/*
 * SonarQube Java
 * Copyright (C) 2012-2024 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Sonar Source-Available License Version 1, as published by SonarSource SA.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Sonar Source-Available License for more details.
 *
 * You should have received a copy of the Sonar Source-Available License
 * along with this program; if not, see https://sonarsource.com/license/ssal/
 */
package org.sonar.java.checks.naming;

import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key = "S1190")
public class KeywordAsIdentifierCheck extends BaseTreeVisitor implements JavaFileScanner {

  private JavaFileScannerContext context;

  private static final String FORBIDDEN_IDENTIFIER = "_";

  @Override
  public void scanFile(JavaFileScannerContext context) {
    this.context = context;
    scan(context.getTree());
  }

  @Override
  public void visitVariable(VariableTree tree) {
    IdentifierTree simpleName = tree.simpleName();
    if (!simpleName.isUnnamedVariable() && FORBIDDEN_IDENTIFIER.equals(simpleName.name())) {
      context.reportIssue(this, simpleName, "Use a different name than \"" + simpleName.name() + "\".");
    }
    super.visitVariable(tree);
  }

}
