package checks;

import java.util.*;

class S1874_CallToDeprecatedMethod {

  public S1874_CallToDeprecatedMethod() {
    String string = new String("my string");
    string.getBytes(1, 1, new byte[3], 7); // Noncompliant {{Remove this use of "getBytes"; it is deprecated.}}
//         ^^^^^^^^
    new DeprecatedConstructor(); // Noncompliant {{Remove this use of "DeprecatedConstructor"; it is deprecated.}}
//      ^^^^^^^^^^^^^^^^^^^^^
    new MyDeprecatedClass(); // Noncompliant
    old++; // Noncompliant
    MyDeprecatedClass.a++; // Noncompliant
  }

  void useDeprecatedEum(Object o) {
    useDeprecatedEum(DeprecatedEnum // Noncompliant
      .A); // Noncompliant
    useDeprecatedEum(DeprecatedEnum // Noncompliant
      .B); // Noncompliant
    useDeprecatedEum(PartiallyDeprecatedEnum.C);
    useDeprecatedEum(PartiallyDeprecatedEnum.D); // Noncompliant
  }

  @Deprecated
  int old;

  @Deprecated
  private static class MyDeprecatedClass {
    static int a;
  }

  public static class ExtendsDeprecatedClass extends MyDeprecatedClass { // Noncompliant {{Remove this use of "MyDeprecatedClass"; it is deprecated.}}
//                                                   ^^^^^^^^^^^^^^^^^
  }

  public static abstract class ClassWithDeprecatedMethods {
    @Deprecated
    public void deprecatedMethod1() {
    }
    @Deprecated
    public void deprecatedMethod2() {
    }
    @Deprecated
    public abstract void deprecatedMethod3();
  }

  public interface InterfaceWithDeprecatedMethods {
    @Deprecated
    public void deprecatedMethod4();
  }

  public static class ClassOverridingDeprecatedMethods extends ClassWithDeprecatedMethods implements InterfaceWithDeprecatedMethods {
    public void deprecatedMethod1() { // Noncompliant {{Don't override a deprecated method or explicitly mark it as "@Deprecated".}}
//              ^^^^^^^^^^^^^^^^^
    }
    @Deprecated
    public void deprecatedMethod2() { // Compliant, explicitely marked as "@Deprecated"
    }
    public void deprecatedMethod3() { // Compliant, override abstract method
    }
    public void deprecatedMethod4() { // Compliant, override interface
    }
  }

  private static class DeprecatedConstructor {
    @Deprecated
    public DeprecatedConstructor() {
      "".getBytes(1, 1, new byte[3], 7);
    }
    String a  = new String(new byte[3], 7); // Noncompliant
  }

  @Deprecated
  class A {
    Object a = new DeprecatedConstructor();
  }

  class B {
    @Deprecated
    void foo() {
      Object a = new DeprecatedConstructor();
      "".getBytes(1, 1, new byte[3], 7);
    }
  }

  class Foo {
    @Deprecated
    public Foo() { }
    public Foo(String s) { }
  }

  class Bar extends Foo {
    public Bar() { // Compliant
      super("");
    }
  }
}

@Deprecated
enum DeprecatedEnum {
  A,
  B;
}

enum PartiallyDeprecatedEnum {
  C,
  @Deprecated D;
}

class MyCustomClass {
  @Deprecated
  MyDeprecatedType myVar;
}

@Deprecated
class MyDeprecatedType {
  // some stuff
}

class MethodResolution {
  public static void test() {
    HasDeprecations.method(new ArrayList<>());
    HasDeprecations.method(new HashMap<>()); // Noncompliant {{Remove this use of "method"; it is deprecated.}}
//                  ^^^^^^
  }

  static class HasDeprecations {
    @Deprecated
    public static void method(final Map<String, String> m) { }
    public static void method(final List<String> l) { }
  }
}
