/*
 * SonarSource :: .NET :: Core
 * Copyright (C) 2014-2024 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Sonar Source-Available License Version 1, as published by SonarSource SA.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Sonar Source-Available License for more details.
 *
 * You should have received a copy of the Sonar Source-Available License
 * along with this program; if not, see https://sonarsource.com/license/ssal/
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer.LogInfo;

/*
 * This class is responsible of reading log messages generated by the C#/VB.NET analyzer.
 */
public class LogImporter extends RawProtobufImporter<LogInfo> {

  private static final Logger LOG = LoggerFactory.getLogger(LogImporter.class);
  private List<LogInfo> messages = new ArrayList<>();

  public LogImporter() {
    super(SonarAnalyzer.LogInfo.parser());
  }

  @Override
  void consume(LogInfo message) {
    messages.add(message);
  }

  @Override
  public void save() {
    for (LogInfo message : messages) {
      switch (message.getSeverity()) {
        case DEBUG:
          LOG.debug(message.getText());
          break;

        case INFO:
          LOG.info(message.getText());
          break;

        case WARNING:
          LOG.warn(message.getText());
          break;

        case UNKNOWN_SEVERITY:
        default:
          LOG.warn("Unexpected log message severity: {}", message.getSeverity());
          LOG.info(message.getText());
      }
    }

    messages.clear();
  }
}
