# Issue tracking

All issues for C# and VB.NET code should be reported via our [Community Forum](https://community.sonarsource.com/c/clean-code/fp/7).

You're welcome to submit any issue that you've found using the C# and VB.NET code analyzers in:

* [SonarQube cloud](https://www.sonarsource.com/products/sonarcloud/)
* [SonarQube server](https://www.sonarsource.com/products/sonarqube/)
* [SonarQube for IDE](https://www.sonarsource.com/products/sonarlint/)
* [SonarAnalyzer.CSharp NuGet package](https://www.nuget.org/packages/SonarAnalyzer.CSharp/)
* [SonarAnalyzer.VisualBasic Nuget package](https://www.nuget.org/packages/SonarAnalyzer.VisualBasic/)

Please report all exceptions thrown from analyzer as well as False-Positive and False-Negative behavior. Try to provide a minimal reproducible example for each case.

You can ask for help, request new rule or feature on [Community Forum](https://community.sonarsource.com/).

## Labels

Labels are divided into several categories. One issue can have:

* multiple labels from Area category,
* only one label from Status category,
* only one label from Type category.

## Implicit rules

* Any issue without labels needs review.
* Every issue containing labels is confirmed.
* Issues marked as `Status: On Hold` are treated case by case. Reference timeout is 3 months without reply.