﻿using System.Runtime.InteropServices;

interface IMyInterface
{
    static virtual void StaticVirtualMethod() // Compliant (empty virtual method)
    {

    }

    static abstract void StaticAbstractMethod();
}

class MyClass : IMyInterface
{
    public static void StaticVirtualMethod() { } // Compliant

    public static void StaticAbstractMethod() { } // Compliant
}

public unsafe partial class Externals
{
    [LibraryImport("ole32.dll")]
    private static partial void F();  // Compliant

    // Code usually generated by the source generator:
    [System.Runtime.InteropServices.DllImportAttribute("ole32.dll", EntryPoint = "F", ExactSpelling = true)]
    private static extern partial void F(); // Compliant
}

abstract class WithModifiers
{
    public unsafe required int X { set { } }              // Noncompliant
    public virtual int Y { get => 42;  private set { } }  // Noncompliant
    public abstract int Z { get; private protected set; } // Compliant: no body
}

public struct S
{
    public S() // Compliant - This will replace the default constructor
    {
    }
}

public partial class PartialProperty
{
    public partial int Property_01 { set; } 
}

public partial class PartialProperty
{
    public partial int Property_01 { set { } } // Noncompliant
}
