﻿/*
 * SonarAnalyzer for .NET
 * Copyright (C) 2014-2024 SonarSource SA
 * mailto:info AT sonarsource DOT com
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Sonar Source-Available License Version 1, as published by SonarSource SA.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Sonar Source-Available License for more details.
 *
 * You should have received a copy of the Sonar Source-Available License
 * along with this program; if not, see https://sonarsource.com/license/ssal/
 */

using SonarAnalyzer.Core.Trackers;

namespace SonarAnalyzer.Rules.CSharp
{
    [DiagnosticAnalyzer(LanguageNames.CSharp)]
    public sealed class DoNotCallAssemblyLoadInvalidMethods : DoNotCallMethodsCSharpBase
    {
        private const string DiagnosticId = "S3885";

        protected override string MessageFormat => "Replace this call to '{0}' with 'Assembly.Load'.";

        protected override IEnumerable<MemberDescriptor> CheckedMethods { get; } = new List<MemberDescriptor>
        {
            new(KnownType.System_Reflection_Assembly, "LoadFrom"),
            new(KnownType.System_Reflection_Assembly, "LoadFile"),
            new(KnownType.System_Reflection_Assembly, "LoadWithPartialName")
        };

        public DoNotCallAssemblyLoadInvalidMethods() : base(DiagnosticId) { }
    }
}
