module.exports = {
  parser: '@typescript-eslint/parser',
  plugins: ['@typescript-eslint', 'mocha'],
  env: {
    es6: true,
    node: true,
    mocha: true,
  },
  extends: ['airbnb', 'plugin:@typescript-eslint/recommended', 'plugin:mocha/recommended', 'plugin:import/typescript'],
  parserOptions: {
    ecmaVersion: 2020,
    sourceType: 'module',
  },
  rules: {
    'react/jsx-filename-extension': 'off',
    '@typescript-eslint/no-explicit-any': 'off',
    indent: ['error', 2],
    '@typescript-eslint/explicit-function-return-type': 'off',
    '@typescript-eslint/no-non-null-assertion': 'off',
    '@typescript-eslint/ban-ts-ignore': 'off',
    'import/prefer-default-export': 'off',
    'linebreak-style': ['error', 'unix'],
    quotes: ['error', 'single'],
    semi: ['error', 'never'],
    'import/no-unresolved': 'off',
    'func-names': 'off',
    'no-underscore-dangle': 'off',
    'guard-for-in': 'off',
    'no-restricted-syntax': 'off',
    'no-await-in-loop': 'off',
    'object-curly-newline': 'off',
    'import/extensions': [2, 'ignorePackages'],
    'mocha/no-hooks-for-single-case': 'off',
    'no-param-reassign': 'off',
    'default-param-last': 'off',
    'no-use-before-define': 'off',
    'no-restricted-exports': 'off',
    'react/require-default-props': 'off',
    'react/jsx-props-no-spreading': 'off',
    'react/function-component-definition': 'off',
    'max-classes-per-file': 'off',
    '@typescript-eslint/ban-ts-comment': 'off',
    'import/no-import-module-exports': 'off',
  },
  ignorePatterns: [
    '*/build/**/*',
    '*.json',
    '*.txt',
    '*.md',
    '*.lock',
    '*.log',
    '*.yaml',
    '**/*/frontend/assets/**/*',
    '*.d.ts',
    '*.config.js',
  ],
  overrides: [
    {
      files: ['*-test.js', '*.spec.js', '*-test.ts', '*.spec.ts', '*.spec.tsx', '*.factory.ts', '*.factory.js'],
      rules: {
        'no-unused-expressions': 'off',
        'func-names': 'off',
        'prefer-arrow-callback': 'off',
        'import/no-extraneous-dependencies': 'off',
        'mocha/no-mocha-arrows': 'off',
        '@typescript-eslint/explicit-function-return-type': 'off',
      },
    },
    {
      files: ['*.jsx', '*.js'],
      rules: {
        '@typescript-eslint/explicit-function-return-type': 'off',
      },
    },
    {
      files: ['*.cjs'],
      rules: {
        'import/no-commonjs': 'off',
      },
    },
    {
      files: ['*.tsx'],
      rules: {
        'react/prop-types': 'off',
        'react/function-component-definition': 'off',
      },
    },
    {
      files: ['**/*/cypress/integration/**/*.spec.js', './cy/**/*.js'],
      rules: {
        'mocha/no-mocha-arrows': 'off',
        'spaced-comment': 'off',
      },
    },
  ],
  settings: {
    'import/resolver': {
      node: {
        extensions: ['.js', '.jsx', '.ts', '.tsx'],
      },
    },
  },
  globals: {
    expect: true,
    factory: true,
    sandbox: true,
    server: true,
    window: true,
    AdminJS: true,
    flatpickr: true,
    FormData: true,
    File: true,
    cy: true,
    Cypress: true,
  },
}
