﻿// Copyright (c) 2020-2024 Jonathan Wood (www.softcircuits.com)
// Licensed under the MIT license.
//

namespace SoftCircuits.FullTextSearchQuery
{
    internal static class StandardStopWords
    {
        /// <summary>
        /// Standard list of stop words.
        /// </summary>
        /// <remarks>
        /// <para>
        /// It is critical that full-text search queries omit stop words or else
        /// terms joined using "AND" that contain a stop word will produce no
        /// results.
        /// </para>
        /// <para>
        /// The exact list of stop words can vary. To get the system stop words
        /// from the current database, use the following query. As seen in the
        /// query, the list is filtered to include only English stop words.
        /// </para>
        /// <code>
        /// SELECT ssw.stopword, slg.name
        /// FROM sys.fulltext_system_stopwords ssw
        /// JOIN sys.fulltext_languages slg
        /// ON slg.lcid = ssw.language_id
        /// WHERE slg.lcid = 1033
        /// </code>
        /// </remarks>
        public static string[] StopWords =
        [
            "$",
            "0",
            "1",
            "2",
            "3",
            "4",
            "5",
            "6",
            "7",
            "8",
            "9",
            "A",
            "B",
            "C",
            "D",
            "E",
            "F",
            "G",
            "H",
            "I",
            "J",
            "K",
            "L",
            "M",
            "N",
            "O",
            "P",
            "Q",
            "R",
            "S",
            "T",
            "U",
            "V",
            "W",
            "X",
            "Y",
            "Z",
            "about",
            "after",
            "all",
            "also",
            "an",
            "and",
            "another",
            "any",
            "are",
            "as",
            "at",
            "be",
            "because",
            "been",
            "before",
            "being",
            "between",
            "both",
            "but",
            "by",
            "came",
            "can",
            "come",
            "could",
            "did",
            "do",
            "does",
            "each",
            "else",
            "for",
            "from",
            "get",
            "got",
            "had",
            "has",
            "have",
            "he",
            "her",
            "here",
            "him",
            "himself",
            "his",
            "how",
            "if",
            "in",
            "into",
            "is",
            "it",
            "its",
            "just",
            "like",
            "make",
            "many",
            "me",
            "might",
            "more",
            "most",
            "much",
            "must",
            "my",
            "never",
            "no",
            "now",
            "of",
            "on",
            "only",
            "or",
            "other",
            "our",
            "out",
            "over",
            "re",
            "said",
            "same",
            "see",
            "should",
            "since",
            "so",
            "some",
            "still",
            "such",
            "take",
            "than",
            "that",
            "the",
            "their",
            "them",
            "then",
            "there",
            "these",
            "they",
            "this",
            "those",
            "through",
            "to",
            "too",
            "under",
            "up",
            "use",
            "very",
            "want",
            "was",
            "way",
            "we",
            "well",
            "were",
            "what",
            "when",
            "where",
            "which",
            "while",
            "who",
            "will",
            "with",
            "would",
            "you",
            "your",
        ];
    }
}
