package config

// Code generated by github.com/tinylib/msgp DO NOT EDIT.

import (
	"github.com/tinylib/msgp/msgp"
)

// DecodeMsg implements msgp.Decodable
func (z *AppConfiguration) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "api_version":
			z.APIVersion, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "APIVersion")
				return
			}
		case "clients":
			var zb0002 uint32
			zb0002, err = dc.ReadArrayHeader()
			if err != nil {
				err = msgp.WrapError(err, "Clients")
				return
			}
			if cap(z.Clients) >= int(zb0002) {
				z.Clients = (z.Clients)[:zb0002]
			} else {
				z.Clients = make([]OAuthClientConfiguration, zb0002)
			}
			for za0001 := range z.Clients {
				var zb0003 uint32
				zb0003, err = dc.ReadMapHeader()
				if err != nil {
					err = msgp.WrapError(err, "Clients", za0001)
					return
				}
				if z.Clients[za0001] == nil {
					z.Clients[za0001] = make(OAuthClientConfiguration, zb0003)
				} else if len(z.Clients[za0001]) > 0 {
					for key := range z.Clients[za0001] {
						delete(z.Clients[za0001], key)
					}
				}
				for zb0003 > 0 {
					zb0003--
					var za0002 string
					var za0003 interface{}
					za0002, err = dc.ReadString()
					if err != nil {
						err = msgp.WrapError(err, "Clients", za0001)
						return
					}
					za0003, err = dc.ReadIntf()
					if err != nil {
						err = msgp.WrapError(err, "Clients", za0001, za0002)
						return
					}
					z.Clients[za0001][za0002] = za0003
				}
			}
		case "master_key":
			z.MasterKey, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "MasterKey")
				return
			}
		case "session":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "Session")
					return
				}
				z.Session = nil
			} else {
				if z.Session == nil {
					z.Session = new(SessionConfiguration)
				}
				err = z.Session.DecodeMsg(dc)
				if err != nil {
					err = msgp.WrapError(err, "Session")
					return
				}
			}
		case "cors":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "CORS")
					return
				}
				z.CORS = nil
			} else {
				if z.CORS == nil {
					z.CORS = new(CORSConfiguration)
				}
				var zb0004 uint32
				zb0004, err = dc.ReadMapHeader()
				if err != nil {
					err = msgp.WrapError(err, "CORS")
					return
				}
				for zb0004 > 0 {
					zb0004--
					field, err = dc.ReadMapKeyPtr()
					if err != nil {
						err = msgp.WrapError(err, "CORS")
						return
					}
					switch msgp.UnsafeString(field) {
					case "origin":
						z.CORS.Origin, err = dc.ReadString()
						if err != nil {
							err = msgp.WrapError(err, "CORS", "Origin")
							return
						}
					default:
						err = dc.Skip()
						if err != nil {
							err = msgp.WrapError(err, "CORS")
							return
						}
					}
				}
			}
		case "authentication":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "Authentication")
					return
				}
				z.Authentication = nil
			} else {
				if z.Authentication == nil {
					z.Authentication = new(AuthenticationConfiguration)
				}
				err = z.Authentication.DecodeMsg(dc)
				if err != nil {
					err = msgp.WrapError(err, "Authentication")
					return
				}
			}
		case "auth_ui":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "AuthUI")
					return
				}
				z.AuthUI = nil
			} else {
				if z.AuthUI == nil {
					z.AuthUI = new(AuthUIConfiguration)
				}
				err = z.AuthUI.DecodeMsg(dc)
				if err != nil {
					err = msgp.WrapError(err, "AuthUI")
					return
				}
			}
		case "oidc":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "OIDC")
					return
				}
				z.OIDC = nil
			} else {
				if z.OIDC == nil {
					z.OIDC = new(OIDCConfiguration)
				}
				err = z.OIDC.DecodeMsg(dc)
				if err != nil {
					err = msgp.WrapError(err, "OIDC")
					return
				}
			}
		case "authenticator":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "Authenticator")
					return
				}
				z.Authenticator = nil
			} else {
				if z.Authenticator == nil {
					z.Authenticator = new(AuthenticatorConfiguration)
				}
				err = z.Authenticator.DecodeMsg(dc)
				if err != nil {
					err = msgp.WrapError(err, "Authenticator")
					return
				}
			}
		case "forgot_password":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "ForgotPassword")
					return
				}
				z.ForgotPassword = nil
			} else {
				if z.ForgotPassword == nil {
					z.ForgotPassword = new(ForgotPasswordConfiguration)
				}
				var zb0005 uint32
				zb0005, err = dc.ReadMapHeader()
				if err != nil {
					err = msgp.WrapError(err, "ForgotPassword")
					return
				}
				for zb0005 > 0 {
					zb0005--
					field, err = dc.ReadMapKeyPtr()
					if err != nil {
						err = msgp.WrapError(err, "ForgotPassword")
						return
					}
					switch msgp.UnsafeString(field) {
					case "email_message":
						err = z.ForgotPassword.EmailMessage.DecodeMsg(dc)
						if err != nil {
							err = msgp.WrapError(err, "ForgotPassword", "EmailMessage")
							return
						}
					case "sms_message":
						err = z.ForgotPassword.SMSMessage.DecodeMsg(dc)
						if err != nil {
							err = msgp.WrapError(err, "ForgotPassword", "SMSMessage")
							return
						}
					case "reset_code_lifetime":
						z.ForgotPassword.ResetCodeLifetime, err = dc.ReadInt()
						if err != nil {
							err = msgp.WrapError(err, "ForgotPassword", "ResetCodeLifetime")
							return
						}
					default:
						err = dc.Skip()
						if err != nil {
							err = msgp.WrapError(err, "ForgotPassword")
							return
						}
					}
				}
			}
		case "welcome_message":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "WelcomeMessage")
					return
				}
				z.WelcomeMessage = nil
			} else {
				if z.WelcomeMessage == nil {
					z.WelcomeMessage = new(WelcomeMessageConfiguration)
				}
				err = z.WelcomeMessage.DecodeMsg(dc)
				if err != nil {
					err = msgp.WrapError(err, "WelcomeMessage")
					return
				}
			}
		case "identity":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "Identity")
					return
				}
				z.Identity = nil
			} else {
				if z.Identity == nil {
					z.Identity = new(IdentityConfiguration)
				}
				err = z.Identity.DecodeMsg(dc)
				if err != nil {
					err = msgp.WrapError(err, "Identity")
					return
				}
			}
		case "user_verification":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "UserVerification")
					return
				}
				z.UserVerification = nil
			} else {
				if z.UserVerification == nil {
					z.UserVerification = new(UserVerificationConfiguration)
				}
				err = z.UserVerification.DecodeMsg(dc)
				if err != nil {
					err = msgp.WrapError(err, "UserVerification")
					return
				}
			}
		case "hook":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "Hook")
					return
				}
				z.Hook = nil
			} else {
				if z.Hook == nil {
					z.Hook = new(HookAppConfiguration)
				}
				var zb0006 uint32
				zb0006, err = dc.ReadMapHeader()
				if err != nil {
					err = msgp.WrapError(err, "Hook")
					return
				}
				for zb0006 > 0 {
					zb0006--
					field, err = dc.ReadMapKeyPtr()
					if err != nil {
						err = msgp.WrapError(err, "Hook")
						return
					}
					switch msgp.UnsafeString(field) {
					case "secret":
						z.Hook.Secret, err = dc.ReadString()
						if err != nil {
							err = msgp.WrapError(err, "Hook", "Secret")
							return
						}
					default:
						err = dc.Skip()
						if err != nil {
							err = msgp.WrapError(err, "Hook")
							return
						}
					}
				}
			}
		case "messages":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "Messages")
					return
				}
				z.Messages = nil
			} else {
				if z.Messages == nil {
					z.Messages = new(MessagesConfiguration)
				}
				err = z.Messages.DecodeMsg(dc)
				if err != nil {
					err = msgp.WrapError(err, "Messages")
					return
				}
			}
		case "smtp":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "SMTP")
					return
				}
				z.SMTP = nil
			} else {
				if z.SMTP == nil {
					z.SMTP = new(SMTPConfiguration)
				}
				err = z.SMTP.DecodeMsg(dc)
				if err != nil {
					err = msgp.WrapError(err, "SMTP")
					return
				}
			}
		case "twilio":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "Twilio")
					return
				}
				z.Twilio = nil
			} else {
				if z.Twilio == nil {
					z.Twilio = new(TwilioConfiguration)
				}
				var zb0007 uint32
				zb0007, err = dc.ReadMapHeader()
				if err != nil {
					err = msgp.WrapError(err, "Twilio")
					return
				}
				for zb0007 > 0 {
					zb0007--
					field, err = dc.ReadMapKeyPtr()
					if err != nil {
						err = msgp.WrapError(err, "Twilio")
						return
					}
					switch msgp.UnsafeString(field) {
					case "account_sid":
						z.Twilio.AccountSID, err = dc.ReadString()
						if err != nil {
							err = msgp.WrapError(err, "Twilio", "AccountSID")
							return
						}
					case "auth_token":
						z.Twilio.AuthToken, err = dc.ReadString()
						if err != nil {
							err = msgp.WrapError(err, "Twilio", "AuthToken")
							return
						}
					default:
						err = dc.Skip()
						if err != nil {
							err = msgp.WrapError(err, "Twilio")
							return
						}
					}
				}
			}
		case "nexmo":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "Nexmo")
					return
				}
				z.Nexmo = nil
			} else {
				if z.Nexmo == nil {
					z.Nexmo = new(NexmoConfiguration)
				}
				var zb0008 uint32
				zb0008, err = dc.ReadMapHeader()
				if err != nil {
					err = msgp.WrapError(err, "Nexmo")
					return
				}
				for zb0008 > 0 {
					zb0008--
					field, err = dc.ReadMapKeyPtr()
					if err != nil {
						err = msgp.WrapError(err, "Nexmo")
						return
					}
					switch msgp.UnsafeString(field) {
					case "api_key":
						z.Nexmo.APIKey, err = dc.ReadString()
						if err != nil {
							err = msgp.WrapError(err, "Nexmo", "APIKey")
							return
						}
					case "api_secret":
						z.Nexmo.APISecret, err = dc.ReadString()
						if err != nil {
							err = msgp.WrapError(err, "Nexmo", "APISecret")
							return
						}
					default:
						err = dc.Skip()
						if err != nil {
							err = msgp.WrapError(err, "Nexmo")
							return
						}
					}
				}
			}
		case "localization":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "Localization")
					return
				}
				z.Localization = nil
			} else {
				if z.Localization == nil {
					z.Localization = new(LocalizationConfiguration)
				}
				err = z.Localization.DecodeMsg(dc)
				if err != nil {
					err = msgp.WrapError(err, "Localization")
					return
				}
			}
		case "asset":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "Asset")
					return
				}
				z.Asset = nil
			} else {
				if z.Asset == nil {
					z.Asset = new(AssetConfiguration)
				}
				var zb0009 uint32
				zb0009, err = dc.ReadMapHeader()
				if err != nil {
					err = msgp.WrapError(err, "Asset")
					return
				}
				for zb0009 > 0 {
					zb0009--
					field, err = dc.ReadMapKeyPtr()
					if err != nil {
						err = msgp.WrapError(err, "Asset")
						return
					}
					switch msgp.UnsafeString(field) {
					case "secret":
						z.Asset.Secret, err = dc.ReadString()
						if err != nil {
							err = msgp.WrapError(err, "Asset", "Secret")
							return
						}
					default:
						err = dc.Skip()
						if err != nil {
							err = msgp.WrapError(err, "Asset")
							return
						}
					}
				}
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *AppConfiguration) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 20
	// write "api_version"
	err = en.Append(0xde, 0x0, 0x14, 0xab, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e)
	if err != nil {
		return
	}
	err = en.WriteString(z.APIVersion)
	if err != nil {
		err = msgp.WrapError(err, "APIVersion")
		return
	}
	// write "clients"
	err = en.Append(0xa7, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73)
	if err != nil {
		return
	}
	err = en.WriteArrayHeader(uint32(len(z.Clients)))
	if err != nil {
		err = msgp.WrapError(err, "Clients")
		return
	}
	for za0001 := range z.Clients {
		err = en.WriteMapHeader(uint32(len(z.Clients[za0001])))
		if err != nil {
			err = msgp.WrapError(err, "Clients", za0001)
			return
		}
		for za0002, za0003 := range z.Clients[za0001] {
			err = en.WriteString(za0002)
			if err != nil {
				err = msgp.WrapError(err, "Clients", za0001)
				return
			}
			err = en.WriteIntf(za0003)
			if err != nil {
				err = msgp.WrapError(err, "Clients", za0001, za0002)
				return
			}
		}
	}
	// write "master_key"
	err = en.Append(0xaa, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6b, 0x65, 0x79)
	if err != nil {
		return
	}
	err = en.WriteString(z.MasterKey)
	if err != nil {
		err = msgp.WrapError(err, "MasterKey")
		return
	}
	// write "session"
	err = en.Append(0xa7, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e)
	if err != nil {
		return
	}
	if z.Session == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		err = z.Session.EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "Session")
			return
		}
	}
	// write "cors"
	err = en.Append(0xa4, 0x63, 0x6f, 0x72, 0x73)
	if err != nil {
		return
	}
	if z.CORS == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		// map header, size 1
		// write "origin"
		err = en.Append(0x81, 0xa6, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e)
		if err != nil {
			return
		}
		err = en.WriteString(z.CORS.Origin)
		if err != nil {
			err = msgp.WrapError(err, "CORS", "Origin")
			return
		}
	}
	// write "authentication"
	err = en.Append(0xae, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e)
	if err != nil {
		return
	}
	if z.Authentication == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		err = z.Authentication.EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "Authentication")
			return
		}
	}
	// write "auth_ui"
	err = en.Append(0xa7, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x75, 0x69)
	if err != nil {
		return
	}
	if z.AuthUI == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		err = z.AuthUI.EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "AuthUI")
			return
		}
	}
	// write "oidc"
	err = en.Append(0xa4, 0x6f, 0x69, 0x64, 0x63)
	if err != nil {
		return
	}
	if z.OIDC == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		err = z.OIDC.EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "OIDC")
			return
		}
	}
	// write "authenticator"
	err = en.Append(0xad, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x6f, 0x72)
	if err != nil {
		return
	}
	if z.Authenticator == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		err = z.Authenticator.EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "Authenticator")
			return
		}
	}
	// write "forgot_password"
	err = en.Append(0xaf, 0x66, 0x6f, 0x72, 0x67, 0x6f, 0x74, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64)
	if err != nil {
		return
	}
	if z.ForgotPassword == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		// map header, size 3
		// write "email_message"
		err = en.Append(0x83, 0xad, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65)
		if err != nil {
			return
		}
		err = z.ForgotPassword.EmailMessage.EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "ForgotPassword", "EmailMessage")
			return
		}
		// write "sms_message"
		err = en.Append(0xab, 0x73, 0x6d, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65)
		if err != nil {
			return
		}
		err = z.ForgotPassword.SMSMessage.EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "ForgotPassword", "SMSMessage")
			return
		}
		// write "reset_code_lifetime"
		err = en.Append(0xb3, 0x72, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65)
		if err != nil {
			return
		}
		err = en.WriteInt(z.ForgotPassword.ResetCodeLifetime)
		if err != nil {
			err = msgp.WrapError(err, "ForgotPassword", "ResetCodeLifetime")
			return
		}
	}
	// write "welcome_message"
	err = en.Append(0xaf, 0x77, 0x65, 0x6c, 0x63, 0x6f, 0x6d, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65)
	if err != nil {
		return
	}
	if z.WelcomeMessage == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		err = z.WelcomeMessage.EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "WelcomeMessage")
			return
		}
	}
	// write "identity"
	err = en.Append(0xa8, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79)
	if err != nil {
		return
	}
	if z.Identity == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		err = z.Identity.EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "Identity")
			return
		}
	}
	// write "user_verification"
	err = en.Append(0xb1, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e)
	if err != nil {
		return
	}
	if z.UserVerification == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		err = z.UserVerification.EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "UserVerification")
			return
		}
	}
	// write "hook"
	err = en.Append(0xa4, 0x68, 0x6f, 0x6f, 0x6b)
	if err != nil {
		return
	}
	if z.Hook == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		// map header, size 1
		// write "secret"
		err = en.Append(0x81, 0xa6, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74)
		if err != nil {
			return
		}
		err = en.WriteString(z.Hook.Secret)
		if err != nil {
			err = msgp.WrapError(err, "Hook", "Secret")
			return
		}
	}
	// write "messages"
	err = en.Append(0xa8, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73)
	if err != nil {
		return
	}
	if z.Messages == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		err = z.Messages.EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "Messages")
			return
		}
	}
	// write "smtp"
	err = en.Append(0xa4, 0x73, 0x6d, 0x74, 0x70)
	if err != nil {
		return
	}
	if z.SMTP == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		err = z.SMTP.EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "SMTP")
			return
		}
	}
	// write "twilio"
	err = en.Append(0xa6, 0x74, 0x77, 0x69, 0x6c, 0x69, 0x6f)
	if err != nil {
		return
	}
	if z.Twilio == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		// map header, size 2
		// write "account_sid"
		err = en.Append(0x82, 0xab, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x73, 0x69, 0x64)
		if err != nil {
			return
		}
		err = en.WriteString(z.Twilio.AccountSID)
		if err != nil {
			err = msgp.WrapError(err, "Twilio", "AccountSID")
			return
		}
		// write "auth_token"
		err = en.Append(0xaa, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e)
		if err != nil {
			return
		}
		err = en.WriteString(z.Twilio.AuthToken)
		if err != nil {
			err = msgp.WrapError(err, "Twilio", "AuthToken")
			return
		}
	}
	// write "nexmo"
	err = en.Append(0xa5, 0x6e, 0x65, 0x78, 0x6d, 0x6f)
	if err != nil {
		return
	}
	if z.Nexmo == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		// map header, size 2
		// write "api_key"
		err = en.Append(0x82, 0xa7, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79)
		if err != nil {
			return
		}
		err = en.WriteString(z.Nexmo.APIKey)
		if err != nil {
			err = msgp.WrapError(err, "Nexmo", "APIKey")
			return
		}
		// write "api_secret"
		err = en.Append(0xaa, 0x61, 0x70, 0x69, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74)
		if err != nil {
			return
		}
		err = en.WriteString(z.Nexmo.APISecret)
		if err != nil {
			err = msgp.WrapError(err, "Nexmo", "APISecret")
			return
		}
	}
	// write "localization"
	err = en.Append(0xac, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e)
	if err != nil {
		return
	}
	if z.Localization == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		err = z.Localization.EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "Localization")
			return
		}
	}
	// write "asset"
	err = en.Append(0xa5, 0x61, 0x73, 0x73, 0x65, 0x74)
	if err != nil {
		return
	}
	if z.Asset == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		// map header, size 1
		// write "secret"
		err = en.Append(0x81, 0xa6, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74)
		if err != nil {
			return
		}
		err = en.WriteString(z.Asset.Secret)
		if err != nil {
			err = msgp.WrapError(err, "Asset", "Secret")
			return
		}
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *AppConfiguration) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 20
	// string "api_version"
	o = append(o, 0xde, 0x0, 0x14, 0xab, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e)
	o = msgp.AppendString(o, z.APIVersion)
	// string "clients"
	o = append(o, 0xa7, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.Clients)))
	for za0001 := range z.Clients {
		o = msgp.AppendMapHeader(o, uint32(len(z.Clients[za0001])))
		for za0002, za0003 := range z.Clients[za0001] {
			o = msgp.AppendString(o, za0002)
			o, err = msgp.AppendIntf(o, za0003)
			if err != nil {
				err = msgp.WrapError(err, "Clients", za0001, za0002)
				return
			}
		}
	}
	// string "master_key"
	o = append(o, 0xaa, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6b, 0x65, 0x79)
	o = msgp.AppendString(o, z.MasterKey)
	// string "session"
	o = append(o, 0xa7, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e)
	if z.Session == nil {
		o = msgp.AppendNil(o)
	} else {
		o, err = z.Session.MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "Session")
			return
		}
	}
	// string "cors"
	o = append(o, 0xa4, 0x63, 0x6f, 0x72, 0x73)
	if z.CORS == nil {
		o = msgp.AppendNil(o)
	} else {
		// map header, size 1
		// string "origin"
		o = append(o, 0x81, 0xa6, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e)
		o = msgp.AppendString(o, z.CORS.Origin)
	}
	// string "authentication"
	o = append(o, 0xae, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e)
	if z.Authentication == nil {
		o = msgp.AppendNil(o)
	} else {
		o, err = z.Authentication.MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "Authentication")
			return
		}
	}
	// string "auth_ui"
	o = append(o, 0xa7, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x75, 0x69)
	if z.AuthUI == nil {
		o = msgp.AppendNil(o)
	} else {
		o, err = z.AuthUI.MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "AuthUI")
			return
		}
	}
	// string "oidc"
	o = append(o, 0xa4, 0x6f, 0x69, 0x64, 0x63)
	if z.OIDC == nil {
		o = msgp.AppendNil(o)
	} else {
		o, err = z.OIDC.MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "OIDC")
			return
		}
	}
	// string "authenticator"
	o = append(o, 0xad, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x6f, 0x72)
	if z.Authenticator == nil {
		o = msgp.AppendNil(o)
	} else {
		o, err = z.Authenticator.MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "Authenticator")
			return
		}
	}
	// string "forgot_password"
	o = append(o, 0xaf, 0x66, 0x6f, 0x72, 0x67, 0x6f, 0x74, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64)
	if z.ForgotPassword == nil {
		o = msgp.AppendNil(o)
	} else {
		// map header, size 3
		// string "email_message"
		o = append(o, 0x83, 0xad, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65)
		o, err = z.ForgotPassword.EmailMessage.MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "ForgotPassword", "EmailMessage")
			return
		}
		// string "sms_message"
		o = append(o, 0xab, 0x73, 0x6d, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65)
		o, err = z.ForgotPassword.SMSMessage.MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "ForgotPassword", "SMSMessage")
			return
		}
		// string "reset_code_lifetime"
		o = append(o, 0xb3, 0x72, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65)
		o = msgp.AppendInt(o, z.ForgotPassword.ResetCodeLifetime)
	}
	// string "welcome_message"
	o = append(o, 0xaf, 0x77, 0x65, 0x6c, 0x63, 0x6f, 0x6d, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65)
	if z.WelcomeMessage == nil {
		o = msgp.AppendNil(o)
	} else {
		o, err = z.WelcomeMessage.MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "WelcomeMessage")
			return
		}
	}
	// string "identity"
	o = append(o, 0xa8, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79)
	if z.Identity == nil {
		o = msgp.AppendNil(o)
	} else {
		o, err = z.Identity.MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "Identity")
			return
		}
	}
	// string "user_verification"
	o = append(o, 0xb1, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e)
	if z.UserVerification == nil {
		o = msgp.AppendNil(o)
	} else {
		o, err = z.UserVerification.MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "UserVerification")
			return
		}
	}
	// string "hook"
	o = append(o, 0xa4, 0x68, 0x6f, 0x6f, 0x6b)
	if z.Hook == nil {
		o = msgp.AppendNil(o)
	} else {
		// map header, size 1
		// string "secret"
		o = append(o, 0x81, 0xa6, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74)
		o = msgp.AppendString(o, z.Hook.Secret)
	}
	// string "messages"
	o = append(o, 0xa8, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73)
	if z.Messages == nil {
		o = msgp.AppendNil(o)
	} else {
		o, err = z.Messages.MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "Messages")
			return
		}
	}
	// string "smtp"
	o = append(o, 0xa4, 0x73, 0x6d, 0x74, 0x70)
	if z.SMTP == nil {
		o = msgp.AppendNil(o)
	} else {
		o, err = z.SMTP.MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "SMTP")
			return
		}
	}
	// string "twilio"
	o = append(o, 0xa6, 0x74, 0x77, 0x69, 0x6c, 0x69, 0x6f)
	if z.Twilio == nil {
		o = msgp.AppendNil(o)
	} else {
		// map header, size 2
		// string "account_sid"
		o = append(o, 0x82, 0xab, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x73, 0x69, 0x64)
		o = msgp.AppendString(o, z.Twilio.AccountSID)
		// string "auth_token"
		o = append(o, 0xaa, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e)
		o = msgp.AppendString(o, z.Twilio.AuthToken)
	}
	// string "nexmo"
	o = append(o, 0xa5, 0x6e, 0x65, 0x78, 0x6d, 0x6f)
	if z.Nexmo == nil {
		o = msgp.AppendNil(o)
	} else {
		// map header, size 2
		// string "api_key"
		o = append(o, 0x82, 0xa7, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79)
		o = msgp.AppendString(o, z.Nexmo.APIKey)
		// string "api_secret"
		o = append(o, 0xaa, 0x61, 0x70, 0x69, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74)
		o = msgp.AppendString(o, z.Nexmo.APISecret)
	}
	// string "localization"
	o = append(o, 0xac, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e)
	if z.Localization == nil {
		o = msgp.AppendNil(o)
	} else {
		o, err = z.Localization.MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "Localization")
			return
		}
	}
	// string "asset"
	o = append(o, 0xa5, 0x61, 0x73, 0x73, 0x65, 0x74)
	if z.Asset == nil {
		o = msgp.AppendNil(o)
	} else {
		// map header, size 1
		// string "secret"
		o = append(o, 0x81, 0xa6, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74)
		o = msgp.AppendString(o, z.Asset.Secret)
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *AppConfiguration) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "api_version":
			z.APIVersion, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "APIVersion")
				return
			}
		case "clients":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Clients")
				return
			}
			if cap(z.Clients) >= int(zb0002) {
				z.Clients = (z.Clients)[:zb0002]
			} else {
				z.Clients = make([]OAuthClientConfiguration, zb0002)
			}
			for za0001 := range z.Clients {
				var zb0003 uint32
				zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Clients", za0001)
					return
				}
				if z.Clients[za0001] == nil {
					z.Clients[za0001] = make(OAuthClientConfiguration, zb0003)
				} else if len(z.Clients[za0001]) > 0 {
					for key := range z.Clients[za0001] {
						delete(z.Clients[za0001], key)
					}
				}
				for zb0003 > 0 {
					var za0002 string
					var za0003 interface{}
					zb0003--
					za0002, bts, err = msgp.ReadStringBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Clients", za0001)
						return
					}
					za0003, bts, err = msgp.ReadIntfBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Clients", za0001, za0002)
						return
					}
					z.Clients[za0001][za0002] = za0003
				}
			}
		case "master_key":
			z.MasterKey, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "MasterKey")
				return
			}
		case "session":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.Session = nil
			} else {
				if z.Session == nil {
					z.Session = new(SessionConfiguration)
				}
				bts, err = z.Session.UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "Session")
					return
				}
			}
		case "cors":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.CORS = nil
			} else {
				if z.CORS == nil {
					z.CORS = new(CORSConfiguration)
				}
				var zb0004 uint32
				zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "CORS")
					return
				}
				for zb0004 > 0 {
					zb0004--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "CORS")
						return
					}
					switch msgp.UnsafeString(field) {
					case "origin":
						z.CORS.Origin, bts, err = msgp.ReadStringBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "CORS", "Origin")
							return
						}
					default:
						bts, err = msgp.Skip(bts)
						if err != nil {
							err = msgp.WrapError(err, "CORS")
							return
						}
					}
				}
			}
		case "authentication":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.Authentication = nil
			} else {
				if z.Authentication == nil {
					z.Authentication = new(AuthenticationConfiguration)
				}
				bts, err = z.Authentication.UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "Authentication")
					return
				}
			}
		case "auth_ui":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.AuthUI = nil
			} else {
				if z.AuthUI == nil {
					z.AuthUI = new(AuthUIConfiguration)
				}
				bts, err = z.AuthUI.UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "AuthUI")
					return
				}
			}
		case "oidc":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.OIDC = nil
			} else {
				if z.OIDC == nil {
					z.OIDC = new(OIDCConfiguration)
				}
				bts, err = z.OIDC.UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "OIDC")
					return
				}
			}
		case "authenticator":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.Authenticator = nil
			} else {
				if z.Authenticator == nil {
					z.Authenticator = new(AuthenticatorConfiguration)
				}
				bts, err = z.Authenticator.UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "Authenticator")
					return
				}
			}
		case "forgot_password":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.ForgotPassword = nil
			} else {
				if z.ForgotPassword == nil {
					z.ForgotPassword = new(ForgotPasswordConfiguration)
				}
				var zb0005 uint32
				zb0005, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "ForgotPassword")
					return
				}
				for zb0005 > 0 {
					zb0005--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "ForgotPassword")
						return
					}
					switch msgp.UnsafeString(field) {
					case "email_message":
						bts, err = z.ForgotPassword.EmailMessage.UnmarshalMsg(bts)
						if err != nil {
							err = msgp.WrapError(err, "ForgotPassword", "EmailMessage")
							return
						}
					case "sms_message":
						bts, err = z.ForgotPassword.SMSMessage.UnmarshalMsg(bts)
						if err != nil {
							err = msgp.WrapError(err, "ForgotPassword", "SMSMessage")
							return
						}
					case "reset_code_lifetime":
						z.ForgotPassword.ResetCodeLifetime, bts, err = msgp.ReadIntBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "ForgotPassword", "ResetCodeLifetime")
							return
						}
					default:
						bts, err = msgp.Skip(bts)
						if err != nil {
							err = msgp.WrapError(err, "ForgotPassword")
							return
						}
					}
				}
			}
		case "welcome_message":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.WelcomeMessage = nil
			} else {
				if z.WelcomeMessage == nil {
					z.WelcomeMessage = new(WelcomeMessageConfiguration)
				}
				bts, err = z.WelcomeMessage.UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "WelcomeMessage")
					return
				}
			}
		case "identity":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.Identity = nil
			} else {
				if z.Identity == nil {
					z.Identity = new(IdentityConfiguration)
				}
				bts, err = z.Identity.UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "Identity")
					return
				}
			}
		case "user_verification":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.UserVerification = nil
			} else {
				if z.UserVerification == nil {
					z.UserVerification = new(UserVerificationConfiguration)
				}
				bts, err = z.UserVerification.UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "UserVerification")
					return
				}
			}
		case "hook":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.Hook = nil
			} else {
				if z.Hook == nil {
					z.Hook = new(HookAppConfiguration)
				}
				var zb0006 uint32
				zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Hook")
					return
				}
				for zb0006 > 0 {
					zb0006--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "Hook")
						return
					}
					switch msgp.UnsafeString(field) {
					case "secret":
						z.Hook.Secret, bts, err = msgp.ReadStringBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Hook", "Secret")
							return
						}
					default:
						bts, err = msgp.Skip(bts)
						if err != nil {
							err = msgp.WrapError(err, "Hook")
							return
						}
					}
				}
			}
		case "messages":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.Messages = nil
			} else {
				if z.Messages == nil {
					z.Messages = new(MessagesConfiguration)
				}
				bts, err = z.Messages.UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "Messages")
					return
				}
			}
		case "smtp":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.SMTP = nil
			} else {
				if z.SMTP == nil {
					z.SMTP = new(SMTPConfiguration)
				}
				bts, err = z.SMTP.UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "SMTP")
					return
				}
			}
		case "twilio":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.Twilio = nil
			} else {
				if z.Twilio == nil {
					z.Twilio = new(TwilioConfiguration)
				}
				var zb0007 uint32
				zb0007, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Twilio")
					return
				}
				for zb0007 > 0 {
					zb0007--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "Twilio")
						return
					}
					switch msgp.UnsafeString(field) {
					case "account_sid":
						z.Twilio.AccountSID, bts, err = msgp.ReadStringBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Twilio", "AccountSID")
							return
						}
					case "auth_token":
						z.Twilio.AuthToken, bts, err = msgp.ReadStringBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Twilio", "AuthToken")
							return
						}
					default:
						bts, err = msgp.Skip(bts)
						if err != nil {
							err = msgp.WrapError(err, "Twilio")
							return
						}
					}
				}
			}
		case "nexmo":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.Nexmo = nil
			} else {
				if z.Nexmo == nil {
					z.Nexmo = new(NexmoConfiguration)
				}
				var zb0008 uint32
				zb0008, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Nexmo")
					return
				}
				for zb0008 > 0 {
					zb0008--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "Nexmo")
						return
					}
					switch msgp.UnsafeString(field) {
					case "api_key":
						z.Nexmo.APIKey, bts, err = msgp.ReadStringBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Nexmo", "APIKey")
							return
						}
					case "api_secret":
						z.Nexmo.APISecret, bts, err = msgp.ReadStringBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Nexmo", "APISecret")
							return
						}
					default:
						bts, err = msgp.Skip(bts)
						if err != nil {
							err = msgp.WrapError(err, "Nexmo")
							return
						}
					}
				}
			}
		case "localization":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.Localization = nil
			} else {
				if z.Localization == nil {
					z.Localization = new(LocalizationConfiguration)
				}
				bts, err = z.Localization.UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "Localization")
					return
				}
			}
		case "asset":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.Asset = nil
			} else {
				if z.Asset == nil {
					z.Asset = new(AssetConfiguration)
				}
				var zb0009 uint32
				zb0009, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Asset")
					return
				}
				for zb0009 > 0 {
					zb0009--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "Asset")
						return
					}
					switch msgp.UnsafeString(field) {
					case "secret":
						z.Asset.Secret, bts, err = msgp.ReadStringBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Asset", "Secret")
							return
						}
					default:
						bts, err = msgp.Skip(bts)
						if err != nil {
							err = msgp.WrapError(err, "Asset")
							return
						}
					}
				}
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *AppConfiguration) Msgsize() (s int) {
	s = 3 + 12 + msgp.StringPrefixSize + len(z.APIVersion) + 8 + msgp.ArrayHeaderSize
	for za0001 := range z.Clients {
		s += msgp.MapHeaderSize
		if z.Clients[za0001] != nil {
			for za0002, za0003 := range z.Clients[za0001] {
				_ = za0003
				s += msgp.StringPrefixSize + len(za0002) + msgp.GuessSize(za0003)
			}
		}
	}
	s += 11 + msgp.StringPrefixSize + len(z.MasterKey) + 8
	if z.Session == nil {
		s += msgp.NilSize
	} else {
		s += z.Session.Msgsize()
	}
	s += 5
	if z.CORS == nil {
		s += msgp.NilSize
	} else {
		s += 1 + 7 + msgp.StringPrefixSize + len(z.CORS.Origin)
	}
	s += 15
	if z.Authentication == nil {
		s += msgp.NilSize
	} else {
		s += z.Authentication.Msgsize()
	}
	s += 8
	if z.AuthUI == nil {
		s += msgp.NilSize
	} else {
		s += z.AuthUI.Msgsize()
	}
	s += 5
	if z.OIDC == nil {
		s += msgp.NilSize
	} else {
		s += z.OIDC.Msgsize()
	}
	s += 14
	if z.Authenticator == nil {
		s += msgp.NilSize
	} else {
		s += z.Authenticator.Msgsize()
	}
	s += 16
	if z.ForgotPassword == nil {
		s += msgp.NilSize
	} else {
		s += 1 + 14 + z.ForgotPassword.EmailMessage.Msgsize() + 12 + z.ForgotPassword.SMSMessage.Msgsize() + 20 + msgp.IntSize
	}
	s += 16
	if z.WelcomeMessage == nil {
		s += msgp.NilSize
	} else {
		s += z.WelcomeMessage.Msgsize()
	}
	s += 9
	if z.Identity == nil {
		s += msgp.NilSize
	} else {
		s += z.Identity.Msgsize()
	}
	s += 18
	if z.UserVerification == nil {
		s += msgp.NilSize
	} else {
		s += z.UserVerification.Msgsize()
	}
	s += 5
	if z.Hook == nil {
		s += msgp.NilSize
	} else {
		s += 1 + 7 + msgp.StringPrefixSize + len(z.Hook.Secret)
	}
	s += 9
	if z.Messages == nil {
		s += msgp.NilSize
	} else {
		s += z.Messages.Msgsize()
	}
	s += 5
	if z.SMTP == nil {
		s += msgp.NilSize
	} else {
		s += z.SMTP.Msgsize()
	}
	s += 7
	if z.Twilio == nil {
		s += msgp.NilSize
	} else {
		s += 1 + 12 + msgp.StringPrefixSize + len(z.Twilio.AccountSID) + 11 + msgp.StringPrefixSize + len(z.Twilio.AuthToken)
	}
	s += 6
	if z.Nexmo == nil {
		s += msgp.NilSize
	} else {
		s += 1 + 8 + msgp.StringPrefixSize + len(z.Nexmo.APIKey) + 11 + msgp.StringPrefixSize + len(z.Nexmo.APISecret)
	}
	s += 13
	if z.Localization == nil {
		s += msgp.NilSize
	} else {
		s += z.Localization.Msgsize()
	}
	s += 6
	if z.Asset == nil {
		s += msgp.NilSize
	} else {
		s += 1 + 7 + msgp.StringPrefixSize + len(z.Asset.Secret)
	}
	return
}

// DecodeMsg implements msgp.Decodable
func (z *AssetConfiguration) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "secret":
			z.Secret, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Secret")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z AssetConfiguration) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 1
	// write "secret"
	err = en.Append(0x81, 0xa6, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74)
	if err != nil {
		return
	}
	err = en.WriteString(z.Secret)
	if err != nil {
		err = msgp.WrapError(err, "Secret")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z AssetConfiguration) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 1
	// string "secret"
	o = append(o, 0x81, 0xa6, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74)
	o = msgp.AppendString(o, z.Secret)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *AssetConfiguration) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "secret":
			z.Secret, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Secret")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z AssetConfiguration) Msgsize() (s int) {
	s = 1 + 7 + msgp.StringPrefixSize + len(z.Secret)
	return
}

// DecodeMsg implements msgp.Decodable
func (z *CORSConfiguration) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "origin":
			z.Origin, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Origin")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z CORSConfiguration) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 1
	// write "origin"
	err = en.Append(0x81, 0xa6, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e)
	if err != nil {
		return
	}
	err = en.WriteString(z.Origin)
	if err != nil {
		err = msgp.WrapError(err, "Origin")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z CORSConfiguration) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 1
	// string "origin"
	o = append(o, 0x81, 0xa6, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e)
	o = msgp.AppendString(o, z.Origin)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *CORSConfiguration) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "origin":
			z.Origin, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Origin")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z CORSConfiguration) Msgsize() (s int) {
	s = 1 + 7 + msgp.StringPrefixSize + len(z.Origin)
	return
}

// DecodeMsg implements msgp.Decodable
func (z *DatabaseConfiguration) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "database_url":
			z.DatabaseURL, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "DatabaseURL")
				return
			}
		case "database_schema":
			z.DatabaseSchema, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "DatabaseSchema")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z DatabaseConfiguration) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 2
	// write "database_url"
	err = en.Append(0x82, 0xac, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x75, 0x72, 0x6c)
	if err != nil {
		return
	}
	err = en.WriteString(z.DatabaseURL)
	if err != nil {
		err = msgp.WrapError(err, "DatabaseURL")
		return
	}
	// write "database_schema"
	err = en.Append(0xaf, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61)
	if err != nil {
		return
	}
	err = en.WriteString(z.DatabaseSchema)
	if err != nil {
		err = msgp.WrapError(err, "DatabaseSchema")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z DatabaseConfiguration) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 2
	// string "database_url"
	o = append(o, 0x82, 0xac, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x75, 0x72, 0x6c)
	o = msgp.AppendString(o, z.DatabaseURL)
	// string "database_schema"
	o = append(o, 0xaf, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61)
	o = msgp.AppendString(o, z.DatabaseSchema)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *DatabaseConfiguration) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "database_url":
			z.DatabaseURL, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DatabaseURL")
				return
			}
		case "database_schema":
			z.DatabaseSchema, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DatabaseSchema")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z DatabaseConfiguration) Msgsize() (s int) {
	s = 1 + 13 + msgp.StringPrefixSize + len(z.DatabaseURL) + 16 + msgp.StringPrefixSize + len(z.DatabaseSchema)
	return
}

// DecodeMsg implements msgp.Decodable
func (z *DeploymentRoute) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "version":
			z.Version, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Version")
				return
			}
		case "path":
			z.Path, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Path")
				return
			}
		case "type":
			z.Type, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Type")
				return
			}
		case "type_config":
			var zb0002 uint32
			zb0002, err = dc.ReadMapHeader()
			if err != nil {
				err = msgp.WrapError(err, "TypeConfig")
				return
			}
			if z.TypeConfig == nil {
				z.TypeConfig = make(map[string]interface{}, zb0002)
			} else if len(z.TypeConfig) > 0 {
				for key := range z.TypeConfig {
					delete(z.TypeConfig, key)
				}
			}
			for zb0002 > 0 {
				zb0002--
				var za0001 string
				var za0002 interface{}
				za0001, err = dc.ReadString()
				if err != nil {
					err = msgp.WrapError(err, "TypeConfig")
					return
				}
				za0002, err = dc.ReadIntf()
				if err != nil {
					err = msgp.WrapError(err, "TypeConfig", za0001)
					return
				}
				z.TypeConfig[za0001] = za0002
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *DeploymentRoute) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 4
	// write "version"
	err = en.Append(0x84, 0xa7, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e)
	if err != nil {
		return
	}
	err = en.WriteString(z.Version)
	if err != nil {
		err = msgp.WrapError(err, "Version")
		return
	}
	// write "path"
	err = en.Append(0xa4, 0x70, 0x61, 0x74, 0x68)
	if err != nil {
		return
	}
	err = en.WriteString(z.Path)
	if err != nil {
		err = msgp.WrapError(err, "Path")
		return
	}
	// write "type"
	err = en.Append(0xa4, 0x74, 0x79, 0x70, 0x65)
	if err != nil {
		return
	}
	err = en.WriteString(z.Type)
	if err != nil {
		err = msgp.WrapError(err, "Type")
		return
	}
	// write "type_config"
	err = en.Append(0xab, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67)
	if err != nil {
		return
	}
	err = en.WriteMapHeader(uint32(len(z.TypeConfig)))
	if err != nil {
		err = msgp.WrapError(err, "TypeConfig")
		return
	}
	for za0001, za0002 := range z.TypeConfig {
		err = en.WriteString(za0001)
		if err != nil {
			err = msgp.WrapError(err, "TypeConfig")
			return
		}
		err = en.WriteIntf(za0002)
		if err != nil {
			err = msgp.WrapError(err, "TypeConfig", za0001)
			return
		}
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *DeploymentRoute) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 4
	// string "version"
	o = append(o, 0x84, 0xa7, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e)
	o = msgp.AppendString(o, z.Version)
	// string "path"
	o = append(o, 0xa4, 0x70, 0x61, 0x74, 0x68)
	o = msgp.AppendString(o, z.Path)
	// string "type"
	o = append(o, 0xa4, 0x74, 0x79, 0x70, 0x65)
	o = msgp.AppendString(o, z.Type)
	// string "type_config"
	o = append(o, 0xab, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67)
	o = msgp.AppendMapHeader(o, uint32(len(z.TypeConfig)))
	for za0001, za0002 := range z.TypeConfig {
		o = msgp.AppendString(o, za0001)
		o, err = msgp.AppendIntf(o, za0002)
		if err != nil {
			err = msgp.WrapError(err, "TypeConfig", za0001)
			return
		}
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *DeploymentRoute) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "version":
			z.Version, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Version")
				return
			}
		case "path":
			z.Path, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Path")
				return
			}
		case "type":
			z.Type, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Type")
				return
			}
		case "type_config":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "TypeConfig")
				return
			}
			if z.TypeConfig == nil {
				z.TypeConfig = make(map[string]interface{}, zb0002)
			} else if len(z.TypeConfig) > 0 {
				for key := range z.TypeConfig {
					delete(z.TypeConfig, key)
				}
			}
			for zb0002 > 0 {
				var za0001 string
				var za0002 interface{}
				zb0002--
				za0001, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TypeConfig")
					return
				}
				za0002, bts, err = msgp.ReadIntfBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TypeConfig", za0001)
					return
				}
				z.TypeConfig[za0001] = za0002
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *DeploymentRoute) Msgsize() (s int) {
	s = 1 + 8 + msgp.StringPrefixSize + len(z.Version) + 5 + msgp.StringPrefixSize + len(z.Path) + 5 + msgp.StringPrefixSize + len(z.Type) + 12 + msgp.MapHeaderSize
	if z.TypeConfig != nil {
		for za0001, za0002 := range z.TypeConfig {
			_ = za0002
			s += msgp.StringPrefixSize + len(za0001) + msgp.GuessSize(za0002)
		}
	}
	return
}

// DecodeMsg implements msgp.Decodable
func (z *ForgotPasswordConfiguration) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "email_message":
			err = z.EmailMessage.DecodeMsg(dc)
			if err != nil {
				err = msgp.WrapError(err, "EmailMessage")
				return
			}
		case "sms_message":
			err = z.SMSMessage.DecodeMsg(dc)
			if err != nil {
				err = msgp.WrapError(err, "SMSMessage")
				return
			}
		case "reset_code_lifetime":
			z.ResetCodeLifetime, err = dc.ReadInt()
			if err != nil {
				err = msgp.WrapError(err, "ResetCodeLifetime")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *ForgotPasswordConfiguration) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 3
	// write "email_message"
	err = en.Append(0x83, 0xad, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65)
	if err != nil {
		return
	}
	err = z.EmailMessage.EncodeMsg(en)
	if err != nil {
		err = msgp.WrapError(err, "EmailMessage")
		return
	}
	// write "sms_message"
	err = en.Append(0xab, 0x73, 0x6d, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65)
	if err != nil {
		return
	}
	err = z.SMSMessage.EncodeMsg(en)
	if err != nil {
		err = msgp.WrapError(err, "SMSMessage")
		return
	}
	// write "reset_code_lifetime"
	err = en.Append(0xb3, 0x72, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65)
	if err != nil {
		return
	}
	err = en.WriteInt(z.ResetCodeLifetime)
	if err != nil {
		err = msgp.WrapError(err, "ResetCodeLifetime")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ForgotPasswordConfiguration) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 3
	// string "email_message"
	o = append(o, 0x83, 0xad, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65)
	o, err = z.EmailMessage.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "EmailMessage")
		return
	}
	// string "sms_message"
	o = append(o, 0xab, 0x73, 0x6d, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65)
	o, err = z.SMSMessage.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "SMSMessage")
		return
	}
	// string "reset_code_lifetime"
	o = append(o, 0xb3, 0x72, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65)
	o = msgp.AppendInt(o, z.ResetCodeLifetime)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ForgotPasswordConfiguration) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "email_message":
			bts, err = z.EmailMessage.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "EmailMessage")
				return
			}
		case "sms_message":
			bts, err = z.SMSMessage.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "SMSMessage")
				return
			}
		case "reset_code_lifetime":
			z.ResetCodeLifetime, bts, err = msgp.ReadIntBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ResetCodeLifetime")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ForgotPasswordConfiguration) Msgsize() (s int) {
	s = 1 + 14 + z.EmailMessage.Msgsize() + 12 + z.SMSMessage.Msgsize() + 20 + msgp.IntSize
	return
}

// DecodeMsg implements msgp.Decodable
func (z *Hook) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "event":
			z.Event, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Event")
				return
			}
		case "url":
			z.URL, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "URL")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z Hook) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 2
	// write "event"
	err = en.Append(0x82, 0xa5, 0x65, 0x76, 0x65, 0x6e, 0x74)
	if err != nil {
		return
	}
	err = en.WriteString(z.Event)
	if err != nil {
		err = msgp.WrapError(err, "Event")
		return
	}
	// write "url"
	err = en.Append(0xa3, 0x75, 0x72, 0x6c)
	if err != nil {
		return
	}
	err = en.WriteString(z.URL)
	if err != nil {
		err = msgp.WrapError(err, "URL")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z Hook) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 2
	// string "event"
	o = append(o, 0x82, 0xa5, 0x65, 0x76, 0x65, 0x6e, 0x74)
	o = msgp.AppendString(o, z.Event)
	// string "url"
	o = append(o, 0xa3, 0x75, 0x72, 0x6c)
	o = msgp.AppendString(o, z.URL)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Hook) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "event":
			z.Event, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Event")
				return
			}
		case "url":
			z.URL, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "URL")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z Hook) Msgsize() (s int) {
	s = 1 + 6 + msgp.StringPrefixSize + len(z.Event) + 4 + msgp.StringPrefixSize + len(z.URL)
	return
}

// DecodeMsg implements msgp.Decodable
func (z *HookAppConfiguration) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "secret":
			z.Secret, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Secret")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z HookAppConfiguration) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 1
	// write "secret"
	err = en.Append(0x81, 0xa6, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74)
	if err != nil {
		return
	}
	err = en.WriteString(z.Secret)
	if err != nil {
		err = msgp.WrapError(err, "Secret")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z HookAppConfiguration) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 1
	// string "secret"
	o = append(o, 0x81, 0xa6, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74)
	o = msgp.AppendString(o, z.Secret)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *HookAppConfiguration) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "secret":
			z.Secret, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Secret")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z HookAppConfiguration) Msgsize() (s int) {
	s = 1 + 7 + msgp.StringPrefixSize + len(z.Secret)
	return
}

// DecodeMsg implements msgp.Decodable
func (z *HookTenantConfiguration) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "sync_hook_timeout_second":
			z.SyncHookTimeout, err = dc.ReadInt()
			if err != nil {
				err = msgp.WrapError(err, "SyncHookTimeout")
				return
			}
		case "sync_hook_total_timeout_second":
			z.SyncHookTotalTimeout, err = dc.ReadInt()
			if err != nil {
				err = msgp.WrapError(err, "SyncHookTotalTimeout")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z HookTenantConfiguration) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 2
	// write "sync_hook_timeout_second"
	err = en.Append(0x82, 0xb8, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64)
	if err != nil {
		return
	}
	err = en.WriteInt(z.SyncHookTimeout)
	if err != nil {
		err = msgp.WrapError(err, "SyncHookTimeout")
		return
	}
	// write "sync_hook_total_timeout_second"
	err = en.Append(0xbe, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64)
	if err != nil {
		return
	}
	err = en.WriteInt(z.SyncHookTotalTimeout)
	if err != nil {
		err = msgp.WrapError(err, "SyncHookTotalTimeout")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z HookTenantConfiguration) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 2
	// string "sync_hook_timeout_second"
	o = append(o, 0x82, 0xb8, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64)
	o = msgp.AppendInt(o, z.SyncHookTimeout)
	// string "sync_hook_total_timeout_second"
	o = append(o, 0xbe, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64)
	o = msgp.AppendInt(o, z.SyncHookTotalTimeout)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *HookTenantConfiguration) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "sync_hook_timeout_second":
			z.SyncHookTimeout, bts, err = msgp.ReadIntBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "SyncHookTimeout")
				return
			}
		case "sync_hook_total_timeout_second":
			z.SyncHookTotalTimeout, bts, err = msgp.ReadIntBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "SyncHookTotalTimeout")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z HookTenantConfiguration) Msgsize() (s int) {
	s = 1 + 25 + msgp.IntSize + 31 + msgp.IntSize
	return
}

// DecodeMsg implements msgp.Decodable
func (z *NexmoConfiguration) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "api_key":
			z.APIKey, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "APIKey")
				return
			}
		case "api_secret":
			z.APISecret, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "APISecret")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z NexmoConfiguration) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 2
	// write "api_key"
	err = en.Append(0x82, 0xa7, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79)
	if err != nil {
		return
	}
	err = en.WriteString(z.APIKey)
	if err != nil {
		err = msgp.WrapError(err, "APIKey")
		return
	}
	// write "api_secret"
	err = en.Append(0xaa, 0x61, 0x70, 0x69, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74)
	if err != nil {
		return
	}
	err = en.WriteString(z.APISecret)
	if err != nil {
		err = msgp.WrapError(err, "APISecret")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z NexmoConfiguration) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 2
	// string "api_key"
	o = append(o, 0x82, 0xa7, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79)
	o = msgp.AppendString(o, z.APIKey)
	// string "api_secret"
	o = append(o, 0xaa, 0x61, 0x70, 0x69, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74)
	o = msgp.AppendString(o, z.APISecret)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *NexmoConfiguration) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "api_key":
			z.APIKey, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "APIKey")
				return
			}
		case "api_secret":
			z.APISecret, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "APISecret")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z NexmoConfiguration) Msgsize() (s int) {
	s = 1 + 8 + msgp.StringPrefixSize + len(z.APIKey) + 11 + msgp.StringPrefixSize + len(z.APISecret)
	return
}

// DecodeMsg implements msgp.Decodable
func (z *OAuthClientConfiguration) DecodeMsg(dc *msgp.Reader) (err error) {
	var zb0003 uint32
	zb0003, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if (*z) == nil {
		(*z) = make(OAuthClientConfiguration, zb0003)
	} else if len((*z)) > 0 {
		for key := range *z {
			delete((*z), key)
		}
	}
	for zb0003 > 0 {
		zb0003--
		var zb0001 string
		var zb0002 interface{}
		zb0001, err = dc.ReadString()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		zb0002, err = dc.ReadIntf()
		if err != nil {
			err = msgp.WrapError(err, zb0001)
			return
		}
		(*z)[zb0001] = zb0002
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z OAuthClientConfiguration) EncodeMsg(en *msgp.Writer) (err error) {
	err = en.WriteMapHeader(uint32(len(z)))
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0004, zb0005 := range z {
		err = en.WriteString(zb0004)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		err = en.WriteIntf(zb0005)
		if err != nil {
			err = msgp.WrapError(err, zb0004)
			return
		}
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z OAuthClientConfiguration) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendMapHeader(o, uint32(len(z)))
	for zb0004, zb0005 := range z {
		o = msgp.AppendString(o, zb0004)
		o, err = msgp.AppendIntf(o, zb0005)
		if err != nil {
			err = msgp.WrapError(err, zb0004)
			return
		}
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *OAuthClientConfiguration) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var zb0003 uint32
	zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if (*z) == nil {
		(*z) = make(OAuthClientConfiguration, zb0003)
	} else if len((*z)) > 0 {
		for key := range *z {
			delete((*z), key)
		}
	}
	for zb0003 > 0 {
		var zb0001 string
		var zb0002 interface{}
		zb0003--
		zb0001, bts, err = msgp.ReadStringBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		zb0002, bts, err = msgp.ReadIntfBytes(bts)
		if err != nil {
			err = msgp.WrapError(err, zb0001)
			return
		}
		(*z)[zb0001] = zb0002
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z OAuthClientConfiguration) Msgsize() (s int) {
	s = msgp.MapHeaderSize
	if z != nil {
		for zb0004, zb0005 := range z {
			_ = zb0005
			s += msgp.StringPrefixSize + len(zb0004) + msgp.GuessSize(zb0005)
		}
	}
	return
}

// DecodeMsg implements msgp.Decodable
func (z *OIDCConfiguration) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "keys":
			var zb0002 uint32
			zb0002, err = dc.ReadArrayHeader()
			if err != nil {
				err = msgp.WrapError(err, "Keys")
				return
			}
			if cap(z.Keys) >= int(zb0002) {
				z.Keys = (z.Keys)[:zb0002]
			} else {
				z.Keys = make([]OIDCSigningKeyConfiguration, zb0002)
			}
			for za0001 := range z.Keys {
				var zb0003 uint32
				zb0003, err = dc.ReadMapHeader()
				if err != nil {
					err = msgp.WrapError(err, "Keys", za0001)
					return
				}
				for zb0003 > 0 {
					zb0003--
					field, err = dc.ReadMapKeyPtr()
					if err != nil {
						err = msgp.WrapError(err, "Keys", za0001)
						return
					}
					switch msgp.UnsafeString(field) {
					case "kid":
						z.Keys[za0001].KID, err = dc.ReadString()
						if err != nil {
							err = msgp.WrapError(err, "Keys", za0001, "KID")
							return
						}
					case "public_key":
						z.Keys[za0001].PublicKey, err = dc.ReadString()
						if err != nil {
							err = msgp.WrapError(err, "Keys", za0001, "PublicKey")
							return
						}
					case "private_key":
						z.Keys[za0001].PrivateKey, err = dc.ReadString()
						if err != nil {
							err = msgp.WrapError(err, "Keys", za0001, "PrivateKey")
							return
						}
					default:
						err = dc.Skip()
						if err != nil {
							err = msgp.WrapError(err, "Keys", za0001)
							return
						}
					}
				}
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *OIDCConfiguration) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 1
	// write "keys"
	err = en.Append(0x81, 0xa4, 0x6b, 0x65, 0x79, 0x73)
	if err != nil {
		return
	}
	err = en.WriteArrayHeader(uint32(len(z.Keys)))
	if err != nil {
		err = msgp.WrapError(err, "Keys")
		return
	}
	for za0001 := range z.Keys {
		// map header, size 3
		// write "kid"
		err = en.Append(0x83, 0xa3, 0x6b, 0x69, 0x64)
		if err != nil {
			return
		}
		err = en.WriteString(z.Keys[za0001].KID)
		if err != nil {
			err = msgp.WrapError(err, "Keys", za0001, "KID")
			return
		}
		// write "public_key"
		err = en.Append(0xaa, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79)
		if err != nil {
			return
		}
		err = en.WriteString(z.Keys[za0001].PublicKey)
		if err != nil {
			err = msgp.WrapError(err, "Keys", za0001, "PublicKey")
			return
		}
		// write "private_key"
		err = en.Append(0xab, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79)
		if err != nil {
			return
		}
		err = en.WriteString(z.Keys[za0001].PrivateKey)
		if err != nil {
			err = msgp.WrapError(err, "Keys", za0001, "PrivateKey")
			return
		}
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *OIDCConfiguration) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 1
	// string "keys"
	o = append(o, 0x81, 0xa4, 0x6b, 0x65, 0x79, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.Keys)))
	for za0001 := range z.Keys {
		// map header, size 3
		// string "kid"
		o = append(o, 0x83, 0xa3, 0x6b, 0x69, 0x64)
		o = msgp.AppendString(o, z.Keys[za0001].KID)
		// string "public_key"
		o = append(o, 0xaa, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79)
		o = msgp.AppendString(o, z.Keys[za0001].PublicKey)
		// string "private_key"
		o = append(o, 0xab, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79)
		o = msgp.AppendString(o, z.Keys[za0001].PrivateKey)
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *OIDCConfiguration) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "keys":
			var zb0002 uint32
			zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Keys")
				return
			}
			if cap(z.Keys) >= int(zb0002) {
				z.Keys = (z.Keys)[:zb0002]
			} else {
				z.Keys = make([]OIDCSigningKeyConfiguration, zb0002)
			}
			for za0001 := range z.Keys {
				var zb0003 uint32
				zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Keys", za0001)
					return
				}
				for zb0003 > 0 {
					zb0003--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "Keys", za0001)
						return
					}
					switch msgp.UnsafeString(field) {
					case "kid":
						z.Keys[za0001].KID, bts, err = msgp.ReadStringBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Keys", za0001, "KID")
							return
						}
					case "public_key":
						z.Keys[za0001].PublicKey, bts, err = msgp.ReadStringBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Keys", za0001, "PublicKey")
							return
						}
					case "private_key":
						z.Keys[za0001].PrivateKey, bts, err = msgp.ReadStringBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Keys", za0001, "PrivateKey")
							return
						}
					default:
						bts, err = msgp.Skip(bts)
						if err != nil {
							err = msgp.WrapError(err, "Keys", za0001)
							return
						}
					}
				}
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *OIDCConfiguration) Msgsize() (s int) {
	s = 1 + 5 + msgp.ArrayHeaderSize
	for za0001 := range z.Keys {
		s += 1 + 4 + msgp.StringPrefixSize + len(z.Keys[za0001].KID) + 11 + msgp.StringPrefixSize + len(z.Keys[za0001].PublicKey) + 12 + msgp.StringPrefixSize + len(z.Keys[za0001].PrivateKey)
	}
	return
}

// DecodeMsg implements msgp.Decodable
func (z *OIDCSigningKeyConfiguration) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "kid":
			z.KID, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "KID")
				return
			}
		case "public_key":
			z.PublicKey, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "PublicKey")
				return
			}
		case "private_key":
			z.PrivateKey, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "PrivateKey")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z OIDCSigningKeyConfiguration) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 3
	// write "kid"
	err = en.Append(0x83, 0xa3, 0x6b, 0x69, 0x64)
	if err != nil {
		return
	}
	err = en.WriteString(z.KID)
	if err != nil {
		err = msgp.WrapError(err, "KID")
		return
	}
	// write "public_key"
	err = en.Append(0xaa, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79)
	if err != nil {
		return
	}
	err = en.WriteString(z.PublicKey)
	if err != nil {
		err = msgp.WrapError(err, "PublicKey")
		return
	}
	// write "private_key"
	err = en.Append(0xab, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79)
	if err != nil {
		return
	}
	err = en.WriteString(z.PrivateKey)
	if err != nil {
		err = msgp.WrapError(err, "PrivateKey")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z OIDCSigningKeyConfiguration) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 3
	// string "kid"
	o = append(o, 0x83, 0xa3, 0x6b, 0x69, 0x64)
	o = msgp.AppendString(o, z.KID)
	// string "public_key"
	o = append(o, 0xaa, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79)
	o = msgp.AppendString(o, z.PublicKey)
	// string "private_key"
	o = append(o, 0xab, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79)
	o = msgp.AppendString(o, z.PrivateKey)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *OIDCSigningKeyConfiguration) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "kid":
			z.KID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "KID")
				return
			}
		case "public_key":
			z.PublicKey, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "PublicKey")
				return
			}
		case "private_key":
			z.PrivateKey, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "PrivateKey")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z OIDCSigningKeyConfiguration) Msgsize() (s int) {
	s = 1 + 4 + msgp.StringPrefixSize + len(z.KID) + 11 + msgp.StringPrefixSize + len(z.PublicKey) + 12 + msgp.StringPrefixSize + len(z.PrivateKey)
	return
}

// DecodeMsg implements msgp.Decodable
func (z *SMTPConfiguration) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "host":
			z.Host, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Host")
				return
			}
		case "port":
			z.Port, err = dc.ReadInt()
			if err != nil {
				err = msgp.WrapError(err, "Port")
				return
			}
		case "mode":
			{
				var zb0002 string
				zb0002, err = dc.ReadString()
				if err != nil {
					err = msgp.WrapError(err, "Mode")
					return
				}
				z.Mode = SMTPMode(zb0002)
			}
		case "login":
			z.Login, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Login")
				return
			}
		case "password":
			z.Password, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Password")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *SMTPConfiguration) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 5
	// write "host"
	err = en.Append(0x85, 0xa4, 0x68, 0x6f, 0x73, 0x74)
	if err != nil {
		return
	}
	err = en.WriteString(z.Host)
	if err != nil {
		err = msgp.WrapError(err, "Host")
		return
	}
	// write "port"
	err = en.Append(0xa4, 0x70, 0x6f, 0x72, 0x74)
	if err != nil {
		return
	}
	err = en.WriteInt(z.Port)
	if err != nil {
		err = msgp.WrapError(err, "Port")
		return
	}
	// write "mode"
	err = en.Append(0xa4, 0x6d, 0x6f, 0x64, 0x65)
	if err != nil {
		return
	}
	err = en.WriteString(string(z.Mode))
	if err != nil {
		err = msgp.WrapError(err, "Mode")
		return
	}
	// write "login"
	err = en.Append(0xa5, 0x6c, 0x6f, 0x67, 0x69, 0x6e)
	if err != nil {
		return
	}
	err = en.WriteString(z.Login)
	if err != nil {
		err = msgp.WrapError(err, "Login")
		return
	}
	// write "password"
	err = en.Append(0xa8, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64)
	if err != nil {
		return
	}
	err = en.WriteString(z.Password)
	if err != nil {
		err = msgp.WrapError(err, "Password")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *SMTPConfiguration) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 5
	// string "host"
	o = append(o, 0x85, 0xa4, 0x68, 0x6f, 0x73, 0x74)
	o = msgp.AppendString(o, z.Host)
	// string "port"
	o = append(o, 0xa4, 0x70, 0x6f, 0x72, 0x74)
	o = msgp.AppendInt(o, z.Port)
	// string "mode"
	o = append(o, 0xa4, 0x6d, 0x6f, 0x64, 0x65)
	o = msgp.AppendString(o, string(z.Mode))
	// string "login"
	o = append(o, 0xa5, 0x6c, 0x6f, 0x67, 0x69, 0x6e)
	o = msgp.AppendString(o, z.Login)
	// string "password"
	o = append(o, 0xa8, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64)
	o = msgp.AppendString(o, z.Password)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *SMTPConfiguration) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "host":
			z.Host, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Host")
				return
			}
		case "port":
			z.Port, bts, err = msgp.ReadIntBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Port")
				return
			}
		case "mode":
			{
				var zb0002 string
				zb0002, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Mode")
					return
				}
				z.Mode = SMTPMode(zb0002)
			}
		case "login":
			z.Login, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Login")
				return
			}
		case "password":
			z.Password, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Password")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *SMTPConfiguration) Msgsize() (s int) {
	s = 1 + 5 + msgp.StringPrefixSize + len(z.Host) + 5 + msgp.IntSize + 5 + msgp.StringPrefixSize + len(string(z.Mode)) + 6 + msgp.StringPrefixSize + len(z.Login) + 9 + msgp.StringPrefixSize + len(z.Password)
	return
}

// DecodeMsg implements msgp.Decodable
func (z *SMTPMode) DecodeMsg(dc *msgp.Reader) (err error) {
	{
		var zb0001 string
		zb0001, err = dc.ReadString()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = SMTPMode(zb0001)
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z SMTPMode) EncodeMsg(en *msgp.Writer) (err error) {
	err = en.WriteString(string(z))
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z SMTPMode) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendString(o, string(z))
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *SMTPMode) UnmarshalMsg(bts []byte) (o []byte, err error) {
	{
		var zb0001 string
		zb0001, bts, err = msgp.ReadStringBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = SMTPMode(zb0001)
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z SMTPMode) Msgsize() (s int) {
	s = msgp.StringPrefixSize + len(string(z))
	return
}

// DecodeMsg implements msgp.Decodable
func (z *SessionConfiguration) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "lifetime":
			z.Lifetime, err = dc.ReadInt()
			if err != nil {
				err = msgp.WrapError(err, "Lifetime")
				return
			}
		case "idle_timeout_enabled":
			z.IdleTimeoutEnabled, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "IdleTimeoutEnabled")
				return
			}
		case "idle_timeout":
			z.IdleTimeout, err = dc.ReadInt()
			if err != nil {
				err = msgp.WrapError(err, "IdleTimeout")
				return
			}
		case "cookie_domain":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "CookieDomain")
					return
				}
				z.CookieDomain = nil
			} else {
				if z.CookieDomain == nil {
					z.CookieDomain = new(string)
				}
				*z.CookieDomain, err = dc.ReadString()
				if err != nil {
					err = msgp.WrapError(err, "CookieDomain")
					return
				}
			}
		case "cookie_non_persistent":
			z.CookieNonPersistent, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "CookieNonPersistent")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *SessionConfiguration) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 5
	// write "lifetime"
	err = en.Append(0x85, 0xa8, 0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65)
	if err != nil {
		return
	}
	err = en.WriteInt(z.Lifetime)
	if err != nil {
		err = msgp.WrapError(err, "Lifetime")
		return
	}
	// write "idle_timeout_enabled"
	err = en.Append(0xb4, 0x69, 0x64, 0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64)
	if err != nil {
		return
	}
	err = en.WriteBool(z.IdleTimeoutEnabled)
	if err != nil {
		err = msgp.WrapError(err, "IdleTimeoutEnabled")
		return
	}
	// write "idle_timeout"
	err = en.Append(0xac, 0x69, 0x64, 0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74)
	if err != nil {
		return
	}
	err = en.WriteInt(z.IdleTimeout)
	if err != nil {
		err = msgp.WrapError(err, "IdleTimeout")
		return
	}
	// write "cookie_domain"
	err = en.Append(0xad, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e)
	if err != nil {
		return
	}
	if z.CookieDomain == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		err = en.WriteString(*z.CookieDomain)
		if err != nil {
			err = msgp.WrapError(err, "CookieDomain")
			return
		}
	}
	// write "cookie_non_persistent"
	err = en.Append(0xb5, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x5f, 0x6e, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74)
	if err != nil {
		return
	}
	err = en.WriteBool(z.CookieNonPersistent)
	if err != nil {
		err = msgp.WrapError(err, "CookieNonPersistent")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *SessionConfiguration) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 5
	// string "lifetime"
	o = append(o, 0x85, 0xa8, 0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65)
	o = msgp.AppendInt(o, z.Lifetime)
	// string "idle_timeout_enabled"
	o = append(o, 0xb4, 0x69, 0x64, 0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64)
	o = msgp.AppendBool(o, z.IdleTimeoutEnabled)
	// string "idle_timeout"
	o = append(o, 0xac, 0x69, 0x64, 0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74)
	o = msgp.AppendInt(o, z.IdleTimeout)
	// string "cookie_domain"
	o = append(o, 0xad, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e)
	if z.CookieDomain == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendString(o, *z.CookieDomain)
	}
	// string "cookie_non_persistent"
	o = append(o, 0xb5, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x5f, 0x6e, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74)
	o = msgp.AppendBool(o, z.CookieNonPersistent)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *SessionConfiguration) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "lifetime":
			z.Lifetime, bts, err = msgp.ReadIntBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Lifetime")
				return
			}
		case "idle_timeout_enabled":
			z.IdleTimeoutEnabled, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "IdleTimeoutEnabled")
				return
			}
		case "idle_timeout":
			z.IdleTimeout, bts, err = msgp.ReadIntBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "IdleTimeout")
				return
			}
		case "cookie_domain":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.CookieDomain = nil
			} else {
				if z.CookieDomain == nil {
					z.CookieDomain = new(string)
				}
				*z.CookieDomain, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "CookieDomain")
					return
				}
			}
		case "cookie_non_persistent":
			z.CookieNonPersistent, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "CookieNonPersistent")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *SessionConfiguration) Msgsize() (s int) {
	s = 1 + 9 + msgp.IntSize + 21 + msgp.BoolSize + 13 + msgp.IntSize + 14
	if z.CookieDomain == nil {
		s += msgp.NilSize
	} else {
		s += msgp.StringPrefixSize + len(*z.CookieDomain)
	}
	s += 22 + msgp.BoolSize
	return
}

// DecodeMsg implements msgp.Decodable
func (z *TemplateItem) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "type":
			{
				var zb0002 string
				zb0002, err = dc.ReadString()
				if err != nil {
					err = msgp.WrapError(err, "Type")
					return
				}
				z.Type = TemplateItemType(zb0002)
			}
		case "language_tag":
			z.LanguageTag, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "LanguageTag")
				return
			}
		case "key":
			z.Key, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Key")
				return
			}
		case "uri":
			z.URI, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "URI")
				return
			}
		case "digest":
			z.Digest, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Digest")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *TemplateItem) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 5
	// write "type"
	err = en.Append(0x85, 0xa4, 0x74, 0x79, 0x70, 0x65)
	if err != nil {
		return
	}
	err = en.WriteString(string(z.Type))
	if err != nil {
		err = msgp.WrapError(err, "Type")
		return
	}
	// write "language_tag"
	err = en.Append(0xac, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x61, 0x67)
	if err != nil {
		return
	}
	err = en.WriteString(z.LanguageTag)
	if err != nil {
		err = msgp.WrapError(err, "LanguageTag")
		return
	}
	// write "key"
	err = en.Append(0xa3, 0x6b, 0x65, 0x79)
	if err != nil {
		return
	}
	err = en.WriteString(z.Key)
	if err != nil {
		err = msgp.WrapError(err, "Key")
		return
	}
	// write "uri"
	err = en.Append(0xa3, 0x75, 0x72, 0x69)
	if err != nil {
		return
	}
	err = en.WriteString(z.URI)
	if err != nil {
		err = msgp.WrapError(err, "URI")
		return
	}
	// write "digest"
	err = en.Append(0xa6, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74)
	if err != nil {
		return
	}
	err = en.WriteString(z.Digest)
	if err != nil {
		err = msgp.WrapError(err, "Digest")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *TemplateItem) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 5
	// string "type"
	o = append(o, 0x85, 0xa4, 0x74, 0x79, 0x70, 0x65)
	o = msgp.AppendString(o, string(z.Type))
	// string "language_tag"
	o = append(o, 0xac, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x61, 0x67)
	o = msgp.AppendString(o, z.LanguageTag)
	// string "key"
	o = append(o, 0xa3, 0x6b, 0x65, 0x79)
	o = msgp.AppendString(o, z.Key)
	// string "uri"
	o = append(o, 0xa3, 0x75, 0x72, 0x69)
	o = msgp.AppendString(o, z.URI)
	// string "digest"
	o = append(o, 0xa6, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74)
	o = msgp.AppendString(o, z.Digest)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *TemplateItem) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "type":
			{
				var zb0002 string
				zb0002, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Type")
					return
				}
				z.Type = TemplateItemType(zb0002)
			}
		case "language_tag":
			z.LanguageTag, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "LanguageTag")
				return
			}
		case "key":
			z.Key, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Key")
				return
			}
		case "uri":
			z.URI, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "URI")
				return
			}
		case "digest":
			z.Digest, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Digest")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *TemplateItem) Msgsize() (s int) {
	s = 1 + 5 + msgp.StringPrefixSize + len(string(z.Type)) + 13 + msgp.StringPrefixSize + len(z.LanguageTag) + 4 + msgp.StringPrefixSize + len(z.Key) + 4 + msgp.StringPrefixSize + len(z.URI) + 7 + msgp.StringPrefixSize + len(z.Digest)
	return
}

// DecodeMsg implements msgp.Decodable
func (z *TemplateItemType) DecodeMsg(dc *msgp.Reader) (err error) {
	{
		var zb0001 string
		zb0001, err = dc.ReadString()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = TemplateItemType(zb0001)
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z TemplateItemType) EncodeMsg(en *msgp.Writer) (err error) {
	err = en.WriteString(string(z))
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z TemplateItemType) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendString(o, string(z))
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *TemplateItemType) UnmarshalMsg(bts []byte) (o []byte, err error) {
	{
		var zb0001 string
		zb0001, bts, err = msgp.ReadStringBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = TemplateItemType(zb0001)
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z TemplateItemType) Msgsize() (s int) {
	s = msgp.StringPrefixSize + len(string(z))
	return
}

// DecodeMsg implements msgp.Decodable
func (z *TenantConfiguration) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "api_version":
			z.APIVersion, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "APIVersion")
				return
			}
		case "app_id":
			z.AppID, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "AppID")
				return
			}
		case "app_name":
			z.AppName, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "AppName")
				return
			}
		case "hook":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "Hook")
					return
				}
				z.Hook = nil
			} else {
				if z.Hook == nil {
					z.Hook = new(HookTenantConfiguration)
				}
				var zb0002 uint32
				zb0002, err = dc.ReadMapHeader()
				if err != nil {
					err = msgp.WrapError(err, "Hook")
					return
				}
				for zb0002 > 0 {
					zb0002--
					field, err = dc.ReadMapKeyPtr()
					if err != nil {
						err = msgp.WrapError(err, "Hook")
						return
					}
					switch msgp.UnsafeString(field) {
					case "sync_hook_timeout_second":
						z.Hook.SyncHookTimeout, err = dc.ReadInt()
						if err != nil {
							err = msgp.WrapError(err, "Hook", "SyncHookTimeout")
							return
						}
					case "sync_hook_total_timeout_second":
						z.Hook.SyncHookTotalTimeout, err = dc.ReadInt()
						if err != nil {
							err = msgp.WrapError(err, "Hook", "SyncHookTotalTimeout")
							return
						}
					default:
						err = dc.Skip()
						if err != nil {
							err = msgp.WrapError(err, "Hook")
							return
						}
					}
				}
			}
		case "database_config":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "DatabaseConfig")
					return
				}
				z.DatabaseConfig = nil
			} else {
				if z.DatabaseConfig == nil {
					z.DatabaseConfig = new(DatabaseConfiguration)
				}
				var zb0003 uint32
				zb0003, err = dc.ReadMapHeader()
				if err != nil {
					err = msgp.WrapError(err, "DatabaseConfig")
					return
				}
				for zb0003 > 0 {
					zb0003--
					field, err = dc.ReadMapKeyPtr()
					if err != nil {
						err = msgp.WrapError(err, "DatabaseConfig")
						return
					}
					switch msgp.UnsafeString(field) {
					case "database_url":
						z.DatabaseConfig.DatabaseURL, err = dc.ReadString()
						if err != nil {
							err = msgp.WrapError(err, "DatabaseConfig", "DatabaseURL")
							return
						}
					case "database_schema":
						z.DatabaseConfig.DatabaseSchema, err = dc.ReadString()
						if err != nil {
							err = msgp.WrapError(err, "DatabaseConfig", "DatabaseSchema")
							return
						}
					default:
						err = dc.Skip()
						if err != nil {
							err = msgp.WrapError(err, "DatabaseConfig")
							return
						}
					}
				}
			}
		case "app_config":
			if dc.IsNil() {
				err = dc.ReadNil()
				if err != nil {
					err = msgp.WrapError(err, "AppConfig")
					return
				}
				z.AppConfig = nil
			} else {
				if z.AppConfig == nil {
					z.AppConfig = new(AppConfiguration)
				}
				err = z.AppConfig.DecodeMsg(dc)
				if err != nil {
					err = msgp.WrapError(err, "AppConfig")
					return
				}
			}
		case "template_items":
			var zb0004 uint32
			zb0004, err = dc.ReadArrayHeader()
			if err != nil {
				err = msgp.WrapError(err, "TemplateItems")
				return
			}
			if cap(z.TemplateItems) >= int(zb0004) {
				z.TemplateItems = (z.TemplateItems)[:zb0004]
			} else {
				z.TemplateItems = make([]TemplateItem, zb0004)
			}
			for za0001 := range z.TemplateItems {
				err = z.TemplateItems[za0001].DecodeMsg(dc)
				if err != nil {
					err = msgp.WrapError(err, "TemplateItems", za0001)
					return
				}
			}
		case "hooks":
			var zb0005 uint32
			zb0005, err = dc.ReadArrayHeader()
			if err != nil {
				err = msgp.WrapError(err, "Hooks")
				return
			}
			if cap(z.Hooks) >= int(zb0005) {
				z.Hooks = (z.Hooks)[:zb0005]
			} else {
				z.Hooks = make([]Hook, zb0005)
			}
			for za0002 := range z.Hooks {
				var zb0006 uint32
				zb0006, err = dc.ReadMapHeader()
				if err != nil {
					err = msgp.WrapError(err, "Hooks", za0002)
					return
				}
				for zb0006 > 0 {
					zb0006--
					field, err = dc.ReadMapKeyPtr()
					if err != nil {
						err = msgp.WrapError(err, "Hooks", za0002)
						return
					}
					switch msgp.UnsafeString(field) {
					case "event":
						z.Hooks[za0002].Event, err = dc.ReadString()
						if err != nil {
							err = msgp.WrapError(err, "Hooks", za0002, "Event")
							return
						}
					case "url":
						z.Hooks[za0002].URL, err = dc.ReadString()
						if err != nil {
							err = msgp.WrapError(err, "Hooks", za0002, "URL")
							return
						}
					default:
						err = dc.Skip()
						if err != nil {
							err = msgp.WrapError(err, "Hooks", za0002)
							return
						}
					}
				}
			}
		case "deployment_routes":
			var zb0007 uint32
			zb0007, err = dc.ReadArrayHeader()
			if err != nil {
				err = msgp.WrapError(err, "DeploymentRoutes")
				return
			}
			if cap(z.DeploymentRoutes) >= int(zb0007) {
				z.DeploymentRoutes = (z.DeploymentRoutes)[:zb0007]
			} else {
				z.DeploymentRoutes = make([]DeploymentRoute, zb0007)
			}
			for za0003 := range z.DeploymentRoutes {
				err = z.DeploymentRoutes[za0003].DecodeMsg(dc)
				if err != nil {
					err = msgp.WrapError(err, "DeploymentRoutes", za0003)
					return
				}
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *TenantConfiguration) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 9
	// write "api_version"
	err = en.Append(0x89, 0xab, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e)
	if err != nil {
		return
	}
	err = en.WriteString(z.APIVersion)
	if err != nil {
		err = msgp.WrapError(err, "APIVersion")
		return
	}
	// write "app_id"
	err = en.Append(0xa6, 0x61, 0x70, 0x70, 0x5f, 0x69, 0x64)
	if err != nil {
		return
	}
	err = en.WriteString(z.AppID)
	if err != nil {
		err = msgp.WrapError(err, "AppID")
		return
	}
	// write "app_name"
	err = en.Append(0xa8, 0x61, 0x70, 0x70, 0x5f, 0x6e, 0x61, 0x6d, 0x65)
	if err != nil {
		return
	}
	err = en.WriteString(z.AppName)
	if err != nil {
		err = msgp.WrapError(err, "AppName")
		return
	}
	// write "hook"
	err = en.Append(0xa4, 0x68, 0x6f, 0x6f, 0x6b)
	if err != nil {
		return
	}
	if z.Hook == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		// map header, size 2
		// write "sync_hook_timeout_second"
		err = en.Append(0x82, 0xb8, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64)
		if err != nil {
			return
		}
		err = en.WriteInt(z.Hook.SyncHookTimeout)
		if err != nil {
			err = msgp.WrapError(err, "Hook", "SyncHookTimeout")
			return
		}
		// write "sync_hook_total_timeout_second"
		err = en.Append(0xbe, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64)
		if err != nil {
			return
		}
		err = en.WriteInt(z.Hook.SyncHookTotalTimeout)
		if err != nil {
			err = msgp.WrapError(err, "Hook", "SyncHookTotalTimeout")
			return
		}
	}
	// write "database_config"
	err = en.Append(0xaf, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67)
	if err != nil {
		return
	}
	if z.DatabaseConfig == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		// map header, size 2
		// write "database_url"
		err = en.Append(0x82, 0xac, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x75, 0x72, 0x6c)
		if err != nil {
			return
		}
		err = en.WriteString(z.DatabaseConfig.DatabaseURL)
		if err != nil {
			err = msgp.WrapError(err, "DatabaseConfig", "DatabaseURL")
			return
		}
		// write "database_schema"
		err = en.Append(0xaf, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61)
		if err != nil {
			return
		}
		err = en.WriteString(z.DatabaseConfig.DatabaseSchema)
		if err != nil {
			err = msgp.WrapError(err, "DatabaseConfig", "DatabaseSchema")
			return
		}
	}
	// write "app_config"
	err = en.Append(0xaa, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67)
	if err != nil {
		return
	}
	if z.AppConfig == nil {
		err = en.WriteNil()
		if err != nil {
			return
		}
	} else {
		err = z.AppConfig.EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "AppConfig")
			return
		}
	}
	// write "template_items"
	err = en.Append(0xae, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73)
	if err != nil {
		return
	}
	err = en.WriteArrayHeader(uint32(len(z.TemplateItems)))
	if err != nil {
		err = msgp.WrapError(err, "TemplateItems")
		return
	}
	for za0001 := range z.TemplateItems {
		err = z.TemplateItems[za0001].EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "TemplateItems", za0001)
			return
		}
	}
	// write "hooks"
	err = en.Append(0xa5, 0x68, 0x6f, 0x6f, 0x6b, 0x73)
	if err != nil {
		return
	}
	err = en.WriteArrayHeader(uint32(len(z.Hooks)))
	if err != nil {
		err = msgp.WrapError(err, "Hooks")
		return
	}
	for za0002 := range z.Hooks {
		// map header, size 2
		// write "event"
		err = en.Append(0x82, 0xa5, 0x65, 0x76, 0x65, 0x6e, 0x74)
		if err != nil {
			return
		}
		err = en.WriteString(z.Hooks[za0002].Event)
		if err != nil {
			err = msgp.WrapError(err, "Hooks", za0002, "Event")
			return
		}
		// write "url"
		err = en.Append(0xa3, 0x75, 0x72, 0x6c)
		if err != nil {
			return
		}
		err = en.WriteString(z.Hooks[za0002].URL)
		if err != nil {
			err = msgp.WrapError(err, "Hooks", za0002, "URL")
			return
		}
	}
	// write "deployment_routes"
	err = en.Append(0xb1, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73)
	if err != nil {
		return
	}
	err = en.WriteArrayHeader(uint32(len(z.DeploymentRoutes)))
	if err != nil {
		err = msgp.WrapError(err, "DeploymentRoutes")
		return
	}
	for za0003 := range z.DeploymentRoutes {
		err = z.DeploymentRoutes[za0003].EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "DeploymentRoutes", za0003)
			return
		}
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *TenantConfiguration) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 9
	// string "api_version"
	o = append(o, 0x89, 0xab, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e)
	o = msgp.AppendString(o, z.APIVersion)
	// string "app_id"
	o = append(o, 0xa6, 0x61, 0x70, 0x70, 0x5f, 0x69, 0x64)
	o = msgp.AppendString(o, z.AppID)
	// string "app_name"
	o = append(o, 0xa8, 0x61, 0x70, 0x70, 0x5f, 0x6e, 0x61, 0x6d, 0x65)
	o = msgp.AppendString(o, z.AppName)
	// string "hook"
	o = append(o, 0xa4, 0x68, 0x6f, 0x6f, 0x6b)
	if z.Hook == nil {
		o = msgp.AppendNil(o)
	} else {
		// map header, size 2
		// string "sync_hook_timeout_second"
		o = append(o, 0x82, 0xb8, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64)
		o = msgp.AppendInt(o, z.Hook.SyncHookTimeout)
		// string "sync_hook_total_timeout_second"
		o = append(o, 0xbe, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64)
		o = msgp.AppendInt(o, z.Hook.SyncHookTotalTimeout)
	}
	// string "database_config"
	o = append(o, 0xaf, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67)
	if z.DatabaseConfig == nil {
		o = msgp.AppendNil(o)
	} else {
		// map header, size 2
		// string "database_url"
		o = append(o, 0x82, 0xac, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x75, 0x72, 0x6c)
		o = msgp.AppendString(o, z.DatabaseConfig.DatabaseURL)
		// string "database_schema"
		o = append(o, 0xaf, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61)
		o = msgp.AppendString(o, z.DatabaseConfig.DatabaseSchema)
	}
	// string "app_config"
	o = append(o, 0xaa, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67)
	if z.AppConfig == nil {
		o = msgp.AppendNil(o)
	} else {
		o, err = z.AppConfig.MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "AppConfig")
			return
		}
	}
	// string "template_items"
	o = append(o, 0xae, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.TemplateItems)))
	for za0001 := range z.TemplateItems {
		o, err = z.TemplateItems[za0001].MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "TemplateItems", za0001)
			return
		}
	}
	// string "hooks"
	o = append(o, 0xa5, 0x68, 0x6f, 0x6f, 0x6b, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.Hooks)))
	for za0002 := range z.Hooks {
		// map header, size 2
		// string "event"
		o = append(o, 0x82, 0xa5, 0x65, 0x76, 0x65, 0x6e, 0x74)
		o = msgp.AppendString(o, z.Hooks[za0002].Event)
		// string "url"
		o = append(o, 0xa3, 0x75, 0x72, 0x6c)
		o = msgp.AppendString(o, z.Hooks[za0002].URL)
	}
	// string "deployment_routes"
	o = append(o, 0xb1, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.DeploymentRoutes)))
	for za0003 := range z.DeploymentRoutes {
		o, err = z.DeploymentRoutes[za0003].MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "DeploymentRoutes", za0003)
			return
		}
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *TenantConfiguration) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "api_version":
			z.APIVersion, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "APIVersion")
				return
			}
		case "app_id":
			z.AppID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "AppID")
				return
			}
		case "app_name":
			z.AppName, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "AppName")
				return
			}
		case "hook":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.Hook = nil
			} else {
				if z.Hook == nil {
					z.Hook = new(HookTenantConfiguration)
				}
				var zb0002 uint32
				zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Hook")
					return
				}
				for zb0002 > 0 {
					zb0002--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "Hook")
						return
					}
					switch msgp.UnsafeString(field) {
					case "sync_hook_timeout_second":
						z.Hook.SyncHookTimeout, bts, err = msgp.ReadIntBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Hook", "SyncHookTimeout")
							return
						}
					case "sync_hook_total_timeout_second":
						z.Hook.SyncHookTotalTimeout, bts, err = msgp.ReadIntBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Hook", "SyncHookTotalTimeout")
							return
						}
					default:
						bts, err = msgp.Skip(bts)
						if err != nil {
							err = msgp.WrapError(err, "Hook")
							return
						}
					}
				}
			}
		case "database_config":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.DatabaseConfig = nil
			} else {
				if z.DatabaseConfig == nil {
					z.DatabaseConfig = new(DatabaseConfiguration)
				}
				var zb0003 uint32
				zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "DatabaseConfig")
					return
				}
				for zb0003 > 0 {
					zb0003--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "DatabaseConfig")
						return
					}
					switch msgp.UnsafeString(field) {
					case "database_url":
						z.DatabaseConfig.DatabaseURL, bts, err = msgp.ReadStringBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "DatabaseConfig", "DatabaseURL")
							return
						}
					case "database_schema":
						z.DatabaseConfig.DatabaseSchema, bts, err = msgp.ReadStringBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "DatabaseConfig", "DatabaseSchema")
							return
						}
					default:
						bts, err = msgp.Skip(bts)
						if err != nil {
							err = msgp.WrapError(err, "DatabaseConfig")
							return
						}
					}
				}
			}
		case "app_config":
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				z.AppConfig = nil
			} else {
				if z.AppConfig == nil {
					z.AppConfig = new(AppConfiguration)
				}
				bts, err = z.AppConfig.UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "AppConfig")
					return
				}
			}
		case "template_items":
			var zb0004 uint32
			zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "TemplateItems")
				return
			}
			if cap(z.TemplateItems) >= int(zb0004) {
				z.TemplateItems = (z.TemplateItems)[:zb0004]
			} else {
				z.TemplateItems = make([]TemplateItem, zb0004)
			}
			for za0001 := range z.TemplateItems {
				bts, err = z.TemplateItems[za0001].UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "TemplateItems", za0001)
					return
				}
			}
		case "hooks":
			var zb0005 uint32
			zb0005, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Hooks")
				return
			}
			if cap(z.Hooks) >= int(zb0005) {
				z.Hooks = (z.Hooks)[:zb0005]
			} else {
				z.Hooks = make([]Hook, zb0005)
			}
			for za0002 := range z.Hooks {
				var zb0006 uint32
				zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Hooks", za0002)
					return
				}
				for zb0006 > 0 {
					zb0006--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "Hooks", za0002)
						return
					}
					switch msgp.UnsafeString(field) {
					case "event":
						z.Hooks[za0002].Event, bts, err = msgp.ReadStringBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Hooks", za0002, "Event")
							return
						}
					case "url":
						z.Hooks[za0002].URL, bts, err = msgp.ReadStringBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Hooks", za0002, "URL")
							return
						}
					default:
						bts, err = msgp.Skip(bts)
						if err != nil {
							err = msgp.WrapError(err, "Hooks", za0002)
							return
						}
					}
				}
			}
		case "deployment_routes":
			var zb0007 uint32
			zb0007, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "DeploymentRoutes")
				return
			}
			if cap(z.DeploymentRoutes) >= int(zb0007) {
				z.DeploymentRoutes = (z.DeploymentRoutes)[:zb0007]
			} else {
				z.DeploymentRoutes = make([]DeploymentRoute, zb0007)
			}
			for za0003 := range z.DeploymentRoutes {
				bts, err = z.DeploymentRoutes[za0003].UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "DeploymentRoutes", za0003)
					return
				}
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *TenantConfiguration) Msgsize() (s int) {
	s = 1 + 12 + msgp.StringPrefixSize + len(z.APIVersion) + 7 + msgp.StringPrefixSize + len(z.AppID) + 9 + msgp.StringPrefixSize + len(z.AppName) + 5
	if z.Hook == nil {
		s += msgp.NilSize
	} else {
		s += 1 + 25 + msgp.IntSize + 31 + msgp.IntSize
	}
	s += 16
	if z.DatabaseConfig == nil {
		s += msgp.NilSize
	} else {
		s += 1 + 13 + msgp.StringPrefixSize + len(z.DatabaseConfig.DatabaseURL) + 16 + msgp.StringPrefixSize + len(z.DatabaseConfig.DatabaseSchema)
	}
	s += 11
	if z.AppConfig == nil {
		s += msgp.NilSize
	} else {
		s += z.AppConfig.Msgsize()
	}
	s += 15 + msgp.ArrayHeaderSize
	for za0001 := range z.TemplateItems {
		s += z.TemplateItems[za0001].Msgsize()
	}
	s += 6 + msgp.ArrayHeaderSize
	for za0002 := range z.Hooks {
		s += 1 + 6 + msgp.StringPrefixSize + len(z.Hooks[za0002].Event) + 4 + msgp.StringPrefixSize + len(z.Hooks[za0002].URL)
	}
	s += 18 + msgp.ArrayHeaderSize
	for za0003 := range z.DeploymentRoutes {
		s += z.DeploymentRoutes[za0003].Msgsize()
	}
	return
}

// DecodeMsg implements msgp.Decodable
func (z *TwilioConfiguration) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "account_sid":
			z.AccountSID, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "AccountSID")
				return
			}
		case "auth_token":
			z.AuthToken, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "AuthToken")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z TwilioConfiguration) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 2
	// write "account_sid"
	err = en.Append(0x82, 0xab, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x73, 0x69, 0x64)
	if err != nil {
		return
	}
	err = en.WriteString(z.AccountSID)
	if err != nil {
		err = msgp.WrapError(err, "AccountSID")
		return
	}
	// write "auth_token"
	err = en.Append(0xaa, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e)
	if err != nil {
		return
	}
	err = en.WriteString(z.AuthToken)
	if err != nil {
		err = msgp.WrapError(err, "AuthToken")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z TwilioConfiguration) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 2
	// string "account_sid"
	o = append(o, 0x82, 0xab, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x73, 0x69, 0x64)
	o = msgp.AppendString(o, z.AccountSID)
	// string "auth_token"
	o = append(o, 0xaa, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e)
	o = msgp.AppendString(o, z.AuthToken)
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *TwilioConfiguration) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "account_sid":
			z.AccountSID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "AccountSID")
				return
			}
		case "auth_token":
			z.AuthToken, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "AuthToken")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z TwilioConfiguration) Msgsize() (s int) {
	s = 1 + 12 + msgp.StringPrefixSize + len(z.AccountSID) + 11 + msgp.StringPrefixSize + len(z.AuthToken)
	return
}

// DecodeMsg implements msgp.Decodable
func (z *UserVerificationCodeFormat) DecodeMsg(dc *msgp.Reader) (err error) {
	{
		var zb0001 string
		zb0001, err = dc.ReadString()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = UserVerificationCodeFormat(zb0001)
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z UserVerificationCodeFormat) EncodeMsg(en *msgp.Writer) (err error) {
	err = en.WriteString(string(z))
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z UserVerificationCodeFormat) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendString(o, string(z))
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *UserVerificationCodeFormat) UnmarshalMsg(bts []byte) (o []byte, err error) {
	{
		var zb0001 string
		zb0001, bts, err = msgp.ReadStringBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = UserVerificationCodeFormat(zb0001)
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z UserVerificationCodeFormat) Msgsize() (s int) {
	s = msgp.StringPrefixSize + len(string(z))
	return
}

// DecodeMsg implements msgp.Decodable
func (z *UserVerificationConfiguration) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "auto_send_on_signup":
			z.AutoSendOnSignup, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "AutoSendOnSignup")
				return
			}
		case "criteria":
			{
				var zb0002 string
				zb0002, err = dc.ReadString()
				if err != nil {
					err = msgp.WrapError(err, "Criteria")
					return
				}
				z.Criteria = UserVerificationCriteria(zb0002)
			}
		case "login_id_keys":
			var zb0003 uint32
			zb0003, err = dc.ReadArrayHeader()
			if err != nil {
				err = msgp.WrapError(err, "LoginIDKeys")
				return
			}
			if cap(z.LoginIDKeys) >= int(zb0003) {
				z.LoginIDKeys = (z.LoginIDKeys)[:zb0003]
			} else {
				z.LoginIDKeys = make([]UserVerificationKeyConfiguration, zb0003)
			}
			for za0001 := range z.LoginIDKeys {
				err = z.LoginIDKeys[za0001].DecodeMsg(dc)
				if err != nil {
					err = msgp.WrapError(err, "LoginIDKeys", za0001)
					return
				}
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *UserVerificationConfiguration) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 3
	// write "auto_send_on_signup"
	err = en.Append(0x83, 0xb3, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x73, 0x65, 0x6e, 0x64, 0x5f, 0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x75, 0x70)
	if err != nil {
		return
	}
	err = en.WriteBool(z.AutoSendOnSignup)
	if err != nil {
		err = msgp.WrapError(err, "AutoSendOnSignup")
		return
	}
	// write "criteria"
	err = en.Append(0xa8, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61)
	if err != nil {
		return
	}
	err = en.WriteString(string(z.Criteria))
	if err != nil {
		err = msgp.WrapError(err, "Criteria")
		return
	}
	// write "login_id_keys"
	err = en.Append(0xad, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x69, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x73)
	if err != nil {
		return
	}
	err = en.WriteArrayHeader(uint32(len(z.LoginIDKeys)))
	if err != nil {
		err = msgp.WrapError(err, "LoginIDKeys")
		return
	}
	for za0001 := range z.LoginIDKeys {
		err = z.LoginIDKeys[za0001].EncodeMsg(en)
		if err != nil {
			err = msgp.WrapError(err, "LoginIDKeys", za0001)
			return
		}
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *UserVerificationConfiguration) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 3
	// string "auto_send_on_signup"
	o = append(o, 0x83, 0xb3, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x73, 0x65, 0x6e, 0x64, 0x5f, 0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x75, 0x70)
	o = msgp.AppendBool(o, z.AutoSendOnSignup)
	// string "criteria"
	o = append(o, 0xa8, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61)
	o = msgp.AppendString(o, string(z.Criteria))
	// string "login_id_keys"
	o = append(o, 0xad, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x5f, 0x69, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x73)
	o = msgp.AppendArrayHeader(o, uint32(len(z.LoginIDKeys)))
	for za0001 := range z.LoginIDKeys {
		o, err = z.LoginIDKeys[za0001].MarshalMsg(o)
		if err != nil {
			err = msgp.WrapError(err, "LoginIDKeys", za0001)
			return
		}
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *UserVerificationConfiguration) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "auto_send_on_signup":
			z.AutoSendOnSignup, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "AutoSendOnSignup")
				return
			}
		case "criteria":
			{
				var zb0002 string
				zb0002, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Criteria")
					return
				}
				z.Criteria = UserVerificationCriteria(zb0002)
			}
		case "login_id_keys":
			var zb0003 uint32
			zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "LoginIDKeys")
				return
			}
			if cap(z.LoginIDKeys) >= int(zb0003) {
				z.LoginIDKeys = (z.LoginIDKeys)[:zb0003]
			} else {
				z.LoginIDKeys = make([]UserVerificationKeyConfiguration, zb0003)
			}
			for za0001 := range z.LoginIDKeys {
				bts, err = z.LoginIDKeys[za0001].UnmarshalMsg(bts)
				if err != nil {
					err = msgp.WrapError(err, "LoginIDKeys", za0001)
					return
				}
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *UserVerificationConfiguration) Msgsize() (s int) {
	s = 1 + 20 + msgp.BoolSize + 9 + msgp.StringPrefixSize + len(string(z.Criteria)) + 14 + msgp.ArrayHeaderSize
	for za0001 := range z.LoginIDKeys {
		s += z.LoginIDKeys[za0001].Msgsize()
	}
	return
}

// DecodeMsg implements msgp.Decodable
func (z *UserVerificationCriteria) DecodeMsg(dc *msgp.Reader) (err error) {
	{
		var zb0001 string
		zb0001, err = dc.ReadString()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = UserVerificationCriteria(zb0001)
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z UserVerificationCriteria) EncodeMsg(en *msgp.Writer) (err error) {
	err = en.WriteString(string(z))
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z UserVerificationCriteria) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendString(o, string(z))
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *UserVerificationCriteria) UnmarshalMsg(bts []byte) (o []byte, err error) {
	{
		var zb0001 string
		zb0001, bts, err = msgp.ReadStringBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = UserVerificationCriteria(zb0001)
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z UserVerificationCriteria) Msgsize() (s int) {
	s = msgp.StringPrefixSize + len(string(z))
	return
}

// DecodeMsg implements msgp.Decodable
func (z *UserVerificationKeyConfiguration) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "key":
			z.Key, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "Key")
				return
			}
		case "code_format":
			{
				var zb0002 string
				zb0002, err = dc.ReadString()
				if err != nil {
					err = msgp.WrapError(err, "CodeFormat")
					return
				}
				z.CodeFormat = UserVerificationCodeFormat(zb0002)
			}
		case "expiry":
			z.Expiry, err = dc.ReadInt64()
			if err != nil {
				err = msgp.WrapError(err, "Expiry")
				return
			}
		case "success_redirect":
			z.SuccessRedirect, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "SuccessRedirect")
				return
			}
		case "error_redirect":
			z.ErrorRedirect, err = dc.ReadString()
			if err != nil {
				err = msgp.WrapError(err, "ErrorRedirect")
				return
			}
		case "sms_message":
			err = z.SMSMessage.DecodeMsg(dc)
			if err != nil {
				err = msgp.WrapError(err, "SMSMessage")
				return
			}
		case "email_message":
			err = z.EmailMessage.DecodeMsg(dc)
			if err != nil {
				err = msgp.WrapError(err, "EmailMessage")
				return
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *UserVerificationKeyConfiguration) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 7
	// write "key"
	err = en.Append(0x87, 0xa3, 0x6b, 0x65, 0x79)
	if err != nil {
		return
	}
	err = en.WriteString(z.Key)
	if err != nil {
		err = msgp.WrapError(err, "Key")
		return
	}
	// write "code_format"
	err = en.Append(0xab, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74)
	if err != nil {
		return
	}
	err = en.WriteString(string(z.CodeFormat))
	if err != nil {
		err = msgp.WrapError(err, "CodeFormat")
		return
	}
	// write "expiry"
	err = en.Append(0xa6, 0x65, 0x78, 0x70, 0x69, 0x72, 0x79)
	if err != nil {
		return
	}
	err = en.WriteInt64(z.Expiry)
	if err != nil {
		err = msgp.WrapError(err, "Expiry")
		return
	}
	// write "success_redirect"
	err = en.Append(0xb0, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74)
	if err != nil {
		return
	}
	err = en.WriteString(z.SuccessRedirect)
	if err != nil {
		err = msgp.WrapError(err, "SuccessRedirect")
		return
	}
	// write "error_redirect"
	err = en.Append(0xae, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74)
	if err != nil {
		return
	}
	err = en.WriteString(z.ErrorRedirect)
	if err != nil {
		err = msgp.WrapError(err, "ErrorRedirect")
		return
	}
	// write "sms_message"
	err = en.Append(0xab, 0x73, 0x6d, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65)
	if err != nil {
		return
	}
	err = z.SMSMessage.EncodeMsg(en)
	if err != nil {
		err = msgp.WrapError(err, "SMSMessage")
		return
	}
	// write "email_message"
	err = en.Append(0xad, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65)
	if err != nil {
		return
	}
	err = z.EmailMessage.EncodeMsg(en)
	if err != nil {
		err = msgp.WrapError(err, "EmailMessage")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *UserVerificationKeyConfiguration) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 7
	// string "key"
	o = append(o, 0x87, 0xa3, 0x6b, 0x65, 0x79)
	o = msgp.AppendString(o, z.Key)
	// string "code_format"
	o = append(o, 0xab, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74)
	o = msgp.AppendString(o, string(z.CodeFormat))
	// string "expiry"
	o = append(o, 0xa6, 0x65, 0x78, 0x70, 0x69, 0x72, 0x79)
	o = msgp.AppendInt64(o, z.Expiry)
	// string "success_redirect"
	o = append(o, 0xb0, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74)
	o = msgp.AppendString(o, z.SuccessRedirect)
	// string "error_redirect"
	o = append(o, 0xae, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74)
	o = msgp.AppendString(o, z.ErrorRedirect)
	// string "sms_message"
	o = append(o, 0xab, 0x73, 0x6d, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65)
	o, err = z.SMSMessage.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "SMSMessage")
		return
	}
	// string "email_message"
	o = append(o, 0xad, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65)
	o, err = z.EmailMessage.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "EmailMessage")
		return
	}
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *UserVerificationKeyConfiguration) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "key":
			z.Key, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Key")
				return
			}
		case "code_format":
			{
				var zb0002 string
				zb0002, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "CodeFormat")
					return
				}
				z.CodeFormat = UserVerificationCodeFormat(zb0002)
			}
		case "expiry":
			z.Expiry, bts, err = msgp.ReadInt64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Expiry")
				return
			}
		case "success_redirect":
			z.SuccessRedirect, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "SuccessRedirect")
				return
			}
		case "error_redirect":
			z.ErrorRedirect, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "ErrorRedirect")
				return
			}
		case "sms_message":
			bts, err = z.SMSMessage.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "SMSMessage")
				return
			}
		case "email_message":
			bts, err = z.EmailMessage.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "EmailMessage")
				return
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *UserVerificationKeyConfiguration) Msgsize() (s int) {
	s = 1 + 4 + msgp.StringPrefixSize + len(z.Key) + 12 + msgp.StringPrefixSize + len(string(z.CodeFormat)) + 7 + msgp.Int64Size + 17 + msgp.StringPrefixSize + len(z.SuccessRedirect) + 15 + msgp.StringPrefixSize + len(z.ErrorRedirect) + 12 + z.SMSMessage.Msgsize() + 14 + z.EmailMessage.Msgsize()
	return
}

// DecodeMsg implements msgp.Decodable
func (z *WelcomeMessageConfiguration) DecodeMsg(dc *msgp.Reader) (err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, err = dc.ReadMapHeader()
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, err = dc.ReadMapKeyPtr()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "enabled":
			z.Enabled, err = dc.ReadBool()
			if err != nil {
				err = msgp.WrapError(err, "Enabled")
				return
			}
		case "email_message":
			err = z.EmailMessage.DecodeMsg(dc)
			if err != nil {
				err = msgp.WrapError(err, "EmailMessage")
				return
			}
		case "destination":
			{
				var zb0002 string
				zb0002, err = dc.ReadString()
				if err != nil {
					err = msgp.WrapError(err, "Destination")
					return
				}
				z.Destination = WelcomeMessageDestination(zb0002)
			}
		default:
			err = dc.Skip()
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z *WelcomeMessageConfiguration) EncodeMsg(en *msgp.Writer) (err error) {
	// map header, size 3
	// write "enabled"
	err = en.Append(0x83, 0xa7, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64)
	if err != nil {
		return
	}
	err = en.WriteBool(z.Enabled)
	if err != nil {
		err = msgp.WrapError(err, "Enabled")
		return
	}
	// write "email_message"
	err = en.Append(0xad, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65)
	if err != nil {
		return
	}
	err = z.EmailMessage.EncodeMsg(en)
	if err != nil {
		err = msgp.WrapError(err, "EmailMessage")
		return
	}
	// write "destination"
	err = en.Append(0xab, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e)
	if err != nil {
		return
	}
	err = en.WriteString(string(z.Destination))
	if err != nil {
		err = msgp.WrapError(err, "Destination")
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *WelcomeMessageConfiguration) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 3
	// string "enabled"
	o = append(o, 0x83, 0xa7, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64)
	o = msgp.AppendBool(o, z.Enabled)
	// string "email_message"
	o = append(o, 0xad, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65)
	o, err = z.EmailMessage.MarshalMsg(o)
	if err != nil {
		err = msgp.WrapError(err, "EmailMessage")
		return
	}
	// string "destination"
	o = append(o, 0xab, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e)
	o = msgp.AppendString(o, string(z.Destination))
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *WelcomeMessageConfiguration) UnmarshalMsg(bts []byte) (o []byte, err error) {
	var field []byte
	_ = field
	var zb0001 uint32
	zb0001, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	for zb0001 > 0 {
		zb0001--
		field, bts, err = msgp.ReadMapKeyZC(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		switch msgp.UnsafeString(field) {
		case "enabled":
			z.Enabled, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "Enabled")
				return
			}
		case "email_message":
			bts, err = z.EmailMessage.UnmarshalMsg(bts)
			if err != nil {
				err = msgp.WrapError(err, "EmailMessage")
				return
			}
		case "destination":
			{
				var zb0002 string
				zb0002, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Destination")
					return
				}
				z.Destination = WelcomeMessageDestination(zb0002)
			}
		default:
			bts, err = msgp.Skip(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
		}
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *WelcomeMessageConfiguration) Msgsize() (s int) {
	s = 1 + 8 + msgp.BoolSize + 14 + z.EmailMessage.Msgsize() + 12 + msgp.StringPrefixSize + len(string(z.Destination))
	return
}

// DecodeMsg implements msgp.Decodable
func (z *WelcomeMessageDestination) DecodeMsg(dc *msgp.Reader) (err error) {
	{
		var zb0001 string
		zb0001, err = dc.ReadString()
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = WelcomeMessageDestination(zb0001)
	}
	return
}

// EncodeMsg implements msgp.Encodable
func (z WelcomeMessageDestination) EncodeMsg(en *msgp.Writer) (err error) {
	err = en.WriteString(string(z))
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	return
}

// MarshalMsg implements msgp.Marshaler
func (z WelcomeMessageDestination) MarshalMsg(b []byte) (o []byte, err error) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendString(o, string(z))
	return
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *WelcomeMessageDestination) UnmarshalMsg(bts []byte) (o []byte, err error) {
	{
		var zb0001 string
		zb0001, bts, err = msgp.ReadStringBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = WelcomeMessageDestination(zb0001)
	}
	o = bts
	return
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z WelcomeMessageDestination) Msgsize() (s int) {
	s = msgp.StringPrefixSize + len(string(z))
	return
}
