// Code generated by Wire. DO NOT EDIT.

//go:generate wire
//+build !wireinject

package task

import (
	"context"
	"github.com/skygeario/skygear-server/pkg/auth"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/authenticator/password"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/identity/anonymous"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/identity/loginid"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/identity/oauth"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/identity/provider"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/user"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/userprofile"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/userverify"
	"github.com/skygeario/skygear-server/pkg/core/async"
	"github.com/skygeario/skygear-server/pkg/core/auth/authinfo/pq"
	"github.com/skygeario/skygear-server/pkg/core/db"
	"github.com/skygeario/skygear-server/pkg/core/logging"
	"github.com/skygeario/skygear-server/pkg/core/mail"
	"github.com/skygeario/skygear-server/pkg/core/sms"
	"github.com/skygeario/skygear-server/pkg/core/time"
)

// Injectors from wire.go:

func newVerifyCodeSendTask(ctx context.Context, m auth.DependencyMap) async.Task {
	tenantConfiguration := auth.ProvideTenantConfig(ctx, m)
	engine := auth.ProvideTemplateEngine(tenantConfiguration, m)
	sender := mail.ProvideMailSender(ctx, tenantConfiguration)
	client := sms.ProvideSMSClient(ctx, tenantConfiguration)
	codeSenderFactory := userverify.NewDefaultUserVerifyCodeSenderFactory(tenantConfiguration, engine, sender, client)
	sqlBuilderFactory := db.ProvideSQLBuilderFactory(tenantConfiguration)
	sqlExecutor := db.ProvideSQLExecutor(ctx, tenantConfiguration)
	store := pq.ProvideStore(sqlBuilderFactory, sqlExecutor)
	timeProvider := time.NewProvider()
	sqlBuilder := auth.ProvideAuthSQLBuilder(sqlBuilderFactory)
	userprofileStore := userprofile.ProvideStore(timeProvider, sqlBuilder, sqlExecutor)
	reservedNameChecker := auth.ProvideReservedNameChecker(m)
	typeCheckerFactory := loginid.ProvideTypeCheckerFactory(tenantConfiguration, reservedNameChecker)
	checker := loginid.ProvideChecker(tenantConfiguration, typeCheckerFactory)
	normalizerFactory := loginid.ProvideNormalizerFactory(tenantConfiguration)
	loginidProvider := loginid.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration, checker, normalizerFactory)
	oauthProvider := oauth.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider)
	anonymousProvider := anonymous.ProvideProvider(sqlBuilder, sqlExecutor)
	providerProvider := provider.ProvideProvider(tenantConfiguration, loginidProvider, oauthProvider, anonymousProvider)
	queries := &user.Queries{
		AuthInfos:    store,
		UserProfiles: userprofileStore,
		Identities:   providerProvider,
		Time:         timeProvider,
	}
	userverifyProvider := userverify.ProvideProvider(tenantConfiguration, timeProvider, sqlBuilder, sqlExecutor)
	txContext := db.ProvideTxContext(ctx, tenantConfiguration)
	factory := logging.ProvideLoggerFactory(ctx, tenantConfiguration)
	verifyCodeSendTask := &VerifyCodeSendTask{
		CodeSenderFactory:        codeSenderFactory,
		Users:                    queries,
		UserVerificationProvider: userverifyProvider,
		LoginIDProvider:          loginidProvider,
		TxContext:                txContext,
		LoggerFactory:            factory,
	}
	return verifyCodeSendTask
}

func newPwHouseKeeperTask(ctx context.Context, m auth.DependencyMap) async.Task {
	tenantConfiguration := auth.ProvideTenantConfig(ctx, m)
	txContext := db.ProvideTxContext(ctx, tenantConfiguration)
	factory := logging.ProvideLoggerFactory(ctx, tenantConfiguration)
	timeProvider := time.NewProvider()
	sqlBuilderFactory := db.ProvideSQLBuilderFactory(tenantConfiguration)
	sqlBuilder := auth.ProvideAuthSQLBuilder(sqlBuilderFactory)
	sqlExecutor := db.ProvideSQLExecutor(ctx, tenantConfiguration)
	historyStoreImpl := password.ProvideHistoryStore(timeProvider, sqlBuilder, sqlExecutor)
	housekeeper := password.ProvideHousekeeper(historyStoreImpl, factory, tenantConfiguration)
	pwHousekeeperTask := &PwHousekeeperTask{
		TxContext:     txContext,
		LoggerFactory: factory,
		PwHousekeeper: housekeeper,
	}
	return pwHousekeeperTask
}

func newSendMessagesTask(ctx context.Context, m auth.DependencyMap) async.Task {
	tenantConfiguration := auth.ProvideTenantConfig(ctx, m)
	sender := mail.ProvideMailSender(ctx, tenantConfiguration)
	client := sms.ProvideSMSClient(ctx, tenantConfiguration)
	factory := logging.ProvideLoggerFactory(ctx, tenantConfiguration)
	sendMessagesTask := &SendMessagesTask{
		EmailSender:   sender,
		SMSClient:     client,
		LoggerFactory: factory,
	}
	return sendMessagesTask
}
