// Code generated by Wire. DO NOT EDIT.

//go:generate wire
//+build !wireinject

package webapp

import (
	"github.com/google/wire"
	"github.com/skygeario/skygear-server/pkg/auth"
	auth2 "github.com/skygeario/skygear-server/pkg/auth/dependency/auth"
	redis3 "github.com/skygeario/skygear-server/pkg/auth/dependency/auth/redis"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/authenticator/bearertoken"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/authenticator/oob"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/authenticator/password"
	provider2 "github.com/skygeario/skygear-server/pkg/auth/dependency/authenticator/provider"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/authenticator/recoverycode"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/authenticator/totp"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/challenge"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/forgotpassword"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/hook"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/identity/anonymous"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/identity/loginid"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/identity/oauth"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/identity/provider"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/interaction"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/interaction/flows"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/interaction/redis"
	oauth2 "github.com/skygeario/skygear-server/pkg/auth/dependency/oauth"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/oauth/handler"
	pq2 "github.com/skygeario/skygear-server/pkg/auth/dependency/oauth/pq"
	redis2 "github.com/skygeario/skygear-server/pkg/auth/dependency/oauth/redis"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/oidc"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/session"
	redis4 "github.com/skygeario/skygear-server/pkg/auth/dependency/session/redis"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/sso"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/urlprefix"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/user"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/userprofile"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/webapp"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/welcomemessage"
	"github.com/skygeario/skygear-server/pkg/core/async"
	"github.com/skygeario/skygear-server/pkg/core/auth/authinfo/pq"
	"github.com/skygeario/skygear-server/pkg/core/db"
	"github.com/skygeario/skygear-server/pkg/core/logging"
	"github.com/skygeario/skygear-server/pkg/core/time"
	"net/http"
)

// Injectors from wire.go:

func newLoginHandler(r *http.Request, m auth.DependencyMap) http.Handler {
	context := auth.ProvideContext(r)
	tenantConfiguration := auth.ProvideTenantConfig(context, m)
	validateProvider := webapp.ProvideValidateProvider(tenantConfiguration)
	staticAssetURLPrefix := auth.ProvideStaticAssetURLPrefix(m)
	engine := auth.ProvideTemplateEngine(tenantConfiguration, m)
	timeProvider := time.NewProvider()
	sqlBuilderFactory := db.ProvideSQLBuilderFactory(tenantConfiguration)
	sqlBuilder := auth.ProvideAuthSQLBuilder(sqlBuilderFactory)
	sqlExecutor := db.ProvideSQLExecutor(context, tenantConfiguration)
	historyStoreImpl := password.ProvideHistoryStore(timeProvider, sqlBuilder, sqlExecutor)
	checker := password.ProvideChecker(tenantConfiguration, historyStoreImpl)
	reservedNameChecker := auth.ProvideReservedNameChecker(m)
	typeCheckerFactory := loginid.ProvideTypeCheckerFactory(tenantConfiguration, reservedNameChecker)
	loginidChecker := loginid.ProvideChecker(tenantConfiguration, typeCheckerFactory)
	normalizerFactory := loginid.ProvideNormalizerFactory(tenantConfiguration)
	loginidProvider := loginid.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration, loginidChecker, normalizerFactory)
	oauthProvider := oauth.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider)
	anonymousProvider := anonymous.ProvideProvider(sqlBuilder, sqlExecutor)
	providerProvider := provider.ProvideProvider(tenantConfiguration, loginidProvider, oauthProvider, anonymousProvider)
	renderProvider := webapp.ProvideRenderProvider(staticAssetURLPrefix, tenantConfiguration, engine, checker, providerProvider)
	stateStoreImpl := &webapp.StateStoreImpl{
		Context: context,
	}
	stateProviderImpl := &webapp.StateProviderImpl{
		StateStore: stateStoreImpl,
	}
	stateCodec := sso.ProvideStateCodec(tenantConfiguration)
	store := pq.ProvideStore(sqlBuilderFactory, sqlExecutor)
	userprofileStore := userprofile.ProvideStore(timeProvider, sqlBuilder, sqlExecutor)
	queries := &user.Queries{
		AuthInfos:    store,
		UserProfiles: userprofileStore,
		Identities:   providerProvider,
		Time:         timeProvider,
	}
	txContext := db.ProvideTxContext(context, tenantConfiguration)
	factory := logging.ProvideLoggerFactory(context, tenantConfiguration)
	hookProvider := hook.ProvideHookProvider(context, sqlBuilder, sqlExecutor, tenantConfiguration, txContext, timeProvider, queries, store, userprofileStore, loginidProvider, factory)
	redisStore := redis.ProvideStore(context, tenantConfiguration, timeProvider)
	passwordProvider := password.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, factory, historyStoreImpl, checker, tenantConfiguration)
	totpProvider := totp.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	urlprefixProvider := urlprefix.NewProvider(r)
	executor := auth.ProvideTaskExecutor(m)
	queue := async.ProvideTaskQueue(context, txContext, tenantConfiguration, executor)
	oobProvider := oob.ProvideProvider(context, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider, engine, urlprefixProvider, queue)
	bearertokenProvider := bearertoken.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	recoverycodeProvider := recoverycode.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	provider3 := &provider2.Provider{
		Password:     passwordProvider,
		TOTP:         totpProvider,
		OOBOTP:       oobProvider,
		BearerToken:  bearertokenProvider,
		RecoveryCode: recoverycodeProvider,
	}
	welcomemessageProvider := welcomemessage.ProvideProvider(context, tenantConfiguration, engine, queue)
	commands := user.ProvideCommands(store, userprofileStore, timeProvider, hookProvider, urlprefixProvider, queue, tenantConfiguration, welcomemessageProvider)
	userProvider := &user.Provider{
		Commands: commands,
		Queries:  queries,
	}
	interactionProvider := interaction.ProvideProvider(redisStore, timeProvider, factory, providerProvider, provider3, userProvider, oobProvider, tenantConfiguration, hookProvider)
	authorizationStore := &pq2.AuthorizationStore{
		SQLBuilder:  sqlBuilder,
		SQLExecutor: sqlExecutor,
	}
	grantStore := redis2.ProvideGrantStore(context, factory, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider)
	eventStore := redis3.ProvideEventStore(context, tenantConfiguration)
	accessEventProvider := auth2.AccessEventProvider{
		Store: eventStore,
	}
	sessionStore := redis4.ProvideStore(context, tenantConfiguration, timeProvider, factory)
	authAccessEventProvider := &auth2.AccessEventProvider{
		Store: eventStore,
	}
	sessionProvider := session.ProvideSessionProvider(r, sessionStore, authAccessEventProvider, tenantConfiguration)
	isAnonymousIdentityEnabled := flows.ProvideIsAnonymousIdentityEnabled(tenantConfiguration)
	challengeProvider := challenge.ProvideProvider(context, timeProvider, tenantConfiguration)
	anonymousFlow := &flows.AnonymousFlow{
		Enabled:      isAnonymousIdentityEnabled,
		Interactions: interactionProvider,
		Anonymous:    anonymousProvider,
		Challenges:   challengeProvider,
	}
	idTokenIssuer := oidc.ProvideIDTokenIssuer(tenantConfiguration, urlprefixProvider, queries, timeProvider)
	tokenGenerator := _wireTokenGeneratorValue
	tokenHandler := handler.ProvideTokenHandler(r, tenantConfiguration, factory, authorizationStore, grantStore, grantStore, grantStore, accessEventProvider, sessionProvider, anonymousFlow, idTokenIssuer, tokenGenerator, timeProvider)
	insecureCookieConfig := auth.ProvideSessionInsecureCookieConfig(m)
	cookieConfiguration := session.ProvideSessionCookieConfiguration(r, insecureCookieConfig, tenantConfiguration)
	userController := flows.ProvideUserController(store, queries, tokenHandler, cookieConfiguration, sessionProvider, hookProvider, timeProvider, tenantConfiguration)
	webAppFlow := flows.ProvideWebAppFlow(tenantConfiguration, providerProvider, queries, hookProvider, interactionProvider, userController)
	redirectURLFunc := provideRedirectURIForWebAppFunc()
	oAuthProviderFactory := sso.ProvideOAuthProviderFactory(tenantConfiguration, urlprefixProvider, timeProvider, normalizerFactory, redirectURLFunc)
	authenticateProviderImpl := &webapp.AuthenticateProviderImpl{
		ValidateProvider:     validateProvider,
		RenderProvider:       renderProvider,
		StateProvider:        stateProviderImpl,
		SSOStateCodec:        stateCodec,
		Interactions:         webAppFlow,
		OAuthProviderFactory: oAuthProviderFactory,
	}
	loginHandler := &LoginHandler{
		Provider:  authenticateProviderImpl,
		TxContext: txContext,
	}
	return loginHandler
}

var (
	_wireTokenGeneratorValue = handler.TokenGenerator(oauth2.GenerateToken)
)

func newEnterPasswordHandler(r *http.Request, m auth.DependencyMap) http.Handler {
	context := auth.ProvideContext(r)
	tenantConfiguration := auth.ProvideTenantConfig(context, m)
	validateProvider := webapp.ProvideValidateProvider(tenantConfiguration)
	staticAssetURLPrefix := auth.ProvideStaticAssetURLPrefix(m)
	engine := auth.ProvideTemplateEngine(tenantConfiguration, m)
	timeProvider := time.NewProvider()
	sqlBuilderFactory := db.ProvideSQLBuilderFactory(tenantConfiguration)
	sqlBuilder := auth.ProvideAuthSQLBuilder(sqlBuilderFactory)
	sqlExecutor := db.ProvideSQLExecutor(context, tenantConfiguration)
	historyStoreImpl := password.ProvideHistoryStore(timeProvider, sqlBuilder, sqlExecutor)
	checker := password.ProvideChecker(tenantConfiguration, historyStoreImpl)
	reservedNameChecker := auth.ProvideReservedNameChecker(m)
	typeCheckerFactory := loginid.ProvideTypeCheckerFactory(tenantConfiguration, reservedNameChecker)
	loginidChecker := loginid.ProvideChecker(tenantConfiguration, typeCheckerFactory)
	normalizerFactory := loginid.ProvideNormalizerFactory(tenantConfiguration)
	loginidProvider := loginid.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration, loginidChecker, normalizerFactory)
	oauthProvider := oauth.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider)
	anonymousProvider := anonymous.ProvideProvider(sqlBuilder, sqlExecutor)
	providerProvider := provider.ProvideProvider(tenantConfiguration, loginidProvider, oauthProvider, anonymousProvider)
	renderProvider := webapp.ProvideRenderProvider(staticAssetURLPrefix, tenantConfiguration, engine, checker, providerProvider)
	stateStoreImpl := &webapp.StateStoreImpl{
		Context: context,
	}
	stateProviderImpl := &webapp.StateProviderImpl{
		StateStore: stateStoreImpl,
	}
	stateCodec := sso.ProvideStateCodec(tenantConfiguration)
	store := pq.ProvideStore(sqlBuilderFactory, sqlExecutor)
	userprofileStore := userprofile.ProvideStore(timeProvider, sqlBuilder, sqlExecutor)
	queries := &user.Queries{
		AuthInfos:    store,
		UserProfiles: userprofileStore,
		Identities:   providerProvider,
		Time:         timeProvider,
	}
	txContext := db.ProvideTxContext(context, tenantConfiguration)
	factory := logging.ProvideLoggerFactory(context, tenantConfiguration)
	hookProvider := hook.ProvideHookProvider(context, sqlBuilder, sqlExecutor, tenantConfiguration, txContext, timeProvider, queries, store, userprofileStore, loginidProvider, factory)
	redisStore := redis.ProvideStore(context, tenantConfiguration, timeProvider)
	passwordProvider := password.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, factory, historyStoreImpl, checker, tenantConfiguration)
	totpProvider := totp.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	urlprefixProvider := urlprefix.NewProvider(r)
	executor := auth.ProvideTaskExecutor(m)
	queue := async.ProvideTaskQueue(context, txContext, tenantConfiguration, executor)
	oobProvider := oob.ProvideProvider(context, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider, engine, urlprefixProvider, queue)
	bearertokenProvider := bearertoken.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	recoverycodeProvider := recoverycode.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	provider3 := &provider2.Provider{
		Password:     passwordProvider,
		TOTP:         totpProvider,
		OOBOTP:       oobProvider,
		BearerToken:  bearertokenProvider,
		RecoveryCode: recoverycodeProvider,
	}
	welcomemessageProvider := welcomemessage.ProvideProvider(context, tenantConfiguration, engine, queue)
	commands := user.ProvideCommands(store, userprofileStore, timeProvider, hookProvider, urlprefixProvider, queue, tenantConfiguration, welcomemessageProvider)
	userProvider := &user.Provider{
		Commands: commands,
		Queries:  queries,
	}
	interactionProvider := interaction.ProvideProvider(redisStore, timeProvider, factory, providerProvider, provider3, userProvider, oobProvider, tenantConfiguration, hookProvider)
	authorizationStore := &pq2.AuthorizationStore{
		SQLBuilder:  sqlBuilder,
		SQLExecutor: sqlExecutor,
	}
	grantStore := redis2.ProvideGrantStore(context, factory, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider)
	eventStore := redis3.ProvideEventStore(context, tenantConfiguration)
	accessEventProvider := auth2.AccessEventProvider{
		Store: eventStore,
	}
	sessionStore := redis4.ProvideStore(context, tenantConfiguration, timeProvider, factory)
	authAccessEventProvider := &auth2.AccessEventProvider{
		Store: eventStore,
	}
	sessionProvider := session.ProvideSessionProvider(r, sessionStore, authAccessEventProvider, tenantConfiguration)
	isAnonymousIdentityEnabled := flows.ProvideIsAnonymousIdentityEnabled(tenantConfiguration)
	challengeProvider := challenge.ProvideProvider(context, timeProvider, tenantConfiguration)
	anonymousFlow := &flows.AnonymousFlow{
		Enabled:      isAnonymousIdentityEnabled,
		Interactions: interactionProvider,
		Anonymous:    anonymousProvider,
		Challenges:   challengeProvider,
	}
	idTokenIssuer := oidc.ProvideIDTokenIssuer(tenantConfiguration, urlprefixProvider, queries, timeProvider)
	tokenGenerator := _wireTokenGeneratorValue
	tokenHandler := handler.ProvideTokenHandler(r, tenantConfiguration, factory, authorizationStore, grantStore, grantStore, grantStore, accessEventProvider, sessionProvider, anonymousFlow, idTokenIssuer, tokenGenerator, timeProvider)
	insecureCookieConfig := auth.ProvideSessionInsecureCookieConfig(m)
	cookieConfiguration := session.ProvideSessionCookieConfiguration(r, insecureCookieConfig, tenantConfiguration)
	userController := flows.ProvideUserController(store, queries, tokenHandler, cookieConfiguration, sessionProvider, hookProvider, timeProvider, tenantConfiguration)
	webAppFlow := flows.ProvideWebAppFlow(tenantConfiguration, providerProvider, queries, hookProvider, interactionProvider, userController)
	redirectURLFunc := provideRedirectURIForWebAppFunc()
	oAuthProviderFactory := sso.ProvideOAuthProviderFactory(tenantConfiguration, urlprefixProvider, timeProvider, normalizerFactory, redirectURLFunc)
	authenticateProviderImpl := &webapp.AuthenticateProviderImpl{
		ValidateProvider:     validateProvider,
		RenderProvider:       renderProvider,
		StateProvider:        stateProviderImpl,
		SSOStateCodec:        stateCodec,
		Interactions:         webAppFlow,
		OAuthProviderFactory: oAuthProviderFactory,
	}
	enterPasswordHandler := &EnterPasswordHandler{
		Provider:  authenticateProviderImpl,
		TxContext: txContext,
	}
	return enterPasswordHandler
}

func newForgotPasswordHandler(r *http.Request, m auth.DependencyMap) http.Handler {
	context := auth.ProvideContext(r)
	tenantConfiguration := auth.ProvideTenantConfig(context, m)
	validateProvider := webapp.ProvideValidateProvider(tenantConfiguration)
	staticAssetURLPrefix := auth.ProvideStaticAssetURLPrefix(m)
	engine := auth.ProvideTemplateEngine(tenantConfiguration, m)
	timeProvider := time.NewProvider()
	sqlBuilderFactory := db.ProvideSQLBuilderFactory(tenantConfiguration)
	sqlBuilder := auth.ProvideAuthSQLBuilder(sqlBuilderFactory)
	sqlExecutor := db.ProvideSQLExecutor(context, tenantConfiguration)
	historyStoreImpl := password.ProvideHistoryStore(timeProvider, sqlBuilder, sqlExecutor)
	checker := password.ProvideChecker(tenantConfiguration, historyStoreImpl)
	reservedNameChecker := auth.ProvideReservedNameChecker(m)
	typeCheckerFactory := loginid.ProvideTypeCheckerFactory(tenantConfiguration, reservedNameChecker)
	loginidChecker := loginid.ProvideChecker(tenantConfiguration, typeCheckerFactory)
	normalizerFactory := loginid.ProvideNormalizerFactory(tenantConfiguration)
	loginidProvider := loginid.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration, loginidChecker, normalizerFactory)
	oauthProvider := oauth.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider)
	anonymousProvider := anonymous.ProvideProvider(sqlBuilder, sqlExecutor)
	providerProvider := provider.ProvideProvider(tenantConfiguration, loginidProvider, oauthProvider, anonymousProvider)
	renderProvider := webapp.ProvideRenderProvider(staticAssetURLPrefix, tenantConfiguration, engine, checker, providerProvider)
	stateStoreImpl := &webapp.StateStoreImpl{
		Context: context,
	}
	stateProviderImpl := &webapp.StateProviderImpl{
		StateStore: stateStoreImpl,
	}
	storeImpl := &forgotpassword.StoreImpl{
		Context: context,
	}
	store := pq.ProvideStore(sqlBuilderFactory, sqlExecutor)
	userprofileStore := userprofile.ProvideStore(timeProvider, sqlBuilder, sqlExecutor)
	queries := &user.Queries{
		AuthInfos:    store,
		UserProfiles: userprofileStore,
		Identities:   providerProvider,
		Time:         timeProvider,
	}
	txContext := db.ProvideTxContext(context, tenantConfiguration)
	factory := logging.ProvideLoggerFactory(context, tenantConfiguration)
	hookProvider := hook.ProvideHookProvider(context, sqlBuilder, sqlExecutor, tenantConfiguration, txContext, timeProvider, queries, store, userprofileStore, loginidProvider, factory)
	urlprefixProvider := urlprefix.NewProvider(r)
	executor := auth.ProvideTaskExecutor(m)
	queue := async.ProvideTaskQueue(context, txContext, tenantConfiguration, executor)
	redisStore := redis.ProvideStore(context, tenantConfiguration, timeProvider)
	passwordProvider := password.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, factory, historyStoreImpl, checker, tenantConfiguration)
	totpProvider := totp.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	oobProvider := oob.ProvideProvider(context, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider, engine, urlprefixProvider, queue)
	bearertokenProvider := bearertoken.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	recoverycodeProvider := recoverycode.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	provider3 := &provider2.Provider{
		Password:     passwordProvider,
		TOTP:         totpProvider,
		OOBOTP:       oobProvider,
		BearerToken:  bearertokenProvider,
		RecoveryCode: recoverycodeProvider,
	}
	welcomemessageProvider := welcomemessage.ProvideProvider(context, tenantConfiguration, engine, queue)
	commands := user.ProvideCommands(store, userprofileStore, timeProvider, hookProvider, urlprefixProvider, queue, tenantConfiguration, welcomemessageProvider)
	userProvider := &user.Provider{
		Commands: commands,
		Queries:  queries,
	}
	interactionProvider := interaction.ProvideProvider(redisStore, timeProvider, factory, providerProvider, provider3, userProvider, oobProvider, tenantConfiguration, hookProvider)
	passwordFlow := &flows.PasswordFlow{
		Interactions: interactionProvider,
	}
	forgotpasswordProvider := forgotpassword.ProvideProvider(context, staticAssetURLPrefix, tenantConfiguration, storeImpl, queries, hookProvider, timeProvider, urlprefixProvider, engine, queue, passwordFlow, loginidProvider)
	webappForgotPasswordProvider := &webapp.ForgotPasswordProvider{
		ValidateProvider: validateProvider,
		RenderProvider:   renderProvider,
		StateProvider:    stateProviderImpl,
		ForgotPassword:   forgotpasswordProvider,
	}
	forgotPasswordHandler := &ForgotPasswordHandler{
		Provider:  webappForgotPasswordProvider,
		TxContext: txContext,
	}
	return forgotPasswordHandler
}

func newForgotPasswordSuccessHandler(r *http.Request, m auth.DependencyMap) http.Handler {
	context := auth.ProvideContext(r)
	tenantConfiguration := auth.ProvideTenantConfig(context, m)
	validateProvider := webapp.ProvideValidateProvider(tenantConfiguration)
	staticAssetURLPrefix := auth.ProvideStaticAssetURLPrefix(m)
	engine := auth.ProvideTemplateEngine(tenantConfiguration, m)
	timeProvider := time.NewProvider()
	sqlBuilderFactory := db.ProvideSQLBuilderFactory(tenantConfiguration)
	sqlBuilder := auth.ProvideAuthSQLBuilder(sqlBuilderFactory)
	sqlExecutor := db.ProvideSQLExecutor(context, tenantConfiguration)
	historyStoreImpl := password.ProvideHistoryStore(timeProvider, sqlBuilder, sqlExecutor)
	checker := password.ProvideChecker(tenantConfiguration, historyStoreImpl)
	reservedNameChecker := auth.ProvideReservedNameChecker(m)
	typeCheckerFactory := loginid.ProvideTypeCheckerFactory(tenantConfiguration, reservedNameChecker)
	loginidChecker := loginid.ProvideChecker(tenantConfiguration, typeCheckerFactory)
	normalizerFactory := loginid.ProvideNormalizerFactory(tenantConfiguration)
	loginidProvider := loginid.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration, loginidChecker, normalizerFactory)
	oauthProvider := oauth.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider)
	anonymousProvider := anonymous.ProvideProvider(sqlBuilder, sqlExecutor)
	providerProvider := provider.ProvideProvider(tenantConfiguration, loginidProvider, oauthProvider, anonymousProvider)
	renderProvider := webapp.ProvideRenderProvider(staticAssetURLPrefix, tenantConfiguration, engine, checker, providerProvider)
	stateStoreImpl := &webapp.StateStoreImpl{
		Context: context,
	}
	stateProviderImpl := &webapp.StateProviderImpl{
		StateStore: stateStoreImpl,
	}
	storeImpl := &forgotpassword.StoreImpl{
		Context: context,
	}
	store := pq.ProvideStore(sqlBuilderFactory, sqlExecutor)
	userprofileStore := userprofile.ProvideStore(timeProvider, sqlBuilder, sqlExecutor)
	queries := &user.Queries{
		AuthInfos:    store,
		UserProfiles: userprofileStore,
		Identities:   providerProvider,
		Time:         timeProvider,
	}
	txContext := db.ProvideTxContext(context, tenantConfiguration)
	factory := logging.ProvideLoggerFactory(context, tenantConfiguration)
	hookProvider := hook.ProvideHookProvider(context, sqlBuilder, sqlExecutor, tenantConfiguration, txContext, timeProvider, queries, store, userprofileStore, loginidProvider, factory)
	urlprefixProvider := urlprefix.NewProvider(r)
	executor := auth.ProvideTaskExecutor(m)
	queue := async.ProvideTaskQueue(context, txContext, tenantConfiguration, executor)
	redisStore := redis.ProvideStore(context, tenantConfiguration, timeProvider)
	passwordProvider := password.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, factory, historyStoreImpl, checker, tenantConfiguration)
	totpProvider := totp.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	oobProvider := oob.ProvideProvider(context, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider, engine, urlprefixProvider, queue)
	bearertokenProvider := bearertoken.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	recoverycodeProvider := recoverycode.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	provider3 := &provider2.Provider{
		Password:     passwordProvider,
		TOTP:         totpProvider,
		OOBOTP:       oobProvider,
		BearerToken:  bearertokenProvider,
		RecoveryCode: recoverycodeProvider,
	}
	welcomemessageProvider := welcomemessage.ProvideProvider(context, tenantConfiguration, engine, queue)
	commands := user.ProvideCommands(store, userprofileStore, timeProvider, hookProvider, urlprefixProvider, queue, tenantConfiguration, welcomemessageProvider)
	userProvider := &user.Provider{
		Commands: commands,
		Queries:  queries,
	}
	interactionProvider := interaction.ProvideProvider(redisStore, timeProvider, factory, providerProvider, provider3, userProvider, oobProvider, tenantConfiguration, hookProvider)
	passwordFlow := &flows.PasswordFlow{
		Interactions: interactionProvider,
	}
	forgotpasswordProvider := forgotpassword.ProvideProvider(context, staticAssetURLPrefix, tenantConfiguration, storeImpl, queries, hookProvider, timeProvider, urlprefixProvider, engine, queue, passwordFlow, loginidProvider)
	webappForgotPasswordProvider := &webapp.ForgotPasswordProvider{
		ValidateProvider: validateProvider,
		RenderProvider:   renderProvider,
		StateProvider:    stateProviderImpl,
		ForgotPassword:   forgotpasswordProvider,
	}
	forgotPasswordSuccessHandler := &ForgotPasswordSuccessHandler{
		Provider:  webappForgotPasswordProvider,
		TxContext: txContext,
	}
	return forgotPasswordSuccessHandler
}

func newResetPasswordHandler(r *http.Request, m auth.DependencyMap) http.Handler {
	context := auth.ProvideContext(r)
	tenantConfiguration := auth.ProvideTenantConfig(context, m)
	validateProvider := webapp.ProvideValidateProvider(tenantConfiguration)
	staticAssetURLPrefix := auth.ProvideStaticAssetURLPrefix(m)
	engine := auth.ProvideTemplateEngine(tenantConfiguration, m)
	timeProvider := time.NewProvider()
	sqlBuilderFactory := db.ProvideSQLBuilderFactory(tenantConfiguration)
	sqlBuilder := auth.ProvideAuthSQLBuilder(sqlBuilderFactory)
	sqlExecutor := db.ProvideSQLExecutor(context, tenantConfiguration)
	historyStoreImpl := password.ProvideHistoryStore(timeProvider, sqlBuilder, sqlExecutor)
	checker := password.ProvideChecker(tenantConfiguration, historyStoreImpl)
	reservedNameChecker := auth.ProvideReservedNameChecker(m)
	typeCheckerFactory := loginid.ProvideTypeCheckerFactory(tenantConfiguration, reservedNameChecker)
	loginidChecker := loginid.ProvideChecker(tenantConfiguration, typeCheckerFactory)
	normalizerFactory := loginid.ProvideNormalizerFactory(tenantConfiguration)
	loginidProvider := loginid.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration, loginidChecker, normalizerFactory)
	oauthProvider := oauth.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider)
	anonymousProvider := anonymous.ProvideProvider(sqlBuilder, sqlExecutor)
	providerProvider := provider.ProvideProvider(tenantConfiguration, loginidProvider, oauthProvider, anonymousProvider)
	renderProvider := webapp.ProvideRenderProvider(staticAssetURLPrefix, tenantConfiguration, engine, checker, providerProvider)
	stateStoreImpl := &webapp.StateStoreImpl{
		Context: context,
	}
	stateProviderImpl := &webapp.StateProviderImpl{
		StateStore: stateStoreImpl,
	}
	storeImpl := &forgotpassword.StoreImpl{
		Context: context,
	}
	store := pq.ProvideStore(sqlBuilderFactory, sqlExecutor)
	userprofileStore := userprofile.ProvideStore(timeProvider, sqlBuilder, sqlExecutor)
	queries := &user.Queries{
		AuthInfos:    store,
		UserProfiles: userprofileStore,
		Identities:   providerProvider,
		Time:         timeProvider,
	}
	txContext := db.ProvideTxContext(context, tenantConfiguration)
	factory := logging.ProvideLoggerFactory(context, tenantConfiguration)
	hookProvider := hook.ProvideHookProvider(context, sqlBuilder, sqlExecutor, tenantConfiguration, txContext, timeProvider, queries, store, userprofileStore, loginidProvider, factory)
	urlprefixProvider := urlprefix.NewProvider(r)
	executor := auth.ProvideTaskExecutor(m)
	queue := async.ProvideTaskQueue(context, txContext, tenantConfiguration, executor)
	redisStore := redis.ProvideStore(context, tenantConfiguration, timeProvider)
	passwordProvider := password.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, factory, historyStoreImpl, checker, tenantConfiguration)
	totpProvider := totp.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	oobProvider := oob.ProvideProvider(context, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider, engine, urlprefixProvider, queue)
	bearertokenProvider := bearertoken.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	recoverycodeProvider := recoverycode.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	provider3 := &provider2.Provider{
		Password:     passwordProvider,
		TOTP:         totpProvider,
		OOBOTP:       oobProvider,
		BearerToken:  bearertokenProvider,
		RecoveryCode: recoverycodeProvider,
	}
	welcomemessageProvider := welcomemessage.ProvideProvider(context, tenantConfiguration, engine, queue)
	commands := user.ProvideCommands(store, userprofileStore, timeProvider, hookProvider, urlprefixProvider, queue, tenantConfiguration, welcomemessageProvider)
	userProvider := &user.Provider{
		Commands: commands,
		Queries:  queries,
	}
	interactionProvider := interaction.ProvideProvider(redisStore, timeProvider, factory, providerProvider, provider3, userProvider, oobProvider, tenantConfiguration, hookProvider)
	passwordFlow := &flows.PasswordFlow{
		Interactions: interactionProvider,
	}
	forgotpasswordProvider := forgotpassword.ProvideProvider(context, staticAssetURLPrefix, tenantConfiguration, storeImpl, queries, hookProvider, timeProvider, urlprefixProvider, engine, queue, passwordFlow, loginidProvider)
	webappForgotPasswordProvider := &webapp.ForgotPasswordProvider{
		ValidateProvider: validateProvider,
		RenderProvider:   renderProvider,
		StateProvider:    stateProviderImpl,
		ForgotPassword:   forgotpasswordProvider,
	}
	resetPasswordHandler := &ResetPasswordHandler{
		Provider:  webappForgotPasswordProvider,
		TxContext: txContext,
	}
	return resetPasswordHandler
}

func newResetPasswordSuccessHandler(r *http.Request, m auth.DependencyMap) http.Handler {
	context := auth.ProvideContext(r)
	tenantConfiguration := auth.ProvideTenantConfig(context, m)
	validateProvider := webapp.ProvideValidateProvider(tenantConfiguration)
	staticAssetURLPrefix := auth.ProvideStaticAssetURLPrefix(m)
	engine := auth.ProvideTemplateEngine(tenantConfiguration, m)
	timeProvider := time.NewProvider()
	sqlBuilderFactory := db.ProvideSQLBuilderFactory(tenantConfiguration)
	sqlBuilder := auth.ProvideAuthSQLBuilder(sqlBuilderFactory)
	sqlExecutor := db.ProvideSQLExecutor(context, tenantConfiguration)
	historyStoreImpl := password.ProvideHistoryStore(timeProvider, sqlBuilder, sqlExecutor)
	checker := password.ProvideChecker(tenantConfiguration, historyStoreImpl)
	reservedNameChecker := auth.ProvideReservedNameChecker(m)
	typeCheckerFactory := loginid.ProvideTypeCheckerFactory(tenantConfiguration, reservedNameChecker)
	loginidChecker := loginid.ProvideChecker(tenantConfiguration, typeCheckerFactory)
	normalizerFactory := loginid.ProvideNormalizerFactory(tenantConfiguration)
	loginidProvider := loginid.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration, loginidChecker, normalizerFactory)
	oauthProvider := oauth.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider)
	anonymousProvider := anonymous.ProvideProvider(sqlBuilder, sqlExecutor)
	providerProvider := provider.ProvideProvider(tenantConfiguration, loginidProvider, oauthProvider, anonymousProvider)
	renderProvider := webapp.ProvideRenderProvider(staticAssetURLPrefix, tenantConfiguration, engine, checker, providerProvider)
	stateStoreImpl := &webapp.StateStoreImpl{
		Context: context,
	}
	stateProviderImpl := &webapp.StateProviderImpl{
		StateStore: stateStoreImpl,
	}
	storeImpl := &forgotpassword.StoreImpl{
		Context: context,
	}
	store := pq.ProvideStore(sqlBuilderFactory, sqlExecutor)
	userprofileStore := userprofile.ProvideStore(timeProvider, sqlBuilder, sqlExecutor)
	queries := &user.Queries{
		AuthInfos:    store,
		UserProfiles: userprofileStore,
		Identities:   providerProvider,
		Time:         timeProvider,
	}
	txContext := db.ProvideTxContext(context, tenantConfiguration)
	factory := logging.ProvideLoggerFactory(context, tenantConfiguration)
	hookProvider := hook.ProvideHookProvider(context, sqlBuilder, sqlExecutor, tenantConfiguration, txContext, timeProvider, queries, store, userprofileStore, loginidProvider, factory)
	urlprefixProvider := urlprefix.NewProvider(r)
	executor := auth.ProvideTaskExecutor(m)
	queue := async.ProvideTaskQueue(context, txContext, tenantConfiguration, executor)
	redisStore := redis.ProvideStore(context, tenantConfiguration, timeProvider)
	passwordProvider := password.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, factory, historyStoreImpl, checker, tenantConfiguration)
	totpProvider := totp.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	oobProvider := oob.ProvideProvider(context, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider, engine, urlprefixProvider, queue)
	bearertokenProvider := bearertoken.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	recoverycodeProvider := recoverycode.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	provider3 := &provider2.Provider{
		Password:     passwordProvider,
		TOTP:         totpProvider,
		OOBOTP:       oobProvider,
		BearerToken:  bearertokenProvider,
		RecoveryCode: recoverycodeProvider,
	}
	welcomemessageProvider := welcomemessage.ProvideProvider(context, tenantConfiguration, engine, queue)
	commands := user.ProvideCommands(store, userprofileStore, timeProvider, hookProvider, urlprefixProvider, queue, tenantConfiguration, welcomemessageProvider)
	userProvider := &user.Provider{
		Commands: commands,
		Queries:  queries,
	}
	interactionProvider := interaction.ProvideProvider(redisStore, timeProvider, factory, providerProvider, provider3, userProvider, oobProvider, tenantConfiguration, hookProvider)
	passwordFlow := &flows.PasswordFlow{
		Interactions: interactionProvider,
	}
	forgotpasswordProvider := forgotpassword.ProvideProvider(context, staticAssetURLPrefix, tenantConfiguration, storeImpl, queries, hookProvider, timeProvider, urlprefixProvider, engine, queue, passwordFlow, loginidProvider)
	webappForgotPasswordProvider := &webapp.ForgotPasswordProvider{
		ValidateProvider: validateProvider,
		RenderProvider:   renderProvider,
		StateProvider:    stateProviderImpl,
		ForgotPassword:   forgotpasswordProvider,
	}
	resetPasswordSuccessHandler := &ResetPasswordSuccessHandler{
		Provider:  webappForgotPasswordProvider,
		TxContext: txContext,
	}
	return resetPasswordSuccessHandler
}

func newSignupHandler(r *http.Request, m auth.DependencyMap) http.Handler {
	context := auth.ProvideContext(r)
	tenantConfiguration := auth.ProvideTenantConfig(context, m)
	validateProvider := webapp.ProvideValidateProvider(tenantConfiguration)
	staticAssetURLPrefix := auth.ProvideStaticAssetURLPrefix(m)
	engine := auth.ProvideTemplateEngine(tenantConfiguration, m)
	timeProvider := time.NewProvider()
	sqlBuilderFactory := db.ProvideSQLBuilderFactory(tenantConfiguration)
	sqlBuilder := auth.ProvideAuthSQLBuilder(sqlBuilderFactory)
	sqlExecutor := db.ProvideSQLExecutor(context, tenantConfiguration)
	historyStoreImpl := password.ProvideHistoryStore(timeProvider, sqlBuilder, sqlExecutor)
	checker := password.ProvideChecker(tenantConfiguration, historyStoreImpl)
	reservedNameChecker := auth.ProvideReservedNameChecker(m)
	typeCheckerFactory := loginid.ProvideTypeCheckerFactory(tenantConfiguration, reservedNameChecker)
	loginidChecker := loginid.ProvideChecker(tenantConfiguration, typeCheckerFactory)
	normalizerFactory := loginid.ProvideNormalizerFactory(tenantConfiguration)
	loginidProvider := loginid.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration, loginidChecker, normalizerFactory)
	oauthProvider := oauth.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider)
	anonymousProvider := anonymous.ProvideProvider(sqlBuilder, sqlExecutor)
	providerProvider := provider.ProvideProvider(tenantConfiguration, loginidProvider, oauthProvider, anonymousProvider)
	renderProvider := webapp.ProvideRenderProvider(staticAssetURLPrefix, tenantConfiguration, engine, checker, providerProvider)
	stateStoreImpl := &webapp.StateStoreImpl{
		Context: context,
	}
	stateProviderImpl := &webapp.StateProviderImpl{
		StateStore: stateStoreImpl,
	}
	stateCodec := sso.ProvideStateCodec(tenantConfiguration)
	store := pq.ProvideStore(sqlBuilderFactory, sqlExecutor)
	userprofileStore := userprofile.ProvideStore(timeProvider, sqlBuilder, sqlExecutor)
	queries := &user.Queries{
		AuthInfos:    store,
		UserProfiles: userprofileStore,
		Identities:   providerProvider,
		Time:         timeProvider,
	}
	txContext := db.ProvideTxContext(context, tenantConfiguration)
	factory := logging.ProvideLoggerFactory(context, tenantConfiguration)
	hookProvider := hook.ProvideHookProvider(context, sqlBuilder, sqlExecutor, tenantConfiguration, txContext, timeProvider, queries, store, userprofileStore, loginidProvider, factory)
	redisStore := redis.ProvideStore(context, tenantConfiguration, timeProvider)
	passwordProvider := password.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, factory, historyStoreImpl, checker, tenantConfiguration)
	totpProvider := totp.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	urlprefixProvider := urlprefix.NewProvider(r)
	executor := auth.ProvideTaskExecutor(m)
	queue := async.ProvideTaskQueue(context, txContext, tenantConfiguration, executor)
	oobProvider := oob.ProvideProvider(context, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider, engine, urlprefixProvider, queue)
	bearertokenProvider := bearertoken.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	recoverycodeProvider := recoverycode.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	provider3 := &provider2.Provider{
		Password:     passwordProvider,
		TOTP:         totpProvider,
		OOBOTP:       oobProvider,
		BearerToken:  bearertokenProvider,
		RecoveryCode: recoverycodeProvider,
	}
	welcomemessageProvider := welcomemessage.ProvideProvider(context, tenantConfiguration, engine, queue)
	commands := user.ProvideCommands(store, userprofileStore, timeProvider, hookProvider, urlprefixProvider, queue, tenantConfiguration, welcomemessageProvider)
	userProvider := &user.Provider{
		Commands: commands,
		Queries:  queries,
	}
	interactionProvider := interaction.ProvideProvider(redisStore, timeProvider, factory, providerProvider, provider3, userProvider, oobProvider, tenantConfiguration, hookProvider)
	authorizationStore := &pq2.AuthorizationStore{
		SQLBuilder:  sqlBuilder,
		SQLExecutor: sqlExecutor,
	}
	grantStore := redis2.ProvideGrantStore(context, factory, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider)
	eventStore := redis3.ProvideEventStore(context, tenantConfiguration)
	accessEventProvider := auth2.AccessEventProvider{
		Store: eventStore,
	}
	sessionStore := redis4.ProvideStore(context, tenantConfiguration, timeProvider, factory)
	authAccessEventProvider := &auth2.AccessEventProvider{
		Store: eventStore,
	}
	sessionProvider := session.ProvideSessionProvider(r, sessionStore, authAccessEventProvider, tenantConfiguration)
	isAnonymousIdentityEnabled := flows.ProvideIsAnonymousIdentityEnabled(tenantConfiguration)
	challengeProvider := challenge.ProvideProvider(context, timeProvider, tenantConfiguration)
	anonymousFlow := &flows.AnonymousFlow{
		Enabled:      isAnonymousIdentityEnabled,
		Interactions: interactionProvider,
		Anonymous:    anonymousProvider,
		Challenges:   challengeProvider,
	}
	idTokenIssuer := oidc.ProvideIDTokenIssuer(tenantConfiguration, urlprefixProvider, queries, timeProvider)
	tokenGenerator := _wireTokenGeneratorValue
	tokenHandler := handler.ProvideTokenHandler(r, tenantConfiguration, factory, authorizationStore, grantStore, grantStore, grantStore, accessEventProvider, sessionProvider, anonymousFlow, idTokenIssuer, tokenGenerator, timeProvider)
	insecureCookieConfig := auth.ProvideSessionInsecureCookieConfig(m)
	cookieConfiguration := session.ProvideSessionCookieConfiguration(r, insecureCookieConfig, tenantConfiguration)
	userController := flows.ProvideUserController(store, queries, tokenHandler, cookieConfiguration, sessionProvider, hookProvider, timeProvider, tenantConfiguration)
	webAppFlow := flows.ProvideWebAppFlow(tenantConfiguration, providerProvider, queries, hookProvider, interactionProvider, userController)
	redirectURLFunc := provideRedirectURIForWebAppFunc()
	oAuthProviderFactory := sso.ProvideOAuthProviderFactory(tenantConfiguration, urlprefixProvider, timeProvider, normalizerFactory, redirectURLFunc)
	authenticateProviderImpl := &webapp.AuthenticateProviderImpl{
		ValidateProvider:     validateProvider,
		RenderProvider:       renderProvider,
		StateProvider:        stateProviderImpl,
		SSOStateCodec:        stateCodec,
		Interactions:         webAppFlow,
		OAuthProviderFactory: oAuthProviderFactory,
	}
	signupHandler := &SignupHandler{
		Provider:  authenticateProviderImpl,
		TxContext: txContext,
	}
	return signupHandler
}

func newPromoteHandler(r *http.Request, m auth.DependencyMap) http.Handler {
	context := auth.ProvideContext(r)
	tenantConfiguration := auth.ProvideTenantConfig(context, m)
	validateProvider := webapp.ProvideValidateProvider(tenantConfiguration)
	staticAssetURLPrefix := auth.ProvideStaticAssetURLPrefix(m)
	engine := auth.ProvideTemplateEngine(tenantConfiguration, m)
	timeProvider := time.NewProvider()
	sqlBuilderFactory := db.ProvideSQLBuilderFactory(tenantConfiguration)
	sqlBuilder := auth.ProvideAuthSQLBuilder(sqlBuilderFactory)
	sqlExecutor := db.ProvideSQLExecutor(context, tenantConfiguration)
	historyStoreImpl := password.ProvideHistoryStore(timeProvider, sqlBuilder, sqlExecutor)
	checker := password.ProvideChecker(tenantConfiguration, historyStoreImpl)
	reservedNameChecker := auth.ProvideReservedNameChecker(m)
	typeCheckerFactory := loginid.ProvideTypeCheckerFactory(tenantConfiguration, reservedNameChecker)
	loginidChecker := loginid.ProvideChecker(tenantConfiguration, typeCheckerFactory)
	normalizerFactory := loginid.ProvideNormalizerFactory(tenantConfiguration)
	loginidProvider := loginid.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration, loginidChecker, normalizerFactory)
	oauthProvider := oauth.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider)
	anonymousProvider := anonymous.ProvideProvider(sqlBuilder, sqlExecutor)
	providerProvider := provider.ProvideProvider(tenantConfiguration, loginidProvider, oauthProvider, anonymousProvider)
	renderProvider := webapp.ProvideRenderProvider(staticAssetURLPrefix, tenantConfiguration, engine, checker, providerProvider)
	stateStoreImpl := &webapp.StateStoreImpl{
		Context: context,
	}
	stateProviderImpl := &webapp.StateProviderImpl{
		StateStore: stateStoreImpl,
	}
	stateCodec := sso.ProvideStateCodec(tenantConfiguration)
	store := pq.ProvideStore(sqlBuilderFactory, sqlExecutor)
	userprofileStore := userprofile.ProvideStore(timeProvider, sqlBuilder, sqlExecutor)
	queries := &user.Queries{
		AuthInfos:    store,
		UserProfiles: userprofileStore,
		Identities:   providerProvider,
		Time:         timeProvider,
	}
	txContext := db.ProvideTxContext(context, tenantConfiguration)
	factory := logging.ProvideLoggerFactory(context, tenantConfiguration)
	hookProvider := hook.ProvideHookProvider(context, sqlBuilder, sqlExecutor, tenantConfiguration, txContext, timeProvider, queries, store, userprofileStore, loginidProvider, factory)
	redisStore := redis.ProvideStore(context, tenantConfiguration, timeProvider)
	passwordProvider := password.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, factory, historyStoreImpl, checker, tenantConfiguration)
	totpProvider := totp.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	urlprefixProvider := urlprefix.NewProvider(r)
	executor := auth.ProvideTaskExecutor(m)
	queue := async.ProvideTaskQueue(context, txContext, tenantConfiguration, executor)
	oobProvider := oob.ProvideProvider(context, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider, engine, urlprefixProvider, queue)
	bearertokenProvider := bearertoken.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	recoverycodeProvider := recoverycode.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	provider3 := &provider2.Provider{
		Password:     passwordProvider,
		TOTP:         totpProvider,
		OOBOTP:       oobProvider,
		BearerToken:  bearertokenProvider,
		RecoveryCode: recoverycodeProvider,
	}
	welcomemessageProvider := welcomemessage.ProvideProvider(context, tenantConfiguration, engine, queue)
	commands := user.ProvideCommands(store, userprofileStore, timeProvider, hookProvider, urlprefixProvider, queue, tenantConfiguration, welcomemessageProvider)
	userProvider := &user.Provider{
		Commands: commands,
		Queries:  queries,
	}
	interactionProvider := interaction.ProvideProvider(redisStore, timeProvider, factory, providerProvider, provider3, userProvider, oobProvider, tenantConfiguration, hookProvider)
	authorizationStore := &pq2.AuthorizationStore{
		SQLBuilder:  sqlBuilder,
		SQLExecutor: sqlExecutor,
	}
	grantStore := redis2.ProvideGrantStore(context, factory, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider)
	eventStore := redis3.ProvideEventStore(context, tenantConfiguration)
	accessEventProvider := auth2.AccessEventProvider{
		Store: eventStore,
	}
	sessionStore := redis4.ProvideStore(context, tenantConfiguration, timeProvider, factory)
	authAccessEventProvider := &auth2.AccessEventProvider{
		Store: eventStore,
	}
	sessionProvider := session.ProvideSessionProvider(r, sessionStore, authAccessEventProvider, tenantConfiguration)
	isAnonymousIdentityEnabled := flows.ProvideIsAnonymousIdentityEnabled(tenantConfiguration)
	challengeProvider := challenge.ProvideProvider(context, timeProvider, tenantConfiguration)
	anonymousFlow := &flows.AnonymousFlow{
		Enabled:      isAnonymousIdentityEnabled,
		Interactions: interactionProvider,
		Anonymous:    anonymousProvider,
		Challenges:   challengeProvider,
	}
	idTokenIssuer := oidc.ProvideIDTokenIssuer(tenantConfiguration, urlprefixProvider, queries, timeProvider)
	tokenGenerator := _wireTokenGeneratorValue
	tokenHandler := handler.ProvideTokenHandler(r, tenantConfiguration, factory, authorizationStore, grantStore, grantStore, grantStore, accessEventProvider, sessionProvider, anonymousFlow, idTokenIssuer, tokenGenerator, timeProvider)
	insecureCookieConfig := auth.ProvideSessionInsecureCookieConfig(m)
	cookieConfiguration := session.ProvideSessionCookieConfiguration(r, insecureCookieConfig, tenantConfiguration)
	userController := flows.ProvideUserController(store, queries, tokenHandler, cookieConfiguration, sessionProvider, hookProvider, timeProvider, tenantConfiguration)
	webAppFlow := flows.ProvideWebAppFlow(tenantConfiguration, providerProvider, queries, hookProvider, interactionProvider, userController)
	redirectURLFunc := provideRedirectURIForWebAppFunc()
	oAuthProviderFactory := sso.ProvideOAuthProviderFactory(tenantConfiguration, urlprefixProvider, timeProvider, normalizerFactory, redirectURLFunc)
	authenticateProviderImpl := &webapp.AuthenticateProviderImpl{
		ValidateProvider:     validateProvider,
		RenderProvider:       renderProvider,
		StateProvider:        stateProviderImpl,
		SSOStateCodec:        stateCodec,
		Interactions:         webAppFlow,
		OAuthProviderFactory: oAuthProviderFactory,
	}
	promoteHandler := &PromoteHandler{
		Provider:  authenticateProviderImpl,
		TxContext: txContext,
	}
	return promoteHandler
}

func newCreatePasswordHandler(r *http.Request, m auth.DependencyMap) http.Handler {
	context := auth.ProvideContext(r)
	tenantConfiguration := auth.ProvideTenantConfig(context, m)
	validateProvider := webapp.ProvideValidateProvider(tenantConfiguration)
	staticAssetURLPrefix := auth.ProvideStaticAssetURLPrefix(m)
	engine := auth.ProvideTemplateEngine(tenantConfiguration, m)
	timeProvider := time.NewProvider()
	sqlBuilderFactory := db.ProvideSQLBuilderFactory(tenantConfiguration)
	sqlBuilder := auth.ProvideAuthSQLBuilder(sqlBuilderFactory)
	sqlExecutor := db.ProvideSQLExecutor(context, tenantConfiguration)
	historyStoreImpl := password.ProvideHistoryStore(timeProvider, sqlBuilder, sqlExecutor)
	checker := password.ProvideChecker(tenantConfiguration, historyStoreImpl)
	reservedNameChecker := auth.ProvideReservedNameChecker(m)
	typeCheckerFactory := loginid.ProvideTypeCheckerFactory(tenantConfiguration, reservedNameChecker)
	loginidChecker := loginid.ProvideChecker(tenantConfiguration, typeCheckerFactory)
	normalizerFactory := loginid.ProvideNormalizerFactory(tenantConfiguration)
	loginidProvider := loginid.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration, loginidChecker, normalizerFactory)
	oauthProvider := oauth.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider)
	anonymousProvider := anonymous.ProvideProvider(sqlBuilder, sqlExecutor)
	providerProvider := provider.ProvideProvider(tenantConfiguration, loginidProvider, oauthProvider, anonymousProvider)
	renderProvider := webapp.ProvideRenderProvider(staticAssetURLPrefix, tenantConfiguration, engine, checker, providerProvider)
	stateStoreImpl := &webapp.StateStoreImpl{
		Context: context,
	}
	stateProviderImpl := &webapp.StateProviderImpl{
		StateStore: stateStoreImpl,
	}
	stateCodec := sso.ProvideStateCodec(tenantConfiguration)
	store := pq.ProvideStore(sqlBuilderFactory, sqlExecutor)
	userprofileStore := userprofile.ProvideStore(timeProvider, sqlBuilder, sqlExecutor)
	queries := &user.Queries{
		AuthInfos:    store,
		UserProfiles: userprofileStore,
		Identities:   providerProvider,
		Time:         timeProvider,
	}
	txContext := db.ProvideTxContext(context, tenantConfiguration)
	factory := logging.ProvideLoggerFactory(context, tenantConfiguration)
	hookProvider := hook.ProvideHookProvider(context, sqlBuilder, sqlExecutor, tenantConfiguration, txContext, timeProvider, queries, store, userprofileStore, loginidProvider, factory)
	redisStore := redis.ProvideStore(context, tenantConfiguration, timeProvider)
	passwordProvider := password.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, factory, historyStoreImpl, checker, tenantConfiguration)
	totpProvider := totp.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	urlprefixProvider := urlprefix.NewProvider(r)
	executor := auth.ProvideTaskExecutor(m)
	queue := async.ProvideTaskQueue(context, txContext, tenantConfiguration, executor)
	oobProvider := oob.ProvideProvider(context, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider, engine, urlprefixProvider, queue)
	bearertokenProvider := bearertoken.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	recoverycodeProvider := recoverycode.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	provider3 := &provider2.Provider{
		Password:     passwordProvider,
		TOTP:         totpProvider,
		OOBOTP:       oobProvider,
		BearerToken:  bearertokenProvider,
		RecoveryCode: recoverycodeProvider,
	}
	welcomemessageProvider := welcomemessage.ProvideProvider(context, tenantConfiguration, engine, queue)
	commands := user.ProvideCommands(store, userprofileStore, timeProvider, hookProvider, urlprefixProvider, queue, tenantConfiguration, welcomemessageProvider)
	userProvider := &user.Provider{
		Commands: commands,
		Queries:  queries,
	}
	interactionProvider := interaction.ProvideProvider(redisStore, timeProvider, factory, providerProvider, provider3, userProvider, oobProvider, tenantConfiguration, hookProvider)
	authorizationStore := &pq2.AuthorizationStore{
		SQLBuilder:  sqlBuilder,
		SQLExecutor: sqlExecutor,
	}
	grantStore := redis2.ProvideGrantStore(context, factory, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider)
	eventStore := redis3.ProvideEventStore(context, tenantConfiguration)
	accessEventProvider := auth2.AccessEventProvider{
		Store: eventStore,
	}
	sessionStore := redis4.ProvideStore(context, tenantConfiguration, timeProvider, factory)
	authAccessEventProvider := &auth2.AccessEventProvider{
		Store: eventStore,
	}
	sessionProvider := session.ProvideSessionProvider(r, sessionStore, authAccessEventProvider, tenantConfiguration)
	isAnonymousIdentityEnabled := flows.ProvideIsAnonymousIdentityEnabled(tenantConfiguration)
	challengeProvider := challenge.ProvideProvider(context, timeProvider, tenantConfiguration)
	anonymousFlow := &flows.AnonymousFlow{
		Enabled:      isAnonymousIdentityEnabled,
		Interactions: interactionProvider,
		Anonymous:    anonymousProvider,
		Challenges:   challengeProvider,
	}
	idTokenIssuer := oidc.ProvideIDTokenIssuer(tenantConfiguration, urlprefixProvider, queries, timeProvider)
	tokenGenerator := _wireTokenGeneratorValue
	tokenHandler := handler.ProvideTokenHandler(r, tenantConfiguration, factory, authorizationStore, grantStore, grantStore, grantStore, accessEventProvider, sessionProvider, anonymousFlow, idTokenIssuer, tokenGenerator, timeProvider)
	insecureCookieConfig := auth.ProvideSessionInsecureCookieConfig(m)
	cookieConfiguration := session.ProvideSessionCookieConfiguration(r, insecureCookieConfig, tenantConfiguration)
	userController := flows.ProvideUserController(store, queries, tokenHandler, cookieConfiguration, sessionProvider, hookProvider, timeProvider, tenantConfiguration)
	webAppFlow := flows.ProvideWebAppFlow(tenantConfiguration, providerProvider, queries, hookProvider, interactionProvider, userController)
	redirectURLFunc := provideRedirectURIForWebAppFunc()
	oAuthProviderFactory := sso.ProvideOAuthProviderFactory(tenantConfiguration, urlprefixProvider, timeProvider, normalizerFactory, redirectURLFunc)
	authenticateProviderImpl := &webapp.AuthenticateProviderImpl{
		ValidateProvider:     validateProvider,
		RenderProvider:       renderProvider,
		StateProvider:        stateProviderImpl,
		SSOStateCodec:        stateCodec,
		Interactions:         webAppFlow,
		OAuthProviderFactory: oAuthProviderFactory,
	}
	createPasswordHandler := &CreatePasswordHandler{
		Provider:  authenticateProviderImpl,
		TxContext: txContext,
	}
	return createPasswordHandler
}

func newSettingsHandler(r *http.Request, m auth.DependencyMap) http.Handler {
	staticAssetURLPrefix := auth.ProvideStaticAssetURLPrefix(m)
	context := auth.ProvideContext(r)
	tenantConfiguration := auth.ProvideTenantConfig(context, m)
	engine := auth.ProvideTemplateEngine(tenantConfiguration, m)
	timeProvider := time.NewProvider()
	sqlBuilderFactory := db.ProvideSQLBuilderFactory(tenantConfiguration)
	sqlBuilder := auth.ProvideAuthSQLBuilder(sqlBuilderFactory)
	sqlExecutor := db.ProvideSQLExecutor(context, tenantConfiguration)
	historyStoreImpl := password.ProvideHistoryStore(timeProvider, sqlBuilder, sqlExecutor)
	checker := password.ProvideChecker(tenantConfiguration, historyStoreImpl)
	reservedNameChecker := auth.ProvideReservedNameChecker(m)
	typeCheckerFactory := loginid.ProvideTypeCheckerFactory(tenantConfiguration, reservedNameChecker)
	loginidChecker := loginid.ProvideChecker(tenantConfiguration, typeCheckerFactory)
	normalizerFactory := loginid.ProvideNormalizerFactory(tenantConfiguration)
	loginidProvider := loginid.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration, loginidChecker, normalizerFactory)
	oauthProvider := oauth.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider)
	anonymousProvider := anonymous.ProvideProvider(sqlBuilder, sqlExecutor)
	providerProvider := provider.ProvideProvider(tenantConfiguration, loginidProvider, oauthProvider, anonymousProvider)
	renderProvider := webapp.ProvideRenderProvider(staticAssetURLPrefix, tenantConfiguration, engine, checker, providerProvider)
	settingsHandler := &SettingsHandler{
		RenderProvider: renderProvider,
	}
	return settingsHandler
}

func newSettingsIdentityHandler(r *http.Request, m auth.DependencyMap) http.Handler {
	staticAssetURLPrefix := auth.ProvideStaticAssetURLPrefix(m)
	context := auth.ProvideContext(r)
	tenantConfiguration := auth.ProvideTenantConfig(context, m)
	engine := auth.ProvideTemplateEngine(tenantConfiguration, m)
	timeProvider := time.NewProvider()
	sqlBuilderFactory := db.ProvideSQLBuilderFactory(tenantConfiguration)
	sqlBuilder := auth.ProvideAuthSQLBuilder(sqlBuilderFactory)
	sqlExecutor := db.ProvideSQLExecutor(context, tenantConfiguration)
	historyStoreImpl := password.ProvideHistoryStore(timeProvider, sqlBuilder, sqlExecutor)
	checker := password.ProvideChecker(tenantConfiguration, historyStoreImpl)
	reservedNameChecker := auth.ProvideReservedNameChecker(m)
	typeCheckerFactory := loginid.ProvideTypeCheckerFactory(tenantConfiguration, reservedNameChecker)
	loginidChecker := loginid.ProvideChecker(tenantConfiguration, typeCheckerFactory)
	normalizerFactory := loginid.ProvideNormalizerFactory(tenantConfiguration)
	loginidProvider := loginid.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration, loginidChecker, normalizerFactory)
	oauthProvider := oauth.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider)
	anonymousProvider := anonymous.ProvideProvider(sqlBuilder, sqlExecutor)
	providerProvider := provider.ProvideProvider(tenantConfiguration, loginidProvider, oauthProvider, anonymousProvider)
	renderProvider := webapp.ProvideRenderProvider(staticAssetURLPrefix, tenantConfiguration, engine, checker, providerProvider)
	validateProvider := webapp.ProvideValidateProvider(tenantConfiguration)
	stateStoreImpl := &webapp.StateStoreImpl{
		Context: context,
	}
	stateProviderImpl := &webapp.StateProviderImpl{
		StateStore: stateStoreImpl,
	}
	stateCodec := sso.ProvideStateCodec(tenantConfiguration)
	store := pq.ProvideStore(sqlBuilderFactory, sqlExecutor)
	userprofileStore := userprofile.ProvideStore(timeProvider, sqlBuilder, sqlExecutor)
	queries := &user.Queries{
		AuthInfos:    store,
		UserProfiles: userprofileStore,
		Identities:   providerProvider,
		Time:         timeProvider,
	}
	txContext := db.ProvideTxContext(context, tenantConfiguration)
	factory := logging.ProvideLoggerFactory(context, tenantConfiguration)
	hookProvider := hook.ProvideHookProvider(context, sqlBuilder, sqlExecutor, tenantConfiguration, txContext, timeProvider, queries, store, userprofileStore, loginidProvider, factory)
	redisStore := redis.ProvideStore(context, tenantConfiguration, timeProvider)
	passwordProvider := password.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, factory, historyStoreImpl, checker, tenantConfiguration)
	totpProvider := totp.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	urlprefixProvider := urlprefix.NewProvider(r)
	executor := auth.ProvideTaskExecutor(m)
	queue := async.ProvideTaskQueue(context, txContext, tenantConfiguration, executor)
	oobProvider := oob.ProvideProvider(context, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider, engine, urlprefixProvider, queue)
	bearertokenProvider := bearertoken.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	recoverycodeProvider := recoverycode.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	provider3 := &provider2.Provider{
		Password:     passwordProvider,
		TOTP:         totpProvider,
		OOBOTP:       oobProvider,
		BearerToken:  bearertokenProvider,
		RecoveryCode: recoverycodeProvider,
	}
	welcomemessageProvider := welcomemessage.ProvideProvider(context, tenantConfiguration, engine, queue)
	commands := user.ProvideCommands(store, userprofileStore, timeProvider, hookProvider, urlprefixProvider, queue, tenantConfiguration, welcomemessageProvider)
	userProvider := &user.Provider{
		Commands: commands,
		Queries:  queries,
	}
	interactionProvider := interaction.ProvideProvider(redisStore, timeProvider, factory, providerProvider, provider3, userProvider, oobProvider, tenantConfiguration, hookProvider)
	authorizationStore := &pq2.AuthorizationStore{
		SQLBuilder:  sqlBuilder,
		SQLExecutor: sqlExecutor,
	}
	grantStore := redis2.ProvideGrantStore(context, factory, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider)
	eventStore := redis3.ProvideEventStore(context, tenantConfiguration)
	accessEventProvider := auth2.AccessEventProvider{
		Store: eventStore,
	}
	sessionStore := redis4.ProvideStore(context, tenantConfiguration, timeProvider, factory)
	authAccessEventProvider := &auth2.AccessEventProvider{
		Store: eventStore,
	}
	sessionProvider := session.ProvideSessionProvider(r, sessionStore, authAccessEventProvider, tenantConfiguration)
	isAnonymousIdentityEnabled := flows.ProvideIsAnonymousIdentityEnabled(tenantConfiguration)
	challengeProvider := challenge.ProvideProvider(context, timeProvider, tenantConfiguration)
	anonymousFlow := &flows.AnonymousFlow{
		Enabled:      isAnonymousIdentityEnabled,
		Interactions: interactionProvider,
		Anonymous:    anonymousProvider,
		Challenges:   challengeProvider,
	}
	idTokenIssuer := oidc.ProvideIDTokenIssuer(tenantConfiguration, urlprefixProvider, queries, timeProvider)
	tokenGenerator := _wireTokenGeneratorValue
	tokenHandler := handler.ProvideTokenHandler(r, tenantConfiguration, factory, authorizationStore, grantStore, grantStore, grantStore, accessEventProvider, sessionProvider, anonymousFlow, idTokenIssuer, tokenGenerator, timeProvider)
	insecureCookieConfig := auth.ProvideSessionInsecureCookieConfig(m)
	cookieConfiguration := session.ProvideSessionCookieConfiguration(r, insecureCookieConfig, tenantConfiguration)
	userController := flows.ProvideUserController(store, queries, tokenHandler, cookieConfiguration, sessionProvider, hookProvider, timeProvider, tenantConfiguration)
	webAppFlow := flows.ProvideWebAppFlow(tenantConfiguration, providerProvider, queries, hookProvider, interactionProvider, userController)
	redirectURLFunc := provideRedirectURIForWebAppFunc()
	oAuthProviderFactory := sso.ProvideOAuthProviderFactory(tenantConfiguration, urlprefixProvider, timeProvider, normalizerFactory, redirectURLFunc)
	authenticateProviderImpl := &webapp.AuthenticateProviderImpl{
		ValidateProvider:     validateProvider,
		RenderProvider:       renderProvider,
		StateProvider:        stateProviderImpl,
		SSOStateCodec:        stateCodec,
		Interactions:         webAppFlow,
		OAuthProviderFactory: oAuthProviderFactory,
	}
	settingsIdentityHandler := &SettingsIdentityHandler{
		RenderProvider: renderProvider,
		Provider:       authenticateProviderImpl,
		TxContext:      txContext,
	}
	return settingsIdentityHandler
}

func newOOBOTPHandler(r *http.Request, m auth.DependencyMap) http.Handler {
	context := auth.ProvideContext(r)
	tenantConfiguration := auth.ProvideTenantConfig(context, m)
	validateProvider := webapp.ProvideValidateProvider(tenantConfiguration)
	staticAssetURLPrefix := auth.ProvideStaticAssetURLPrefix(m)
	engine := auth.ProvideTemplateEngine(tenantConfiguration, m)
	timeProvider := time.NewProvider()
	sqlBuilderFactory := db.ProvideSQLBuilderFactory(tenantConfiguration)
	sqlBuilder := auth.ProvideAuthSQLBuilder(sqlBuilderFactory)
	sqlExecutor := db.ProvideSQLExecutor(context, tenantConfiguration)
	historyStoreImpl := password.ProvideHistoryStore(timeProvider, sqlBuilder, sqlExecutor)
	checker := password.ProvideChecker(tenantConfiguration, historyStoreImpl)
	reservedNameChecker := auth.ProvideReservedNameChecker(m)
	typeCheckerFactory := loginid.ProvideTypeCheckerFactory(tenantConfiguration, reservedNameChecker)
	loginidChecker := loginid.ProvideChecker(tenantConfiguration, typeCheckerFactory)
	normalizerFactory := loginid.ProvideNormalizerFactory(tenantConfiguration)
	loginidProvider := loginid.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration, loginidChecker, normalizerFactory)
	oauthProvider := oauth.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider)
	anonymousProvider := anonymous.ProvideProvider(sqlBuilder, sqlExecutor)
	providerProvider := provider.ProvideProvider(tenantConfiguration, loginidProvider, oauthProvider, anonymousProvider)
	renderProvider := webapp.ProvideRenderProvider(staticAssetURLPrefix, tenantConfiguration, engine, checker, providerProvider)
	stateStoreImpl := &webapp.StateStoreImpl{
		Context: context,
	}
	stateProviderImpl := &webapp.StateProviderImpl{
		StateStore: stateStoreImpl,
	}
	stateCodec := sso.ProvideStateCodec(tenantConfiguration)
	store := pq.ProvideStore(sqlBuilderFactory, sqlExecutor)
	userprofileStore := userprofile.ProvideStore(timeProvider, sqlBuilder, sqlExecutor)
	queries := &user.Queries{
		AuthInfos:    store,
		UserProfiles: userprofileStore,
		Identities:   providerProvider,
		Time:         timeProvider,
	}
	txContext := db.ProvideTxContext(context, tenantConfiguration)
	factory := logging.ProvideLoggerFactory(context, tenantConfiguration)
	hookProvider := hook.ProvideHookProvider(context, sqlBuilder, sqlExecutor, tenantConfiguration, txContext, timeProvider, queries, store, userprofileStore, loginidProvider, factory)
	redisStore := redis.ProvideStore(context, tenantConfiguration, timeProvider)
	passwordProvider := password.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, factory, historyStoreImpl, checker, tenantConfiguration)
	totpProvider := totp.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	urlprefixProvider := urlprefix.NewProvider(r)
	executor := auth.ProvideTaskExecutor(m)
	queue := async.ProvideTaskQueue(context, txContext, tenantConfiguration, executor)
	oobProvider := oob.ProvideProvider(context, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider, engine, urlprefixProvider, queue)
	bearertokenProvider := bearertoken.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	recoverycodeProvider := recoverycode.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	provider3 := &provider2.Provider{
		Password:     passwordProvider,
		TOTP:         totpProvider,
		OOBOTP:       oobProvider,
		BearerToken:  bearertokenProvider,
		RecoveryCode: recoverycodeProvider,
	}
	welcomemessageProvider := welcomemessage.ProvideProvider(context, tenantConfiguration, engine, queue)
	commands := user.ProvideCommands(store, userprofileStore, timeProvider, hookProvider, urlprefixProvider, queue, tenantConfiguration, welcomemessageProvider)
	userProvider := &user.Provider{
		Commands: commands,
		Queries:  queries,
	}
	interactionProvider := interaction.ProvideProvider(redisStore, timeProvider, factory, providerProvider, provider3, userProvider, oobProvider, tenantConfiguration, hookProvider)
	authorizationStore := &pq2.AuthorizationStore{
		SQLBuilder:  sqlBuilder,
		SQLExecutor: sqlExecutor,
	}
	grantStore := redis2.ProvideGrantStore(context, factory, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider)
	eventStore := redis3.ProvideEventStore(context, tenantConfiguration)
	accessEventProvider := auth2.AccessEventProvider{
		Store: eventStore,
	}
	sessionStore := redis4.ProvideStore(context, tenantConfiguration, timeProvider, factory)
	authAccessEventProvider := &auth2.AccessEventProvider{
		Store: eventStore,
	}
	sessionProvider := session.ProvideSessionProvider(r, sessionStore, authAccessEventProvider, tenantConfiguration)
	isAnonymousIdentityEnabled := flows.ProvideIsAnonymousIdentityEnabled(tenantConfiguration)
	challengeProvider := challenge.ProvideProvider(context, timeProvider, tenantConfiguration)
	anonymousFlow := &flows.AnonymousFlow{
		Enabled:      isAnonymousIdentityEnabled,
		Interactions: interactionProvider,
		Anonymous:    anonymousProvider,
		Challenges:   challengeProvider,
	}
	idTokenIssuer := oidc.ProvideIDTokenIssuer(tenantConfiguration, urlprefixProvider, queries, timeProvider)
	tokenGenerator := _wireTokenGeneratorValue
	tokenHandler := handler.ProvideTokenHandler(r, tenantConfiguration, factory, authorizationStore, grantStore, grantStore, grantStore, accessEventProvider, sessionProvider, anonymousFlow, idTokenIssuer, tokenGenerator, timeProvider)
	insecureCookieConfig := auth.ProvideSessionInsecureCookieConfig(m)
	cookieConfiguration := session.ProvideSessionCookieConfiguration(r, insecureCookieConfig, tenantConfiguration)
	userController := flows.ProvideUserController(store, queries, tokenHandler, cookieConfiguration, sessionProvider, hookProvider, timeProvider, tenantConfiguration)
	webAppFlow := flows.ProvideWebAppFlow(tenantConfiguration, providerProvider, queries, hookProvider, interactionProvider, userController)
	redirectURLFunc := provideRedirectURIForWebAppFunc()
	oAuthProviderFactory := sso.ProvideOAuthProviderFactory(tenantConfiguration, urlprefixProvider, timeProvider, normalizerFactory, redirectURLFunc)
	authenticateProviderImpl := &webapp.AuthenticateProviderImpl{
		ValidateProvider:     validateProvider,
		RenderProvider:       renderProvider,
		StateProvider:        stateProviderImpl,
		SSOStateCodec:        stateCodec,
		Interactions:         webAppFlow,
		OAuthProviderFactory: oAuthProviderFactory,
	}
	oobotpHandler := &OOBOTPHandler{
		Provider:  authenticateProviderImpl,
		TxContext: txContext,
	}
	return oobotpHandler
}

func newEnterLoginIDHandler(r *http.Request, m auth.DependencyMap) http.Handler {
	context := auth.ProvideContext(r)
	tenantConfiguration := auth.ProvideTenantConfig(context, m)
	validateProvider := webapp.ProvideValidateProvider(tenantConfiguration)
	staticAssetURLPrefix := auth.ProvideStaticAssetURLPrefix(m)
	engine := auth.ProvideTemplateEngine(tenantConfiguration, m)
	timeProvider := time.NewProvider()
	sqlBuilderFactory := db.ProvideSQLBuilderFactory(tenantConfiguration)
	sqlBuilder := auth.ProvideAuthSQLBuilder(sqlBuilderFactory)
	sqlExecutor := db.ProvideSQLExecutor(context, tenantConfiguration)
	historyStoreImpl := password.ProvideHistoryStore(timeProvider, sqlBuilder, sqlExecutor)
	checker := password.ProvideChecker(tenantConfiguration, historyStoreImpl)
	reservedNameChecker := auth.ProvideReservedNameChecker(m)
	typeCheckerFactory := loginid.ProvideTypeCheckerFactory(tenantConfiguration, reservedNameChecker)
	loginidChecker := loginid.ProvideChecker(tenantConfiguration, typeCheckerFactory)
	normalizerFactory := loginid.ProvideNormalizerFactory(tenantConfiguration)
	loginidProvider := loginid.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration, loginidChecker, normalizerFactory)
	oauthProvider := oauth.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider)
	anonymousProvider := anonymous.ProvideProvider(sqlBuilder, sqlExecutor)
	providerProvider := provider.ProvideProvider(tenantConfiguration, loginidProvider, oauthProvider, anonymousProvider)
	renderProvider := webapp.ProvideRenderProvider(staticAssetURLPrefix, tenantConfiguration, engine, checker, providerProvider)
	stateStoreImpl := &webapp.StateStoreImpl{
		Context: context,
	}
	stateProviderImpl := &webapp.StateProviderImpl{
		StateStore: stateStoreImpl,
	}
	stateCodec := sso.ProvideStateCodec(tenantConfiguration)
	store := pq.ProvideStore(sqlBuilderFactory, sqlExecutor)
	userprofileStore := userprofile.ProvideStore(timeProvider, sqlBuilder, sqlExecutor)
	queries := &user.Queries{
		AuthInfos:    store,
		UserProfiles: userprofileStore,
		Identities:   providerProvider,
		Time:         timeProvider,
	}
	txContext := db.ProvideTxContext(context, tenantConfiguration)
	factory := logging.ProvideLoggerFactory(context, tenantConfiguration)
	hookProvider := hook.ProvideHookProvider(context, sqlBuilder, sqlExecutor, tenantConfiguration, txContext, timeProvider, queries, store, userprofileStore, loginidProvider, factory)
	redisStore := redis.ProvideStore(context, tenantConfiguration, timeProvider)
	passwordProvider := password.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, factory, historyStoreImpl, checker, tenantConfiguration)
	totpProvider := totp.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	urlprefixProvider := urlprefix.NewProvider(r)
	executor := auth.ProvideTaskExecutor(m)
	queue := async.ProvideTaskQueue(context, txContext, tenantConfiguration, executor)
	oobProvider := oob.ProvideProvider(context, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider, engine, urlprefixProvider, queue)
	bearertokenProvider := bearertoken.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	recoverycodeProvider := recoverycode.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	provider3 := &provider2.Provider{
		Password:     passwordProvider,
		TOTP:         totpProvider,
		OOBOTP:       oobProvider,
		BearerToken:  bearertokenProvider,
		RecoveryCode: recoverycodeProvider,
	}
	welcomemessageProvider := welcomemessage.ProvideProvider(context, tenantConfiguration, engine, queue)
	commands := user.ProvideCommands(store, userprofileStore, timeProvider, hookProvider, urlprefixProvider, queue, tenantConfiguration, welcomemessageProvider)
	userProvider := &user.Provider{
		Commands: commands,
		Queries:  queries,
	}
	interactionProvider := interaction.ProvideProvider(redisStore, timeProvider, factory, providerProvider, provider3, userProvider, oobProvider, tenantConfiguration, hookProvider)
	authorizationStore := &pq2.AuthorizationStore{
		SQLBuilder:  sqlBuilder,
		SQLExecutor: sqlExecutor,
	}
	grantStore := redis2.ProvideGrantStore(context, factory, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider)
	eventStore := redis3.ProvideEventStore(context, tenantConfiguration)
	accessEventProvider := auth2.AccessEventProvider{
		Store: eventStore,
	}
	sessionStore := redis4.ProvideStore(context, tenantConfiguration, timeProvider, factory)
	authAccessEventProvider := &auth2.AccessEventProvider{
		Store: eventStore,
	}
	sessionProvider := session.ProvideSessionProvider(r, sessionStore, authAccessEventProvider, tenantConfiguration)
	isAnonymousIdentityEnabled := flows.ProvideIsAnonymousIdentityEnabled(tenantConfiguration)
	challengeProvider := challenge.ProvideProvider(context, timeProvider, tenantConfiguration)
	anonymousFlow := &flows.AnonymousFlow{
		Enabled:      isAnonymousIdentityEnabled,
		Interactions: interactionProvider,
		Anonymous:    anonymousProvider,
		Challenges:   challengeProvider,
	}
	idTokenIssuer := oidc.ProvideIDTokenIssuer(tenantConfiguration, urlprefixProvider, queries, timeProvider)
	tokenGenerator := _wireTokenGeneratorValue
	tokenHandler := handler.ProvideTokenHandler(r, tenantConfiguration, factory, authorizationStore, grantStore, grantStore, grantStore, accessEventProvider, sessionProvider, anonymousFlow, idTokenIssuer, tokenGenerator, timeProvider)
	insecureCookieConfig := auth.ProvideSessionInsecureCookieConfig(m)
	cookieConfiguration := session.ProvideSessionCookieConfiguration(r, insecureCookieConfig, tenantConfiguration)
	userController := flows.ProvideUserController(store, queries, tokenHandler, cookieConfiguration, sessionProvider, hookProvider, timeProvider, tenantConfiguration)
	webAppFlow := flows.ProvideWebAppFlow(tenantConfiguration, providerProvider, queries, hookProvider, interactionProvider, userController)
	redirectURLFunc := provideRedirectURIForWebAppFunc()
	oAuthProviderFactory := sso.ProvideOAuthProviderFactory(tenantConfiguration, urlprefixProvider, timeProvider, normalizerFactory, redirectURLFunc)
	authenticateProviderImpl := &webapp.AuthenticateProviderImpl{
		ValidateProvider:     validateProvider,
		RenderProvider:       renderProvider,
		StateProvider:        stateProviderImpl,
		SSOStateCodec:        stateCodec,
		Interactions:         webAppFlow,
		OAuthProviderFactory: oAuthProviderFactory,
	}
	enterLoginIDHandler := &EnterLoginIDHandler{
		Provider:  authenticateProviderImpl,
		TxContext: txContext,
	}
	return enterLoginIDHandler
}

func newLogoutHandler(r *http.Request, m auth.DependencyMap) http.Handler {
	staticAssetURLPrefix := auth.ProvideStaticAssetURLPrefix(m)
	context := auth.ProvideContext(r)
	tenantConfiguration := auth.ProvideTenantConfig(context, m)
	engine := auth.ProvideTemplateEngine(tenantConfiguration, m)
	timeProvider := time.NewProvider()
	sqlBuilderFactory := db.ProvideSQLBuilderFactory(tenantConfiguration)
	sqlBuilder := auth.ProvideAuthSQLBuilder(sqlBuilderFactory)
	sqlExecutor := db.ProvideSQLExecutor(context, tenantConfiguration)
	historyStoreImpl := password.ProvideHistoryStore(timeProvider, sqlBuilder, sqlExecutor)
	checker := password.ProvideChecker(tenantConfiguration, historyStoreImpl)
	reservedNameChecker := auth.ProvideReservedNameChecker(m)
	typeCheckerFactory := loginid.ProvideTypeCheckerFactory(tenantConfiguration, reservedNameChecker)
	loginidChecker := loginid.ProvideChecker(tenantConfiguration, typeCheckerFactory)
	normalizerFactory := loginid.ProvideNormalizerFactory(tenantConfiguration)
	loginidProvider := loginid.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration, loginidChecker, normalizerFactory)
	oauthProvider := oauth.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider)
	anonymousProvider := anonymous.ProvideProvider(sqlBuilder, sqlExecutor)
	providerProvider := provider.ProvideProvider(tenantConfiguration, loginidProvider, oauthProvider, anonymousProvider)
	renderProvider := webapp.ProvideRenderProvider(staticAssetURLPrefix, tenantConfiguration, engine, checker, providerProvider)
	store := pq.ProvideStore(sqlBuilderFactory, sqlExecutor)
	userprofileStore := userprofile.ProvideStore(timeProvider, sqlBuilder, sqlExecutor)
	queries := &user.Queries{
		AuthInfos:    store,
		UserProfiles: userprofileStore,
		Identities:   providerProvider,
		Time:         timeProvider,
	}
	txContext := db.ProvideTxContext(context, tenantConfiguration)
	factory := logging.ProvideLoggerFactory(context, tenantConfiguration)
	hookProvider := hook.ProvideHookProvider(context, sqlBuilder, sqlExecutor, tenantConfiguration, txContext, timeProvider, queries, store, userprofileStore, loginidProvider, factory)
	sessionStore := redis4.ProvideStore(context, tenantConfiguration, timeProvider, factory)
	insecureCookieConfig := auth.ProvideSessionInsecureCookieConfig(m)
	cookieConfiguration := session.ProvideSessionCookieConfiguration(r, insecureCookieConfig, tenantConfiguration)
	manager := session.ProvideSessionManager(sessionStore, timeProvider, tenantConfiguration, cookieConfiguration)
	grantStore := redis2.ProvideGrantStore(context, factory, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider)
	sessionManager := &oauth2.SessionManager{
		Store: grantStore,
		Time:  timeProvider,
	}
	authSessionManager := &auth2.SessionManager{
		Users:               queries,
		Hooks:               hookProvider,
		IDPSessions:         manager,
		AccessTokenSessions: sessionManager,
	}
	logoutHandler := &LogoutHandler{
		RenderProvider: renderProvider,
		SessionManager: authSessionManager,
		TxContext:      txContext,
	}
	return logoutHandler
}

func newSSOCallbackHandler(r *http.Request, m auth.DependencyMap) http.Handler {
	context := auth.ProvideContext(r)
	tenantConfiguration := auth.ProvideTenantConfig(context, m)
	validateProvider := webapp.ProvideValidateProvider(tenantConfiguration)
	staticAssetURLPrefix := auth.ProvideStaticAssetURLPrefix(m)
	engine := auth.ProvideTemplateEngine(tenantConfiguration, m)
	timeProvider := time.NewProvider()
	sqlBuilderFactory := db.ProvideSQLBuilderFactory(tenantConfiguration)
	sqlBuilder := auth.ProvideAuthSQLBuilder(sqlBuilderFactory)
	sqlExecutor := db.ProvideSQLExecutor(context, tenantConfiguration)
	historyStoreImpl := password.ProvideHistoryStore(timeProvider, sqlBuilder, sqlExecutor)
	checker := password.ProvideChecker(tenantConfiguration, historyStoreImpl)
	reservedNameChecker := auth.ProvideReservedNameChecker(m)
	typeCheckerFactory := loginid.ProvideTypeCheckerFactory(tenantConfiguration, reservedNameChecker)
	loginidChecker := loginid.ProvideChecker(tenantConfiguration, typeCheckerFactory)
	normalizerFactory := loginid.ProvideNormalizerFactory(tenantConfiguration)
	loginidProvider := loginid.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration, loginidChecker, normalizerFactory)
	oauthProvider := oauth.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider)
	anonymousProvider := anonymous.ProvideProvider(sqlBuilder, sqlExecutor)
	providerProvider := provider.ProvideProvider(tenantConfiguration, loginidProvider, oauthProvider, anonymousProvider)
	renderProvider := webapp.ProvideRenderProvider(staticAssetURLPrefix, tenantConfiguration, engine, checker, providerProvider)
	stateStoreImpl := &webapp.StateStoreImpl{
		Context: context,
	}
	stateProviderImpl := &webapp.StateProviderImpl{
		StateStore: stateStoreImpl,
	}
	stateCodec := sso.ProvideStateCodec(tenantConfiguration)
	store := pq.ProvideStore(sqlBuilderFactory, sqlExecutor)
	userprofileStore := userprofile.ProvideStore(timeProvider, sqlBuilder, sqlExecutor)
	queries := &user.Queries{
		AuthInfos:    store,
		UserProfiles: userprofileStore,
		Identities:   providerProvider,
		Time:         timeProvider,
	}
	txContext := db.ProvideTxContext(context, tenantConfiguration)
	factory := logging.ProvideLoggerFactory(context, tenantConfiguration)
	hookProvider := hook.ProvideHookProvider(context, sqlBuilder, sqlExecutor, tenantConfiguration, txContext, timeProvider, queries, store, userprofileStore, loginidProvider, factory)
	redisStore := redis.ProvideStore(context, tenantConfiguration, timeProvider)
	passwordProvider := password.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, factory, historyStoreImpl, checker, tenantConfiguration)
	totpProvider := totp.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	urlprefixProvider := urlprefix.NewProvider(r)
	executor := auth.ProvideTaskExecutor(m)
	queue := async.ProvideTaskQueue(context, txContext, tenantConfiguration, executor)
	oobProvider := oob.ProvideProvider(context, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider, engine, urlprefixProvider, queue)
	bearertokenProvider := bearertoken.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	recoverycodeProvider := recoverycode.ProvideProvider(sqlBuilder, sqlExecutor, timeProvider, tenantConfiguration)
	provider3 := &provider2.Provider{
		Password:     passwordProvider,
		TOTP:         totpProvider,
		OOBOTP:       oobProvider,
		BearerToken:  bearertokenProvider,
		RecoveryCode: recoverycodeProvider,
	}
	welcomemessageProvider := welcomemessage.ProvideProvider(context, tenantConfiguration, engine, queue)
	commands := user.ProvideCommands(store, userprofileStore, timeProvider, hookProvider, urlprefixProvider, queue, tenantConfiguration, welcomemessageProvider)
	userProvider := &user.Provider{
		Commands: commands,
		Queries:  queries,
	}
	interactionProvider := interaction.ProvideProvider(redisStore, timeProvider, factory, providerProvider, provider3, userProvider, oobProvider, tenantConfiguration, hookProvider)
	authorizationStore := &pq2.AuthorizationStore{
		SQLBuilder:  sqlBuilder,
		SQLExecutor: sqlExecutor,
	}
	grantStore := redis2.ProvideGrantStore(context, factory, tenantConfiguration, sqlBuilder, sqlExecutor, timeProvider)
	eventStore := redis3.ProvideEventStore(context, tenantConfiguration)
	accessEventProvider := auth2.AccessEventProvider{
		Store: eventStore,
	}
	sessionStore := redis4.ProvideStore(context, tenantConfiguration, timeProvider, factory)
	authAccessEventProvider := &auth2.AccessEventProvider{
		Store: eventStore,
	}
	sessionProvider := session.ProvideSessionProvider(r, sessionStore, authAccessEventProvider, tenantConfiguration)
	isAnonymousIdentityEnabled := flows.ProvideIsAnonymousIdentityEnabled(tenantConfiguration)
	challengeProvider := challenge.ProvideProvider(context, timeProvider, tenantConfiguration)
	anonymousFlow := &flows.AnonymousFlow{
		Enabled:      isAnonymousIdentityEnabled,
		Interactions: interactionProvider,
		Anonymous:    anonymousProvider,
		Challenges:   challengeProvider,
	}
	idTokenIssuer := oidc.ProvideIDTokenIssuer(tenantConfiguration, urlprefixProvider, queries, timeProvider)
	tokenGenerator := _wireTokenGeneratorValue
	tokenHandler := handler.ProvideTokenHandler(r, tenantConfiguration, factory, authorizationStore, grantStore, grantStore, grantStore, accessEventProvider, sessionProvider, anonymousFlow, idTokenIssuer, tokenGenerator, timeProvider)
	insecureCookieConfig := auth.ProvideSessionInsecureCookieConfig(m)
	cookieConfiguration := session.ProvideSessionCookieConfiguration(r, insecureCookieConfig, tenantConfiguration)
	userController := flows.ProvideUserController(store, queries, tokenHandler, cookieConfiguration, sessionProvider, hookProvider, timeProvider, tenantConfiguration)
	webAppFlow := flows.ProvideWebAppFlow(tenantConfiguration, providerProvider, queries, hookProvider, interactionProvider, userController)
	redirectURLFunc := provideRedirectURIForWebAppFunc()
	oAuthProviderFactory := sso.ProvideOAuthProviderFactory(tenantConfiguration, urlprefixProvider, timeProvider, normalizerFactory, redirectURLFunc)
	authenticateProviderImpl := &webapp.AuthenticateProviderImpl{
		ValidateProvider:     validateProvider,
		RenderProvider:       renderProvider,
		StateProvider:        stateProviderImpl,
		SSOStateCodec:        stateCodec,
		Interactions:         webAppFlow,
		OAuthProviderFactory: oAuthProviderFactory,
	}
	ssoCallbackHandler := &SSOCallbackHandler{
		Provider:  authenticateProviderImpl,
		TxContext: txContext,
	}
	return ssoCallbackHandler
}

// wire.go:

func provideRedirectURIForWebAppFunc() sso.RedirectURLFunc {
	return redirectURIForWebApp
}

var dependencySet = wire.NewSet(auth.DependencySet, wire.Bind(new(webapp.OAuthProviderFactory), new(*sso.OAuthProviderFactory)), wire.Struct(new(webapp.AuthenticateProviderImpl), "*"), wire.Bind(new(webapp.ForgotPassword), new(*forgotpassword.Provider)), wire.Struct(new(webapp.ForgotPasswordProvider), "*"), provideRedirectURIForWebAppFunc)
