// Code generated by Wire. DO NOT EDIT.

//go:generate wire
//+build !wireinject

package session

import (
	"github.com/skygeario/skygear-server/pkg/auth"
	auth2 "github.com/skygeario/skygear-server/pkg/auth/dependency/auth"
	redis2 "github.com/skygeario/skygear-server/pkg/auth/dependency/auth/redis"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/identity/anonymous"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/oauth"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/oauth/pq"
	redis3 "github.com/skygeario/skygear-server/pkg/auth/dependency/oauth/redis"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/session"
	"github.com/skygeario/skygear-server/pkg/auth/dependency/session/redis"
	pq2 "github.com/skygeario/skygear-server/pkg/core/auth/authinfo/pq"
	"github.com/skygeario/skygear-server/pkg/core/db"
	"github.com/skygeario/skygear-server/pkg/core/logging"
	"github.com/skygeario/skygear-server/pkg/core/time"
	"net/http"
)

// Injectors from wire.go:

func newResolveHandler(r *http.Request, m auth.DependencyMap) http.Handler {
	insecureCookieConfig := auth.ProvideSessionInsecureCookieConfig(m)
	context := auth.ProvideContext(r)
	tenantConfiguration := auth.ProvideTenantConfig(context, m)
	cookieConfiguration := session.ProvideSessionCookieConfiguration(r, insecureCookieConfig, tenantConfiguration)
	provider := time.NewProvider()
	factory := logging.ProvideLoggerFactory(context, tenantConfiguration)
	store := redis.ProvideStore(context, tenantConfiguration, provider, factory)
	eventStore := redis2.ProvideEventStore(context, tenantConfiguration)
	accessEventProvider := &auth2.AccessEventProvider{
		Store: eventStore,
	}
	sessionProvider := session.ProvideSessionProvider(r, store, accessEventProvider, tenantConfiguration)
	resolver := &session.Resolver{
		CookieConfiguration: cookieConfiguration,
		Provider:            sessionProvider,
		Time:                provider,
	}
	sqlBuilderFactory := db.ProvideSQLBuilderFactory(tenantConfiguration)
	sqlBuilder := auth.ProvideAuthSQLBuilder(sqlBuilderFactory)
	sqlExecutor := db.ProvideSQLExecutor(context, tenantConfiguration)
	authorizationStore := &pq.AuthorizationStore{
		SQLBuilder:  sqlBuilder,
		SQLExecutor: sqlExecutor,
	}
	grantStore := redis3.ProvideGrantStore(context, factory, tenantConfiguration, sqlBuilder, sqlExecutor, provider)
	resolverSessionProvider := oauth.ProvideResolverProvider(sessionProvider)
	oauthResolver := &oauth.Resolver{
		Authorizations: authorizationStore,
		AccessGrants:   grantStore,
		OfflineGrants:  grantStore,
		Sessions:       resolverSessionProvider,
		Time:           provider,
	}
	authAccessEventProvider := auth2.AccessEventProvider{
		Store: eventStore,
	}
	authinfoStore := pq2.ProvideStore(sqlBuilderFactory, sqlExecutor)
	txContext := db.ProvideTxContext(context, tenantConfiguration)
	middleware := &auth2.Middleware{
		IDPSessionResolver:         resolver,
		AccessTokenSessionResolver: oauthResolver,
		AccessEvents:               authAccessEventProvider,
		AuthInfoStore:              authinfoStore,
		Time:                       provider,
		TxContext:                  txContext,
	}
	anonymousProvider := anonymous.ProvideProvider(sqlBuilder, sqlExecutor)
	handler := provideResolveHandler(middleware, factory, provider, anonymousProvider)
	return handler
}

// wire.go:

func provideResolveHandler(
	m *auth2.Middleware,
	lf logging.Factory,
	t time.Provider,
	ap *anonymous.Provider,
) http.Handler {
	return m.Handle(&ResolveHandler{
		TimeProvider:  t,
		LoggerFactory: lf,
		Anonymous:     ap,
	})
}
