import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:travel_app_flutter/cubit/app_cubit.dart';
import 'package:travel_app_flutter/cubit/app_cubit_states.dart';
import 'package:travel_app_flutter/pages/navpages/detail_page.dart';
import 'package:travel_app_flutter/pages/navpages/main_page.dart';
import 'package:travel_app_flutter/pages/welcome_page.dart';

class AppCubitLogics extends StatefulWidget {
  const AppCubitLogics({Key? key}) : super(key: key);

  @override
  State<AppCubitLogics> createState() => _AppCubitLogicsState();
}

class _AppCubitLogicsState extends State<AppCubitLogics> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: BlocBuilder<AppCubits, CubitStates>(builder: (context, state) {
        if (state is WelcomeState) {
          return WelcomePage();
        } else if (state is LoadingState) {
          return Center(
            child: CircularProgressIndicator(),
          );
        } else if (state is DetailState) {
          return DetailPage();
        } else if (state is LoadedState) {
          return MainPage();
        } else {
          return Container();
        }
      }),
    );
  }
}
