# Space Lab Tasks

This Flutter project represents a Todo application, encompassing various features for efficient task management and user experience:

## App Demo

Click here on video link: <a href="https://youtu.be/lGLMuZRbC6w" target="_blank">Demo Video</a>

## Signin and Signup
The app facilitates user authentication with dedicated Signin and Signup pages, ensuring secure access for registered users.

## Task Management
It provides an intuitive interface for managing tasks efficiently, supporting both light and dark themes for user preference.

### Task List Views
- **Todo List (Light Theme):** Displays tasks in a bright interface for clear visibility.
- **Todo List (Dark Theme):** Allows comfortable task viewing in low-light environments.

### Task Creation
- **Add Task:** Enables users to effortlessly create and add new tasks to their lists.

## Analytics
The app will soon offer Task Analytics, presenting insightful statistics and data visualization regarding task completion rates and progress (coming in new App RELEASE).

## User Profile
Users can access and manage their profile information, settings, and preferences through the dedicated User Profile and Edit Profile screens.


# Signin and Signup Page

These images showcase the Signin and Signup pages of the application:

<table>
  <tr>
    <td>
      <img src="https://github.com/ShubhamKNIT/D-Artistry/raw/main/assets/images/D'Artistry%20Screenshot/First_Page.png" alt="First Page" width="300">
      <p align="center"><em>First Page: Landing page with app branding</em></p>
    </td>
    <td>
      <img src="https://github.com/ShubhamKNIT/D-Artistry/raw/main/assets/images/D'Artistry%20Screenshot/Signin_Page.png" alt="Signin Page" width="300">
      <p align="center"><em>Signin Page: Allows users to log in</em></p>
    </td>
    <td>
      <img src="https://github.com/ShubhamKNIT/D-Artistry/raw/main/assets/images/D'Artistry%20Screenshot/Signup_Page.png" alt="Signup Page" width="300">
      <p align="center"><em>Signup Page: Enables new user registration</em></p>
    </td>
  </tr>
</table>


# Task Page and Add Task

This section showcases the Task Page and Add Task interface of the application:

<table>
  <tr>
    <td>
      <img src="https://github.com/ShubhamKNIT/D-Artistry/raw/main/assets/images/D'Artistry%20Screenshot/Todo_List_Light.png" alt="Todo List Light" width="300">
      <p align="center"><em>Todo List (Light Theme): Displays tasks in a light-themed interface</em></p>
    </td>
    <td>
      <img src="https://github.com/ShubhamKNIT/D-Artistry/raw/main/assets/images/D'Artistry%20Screenshot/Todo_list_dark.png" alt="Todo List Dark" width="300">
      <p align="center"><em>Todo List (Dark Theme): Shows tasks in a dark-themed interface</em></p>
    </td>
    <td>
      <img src="https://github.com/ShubhamKNIT/D-Artistry/raw/main/assets/images/D'Artistry%20Screenshot/Add_task.png" alt="Add Task" width="300">
      <p align="center"><em>Add Task: Allows users to create new tasks or activities</em></p>
    </td>
  </tr>
</table>

# Task Analytics and User Profile

This section illustrates the Task Analytics and User Profile screens:

<table>
  <tr>
    <td>
      <img src="https://github.com/ShubhamKNIT/D-Artistry/raw/main/assets/images/D'Artistry%20Screenshot/Task_Analytics.png" alt="Task Analytics" width="300">
      <p align="center"><em>Task Analytics: Provides insights and statistics about tasks and activities</em></p>
    </td>
    <td>
      <img src="https://github.com/ShubhamKNIT/D-Artistry/raw/main/assets/images/D'Artistry%20Screenshot/Profile.png" alt="User Profile" width="300">
      <p align="center"><em>User Profile: Displays user information and settings</em></p>
    </td>
    <td>
      <img src="https://github.com/ShubhamKNIT/D-Artistry/raw/main/assets/images/D'Artistry%20Screenshot/Edit_Profile.png" alt="Edit Profile" width="300">
      <p align="center"><em>Edit Profile: Allows users to modify their profile information</em></p>
    </td>
  </tr>
</table>

