import { SimpleSchema } from 'meteor/aldeed:simple-schema';

SimpleSchema.messages({
  required: '请输入 [label]',
  minString: '[label] 不能小于 [min] 个字符',
  maxString: '[label] 不能超过 [max] 个字符',
  minNumber: '[label] 不能小于 [min]',
  maxNumber: '[label] 不能超过 [max]',
  minDate: '[label] 不能早于 [min]',
  maxDate: '[label] 不能晚于 [max]',
  badDate: '[label] 不是一个合法的日期',
  minCount: '数值必须大于 [minCount]',
  maxCount: '数值必须小于 [maxCount]',
  noDecimal: '[label] 必须是整数',
  notAllowed: '[value] 不被允许',
  expectedString: '[label] 必须是字符',
  expectedNumber: '[label] 必须是数字',
  expectedBoolean: '[label] 必须是布尔类型',
  expectedArray: '[label] 必须是一个数组',
  expectedObject: '[label] 必须是一个对象',
  expectedConstructor: '[label] 必须是 [type]',
  regEx: [
    { msg: '[label] 格式不正确' },
    { exp: SimpleSchema.RegEx.Email, msg: '[label] 必须是一个合法的Email地址' },
    { exp: SimpleSchema.RegEx.WeakEmail, msg: '[label] 必须是一个合法的Email地址' },
    { exp: SimpleSchema.RegEx.Domain, msg: '[label] 必须是一个合法的域名地址' },
    { exp: SimpleSchema.RegEx.WeakDomain, msg: '[label] 必须是一个合法的域名地址' },
    { exp: SimpleSchema.RegEx.IP, msg: '[label] 必须是一个合法 IPv4 或 IPv6 地址' },
    { exp: SimpleSchema.RegEx.IPv4, msg: '[label] 必须是一个合法的 IPv4 地址' },
    { exp: SimpleSchema.RegEx.IPv6, msg: '[label] 必须是一个合法的 IPv6 地址' },
    { exp: SimpleSchema.RegEx.Url, msg: '[label] 必须是一个合法的URL地址' },
    { exp: SimpleSchema.RegEx.Id, msg: '[label] 必须是一个合法的 ID' },
  ],
  keyNotInSchema: '[key] 不在数据模型的允许范围内',
});
