# Contributing to ytnoti

:+1::tada: First off, thanks for taking the time to contribute! :tada::+1:

We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features
- Becoming a maintainer

## Table of Contents

- [How to Contribute to the codebase](#how-to-contribute-to-the-codebase)
- [How to localize SoruSora into a different language](#how-to-localize-sorusora-into-a-different-language)
- [Report bugs using Github's issues](#report-bugs-using-githubs-issues)
- [Write bug reports with detail, background, and sample code](#write-bug-reports-with-detail-background-and-sample-code)
- [Use a Consistent Coding Style](#use-a-consistent-coding-style)
- [License](#license)
- [Code of Conduct](#code-of-conduct)

## How to Contribute to the codebase

Pull requests are the best way to propose changes to the codebase (we use [Github Flow](https://guides.github.com/introduction/flow/index.html)). We actively welcome your pull requests:

1. Fork the repo and create your branch from `main`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the test suite passes.
5. Make sure your code lints.
6. Issue that pull request!

## Report bugs using Github's issues

We use GitHub issues to track public bugs. Report a bug by [opening a new issue](https://github.com/SeoulSKY/SoruSora/issues); it's that easy!

## Write bug reports with detail, background, and sample code

[This is an example](http://stackoverflow.com/q/12488905/180626) of a bug report that I think is not a bad model.

**Great Bug Reports** tend to have:

- A quick summary and/or background
- Steps to reproduce
  - Be specific!
  - Give a sample code if you can. [This stackoverflow question](http://stackoverflow.com/q/12488905/180626) includes sample code that _anyone_ with a base R setup can run to reproduce.
- What you expected would happen
- What actually happens
- Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)

People _love_ thorough bug reports. I'm not even kidding.

## Use a Consistent Coding Style

Follow [PEP 8 Guidelines](https://peps.python.org/pep-0008/), which are standard coding style guidelines for Python

- You can try running `pylint` for style unification

If you have any questions, please don't hesitate to ask. You can contact me via [Discord](https://discord.seoulsky.org) or email: contact@seoulsky.org.

## License

By contributing, you agree that your contributions will be licensed under its MIT License.

## Code of Conduct

Consider reading [Code of Conduct](https://github.com/SeoulSKY/ytnoti/blob/master/docs/CODE_OF_CONDUCT.md).
