DROP TABLE IF EXISTS program;

CREATE TABLE program
(
    id BIGSERIAL PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    description TEXT NOT NULL,
    ts tsvector generated always as (to_tsvector('english', name || ' ' || description)) stored
);

CREATE INDEX program_ts_idx ON program USING GIN (ts);

insert into program (name, description) values ('ViaSat, Inc.', 'Radio And Television Broadcasting And Communications Equipment');
insert into program (name, description) values ('Vanguard Long-Term Government Bond ETF', 'n/a');
insert into program (name, description) values ('PowerShares Nasdaq Internet Portfolio', 'n/a');
insert into program (name, description) values ('Great Lakes Dredge & Dock Corporation', 'Military/Government/Technical');
insert into program (name, description) values ('Capital Product Partners L.P.', 'Marine Transportation');
insert into program (name, description) values ('Community Bankers Trust Corporation.', 'Major Banks');
insert into program (name, description) values ('Vericel Corporation', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('PowerShares DWA Momentum Portfolio', 'n/a');
insert into program (name, description) values ('ARCA biopharma, Inc.', 'Biotechnology: In Vitro & In Vivo Diagnostic Substances');
insert into program (name, description) values ('WEX Inc.', 'Business Services');
insert into program (name, description) values ('Owens Corning Inc', 'Industrial Machinery/Components');
insert into program (name, description) values ('Fidelity Southern Corporation', 'Major Banks');
insert into program (name, description) values ('Spartan Motors, Inc.', 'Auto Manufacturing');
insert into program (name, description) values ('Annaly Capital Management Inc', 'n/a');
insert into program (name, description) values ('Mellanox Technologies, Ltd.', 'Semiconductors');
insert into program (name, description) values ('People''s United Financial, Inc.', 'Savings Institutions');
insert into program (name, description) values ('First Trust Developed Markets Ex-US AlphaDEX Fund', 'n/a');
insert into program (name, description) values ('Norwegian Cruise Line Holdings Ltd.', 'Marine Transportation');
insert into program (name, description) values ('TJX Companies, Inc. (The)', 'Clothing/Shoe/Accessory Stores');
insert into program (name, description) values ('CardConnect Corp.', 'Business Services');
insert into program (name, description) values ('Function(x) Inc.', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('Smart Sand, Inc.', 'n/a');
insert into program (name, description) values ('Patrick Industries, Inc.', 'Forest Products');
insert into program (name, description) values ('Brookdale Senior Living Inc.', 'Hospital/Nursing Management');
insert into program (name, description) values ('PROS Holdings, Inc.', 'EDP Services');
insert into program (name, description) values ('Red Rock Resorts, Inc.', 'Hotels/Resorts');
insert into program (name, description) values ('DISH Network Corporation', 'Television Services');
insert into program (name, description) values ('Watsco, Inc.', 'n/a');
insert into program (name, description) values ('Vaalco Energy Inc', 'Oil & Gas Production');
insert into program (name, description) values ('athenahealth, Inc.', 'Business Services');
insert into program (name, description) values ('Nuveen Quality Municipal Income Fund', 'n/a');
insert into program (name, description) values ('Eastman Chemical Company', 'Major Chemicals');
insert into program (name, description) values ('Versartis, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Willamette Valley Vineyards, Inc.', 'Beverages (Production/Distribution)');
insert into program (name, description) values ('The Hanover Insurance Group, Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Equinix, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('General Mills, Inc.', 'Packaged Foods');
insert into program (name, description) values ('Cellectis S.A.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('AxoGen, Inc.', 'Biotechnology: Electromedical & Electrotherapeutic Apparatus');
insert into program (name, description) values ('PDC Energy, Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('UNITIL Corporation', 'Power Generation');
insert into program (name, description) values ('Discovery Communications, Inc.', 'Television Services');
insert into program (name, description) values ('Colony NorthStar, Inc.', 'n/a');
insert into program (name, description) values ('ProShares UltraPro QQQ', 'n/a');
insert into program (name, description) values ('Verint Systems Inc.', 'EDP Services');
insert into program (name, description) values ('Ascena Retail Group, Inc.', 'Clothing/Shoe/Accessory Stores');
insert into program (name, description) values ('Carbonite, Inc.', 'EDP Services');
insert into program (name, description) values ('athenahealth, Inc.', 'Business Services');
insert into program (name, description) values ('Diana Containerships Inc.', 'Marine Transportation');
insert into program (name, description) values ('Nuveen Real Estate Fund', 'n/a');
insert into program (name, description) values ('Sumitomo Mitsui Financial Group Inc', 'Commercial Banks');
insert into program (name, description) values ('BlackRock New York Investment Quality Municipal Trust Inc. (Th', 'n/a');
insert into program (name, description) values ('The Bancorp, Inc.', 'Major Banks');
insert into program (name, description) values ('Chemours Company (The)', 'Major Chemicals');
insert into program (name, description) values ('Tetra Tech, Inc.', 'Military/Government/Technical');
insert into program (name, description) values ('Intermolecular, Inc.', 'Semiconductors');
insert into program (name, description) values ('PRGX Global, Inc.', 'Diversified Commercial Services');
insert into program (name, description) values ('Invesco California Value Municipal Income Trust', 'n/a');
insert into program (name, description) values ('C&F Financial Corporation', 'Major Banks');
insert into program (name, description) values ('Allegiant Travel Company', 'Air Freight/Delivery Services');
insert into program (name, description) values ('Wabco Holdings Inc.', 'Auto Manufacturing');
insert into program (name, description) values ('Bio-Techne Corp', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Tecogen Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('PNC Financial Services Group, Inc. (The)', 'Major Banks');
insert into program (name, description) values ('General Dynamics Corporation', 'Marine Transportation');
insert into program (name, description) values ('Cincinnati Bell Inc', 'Telecommunications Equipment');
insert into program (name, description) values ('Lake Shore Bancorp, Inc.', 'Savings Institutions');
insert into program (name, description) values ('Hyatt Hotels Corporation', 'Hotels/Resorts');
insert into program (name, description) values ('Amplify Online Retail ETF', 'n/a');
insert into program (name, description) values ('BGC Partners, Inc.', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('bluebird bio, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Royal Bank Scotland plc (The)', 'n/a');
insert into program (name, description) values ('Tuniu Corporation', 'Transportation Services');
insert into program (name, description) values ('Bioblast Pharma Ltd.', 'Major Pharmaceuticals');
insert into program (name, description) values ('GenMark Diagnostics, Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Northwest Natural Gas Company', 'Oil/Gas Transmission');
insert into program (name, description) values ('IDACORP, Inc.', 'Electric Utilities: Central');
insert into program (name, description) values ('Trans World Entertainment Corp.', 'Consumer Electronics/Video Chains');
insert into program (name, description) values ('ZTO Express (Cayman) Inc.', 'Trucking Freight/Courier Services');
insert into program (name, description) values ('First Defiance Financial Corp.', 'Savings Institutions');
insert into program (name, description) values ('LiNiu Technology Group', 'Services-Misc. Amusement & Recreation');
insert into program (name, description) values ('The Trade Desk, Inc.', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('SandRidge Mississippian Trust I', 'Oil & Gas Production');
insert into program (name, description) values ('People''s Utah Bancorp', 'Major Banks');
insert into program (name, description) values ('Unilever PLC', 'Package Goods/Cosmetics');
insert into program (name, description) values ('Salesforce.com Inc', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Yum China Holdings, Inc.', 'Restaurants');
insert into program (name, description) values ('StealthGas, Inc.', 'Marine Transportation');
insert into program (name, description) values ('GigaMedia Limited', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('argenx SE', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Barington/Hilco Acquisition Corp.', 'Business Services');
insert into program (name, description) values ('Barclays PLC', 'Commercial Banks');
insert into program (name, description) values ('Teekay LNG Partners L.P.', 'n/a');
insert into program (name, description) values ('Vanda Pharmaceuticals Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Landcadia Holdings, Inc.', 'Business Services');
insert into program (name, description) values ('Alder BioPharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('IAC/InterActiveCorp', 'Other Specialty Stores');
insert into program (name, description) values ('Ramaco Resources, Inc.', 'Coal Mining');
insert into program (name, description) values ('Alnylam Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('VivoPower International PLC', 'Power Generation');
insert into program (name, description) values ('Kayne Anderson Acquisition Corp.', 'Business Services');
insert into program (name, description) values ('Gabelli Dividend', 'n/a');
insert into program (name, description) values ('CABCO Series 2004-101 Trust', 'Finance: Consumer Services');
insert into program (name, description) values ('Cliffs Natural Resources Inc.', 'Precious Metals');
insert into program (name, description) values ('Sun Life Financial Inc.', 'Life Insurance');
insert into program (name, description) values ('Yatra Online, Inc.', 'Transportation Services');
insert into program (name, description) values ('LMP Capital and Income Fund Inc.', 'n/a');
insert into program (name, description) values ('Sparton Corporation', 'Electrical Products');
insert into program (name, description) values ('VelocityShares Daily 2x VIX Short-Term ETN', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('Royal Gold, Inc.', 'Precious Metals');
insert into program (name, description) values ('American Tower Corporation (REIT)', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Tower International, Inc.', 'Auto Parts:O.E.M.');
insert into program (name, description) values ('Organovo Holdings, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('First Trust/Aberdeen Global Opportunity Income Fund', 'n/a');
insert into program (name, description) values ('Five Star Senior Living Inc.', 'Hospital/Nursing Management');
insert into program (name, description) values ('Gulf Island Fabrication, Inc.', 'Metal Fabrications');
insert into program (name, description) values ('PowerShares 1-30 Laddered Treasury Portfolio', 'n/a');
insert into program (name, description) values ('WCF Bancorp, Inc.', 'Major Banks');
insert into program (name, description) values ('Wintrust Financial Corporation', 'Major Banks');
insert into program (name, description) values ('Summit State Bank', 'n/a');
insert into program (name, description) values ('Shopify Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Amaya Inc.', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('Garmin Ltd.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Kayne Anderson Acquisition Corp.', 'Business Services');
insert into program (name, description) values ('GrubHub Inc.', 'Business Services');
insert into program (name, description) values ('Timberland Bancorp, Inc.', 'Banks');
insert into program (name, description) values ('Warrior Met Coal, Inc.', 'Coal Mining');
insert into program (name, description) values ('Oil-Dri Corporation Of America', 'Miscellaneous manufacturing industries');
insert into program (name, description) values ('Merit Medical Systems, Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Leju Holdings Limited', 'Real Estate');
insert into program (name, description) values ('Autobytel Inc.', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('Ever-Glory International Group, Inc.', 'Apparel');
insert into program (name, description) values ('Diana Shipping inc.', 'Marine Transportation');
insert into program (name, description) values ('ConAgra Brands, Inc.', 'Packaged Foods');
insert into program (name, description) values ('Royal Bank Scotland plc (The)', 'Commercial Banks');
insert into program (name, description) values ('Intrawest Resorts Holdings, Inc.', 'Services-Misc. Amusement & Recreation');
insert into program (name, description) values ('Horizons DAX Germany ETF', 'n/a');
insert into program (name, description) values ('Liberty TripAdvisor Holdings, Inc.', 'EDP Services');
insert into program (name, description) values ('First Trust RiverFront Dynamic Europe ETF', 'n/a');
insert into program (name, description) values ('Golub Capital BDC, Inc.', 'n/a');
insert into program (name, description) values ('Inseego Corp.', 'Telecommunications Equipment');
insert into program (name, description) values ('Medley Management Inc.', 'Investment Managers');
insert into program (name, description) values ('REGENXBIO Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Prudential Global Short Duration High Yield Fund, Inc.', 'n/a');
insert into program (name, description) values ('Gores Holdings II, Inc.', 'Business Services');
insert into program (name, description) values ('Kulicke and Soffa Industries, Inc.', 'Semiconductors');
insert into program (name, description) values ('Chico''s FAS, Inc.', 'Clothing/Shoe/Accessory Stores');
insert into program (name, description) values ('Denbury Resources Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('Fortis Inc.', 'Electric Utilities: Central');
insert into program (name, description) values ('MMA Capital Management, LLC', 'Real Estate');
insert into program (name, description) values ('Western Asset Bond Fund', 'n/a');
insert into program (name, description) values ('C&F Financial Corporation', 'Major Banks');
insert into program (name, description) values ('DWS High Income Opportunities Fund, Inc.', 'n/a');
insert into program (name, description) values ('Nuveen New York Quality Municipal Income Fund', 'n/a');
insert into program (name, description) values ('WPX Energy, Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('Redwood Trust, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Inpixon ', 'EDP Services');
insert into program (name, description) values ('Red Lion Hotels Corporation', 'Hotels/Resorts');
insert into program (name, description) values ('Bellerophon Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Vornado Realty Trust', 'n/a');
insert into program (name, description) values ('Rice Midstream Partners LP', 'Natural Gas Distribution');
insert into program (name, description) values ('Saia, Inc.', 'Trucking Freight/Courier Services');
insert into program (name, description) values ('Franklin Covey Company', 'Other Consumer Services');
insert into program (name, description) values ('Handy & Harman Ltd.', 'Industrial Specialties');
insert into program (name, description) values ('Selecta Biosciences, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Curtiss-Wright Corporation', 'Industrial Machinery/Components');
insert into program (name, description) values ('Allied Healthcare Products, Inc.', 'Industrial Specialties');
insert into program (name, description) values ('Newell Brands Inc.', 'Plastic Products');
insert into program (name, description) values ('Xinyuan Real Estate Co Ltd', 'Homebuilding');
insert into program (name, description) values ('Steel Partners Holdings LP', 'n/a');
insert into program (name, description) values ('Embotelladora Andina S.A.', 'n/a');
insert into program (name, description) values ('Seattle Genetics, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Republic Services, Inc.', 'Environmental Services');
insert into program (name, description) values ('Abeona Therapeutics Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('RAIT Financial Trust', 'n/a');
insert into program (name, description) values ('MuleSoft, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Dollar General Corporation', 'Department/Specialty Retail Stores');
insert into program (name, description) values ('AK Steel Holding Corporation', 'Steel/Iron Ore');
insert into program (name, description) values ('ShoreTel, Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('Nuveen AMT-Free Quality Municipal Income Fund', 'n/a');
insert into program (name, description) values ('Alcentra Capital Corp.', 'n/a');
insert into program (name, description) values ('VictoryShares US 500 Enhanced Volatility Wtd ETF', 'n/a');
insert into program (name, description) values ('iStar Financial Inc.', 'n/a');
insert into program (name, description) values ('Universal Logistics Holdings, Inc.', 'Trucking Freight/Courier Services');
insert into program (name, description) values ('CYS Investments, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Southwestern Energy Company', 'Oil & Gas Production');
insert into program (name, description) values ('AmerisourceBergen Corporation (Holding Co)', 'Other Pharmaceuticals');
insert into program (name, description) values ('Vectren Corporation', 'Natural Gas Distribution');
insert into program (name, description) values ('Advance Auto Parts Inc', 'Other Specialty Stores');
insert into program (name, description) values ('ZIOPHARM Oncology Inc', 'Major Pharmaceuticals');
insert into program (name, description) values ('Entellus Medical, Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Guaranty Bancshares, Inc.', 'Major Banks');
insert into program (name, description) values ('KNOT Offshore Partners LP', 'Marine Transportation');
insert into program (name, description) values ('Yum China Holdings, Inc.', 'Restaurants');
insert into program (name, description) values ('ChinaCache International Holdings Ltd.', 'EDP Services');
insert into program (name, description) values ('Amedisys Inc', 'Medical/Nursing Services');
insert into program (name, description) values ('Gyrodyne , LLC', 'Building operators');
insert into program (name, description) values ('Boardwalk Pipeline Partners L.P.', 'Natural Gas Distribution');
insert into program (name, description) values ('Hancock Holding Company', 'Major Banks');
insert into program (name, description) values ('Diana Shipping inc.', 'n/a');
insert into program (name, description) values ('Severn Bancorp Inc', 'Major Banks');
insert into program (name, description) values ('Fulgent Genetics, Inc.', 'Medical Specialities');
insert into program (name, description) values ('Blue Buffalo Pet Products, Inc.', 'Packaged Foods');
insert into program (name, description) values ('ViaSat, Inc.', 'Radio And Television Broadcasting And Communications Equipment');
insert into program (name, description) values ('Waddell & Reed Financial, Inc.', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('Layne Christensen Company', 'Engineering & Construction');
insert into program (name, description) values ('Vanguard Long-Term Government Bond ETF', 'n/a');
insert into program (name, description) values ('WageWorks, Inc.', 'Business Services');
insert into program (name, description) values ('Genesco Inc.', 'Clothing/Shoe/Accessory Stores');
insert into program (name, description) values ('Varian Medical Systems, Inc.', 'Biotechnology: Electromedical & Electrotherapeutic Apparatus');
insert into program (name, description) values ('Diamond Offshore Drilling, Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('PowerShares DWA Basic Materials Momentum Portfolio', 'n/a');
insert into program (name, description) values ('UMB Financial Corporation', 'Major Banks');
insert into program (name, description) values ('Nuveen Insured New York Select Tax-Free Income Portfolio', 'n/a');
insert into program (name, description) values ('TriplePoint Venture Growth BDC Corp.', 'n/a');
insert into program (name, description) values ('ContraFect Corporation', 'Major Pharmaceuticals');
insert into program (name, description) values ('Home Bancorp, Inc.', 'Banks');
insert into program (name, description) values ('CTS Corporation', 'Electrical Products');
insert into program (name, description) values ('Peregrine Pharmaceuticals Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Nuveen NASDAQ 100 Dynamic Overwrite Fund', 'n/a');
insert into program (name, description) values ('Enbridge Inc', 'Natural Gas Distribution');
insert into program (name, description) values ('Crawford & Company', 'n/a');
insert into program (name, description) values ('Marriot Vacations Worldwide Corporation', 'Real Estate');
insert into program (name, description) values ('SPAR Group, Inc.', 'Business Services');
insert into program (name, description) values ('Stericycle, Inc.', 'Environmental Services');
insert into program (name, description) values ('Synovus Financial Corp.', 'Major Banks');
insert into program (name, description) values ('ContraVir Pharmaceuticals Inc', 'Major Pharmaceuticals');
insert into program (name, description) values ('Allstate Corporation (The)', 'n/a');
insert into program (name, description) values ('Antares Pharma, Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Nuvectra Corporation', 'Medical/Dental Instruments');
insert into program (name, description) values ('Albemarle Corporation', 'Major Chemicals');
insert into program (name, description) values ('Manchester United Ltd.', 'Services-Misc. Amusement & Recreation');
insert into program (name, description) values ('Mitek Systems, Inc.', 'Computer peripheral equipment');
insert into program (name, description) values ('Kirkland''s, Inc.', 'Other Specialty Stores');
insert into program (name, description) values ('Maximus, Inc.', 'Business Services');
insert into program (name, description) values ('Genesis Energy, L.P.', 'Oil Refining/Marketing');
insert into program (name, description) values ('InterDigital, Inc.', 'Multi-Sector Companies');
insert into program (name, description) values ('BancFirst Corporation', 'Major Banks');
insert into program (name, description) values ('Calamos Strategic Total Return Fund', 'n/a');
insert into program (name, description) values ('M I Acquisitions, Inc.', 'Business Services');
insert into program (name, description) values ('Morgan Stanley Asia-Pacific Fund, Inc.', 'n/a');
insert into program (name, description) values ('First Trust High Income ETF', 'n/a');
insert into program (name, description) values ('Blackrock MuniYield California Fund, Inc.', 'n/a');
insert into program (name, description) values ('Citigroup Inc.', 'n/a');
insert into program (name, description) values ('Nuveen Build America Bond Opportunity Fund', 'n/a');
insert into program (name, description) values ('Coty Inc.', 'Package Goods/Cosmetics');
insert into program (name, description) values ('LTC Properties, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('AmTrust Financial Services, Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Huaneng Power International, Inc.', 'Electric Utilities: Central');
insert into program (name, description) values ('Western Asset Mortgage Capital Corporation', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Lydall, Inc.', 'Auto Parts:O.E.M.');
insert into program (name, description) values ('Sinclair Broadcast Group, Inc.', 'Broadcasting');
insert into program (name, description) values ('Sanchez Energy Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('Alibaba Group Holding Limited', 'Business Services');
insert into program (name, description) values ('Yum! Brands, Inc.', 'Restaurants');
insert into program (name, description) values ('Government Properties Income Trust', 'Real Estate');
insert into program (name, description) values ('NetSol Technologies Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Rowan Companies plc', 'Oil & Gas Production');
insert into program (name, description) values ('Kite Pharma, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Bridge Bancorp, Inc.', 'Major Banks');
insert into program (name, description) values ('Cooper-Standard Holdings Inc.', 'Auto Parts:O.E.M.');
insert into program (name, description) values ('Blackrock Muni New York Intermediate Duration Fund Inc', 'n/a');
insert into program (name, description) values ('Axon Enterprise, Inc.', 'Ordnance And Accessories');
insert into program (name, description) values ('Mirna Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('First Trust New Opportunities MLP & Energy Fund', 'n/a');
insert into program (name, description) values ('C', 'Oilfield Services/Equipment');
insert into program (name, description) values ('Tennessee Valley Authority', 'Electric Utilities: Central');
insert into program (name, description) values ('ACNB Corporation', 'Major Banks');
insert into program (name, description) values ('DTE Energy Company', 'Electric Utilities: Central');
insert into program (name, description) values ('WMIH Corp.', 'Finance: Consumer Services');
insert into program (name, description) values ('CVR Refining, LP', 'Integrated oil Companies');
insert into program (name, description) values ('Insys Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Fortress Biotech, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Global X S&P 500 Catholic Values ETF', 'n/a');
insert into program (name, description) values ('J P Morgan Chase & Co', 'n/a');
insert into program (name, description) values ('Gladstone Capital Corporation', 'n/a');
insert into program (name, description) values ('B. Riley Financial, Inc.', 'Business Services');
insert into program (name, description) values ('Imax Corporation', 'Industrial Machinery/Components');
insert into program (name, description) values ('Delta Natural Gas Company, Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('MMA Capital Management, LLC', 'Real Estate');
insert into program (name, description) values ('Sunesis Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Tortoise Energy Independence Fund, Inc.', 'n/a');
insert into program (name, description) values ('VelocityShares 3x Long Silver ETN', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('Universal Display Corporation', 'Electrical Products');
insert into program (name, description) values ('Trex Company, Inc.', 'Forest Products');
insert into program (name, description) values ('Saia, Inc.', 'Trucking Freight/Courier Services');
insert into program (name, description) values ('White Mountains Insurance Group, Ltd.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Innophos Holdings, Inc.', 'Specialty Chemicals');
insert into program (name, description) values ('Seanergy Maritime Holdings Corp', 'Marine Transportation');
insert into program (name, description) values ('Flex Ltd.', 'Electrical Products');
insert into program (name, description) values ('BlackRock, Inc.', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('Pain Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Yatra Online, Inc.', 'Transportation Services');
insert into program (name, description) values ('Nuveen Virginia Quality Municipal Income Fund', 'n/a');
insert into program (name, description) values ('Blackstone / GSO Strategic Credit Fund', 'n/a');
insert into program (name, description) values ('PowerShares International Dividend Achievers Portfolio', 'n/a');
insert into program (name, description) values ('Cedar Realty Trust, Inc.', 'n/a');
insert into program (name, description) values ('Lindsay Corporation', 'Industrial Machinery/Components');
insert into program (name, description) values ('Ultragenyx Pharmaceutical Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Crawford & Company', 'n/a');
insert into program (name, description) values ('Fenix Parts, Inc.', 'Motor Vehicles');
insert into program (name, description) values ('W.P. Carey Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('CYS Investments, Inc.', 'n/a');
insert into program (name, description) values ('Vornado Realty Trust', 'n/a');
insert into program (name, description) values ('FS Investment Corporation', 'n/a');
insert into program (name, description) values ('Cohen & Steers Quality Income Realty Fund Inc', 'n/a');
insert into program (name, description) values ('Equity Commonwealth', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Simon Property Group, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Royce Global Value Trust, Inc.', 'n/a');
insert into program (name, description) values ('Darling Ingredients Inc.', 'Packaged Foods');
insert into program (name, description) values ('Nuveen Select Tax Free Income Portfolio II', 'n/a');
insert into program (name, description) values ('HubSpot, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Washington Prime Group Inc.', 'n/a');
insert into program (name, description) values ('Boston Beer Company, Inc. (The)', 'Beverages (Production/Distribution)');
insert into program (name, description) values ('Rigel Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Ashford Hospitality Trust Inc', 'n/a');
insert into program (name, description) values ('Berkshire Hathaway Inc.', 'n/a');
insert into program (name, description) values ('First Trust Global Tactical Commodity Strategy Fund', 'n/a');
insert into program (name, description) values ('Third Point Reinsurance Ltd.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Vanguard Short-Term Inflation-Protected Securities Index Fund', 'n/a');
insert into program (name, description) values ('Ingles Markets, Incorporated', 'Food Chains');
insert into program (name, description) values ('Raytheon Company', 'Industrial Machinery/Components');
insert into program (name, description) values ('Exxon Mobil Corporation', 'Integrated oil Companies');
insert into program (name, description) values ('Goldman Sachs Group, Inc. (The)', 'n/a');
insert into program (name, description) values ('Level 3 Communications, Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('Gores Holdings II, Inc.', 'Business Services');
insert into program (name, description) values ('Embotelladora Andina S.A.', 'n/a');
insert into program (name, description) values ('Paratek Pharmaceuticals, Inc. ', 'Major Pharmaceuticals');
insert into program (name, description) values ('Towne Bank', 'n/a');
insert into program (name, description) values ('TOR Minerals International Inc', 'Major Chemicals');
insert into program (name, description) values ('Meridian Waste Solutions, Inc', 'Miscellaneous');
insert into program (name, description) values ('Western Asset Global High Income Fund Inc', 'n/a');
insert into program (name, description) values ('Intelsat S.A.', 'Telecommunications Equipment');
insert into program (name, description) values ('Alleghany Corporation', 'Property-Casualty Insurers');
insert into program (name, description) values ('Ethan Allen Interiors Inc.', 'Home Furnishings');
insert into program (name, description) values ('Union Bankshares Corporation', 'Major Banks');
insert into program (name, description) values ('Kitov Pharmaceuticals Holdings Ltd.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Qwest Corporation', 'Telecommunications Equipment');
insert into program (name, description) values ('RenaissanceRe Holdings Ltd.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Ultragenyx Pharmaceutical Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('BullMark LatAm Select Leaders ETF', 'n/a');
insert into program (name, description) values ('Bio-Path Holdings, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Trustmark Corporation', 'Major Banks');
insert into program (name, description) values ('Swiss Helvetia Fund, Inc. (The)', 'n/a');
insert into program (name, description) values ('Power Integrations, Inc.', 'Semiconductors');
insert into program (name, description) values ('Huntington Bancshares Incorporated', 'Major Banks');
insert into program (name, description) values ('The Bancorp, Inc.', 'Major Banks');
insert into program (name, description) values ('Sasol Ltd.', 'Oil & Gas Production');
insert into program (name, description) values ('Eaton Vance NextShares Trust II', 'n/a');
insert into program (name, description) values ('Essent Group Ltd.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Nuveen North Carolina Quality Municipal Income Fd', 'n/a');
insert into program (name, description) values ('Summit Financial Group, Inc.', 'Major Banks');
insert into program (name, description) values ('China Distance Education Holdings Limited', 'Other Consumer Services');
insert into program (name, description) values ('Celanese Corporation', 'Major Chemicals');
insert into program (name, description) values ('Astec Industries, Inc.', 'Construction/Ag Equipment/Trucks');
insert into program (name, description) values ('Oncobiologics, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('AmTrust Financial Services, Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('VelocityShares Daily 2x VIX Medium-Term ETN', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('AquaVenture Holdings Limited', 'Water Supply');
insert into program (name, description) values ('FlexShares STOXX Global ESG Impact Index Fund', 'n/a');
insert into program (name, description) values ('John Hancock Tax Advantaged Dividend Income Fund', 'n/a');
insert into program (name, description) values ('Dynex Capital, Inc.', 'n/a');
insert into program (name, description) values ('Star Bulk Carriers Corp.', 'Marine Transportation');
insert into program (name, description) values ('Arch Capital Group Ltd.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Boston Private Financial Holdings, Inc.', 'Major Banks');
insert into program (name, description) values ('Immunomedics, Inc.', 'Biotechnology: In Vitro & In Vivo Diagnostic Substances');
insert into program (name, description) values ('Kingstone Companies, Inc', 'Property-Casualty Insurers');
insert into program (name, description) values ('Athenex, Inc.', 'n/a');
insert into program (name, description) values ('Sunshine Bancorp, Inc.', 'Savings Institutions');
insert into program (name, description) values ('Gabelli Equity Trust, Inc. (The)', 'n/a');
insert into program (name, description) values ('Eaton Vance Tax Advantaged Dividend Income Fund', 'n/a');
insert into program (name, description) values ('Blackrock MuniHoldings New York Quality Fund, Inc.', 'n/a');
insert into program (name, description) values ('China Information Technology, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Optibase Ltd.', 'Real Estate');
insert into program (name, description) values ('Abeona Therapeutics Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Digimarc Corporation', 'EDP Services');
insert into program (name, description) values ('HDFC Bank Limited', 'Commercial Banks');
insert into program (name, description) values ('ProAssurance Corporation', 'Property-Casualty Insurers');
insert into program (name, description) values ('Intuitive Surgical, Inc.', 'Industrial Specialties');
insert into program (name, description) values ('RiceBran Technologies', 'Packaged Foods');
insert into program (name, description) values ('BlackRock Investment Quality Municipal Trust Inc. (The)', 'n/a');
insert into program (name, description) values ('Spirit Realty Capital, Inc.', 'Building operators');
insert into program (name, description) values ('Synchronoss Technologies, Inc.', 'EDP Services');
insert into program (name, description) values ('Columbus McKinnon Corporation', 'Construction/Ag Equipment/Trucks');
insert into program (name, description) values ('Gladstone Land Corporation', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Voya Prime Rate Trust', 'n/a');
insert into program (name, description) values ('Duff & Phelps Utilities Income, Inc.', 'n/a');
insert into program (name, description) values ('Nuveen New York Quality Municipal Income Fund', 'n/a');
insert into program (name, description) values ('Hoegh LNG Partners LP', 'Marine Transportation');
insert into program (name, description) values ('Nova Measuring Instruments Ltd.', 'Electronic Components');
insert into program (name, description) values ('Nuveen Connecticut Quality Municipal Income Fund', 'n/a');
insert into program (name, description) values ('Noah Holdings Ltd.', 'Investment Managers');
insert into program (name, description) values ('Neos Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Natural Alternatives International, Inc.', 'Specialty Chemicals');
insert into program (name, description) values ('Colony NorthStar, Inc.', 'n/a');
insert into program (name, description) values ('VelocityShares Daily Inverse VIX Short-Term ETN', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('Superconductor Technologies Inc.', 'Radio And Television Broadcasting And Communications Equipment');
insert into program (name, description) values ('Endurance Specialty Holdings Ltd', 'n/a');
insert into program (name, description) values ('Targa Resources Partners LP', 'n/a');
insert into program (name, description) values ('SJW Group', 'Water Supply');
insert into program (name, description) values ('Apollo Investment Corporation', 'n/a');
insert into program (name, description) values ('United Therapeutics Corporation', 'Major Pharmaceuticals');
insert into program (name, description) values ('Yelp Inc.', 'Other Consumer Services');
insert into program (name, description) values ('VelocityShares VIX Medium-Term ETN', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('First Trust Mid Cap Core AlphaDEX Fund', 'n/a');
insert into program (name, description) values ('Penn Virginia Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('Zendesk, Inc.', 'EDP Services');
insert into program (name, description) values ('Braskem S.A.', 'Major Chemicals');
insert into program (name, description) values ('Western Asset Global High Income Fund Inc', 'n/a');
insert into program (name, description) values ('Evolent Health, Inc', 'Other Consumer Services');
insert into program (name, description) values ('M/I Homes, Inc.', 'n/a');
insert into program (name, description) values ('Flaherty & Crumrine Dynamic Preferred and Income Fund Inc.', 'n/a');
insert into program (name, description) values ('Gladstone Land Corporation', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Winmark Corporation', 'Other Specialty Stores');
insert into program (name, description) values ('Alexander & Baldwin Holdings, Inc.', 'Real Estate');
insert into program (name, description) values ('Ritchie Bros. Auctioneers Incorporated', 'Business Services');
insert into program (name, description) values ('First Trust Global Tactical Commodity Strategy Fund', 'n/a');
insert into program (name, description) values ('AG Mortgage Investment Trust, Inc.', 'n/a');
insert into program (name, description) values ('Quest Resource Holding Corporation.', 'Diversified Commercial Services');
insert into program (name, description) values ('Red Hat, Inc.', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('Alliant Energy Corporation', 'Power Generation');
insert into program (name, description) values ('Cambium Learning Group, Inc.', 'Publishing');
insert into program (name, description) values ('Lyon William Homes', 'Homebuilding');
insert into program (name, description) values ('R.R. Donnelley & Sons Company', 'Publishing');
insert into program (name, description) values ('First Trust Large Cap Value AlphaDEX Fund', 'n/a');
insert into program (name, description) values ('Five Star Senior Living Inc.', 'Hospital/Nursing Management');
insert into program (name, description) values ('Atossa Genetics Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('India Fund, Inc. (The)', 'n/a');
insert into program (name, description) values ('Platform Specialty Products Corporation', 'Major Chemicals');
insert into program (name, description) values ('Citigroup Inc.', 'n/a');
insert into program (name, description) values ('RiverNorth/DoubleLine Strategic Opportunity Fund, Inc.', 'n/a');
insert into program (name, description) values ('Rubicon Technology, Inc.', 'Semiconductors');
insert into program (name, description) values ('Gabelli Convertible and Income Securities Fund, Inc. (The)', 'n/a');
insert into program (name, description) values ('Quantum Corporation', 'Electronic Components');
insert into program (name, description) values ('SandRidge Mississippian Trust I', 'Oil & Gas Production');
insert into program (name, description) values ('Bank of the James Financial Group, Inc.', 'Major Banks');
insert into program (name, description) values ('ConocoPhillips', 'Integrated oil Companies');
insert into program (name, description) values ('Emerson Electric Company', 'Consumer Electronics/Appliances');
insert into program (name, description) values ('FlexShopper, Inc.', 'Diversified Commercial Services');
insert into program (name, description) values ('Marriot Vacations Worldwide Corporation', 'Real Estate');
insert into program (name, description) values ('Best Buy Co., Inc.', 'Consumer Electronics/Video Chains');
insert into program (name, description) values ('Rayonier Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Tesoro Corporation', 'Integrated oil Companies');
insert into program (name, description) values ('Ultragenyx Pharmaceutical Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('AMTEK, Inc.', 'Metal Fabrications');
insert into program (name, description) values ('Daily Journal Corp. (S.C.)', 'Newspapers/Magazines');
insert into program (name, description) values ('Energy Transfer Partners, L.P.', 'Natural Gas Distribution');
insert into program (name, description) values ('Randgold Resources Limited', 'Precious Metals');
insert into program (name, description) values ('Goldman Sachs Group, Inc. (The)', 'n/a');
insert into program (name, description) values ('voxeljet AG', 'Industrial Machinery/Components');
insert into program (name, description) values ('Mercantile Bank Corporation', 'Major Banks');
insert into program (name, description) values ('YY Inc.', 'EDP Services');
insert into program (name, description) values ('CytomX Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Zions Bancorporation', 'Major Banks');
insert into program (name, description) values ('Caleres, Inc.', 'Shoe Manufacturing');
insert into program (name, description) values ('Lions Gate Entertainment Corporation', 'n/a');
insert into program (name, description) values ('PowerShares DWA Basic Materials Momentum Portfolio', 'n/a');
insert into program (name, description) values ('Universal Electronics Inc.', 'Consumer Electronics/Appliances');
insert into program (name, description) values ('FlexShares Credit-Scored US Corporate Bond Index Fund', 'n/a');
insert into program (name, description) values ('Capstone Turbine Corporation', 'Industrial Machinery/Components');
insert into program (name, description) values ('Hess Corporation', 'n/a');
insert into program (name, description) values ('TravelCenters of America LLC', 'Automotive Aftermarket');
insert into program (name, description) values ('Alon USA Partners, LP', 'Integrated oil Companies');
insert into program (name, description) values ('Terreno Realty Corporation', 'Real Estate');
insert into program (name, description) values ('Kaiser Aluminum Corporation', 'Metal Fabrications');
insert into program (name, description) values ('Pimco Corporate & Income Opportunity Fund', 'n/a');
insert into program (name, description) values ('Senior Housing Properties Trust', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Second Sight Medical Products, Inc.', 'n/a');
insert into program (name, description) values ('Colony Starwood Homes', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Essent Group Ltd.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Pinnacle Entertainment, Inc.', 'Hotels/Resorts');
insert into program (name, description) values ('WildHorse Resource Development Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('Vanguard Emerging Markets Government Bond ETF', 'n/a');
insert into program (name, description) values ('FinTech Acquisition Corp. II', 'Business Services');
insert into program (name, description) values ('Jabil Inc.', 'Electrical Products');
insert into program (name, description) values ('The ONE Group Hospitality, Inc.', 'Restaurants');
insert into program (name, description) values ('Vanguard Russell 3000 ETF', 'n/a');
insert into program (name, description) values ('Companhia de saneamento Basico Do Estado De Sao Paulo - Sabesp', 'Water Supply');
insert into program (name, description) values ('Essendant Inc.', 'Paper');
insert into program (name, description) values ('Nuveen High Income 2020 Target Term Fund', 'n/a');
insert into program (name, description) values ('Blue Hills Bancorp, Inc.', 'Major Banks');
insert into program (name, description) values ('Tejon Ranch Co', 'Real Estate');
insert into program (name, description) values ('Medley Capital Corporation', 'n/a');
insert into program (name, description) values ('KKR & Co. L.P.', 'n/a');
insert into program (name, description) values ('Manchester United Ltd.', 'Services-Misc. Amusement & Recreation');
insert into program (name, description) values ('CABCO Series 2004-101 Trust', 'Finance: Consumer Services');
insert into program (name, description) values ('First Busey Corporation', 'Major Banks');
insert into program (name, description) values ('Shore Bancshares Inc', 'Major Banks');
insert into program (name, description) values ('Medley Management Inc.', 'Investment Managers');
insert into program (name, description) values ('California First National Bancorp', 'Major Banks');
insert into program (name, description) values ('ViewRay, Inc.', 'Biotechnology: Electromedical & Electrotherapeutic Apparatus');
insert into program (name, description) values ('Trillium Therapeutics Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Immuron Limited', 'Major Pharmaceuticals');
insert into program (name, description) values ('iShares Morningstar Mid-Cap ETF', 'n/a');
insert into program (name, description) values ('Merrill Lynch & Co., Inc.', 'n/a');
insert into program (name, description) values ('Cabot Microelectronics Corporation', 'Semiconductors');
insert into program (name, description) values ('Sherwin-Williams Company (The)', 'RETAIL: Building Materials');
insert into program (name, description) values ('Sorrento Therapeutics, Inc.', 'Biotechnology: Commercial Physical & Biological Resarch');
insert into program (name, description) values ('ASV Holdings, Inc.', 'Construction/Ag Equipment/Trucks');
insert into program (name, description) values ('Crocs, Inc.', 'Shoe Manufacturing');
insert into program (name, description) values ('Five Below, Inc.', 'Department/Specialty Retail Stores');
insert into program (name, description) values ('Tandy Leather Factory, Inc.', 'Apparel');
insert into program (name, description) values ('Enphase Energy, Inc.', 'Semiconductors');
insert into program (name, description) values ('DAVIDsTEA Inc.', 'Food Chains');
insert into program (name, description) values ('Xerium Technologies, Inc.', 'Textiles');
insert into program (name, description) values ('American Assets Trust, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Sigma Labs, Inc.', 'Miscellaneous manufacturing industries');
insert into program (name, description) values ('Tenax Therapeutics, Inc.', 'Biotechnology: Commercial Physical & Biological Resarch');
insert into program (name, description) values ('PIMCO California Municipal Income Fund', 'n/a');
insert into program (name, description) values ('Natera, Inc.', 'Medical Specialities');
insert into program (name, description) values ('Bank of Commerce Holdings (CA)', 'Major Banks');
insert into program (name, description) values ('Winmark Corporation', 'Other Specialty Stores');
insert into program (name, description) values ('Tower International, Inc.', 'Auto Parts:O.E.M.');
insert into program (name, description) values ('Colony NorthStar, Inc.', 'n/a');
insert into program (name, description) values ('Mesa Laboratories, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('United Continental Holdings, Inc.', 'Air Freight/Delivery Services');
insert into program (name, description) values ('Kimco Realty Corporation', 'Real Estate Investment Trusts');
insert into program (name, description) values ('John Hancock Investors Trust', 'n/a');
insert into program (name, description) values ('Bonso Electronics International, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Verona Pharma plc', 'Major Pharmaceuticals');
insert into program (name, description) values ('IQ Chaikin U.S. Small Cap ETF', 'n/a');
insert into program (name, description) values ('Stewart Information Services Corporation', 'Specialty Insurers');
insert into program (name, description) values ('NutriSystem Inc', 'Catalog/Specialty Distribution');
insert into program (name, description) values ('Washington Trust Bancorp, Inc.', 'Major Banks');
insert into program (name, description) values ('Ardmore Shipping Corporation', 'Marine Transportation');
insert into program (name, description) values ('Protective Life Corporation', 'n/a');
insert into program (name, description) values ('Iridium Communications Inc', 'Telecommunications Equipment');
insert into program (name, description) values ('Elbit Systems Ltd.', 'Military/Government/Technical');
insert into program (name, description) values ('Toll Brothers Inc.', 'Homebuilding');
insert into program (name, description) values ('PowerShares S&P SmallCap Energy Portfolio', 'n/a');
insert into program (name, description) values ('Emerald Expositions Events, Inc.', 'Business Services');
insert into program (name, description) values ('Weyco Group, Inc.', 'Apparel');
insert into program (name, description) values ('P & F Industries, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Workday, Inc.', 'EDP Services');
insert into program (name, description) values ('DTE Energy Company', 'Electric Utilities: Central');
insert into program (name, description) values ('Tortoise Power and Energy Infrastructure Fund, Inc', 'n/a');
insert into program (name, description) values ('ASML Holding N.V.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Tootsie Roll Industries, Inc.', 'Specialty Foods');
insert into program (name, description) values ('R.R. Donnelley & Sons Company', 'Publishing');
insert into program (name, description) values ('Revolution Lighting Technologies, Inc.', 'Building Products');
insert into program (name, description) values ('Blackrock Corporate High Yield Fund, Inc.', 'n/a');
insert into program (name, description) values ('Diana Shipping inc.', 'Marine Transportation');
insert into program (name, description) values ('OM Asset Management plc', 'Investment Managers');
insert into program (name, description) values ('Entergy Mississippi, Inc.', 'Electric Utilities: Central');
insert into program (name, description) values ('Wintrust Financial Corporation', 'Major Banks');
insert into program (name, description) values ('Exact Sciences Corporation', 'Biotechnology: Commercial Physical & Biological Resarch');
insert into program (name, description) values ('Highland/iBoxx Senior Loan ETF', 'n/a');
insert into program (name, description) values ('MidWestOne Financial Group, Inc.', 'Major Banks');
insert into program (name, description) values ('Tetraphase Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Vipshop Holdings Limited', 'Catalog/Specialty Distribution');
insert into program (name, description) values ('Western Alliance Bancorporation', 'Major Banks');
insert into program (name, description) values ('American Homes 4 Rent', 'n/a');
insert into program (name, description) values ('Saban Capital Acquisition Corp.', 'n/a');
insert into program (name, description) values ('Brooks Automation, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Liberty TripAdvisor Holdings, Inc.', 'EDP Services');
insert into program (name, description) values ('Luxottica Group, S.p.A.', 'Ophthalmic Goods');
insert into program (name, description) values ('Origo Acquisition Corporation', 'Business Services');
insert into program (name, description) values ('Kayne Anderson MLP Investment Company', 'n/a');
insert into program (name, description) values ('Cowen Inc.', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('Stewart Information Services Corporation', 'Specialty Insurers');
insert into program (name, description) values ('Sirius XM Holdings Inc.', 'Broadcasting');
insert into program (name, description) values ('Waddell & Reed Financial, Inc.', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('TJX Companies, Inc. (The)', 'Clothing/Shoe/Accessory Stores');
insert into program (name, description) values ('Atmos Energy Corporation', 'Oil/Gas Transmission');
insert into program (name, description) values ('Anthem, Inc.', 'Medical Specialities');
insert into program (name, description) values ('CareDx, Inc.', 'Medical Specialities');
insert into program (name, description) values ('Strattec Security Corporation', 'Auto Parts:O.E.M.');
insert into program (name, description) values ('LaSalle Hotel Properties', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Global X S&P 500 Catholic Values ETF', 'n/a');
insert into program (name, description) values ('Public Storage', 'Real Estate Investment Trusts');
insert into program (name, description) values ('PowerShares S&P SmallCap Energy Portfolio', 'n/a');
insert into program (name, description) values ('Global Sources Ltd.', 'Advertising');
insert into program (name, description) values ('Vina Concha Y Toro', 'Beverages (Production/Distribution)');
insert into program (name, description) values ('PGT Innovations, Inc.', 'Building Products');
insert into program (name, description) values ('Pennsylvania Real Estate Investment Trust', 'n/a');
insert into program (name, description) values ('Bankrate, Inc.', 'EDP Services');
insert into program (name, description) values ('Hanwha Q CELLS Co., Ltd. ', 'Semiconductors');
insert into program (name, description) values ('Western Asset Global Corporate Defined Opportunity Fund Inc.', 'n/a');
insert into program (name, description) values ('WhiteHorse Finance, Inc.', 'n/a');
insert into program (name, description) values ('Lyon William Homes', 'Homebuilding');
insert into program (name, description) values ('Wheeler Real Estate Investment Trust, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('MINDBODY, Inc.', 'EDP Services');
insert into program (name, description) values ('SPS Commerce, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('South State Corporation', 'Major Banks');
insert into program (name, description) values ('Piper Jaffray Companies', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('Abercrombie & Fitch Company', 'Clothing/Shoe/Accessory Stores');
insert into program (name, description) values ('OFG Bancorp', 'Major Banks');
insert into program (name, description) values ('EMCOR Group, Inc.', 'Engineering & Construction');
insert into program (name, description) values ('AG Mortgage Investment Trust, Inc.', 'n/a');
insert into program (name, description) values ('NextEra Energy, Inc.', 'n/a');
insert into program (name, description) values ('MDU Resources Group, Inc.', 'Mining & Quarrying of Nonmetallic Minerals (No Fuels)');
insert into program (name, description) values ('CHS Inc', 'Farming/Seeds/Milling');
insert into program (name, description) values ('PIMCO Municipal Income Fund III', 'n/a');
insert into program (name, description) values ('1-800 FLOWERS.COM, Inc.', 'Other Specialty Stores');
insert into program (name, description) values ('Quad Graphics, Inc', 'Publishing');
insert into program (name, description) values ('First Trust RiverFront Dynamic Asia Pacific ETF', 'n/a');
insert into program (name, description) values ('Mota Group, Inc.', 'n/a');
insert into program (name, description) values ('American Homes 4 Rent', 'n/a');
insert into program (name, description) values ('Public Storage', 'Real Estate Investment Trusts');
insert into program (name, description) values ('HMN Financial, Inc.', 'Savings Institutions');
insert into program (name, description) values ('Huntington Bancshares Incorporated', 'Major Banks');
insert into program (name, description) values ('Manitex International, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Remark Holdings, Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('Applied DNA Sciences Inc', 'Other Consumer Services');
insert into program (name, description) values ('Liberty Interactive Corporation', 'Catalog/Specialty Distribution');
insert into program (name, description) values ('Stellus Capital Investment Corporation', 'n/a');
insert into program (name, description) values ('Noah Holdings Ltd.', 'Investment Managers');
insert into program (name, description) values ('Tribune Media Company', 'Broadcasting');
insert into program (name, description) values ('Gridsum Holding Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Eastern Company (The)', 'Industrial Machinery/Components');
insert into program (name, description) values ('Ohio Valley Banc Corp.', 'Major Banks');
insert into program (name, description) values ('Synthetic Fixed-Income Securities, Inc.', 'Finance: Consumer Services');
insert into program (name, description) values ('Tetraphase Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Akebia Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Shutterstock, Inc.', 'EDP Services');
insert into program (name, description) values ('Signature Bank', 'Major Banks');
insert into program (name, description) values ('MFA Financial, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('CTI Industries Corporation', 'Specialty Chemicals');
insert into program (name, description) values ('Medpace Holdings, Inc.', 'Biotechnology: Commercial Physical & Biological Resarch');
insert into program (name, description) values ('Naked Brand Group Inc.', 'Apparel');
insert into program (name, description) values ('Greif Bros. Corporation', 'n/a');
insert into program (name, description) values ('Patrick Industries, Inc.', 'Forest Products');
insert into program (name, description) values ('Rapid7, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Royal Bank Scotland plc (The)', 'Commercial Banks');
insert into program (name, description) values ('Invitation Homes Inc.', 'Real Estate');
insert into program (name, description) values ('Siebert Financial Corp.', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('Eastern Company (The)', 'Industrial Machinery/Components');
insert into program (name, description) values ('Discover Financial Services', 'Finance: Consumer Services');
insert into program (name, description) values ('Viad Corp', 'Business Services');
insert into program (name, description) values ('American Tower Corporation (REIT)', 'Real Estate Investment Trusts');
insert into program (name, description) values ('TrovaGene, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('United States Cellular Corporation', 'Telecommunications Equipment');
insert into program (name, description) values ('Boston Omaha Corporation', 'n/a');
insert into program (name, description) values ('Syndax Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Health Insurance Innovations, Inc.', 'Specialty Insurers');
insert into program (name, description) values ('Gladstone Investment Corporation', 'n/a');
insert into program (name, description) values ('AutoNation, Inc.', 'Automotive Aftermarket');
insert into program (name, description) values ('Colonial Investment Grade Municipal Trust', 'n/a');
insert into program (name, description) values ('Blackrock Global', 'n/a');
insert into program (name, description) values ('American States Water Company', 'Water Supply');
insert into program (name, description) values ('Torchmark Corporation', 'n/a');
insert into program (name, description) values ('Agilent Technologies, Inc.', 'Biotechnology: Laboratory Analytical Instruments');
insert into program (name, description) values ('Landauer, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('CVB Financial Corporation', 'Major Banks');
insert into program (name, description) values ('Merrimack Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Endocyte, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('VictoryShares Developed Enhanced Volatility Wtd ETF', 'n/a');
insert into program (name, description) values ('Sophiris Bio, Inc.', 'n/a');
insert into program (name, description) values ('Ocean Bio-Chem, Inc.', 'Specialty Chemicals');
insert into program (name, description) values ('Viking Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('ServiceNow, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Five Oaks Investment Corp.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Atlassian Corporation Plc', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Bioanalytical Systems, Inc.', 'Biotechnology: Commercial Physical & Biological Resarch');
insert into program (name, description) values ('Zosano Pharma Corporation', 'Major Pharmaceuticals');
insert into program (name, description) values ('Helix Energy Solutions Group, Inc.', 'Oilfield Services/Equipment');
insert into program (name, description) values ('CMS Energy Corporation', 'Power Generation');
insert into program (name, description) values ('PCM, Inc.', 'Catalog/Specialty Distribution');
insert into program (name, description) values ('Customers Bancorp, Inc', 'n/a');
insert into program (name, description) values ('QIWI plc', 'Business Services');
insert into program (name, description) values ('NL Industries, Inc.', 'Major Chemicals');
insert into program (name, description) values ('PACCAR Inc.', 'Auto Manufacturing');
insert into program (name, description) values ('Alabama Power Company', 'Electric Utilities: Central');
insert into program (name, description) values ('Hovnanian Enterprises Inc', 'Homebuilding');
insert into program (name, description) values ('PowerShares DWA Emerging Markets Momentum Portfolio', 'n/a');
insert into program (name, description) values ('Sterling Bancorp', 'Major Banks');
insert into program (name, description) values ('Pinnacle West Capital Corporation', 'Electric Utilities: Central');
insert into program (name, description) values ('Ichor Holdings', 'Semiconductors');
insert into program (name, description) values ('Liberty Global plc', 'Television Services');
insert into program (name, description) values ('Rush Enterprises, Inc.', 'Automotive Aftermarket');
insert into program (name, description) values ('Lake Shore Bancorp, Inc.', 'Savings Institutions');
insert into program (name, description) values ('Auburn National Bancorporation, Inc.', 'Major Banks');
insert into program (name, description) values ('Pimco Income Opportunity Fund', 'n/a');
insert into program (name, description) values ('Accenture plc', 'Business Services');
insert into program (name, description) values ('Rush Enterprises, Inc.', 'Automotive Aftermarket');
insert into program (name, description) values ('Scudder Strategic Income Trust', 'n/a');
insert into program (name, description) values ('BB&T Corporation', 'n/a');
insert into program (name, description) values ('Ashford Hospitality Trust Inc', 'n/a');
insert into program (name, description) values ('Cellect Biotechnology Ltd.', 'n/a');
insert into program (name, description) values ('Luby''s, Inc.', 'Restaurants');
insert into program (name, description) values ('CVR Refining, LP', 'Integrated oil Companies');
insert into program (name, description) values ('LivaNova PLC', 'Biotechnology: Electromedical & Electrotherapeutic Apparatus');
insert into program (name, description) values ('Retail Properties of America, Inc.', 'n/a');
insert into program (name, description) values ('Retail Opportunity Investments Corp.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Activision Blizzard, Inc', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Eaton Vance Risk-Managed Diversified Equity Income Fund', 'n/a');
insert into program (name, description) values ('Grupo Financiero Santander Mexico S.A. B. de C.V.', 'Commercial Banks');
insert into program (name, description) values ('Wells Fargo & Company', 'n/a');
insert into program (name, description) values ('Select Comfort Corporation', 'Home Furnishings');
insert into program (name, description) values ('BB&T Corporation', 'Major Banks');
insert into program (name, description) values ('Ashford Hospitality Trust Inc', 'n/a');
insert into program (name, description) values ('Teekay Corporation', 'Marine Transportation');
insert into program (name, description) values ('Brainstorm Cell Therapeutics Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Pennsylvania Real Estate Investment Trust', 'Real Estate Investment Trusts');
insert into program (name, description) values ('SVB Financial Group', 'Major Banks');
insert into program (name, description) values ('F.N.B. Corporation', 'Major Banks');
insert into program (name, description) values ('Gazit-Globe Ltd.', 'Real Estate');
insert into program (name, description) values ('Nuveen Select Tax Free Income Portfolio', 'n/a');
insert into program (name, description) values ('Zosano Pharma Corporation', 'Major Pharmaceuticals');
insert into program (name, description) values ('Female Health Company (The)', 'Specialty Chemicals');
insert into program (name, description) values ('Splunk Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('HSBC Holdings plc', 'Savings Institutions');
insert into program (name, description) values ('Transdigm Group Incorporated', 'Military/Government/Technical');
insert into program (name, description) values ('Raytheon Company', 'Industrial Machinery/Components');
insert into program (name, description) values ('Savara, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('ImmuCell Corporation', 'Biotechnology: In Vitro & In Vivo Diagnostic Substances');
insert into program (name, description) values ('JM Global Holding Company', 'Business Services');
insert into program (name, description) values ('Eastman Kodak Company', 'n/a');
insert into program (name, description) values ('Dynex Capital, Inc.', 'n/a');
insert into program (name, description) values ('Haverty Furniture Companies, Inc.', 'Other Specialty Stores');
insert into program (name, description) values ('AmTrust Financial Services, Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Phoenix New Media Limited', 'Broadcasting');
insert into program (name, description) values ('Southwestern Energy Company', 'Oil & Gas Production');
insert into program (name, description) values ('Blackrock Health Sciences Trust', 'n/a');
insert into program (name, description) values ('Nuveen Dow 30SM Dynamic Overwrite Fund', 'n/a');
insert into program (name, description) values ('MCBC Holdings, Inc.', 'Marine Transportation');
insert into program (name, description) values ('Vista Outdoor Inc.', 'Ordnance And Accessories');
insert into program (name, description) values ('Kayne Anderson Midstream Energy Fund, Inc', 'n/a');
insert into program (name, description) values ('Lazard World Dividend & Income Fund, Inc.', 'n/a');
insert into program (name, description) values ('Raymond James Financial, Inc.', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('BancFirst Corporation', 'Major Banks');
insert into program (name, description) values ('Meridian Bancorp, Inc.', 'Major Banks');
insert into program (name, description) values ('Xerox Corporation', 'Business Services');
insert into program (name, description) values ('Jazz Pharmaceuticals plc', 'Major Pharmaceuticals');
insert into program (name, description) values ('DDR Corp.', 'n/a');
insert into program (name, description) values ('Acadia Healthcare Company, Inc.', 'Medical Specialities');
insert into program (name, description) values ('Niagara Mohawk Holdings, Inc.', 'Power Generation');
insert into program (name, description) values ('PowerShares DWA Utilities Momentum Portfolio', 'n/a');
insert into program (name, description) values ('Natuzzi, S.p.A.', 'Home Furnishings');
insert into program (name, description) values ('Rogers Communication, Inc.', 'Television Services');
insert into program (name, description) values ('8point3 Energy Partners LP', 'Electric Utilities: Central');
insert into program (name, description) values ('NanoString Technologies, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('J P Morgan Chase & Co', 'Major Banks');
insert into program (name, description) values ('Embotelladora Andina S.A.', 'n/a');
insert into program (name, description) values ('Auburn National Bancorporation, Inc.', 'Major Banks');
insert into program (name, description) values ('BB&T Corporation', 'n/a');
insert into program (name, description) values ('Hexcel Corporation', 'Major Chemicals');
insert into program (name, description) values ('Eco-Stim Energy Solutions, Inc.', 'Oilfield Services/Equipment');
insert into program (name, description) values ('Apollo Investment Corporation', 'n/a');
insert into program (name, description) values ('Public Storage', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Selecta Biosciences, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Snap-On Incorporated', 'Industrial Machinery/Components');
insert into program (name, description) values ('Murphy Oil Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('Civista Bancshares, Inc. ', 'Major Banks');
insert into program (name, description) values ('Dell Technologies Inc.', 'Computer Manufacturing');
insert into program (name, description) values ('Royal Bank Scotland plc (The)', 'Commercial Banks');
insert into program (name, description) values ('Gamco Investors, Inc.', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('First Trust Switzerland AlphaDEX Fund', 'n/a');
insert into program (name, description) values ('Southern California Edison Company', 'n/a');
insert into program (name, description) values ('AmTrust Financial Services, Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('CGG', 'Oil & Gas Production');
insert into program (name, description) values ('Prudential Financial, Inc.', 'Life Insurance');
insert into program (name, description) values ('Blackrock Corporate High Yield Fund, Inc.', 'n/a');
insert into program (name, description) values ('Knoll, Inc.', 'Office Equipment/Supplies/Services');
insert into program (name, description) values ('Crown Castle International Corporation', 'Real Estate Investment Trusts');
insert into program (name, description) values ('First Trust China AlphaDEX Fund', 'n/a');
insert into program (name, description) values ('HSBC Holdings plc', 'n/a');
insert into program (name, description) values ('Putnam High Income Bond Fund', 'n/a');
insert into program (name, description) values ('Covanta Holding Corporation', 'Electric Utilities: Central');
insert into program (name, description) values ('ChinaCache International Holdings Ltd.', 'EDP Services');
insert into program (name, description) values ('Ashford Hospitality Trust Inc', 'n/a');
insert into program (name, description) values ('Wipro Limited', 'EDP Services');
insert into program (name, description) values ('Mallinckrodt plc', 'Major Pharmaceuticals');
insert into program (name, description) values ('Cubic Corporation', 'Industrial Machinery/Components');
insert into program (name, description) values ('Build-A-Bear Workshop, Inc.', 'Recreational Products/Toys');
insert into program (name, description) values ('Kohl''s Corporation', 'Department/Specialty Retail Stores');
insert into program (name, description) values ('Hutchison China MediTech Limited', 'Major Pharmaceuticals');
insert into program (name, description) values ('National General Holdings Corp', 'Property-Casualty Insurers');
insert into program (name, description) values ('Xplore Technologies Corp', 'Computer Manufacturing');
insert into program (name, description) values ('The9 Limited', 'Business Services');
insert into program (name, description) values ('QIWI plc', 'Business Services');
insert into program (name, description) values ('IHS Markit Ltd.', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('Intel Corporation', 'Semiconductors');
insert into program (name, description) values ('Banner Corporation', 'Major Banks');
insert into program (name, description) values ('American International Group, Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Escalade, Incorporated', 'Recreational Products/Toys');
insert into program (name, description) values ('Nexstar Media Group, Inc.', 'Broadcasting');
insert into program (name, description) values ('Boston Properties, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Ameris Bancorp', 'Major Banks');
insert into program (name, description) values ('CABCO Series 2004-101 Trust', 'Finance: Consumer Services');
insert into program (name, description) values ('BlackRock Municipal Income Investment Trust', 'n/a');
insert into program (name, description) values ('Colony NorthStar, Inc.', 'n/a');
insert into program (name, description) values ('iShares MSCI USA ESG Optimized ETF', 'n/a');
insert into program (name, description) values ('Rice Midstream Partners LP', 'Natural Gas Distribution');
insert into program (name, description) values ('Applied Genetic Technologies Corporation', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Hennessy Advisors, Inc.', 'Investment Managers');
insert into program (name, description) values ('Calpine Corporation', 'Electric Utilities: Central');
insert into program (name, description) values ('Conyers Park Acquisition Corp.', 'Business Services');
insert into program (name, description) values ('TIM Participacoes S.A.', 'Telecommunications Equipment');
insert into program (name, description) values ('R.R. Donnelley & Sons Company', 'Publishing');
insert into program (name, description) values ('Tri Continental Corporation', 'n/a');
insert into program (name, description) values ('National Steel Company', 'Steel/Iron Ore');
insert into program (name, description) values ('Manulife Financial Corp', 'Life Insurance');
insert into program (name, description) values ('Prudential Financial, Inc.', 'Life Insurance');
insert into program (name, description) values ('Colonial High Income Municipal Trust', 'n/a');
insert into program (name, description) values ('WisdomTree United Kingdom Hedged Equity Fund', 'n/a');
insert into program (name, description) values ('Zoe''s Kitchen, Inc.', 'Restaurants');
insert into program (name, description) values ('Adtalem Global Education Inc.', 'Other Consumer Services');
insert into program (name, description) values ('Genworth Financial Inc', 'Life Insurance');
insert into program (name, description) values ('CRH PLC', 'Building Materials');
insert into program (name, description) values ('Spark Energy, Inc.', 'Power Generation');
insert into program (name, description) values ('Philip Morris International Inc', 'Farming/Seeds/Milling');
insert into program (name, description) values ('CryoPort, Inc.', 'Oil Refining/Marketing');
insert into program (name, description) values ('Cellular Biomedicine Group, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Lightbridge Corporation', 'Professional Services');
insert into program (name, description) values ('Stone Energy Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('Novanta Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Navios Maritime Acquisition Corporation', 'Marine Transportation');
insert into program (name, description) values ('PowerShares S&P SmallCap Information Technology Portfolio', 'n/a');
insert into program (name, description) values ('Citrix Systems, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Boston Private Financial Holdings, Inc.', 'Major Banks');
insert into program (name, description) values ('Westlake Chemical Corporation', 'Major Chemicals');
insert into program (name, description) values ('Alamos Gold Inc.', 'Precious Metals');
insert into program (name, description) values ('Stantec Inc', 'Military/Government/Technical');
insert into program (name, description) values ('Xerox Corporation', 'Business Services');
insert into program (name, description) values ('Exact Sciences Corporation', 'Biotechnology: Commercial Physical & Biological Resarch');
insert into program (name, description) values ('State Street Corporation', 'n/a');
insert into program (name, description) values ('Vishay Precision Group, Inc.', 'Electrical Products');
insert into program (name, description) values ('Pegasystems Inc.', 'EDP Services');
insert into program (name, description) values ('SMTC Corporation', 'Electrical Products');
insert into program (name, description) values ('Zebra Technologies Corporation', 'Industrial Machinery/Components');
insert into program (name, description) values ('Aetna Inc.', 'Medical Specialities');
insert into program (name, description) values ('Teekay Offshore Partners L.P.', 'n/a');
insert into program (name, description) values ('Loral Space and Communications, Inc.', 'Radio And Television Broadcasting And Communications Equipment');
insert into program (name, description) values ('TPG Pace Energy Holdings Corp.', 'n/a');
insert into program (name, description) values ('Calpine Corporation', 'Electric Utilities: Central');
insert into program (name, description) values ('WhiteHorse Finance, Inc.', 'n/a');
insert into program (name, description) values ('Intercontinental Hotels Group', 'Hotels/Resorts');
insert into program (name, description) values ('Lexington Realty Trust', 'n/a');
insert into program (name, description) values ('Speedway Motorsports, Inc.', 'Services-Misc. Amusement & Recreation');
insert into program (name, description) values ('National Grid Transco, PLC', 'Natural Gas Distribution');
insert into program (name, description) values ('Pretium Resources, Inc.', 'Precious Metals');
insert into program (name, description) values ('Nabors Industries Ltd.', 'Oil & Gas Production');
insert into program (name, description) values ('Nabriva Therapeutics AG', 'Major Pharmaceuticals');
insert into program (name, description) values ('Accelerate Diagnostics, Inc.', 'Biotechnology: Laboratory Analytical Instruments');
insert into program (name, description) values ('Invitation Homes Inc.', 'Real Estate');
insert into program (name, description) values ('Live Ventures Incorporated', 'EDP Services');
insert into program (name, description) values ('PowerShares S&P SmallCap Utilities Portfolio', 'n/a');
insert into program (name, description) values ('support.com, Inc.', 'EDP Services');
insert into program (name, description) values ('Cadence Design Systems, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Columbia Property Trust, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('BioLineRx Ltd.', 'Major Pharmaceuticals');
insert into program (name, description) values ('PNC Financial Services Group, Inc. (The)', 'Major Banks');
insert into program (name, description) values ('MaxPoint Interactive, Inc.', 'Advertising');
insert into program (name, description) values ('Gabelli Utility Trust (The)', 'n/a');
insert into program (name, description) values ('Orthofix International N.V.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Enterprise Bancorp Inc', 'Major Banks');
insert into program (name, description) values ('Oxford Lane Capital Corp.', 'n/a');
insert into program (name, description) values ('Gladstone Investment Corporation', 'n/a');
insert into program (name, description) values ('Ardmore Shipping Corporation', 'Marine Transportation');
insert into program (name, description) values ('Yirendai Ltd.', 'Finance: Consumer Services');
insert into program (name, description) values ('Boise Cascade, L.L.C.', 'RETAIL: Building Materials');
insert into program (name, description) values ('PRGX Global, Inc.', 'Diversified Commercial Services');
insert into program (name, description) values ('Equus Total Return, Inc.', 'n/a');
insert into program (name, description) values ('Main Street Capital Corporation', 'n/a');
insert into program (name, description) values ('My Size, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('John B. Sanfilippo & Son, Inc.', 'Specialty Foods');
insert into program (name, description) values ('Wesco Aircraft Holdings, Inc.', 'Wholesale Distributors');
insert into program (name, description) values ('North American Energy Partners, Inc.', 'Oilfield Services/Equipment');
insert into program (name, description) values ('Dolby Laboratories', 'Multi-Sector Companies');
insert into program (name, description) values ('Dividend and Income Fund', 'n/a');
insert into program (name, description) values ('Parke Bancorp, Inc.', 'Major Banks');
insert into program (name, description) values ('Tidewater Inc.', 'Marine Transportation');
insert into program (name, description) values ('RAIT Financial Trust', 'Real Estate Investment Trusts');
insert into program (name, description) values ('CBS Corporation', 'Broadcasting');
insert into program (name, description) values ('Myovant Sciences Ltd.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Capitol Acquisition Corp. III', 'Business Services');
insert into program (name, description) values ('KKR & Co. L.P.', 'n/a');
insert into program (name, description) values ('Hilltop Holdings Inc.', 'Major Banks');
insert into program (name, description) values ('Invesco High Income Trust II', 'n/a');
insert into program (name, description) values ('Euronav NV', 'Marine Transportation');
insert into program (name, description) values ('Conyers Park Acquisition Corp.', 'Business Services');
insert into program (name, description) values ('Gabelli Utility Trust (The)', 'n/a');
insert into program (name, description) values ('Plains Group Holdings, L.P.', 'Natural Gas Distribution');
insert into program (name, description) values ('Alpine Global Dynamic Dividend Fund', 'n/a');
insert into program (name, description) values ('icad inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Nortel Inversora SA', 'Telecommunications Equipment');
insert into program (name, description) values ('Regis Corporation', 'Other Consumer Services');
insert into program (name, description) values ('Nordic American Tankers Limited', 'Marine Transportation');
insert into program (name, description) values ('Green Plains, Inc.', 'Major Chemicals');
insert into program (name, description) values ('Wabco Holdings Inc.', 'Auto Manufacturing');
insert into program (name, description) values ('PowerShares 1-30 Laddered Treasury Portfolio', 'n/a');
insert into program (name, description) values ('Covenant Transportation Group, Inc.', 'Trucking Freight/Courier Services');
insert into program (name, description) values ('Vident Core U.S. Bond Strategy Fund', 'n/a');
insert into program (name, description) values ('China Distance Education Holdings Limited', 'Other Consumer Services');
insert into program (name, description) values ('ONE Gas, Inc.', 'Oil/Gas Transmission');
insert into program (name, description) values ('Mesa Laboratories, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Electrum Special Acquisition Corporation', 'Business Services');
insert into program (name, description) values ('Navios Maritime Holdings Inc.', 'Marine Transportation');
insert into program (name, description) values ('MainSource Financial Group, Inc.', 'Major Banks');
insert into program (name, description) values ('Hamilton Lane Incorporated', 'Investment Managers');
insert into program (name, description) values ('Azure Power Global Limited', 'Electric Utilities: Central');
insert into program (name, description) values ('ESSA Bancorp, Inc.', 'Banks');
insert into program (name, description) values ('Cemex S.A.B. de C.V.', 'Building Materials');
insert into program (name, description) values ('Ameris Bancorp', 'Major Banks');
insert into program (name, description) values ('ILG, Inc', 'Real Estate');
insert into program (name, description) values ('Ferrellgas Partners, L.P.', 'Other Specialty Stores');
insert into program (name, description) values ('Weingarten Realty Investors', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Molson Coors Brewing  Company', 'n/a');
insert into program (name, description) values ('PowerShares Golden Dragon China Portfolio', 'n/a');
insert into program (name, description) values ('CrossAmerica Partners LP', 'Oil Refining/Marketing');
insert into program (name, description) values ('Deutsch Bk Contingent Cap Tr V', 'Major Banks');
insert into program (name, description) values ('Repros Therapeutics Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Benitec Biopharma Limited', 'Major Pharmaceuticals');
insert into program (name, description) values ('Intercontinental Hotels Group', 'Hotels/Resorts');
insert into program (name, description) values ('Whiting Petroleum Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('Unisys Corporation', 'EDP Services');
insert into program (name, description) values ('Nuveen Michigan Quality Municipal Income Fund', 'n/a');
insert into program (name, description) values ('Five Oaks Investment Corp.', 'n/a');
insert into program (name, description) values ('Kaiser Aluminum Corporation', 'Metal Fabrications');
insert into program (name, description) values ('Enbridge Inc', 'Natural Gas Distribution');
insert into program (name, description) values ('Motorola Solutions, Inc.', 'Radio And Television Broadcasting And Communications Equipment');
insert into program (name, description) values ('Travelzoo', 'EDP Services');
insert into program (name, description) values ('First Trust', 'n/a');
insert into program (name, description) values ('United Fire Group, Inc', 'Property-Casualty Insurers');
insert into program (name, description) values ('First Trust', 'n/a');
insert into program (name, description) values ('Matador Resources Company', 'Oil & Gas Production');
insert into program (name, description) values ('Maxim Integrated Products, Inc.', 'Semiconductors');
insert into program (name, description) values ('Chemical Financial Corporation', 'Major Banks');
insert into program (name, description) values ('Lsb Industries Inc.', 'Major Chemicals');
insert into program (name, description) values ('Diana Shipping inc.', 'n/a');
insert into program (name, description) values ('iShares Morningstar Mid-Cap ETF', 'n/a');
insert into program (name, description) values ('GigaMedia Limited', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('Cohen & Steers Inc', 'Investment Managers');
insert into program (name, description) values ('21Vianet Group, Inc.', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('Clearwater Paper Corporation', 'Paper');
insert into program (name, description) values ('NVE Corporation', 'Semiconductors');
insert into program (name, description) values ('Vanguard Intermediate -Term Government Bond ETF', 'n/a');
insert into program (name, description) values ('Resolute Forest Products Inc.', 'Paper');
insert into program (name, description) values ('Autohome Inc.', 'EDP Services');
insert into program (name, description) values ('Global Indemnity Limited', 'Property-Casualty Insurers');
insert into program (name, description) values ('Equity Lifestyle Properties, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Iron Mountain Incorporated', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Forestar Group Inc', 'Real Estate');
insert into program (name, description) values ('Vornado Realty Trust', 'n/a');
insert into program (name, description) values ('Allstate Corporation (The)', 'n/a');
insert into program (name, description) values ('Flaherty & Crumrine Preferred Income Opportunity Fund Inc', 'n/a');
insert into program (name, description) values ('Banco Latinoamericano de Comercio Exterior, S.A.', 'Commercial Banks');
insert into program (name, description) values ('Twenty-First Century Fox, Inc.', 'Television Services');
insert into program (name, description) values ('Southern Missouri Bancorp, Inc.', 'Banks');
insert into program (name, description) values ('Global X Longevity Thematic ETF', 'n/a');
insert into program (name, description) values ('Rex Energy Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('Anthera Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('DCT Industrial Trust Inc', 'Real Estate Investment Trusts');
insert into program (name, description) values ('PowerShares High Yield Equity Dividend Achievers Portfolio', 'n/a');
insert into program (name, description) values ('Yamana Gold Inc.', 'Precious Metals');
insert into program (name, description) values ('Marathon Oil Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('SunTrust Banks, Inc.', 'n/a');
insert into program (name, description) values ('Apollo Investment Corporation', 'n/a');
insert into program (name, description) values ('American Midstream Partners, LP', 'Natural Gas Distribution');
insert into program (name, description) values ('Ralph Lauren Corporation', 'Apparel');
insert into program (name, description) values ('Alcoa Corporation', 'Metal Fabrications');
insert into program (name, description) values ('Wells Fargo & Company', 'n/a');
insert into program (name, description) values ('First Financial Bancorp.', 'Major Banks');
insert into program (name, description) values ('Cincinnati Bell Inc', 'n/a');
insert into program (name, description) values ('Pacific Drilling S.A.', 'Oil & Gas Production');
insert into program (name, description) values ('Actua Corporation', 'EDP Services');
insert into program (name, description) values ('WNS (Holdings) Limited', 'Business Services');
insert into program (name, description) values ('Martin Midstream Partners L.P.', 'Oil Refining/Marketing');
insert into program (name, description) values ('Roka Bioscience, Inc.', 'Biotechnology: Laboratory Analytical Instruments');
insert into program (name, description) values ('First Trust International IPO ETF', 'n/a');
insert into program (name, description) values ('American Railcar Industries, Inc.', 'Railroads');
insert into program (name, description) values ('ePlus inc.', 'Retail: Computer Software & Peripheral Equipment');
insert into program (name, description) values ('First Trust Managed Municipal ETF', 'n/a');
insert into program (name, description) values ('Ply Gem Holdings, Inc.', 'Forest Products');
insert into program (name, description) values ('Manhattan Associates, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Wendy''s Company (The)', 'Restaurants');
insert into program (name, description) values ('Wynn Resorts, Limited', 'Hotels/Resorts');
insert into program (name, description) values ('NextEra Energy, Inc.', 'n/a');
insert into program (name, description) values ('MFS Government Markets Income Trust', 'n/a');
insert into program (name, description) values ('Aspen Insurance Holdings Limited', 'n/a');
insert into program (name, description) values ('Ball Corporation', 'Containers/Packaging');
insert into program (name, description) values ('Adamis Pharmaceuticals Corporation', 'Major Pharmaceuticals');
insert into program (name, description) values ('American Railcar Industries, Inc.', 'Railroads');
insert into program (name, description) values ('Nexstar Media Group, Inc.', 'Broadcasting');
insert into program (name, description) values ('TICC Capital Corp.', 'n/a');
insert into program (name, description) values ('Ferrellgas Partners, L.P.', 'Other Specialty Stores');
insert into program (name, description) values ('Oclaro, Inc.', 'Semiconductors');
insert into program (name, description) values ('B. Riley Financial, Inc.', 'Business Services');
insert into program (name, description) values ('Salesforce.com Inc', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Sonus Networks, Inc.', 'EDP Services');
insert into program (name, description) values ('Eaton Vance Corporation', 'n/a');
insert into program (name, description) values ('Crocs, Inc.', 'Shoe Manufacturing');
insert into program (name, description) values ('Western Union Company (The)', 'Business Services');
insert into program (name, description) values ('TeleTech Holdings, Inc.', 'Professional Services');
insert into program (name, description) values ('Jacksonville Bancorp Inc.', 'Savings Institutions');
insert into program (name, description) values ('Align Technology, Inc.', 'Industrial Specialties');
insert into program (name, description) values ('Mylan N.V.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Zoetis Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Just Energy Group, Inc.', 'n/a');
insert into program (name, description) values ('Luxottica Group, S.p.A.', 'Ophthalmic Goods');
insert into program (name, description) values ('Liberty Media Corporation', 'Broadcasting');
insert into program (name, description) values ('Nortel Inversora SA', 'Telecommunications Equipment');
insert into program (name, description) values ('Chimera Investment Corporation', 'Real Estate Investment Trusts');
insert into program (name, description) values ('PowerShares DWA Financial Momentum Portfolio', 'n/a');
insert into program (name, description) values ('First Trust NASDAQ Cybersecurity ETF', 'n/a');
insert into program (name, description) values ('Blackrock MuniHoldings New York Quality Fund, Inc.', 'n/a');
insert into program (name, description) values ('First Trust', 'n/a');
insert into program (name, description) values ('Zions Bancorporation', 'Major Banks');
insert into program (name, description) values ('El Paso Electric Company', 'Electric Utilities: Central');
insert into program (name, description) values ('DWS High Income Opportunities Fund, Inc.', 'n/a');
insert into program (name, description) values ('ChannelAdvisor Corporation', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Myovant Sciences Ltd.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Spectrum Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Landauer, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Sonic Automotive, Inc.', 'Automotive Aftermarket');
insert into program (name, description) values ('Infosys Limited', 'EDP Services');
insert into program (name, description) values ('Allstate Corporation (The)', 'Property-Casualty Insurers');
insert into program (name, description) values ('Marathon Oil Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('Blackrock Core Bond Trust', 'n/a');
insert into program (name, description) values ('Dextera Surgical Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Medtronic plc', 'Biotechnology: Electromedical & Electrotherapeutic Apparatus');
insert into program (name, description) values ('Interlink Electronics, Inc.', 'Computer peripheral equipment');
insert into program (name, description) values ('JAKKS Pacific, Inc.', 'Recreational Products/Toys');
insert into program (name, description) values ('Empresa Distribuidora Y Comercializadora Norte S.A. (Edenor)', 'Electric Utilities: Central');
insert into program (name, description) values ('Boston Properties, Inc.', 'n/a');
insert into program (name, description) values ('Marinus Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Donegal Group, Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Alphabet Inc.', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('Acasti Pharma, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('First Trust SSI Strategic Convertible Securities ETF', 'n/a');
insert into program (name, description) values ('Oasmia Pharmaceutical AB', 'Major Pharmaceuticals');
insert into program (name, description) values ('Caesarstone Ltd.', 'Building Materials');
insert into program (name, description) values ('Carriage Services, Inc.', 'Other Consumer Services');
insert into program (name, description) values ('Quality Systems, Inc.', 'EDP Services');
insert into program (name, description) values ('Coca-Cola Bottling Co. Consolidated', 'Beverages (Production/Distribution)');
insert into program (name, description) values ('Interface, Inc.', 'Home Furnishings');
insert into program (name, description) values ('Trinity Biotech plc', 'Biotechnology: In Vitro & In Vivo Diagnostic Substances');
insert into program (name, description) values ('CMS Energy Corporation', 'Power Generation');
insert into program (name, description) values ('Dean Foods Company', 'Packaged Foods');
insert into program (name, description) values ('RH', 'Other Specialty Stores');
insert into program (name, description) values ('Alphabet Inc.', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('Cintas Corporation', 'Apparel');
insert into program (name, description) values ('IZEA Inc.', 'Advertising');
insert into program (name, description) values ('Fang Holdings Limited', 'EDP Services');
insert into program (name, description) values ('Maxwell Technologies, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('The Obesity ETF', 'n/a');
insert into program (name, description) values ('UMB Financial Corporation', 'Major Banks');
insert into program (name, description) values ('uniQure N.V.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Veeco Instruments Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('New Home Company Inc. (The)', 'Homebuilding');
insert into program (name, description) values ('Okta, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Amkor Technology, Inc.', 'Semiconductors');
insert into program (name, description) values ('Grand Canyon Education, Inc.', 'Other Consumer Services');
insert into program (name, description) values ('Rubicon Technology, Inc.', 'Semiconductors');
insert into program (name, description) values ('FlexShares Real Assets Allocation Index Fund', 'n/a');
insert into program (name, description) values ('GTY Technology Holdings, Inc.', 'n/a');
insert into program (name, description) values ('Nuveen California Municipal Value Fund, Inc.', 'n/a');
insert into program (name, description) values ('General Electric Capital Corporation', 'Consumer Electronics/Appliances');
insert into program (name, description) values ('Entravision Communications Corporation', 'Broadcasting');
insert into program (name, description) values ('Arrow DWA Tactical ETF', 'n/a');
insert into program (name, description) values ('Meridian Waste Solutions, Inc', 'Miscellaneous');
insert into program (name, description) values ('Cabela''s Inc', 'Other Specialty Stores');
insert into program (name, description) values ('CareDx, Inc.', 'Medical Specialities');
insert into program (name, description) values ('KCAP Financial, Inc.', 'n/a');
insert into program (name, description) values ('Covanta Holding Corporation', 'Electric Utilities: Central');
insert into program (name, description) values ('Lee Enterprises, Incorporated', 'Newspapers/Magazines');
insert into program (name, description) values ('Axar Acquisition Corp.', 'Business Services');
insert into program (name, description) values ('Cogint, Inc.', 'Advertising');
insert into program (name, description) values ('Aegon NV', 'Life Insurance');
insert into program (name, description) values ('Maxwell Technologies, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Reinsurance Group of America, Incorporated', 'Life Insurance');
insert into program (name, description) values ('WEC Energy Group, Inc.', 'Power Generation');
insert into program (name, description) values ('Pier 1 Imports, Inc.', 'Home Furnishings');
insert into program (name, description) values ('Nuveen Municipal High Income Opportunity Fund', 'n/a');
insert into program (name, description) values ('Hub Group, Inc.', 'Oil Refining/Marketing');
insert into program (name, description) values ('Fidelity National Financial, Inc.', 'Specialty Insurers');
insert into program (name, description) values ('Twilio Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Kimbell Royalty Partners', 'Oil & Gas Production');
insert into program (name, description) values ('First Trust Managed Municipal ETF', 'n/a');
insert into program (name, description) values ('ICON plc', 'Biotechnology: Commercial Physical & Biological Resarch');
insert into program (name, description) values ('Prudential Short Duration High Yield Fund, Inc.', 'n/a');
insert into program (name, description) values ('TechnipFMC plc', 'Metal Fabrications');
insert into program (name, description) values ('Cullen/Frost Bankers, Inc.', 'n/a');
insert into program (name, description) values ('Cohen & Steers Total Return Realty Fund, Inc.', 'n/a');
insert into program (name, description) values ('J.M. Smucker Company (The)', 'Packaged Foods');
insert into program (name, description) values ('Sun Life Financial Inc.', 'Life Insurance');
insert into program (name, description) values ('Constellation Brands Inc', 'n/a');
insert into program (name, description) values ('Omega Healthcare Investors, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Marsh & McLennan Companies, Inc.', 'Specialty Insurers');
insert into program (name, description) values ('PowerShares Global Gold & Precious Metals Portfolio', 'n/a');
insert into program (name, description) values ('Third Point Reinsurance Ltd.', 'Property-Casualty Insurers');
insert into program (name, description) values ('First Trust Mid Cap Value AlphaDEX Fund', 'n/a');
insert into program (name, description) values ('Kinsale Capital Group, Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Easterly Acquisition Corp.', 'Building Products');
insert into program (name, description) values ('Web.com Group, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Stellar Acquisition III Inc.', 'Business Services');
insert into program (name, description) values ('Hancock Holding Company', 'Major Banks');
insert into program (name, description) values ('Brady Corporation', 'Miscellaneous manufacturing industries');
insert into program (name, description) values ('Silver Run Acquisition Corporation II', 'Business Services');
insert into program (name, description) values ('OCI Partners LP', 'Major Chemicals');
insert into program (name, description) values ('Oclaro, Inc.', 'Semiconductors');
insert into program (name, description) values ('Prima BioMed Ltd', 'Major Pharmaceuticals');
insert into program (name, description) values ('Sunstone Hotel Investors, Inc.', 'n/a');
insert into program (name, description) values ('U.S. Auto Parts Network, Inc.', 'Other Specialty Stores');
insert into program (name, description) values ('CNH Industrial N.V.', 'Construction/Ag Equipment/Trucks');
insert into program (name, description) values ('CVR Energy Inc.', 'Integrated oil Companies');
insert into program (name, description) values ('LogMein, Inc.', 'n/a');
insert into program (name, description) values ('Cohu, Inc.', 'Electrical Products');
insert into program (name, description) values ('Apple Inc.', 'Computer Manufacturing');
insert into program (name, description) values ('VanEck Vectors Biotech ETF', 'n/a');
insert into program (name, description) values ('Raven Industries, Inc.', 'Specialty Chemicals');
insert into program (name, description) values ('Gulf Island Fabrication, Inc.', 'Metal Fabrications');
insert into program (name, description) values ('CNA Financial Corporation', 'Property-Casualty Insurers');
insert into program (name, description) values ('Verizon Communications Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('QuinStreet, Inc.', 'Business Services');
insert into program (name, description) values ('John Bean Technologies Corporation', 'Industrial Machinery/Components');
insert into program (name, description) values ('First Trust Japan AlphaDEX Fund', 'n/a');
insert into program (name, description) values ('Georgia Power Company', 'Electric Utilities: Central');
insert into program (name, description) values ('O''Reilly Automotive, Inc.', 'Other Specialty Stores');
insert into program (name, description) values ('Iron Mountain Incorporated', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Warrior Met Coal, Inc.', 'Coal Mining');
insert into program (name, description) values ('St. Joe Company (The)', 'Homebuilding');
insert into program (name, description) values ('Liberty Interactive Corporation', 'Catalog/Specialty Distribution');
insert into program (name, description) values ('ImmuCell Corporation', 'Biotechnology: In Vitro & In Vivo Diagnostic Substances');
insert into program (name, description) values ('American Homes 4 Rent', 'n/a');
insert into program (name, description) values ('Ellington Financial LLC', 'Real Estate');
insert into program (name, description) values ('Camtek Ltd.', 'Electronic Components');
insert into program (name, description) values ('Equifax, Inc.', 'Finance: Consumer Services');
insert into program (name, description) values ('Fidelity National Financial, Inc.', 'Specialty Insurers');
insert into program (name, description) values ('Catalyst Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Nabors Industries Ltd.', 'Oil & Gas Production');
insert into program (name, description) values ('YRC Worldwide, Inc.', 'Trucking Freight/Courier Services');
insert into program (name, description) values ('Goldman Sachs Group, Inc. (The)', 'n/a');
insert into program (name, description) values ('Bank of Hawaii Corporation', 'Major Banks');
insert into program (name, description) values ('American Superconductor Corporation', 'Metal Fabrications');
insert into program (name, description) values ('Hilltop Holdings Inc.', 'Major Banks');
insert into program (name, description) values ('Cytokinetics, Incorporated', 'Major Pharmaceuticals');
insert into program (name, description) values ('Grupo Financiero Santander Mexico S.A. B. de C.V.', 'Commercial Banks');
insert into program (name, description) values ('Upland Software, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('United Community Bancorp', 'Savings Institutions');
insert into program (name, description) values ('CDW Corporation', 'Catalog/Specialty Distribution');
insert into program (name, description) values ('Blackrock MuniYield California Fund, Inc.', 'n/a');
insert into program (name, description) values ('Kayne Anderson Acquisition Corp.', 'Business Services');
insert into program (name, description) values ('The Trade Desk, Inc.', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('AT&T Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('Avinger, Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Dynatronics Corporation', 'Biotechnology: Electromedical & Electrotherapeutic Apparatus');
insert into program (name, description) values ('Harsco Corporation', 'Metal Fabrications');
insert into program (name, description) values ('First Interstate BancSystem, Inc.', 'Major Banks');
insert into program (name, description) values ('KAR Auction Services, Inc', 'Automotive Aftermarket');
insert into program (name, description) values ('PIMCO Income Strategy Fund', 'n/a');
insert into program (name, description) values ('Putnam Managed Municipal Income Trust', 'n/a');
insert into program (name, description) values ('Yamana Gold Inc.', 'Precious Metals');
insert into program (name, description) values ('Sify Technologies Limited', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('Summit State Bank', 'n/a');
insert into program (name, description) values ('Heritage Financial Corporation', 'Banks');
insert into program (name, description) values ('WisdomTree Emerging Markets Consumer Growth Fund', 'n/a');
insert into program (name, description) values ('Synopsys, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('GigaMedia Limited', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('PowerShares Variable Rate Investment Grade Portfolio', 'n/a');
insert into program (name, description) values ('PowerShares High Yield Equity Dividend Achievers Portfolio', 'n/a');
insert into program (name, description) values ('Biogen Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Genesco Inc.', 'Clothing/Shoe/Accessory Stores');
insert into program (name, description) values ('Nivalis Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Liberty Expedia Holdings, Inc.', 'Other Consumer Services');
insert into program (name, description) values ('Fairmount Santrol Holdings Inc.', 'Mining & Quarrying of Nonmetallic Minerals (No Fuels)');
insert into program (name, description) values ('Manitowoc Company, Inc. (The)', 'Construction/Ag Equipment/Trucks');
insert into program (name, description) values ('Legacy Reserves LP', 'Oil & Gas Production');
insert into program (name, description) values ('Capitala Finance Corp.', 'n/a');
insert into program (name, description) values ('Toro Company (The)', 'Tools/Hardware');
insert into program (name, description) values ('Eaton Vance Tax-Advantaged Global Dividend Income Fund', 'n/a');
insert into program (name, description) values ('State Street Corporation', 'n/a');
insert into program (name, description) values ('Hawaiian Electric Industries, Inc.', 'Electric Utilities: Central');
insert into program (name, description) values ('Horizon Technology Finance Corporation', 'n/a');
insert into program (name, description) values ('Community West Bancshares', 'Major Banks');
insert into program (name, description) values ('J. Alexander''s Holdings, Inc.', 'Restaurants');
insert into program (name, description) values ('Apache Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('EQT Midstream Partners, LP', 'Natural Gas Distribution');
insert into program (name, description) values ('Nutanix, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Werner Enterprises, Inc.', 'Trucking Freight/Courier Services');
insert into program (name, description) values ('Arch Coal, Inc.', 'Coal Mining');
insert into program (name, description) values ('Syneron Medical Ltd.', 'Biotechnology: Electromedical & Electrotherapeutic Apparatus');
insert into program (name, description) values ('Warrior Met Coal, Inc.', 'Coal Mining');
insert into program (name, description) values ('Union Pacific Corporation', 'Railroads');
insert into program (name, description) values ('New Residential Investment Corp.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('First Trust Nasdaq Transportation ETF', 'n/a');
insert into program (name, description) values ('PowerShares BuyBack Achievers Portfolio', 'n/a');
insert into program (name, description) values ('Ashford Hospitality Prime, Inc.', 'n/a');
insert into program (name, description) values ('Net Element, Inc.', 'EDP Services');
insert into program (name, description) values ('American Water Works', 'Water Supply');
insert into program (name, description) values ('JinkoSolar Holding Company Limited', 'Semiconductors');
insert into program (name, description) values ('Teva Pharmaceutical Industries Limited', 'Major Pharmaceuticals');
insert into program (name, description) values ('Allstate Corporation (The)', 'n/a');
insert into program (name, description) values ('DigitalGlobe, Inc', 'Telecommunications Equipment');
insert into program (name, description) values ('Brinker International, Inc.', 'Restaurants');
insert into program (name, description) values ('North European Oil Royality Trust', 'Oil & Gas Production');
insert into program (name, description) values ('ContraVir Pharmaceuticals Inc', 'Major Pharmaceuticals');
insert into program (name, description) values ('Atossa Genetics Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Global Ship Lease, Inc.', 'Marine Transportation');
insert into program (name, description) values ('Principal Shareholder Yield Index ETF', 'n/a');
insert into program (name, description) values ('Legg Mason, Inc.', 'Investment Managers');
insert into program (name, description) values ('BioDelivery Sciences International, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Canon, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('First Trust Hong Kong AlphaDEX Fund', 'n/a');
insert into program (name, description) values ('Chesapeake Lodging Trust', 'n/a');
insert into program (name, description) values ('Tyson Foods, Inc.', 'Meat/Poultry/Fish');
insert into program (name, description) values ('Validus Holdings, Ltd.', 'Property-Casualty Insurers');
insert into program (name, description) values ('PowerShares International BuyBack Achievers Portfolio', 'n/a');
insert into program (name, description) values ('PennyMac Financial Services, Inc.', 'Finance: Consumer Services');
insert into program (name, description) values ('B. Riley Financial, Inc.', 'Business Services');
insert into program (name, description) values ('X-Links Silver Shares Covered Call ETN', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('MFS Intermediate Income Trust', 'n/a');
insert into program (name, description) values ('Crawford & Company', 'n/a');
insert into program (name, description) values ('Brunswick Corporation', 'Industrial Machinery/Components');
insert into program (name, description) values ('Chemical Financial Corporation', 'Major Banks');
insert into program (name, description) values ('Scudder Municiple Income Trust', 'n/a');
insert into program (name, description) values ('Two River Bancorp', 'Major Banks');
insert into program (name, description) values ('Prudential Financial, Inc.', 'Life Insurance');
insert into program (name, description) values ('NCI Building Systems, Inc.', 'Metal Fabrications');
insert into program (name, description) values ('CB Financial Services, Inc.', 'Major Banks');
insert into program (name, description) values ('McGrath RentCorp', 'Diversified Commercial Services');
insert into program (name, description) values ('Smart', 'Food Chains');
insert into program (name, description) values ('Crown Castle International Corporation', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Juniper Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('EXCO Resources NL', 'Oil & Gas Production');
insert into program (name, description) values ('Electrum Special Acquisition Corporation', 'Business Services');
insert into program (name, description) values ('WisdomTree U.S. SmallCap Quality Dividend Growth Fund', 'n/a');
insert into program (name, description) values ('Domino''s Pizza Inc', 'Food Distributors');
insert into program (name, description) values ('Vanguard International High Dividend Yield ETF', 'n/a');
insert into program (name, description) values ('American Homes 4 Rent', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Nuveen Preferred and Income 2022 Term Fund', 'n/a');
insert into program (name, description) values ('Alnylam Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Hormel Foods Corporation', 'Meat/Poultry/Fish');
insert into program (name, description) values ('Federal Realty Investment Trust', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Chesapeake Lodging Trust', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Dynex Capital, Inc.', 'n/a');
insert into program (name, description) values ('BankFinancial Corporation', 'Savings Institutions');
insert into program (name, description) values ('Sealed Air Corporation', 'Major Chemicals');
insert into program (name, description) values ('Bank of South Carolina Corp.', 'Major Banks');
insert into program (name, description) values ('MOCON, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('icad inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Tortoise Energy Independence Fund, Inc.', 'n/a');
insert into program (name, description) values ('First Savings Financial Group, Inc.', 'Savings Institutions');
insert into program (name, description) values ('Future FinTech Group Inc.', 'Packaged Foods');
insert into program (name, description) values ('Armstrong World Industries Inc', 'Plastic Products');
insert into program (name, description) values ('Eaton Vance Risk-Managed Diversified Equity Income Fund', 'n/a');
insert into program (name, description) values ('Morgan Stanley', 'n/a');
insert into program (name, description) values ('Alliant Energy Corporation', 'Power Generation');
insert into program (name, description) values ('Entegra Financial Corp.', 'Banks');
insert into program (name, description) values ('Q2 Holdings, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Insight Select Income Fund', 'n/a');
insert into program (name, description) values ('Dynegy Inc.', 'n/a');
insert into program (name, description) values ('Las Vegas Sands Corp.', 'Hotels/Resorts');
insert into program (name, description) values ('Templeton Dragon Fund, Inc.', 'n/a');
insert into program (name, description) values ('Quintiles IMS Holdings, Inc.', 'Biotechnology: Commercial Physical & Biological Resarch');
insert into program (name, description) values ('Advanced Semiconductor Engineering, Inc.', 'Semiconductors');
insert into program (name, description) values ('Old National Bancorp', 'Major Banks');
insert into program (name, description) values ('Resources Connection, Inc.', 'Business Services');
insert into program (name, description) values ('TIM Participacoes S.A.', 'Telecommunications Equipment');
insert into program (name, description) values ('Allstate Corporation (The)', 'n/a');
insert into program (name, description) values ('Avista Healthcare Public Acquisition Corp.', 'Business Services');
insert into program (name, description) values ('Globus Medical, Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Aehr Test Systems', 'Electrical Products');
insert into program (name, description) values ('Discover Financial Services', 'n/a');
insert into program (name, description) values ('Acushnet Holdings Corp.', 'Recreational Products/Toys');
insert into program (name, description) values ('First Trust NASDAQ-100 Equal Weighted Index Fund', 'n/a');
insert into program (name, description) values ('AmTrust Financial Services, Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('DigitalGlobe, Inc', 'Telecommunications Equipment');
insert into program (name, description) values ('Flaherty & Crumrine Preferred Income Fund Incorporated', 'n/a');
insert into program (name, description) values ('MoSys, Inc.', 'Semiconductors');
insert into program (name, description) values ('Vericel Corporation', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('DXC Technology Company', 'EDP Services');
insert into program (name, description) values ('OneBeacon Insurance Group, Ltd.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Sunstone Hotel Investors, Inc.', 'n/a');
insert into program (name, description) values ('Maiden Holdings, Ltd.', 'Property-Casualty Insurers');
insert into program (name, description) values ('PowerShares Global Water Portfolio', 'n/a');
insert into program (name, description) values ('Juniper Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Newtek Business Services Corp.', 'n/a');
insert into program (name, description) values ('iShares S&P Global Timber & Forestry Index Fund', 'n/a');
insert into program (name, description) values ('TE Connectivity Ltd.', 'Electronic Components');
insert into program (name, description) values ('American Water Works', 'Water Supply');
insert into program (name, description) values ('Dollar General Corporation', 'Department/Specialty Retail Stores');
insert into program (name, description) values ('Insys Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Asia Pacific Fund, Inc. (The)', 'n/a');
insert into program (name, description) values ('Calgon Carbon Corporation', 'Major Chemicals');
insert into program (name, description) values ('Everi Holdings Inc.', 'Finance: Consumer Services');
insert into program (name, description) values ('L.S. Starrett Company (The)', 'Industrial Machinery/Components');
insert into program (name, description) values ('National Commerce Corporation', 'Major Banks');
insert into program (name, description) values ('Global Medical REIT Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('GenMark Diagnostics, Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('MPLX LP', 'Natural Gas Distribution');
insert into program (name, description) values ('Net Element, Inc.', 'EDP Services');
insert into program (name, description) values ('Oi S.A.', 'n/a');
insert into program (name, description) values ('Morgan Stanley Asia-Pacific Fund, Inc.', 'n/a');
insert into program (name, description) values ('Monotype Imaging Holdings Inc.', 'EDP Services');
insert into program (name, description) values ('Liberty All-Star Growth Fund, Inc.', 'n/a');
insert into program (name, description) values ('Stanley Black & Decker, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Bemis Company, Inc.', 'Containers/Packaging');
insert into program (name, description) values ('FSB Bancorp, Inc.', 'Savings Institutions');
insert into program (name, description) values ('Grupo Aval Acciones y Valores S.A.', 'Commercial Banks');
insert into program (name, description) values ('TravelCenters of America LLC', 'Automotive Aftermarket');
insert into program (name, description) values ('Kadmon Holdings, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Lsb Industries Inc.', 'Major Chemicals');
insert into program (name, description) values ('Teradyne, Inc.', 'Electrical Products');
insert into program (name, description) values ('Evolving Systems, Inc.', 'EDP Services');
insert into program (name, description) values ('Trecora Resources', 'Integrated oil Companies');
insert into program (name, description) values ('MSG Networks Inc.', 'Services-Misc. Amusement & Recreation');
insert into program (name, description) values ('Apollo Commercial Real Estate Finance', 'n/a');
insert into program (name, description) values ('China TechFaith Wireless Communication Technology Limited', 'n/a');
insert into program (name, description) values ('GlassBridge Enterprises, Inc.', 'Electronic Components');
insert into program (name, description) values ('Teleflex Incorporated', 'Medical/Dental Instruments');
insert into program (name, description) values ('Adtalem Global Education Inc.', 'Other Consumer Services');
insert into program (name, description) values ('Echelon Corporation', 'Computer Communications Equipment');
insert into program (name, description) values ('Andina Acquisition Corp. II', 'Business Services');
insert into program (name, description) values ('ICC Holdings, Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Grupo Aval Acciones y Valores S.A.', 'Commercial Banks');
insert into program (name, description) values ('Boston Properties, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Axar Acquisition Corp.', 'Business Services');
insert into program (name, description) values ('NanoString Technologies, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Home Bancorp, Inc.', 'Banks');
insert into program (name, description) values ('Barnes & Noble, Inc.', 'Other Specialty Stores');
insert into program (name, description) values ('Midatech Pharma PLC', 'Major Pharmaceuticals');
insert into program (name, description) values ('Perma-Fix Environmental Services, Inc.', 'Environmental Services');
insert into program (name, description) values ('Kimball International, Inc.', 'Home Furnishings');
insert into program (name, description) values ('Principal Shareholder Yield Index ETF', 'n/a');
insert into program (name, description) values ('Starbucks Corporation', 'Restaurants');
insert into program (name, description) values ('Bank Of Montreal', 'n/a');
insert into program (name, description) values ('Biomerica, Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Nabriva Therapeutics AG', 'Major Pharmaceuticals');
insert into program (name, description) values ('Goldman Sachs MLP Energy Renaissance Fund', 'n/a');
insert into program (name, description) values ('Associated Banc-Corp', 'Major Banks');
insert into program (name, description) values ('Franco-Nevada Corporation', 'Precious Metals');
insert into program (name, description) values ('Motif Bio plc', 'Major Pharmaceuticals');
insert into program (name, description) values ('B.O.S. Better Online Solutions', 'Computer Communications Equipment');
insert into program (name, description) values ('North European Oil Royality Trust', 'Oil & Gas Production');
insert into program (name, description) values ('Post Holdings, Inc.', 'Packaged Foods');
insert into program (name, description) values ('iShares MSCI Global Impact ETF', 'n/a');
insert into program (name, description) values ('Diana Shipping inc.', 'n/a');
insert into program (name, description) values ('SL Green Realty Corporation', 'n/a');
insert into program (name, description) values ('Toll Brothers Inc.', 'Homebuilding');
insert into program (name, description) values ('Dorchester Minerals, L.P.', 'Oil & Gas Production');
insert into program (name, description) values ('Nuveen Municipal High Income Opportunity Fund', 'n/a');
insert into program (name, description) values ('Citi Trends, Inc.', 'Clothing/Shoe/Accessory Stores');
insert into program (name, description) values ('Scorpio Tankers Inc.', 'Marine Transportation');
insert into program (name, description) values ('NASDAQ TEST STOCK', 'n/a');
insert into program (name, description) values ('Kennametal Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Hardinge Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Apollo Commercial Real Estate Finance', 'n/a');
insert into program (name, description) values ('Immunomedics, Inc.', 'Biotechnology: In Vitro & In Vivo Diagnostic Substances');
insert into program (name, description) values ('Teekay Tankers Ltd.', 'Marine Transportation');
insert into program (name, description) values ('Reading International Inc', 'Movies/Entertainment');
insert into program (name, description) values ('Ryerson Holding Corporation', 'Metal Fabrications');
insert into program (name, description) values ('Thermo Fisher Scientific Inc', 'Industrial Machinery/Components');
insert into program (name, description) values ('BRF S.A.', 'Meat/Poultry/Fish');
insert into program (name, description) values ('United Insurance Holdings Corp.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Hardinge Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Aquinox Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('OceanFirst Financial Corp.', 'Savings Institutions');
insert into program (name, description) values ('Scudder Multi-Market Income Trust', 'n/a');
insert into program (name, description) values ('Maui Land & Pineapple Company, Inc.', 'Real Estate');
insert into program (name, description) values ('Imax Corporation', 'Industrial Machinery/Components');
insert into program (name, description) values ('Silver Run Acquisition Corporation II', 'Business Services');
insert into program (name, description) values ('Great Elm Capital Corp.', 'n/a');
insert into program (name, description) values ('The Kraft Heinz Company', 'Packaged Foods');
insert into program (name, description) values ('Cambium Learning Group, Inc.', 'Publishing');
insert into program (name, description) values ('Diamond Offshore Drilling, Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('Appliance Recycling Centers of America, Inc.', 'Home Furnishings');
insert into program (name, description) values ('VelocityShares VIX Medium-Term ETN', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('Stag Industrial, Inc.', 'n/a');
insert into program (name, description) values ('Profire Energy, Inc.', 'Metal Fabrications');
insert into program (name, description) values ('BSB Bancorp, Inc.', 'Major Banks');
insert into program (name, description) values ('Fortinet, Inc.', 'Computer peripheral equipment');
insert into program (name, description) values ('First Trust China AlphaDEX Fund', 'n/a');
insert into program (name, description) values ('MannKind Corporation', 'Major Pharmaceuticals');
insert into program (name, description) values ('Edison International', 'Electric Utilities: Central');
insert into program (name, description) values ('Shinhan Financial Group Co Ltd', 'Major Banks');
insert into program (name, description) values ('Microbot Medical Inc. ', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Public Storage', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Enterprise Bancorp Inc', 'Major Banks');
insert into program (name, description) values ('Shore Bancshares Inc', 'Major Banks');
insert into program (name, description) values ('Visteon Corporation', 'Auto Parts:O.E.M.');
insert into program (name, description) values ('G. Willi-Food International,  Ltd.', 'Food Distributors');
insert into program (name, description) values ('Westmoreland Coal Company', 'Coal Mining');
insert into program (name, description) values ('Blackrock Enhanced Government Fund, Inc', 'n/a');
insert into program (name, description) values ('Saratoga Investment Corp', 'n/a');
insert into program (name, description) values ('iRhythm Technologies, Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('OneBeacon Insurance Group, Ltd.', 'Property-Casualty Insurers');
insert into program (name, description) values ('CafePress Inc.', 'Other Specialty Stores');
insert into program (name, description) values ('Teekay Offshore Partners L.P.', 'Marine Transportation');
insert into program (name, description) values ('Exelon Corporation', 'Power Generation');
insert into program (name, description) values ('Great Ajax Corp.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Iteris, Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('Eversource Energy', 'Electric Utilities: Central');
insert into program (name, description) values ('Select Energy Services, Inc.', 'Oilfield Services/Equipment');
insert into program (name, description) values ('Daseke, Inc.', 'Transportation Services');
insert into program (name, description) values ('Home Bancorp, Inc.', 'Banks');
insert into program (name, description) values ('Yum China Holdings, Inc.', 'Restaurants');
insert into program (name, description) values ('Orexigen Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Brown & Brown, Inc.', 'Specialty Insurers');
insert into program (name, description) values ('BB&T Corporation', 'n/a');
insert into program (name, description) values ('Tuesday Morning Corp.', 'Department/Specialty Retail Stores');
insert into program (name, description) values ('New Ireland Fund, Inc. (The)', 'n/a');
insert into program (name, description) values ('Ligand Pharmaceuticals Incorporated', 'Major Pharmaceuticals');
insert into program (name, description) values ('Virtus Total Return Fund Inc.', 'n/a');
insert into program (name, description) values ('Athenex, Inc.', 'n/a');
insert into program (name, description) values ('Virtus Global Dividend & Income Fund Inc.', 'n/a');
insert into program (name, description) values ('BCB Bancorp, Inc. (NJ)', 'Savings Institutions');
insert into program (name, description) values ('Cognex Corporation', 'Industrial Machinery/Components');
insert into program (name, description) values ('GasLog LP.', 'Marine Transportation');
insert into program (name, description) values ('BeyondSpring, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Harsco Corporation', 'Metal Fabrications');
insert into program (name, description) values ('Pennsylvania Real Estate Investment Trust', 'n/a');
insert into program (name, description) values ('Chipotle Mexican Grill, Inc.', 'Restaurants');
insert into program (name, description) values ('Luby''s, Inc.', 'Restaurants');
insert into program (name, description) values ('Strata Skin Sciences, Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('FMC Corporation', 'Major Chemicals');
insert into program (name, description) values ('iPath US Treasury 2-year Bull ETN', 'Commercial Banks');
insert into program (name, description) values ('Modern Media Acquisition Corp.', 'Business Services');
insert into program (name, description) values ('First Trust Managed Municipal ETF', 'n/a');
insert into program (name, description) values ('Sotherly Hotels LP', 'Hotels/Resorts');
insert into program (name, description) values ('Hutchison China MediTech Limited', 'Major Pharmaceuticals');
insert into program (name, description) values ('Wheaton Precious Metals Corp.', 'Precious Metals');
insert into program (name, description) values ('Kennedy-Wilson Holdings Inc.', 'Real Estate');
insert into program (name, description) values ('Heritage Insurance Holdings, Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Geopark Ltd', 'Oil & Gas Production');
insert into program (name, description) values ('Toyota Motor Corp Ltd Ord', 'Auto Manufacturing');
insert into program (name, description) values ('Full House Resorts, Inc.', 'Hotels/Resorts');
insert into program (name, description) values ('First Trust MLP and Energy Income Fund', 'n/a');
insert into program (name, description) values ('Collegium Pharmaceutical, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('First Trust Specialty Finance and Financial Opportunities Fund', 'n/a');
insert into program (name, description) values ('Time Warner Inc.', 'Television Services');
insert into program (name, description) values ('Juno Therapeutics, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Prothena Corporation plc', 'Major Pharmaceuticals');
insert into program (name, description) values ('CryoPort, Inc.', 'Oil Refining/Marketing');
insert into program (name, description) values ('Calix, Inc', 'Telecommunications Equipment');
insert into program (name, description) values ('Easterly Acquisition Corp.', 'Building Products');
insert into program (name, description) values ('BBVA Banco Frances S.A.', 'Commercial Banks');
insert into program (name, description) values ('Scudder Global High Income Fund, Inc.', 'n/a');
insert into program (name, description) values ('China Xiniya Fashion Limited', 'Apparel');
insert into program (name, description) values ('John Hancock Preferred Income Fund', 'n/a');
insert into program (name, description) values ('Eagle Growth and Income Opportunities Fund', 'n/a');
insert into program (name, description) values ('Vical Incorporated', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Terra Nitrogen Company, L.P.', 'Agricultural Chemicals');
insert into program (name, description) values ('E.I. du Pont de Nemours and Company', 'Major Chemicals');
insert into program (name, description) values ('Canada Goose Holdings Inc.', 'Apparel');
insert into program (name, description) values ('BofI Holding, Inc.', 'Savings Institutions');
insert into program (name, description) values ('ParkerVision, Inc.', 'Radio And Television Broadcasting And Communications Equipment');
insert into program (name, description) values ('SeaChange International, Inc.', 'Radio And Television Broadcasting And Communications Equipment');
insert into program (name, description) values ('TravelCenters of America LLC', 'Automotive Aftermarket');
insert into program (name, description) values ('Bank of America Corporation', 'Major Banks');
insert into program (name, description) values ('BiondVax Pharmaceuticals Ltd.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('CSX Corporation', 'Railroads');
insert into program (name, description) values ('Syndax Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Baldwin & Lyons, Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('PNC Financial Services Group, Inc. (The)', 'Major Banks');
insert into program (name, description) values ('Marcus & Millichap, Inc.', 'Real Estate');
insert into program (name, description) values ('FormFactor, Inc.', 'Semiconductors');
insert into program (name, description) values ('Fulgent Genetics, Inc.', 'Medical Specialities');
insert into program (name, description) values ('National Storage Affiliates Trust', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Tiffany & Co.', 'Consumer Specialties');
insert into program (name, description) values ('Nova Lifestyle, Inc', 'Home Furnishings');
insert into program (name, description) values ('B. Riley Financial, Inc.', 'Business Services');
insert into program (name, description) values ('Kingsway Financial Services, Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('ICC Holdings, Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('iShares MSCI UAE Capped ETF', 'n/a');
insert into program (name, description) values ('Ocean Rig UDW Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('Solar Senior Capital Ltd.', 'n/a');
insert into program (name, description) values ('Otter Tail Corporation', 'Electric Utilities: Central');
insert into program (name, description) values ('LKQ Corporation', 'Motor Vehicles');
insert into program (name, description) values ('LCI Industries ', 'n/a');
insert into program (name, description) values ('National General Holdings Corp', 'Property-Casualty Insurers');
insert into program (name, description) values ('Colgate-Palmolive Company', 'Package Goods/Cosmetics');
insert into program (name, description) values ('Liberty Tax, Inc.', 'Multi-Sector Companies');
insert into program (name, description) values ('Quotient Limited', 'Biotechnology: In Vitro & In Vivo Diagnostic Substances');
insert into program (name, description) values ('Euro Tech Holdings Company Limited', 'Diversified Electronic Products');
insert into program (name, description) values ('Texas Capital Bancshares, Inc.', 'Major Banks');
insert into program (name, description) values ('Genomic Health, Inc.', 'Medical Specialities');
insert into program (name, description) values ('Protagonist Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('SVB Financial Group', 'Major Banks');
insert into program (name, description) values ('Enzo Biochem, Inc.', 'Medical Specialities');
insert into program (name, description) values ('Koninklijke Philips N.V.', 'Consumer Electronics/Appliances');
insert into program (name, description) values ('IES Holdings, Inc.', 'Engineering & Construction');
insert into program (name, description) values ('Heidrick & Struggles International, Inc.', 'Diversified Commercial Services');
insert into program (name, description) values ('Littelfuse, Inc.', 'Electrical Products');
insert into program (name, description) values ('Dupont Fabros Technology, Inc.', 'Real Estate');
insert into program (name, description) values ('RCM Technologies, Inc.', 'Professional Services');
insert into program (name, description) values ('TOR Minerals International Inc', 'Major Chemicals');
insert into program (name, description) values ('Dynegy Inc.', 'n/a');
insert into program (name, description) values ('Provident Financial Holdings, Inc.', 'Savings Institutions');
insert into program (name, description) values ('Hancock Holding Company', 'Major Banks');
insert into program (name, description) values ('Willdan Group, Inc.', 'Military/Government/Technical');
insert into program (name, description) values ('Pure Cycle Corporation', 'Water Supply');
insert into program (name, description) values ('SeaSpine Holdings Corporation', 'Medical/Dental Instruments');
insert into program (name, description) values ('EQT Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('Waterstone Financial, Inc.', 'Savings Institutions');
insert into program (name, description) values ('Barclays Inverse US Treasury Composite ETN', 'Commercial Banks');
insert into program (name, description) values ('KLX Inc.', 'Aerospace');
insert into program (name, description) values ('SolarEdge Technologies, Inc.', 'Semiconductors');
insert into program (name, description) values ('Leju Holdings Limited', 'Real Estate');
insert into program (name, description) values ('Community First Bancshares, Inc.', 'n/a');
insert into program (name, description) values ('Blackrock MuniHoldings New Jersey Insured Fund, Inc.', 'n/a');
insert into program (name, description) values ('Mizuho Financial Group, Inc.', 'Major Banks');
insert into program (name, description) values ('Morgan Stanley', 'n/a');
insert into program (name, description) values ('Web.com Group, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Coastway Bancorp, Inc.', 'Savings Institutions');
insert into program (name, description) values ('United Insurance Holdings Corp.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Bel Fuse Inc.', 'Electrical Products');
insert into program (name, description) values ('Invesco Pennsylvania Value Municipal Income Trust', 'n/a');
insert into program (name, description) values ('ANI Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('National Holdings Corporation', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('Goldman Sachs Group, Inc. (The)', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('Monogram Residential Trust, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('TriState Capital Holdings, Inc.', 'Major Banks');
insert into program (name, description) values ('Comstock Resources, Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('Urban One, Inc. ', 'Broadcasting');
insert into program (name, description) values ('Manning & Napier, Inc.', 'Investment Managers');
insert into program (name, description) values ('UBS AG', 'Major Banks');
insert into program (name, description) values ('Madison Strategic Sector Premium Fund', 'n/a');
insert into program (name, description) values ('SEACOR Holdings, Inc.', 'Marine Transportation');
insert into program (name, description) values ('IPG Photonics Corporation', 'Semiconductors');
insert into program (name, description) values ('Stewardship Financial Corp', 'Major Banks');
insert into program (name, description) values ('United States Cellular Corporation', 'Telecommunications Equipment');
insert into program (name, description) values ('Annaly Capital Management Inc', 'n/a');
insert into program (name, description) values ('Colfax Corporation', 'Fluid Controls');
insert into program (name, description) values ('Galmed Pharmaceuticals Ltd.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Fluidigm Corporation', 'Biotechnology: Laboratory Analytical Instruments');
insert into program (name, description) values ('FlexShares STOXX Global ESG Impact Index Fund', 'n/a');
insert into program (name, description) values ('TRC Companies, Inc.', 'Military/Government/Technical');
insert into program (name, description) values ('Chimera Investment Corporation', 'n/a');
insert into program (name, description) values ('Qiagen N.V.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('W.W. Grainger, Inc.', 'Office Equipment/Supplies/Services');
insert into program (name, description) values ('Jaguar Animal Health, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('AAON, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Safe Bulkers, Inc', 'n/a');
insert into program (name, description) values ('ImmuCell Corporation', 'Biotechnology: In Vitro & In Vivo Diagnostic Substances');
insert into program (name, description) values ('NBT Bancorp Inc.', 'Major Banks');
insert into program (name, description) values ('1st Source Corporation', 'Major Banks');
insert into program (name, description) values ('Worthington Industries, Inc.', 'Steel/Iron Ore');
insert into program (name, description) values ('TriplePoint Venture Growth BDC Corp.', 'n/a');
insert into program (name, description) values ('MV Oil Trust', 'Oil & Gas Production');
insert into program (name, description) values ('NovoCure Limited', 'Medical/Dental Instruments');
insert into program (name, description) values ('Miller/Howard High Income Equity Fund', 'n/a');
insert into program (name, description) values ('Big Lots, Inc.', 'Department/Specialty Retail Stores');
insert into program (name, description) values ('PNC Financial Services Group, Inc. (The)', 'n/a');
insert into program (name, description) values ('Alliance Holdings GP, L.P.', 'Coal Mining');
insert into program (name, description) values ('TriplePoint Venture Growth BDC Corp.', 'n/a');
insert into program (name, description) values ('New Ireland Fund, Inc. (The)', 'n/a');
insert into program (name, description) values ('American River Bankshares', 'Major Banks');
insert into program (name, description) values ('Papa Murphy''s Holdings, Inc.', 'Restaurants');
insert into program (name, description) values ('bebe stores, inc.', 'Apparel');
insert into program (name, description) values ('New Mountain Finance Corporation', 'n/a');
insert into program (name, description) values ('Yahoo! Inc.', 'EDP Services');
insert into program (name, description) values ('WesBanco, Inc.', 'Major Banks');
insert into program (name, description) values ('Apptio, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Gamestop Corporation', 'Electronics Distribution');
insert into program (name, description) values ('Silicom Ltd', 'Computer Communications Equipment');
insert into program (name, description) values ('Vornado Realty Trust', 'n/a');
insert into program (name, description) values ('THL Credit, Inc.', 'n/a');
insert into program (name, description) values ('GigaMedia Limited', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('S&P Global Inc.', 'Finance: Consumer Services');
insert into program (name, description) values ('MPLX LP', 'Natural Gas Distribution');
insert into program (name, description) values ('Graphic Packaging Holding Company', 'Containers/Packaging');
insert into program (name, description) values ('La-Z-Boy Incorporated', 'Home Furnishings');
insert into program (name, description) values ('Royal Bank Scotland plc (The)', 'Commercial Banks');
insert into program (name, description) values ('Era Group, Inc.', 'Transportation Services');
insert into program (name, description) values ('Mobile TeleSystems OJSC', 'Telecommunications Equipment');
insert into program (name, description) values ('Comtech Telecommunications Corp.', 'Radio And Television Broadcasting And Communications Equipment');
insert into program (name, description) values ('PS Business Parks, Inc.', 'n/a');
insert into program (name, description) values ('Validus Holdings, Ltd.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Banc of California, Inc.', 'Major Banks');
insert into program (name, description) values ('Hibbett Sports, Inc.', 'Other Specialty Stores');
insert into program (name, description) values ('MagneGas Corporation', 'Industrial Machinery/Components');
insert into program (name, description) values ('Perma-Fix Environmental Services, Inc.', 'Environmental Services');
insert into program (name, description) values ('Adtalem Global Education Inc.', 'Other Consumer Services');
insert into program (name, description) values ('Nuveen Tax-Advantaged Dividend Growth Fund', 'n/a');
insert into program (name, description) values ('Bridge Bancorp, Inc.', 'Major Banks');
insert into program (name, description) values ('Kelly Services, Inc.', 'Professional Services');
insert into program (name, description) values ('Georgia Power Company', 'Electric Utilities: Central');
insert into program (name, description) values ('First Trust RiverFront Dynamic Europe ETF', 'n/a');
insert into program (name, description) values ('Everest Re Group, Ltd.', 'Property-Casualty Insurers');
insert into program (name, description) values ('QIWI plc', 'Business Services');
insert into program (name, description) values ('Vanguard Global ex-U.S. Real Estate ETF', 'n/a');
insert into program (name, description) values ('Niagara Mohawk Holdings, Inc.', 'Power Generation');
insert into program (name, description) values ('Southern California Edison Company', 'n/a');
insert into program (name, description) values ('Tantech Holdings Ltd.', 'Major Chemicals');
insert into program (name, description) values ('New York Community Bancorp, Inc.', 'n/a');
insert into program (name, description) values ('Castlight Health, inc.', 'EDP Services');
insert into program (name, description) values ('Golar LNG Limited', 'Marine Transportation');
insert into program (name, description) values ('RiverNorth Opportunities Fund, Inc.', 'n/a');
insert into program (name, description) values ('Becton, Dickinson and Company', 'Medical/Dental Instruments');
insert into program (name, description) values ('Hillenbrand Inc', 'Miscellaneous manufacturing industries');
insert into program (name, description) values ('Electronics for Imaging, Inc.', 'Computer Communications Equipment');
insert into program (name, description) values ('Spectrum Brands Holdings, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Global Self Storage, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('McDermott International, Inc.', 'Metal Fabrications');
insert into program (name, description) values ('Voya Financial, Inc.', 'Life Insurance');
insert into program (name, description) values ('Diamondback Energy, Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('Companhia Brasileira de Distribuicao', 'Food Chains');
insert into program (name, description) values ('Blackrock Municipal 2020 Term Trust', 'n/a');
insert into program (name, description) values ('Blackhawk Network Holdings, Inc.', 'Finance: Consumer Services');
insert into program (name, description) values ('Intercontinental Exchange Inc.', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('American Homes 4 Rent', 'n/a');
insert into program (name, description) values ('Huntington Bancshares Incorporated', 'Major Banks');
insert into program (name, description) values ('MaxLinear, Inc', 'Semiconductors');
insert into program (name, description) values ('Schnitzer Steel Industries, Inc.', 'Industrial Specialties');
insert into program (name, description) values ('Arrow Electronics, Inc.', 'Electronic Components');
insert into program (name, description) values ('Brocade Communications Systems, Inc.', 'Computer Communications Equipment');
insert into program (name, description) values ('Avinger, Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('LG Display Co., Ltd.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Merrill Lynch & Co., Inc.', 'n/a');
insert into program (name, description) values ('Unico American Corporation', 'Property-Casualty Insurers');
insert into program (name, description) values ('Southern California Edison Company', 'n/a');
insert into program (name, description) values ('USA Technologies, Inc.', 'Office Equipment/Supplies/Services');
insert into program (name, description) values ('First Trust RiverFront Dynamic Europe ETF', 'n/a');
insert into program (name, description) values ('AllianceBernstein Holding L.P.', 'Investment Managers');
insert into program (name, description) values ('TrovaGene, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('National Retail Properties', 'n/a');
insert into program (name, description) values ('MSG Networks Inc.', 'Services-Misc. Amusement & Recreation');
insert into program (name, description) values ('Mid-America Apartment Communities, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('ENDRA Life Sciences Inc.', 'Biotechnology: Electromedical & Electrotherapeutic Apparatus');
insert into program (name, description) values ('China Eastern Airlines Corporation Ltd.', 'Air Freight/Delivery Services');
insert into program (name, description) values ('ObsEva SA', 'Major Pharmaceuticals');
insert into program (name, description) values ('W.W. Grainger, Inc.', 'Office Equipment/Supplies/Services');
insert into program (name, description) values ('Proteostasis Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('CBRE Group, Inc.', 'Real Estate');
insert into program (name, description) values ('Aptevo Therapeutics Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('AirMedia Group Inc', 'Advertising');
insert into program (name, description) values ('Teekay Corporation', 'Marine Transportation');
insert into program (name, description) values ('Keane Group, Inc.', 'Oilfield Services/Equipment');
insert into program (name, description) values ('ViewRay, Inc.', 'Biotechnology: Electromedical & Electrotherapeutic Apparatus');
insert into program (name, description) values ('Evertec, Inc.', 'EDP Services');
insert into program (name, description) values ('Principal Healthcare Innovators Index ETF', 'n/a');
insert into program (name, description) values ('Armada Hoffler Properties, Inc.', 'Real Estate');
insert into program (name, description) values ('Seaspan Corporation', 'Marine Transportation');
insert into program (name, description) values ('Chico''s FAS, Inc.', 'Clothing/Shoe/Accessory Stores');
insert into program (name, description) values ('IDEX Corporation', 'Fluid Controls');
insert into program (name, description) values ('AECOM', 'Military/Government/Technical');
insert into program (name, description) values ('Pimco Global Stocksplus & Income Fund', 'n/a');
insert into program (name, description) values ('Harmony Merger Corp.', 'Oil & Gas Production');
insert into program (name, description) values ('Mellanox Technologies, Ltd.', 'Semiconductors');
insert into program (name, description) values ('Oxbridge Re Holdings Limited', 'Property-Casualty Insurers');
insert into program (name, description) values ('National Bank Holdings Corporation', 'Major Banks');
insert into program (name, description) values ('Novo Nordisk A/S', 'Major Pharmaceuticals');
insert into program (name, description) values ('Mesabi Trust', 'Precious Metals');
insert into program (name, description) values ('Axis Capital Holdings Limited', 'n/a');
insert into program (name, description) values ('Kilroy Realty Corporation', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Intermolecular, Inc.', 'Semiconductors');
insert into program (name, description) values ('ZAGG Inc', 'Other Specialty Stores');
insert into program (name, description) values ('Global Brokerage, Inc.', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('Inovio Pharmaceuticals, Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Alliqua BioMedical, Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('HNI Corporation', 'Office Equipment/Supplies/Services');
insert into program (name, description) values ('West Marine, Inc.', 'Automotive Aftermarket');
insert into program (name, description) values ('Century Bancorp, Inc.', 'Major Banks');
insert into program (name, description) values ('Asta Funding, Inc.', 'Finance Companies');
insert into program (name, description) values ('Calavo Growers, Inc.', 'Farming/Seeds/Milling');
insert into program (name, description) values ('Mid-America Apartment Communities, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Juniper Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Kraton Corporation', 'Major Chemicals');
insert into program (name, description) values ('U.S. Auto Parts Network, Inc.', 'Other Specialty Stores');
insert into program (name, description) values ('Bank of America Corporation', 'n/a');
insert into program (name, description) values ('Triumph Bancorp, Inc.', 'Major Banks');
insert into program (name, description) values ('SkyWest, Inc.', 'Air Freight/Delivery Services');
insert into program (name, description) values ('TechTarget, Inc.', 'Business Services');
insert into program (name, description) values ('Hemisphere Media Group, Inc.', 'Television Services');
insert into program (name, description) values ('Oil States International, Inc.', 'Metal Fabrications');
insert into program (name, description) values ('Container Store (The)', 'Home Furnishings');
insert into program (name, description) values ('Capstead Mortgage Corporation', 'n/a');
insert into program (name, description) values ('Pinnacle West Capital Corporation', 'Electric Utilities: Central');
insert into program (name, description) values ('Blackrock Health Sciences Trust', 'n/a');
insert into program (name, description) values ('Veritone, Inc.', 'EDP Services');
insert into program (name, description) values ('JetPay Corporation', 'Business Services');
insert into program (name, description) values ('ON Semiconductor Corporation', 'Semiconductors');
insert into program (name, description) values ('PCM, Inc.', 'Catalog/Specialty Distribution');
insert into program (name, description) values ('MTGE Investment Corp.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Conyers Park Acquisition Corp.', 'Business Services');
insert into program (name, description) values ('IZEA Inc.', 'Advertising');
insert into program (name, description) values ('Visa Inc.', 'Business Services');
insert into program (name, description) values ('Inventure Foods, Inc.', 'Packaged Foods');
insert into program (name, description) values ('Bel Fuse Inc.', 'Electrical Products');
insert into program (name, description) values ('Monogram Residential Trust, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('NextEra Energy, Inc.', 'n/a');
insert into program (name, description) values ('Cellectar Biosciences, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Tarena International, Inc.', 'Other Consumer Services');
insert into program (name, description) values ('Appliance Recycling Centers of America, Inc.', 'Home Furnishings');
insert into program (name, description) values ('Enbridge Energy, L.P.', 'Natural Gas Distribution');
insert into program (name, description) values ('Tri Continental Corporation', 'n/a');
insert into program (name, description) values ('Cushing Energy Income Fund (The)', 'n/a');
insert into program (name, description) values ('Nuveen Michigan Quality Municipal Income Fund', 'n/a');
insert into program (name, description) values ('WebMD Health Corp', 'Business Services');
insert into program (name, description) values ('Alere Inc.', 'n/a');
insert into program (name, description) values ('Macro Bank Inc.', 'Commercial Banks');
insert into program (name, description) values ('Torchlight Energy Resources, Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('Equity Commonwealth', 'Real Estate Investment Trusts');
insert into program (name, description) values ('SeaSpine Holdings Corporation', 'Medical/Dental Instruments');
insert into program (name, description) values ('Playa Hotels & Resorts N.V.', 'Hotels/Resorts');
insert into program (name, description) values ('Arbor Realty Trust', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Star Bulk Carriers Corp.', 'Marine Transportation');
insert into program (name, description) values ('First Connecticut Bancorp, Inc.', 'Banks');
insert into program (name, description) values ('Eagle Point Credit Company Inc.', 'n/a');
insert into program (name, description) values ('ProShares UltraPro Short QQQ', 'n/a');
insert into program (name, description) values ('Real Industry, Inc. ', 'Telecommunications Equipment');
insert into program (name, description) values ('Hunter Maritime Acquisition Corp.', 'Oil Refining/Marketing');
insert into program (name, description) values ('WPCS International Incorporated', 'Telecommunications Equipment');
insert into program (name, description) values ('Charles & Colvard Ltd', 'Consumer Specialties');
insert into program (name, description) values ('National General Holdings Corp', 'Property-Casualty Insurers');
insert into program (name, description) values ('Novo Nordisk A/S', 'Major Pharmaceuticals');
insert into program (name, description) values ('Albireo Pharma, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Origo Acquisition Corporation', 'Business Services');
insert into program (name, description) values ('JA Solar Holdings, Co., Ltd.', 'Semiconductors');
insert into program (name, description) values ('Barnes Group, Inc.', 'Metal Fabrications');
insert into program (name, description) values ('Organovo Holdings, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('The Travelers Companies, Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('MediciNova, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Mobileye N.V.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Whitestone REIT', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Arlington Asset Investment Corp', 'n/a');
insert into program (name, description) values ('Grupo Financiero Galicia S.A.', 'Commercial Banks');
insert into program (name, description) values ('Addus HomeCare Corporation', 'Medical/Nursing Services');
insert into program (name, description) values ('HFF, Inc.', 'Real Estate');
insert into program (name, description) values ('Huntington Bancshares Incorporated', 'Major Banks');
insert into program (name, description) values ('Blackrock MuniYield New Jersey Fund, Inc.', 'n/a');
insert into program (name, description) values ('PowerShares DWA Momentum Portfolio', 'n/a');
insert into program (name, description) values ('Putnam Municipal Opportunities Trust', 'n/a');
insert into program (name, description) values ('Welbilt, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Net 1 UEPS Technologies, Inc.', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('SteadyMed Ltd.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Agree Realty Corporation', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Goldman Sachs Group, Inc. (The)', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('Children''s Place, Inc. (The)', 'Clothing/Shoe/Accessory Stores');
insert into program (name, description) values ('Horizon Pharma plc', 'Major Pharmaceuticals');
insert into program (name, description) values ('Barington/Hilco Acquisition Corp.', 'Business Services');
insert into program (name, description) values ('General American Investors, Inc.', 'n/a');
insert into program (name, description) values ('Voya Emerging Markets High Income Dividend Equity Fund', 'n/a');
insert into program (name, description) values ('FB Financial Corporation', 'Major Banks');
insert into program (name, description) values ('IXYS Corporation', 'Semiconductors');
insert into program (name, description) values ('PowerShares QQQ Trust, Series 1', 'n/a');
insert into program (name, description) values ('Covenant Transportation Group, Inc.', 'Trucking Freight/Courier Services');
insert into program (name, description) values ('Motorcar Parts of America, Inc.', 'Auto Parts:O.E.M.');
insert into program (name, description) values ('Community Health Systems, Inc.', 'Hospital/Nursing Management');
insert into program (name, description) values ('ICF International, Inc.', 'Professional Services');
insert into program (name, description) values ('JD.com, Inc.', 'Other Specialty Stores');
insert into program (name, description) values ('First Trust/Aberdeen Emerging Opportunity Fund', 'n/a');
insert into program (name, description) values ('Gyrodyne , LLC', 'Building operators');
insert into program (name, description) values ('Viper Energy Partners LP', 'Oil & Gas Production');
insert into program (name, description) values ('Hill International, Inc.', 'Military/Government/Technical');
insert into program (name, description) values ('Cedar Realty Trust, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Nivalis Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Inventure Foods, Inc.', 'Packaged Foods');
insert into program (name, description) values ('New Relic, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('EQT Midstream Partners, LP', 'Natural Gas Distribution');
insert into program (name, description) values ('Qiagen N.V.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('SAP SE', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Tremor Video, Inc.', 'Advertising');
insert into program (name, description) values ('Penske Automotive Group, Inc.', 'Automotive Aftermarket');
insert into program (name, description) values ('Uniti Group Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Cirrus Logic, Inc.', 'Semiconductors');
insert into program (name, description) values ('LATAM Airlines Group S.A.', 'Air Freight/Delivery Services');
insert into program (name, description) values ('Big 5 Sporting Goods Corporation', 'Other Specialty Stores');
insert into program (name, description) values ('Senior Housing Properties Trust', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Star Bulk Carriers Corp.', 'Marine Transportation');
insert into program (name, description) values ('B&G Foods, Inc.', 'Packaged Foods');
insert into program (name, description) values ('AGNC Investment Corp.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Vonage Holdings Corp.', 'Telecommunications Equipment');
insert into program (name, description) values ('Virtus Global Dividend & Income Fund Inc.', 'n/a');
insert into program (name, description) values ('On Assignment, Inc.', 'Professional Services');
insert into program (name, description) values ('Spok Holdings, Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('Otonomy, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('PowerShares FTSE RAFI US 1500 Small-Mid Portfolio', 'n/a');
insert into program (name, description) values ('Beneficial Bancorp, Inc.', 'Savings Institutions');
insert into program (name, description) values ('ING Group, N.V.', 'Commercial Banks');
insert into program (name, description) values ('Anadarko Petroleum Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('Gladstone Capital Corporation', 'n/a');
insert into program (name, description) values ('Tenneco Inc.', 'Auto Parts:O.E.M.');
insert into program (name, description) values ('Pimco California Municipal Income Fund II', 'n/a');
insert into program (name, description) values ('Sonic Corp.', 'Restaurants');
insert into program (name, description) values ('Rush Enterprises, Inc.', 'Automotive Aftermarket');
insert into program (name, description) values ('BancFirst Corporation', 'Major Banks');
insert into program (name, description) values ('DTE Energy Company', 'Electric Utilities: Central');
insert into program (name, description) values ('Osisko Gold Royalties Ltd', 'Precious Metals');
insert into program (name, description) values ('Atlantic Capital Bancshares, Inc.', 'Major Banks');
insert into program (name, description) values ('Kimco Realty Corporation', 'n/a');
insert into program (name, description) values ('Waters Corporation', 'Biotechnology: Laboratory Analytical Instruments');
insert into program (name, description) values ('BioLife Solutions, Inc.', 'Biotechnology: Electromedical & Electrotherapeutic Apparatus');
insert into program (name, description) values ('GasLog Partners LP', 'n/a');
insert into program (name, description) values ('Yingli Green Energy Holding Company Limited', 'Semiconductors');
insert into program (name, description) values ('Royal Caribbean Cruises Ltd.', 'Marine Transportation');
insert into program (name, description) values ('Retail Properties of America, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Stepan Company', 'Package Goods/Cosmetics');
insert into program (name, description) values ('NCI Building Systems, Inc.', 'Metal Fabrications');
insert into program (name, description) values ('Texas Capital Bancshares, Inc.', 'Major Banks');
insert into program (name, description) values ('Constellium N.V.', 'Metal Fabrications');
insert into program (name, description) values ('Prudential Public Limited Company', 'Life Insurance');
insert into program (name, description) values ('Mondelez International, Inc.', 'Packaged Foods');
insert into program (name, description) values ('Active Alts Contrarian ETF', 'n/a');
insert into program (name, description) values ('Seacoast Banking Corporation of Florida', 'Major Banks');
insert into program (name, description) values ('PowerShares Multi-Strategy Alternative Portfolio', 'n/a');
insert into program (name, description) values ('FIRST REPUBLIC BANK', 'n/a');
insert into program (name, description) values ('PennantPark Floating Rate Capital Ltd.', 'n/a');
insert into program (name, description) values ('FinTech Acquisition Corp. II', 'Business Services');
insert into program (name, description) values ('Armada Hoffler Properties, Inc.', 'Real Estate');
insert into program (name, description) values ('Dynegy Inc.', 'n/a');
insert into program (name, description) values ('Edgewater Technology, Inc.', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('PRA Group, Inc.', 'Finance: Consumer Services');
insert into program (name, description) values ('Asia Tigers Fund, Inc. (The)', 'n/a');
insert into program (name, description) values ('Rush Enterprises, Inc.', 'Automotive Aftermarket');
insert into program (name, description) values ('National Health Investors, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Inpixon ', 'EDP Services');
insert into program (name, description) values ('Brooks Automation, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Turkish Investment Fund, Inc. (The)', 'n/a');
insert into program (name, description) values ('Frontier Communications Corporation', 'Telecommunications Equipment');
insert into program (name, description) values ('Blackrock Municipal Income Quality Trust', 'n/a');
insert into program (name, description) values ('Rosehill Resources Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('Atento S.A.', 'Telecommunications Equipment');
insert into program (name, description) values ('Synacor, Inc.', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('VictoryShares US Discovery Enhanced Volatility Wtd ETF', 'n/a');
insert into program (name, description) values ('WisdomTree Negative Duration High Yield Bond Fund', 'n/a');
insert into program (name, description) values ('Supernus Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Wintrust Financial Corporation', 'Major Banks');
insert into program (name, description) values ('CAE Inc', 'Industrial Machinery/Components');
insert into program (name, description) values ('Dean Foods Company', 'Packaged Foods');
insert into program (name, description) values ('Determine, Inc. ', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Electrum Special Acquisition Corporation', 'Business Services');
insert into program (name, description) values ('First Trust RiverFront Dynamic Europe ETF', 'n/a');
insert into program (name, description) values ('CombiMatrix Corporation', 'Hospital/Nursing Management');
insert into program (name, description) values ('Kimco Realty Corporation', 'n/a');
insert into program (name, description) values ('First Financial Corporation Indiana', 'Major Banks');
insert into program (name, description) values ('Davis Select U.S. Equity ETF', 'n/a');
insert into program (name, description) values ('Accenture plc', 'Business Services');
insert into program (name, description) values ('Integer Holdings Corporation', 'Industrial Machinery/Components');
insert into program (name, description) values ('Evoke Pharma, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Yahoo! Inc.', 'EDP Services');
insert into program (name, description) values ('Western Asset Global Corporate Defined Opportunity Fund Inc.', 'n/a');
insert into program (name, description) values ('Brookfield DTLA Inc.', 'n/a');
insert into program (name, description) values ('Hologic, Inc.', 'Medical Electronics');
insert into program (name, description) values ('Shenandoah Telecommunications Co', 'Telecommunications Equipment');
insert into program (name, description) values ('Nuveen S&P 500 Buy-Write Income Fund', 'n/a');
insert into program (name, description) values ('Nuveen Minnesota Quality Municipal Income Fund', 'n/a');
insert into program (name, description) values ('Atlantic American Corporation', 'Life Insurance');
insert into program (name, description) values ('Navios Maritime Holdings Inc.', 'n/a');
insert into program (name, description) values ('Marine Products Corporation', 'Marine Transportation');
insert into program (name, description) values ('Beacon Roofing Supply, Inc.', 'RETAIL: Building Materials');
insert into program (name, description) values ('Intrawest Resorts Holdings, Inc.', 'Services-Misc. Amusement & Recreation');
insert into program (name, description) values ('iShares S&P Global Timber & Forestry Index Fund', 'n/a');
insert into program (name, description) values ('Aspen Aerogels, Inc.', 'RETAIL: Building Materials');
insert into program (name, description) values ('HopFed Bancorp, Inc.', 'Major Banks');
insert into program (name, description) values ('Blackrock MuniYield Investment QualityFund', 'n/a');
insert into program (name, description) values ('Brink''s Company (The)', 'Oil Refining/Marketing');
insert into program (name, description) values ('Paychex, Inc.', 'Diversified Commercial Services');
insert into program (name, description) values ('Insignia Systems, Inc.', 'Advertising');
insert into program (name, description) values ('STMicroelectronics N.V.', 'Semiconductors');
insert into program (name, description) values ('Textron Inc.', 'Aerospace');
insert into program (name, description) values ('Allied Motion Technologies, Inc.', 'Electrical Products');
insert into program (name, description) values ('DTE Energy Company', 'Electric Utilities: Central');
insert into program (name, description) values ('Flex Pharma, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('CenturyLink, Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('Advaxis, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('iShares S&P Global Clean Energy Index Fund', 'n/a');
insert into program (name, description) values ('Landmark Infrastructure Partners LP', 'Real Estate');
insert into program (name, description) values ('Allegheny Technologies Incorporated', 'Steel/Iron Ore');
insert into program (name, description) values ('Cisco Systems, Inc.', 'Computer Communications Equipment');
insert into program (name, description) values ('At Home Group Inc.', 'Home Furnishings');
insert into program (name, description) values ('Griffon Corporation', 'Building Products');
insert into program (name, description) values ('Fairmount Santrol Holdings Inc.', 'Mining & Quarrying of Nonmetallic Minerals (No Fuels)');
insert into program (name, description) values ('Star Bulk Carriers Corp.', 'Marine Transportation');
insert into program (name, description) values ('Xenetic Biosciences, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Legacy Reserves LP', 'Oil & Gas Production');
insert into program (name, description) values ('Hancock Holding Company', 'Major Banks');
insert into program (name, description) values ('First Trust Nasdaq Semiconductor ETF', 'n/a');
insert into program (name, description) values ('AmeriGas Partners, L.P.', 'Other Specialty Stores');
insert into program (name, description) values ('Olympic Steel, Inc.', 'Metal Fabrications');
insert into program (name, description) values ('Blackstone GSO Senior Floating Rate Term Fund', 'n/a');
insert into program (name, description) values ('Hudson Technologies, Inc.', 'Industrial Specialties');
insert into program (name, description) values ('ViewRay, Inc.', 'Biotechnology: Electromedical & Electrotherapeutic Apparatus');
insert into program (name, description) values ('Guggenheim Strategic Opportunities Fund', 'n/a');
insert into program (name, description) values ('Turning Point Brands, Inc.', 'Tobacco');
insert into program (name, description) values ('CEVA, Inc.', 'Semiconductors');
insert into program (name, description) values ('American Campus Communities Inc', 'Real Estate Investment Trusts');
insert into program (name, description) values ('J. W. Mays, Inc.', 'Building operators');
insert into program (name, description) values ('First Trust Germany AlphaDEX Fund', 'n/a');
insert into program (name, description) values ('Cooper Companies, Inc. (The)', 'Ophthalmic Goods');
insert into program (name, description) values ('TeleTech Holdings, Inc.', 'Professional Services');
insert into program (name, description) values ('San Juan Basin Royalty Trust', 'Oil & Gas Production');
insert into program (name, description) values ('Nivalis Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Annaly Capital Management Inc', 'n/a');
insert into program (name, description) values ('Cantel Medical Corp.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Citrix Systems, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('SecureWorks Corp.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Ulta Beauty, Inc.', 'Other Specialty Stores');
insert into program (name, description) values ('Thermon Group Holdings, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Qwest Corporation', 'Telecommunications Equipment');
insert into program (name, description) values ('Blackrock New York Municipal 2018 Term Trust', 'n/a');
insert into program (name, description) values ('HP Inc.', 'Computer Manufacturing');
insert into program (name, description) values ('PT Telekomunikasi Indonesia, Tbk', 'Telecommunications Equipment');
insert into program (name, description) values ('BiondVax Pharmaceuticals Ltd.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Essendant Inc.', 'Paper');
insert into program (name, description) values ('Wright Medical Group N.V.', 'Industrial Specialties');
insert into program (name, description) values ('Iridium Communications Inc', 'Telecommunications Equipment');
insert into program (name, description) values ('Conatus Pharmaceuticals Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Nivalis Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('PowerShares S&P SmallCap Consumer Discretionary Portfolio', 'n/a');
insert into program (name, description) values ('PowerShares KBW Premium Yield Equity REIT Portfolio', 'n/a');
insert into program (name, description) values ('Costamare Inc.', 'Marine Transportation');
insert into program (name, description) values ('SEI Investments Company', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('CTI BioPharma Corp.', 'Major Pharmaceuticals');
insert into program (name, description) values ('AngioDynamics, Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Iridium Communications Inc', 'Telecommunications Equipment');
insert into program (name, description) values ('Vanguard Russell 3000 ETF', 'n/a');
insert into program (name, description) values ('Resources Connection, Inc.', 'Business Services');
insert into program (name, description) values ('Lennar Corporation', 'Homebuilding');
insert into program (name, description) values ('Neenah Paper, Inc.', 'Paper');
insert into program (name, description) values ('AAON, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Juniper Networks, Inc.', 'Computer Communications Equipment');
insert into program (name, description) values ('BOK Financial Corporation', 'Major Banks');
insert into program (name, description) values ('Rexford Industrial Realty, Inc.', 'n/a');
insert into program (name, description) values ('Euronet Worldwide, Inc.', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('EXCO Resources NL', 'Oil & Gas Production');
insert into program (name, description) values ('Macquarie Infrastructure Company', 'Oil Refining/Marketing');
insert into program (name, description) values ('Emerald Expositions Events, Inc.', 'Business Services');
insert into program (name, description) values ('Farmers National Banc Corp.', 'Major Banks');
insert into program (name, description) values ('DTE Energy Company', 'Electric Utilities: Central');
insert into program (name, description) values ('Inspired Entertainment, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Dupont Fabros Technology, Inc.', 'n/a');
insert into program (name, description) values ('Farmland Partners Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Cleveland BioLabs, Inc.', 'Biotechnology: Commercial Physical & Biological Resarch');
insert into program (name, description) values ('Honda Motor Company, Ltd.', 'Auto Manufacturing');
insert into program (name, description) values ('Agios Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('AnaptysBio, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Blackrock Municipal 2018 Term Trust', 'n/a');
insert into program (name, description) values ('Welbilt, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Exelixis, Inc.', 'Biotechnology: Commercial Physical & Biological Resarch');
insert into program (name, description) values ('Tempur Sealy International, Inc.', 'Home Furnishings');
insert into program (name, description) values ('Armstrong World Industries Inc', 'Plastic Products');
insert into program (name, description) values ('The Michaels Companies, Inc.', 'Recreational Products/Toys');
insert into program (name, description) values ('Hawkins, Inc.', 'Specialty Chemicals');
insert into program (name, description) values ('Roadrunner Transportation Systems, Inc', 'Oil Refining/Marketing');
insert into program (name, description) values ('Hallador Energy Company', 'Coal Mining');
insert into program (name, description) values ('Hill-Rom Holdings Inc', 'Medical/Dental Instruments');
insert into program (name, description) values ('Alon USA Energy, Inc.', 'Integrated oil Companies');
insert into program (name, description) values ('Twitter, Inc.', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('Pulse Biosciences, Inc', 'Medical/Dental Instruments');
insert into program (name, description) values ('Deckers Outdoor Corporation', 'Shoe Manufacturing');
insert into program (name, description) values ('NextEra Energy Partners, LP', 'Electric Utilities: Central');
insert into program (name, description) values ('Leading Brands Inc', 'Beverages (Production/Distribution)');
insert into program (name, description) values ('American Software, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Deutsche Bank AG', 'Major Banks');
insert into program (name, description) values ('Nuveen Preferred and Income Term Fund', 'n/a');
insert into program (name, description) values ('MS Structured Asset Corp Saturns GE Cap Corp Series 2002-14', 'Finance: Consumer Services');
insert into program (name, description) values ('Aramark', 'Restaurants');
insert into program (name, description) values ('American Express Company', 'Finance: Consumer Services');
insert into program (name, description) values ('Herc Holdings Inc.', 'n/a');
insert into program (name, description) values ('Kulicke and Soffa Industries, Inc.', 'Semiconductors');
insert into program (name, description) values ('Capital One Financial Corporation', 'Major Banks');
insert into program (name, description) values ('Pixelworks, Inc.', 'Semiconductors');
insert into program (name, description) values ('Keryx Biopharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Ames National Corporation', 'Major Banks');
insert into program (name, description) values ('LCNB Corporation', 'Major Banks');
insert into program (name, description) values ('Sunstone Hotel Investors, Inc.', 'Hotels/Resorts');
insert into program (name, description) values ('UGI Corporation', 'Natural Gas Distribution');
insert into program (name, description) values ('PartnerRe Ltd.', 'n/a');
insert into program (name, description) values ('Pathfinder Bancorp, Inc.', 'Major Banks');
insert into program (name, description) values ('Innovative Industrial Properties, Inc.', 'Real Estate');
insert into program (name, description) values ('Twilio Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('EP Energy Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('Wright Medical Group N.V.', 'Industrial Specialties');
insert into program (name, description) values ('Atlantic Power Corporation', 'Electric Utilities: Central');
insert into program (name, description) values ('Ocera Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('KVH Industries, Inc.', 'Radio And Television Broadcasting And Communications Equipment');
insert into program (name, description) values ('PIMCO California Municipal Income Fund', 'n/a');
insert into program (name, description) values ('Genesco Inc.', 'Clothing/Shoe/Accessory Stores');
insert into program (name, description) values ('Brocade Communications Systems, Inc.', 'Computer Communications Equipment');
insert into program (name, description) values ('FIRST REPUBLIC BANK', 'n/a');
insert into program (name, description) values ('Amkor Technology, Inc.', 'Semiconductors');
insert into program (name, description) values ('ServiceNow, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('First Solar, Inc.', 'Semiconductors');
insert into program (name, description) values ('John Hancock Financial Opportunities Fund', 'n/a');
insert into program (name, description) values ('Catalyst Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Grupo Financiero Santander Mexico S.A. B. de C.V.', 'Commercial Banks');
insert into program (name, description) values ('Student Transportation Inc', 'Other Transportation');
insert into program (name, description) values ('Actua Corporation', 'EDP Services');
insert into program (name, description) values ('Tsakos Energy Navigation Ltd', 'Marine Transportation');
insert into program (name, description) values ('Yirendai Ltd.', 'Finance: Consumer Services');
insert into program (name, description) values ('Tetra Technologies, Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('Franklin Resources, Inc.', 'Investment Managers');
insert into program (name, description) values ('Axar Acquisition Corp.', 'Business Services');
insert into program (name, description) values ('Micronet Enertec Technologies, Inc.', 'Electrical Products');
insert into program (name, description) values ('ClearBridge Energy MLP Total Return Fund Inc.', 'n/a');
insert into program (name, description) values ('Wells Fargo & Company', 'n/a');
insert into program (name, description) values ('Ulta Beauty, Inc.', 'Other Specialty Stores');
insert into program (name, description) values ('Wintrust Financial Corporation', 'Major Banks');
insert into program (name, description) values ('PowerShares DWA Financial Momentum Portfolio', 'n/a');
insert into program (name, description) values ('Profire Energy, Inc.', 'Metal Fabrications');
insert into program (name, description) values ('Matlin & Partners Acquisition Corporation', 'Business Services');
insert into program (name, description) values ('Newpark Resources, Inc.', 'Metal Fabrications');
insert into program (name, description) values ('Public Storage', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Sunstone Hotel Investors, Inc.', 'n/a');
insert into program (name, description) values ('GenMark Diagnostics, Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Turkcell Iletisim Hizmetleri AS', 'Telecommunications Equipment');
insert into program (name, description) values ('iShares Asia 50 ETF', 'n/a');
insert into program (name, description) values ('Guaranty Bancshares, Inc.', 'Major Banks');
insert into program (name, description) values ('SMART Global Holdings, Inc.', 'Semiconductors');
insert into program (name, description) values ('Transocean Ltd.', 'Oil & Gas Production');
insert into program (name, description) values ('Arch Capital Group Ltd.', 'n/a');
insert into program (name, description) values ('Antero Resources Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('Fresh Del Monte Produce, Inc.', 'Farming/Seeds/Milling');
insert into program (name, description) values ('Fortress Investment Group LLC', 'Investment Managers');
insert into program (name, description) values ('Smith Micro Software, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Microchip Technology Incorporated', 'Semiconductors');
insert into program (name, description) values ('First Trust Total US Market AlphaDEX ETF', 'n/a');
insert into program (name, description) values ('Axon Enterprise, Inc.', 'Ordnance And Accessories');
insert into program (name, description) values ('Blackrock MuniYield Michigan Quality Fund, Inc.', 'n/a');
insert into program (name, description) values ('Moelis & Company', 'Investment Managers');
insert into program (name, description) values ('Hawaiian Electric Industries, Inc.', 'Electric Utilities: Central');
insert into program (name, description) values ('Telefonica Brasil S.A.', 'Telecommunications Equipment');
insert into program (name, description) values ('China Life Insurance Company Limited', 'Life Insurance');
insert into program (name, description) values ('ConnectOne Bancorp, Inc.', 'Major Banks');
insert into program (name, description) values ('Iteris, Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('Cidara Therapeutics, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Blackrock MuniYield Quality Fund, Inc.', 'n/a');
insert into program (name, description) values ('ViewRay, Inc.', 'Biotechnology: Electromedical & Electrotherapeutic Apparatus');
insert into program (name, description) values ('Opus Bank', 'n/a');
insert into program (name, description) values ('Grupo Aval Acciones y Valores S.A.', 'Commercial Banks');
insert into program (name, description) values ('Data I/O Corporation', 'Electrical Products');
insert into program (name, description) values ('MMA Capital Management, LLC', 'Real Estate');
insert into program (name, description) values ('Sprouts Farmers Market, Inc.', 'Food Chains');
insert into program (name, description) values ('Pacific Special Acquisition Corp.', 'Business Services');
insert into program (name, description) values ('Customers Bancorp, Inc', 'n/a');
insert into program (name, description) values ('Allot Communications Ltd.', 'Computer Communications Equipment');
insert into program (name, description) values ('Cardiovascular Systems, Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Rice Energy Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('Green Bancorp, Inc.', 'Major Banks');
insert into program (name, description) values ('Eaton Vance Senior Income Trust', 'n/a');
insert into program (name, description) values ('T-Mobile US, Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('Lexington Realty Trust', 'n/a');
insert into program (name, description) values ('Casella Waste Systems, Inc.', 'Environmental Services');
insert into program (name, description) values ('Brookline Bancorp, Inc.', 'Savings Institutions');
insert into program (name, description) values ('Devon Energy Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('Sky Solar Holdings, Ltd.', 'Electric Utilities: Central');
insert into program (name, description) values ('BP Prudhoe Bay Royalty Trust', 'Integrated oil Companies');
insert into program (name, description) values ('Cavco Industries, Inc.', 'Homebuilding');
insert into program (name, description) values ('Beazer Homes USA, Inc.', 'Homebuilding');
insert into program (name, description) values ('Lannett Co Inc', 'Major Pharmaceuticals');
insert into program (name, description) values ('CIT Group Inc (DEL)', 'Finance: Consumer Services');
insert into program (name, description) values ('Jupai Holdings Limited', 'Other Consumer Services');
insert into program (name, description) values ('Advanced Accelerator Applications S.A.', 'Major Pharmaceuticals');
insert into program (name, description) values ('UCP, Inc.', 'Homebuilding');
insert into program (name, description) values ('John Wiley & Sons, Inc.', 'n/a');
insert into program (name, description) values ('WCF Bancorp, Inc.', 'Major Banks');
insert into program (name, description) values ('MTGE Investment Corp.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('FinTech Acquisition Corp. II', 'Business Services');
insert into program (name, description) values ('Asure Software Inc', 'EDP Services');
insert into program (name, description) values ('Affiliated Managers Group, Inc.', 'Investment Managers');
insert into program (name, description) values ('Comp En De Mn Cemig ADS', 'Electric Utilities: Central');
insert into program (name, description) values ('Flushing Financial Corporation', 'Major Banks');
insert into program (name, description) values ('Halliburton Company', 'Oilfield Services/Equipment');
insert into program (name, description) values ('M/I Homes, Inc.', 'Homebuilding');
insert into program (name, description) values ('American Electric Power Company, Inc.', 'Electric Utilities: Central');
insert into program (name, description) values ('TRACON Pharmaceuticals, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('iRobot Corporation', 'Consumer Electronics/Appliances');
insert into program (name, description) values ('8x8 Inc', 'Telecommunications Equipment');
insert into program (name, description) values ('Baltimore Gas & Electric Company', 'n/a');
insert into program (name, description) values ('Ryerson Holding Corporation', 'Metal Fabrications');
insert into program (name, description) values ('CoreSite Realty Corporation', 'n/a');
insert into program (name, description) values ('Griffin Industrial Realty, Inc.', 'Real Estate');
insert into program (name, description) values ('Aware, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Horace Mann Educators Corporation', 'Property-Casualty Insurers');
insert into program (name, description) values ('Customers Bancorp, Inc', 'n/a');
insert into program (name, description) values ('Carrols Restaurant Group, Inc.', 'Restaurants');
insert into program (name, description) values ('HealthEquity, Inc.', 'Business Services');
insert into program (name, description) values ('Blackrock New York Municipal Bond Trust', 'n/a');
insert into program (name, description) values ('Selecta Biosciences, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Newtek Business Services Corp.', 'n/a');
insert into program (name, description) values ('Flaherty & Crumrine Preferred Securities Income Fund Inc', 'n/a');
insert into program (name, description) values ('Gevo, Inc.', 'Major Chemicals');
insert into program (name, description) values ('Equitable Financial Corp.', 'Savings Institutions');
insert into program (name, description) values ('BankUnited, Inc.', 'Savings Institutions');
insert into program (name, description) values ('PennyMac Mortgage Investment Trust', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Renren Inc.', 'EDP Services');
insert into program (name, description) values ('RADA Electronic Industries Ltd.', 'Electronic Components');
insert into program (name, description) values ('MutualFirst Financial Inc.', 'Major Banks');
insert into program (name, description) values ('Zendesk, Inc.', 'EDP Services');
insert into program (name, description) values ('Jazz Pharmaceuticals plc', 'Major Pharmaceuticals');
insert into program (name, description) values ('Assured Guaranty Ltd.', 'n/a');
insert into program (name, description) values ('Theravance Biopharma, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('NASDAQ TEST STOCK', 'n/a');
insert into program (name, description) values ('Playa Hotels & Resorts N.V.', 'Hotels/Resorts');
insert into program (name, description) values ('Odyssey Marine Exploration, Inc.', 'Marine Transportation');
insert into program (name, description) values ('GTY Technology Holdings, Inc.', 'Business Services');
insert into program (name, description) values ('THL Credit Senior Loan Fund', 'n/a');
insert into program (name, description) values ('ClearOne, Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('Nivalis Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Jumei International Holding Limited', 'Other Specialty Stores');
insert into program (name, description) values ('FARO Technologies, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('PrimeEnergy Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('Western Gas Partners, LP', 'Natural Gas Distribution');
insert into program (name, description) values ('CVS Health Corporation', 'Medical/Nursing Services');
insert into program (name, description) values ('Cowen Inc.', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('China Rapid Finance Limited', 'Finance: Consumer Services');
insert into program (name, description) values ('Evolving Systems, Inc.', 'EDP Services');
insert into program (name, description) values ('WisdomTree United Kingdom Hedged Equity Fund', 'n/a');
insert into program (name, description) values ('Neovasc Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Nuveen Senior Income Fund', 'n/a');
insert into program (name, description) values ('ANI Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Potlatch Corporation', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Histogenics Corporation', 'Industrial Specialties');
insert into program (name, description) values ('Ambac Financial Group, Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Zendesk, Inc.', 'EDP Services');
insert into program (name, description) values ('Tanger Factory Outlet Centers, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Approach Resources Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('FRP Holdings, Inc.', 'Real Estate');
insert into program (name, description) values ('Xunlei Limited', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Taiwan Fund, Inc. (The)', 'n/a');
insert into program (name, description) values ('NRG Energy, Inc.', 'Electric Utilities: Central');
insert into program (name, description) values ('Carbo Ceramics, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Dunkin'' Brands Group, Inc.', 'Restaurants');
insert into program (name, description) values ('X-Links Silver Shares Covered Call ETN', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('Foresight Autonomous Holdings Ltd.', 'n/a');
insert into program (name, description) values ('Regional Management Corp.', 'Finance: Consumer Services');
insert into program (name, description) values ('Rosetta Stone', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('ASA Gold and Precious Metals Limited', 'n/a');
insert into program (name, description) values ('CB Financial Services, Inc.', 'Major Banks');
insert into program (name, description) values ('Scorpio Bulkers Inc.', 'Marine Transportation');
insert into program (name, description) values ('Southern National Bancorp of Virginia, Inc.', 'Major Banks');
insert into program (name, description) values ('Pacific Continental Corporation (Ore)', 'Major Banks');
insert into program (name, description) values ('Swiss Helvetia Fund, Inc. (The)', 'n/a');
insert into program (name, description) values ('Legg Mason Low Volatility High Dividend ETF', 'n/a');
insert into program (name, description) values ('Quality Systems, Inc.', 'EDP Services');
insert into program (name, description) values ('Concert Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Laureate Education, Inc.', 'Other Consumer Services');
insert into program (name, description) values ('Hawaiian Electric Industries, Inc.', 'Electric Utilities: Central');
insert into program (name, description) values ('EXFO Inc', 'Electrical Products');
insert into program (name, description) values ('First Trust Nasdaq Retail ETF', 'n/a');
insert into program (name, description) values ('Ameresco, Inc.', 'Engineering & Construction');
insert into program (name, description) values ('Bank of America Corporation', 'n/a');
insert into program (name, description) values ('Quinpario Acquisition Corp. 2', 'Business Services');
insert into program (name, description) values ('Boston Properties, Inc.', 'n/a');
insert into program (name, description) values ('NIC Inc.', 'Business Services');
insert into program (name, description) values ('PowerShares S&P SmallCap Materials Portfolio', 'n/a');
insert into program (name, description) values ('Amphenol Corporation', 'Electrical Products');
insert into program (name, description) values ('General Finance Corporation', 'Diversified Commercial Services');
insert into program (name, description) values ('Public Storage', 'Real Estate Investment Trusts');
insert into program (name, description) values ('First Trust', 'n/a');
insert into program (name, description) values ('Determine, Inc. ', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('TerraForm Power, Inc.', 'Electric Utilities: Central');
insert into program (name, description) values ('NASDAQ TEST STOCK', 'n/a');
insert into program (name, description) values ('DSP Group, Inc.', 'Semiconductors');
insert into program (name, description) values ('TPI Composites, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('LATAM Airlines Group S.A.', 'Air Freight/Delivery Services');
insert into program (name, description) values ('Invesco Municipal Income Opportunities Trust', 'n/a');
insert into program (name, description) values ('ATN International, Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('Ocular Therapeutix, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Playa Hotels & Resorts N.V.', 'Hotels/Resorts');
insert into program (name, description) values ('Northern Trust Corporation', 'Major Banks');
insert into program (name, description) values ('Biohaven Pharmaceutical Holding Company Ltd.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Boingo Wireless, Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('Microsoft Corporation', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('United Natural Foods, Inc.', 'Food Distributors');
insert into program (name, description) values ('Check Point Software Technologies Ltd.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Discovery Communications, Inc.', 'Television Services');
insert into program (name, description) values ('FARO Technologies, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Cheetah Mobile Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Cumberland Pharmaceuticals Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('SPAR Group, Inc.', 'Business Services');
insert into program (name, description) values ('Enel Chile S.A.', 'Electric Utilities: Central');
insert into program (name, description) values ('Sanchez Energy Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('Blue Buffalo Pet Products, Inc.', 'Packaged Foods');
insert into program (name, description) values ('Carpenter Technology Corporation', 'Steel/Iron Ore');
insert into program (name, description) values ('Hess Corporation', 'Integrated oil Companies');
insert into program (name, description) values ('NASDAQ TEST STOCK', 'n/a');
insert into program (name, description) values ('Grand Canyon Education, Inc.', 'Other Consumer Services');
insert into program (name, description) values ('Gartner, Inc.', 'Other Consumer Services');
insert into program (name, description) values ('Chimerix, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Walgreens Boots Alliance, Inc.', 'Medical/Nursing Services');
insert into program (name, description) values ('DTE Energy Company', 'Electric Utilities: Central');
insert into program (name, description) values ('LaSalle Hotel Properties', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Sotherly Hotels Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Redhill Biopharma Ltd.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Blackrock Municipal 2018 Term Trust', 'n/a');
insert into program (name, description) values ('American Railcar Industries, Inc.', 'Railroads');
insert into program (name, description) values ('Garrison Capital Inc.', 'n/a');
insert into program (name, description) values ('ONEOK Partners, L.P.', 'Natural Gas Distribution');
insert into program (name, description) values ('Dynegy Inc.', 'n/a');
insert into program (name, description) values ('Capitala Finance Corp.', 'n/a');
insert into program (name, description) values ('ESSA Pharma Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Accuray Incorporated', 'Medical/Dental Instruments');
insert into program (name, description) values ('The Goodyear Tire & Rubber Company', 'Automotive Aftermarket');
insert into program (name, description) values ('Hydrogenics Corporation', 'Major Chemicals');
insert into program (name, description) values ('DineEquity, Inc', 'Restaurants');
insert into program (name, description) values ('Public Storage', 'Real Estate Investment Trusts');
insert into program (name, description) values ('John Hancock Tax-Advantaged Global Shareholder Yield Fund', 'n/a');
insert into program (name, description) values ('Global Partner Acquisition Corp.', 'Hospital/Nursing Management');
insert into program (name, description) values ('Source Capital, Inc.', 'n/a');
insert into program (name, description) values ('ChromaDex Corporation', 'Specialty Chemicals');
insert into program (name, description) values ('Varian Medical Systems, Inc.', 'Biotechnology: Electromedical & Electrotherapeutic Apparatus');
insert into program (name, description) values ('John Hancock Tax Advantaged Dividend Income Fund', 'n/a');
insert into program (name, description) values ('Assured Guaranty Ltd.', 'n/a');
insert into program (name, description) values ('Vishay Precision Group, Inc.', 'Electrical Products');
insert into program (name, description) values ('Trustmark Corporation', 'Major Banks');
insert into program (name, description) values ('Hartford Financial Services Group, Inc. (The)', 'Property-Casualty Insurers');
insert into program (name, description) values ('Nuveen Core Equity Alpha Fund', 'n/a');
insert into program (name, description) values ('Energy XXI Gulf Coast, Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('Steel Partners Holdings LP', 'n/a');
insert into program (name, description) values ('MYOS RENS Technology Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Citigroup Inc.', 'Major Banks');
insert into program (name, description) values ('Industrial Services of America, Inc.', 'Industrial Specialties');
insert into program (name, description) values ('Resource Capital Corp.', 'n/a');
insert into program (name, description) values ('Advent/Claymore Enhanced Growth & Income Fund', 'n/a');
insert into program (name, description) values ('Merit Medical Systems, Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Polaris Industries Inc.', 'Industrial Specialties');
insert into program (name, description) values ('Monmouth Real Estate Investment Corporation', 'n/a');
insert into program (name, description) values ('CPI Card Group Inc.', 'Finance Companies');
insert into program (name, description) values ('Macatawa Bank Corporation', 'Major Banks');
insert into program (name, description) values ('Pacific Premier Bancorp Inc', 'Major Banks');
insert into program (name, description) values ('Aegon NV', 'Life Insurance');
insert into program (name, description) values ('ATA Inc.', 'Other Consumer Services');
insert into program (name, description) values ('Luxottica Group, S.p.A.', 'Ophthalmic Goods');
insert into program (name, description) values ('INVESCO MORTGAGE CAPITAL INC', 'n/a');
insert into program (name, description) values ('SunTrust Banks, Inc.', 'n/a');
insert into program (name, description) values ('CU Bancorp (CA)', 'Major Banks');
insert into program (name, description) values ('W.R. Berkley Corporation', 'n/a');
insert into program (name, description) values ('Arlington Asset Investment Corp', 'Finance/Investors Services');
insert into program (name, description) values ('Patrick Industries, Inc.', 'Forest Products');
insert into program (name, description) values ('Hilltop Holdings Inc.', 'Major Banks');
insert into program (name, description) values ('McGrath RentCorp', 'Diversified Commercial Services');
insert into program (name, description) values ('Bridgepoint Education, Inc.', 'Other Consumer Services');
insert into program (name, description) values ('iShares S&P Global Timber & Forestry Index Fund', 'n/a');
insert into program (name, description) values ('DoubleLine Income Solutions Fund', 'n/a');
insert into program (name, description) values ('Cenovus Energy Inc', 'Oil & Gas Production');
insert into program (name, description) values ('PHH Corp', 'Diversified Financial Services');
insert into program (name, description) values ('Naked Brand Group Inc.', 'Apparel');
insert into program (name, description) values ('Richardson Electronics, Ltd.', 'Electronic Components');
insert into program (name, description) values ('Molson Coors Brewing  Company', 'Beverages (Production/Distribution)');
insert into program (name, description) values ('CRA International,Inc.', 'Other Consumer Services');
insert into program (name, description) values ('Merus N.V.', 'Major Pharmaceuticals');
insert into program (name, description) values ('State Street Corporation', 'n/a');
insert into program (name, description) values ('TEGNA Inc.', 'Broadcasting');
insert into program (name, description) values ('Apollo Investment Corporation', 'n/a');
insert into program (name, description) values ('Prospect Capital Corporation', 'n/a');
insert into program (name, description) values ('Brookfield Asset Management Inc', 'Building operators');
insert into program (name, description) values ('icad inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Materion Corporation', 'Industrial Specialties');
insert into program (name, description) values ('ARMOUR Residential REIT, Inc.', 'n/a');
insert into program (name, description) values ('Cemtrex Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('BlackRock Long-Term Municipal Advantage Trust', 'n/a');
insert into program (name, description) values ('Bonso Electronics International, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Pharmerica Corporation', 'Medical/Nursing Services');
insert into program (name, description) values ('MyoKardia, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Sonoco Products Company', 'Containers/Packaging');
insert into program (name, description) values ('Rosetta Genomics Ltd.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Enviva Partners, LP', 'Forest Products');
insert into program (name, description) values ('Under Armour, Inc.', 'Apparel');
insert into program (name, description) values ('Hill-Rom Holdings Inc', 'Medical/Dental Instruments');
insert into program (name, description) values ('Retail Opportunity Investments Corp.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('BorgWarner Inc.', 'Auto Parts:O.E.M.');
insert into program (name, description) values ('Aspen Insurance Holdings Limited', 'n/a');
insert into program (name, description) values ('Genesco Inc.', 'Clothing/Shoe/Accessory Stores');
insert into program (name, description) values ('Berry Global Group, Inc.', 'Plastic Products');
insert into program (name, description) values ('Novan, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('PowerShares Global Water Portfolio', 'n/a');
insert into program (name, description) values ('Wix.com Ltd.', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('Daktronics, Inc.', 'Miscellaneous manufacturing industries');
insert into program (name, description) values ('Colony NorthStar, Inc.', 'n/a');
insert into program (name, description) values ('Threshold Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Voyager Therapeutics, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('ESCO Technologies Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('Coupa Software Incorporated', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Gabelli Utility Trust (The)', 'n/a');
insert into program (name, description) values ('Zynga Inc.', 'EDP Services');
insert into program (name, description) values ('LGI Homes, Inc.', 'Homebuilding');
insert into program (name, description) values ('Depomed, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Global Indemnity Limited', 'Property-Casualty Insurers');
insert into program (name, description) values ('First Trust NASDAQ Clean Edge Smart Grid Infrastructure Index ', 'n/a');
insert into program (name, description) values ('Norwegian Cruise Line Holdings Ltd.', 'Marine Transportation');
insert into program (name, description) values ('Jack In The Box Inc.', 'Restaurants');
insert into program (name, description) values ('Bank of America Corporation', 'n/a');
insert into program (name, description) values ('Quorum Health Corporation', 'Hospital/Nursing Management');
insert into program (name, description) values ('Assured Guaranty Ltd.', 'n/a');
insert into program (name, description) values ('OFS Capital Corporation', 'n/a');
insert into program (name, description) values ('Naked Brand Group Inc.', 'Apparel');
insert into program (name, description) values ('BB&T Corporation', 'n/a');
insert into program (name, description) values ('First South Bancorp Inc', 'Major Banks');
insert into program (name, description) values ('Sunstone Hotel Investors, Inc.', 'n/a');
insert into program (name, description) values ('Legg Mason BW Global Income Opportunities Fund Inc.', 'n/a');
insert into program (name, description) values ('Martin Midstream Partners L.P.', 'Oil Refining/Marketing');
insert into program (name, description) values ('Arbor Realty Trust', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Capital One Financial Corporation', 'n/a');
insert into program (name, description) values ('FuelCell Energy, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('First Industrial Realty Trust, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Royal Gold, Inc.', 'Precious Metals');
insert into program (name, description) values ('Royal Bank Scotland plc (The)', 'n/a');
insert into program (name, description) values ('Goldman Sachs BDC, Inc.', 'n/a');
insert into program (name, description) values ('Spirit Aerosystems Holdings, Inc.', 'Military/Government/Technical');
insert into program (name, description) values ('Blackrock MuniHoldings California Quality Fund,  Inc.', 'n/a');
insert into program (name, description) values ('Essendant Inc.', 'Paper');
insert into program (name, description) values ('TCF Financial Corporation', 'n/a');
insert into program (name, description) values ('QuickLogic Corporation', 'Semiconductors');
insert into program (name, description) values ('Fortress Biotech, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Berkshire Hathaway Inc.', 'n/a');
insert into program (name, description) values ('eHi Car Services Limited', 'Rental/Leasing Companies');
insert into program (name, description) values ('Portland General Electric Company', 'Electric Utilities: Central');
insert into program (name, description) values ('Preferred Bank', 'n/a');
insert into program (name, description) values ('Phoenix New Media Limited', 'Broadcasting');
insert into program (name, description) values ('AquaBounty Technologies, Inc.', 'n/a');
insert into program (name, description) values ('Unit Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('Gramercy Property Trust Inc.', 'n/a');
insert into program (name, description) values ('iShares FTSE EPRA/NAREIT Europe Index Fund', 'n/a');
insert into program (name, description) values ('Altisource Residential Corporation', 'Real Estate');
insert into program (name, description) values ('First Trust International IPO ETF', 'n/a');
insert into program (name, description) values ('ChipMOS TECHNOLOGIES INC.', 'Semiconductors');
insert into program (name, description) values ('Perma-Pipe International Holdings, Inc.', 'Pollution Control Equipment');
insert into program (name, description) values ('Ivy NextShares', 'n/a');
insert into program (name, description) values ('Quaker Chemical Corporation', 'Major Chemicals');
insert into program (name, description) values ('Public Storage', 'n/a');
insert into program (name, description) values ('TIER REIT, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Molina Healthcare Inc', 'Medical Specialities');
insert into program (name, description) values ('VictoryShares Developed Enhanced Volatility Wtd ETF', 'n/a');
insert into program (name, description) values ('Swift Transportation Company', 'Trucking Freight/Courier Services');
insert into program (name, description) values ('CareTrust REIT, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('The Andersons, Inc.', 'Farming/Seeds/Milling');
insert into program (name, description) values ('athenahealth, Inc.', 'Business Services');
insert into program (name, description) values ('CenterPoint Energy, Inc.', 'Electric Utilities: Central');
insert into program (name, description) values ('Exact Sciences Corporation', 'Biotechnology: Commercial Physical & Biological Resarch');
insert into program (name, description) values ('Corvus Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Marriot Vacations Worldwide Corporation', 'Real Estate');
insert into program (name, description) values ('Andina Acquisition Corp. II', 'Business Services');
insert into program (name, description) values ('Student Transportation Inc', 'Other Transportation');
insert into program (name, description) values ('Wells Fargo & Company', 'n/a');
insert into program (name, description) values ('Jagged Peak Energy Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('Bioblast Pharma Ltd.', 'Major Pharmaceuticals');
insert into program (name, description) values ('John Hancock Preferred Income Fund', 'n/a');
insert into program (name, description) values ('Achillion Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Ocular Therapeutix, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('IBERIABANK Corporation', 'Major Banks');
insert into program (name, description) values ('Public Storage', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Lincoln National Corporation', 'Life Insurance');
insert into program (name, description) values ('EXFO Inc', 'Electrical Products');
insert into program (name, description) values ('Ooma, Inc.', 'EDP Services');
insert into program (name, description) values ('CACI International, Inc.', 'EDP Services');
insert into program (name, description) values ('Vanguard Total International Bond ETF', 'n/a');
insert into program (name, description) values ('Parker-Hannifin Corporation', 'Metal Fabrications');
insert into program (name, description) values ('Enova International, Inc.', 'Finance: Consumer Services');
insert into program (name, description) values ('MTS Systems Corporation', 'Industrial Machinery/Components');
insert into program (name, description) values ('CVD Equipment Corporation', 'Industrial Machinery/Components');
insert into program (name, description) values ('Emergent Biosolutions, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Group 1 Automotive, Inc.', 'Automotive Aftermarket');
insert into program (name, description) values ('Insulet Corporation', 'Medical/Dental Instruments');
insert into program (name, description) values ('Seritage Growth Properties', 'Real Estate');
insert into program (name, description) values ('Under Armour, Inc.', 'Apparel');
insert into program (name, description) values ('MRV Communications, Inc.', 'Semiconductors');
insert into program (name, description) values ('Wells Fargo & Company', 'n/a');
insert into program (name, description) values ('PowerShares Global Water Portfolio', 'n/a');
insert into program (name, description) values ('Wells Fargo & Company', 'n/a');
insert into program (name, description) values ('WESCO International, Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('First United Corporation', 'Major Banks');
insert into program (name, description) values ('Yelp Inc.', 'Other Consumer Services');
insert into program (name, description) values ('M&T Bank Corporation', 'n/a');
insert into program (name, description) values ('Apple Inc.', 'Computer Manufacturing');
insert into program (name, description) values ('Dynasil Corporation of America', 'Industrial Machinery/Components');
insert into program (name, description) values ('Gladstone Land Corporation', 'Real Estate Investment Trusts');
insert into program (name, description) values ('C', 'Oilfield Services/Equipment');
insert into program (name, description) values ('Pure Cycle Corporation', 'Water Supply');
insert into program (name, description) values ('PFSweb, Inc.', 'Business Services');
insert into program (name, description) values ('Royce Value Trust, Inc.', 'n/a');
insert into program (name, description) values ('Paycom Software, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Morgan Stanley', 'n/a');
insert into program (name, description) values ('STORE Capital Corporation', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Vanguard Intermediate-Term Corporate Bond ETF', 'n/a');
insert into program (name, description) values ('Nuveen Build America Bond Opportunity Fund', 'n/a');
insert into program (name, description) values ('LCI Industries ', 'n/a');
insert into program (name, description) values ('Seaspan Corporation', 'n/a');
insert into program (name, description) values ('Sabra Healthcare REIT, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Dynegy Inc.', 'Electric Utilities: Central');
insert into program (name, description) values ('Altria Group', 'Farming/Seeds/Milling');
insert into program (name, description) values ('Astoria Financial Corporation', 'n/a');
insert into program (name, description) values ('Gabelli NextShares Trust', 'n/a');
insert into program (name, description) values ('InterDigital, Inc.', 'Multi-Sector Companies');
insert into program (name, description) values ('New Relic, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Natural Grocers by Vitamin Cottage, Inc.', 'Food Chains');
insert into program (name, description) values ('Eagle Point Credit Company Inc.', 'n/a');
insert into program (name, description) values ('Extraction Oil & Gas, Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('Westar Energy, Inc.', 'Power Generation');
insert into program (name, description) values ('Patterson-UTI Energy, Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('New York Mortgage Trust, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Tiptree Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('The Cushing MLP Total Return Fund', 'n/a');
insert into program (name, description) values ('National Retail Properties', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Texas Pacific Land Trust', 'Oil & Gas Production');
insert into program (name, description) values ('Prestige Brand Holdings, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('First Trust United Kingdom AlphaDEX Fund', 'n/a');
insert into program (name, description) values ('Real Industry, Inc. ', 'Telecommunications Equipment');
insert into program (name, description) values ('Oxbridge Re Holdings Limited', 'Property-Casualty Insurers');
insert into program (name, description) values ('Xerium Technologies, Inc.', 'Textiles');
insert into program (name, description) values ('Synthetic Fixed-Income Securities, Inc.', 'Finance: Consumer Services');
insert into program (name, description) values ('Canon, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Citigroup Inc.', 'Major Banks');
insert into program (name, description) values ('Brady Corporation', 'Miscellaneous manufacturing industries');
insert into program (name, description) values ('Aircastle Limited', 'Diversified Commercial Services');
insert into program (name, description) values ('Alliance National Municipal Income Fund Inc', 'n/a');
insert into program (name, description) values ('Fairmount Santrol Holdings Inc.', 'Mining & Quarrying of Nonmetallic Minerals (No Fuels)');
insert into program (name, description) values ('Twitter, Inc.', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('Therapix Biosciences Ltd.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Dillard''s, Inc.', 'Department/Specialty Retail Stores');
insert into program (name, description) values ('iPath US Treasury 2-year Bull ETN', 'Commercial Banks');
insert into program (name, description) values ('Huron Consulting Group Inc.', 'Professional Services');
insert into program (name, description) values ('Calpine Corporation', 'Electric Utilities: Central');
insert into program (name, description) values ('Imperva, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Corporate Office Properties Trust', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Dillard''s, Inc.', 'Department/Specialty Retail Stores');
insert into program (name, description) values ('Brunswick Corporation', 'Industrial Machinery/Components');
insert into program (name, description) values ('Brainstorm Cell Therapeutics Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Alliance National Municipal Income Fund Inc', 'n/a');
insert into program (name, description) values ('Kirkland''s, Inc.', 'Other Specialty Stores');
insert into program (name, description) values ('Extra Space Storage Inc', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Applied DNA Sciences Inc', 'Other Consumer Services');
insert into program (name, description) values ('Urban One, Inc. ', 'Broadcasting');
insert into program (name, description) values ('HMN Financial, Inc.', 'Savings Institutions');
insert into program (name, description) values ('CRISPR Therapeutics AG', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Neogen Corporation', 'Biotechnology: In Vitro & In Vivo Diagnostic Substances');
insert into program (name, description) values ('Senomyx, Inc.', 'Biotechnology: Commercial Physical & Biological Resarch');
insert into program (name, description) values ('Associated Banc-Corp', 'Major Banks');
insert into program (name, description) values ('First Financial Bancorp.', 'Major Banks');
insert into program (name, description) values ('Sumitomo Mitsui Financial Group Inc', 'Commercial Banks');
insert into program (name, description) values ('Del Taco Restaurants, Inc.', 'Restaurants');
insert into program (name, description) values ('Banco Santander, S.A.', 'n/a');
insert into program (name, description) values ('Endocyte, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('VEON Ltd.', 'Telecommunications Equipment');
insert into program (name, description) values ('Pier 1 Imports, Inc.', 'Home Furnishings');
insert into program (name, description) values ('Adams Natural Resources Fund, Inc.', 'n/a');
insert into program (name, description) values ('Aimmune Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Columbia Seligman Premium Technology Growth Fund, Inc', 'n/a');
insert into program (name, description) values ('PIMCO Commercial Mortgage Securities Trust, Inc.', 'n/a');
insert into program (name, description) values ('Sanmina Corporation', 'Electrical Products');
insert into program (name, description) values ('M/I Homes, Inc.', 'n/a');
insert into program (name, description) values ('Ship Finance International Limited', 'Marine Transportation');
insert into program (name, description) values ('NVR, Inc.', 'Homebuilding');
insert into program (name, description) values ('Neuralstem, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('CorEnergy Infrastructure Trust, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('GATX Corporation', 'Transportation Services');
insert into program (name, description) values ('Brookfield Infrastructure Partners LP', 'Marine Transportation');
insert into program (name, description) values ('Boston Properties, Inc.', 'n/a');
insert into program (name, description) values ('Blackrock MuniHoldings Investment Quality Fund', 'n/a');
insert into program (name, description) values ('Accenture plc', 'Business Services');
insert into program (name, description) values ('Popular, Inc.', 'Major Banks');
insert into program (name, description) values ('Medigus Ltd.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Differential Brands Group Inc.', 'Apparel');
insert into program (name, description) values ('Evolent Health, Inc', 'Other Consumer Services');
insert into program (name, description) values ('HollyFrontier Corporation', 'Integrated oil Companies');
insert into program (name, description) values ('Belden Inc', 'Telecommunications Equipment');
insert into program (name, description) values ('Colonial Intermediate High Income Fund', 'n/a');
insert into program (name, description) values ('Blue Capital Reinsurance Holdings Ltd.', 'Property-Casualty Insurers');
insert into program (name, description) values ('CorEnergy Infrastructure Trust, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Aerie Pharmaceuticals, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Transdigm Group Incorporated', 'Military/Government/Technical');
insert into program (name, description) values ('USA Technologies, Inc.', 'Office Equipment/Supplies/Services');
insert into program (name, description) values ('Moxian, Inc.', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('Dynasil Corporation of America', 'Industrial Machinery/Components');
insert into program (name, description) values ('Heritage-Crystal Clean, Inc.', 'Miscellaneous');
insert into program (name, description) values ('Turquoise Hill Resources Ltd.', 'Precious Metals');
insert into program (name, description) values ('Steel Dynamics, Inc.', 'Steel/Iron Ore');
insert into program (name, description) values ('Prologis, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('TerraVia Holdings, Inc.', 'Major Chemicals');
insert into program (name, description) values ('OpGen, Inc.', 'Medical Specialities');
insert into program (name, description) values ('Wintrust Financial Corporation', 'Major Banks');
insert into program (name, description) values ('Gaia, Inc.', 'Movies/Entertainment');
insert into program (name, description) values ('United Therapeutics Corporation', 'Major Pharmaceuticals');
insert into program (name, description) values ('Global Partner Acquisition Corp.', 'Hospital/Nursing Management');
insert into program (name, description) values ('MetLife, Inc.', 'n/a');
insert into program (name, description) values ('AdvanSix Inc.', 'Major Chemicals');
insert into program (name, description) values ('Heska Corporation', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Silgan Holdings Inc.', 'Containers/Packaging');
insert into program (name, description) values ('BB&T Corporation', 'n/a');
insert into program (name, description) values ('Center Coast MLP & Infrastructure Fund', 'n/a');
insert into program (name, description) values ('Apollo Senior Floating Rate Fund Inc.', 'n/a');
insert into program (name, description) values ('One Liberty Properties, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Nuveen Build America Bond Opportunity Fund', 'n/a');
insert into program (name, description) values ('Gabelli Equity Trust, Inc. (The)', 'n/a');
insert into program (name, description) values ('Xactly Corporation', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('American National Bankshares, Inc.', 'Major Banks');
insert into program (name, description) values ('United Dominion Realty Trust, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Arcadia Biosciences, Inc.', 'Agricultural Chemicals');
insert into program (name, description) values ('Cracker Barrel Old Country Store, Inc.', 'Restaurants');
insert into program (name, description) values ('First Trust China AlphaDEX Fund', 'n/a');
insert into program (name, description) values ('Sharps Compliance Corp', 'Environmental Services');
insert into program (name, description) values ('Magyar Bancorp, Inc.', 'Savings Institutions');
insert into program (name, description) values ('Ohr Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('People''s United Financial, Inc.', 'Savings Institutions');
insert into program (name, description) values ('Advent Claymore Convertible Securities and Income Fund II', 'n/a');
insert into program (name, description) values ('RLJ Lodging Trust', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Streamline Health Solutions, Inc.', 'EDP Services');
insert into program (name, description) values ('First US Bancshares, Inc.', 'Major Banks');
insert into program (name, description) values ('Nuveen Senior Income Fund', 'n/a');
insert into program (name, description) values ('Benitec Biopharma Limited', 'Major Pharmaceuticals');
insert into program (name, description) values ('SkyWest, Inc.', 'Air Freight/Delivery Services');
insert into program (name, description) values ('Calamos Global Dynamic Income Fund', 'n/a');
insert into program (name, description) values ('Pimco Corporate & Income Opportunity Fund', 'n/a');
insert into program (name, description) values ('Getty Realty Corporation', 'Real Estate');
insert into program (name, description) values ('Scorpio Tankers Inc.', 'Marine Transportation');
insert into program (name, description) values ('PIMCO New York Municipal Income Fund III', 'n/a');
insert into program (name, description) values ('Dermira, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Universal Logistics Holdings, Inc.', 'Trucking Freight/Courier Services');
insert into program (name, description) values ('Avista Healthcare Public Acquisition Corp.', 'Business Services');
insert into program (name, description) values ('San Juan Basin Royalty Trust', 'Oil & Gas Production');
insert into program (name, description) values ('Digiliti Money Group, Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('Ferroglobe PLC', 'Metal Fabrications');
insert into program (name, description) values ('ClearBridge Dividend Strategy ESG ETF', 'n/a');
insert into program (name, description) values ('KCAP Financial, Inc.', 'n/a');
insert into program (name, description) values ('Fenix Parts, Inc.', 'Motor Vehicles');
insert into program (name, description) values ('SVB Financial Group', 'Major Banks');
insert into program (name, description) values ('Tidewater Inc.', 'Marine Transportation');
insert into program (name, description) values ('Nutanix, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('WisdomTree Germany Hedged Equity Fund', 'n/a');
insert into program (name, description) values ('iShares Core MSCI Total International Stock ETF', 'n/a');
insert into program (name, description) values ('FactSet Research Systems Inc.', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('ICU Medical, Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('Superior Energy Services, Inc.', 'Oilfield Services/Equipment');
insert into program (name, description) values ('Vericel Corporation', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('CommScope Holding Company, Inc.', 'Radio And Television Broadcasting And Communications Equipment');
insert into program (name, description) values ('Westamerica Bancorporation', 'Major Banks');
insert into program (name, description) values ('Ovid Therapeutics Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Quality Care Properties, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Principal Price Setters Index ETF', 'n/a');
insert into program (name, description) values ('Mid-America Apartment Communities, Inc.', 'n/a');
insert into program (name, description) values ('Genesee & Wyoming, Inc.', 'Railroads');
insert into program (name, description) values ('Ophthotech Corporation', 'Major Pharmaceuticals');
insert into program (name, description) values ('First Financial Bancorp.', 'Major Banks');
insert into program (name, description) values ('Norwood Financial Corp.', 'Major Banks');
insert into program (name, description) values ('Provident Financial Holdings, Inc.', 'Savings Institutions');
insert into program (name, description) values ('CarMax Inc', 'Automotive Aftermarket');
insert into program (name, description) values ('Summer Infant, Inc.', 'Miscellaneous manufacturing industries');
insert into program (name, description) values ('Gabelli Dividend', 'n/a');
insert into program (name, description) values ('RenaissanceRe Holdings Ltd.', 'n/a');
insert into program (name, description) values ('Guggenheim Strategic Opportunities Fund', 'n/a');
insert into program (name, description) values ('Acuity Brands Inc', 'Building Products');
insert into program (name, description) values ('ProShares UltraPro Short QQQ', 'n/a');
insert into program (name, description) values ('TOP Ships Inc.', 'Marine Transportation');
insert into program (name, description) values ('Inovalon Holdings, Inc.', 'EDP Services');
insert into program (name, description) values ('Cellect Biotechnology Ltd.', 'n/a');
insert into program (name, description) values ('FinTech Acquisition Corp. II', 'Business Services');
insert into program (name, description) values ('Fiesta Restaurant Group, Inc.', 'Restaurants');
insert into program (name, description) values ('Johnson Outdoors Inc.', 'Recreational Products/Toys');
insert into program (name, description) values ('Zions Bancorporation', 'Major Banks');
insert into program (name, description) values ('Diamond Offshore Drilling, Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('Ross Stores, Inc.', 'Clothing/Shoe/Accessory Stores');
insert into program (name, description) values ('PAR Technology Corporation', 'Office Equipment/Supplies/Services');
insert into program (name, description) values ('Eaton Vance Tax-Advantage Global Dividend Opp', 'n/a');
insert into program (name, description) values ('Sibanye Gold Limited', 'Precious Metals');
insert into program (name, description) values ('Sensata Technologies Holding N.V.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Timberland Bancorp, Inc.', 'Banks');
insert into program (name, description) values ('MGM Resorts International', 'Hotels/Resorts');
insert into program (name, description) values ('Exelon Corporation', 'Power Generation');
insert into program (name, description) values ('Ulta Beauty, Inc.', 'Other Specialty Stores');
insert into program (name, description) values ('Horizon Technology Finance Corporation', 'n/a');
insert into program (name, description) values ('Morgan Stanley', 'n/a');
insert into program (name, description) values ('My Size, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Multi-Color Corporation', 'Publishing');
insert into program (name, description) values ('Nicolet Bankshares Inc.', 'Major Banks');
insert into program (name, description) values ('KKR & Co. L.P.', 'n/a');
insert into program (name, description) values ('SPX FLOW, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Forum Merger Corporation', 'Business Services');
insert into program (name, description) values ('ICC Holdings, Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('WisdomTree Strategic Corporate Bond Fund', 'n/a');
insert into program (name, description) values ('United Community Banks, Inc.', 'Major Banks');
insert into program (name, description) values ('Veritiv Corporation', 'Paper');
insert into program (name, description) values ('Vanguard Russell 1000 Value ETF', 'n/a');
insert into program (name, description) values ('Intercontinental Exchange Inc.', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('MMA Capital Management, LLC', 'Real Estate');
insert into program (name, description) values ('Cotiviti Holdings, Inc.', 'Business Services');
insert into program (name, description) values ('The Medicines Company', 'Major Pharmaceuticals');
insert into program (name, description) values ('Tocagen Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Saratoga Investment Corp', 'n/a');
insert into program (name, description) values ('Ally Financial Inc.', 'n/a');
insert into program (name, description) values ('8point3 Energy Partners LP', 'Electric Utilities: Central');
insert into program (name, description) values ('CST Brands, Inc.', 'Automotive Aftermarket');
insert into program (name, description) values ('RLJ Lodging Trust', 'Real Estate Investment Trusts');
insert into program (name, description) values ('TPI Composites, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Roper Technologies, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Newtek Business Services Corp.', 'n/a');
insert into program (name, description) values ('Destination Maternity Corporation', 'Clothing/Shoe/Accessory Stores');
insert into program (name, description) values ('Pioneer Floating Rate Trust', 'n/a');
insert into program (name, description) values ('Banc of California, Inc.', 'Major Banks');
insert into program (name, description) values ('Jabil Inc.', 'Electrical Products');
insert into program (name, description) values ('Investors Title Company', 'Specialty Insurers');
insert into program (name, description) values ('Atlantic Capital Bancshares, Inc.', 'Major Banks');
insert into program (name, description) values ('Miragen Therapeutics, Inc.', 'Medical Specialities');
insert into program (name, description) values ('Morningstar, Inc.', 'Investment Managers');
insert into program (name, description) values ('OpGen, Inc.', 'Medical Specialities');
insert into program (name, description) values ('Golar LNG Limited', 'Marine Transportation');
insert into program (name, description) values ('Texas Roadhouse, Inc.', 'Restaurants');
insert into program (name, description) values ('Wesco Aircraft Holdings, Inc.', 'Wholesale Distributors');
insert into program (name, description) values ('S&W Seed Company', 'Farming/Seeds/Milling');
insert into program (name, description) values ('Countrywide Financial Corporation', 'n/a');
insert into program (name, description) values ('Digital Turbine, Inc.', 'Multi-Sector Companies');
insert into program (name, description) values ('Vantiv, Inc.', 'Business Services');
insert into program (name, description) values ('ProPetro Holding Corp.', 'Oilfield Services/Equipment');
insert into program (name, description) values ('Cross Timbers Royalty Trust', 'Oil & Gas Production');
insert into program (name, description) values ('Sage Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Sussex Bancorp', 'Major Banks');
insert into program (name, description) values ('Clearfield, Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('Qwest Corporation', 'Telecommunications Equipment');
insert into program (name, description) values ('Numerex Corp.', 'Telecommunications Equipment');
insert into program (name, description) values ('DigitalGlobe, Inc', 'Telecommunications Equipment');
insert into program (name, description) values ('ASML Holding N.V.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Aegon NV', 'Life Insurance');
insert into program (name, description) values ('Vantage Energy Acquisition Corp.', 'Business Services');
insert into program (name, description) values ('Pimco New York Municipal Income Fund II', 'n/a');
insert into program (name, description) values ('Guggenheim Credit Allocation Fund', 'n/a');
insert into program (name, description) values ('Mercantile Bank Corporation', 'Major Banks');
insert into program (name, description) values ('Nuveen Quality Preferred Income Fund 2', 'n/a');
insert into program (name, description) values ('SMTC Corporation', 'Electrical Products');
insert into program (name, description) values ('China HGS Real Estate, Inc.', 'Real Estate');
insert into program (name, description) values ('Estee Lauder Companies, Inc. (The)', 'Package Goods/Cosmetics');
insert into program (name, description) values ('Iconix Brand Group, Inc.', 'Shoe Manufacturing');
insert into program (name, description) values ('SandRidge Mississippian Trust II', 'Oil & Gas Production');
insert into program (name, description) values ('Hudson Technologies, Inc.', 'Industrial Specialties');
insert into program (name, description) values ('Key Technology, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Stepan Company', 'Package Goods/Cosmetics');
insert into program (name, description) values ('County Bancorp, Inc.', 'Major Banks');
insert into program (name, description) values ('Compass Diversified Holdings', 'Home Furnishings');
insert into program (name, description) values ('Duff & Phelps Utilities Income, Inc.', 'n/a');
insert into program (name, description) values ('Kite Pharma, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Bob Evans Farms, Inc.', 'Restaurants');
insert into program (name, description) values ('Ark Restaurants Corp.', 'Restaurants');
insert into program (name, description) values ('Luby''s, Inc.', 'Restaurants');
insert into program (name, description) values ('Textron Inc.', 'Aerospace');
insert into program (name, description) values ('American Financial Group, Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Legg Mason, Inc.', 'Investment Managers');
insert into program (name, description) values ('Kilroy Realty Corporation', 'n/a');
insert into program (name, description) values ('XO Group, Inc.', 'Other Consumer Services');
insert into program (name, description) values ('BB&T Corporation', 'Major Banks');
insert into program (name, description) values ('Delek US Holdings, Inc.', 'Integrated oil Companies');
insert into program (name, description) values ('DENTSPLY SIRONA Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('MSG Networks Inc.', 'Services-Misc. Amusement & Recreation');
insert into program (name, description) values ('VALE S.A.', 'n/a');
insert into program (name, description) values ('Frontline Ltd.', 'Marine Transportation');
insert into program (name, description) values ('Mednax, Inc', 'Hospital/Nursing Management');
insert into program (name, description) values ('Eaton Vance High Income 2021 Target Term Trust', 'n/a');
insert into program (name, description) values ('MFS Municipal Income Trust', 'n/a');
insert into program (name, description) values ('Gabelli Multi-Media Trust Inc. (The)', 'n/a');
insert into program (name, description) values ('Primoris Services Corporation', 'Water Supply');
insert into program (name, description) values ('Provident Bancorp, Inc.', 'Savings Institutions');
insert into program (name, description) values ('Ion Geophysical Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('Union Bankshares Corporation', 'Major Banks');
insert into program (name, description) values ('KKR Income Opportunities Fund', 'n/a');
insert into program (name, description) values ('CTI BioPharma Corp.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Nano Dimension Ltd.', 'Electrical Products');
insert into program (name, description) values ('Neenah Paper, Inc.', 'Paper');
insert into program (name, description) values ('RealPage, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Peoples Financial Corporation', 'Major Banks');
insert into program (name, description) values ('Brandywine Realty Trust', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Viking Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('The GDL Fund', 'n/a');
insert into program (name, description) values ('CyrusOne Inc', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Putnam Managed Municipal Income Trust', 'n/a');
insert into program (name, description) values ('Spark Therapeutics, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Dunkin'' Brands Group, Inc.', 'Restaurants');
insert into program (name, description) values ('Harvest Capital Credit Corporation', 'n/a');
insert into program (name, description) values ('Presidio, Inc.', 'Retail: Computer Software & Peripheral Equipment');
insert into program (name, description) values ('Builders FirstSource, Inc.', 'RETAIL: Building Materials');
insert into program (name, description) values ('Henry Schein, Inc.', 'Medical Specialities');
insert into program (name, description) values ('NewMarket Corporation', 'Major Chemicals');
insert into program (name, description) values ('Accenture plc', 'Business Services');
insert into program (name, description) values ('SORL Auto Parts, Inc.', 'Auto Parts:O.E.M.');
insert into program (name, description) values ('J P Morgan Chase & Co', 'n/a');
insert into program (name, description) values ('First Trust Senior Floating Rate Income Fund II', 'n/a');
insert into program (name, description) values ('Douglas Dynamics, Inc.', 'Construction/Ag Equipment/Trucks');
insert into program (name, description) values ('Qwest Corporation', 'Telecommunications Equipment');
insert into program (name, description) values ('Southern Company (The)', 'Electric Utilities: Central');
insert into program (name, description) values ('Enterprise Financial Services Corporation', 'Major Banks');
insert into program (name, description) values ('Natural Alternatives International, Inc.', 'Specialty Chemicals');
insert into program (name, description) values ('Asta Funding, Inc.', 'Finance Companies');
insert into program (name, description) values ('NetApp, Inc.', 'Electronic Components');
insert into program (name, description) values ('Jason Industries, Inc.', 'Miscellaneous manufacturing industries');
insert into program (name, description) values ('Universal Technical Institute Inc', 'Other Consumer Services');
insert into program (name, description) values ('TiGenix', 'Major Pharmaceuticals');
insert into program (name, description) values ('Elbit Imaging Ltd.', 'Building operators');
insert into program (name, description) values ('Asia Pacific Wire & Cable Corporation Limited', 'Telecommunications Equipment');
insert into program (name, description) values ('Dean Foods Company', 'Packaged Foods');
insert into program (name, description) values ('Mistras Group Inc', 'Military/Government/Technical');
insert into program (name, description) values ('uniQure N.V.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Live Nation Entertainment, Inc.', 'Services-Misc. Amusement & Recreation');
insert into program (name, description) values ('CGG', 'Oil & Gas Production');
insert into program (name, description) values ('PulteGroup, Inc.', 'Homebuilding');
insert into program (name, description) values ('Acacia Research Corporation', 'Multi-Sector Companies');
insert into program (name, description) values ('Discovery Communications, Inc.', 'Television Services');
insert into program (name, description) values ('American Woodmark Corporation', 'Forest Products');
insert into program (name, description) values ('Avon Products, Inc.', 'Package Goods/Cosmetics');
insert into program (name, description) values ('GrubHub Inc.', 'Business Services');
insert into program (name, description) values ('Eaton Vance Senior Floating-Rate Fund', 'n/a');
insert into program (name, description) values ('BancFirst Corporation', 'Major Banks');
insert into program (name, description) values ('T-Mobile US, Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('South State Corporation', 'Major Banks');
insert into program (name, description) values ('Blackrock MuniHoldings Fund, Inc.', 'n/a');
insert into program (name, description) values ('First Trust Multi Cap Growth AlphaDEX Fund', 'n/a');
insert into program (name, description) values ('Fossil Group, Inc.', 'Consumer Specialties');
insert into program (name, description) values ('Haemonetics Corporation', 'Medical/Dental Instruments');
insert into program (name, description) values ('Donegal Group, Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Capital Bank Financial Corp.', 'Major Banks');
insert into program (name, description) values ('John Hancock Hedged Equity & Income Fund', 'n/a');
insert into program (name, description) values ('VSE Corporation', 'Military/Government/Technical');
insert into program (name, description) values ('Tetra Technologies, Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('Japan Smaller Capitalization Fund Inc', 'n/a');
insert into program (name, description) values ('Huntington Bancshares Incorporated', 'Major Banks');
insert into program (name, description) values ('Biohaven Pharmaceutical Holding Company Ltd.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Gaming Partners International Corporation', 'Recreational Products/Toys');
insert into program (name, description) values ('Penn West Petroleum Ltd', 'Oil & Gas Production');
insert into program (name, description) values ('Franklin Covey Company', 'Other Consumer Services');
insert into program (name, description) values ('United States Lime & Minerals, Inc.', 'Mining & Quarrying of Nonmetallic Minerals (No Fuels)');
insert into program (name, description) values ('Jernigan Capital, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Columbia Banking System, Inc.', 'Major Banks');
insert into program (name, description) values ('JM Global Holding Company', 'Business Services');
insert into program (name, description) values ('Pimco Income Opportunity Fund', 'n/a');
insert into program (name, description) values ('XG Technology, Inc', 'Telecommunications Equipment');
insert into program (name, description) values ('ChinaNet Online Holdings, Inc.', 'Computer Software: Programming, Data Processing');
insert into program (name, description) values ('The Charles Schwab Corporation', 'n/a');
insert into program (name, description) values ('Blackrock MuniYield Michigan Quality Fund, Inc.', 'n/a');
insert into program (name, description) values ('Hanesbrands Inc.', 'Clothing/Shoe/Accessory Stores');
insert into program (name, description) values ('First Trust Strategic Income ETF', 'n/a');
insert into program (name, description) values ('IQ Chaikin U.S. Small Cap ETF', 'n/a');
insert into program (name, description) values ('Apple Inc.', 'Computer Manufacturing');
insert into program (name, description) values ('M I Acquisitions, Inc.', 'Business Services');
insert into program (name, description) values ('Sempra Energy', 'Natural Gas Distribution');
insert into program (name, description) values ('Hospitality Properties Trust', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Quality Care Properties, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Fluor Corporation', 'Military/Government/Technical');
insert into program (name, description) values ('Arbor Realty Trust', 'n/a');
insert into program (name, description) values ('Fox Factory Holding Corp.', 'Motor Vehicles');
insert into program (name, description) values ('iShares GNMA Bond ETF', 'n/a');
insert into program (name, description) values ('RH', 'Other Specialty Stores');
insert into program (name, description) values ('Gulf Island Fabrication, Inc.', 'Metal Fabrications');
insert into program (name, description) values ('bebe stores, inc.', 'Apparel');
insert into program (name, description) values ('Western Refining Logistics, LP', 'Natural Gas Distribution');
insert into program (name, description) values ('Akoustis Technologies, Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('Darden Restaurants, Inc.', 'Restaurants');
insert into program (name, description) values ('Simmons First National Corporation', 'Major Banks');
insert into program (name, description) values ('Gibraltar Industries, Inc.', 'Steel/Iron Ore');
insert into program (name, description) values ('BlackRock Science and Technology Trust', 'n/a');
insert into program (name, description) values ('Gabelli Equity Trust, Inc. (The)', 'n/a');
insert into program (name, description) values ('Eagle Materials Inc', 'Building Materials');
insert into program (name, description) values ('Xcel Brands, Inc', 'Multi-Sector Companies');
insert into program (name, description) values ('Terreno Realty Corporation', 'n/a');
insert into program (name, description) values ('Fidelity Nasdaq Composite Index Tracking Stock', 'n/a');
insert into program (name, description) values ('Liberty Media Corporation', 'Broadcasting');
insert into program (name, description) values ('CIM Commercial Trust Corporation', 'Real Estate Investment Trusts');
insert into program (name, description) values ('NAPCO Security Technologies, Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('Terreno Realty Corporation', 'Real Estate');
insert into program (name, description) values ('UnitedHealth Group Incorporated', 'Medical Specialities');
insert into program (name, description) values ('ENDRA Life Sciences Inc.', 'n/a');
insert into program (name, description) values ('Asure Software Inc', 'EDP Services');
insert into program (name, description) values ('Fuling Global Inc.', 'Plastic Products');
insert into program (name, description) values ('Whole Foods Market, Inc.', 'Food Chains');
insert into program (name, description) values ('AU Optronics Corp', 'Semiconductors');
insert into program (name, description) values ('Tuniu Corporation', 'Transportation Services');
insert into program (name, description) values ('HV Bancorp, Inc.', 'Major Banks');
insert into program (name, description) values ('Unit Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('Ivy NextShares', 'n/a');
insert into program (name, description) values ('Xencor, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Tableau Software, Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Mid-America Apartment Communities, Inc.', 'n/a');
insert into program (name, description) values ('Jensyn Acquistion Corp.', 'Business Services');
insert into program (name, description) values ('TriNet Group, Inc.', 'Business Services');
insert into program (name, description) values ('Liberty Interactive Corporation', 'Catalog/Specialty Distribution');
insert into program (name, description) values ('Mastercard Incorporated', 'Business Services');
insert into program (name, description) values ('Chesapeake Energy Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('Astoria Financial Corporation', 'Savings Institutions');
insert into program (name, description) values ('Concert Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Rennova Health, Inc.', 'Precision Instruments');
insert into program (name, description) values ('One Horizon Group, Inc.', 'Telecommunications Equipment');
insert into program (name, description) values ('First Trust Dynamic Europe Equity Income Fund', 'n/a');
insert into program (name, description) values ('PowerShares DWA Consumer Staples Momentum Portfolio', 'n/a');
insert into program (name, description) values ('Terreno Realty Corporation', 'n/a');
insert into program (name, description) values ('Primero Mining Corp', 'Precious Metals');
insert into program (name, description) values ('Minerals Technologies Inc.', 'Major Chemicals');
insert into program (name, description) values ('Wells Fargo & Company', 'n/a');
insert into program (name, description) values ('Littelfuse, Inc.', 'Electrical Products');
insert into program (name, description) values ('PowerShares Golden Dragon China Portfolio', 'n/a');
insert into program (name, description) values ('PowerShares Golden Dragon China Portfolio', 'n/a');
insert into program (name, description) values ('Epizyme, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('DHX Media Ltd.', 'n/a');
insert into program (name, description) values ('Commerce Bancshares, Inc.', 'Major Banks');
insert into program (name, description) values ('Foresight Energy LP', 'Coal Mining');
insert into program (name, description) values ('StoneMor Partners L.P.', 'Other Consumer Services');
insert into program (name, description) values ('Pegasystems Inc.', 'EDP Services');
insert into program (name, description) values ('Gold Fields Limited', 'Precious Metals');
insert into program (name, description) values ('BancFirst Corporation', 'Major Banks');
insert into program (name, description) values ('Universal Forest Products, Inc.', 'Forest Products');
insert into program (name, description) values ('Glacier Bancorp, Inc.', 'Major Banks');
insert into program (name, description) values ('Dana Incorporated', 'Auto Parts:O.E.M.');
insert into program (name, description) values ('DHI Group, Inc.', 'Business Services');
insert into program (name, description) values ('First Community Financial Partners, Inc.', 'Major Banks');
insert into program (name, description) values ('Cellectis S.A.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Chesapeake Energy Corporation', 'n/a');
insert into program (name, description) values ('SkyWest, Inc.', 'Air Freight/Delivery Services');
insert into program (name, description) values ('Red Rock Resorts, Inc.', 'Hotels/Resorts');
insert into program (name, description) values ('Onconova Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('BLDRS Asia 50 ADR Index Fund', 'n/a');
insert into program (name, description) values ('Compania Cervecerias Unidas, S.A.', 'Beverages (Production/Distribution)');
insert into program (name, description) values ('Vanguard Total International Bond ETF', 'n/a');
insert into program (name, description) values ('NTT DOCOMO, Inc', 'Radio And Television Broadcasting And Communications Equipment');
insert into program (name, description) values ('Shaw Communications Inc.', 'Television Services');
insert into program (name, description) values ('Colony NorthStar, Inc.', 'n/a');
insert into program (name, description) values ('Digital Realty Trust, Inc.', 'n/a');
insert into program (name, description) values ('Energizer Holdings, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Axovant Sciences Ltd.', 'Major Pharmaceuticals');
insert into program (name, description) values ('SandRidge Permian Trust', 'Oil & Gas Production');
insert into program (name, description) values ('Mississippi Power Company', 'n/a');
insert into program (name, description) values ('Emergent Biosolutions, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Profire Energy, Inc.', 'Metal Fabrications');
insert into program (name, description) values ('LM Funding America, Inc.', 'Finance: Consumer Services');
insert into program (name, description) values ('FIRST REPUBLIC BANK', 'n/a');
insert into program (name, description) values ('Kraton Corporation', 'Major Chemicals');
insert into program (name, description) values ('TRACON Pharmaceuticals, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Carver Bancorp, Inc.', 'Savings Institutions');
insert into program (name, description) values ('Condor Hospitality Trust, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Tata Motors Ltd', 'Auto Manufacturing');
insert into program (name, description) values ('Galena Biopharma, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('PowerShares 1-30 Laddered Treasury Portfolio', 'n/a');
insert into program (name, description) values ('Golden Ocean Group Limited', 'Marine Transportation');
insert into program (name, description) values ('NRG Yield, Inc.', 'Electric Utilities: Central');
insert into program (name, description) values ('Nuveen Minnesota Quality Municipal Income Fund', 'n/a');
insert into program (name, description) values ('Capitala Finance Corp.', 'n/a');
insert into program (name, description) values ('Aspen Technology, Inc.', 'EDP Services');
insert into program (name, description) values ('The Long-Term Care ETF', 'n/a');
insert into program (name, description) values ('Generac Holdlings Inc.', 'Metal Fabrications');
insert into program (name, description) values ('Capital One Financial Corporation', 'n/a');
insert into program (name, description) values ('Northern Technologies International Corporation', 'Industrial Specialties');
insert into program (name, description) values ('West Marine, Inc.', 'Automotive Aftermarket');
insert into program (name, description) values ('Principal Millennials Index ETF', 'n/a');
insert into program (name, description) values ('Goldcorp Inc.', 'Precious Metals');
insert into program (name, description) values ('e.l.f. Beauty, Inc.', 'Package Goods/Cosmetics');
insert into program (name, description) values ('Peoples Bancorp Inc.', 'Major Banks');
insert into program (name, description) values ('Associated Banc-Corp', 'Major Banks');
insert into program (name, description) values ('Histogenics Corporation', 'Industrial Specialties');
insert into program (name, description) values ('Elbit Systems Ltd.', 'Military/Government/Technical');
insert into program (name, description) values ('United Rentals, Inc.', 'Diversified Commercial Services');
insert into program (name, description) values ('Solar Capital Ltd.', 'n/a');
insert into program (name, description) values ('Synalloy Corporation', 'Steel/Iron Ore');
insert into program (name, description) values ('L Brands, Inc.', 'Clothing/Shoe/Accessory Stores');
insert into program (name, description) values ('Callon Petroleum Company', 'Oil & Gas Production');
insert into program (name, description) values ('Dana Incorporated', 'Auto Parts:O.E.M.');
insert into program (name, description) values ('1347 Property Insurance Holdings, Inc.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Ocwen Financial Corporation', 'Finance: Consumer Services');
insert into program (name, description) values ('Ares Management L.P.', 'Investment Managers');
insert into program (name, description) values ('Invesco Credit Opportunities Fund', 'n/a');
insert into program (name, description) values ('Sabra Healthcare REIT, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Global Partners LP', 'Oil Refining/Marketing');
insert into program (name, description) values ('Hancock Holding Company', 'Major Banks');
insert into program (name, description) values ('Wabash National Corporation', 'Construction/Ag Equipment/Trucks');
insert into program (name, description) values ('U.S. Physical Therapy, Inc.', 'Medical/Nursing Services');
insert into program (name, description) values ('Earthstone Energy, Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('Reata Pharmaceuticals, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Fuel Tech, Inc.', 'Pollution Control Equipment');
insert into program (name, description) values ('Gildan Activewear, Inc.', 'Apparel');
insert into program (name, description) values ('The Middleby Corporation', 'Industrial Machinery/Components');
insert into program (name, description) values ('Sprint Corporation', 'Telecommunications Equipment');
insert into program (name, description) values ('OFG Bancorp', 'Major Banks');
insert into program (name, description) values ('Delta Technology Holdings Limited', 'Major Chemicals');
insert into program (name, description) values ('China Southern Airlines Company Limited', 'Air Freight/Delivery Services');
insert into program (name, description) values ('Colony NorthStar, Inc.', 'n/a');
insert into program (name, description) values ('Gladstone Investment Corporation', 'n/a');
insert into program (name, description) values ('THL Credit, Inc.', 'n/a');
insert into program (name, description) values ('1st Source Corporation', 'Major Banks');
insert into program (name, description) values ('Symantec Corporation', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Superior Industries International, Inc.', 'Auto Parts:O.E.M.');
insert into program (name, description) values ('Rudolph Technologies, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Healthcare Trust of America, Inc.', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Acacia Research Corporation', 'Multi-Sector Companies');
insert into program (name, description) values ('OvaScience Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Weight Watchers International Inc', 'Other Consumer Services');
insert into program (name, description) values ('QIWI plc', 'Business Services');
insert into program (name, description) values ('Check Point Software Technologies Ltd.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Pacific Biosciences of California, Inc.', 'Biotechnology: Laboratory Analytical Instruments');
insert into program (name, description) values ('Alcoa Corporation', 'Metal Fabrications');
insert into program (name, description) values ('Arrow Electronics, Inc.', 'Electronic Components');
insert into program (name, description) values ('LiNiu Technology Group', 'Services-Misc. Amusement & Recreation');
insert into program (name, description) values ('Federal Agricultural Mortgage Corporation', 'Finance Companies');
insert into program (name, description) values ('Discover Financial Services', 'Finance: Consumer Services');
insert into program (name, description) values ('Oclaro, Inc.', 'Semiconductors');
insert into program (name, description) values ('State Street Corporation', 'n/a');
insert into program (name, description) values ('Nuveen Credit Strategies Income Fund', 'n/a');
insert into program (name, description) values ('Masimo Corporation', 'Biotechnology: Electromedical & Electrotherapeutic Apparatus');
insert into program (name, description) values ('Targa Resources Partners LP', 'n/a');
insert into program (name, description) values ('Viking Therapeutics, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Kosmos Energy Ltd.', 'Oil & Gas Production');
insert into program (name, description) values ('BanColombia S.A.', 'Commercial Banks');
insert into program (name, description) values ('Ritchie Bros. Auctioneers Incorporated', 'Business Services');
insert into program (name, description) values ('Blue Capital Reinsurance Holdings Ltd.', 'Property-Casualty Insurers');
insert into program (name, description) values ('Caterpillar, Inc.', 'Construction/Ag Equipment/Trucks');
insert into program (name, description) values ('AdvisorShares Market Adaptive Unconstrained Income ETF', 'n/a');
insert into program (name, description) values ('JM Global Holding Company', 'Business Services');
insert into program (name, description) values ('BlackRock Multi-Sector Income Trust', 'n/a');
insert into program (name, description) values ('Lakeland Industries, Inc.', 'Industrial Specialties');
insert into program (name, description) values ('Twin Disc, Incorporated', 'Industrial Machinery/Components');
insert into program (name, description) values ('FSB Bancorp, Inc.', 'Savings Institutions');
insert into program (name, description) values ('Blackstone / GSO Strategic Credit Fund', 'n/a');
insert into program (name, description) values ('Nuveen AMT-Free Municipal Credit Income Fund', 'n/a');
insert into program (name, description) values ('Aegon NV', 'Life Insurance');
insert into program (name, description) values ('D.R. Horton, Inc.', 'Homebuilding');
insert into program (name, description) values ('Reinsurance Group of America, Incorporated', 'Life Insurance');
insert into program (name, description) values ('J. W. Mays, Inc.', 'Building operators');
insert into program (name, description) values ('Webster Financial Corporation', 'Major Banks');
insert into program (name, description) values ('Perceptron, Inc.', 'Electronic Components');
insert into program (name, description) values ('Strayer Education, Inc.', 'Other Consumer Services');
insert into program (name, description) values ('Ligand Pharmaceuticals Incorporated', 'Major Pharmaceuticals');
insert into program (name, description) values ('New Mountain Finance Corporation', 'n/a');
insert into program (name, description) values ('ING Group, N.V.', 'Commercial Banks');
insert into program (name, description) values ('NextEra Energy, Inc.', 'n/a');
insert into program (name, description) values ('Hurco Companies, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Juno Therapeutics, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Artesian Resources Corporation', 'Water Supply');
insert into program (name, description) values ('Kaiser Aluminum Corporation', 'Metal Fabrications');
insert into program (name, description) values ('BioLineRx Ltd.', 'Major Pharmaceuticals');
insert into program (name, description) values ('D.R. Horton, Inc.', 'Homebuilding');
insert into program (name, description) values ('Innoviva, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('TD Ameritrade Holding Corporation', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('FBL Financial Group, Inc.', 'Life Insurance');
insert into program (name, description) values ('VictoryShares Emerging Market Volatility Wtd ETF', 'n/a');
insert into program (name, description) values ('Fauquier Bankshares, Inc.', 'Major Banks');
insert into program (name, description) values ('Dermira, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('HMS Holdings Corp', 'Business Services');
insert into program (name, description) values ('PIMCO Dynamic Income Fund', 'n/a');
insert into program (name, description) values ('ADMA Biologics Inc', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Agree Realty Corporation', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Voya Natural Resources Equity Income Fund', 'n/a');
insert into program (name, description) values ('Dynegy Inc.', 'n/a');
insert into program (name, description) values ('TransUnion', 'Finance: Consumer Services');
insert into program (name, description) values ('Gladstone Land Corporation', 'Real Estate Investment Trusts');
insert into program (name, description) values ('VictoryShares US EQ Income Enhanced Volatility Wtd ETF', 'n/a');
insert into program (name, description) values ('Wal-Mart Stores, Inc.', 'Department/Specialty Retail Stores');
insert into program (name, description) values ('Ecology and Environment, Inc.', 'Military/Government/Technical');
insert into program (name, description) values ('Roadrunner Transportation Systems, Inc', 'Oil Refining/Marketing');
insert into program (name, description) values ('BHP Billiton plc', 'Coal Mining');
insert into program (name, description) values ('Marten Transport, Ltd.', 'Trucking Freight/Courier Services');
insert into program (name, description) values ('Calix, Inc', 'Telecommunications Equipment');
insert into program (name, description) values ('Capstead Mortgage Corporation', 'n/a');
insert into program (name, description) values ('Euro Tech Holdings Company Limited', 'Diversified Electronic Products');
insert into program (name, description) values ('Brookfield Canada Office Properties', 'Real Estate Investment Trusts');
insert into program (name, description) values ('FirstService Corporation', 'Real Estate');
insert into program (name, description) values ('Westrock Company', 'Containers/Packaging');
insert into program (name, description) values ('SEI Investments Company', 'Investment Bankers/Brokers/Service');
insert into program (name, description) values ('Heron Therapeutics, Inc.  ', 'Major Pharmaceuticals');
insert into program (name, description) values ('Morgan Stanley', 'n/a');
insert into program (name, description) values ('CM Finance Inc', 'n/a');
insert into program (name, description) values ('Carter''s, Inc.', 'Apparel');
insert into program (name, description) values ('PowerShares DWA SmallCap Momentum Portfolio', 'n/a');
insert into program (name, description) values ('China TechFaith Wireless Communication Technology Limited', 'n/a');
insert into program (name, description) values ('FlexShares US Quality Large Cap Index Fund', 'n/a');
insert into program (name, description) values ('PS Business Parks, Inc.', 'n/a');
insert into program (name, description) values ('ArQule, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Gamestop Corporation', 'Electronics Distribution');
insert into program (name, description) values ('Alliqua BioMedical, Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('VALE S.A.', 'Precious Metals');
insert into program (name, description) values ('iRhythm Technologies, Inc.', 'Medical/Dental Instruments');
insert into program (name, description) values ('International Paper Company', 'Paper');
insert into program (name, description) values ('Advanced Energy Industries, Inc.', 'Industrial Machinery/Components');
insert into program (name, description) values ('Centennial Resource Development, Inc.', 'Oil & Gas Production');
insert into program (name, description) values ('Chesapeake Utilities Corporation', 'Oil & Gas Production');
insert into program (name, description) values ('Agnico Eagle Mines Limited', 'Precious Metals');
insert into program (name, description) values ('Ability Inc.', 'Business Services');
insert into program (name, description) values ('SunTrust Banks, Inc.', 'n/a');
insert into program (name, description) values ('MercadoLibre, Inc.', 'Business Services');
insert into program (name, description) values ('Pulse Biosciences, Inc', 'Medical/Dental Instruments');
insert into program (name, description) values ('Trevena, Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Asure Software Inc', 'EDP Services');
insert into program (name, description) values ('Concord Medical Services Holdings Limited', 'Medical/Nursing Services');
insert into program (name, description) values ('Blackhawk Network Holdings, Inc.', 'Finance: Consumer Services');
insert into program (name, description) values ('Ares Commercial Real Estate Corporation', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Maiden Holdings, Ltd.', 'n/a');
insert into program (name, description) values ('EPR Properties', 'Real Estate Investment Trusts');
insert into program (name, description) values ('REX American Resources Corporation', 'Major Chemicals');
insert into program (name, description) values ('Cirrus Logic, Inc.', 'Semiconductors');
insert into program (name, description) values ('Star Bulk Carriers Corp.', 'Marine Transportation');
insert into program (name, description) values ('SB Financial Group, Inc.', 'Major Banks');
insert into program (name, description) values ('PNC Financial Services Group, Inc. (The)', 'n/a');
insert into program (name, description) values ('Meridian Bioscience Inc.', 'Biotechnology: In Vitro & In Vivo Diagnostic Substances');
insert into program (name, description) values ('Leucadia National Corporation', 'Meat/Poultry/Fish');
insert into program (name, description) values ('Bank Of Montreal', 'Commercial Banks');
insert into program (name, description) values ('FORM Holdings Corp.', 'Multi-Sector Companies');
insert into program (name, description) values ('Fox Factory Holding Corp.', 'Motor Vehicles');
insert into program (name, description) values ('Dril-Quip, Inc.', 'Metal Fabrications');
insert into program (name, description) values ('Sturm, Ruger & Company, Inc.', 'Ordnance And Accessories');
insert into program (name, description) values ('Axalta Coating Systems Ltd.', 'Paints/Coatings');
insert into program (name, description) values ('CPI Card Group Inc.', 'Finance Companies');
insert into program (name, description) values ('Performance Food Group Company', 'Food Distributors');
insert into program (name, description) values ('Dreyfus High Yield Strategies Fund', 'n/a');
insert into program (name, description) values ('Invesco Pennsylvania Value Municipal Income Trust', 'n/a');
insert into program (name, description) values ('DSW Inc.', 'Clothing/Shoe/Accessory Stores');
insert into program (name, description) values ('USD Partners LP', 'Railroads');
insert into program (name, description) values ('American Water Works', 'Water Supply');
insert into program (name, description) values ('iShares 20+ Year Treasury Bond ETF', 'n/a');
insert into program (name, description) values ('Peregrine Pharmaceuticals Inc.', 'Major Pharmaceuticals');
insert into program (name, description) values ('Norwegian Cruise Line Holdings Ltd.', 'Marine Transportation');
insert into program (name, description) values ('Fifth Street Finance Corp.', 'n/a');
insert into program (name, description) values ('ProShares UltraShort Nasdaq Biotechnology', 'n/a');
insert into program (name, description) values ('Stoneridge, Inc.', 'Auto Parts:O.E.M.');
insert into program (name, description) values ('Champions Oncology, Inc.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Public Storage', 'Real Estate Investment Trusts');
insert into program (name, description) values ('Marriot Vacations Worldwide Corporation', 'Real Estate');
insert into program (name, description) values ('Fulgent Genetics, Inc.', 'Medical Specialities');
insert into program (name, description) values ('Computer Programs and Systems, Inc.', 'EDP Services');
insert into program (name, description) values ('Nicholas Financial, Inc.', 'Finance Companies');
insert into program (name, description) values ('CA Inc.', 'Computer Software: Prepackaged Software');
insert into program (name, description) values ('Treehouse Foods, Inc.', 'Packaged Foods');
insert into program (name, description) values ('Qiagen N.V.', 'Biotechnology: Biological Products (No Diagnostic Substances)');
insert into program (name, description) values ('Intrexon Corporation', 'Biotechnology: Commercial Physical & Biological Resarch');
insert into program (name, description) values ('Jack In The Box Inc.', 'Restaurants');
insert into program (name, description) values ('WisdomTree Interest Rate Hedged High Yield Bond Fund', 'n/a');
insert into program (name, description) values ('Ascent Capital Group, Inc.', 'Other Consumer Services');
insert into program (name, description) values ('Nicolet Bankshares Inc.', 'Major Banks');
insert into program (name, description) values ('Smart Sand, Inc.', 'n/a');
