Contributing
============

All kinds of contributions to LaraHack are greatly appreciated. For someone
unfamiliar with the code base, the most efficient way to contribute is usually
to submit a feature request , bug report or working on our [tasks list](#tasks-list)

If you want to dive into the source code, you can submit a [patch](#patches) as
well. Working on [existing issues][issues] is super helpful!

Feature Requests
----------------

Do you have an idea for an awesome new feature for LaraHack? Please [submit a
feature request][issue]. It's great to hear about new ideas.

If you are inclined to do so, you're welcome to [fork][fork] LaraHack , work on
implementing the feature yourself, and submit a patch. In this case, it's
*highly recommended* that you first [open an issue][issue] describing your
enhancement to get early feedback on the new feature that you are implementing.
This will help avoid wasted efforts and ensure that your work is incorporated
into the code base.

Bug Reports
-----------

Did something go wrong with LaraHack ? Sorry about that! Bug reports are greatly
appreciated!

When you [submit a bug report][issue], please include relevant information such
as LaraHack  version, operating system, configuration, error messages, and steps to
reproduce the bug. The more details you can include, the easier it is to find
and fix the bug.

Patches
-------

Want to hack on LaraHack ? Awesome!

If there are [open issues][issues], you're more than welcome to work on those -
this is probably the best way to contribute to LaraHack . If you have your own
ideas, that's great too! In that case, before working on substantial changes to
the code base, it is *highly recommended* that you first [open an issue][issue]
describing what you intend to work on.

**Patches are generally submitted as pull requests.** Patches are also
[accepted over email][email].

Any changes to the code base should follow the style and coding conventions
used in the rest of the project. The version history should be clean, and
commit messages should be descriptive .


Tasks List
-------

- [ ] Add Quick deploy to Heroku 
- [ ] Add multiple admins with different access
- [ ] Add more settings 
- [ ] Send Custom mails
- [ ] Add CTF Platform
- [ ] Add explore teams ( Join other incomplete teams )

---

If you have any questions about anything, feel free to [ask][email]!


[issue]: https://github.com/ScientificClubofESI/LaraHack/issues/new
[issues]: https://github.com/ScientificClubofESI/LaraHack/issues
[fork]: https://github.com/ScientificClubofESI/LaraHack/fork
[email]: mailto:ha_zellat@esi.dz
