package org.sasanlabs.framework;

import static org.sasanlabs.framework.VulnerableAppConstants.DEFAULT_LOAD_ON_STARTUP_VALUE;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * Servlet implementation class {@code VulnerabilityDefinitions} This class provides the details
 * about all the endpoints exposed from the Application.
 */
@WebServlet(value = "/VulnerabilityDefinitions", loadOnStartup = DEFAULT_LOAD_ON_STARTUP_VALUE)
public class VulnerabilityDefinitions extends HttpServlet {
    private static final Logger LOG = LogManager.getLogger(VulnerabilityDefinitions.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        LOG.debug("GET {}", request.getPathInfo());
        ObjectMapper objectMapper = new ObjectMapper();
        response.getWriter()
                .append(
                        objectMapper.writeValueAsString(
                                VulnerabilityDefinitionRegistry
                                        .getAllRegisteredVulnerabilityDefinitions()));
        response.setContentType("application/json");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        LOG.debug("POST {}", request.getPathInfo());
        response.sendError(HttpServletResponse.SC_METHOD_NOT_ALLOWED);
    }
}
