package org.sasanlabs.framework;

import java.util.HashSet;
import java.util.Set;
import org.sasanlabs.vulnerableapp.facade.schema.VulnerabilityDefinition;

/**
 * {@code VulnerabilityDefinitionRegistry} is the registry class for holding the information about
 * the Vulnerabilities present in the VulnerableApp-jsp.
 *
 * @author KSASAN preetkaran20@gmail.com
 */
public class VulnerabilityDefinitionRegistry {

    private static Set<VulnerabilityDefinition> vulnerabilityDefinitions = new HashSet<>();

    /**
     * Used to add the Vulnerability Definition to the registry.
     *
     * @param vulnerabilityDefinition
     */
    public static synchronized void add(VulnerabilityDefinition vulnerabilityDefinition) {
        vulnerabilityDefinitions.add(vulnerabilityDefinition);
    }

    /**
     * Used to remove the Vulnerability Definition from the registry
     *
     * @param vulnerabilityDefinition
     * @return {@code true} if successfully removed else {@code false}.
     */
    public static synchronized boolean remove(VulnerabilityDefinition vulnerabilityDefinition) {
        return vulnerabilityDefinitions.remove(vulnerabilityDefinition);
    }

    /**
     * Provides all the registered VulnerabilityDefinitions.
     *
     * @return Set of VulnerabilityDefinitionResponseBean
     */
    static Set<VulnerabilityDefinition> getAllRegisteredVulnerabilityDefinitions() {
        return vulnerabilityDefinitions;
    }
}
