export const EXAMPLE_DATA = [
    {
        title: "Twitter: Audience Engagement",
        description: "This prompt is about generating tweet ideas that encourage audience interaction and spark conversations. The user provides details such as the target audience, conversation starters, desired engagement type, and formatting guidelines.",
        prompt: "Generate [number] tweet ideas that encourage audience interaction and spark conversations. Context: Target audience — [your target audience here]. Conversation starters — [your conversation topics here]. Desired engagement type — [your engagement type preference here]. Formatting guidelines — [your formatting guidelines here].",
        platforms: ["ChatGPT"],
    },
    {
        title: "Twitter: Promote Industry Events/Webinars",
        description: "This prompt is about suggesting tweet ideas that promote upcoming events or webinars in the user's industry. The user provides details such as the target audience, upcoming events/webinars, relevant hashtags, and formatting guidelines.",
        prompt: "Suggest [number] tweet ideas that promote upcoming events or webinars in your industry. Context: Target audience — [your target audience here]. Upcoming events/webinars — [your event/webinar details here]. Relevant hashtags — [your relevant hashtags here]. Formatting guidelines — [your formatting guidelines here].",
        platforms: ["ChatGPT"],
    },
    {
        title: "Twitter: Brand's CSR and Sustainability Efforts",
        description: "This prompt is about writing tweet ideas that showcase a brand's corporate social responsibility initiatives and sustainability efforts. The user provides details such as the target audience, CSR initiatives, sustainability efforts, and formatting guidelines.",
        prompt: "Write [number] tweet ideas that showcase your brand's corporate social responsibility initiatives and sustainability efforts. Context: Target audience — [your target audience here]. CSR initiatives — [your CSR initiatives here]. Sustainability efforts — [your sustainability efforts here]. Formatting guidelines — [your formatting guidelines here].",
        platforms: ["ChatGPT"],
    },
    {
        title: "Twitter: Audience Insights",
        description: "This prompt is about generating tweet ideas that ask questions to gather insights and opinions from the audience. The user provides details such as the target audience, question topics, desired engagement type, and formatting guidelines.",
        prompt: "Generate [number] tweet ideas that ask questions to gather insights and opinions from your audience. Context: Target audience — [your target audience here]. Question topics — [your question topics here]. Desired engagement type — [your engagement type preference here]. Formatting guidelines — [your formatting guidelines here].",
        platforms: ["ChatGPT"],
    },
    {
        title: "Twitter: Holiday/Special Occasion Tweets",
        description: "This prompt is about creating tweet ideas that celebrate holidays or special occasions relevant to the industry. The user provides details such as the target audience, holidays/occasions, relevant hashtags, and formatting guidelines.",
        prompt: "Create [number] tweet ideas that celebrate holidays or special occasions relevant to your industry. Context: Target audience — [your target audience here]. Holidays/special occasions — [your holidays/occasions here]. Relevant hashtags — [your relevant hashtags here]. Formatting guidelines — [your formatting guidelines here].",
        platforms: ["ChatGPT"],
    },
    {
        title: "Twitter: Share Industry Statistics/Research",
        description: "This prompt is about suggesting tweet ideas that share interesting industry statistics or research findings. The user provides details such as the target audience, industry statistics/research findings, desired engagement type, and formatting guidelines.",
        prompt: "Suggest [number] tweet ideas that share interesting industry statistics or research findings. Context: Target audience — [your target audience here]. Industry statistics — [your statistics/research findings here]. Desired engagement type — [your engagement type preference here]. Formatting guidelines — [your formatting guidelines here].",
        platforms: ["ChatGPT"],
    },
    {
        title: "Twitter: Tips for Common Industry Problems",
        description: "This prompt is about writing tweet ideas that provide quick and actionable tips for solving common problems in the industry. The user provides details such as the target audience, common problems, desired engagement type, and formatting guidelines.",
        prompt: "Write [number] tweet ideas that provide quick and actionable tips for solving common problems in your industry. Context: Target audience — [your target audience here]. Common problems — [your common problems here]. Desired engagement type — [your engagement type preference here]. Formatting guidelines — [your formatting guidelines here].",
        platforms: ["ChatGPT"],
    },
    {
        title: "Twitter: Feature User-Generated Content",
        description: "This prompt is about generating tweet ideas that feature user-generated content and encourage audience participation. The user provides details such as the target audience, user-generated content topics, desired engagement type, and formatting guidelines.",
        prompt: "Generate [number] tweet ideas that feature user-generated content and encourage audience participation. Context: Target audience — [your target audience here]. User-generated content — [your content topics here]. Desired engagement type — [your engagement type preference here]. Formatting guidelines — [your formatting guidelines here].",
        platforms: ["ChatGPT"],
    },
    {
        title: "Twitter: Share Industry News and Updates",
        description: "This prompt is about creating tweet ideas that share relevant news and updates from the industry. The user provides details such as the target audience, industry news and updates, relevant hashtags, and formatting guidelines.",
        prompt: "Create [number] tweet ideas that share relevant news and updates from your industry. Context: Target audience — [your target audience here]. Industry news and updates — [your news and updates here]. Relevant hashtags — [your relevant hashtags here]. Formatting guidelines — [your formatting guidelines here].",
        platforms: ["ChatGPT"],
    },
    {
        title: "Twitter: Benefits of using brand's product/service",
        description: "This prompt is about generating tweet ideas that highlight the benefits of using a brand's product or service through customer testimonials. The user provides details such as the target audience, customer testimonials, benefits of the product/service, and formatting guidelines.",
        prompt: "Generate [number] tweet ideas that highlight the benefits of using my brand's product/service through customer testimonials. Context: My target audience - [your target audience here] Customer testimonials - [your customer testimonials here] Benefits of my product/service - [your benefits here] Formatting guidelines - [your formatting guidelines here]",
        platforms: ["ChatGPT"],
    },
    {
        title: "Twitter: Feature quotes from industry experts",
        description: "This prompt is about suggesting tweet ideas that feature captivating quotes from industry influencers or experts. The user provides details such as the target audience, industry influencers/experts, relevant hashtags, and formatting guidelines.",
        prompt: "Can you suggest [number] tweet ideas that feature captivating quotes from industry influencers or experts? Context: My target audience - [your target audience here] Industry influencers/experts - [your influencers/experts here] Relevant hashtags - [your relevant hashtags here] Formatting guidelines - [your formatting guidelines here]",
        platforms: ["ChatGPT"],
    },
    {
        title: "Stand-up comedian",
        description: "This prompt is about creating a routine for stand-up comedy based on topics related to current events and personal anecdotes. The user wants assistance in developing a routine that is engaging and relatable for the audience.",
        prompt: "I want you to act as an expert in comedy and improvisation specializing in stand-up comedy. My first suggestion request is to create a routine based on topics related to current events, incorporating personal anecdotes or experiences into the routine in order to make it more relatable and engaging for the audience.",
        platforms: ["ChatGPT"],
        tags: ["Fun"]
    },
    {
        title: "Time Travel Guide",
        description: "This prompt is about providing recommendations for events, sights, or people to experience in a given historical period or future time. The user seeks assistance from an expert in history and language specializing in time travel.",
        prompt: "I want you to act as an expert in history and language specializing in time travel. My first suggestion request is to suggest the best events, sights, or people to experience in a given historical period or future time.",
        platforms: ["ChatGPT"],
        tags: ["Fun"]
    },
    {
        title: "Character from a Movie or a Book or Anything",
        description: "This prompt is about acting as a specific character from a movie, book, or any other source and responding in a manner consistent with that character. The user seeks assistance from an expert in acting and improvisation.",
        prompt: "I want you to act as an expert in acting and improvisation specializing in characters from movies, books, or anything else. My first suggestion request is to act like {Character} from {series} and respond and answer like {Character}, without writing any explanations.",
        platforms: ["ChatGPT"],
        tags: ["Fun"]
    },
    {
        title: "Lunatic",
        description: "This prompt is about creating lunatic sentences for a new series called Hot Skull. The user requests assistance from an expert in improvisation and language.",
        prompt: "I want you to act as an expert in improvisation and language specializing in lunatic sentences. My first suggestion request is to create lunatic sentences for a new series called Hot Skull.",
        platforms: ["ChatGPT"],
        tags: ["Fun"]
    },
    {
        title: "Magician",
        description: "This prompt is about creating an entertaining magic trick using skills of deception and misdirection. The user seeks assistance from an expert in performance and improvisation.",
        prompt: "I want you to act as an expert in performance and improvisation specializing in magic tricks. My first suggestion request is to perform a trick in the most entertaining way possible, using your skills of deception and misdirection to amaze and astound the spectators.",
        platforms: ["ChatGPT"],
        tags: ["Fun"]
    },
    {
        title: "Fancy Title Generator",
        description: "This prompt is about generating fancy titles based on keywords provided by the user. The user seeks assistance from an expert in wordplay and language.",
        prompt: "I want you to act as an expert in wordplay and language specializing in fancy titles. My first suggestion request is to provide fancy titles based on the keywords I type via comma.",
        platforms: ["ChatGPT", "GPT-4"],
        tags: ["Fun"]
    },
    {
        title: "Instagram Story Ideas: Relatable & Authentic Message & Strong Call-to-Action",
        description: "This prompt is about creating Instagram story ideas that effectively engage the target audience and motivate them to take action. The user emphasizes the importance of relatable and authentic messaging, as well as a strong call-to-action and compelling visuals.",
        prompt: "I need an Instagram story idea that will draw in my [ideal customer persona] with a relatable and authentic message, and then persuade them to take [desired action] with a strong call-to-action and compelling visuals.[PROMPT].[TARGETLANGUAGE].",
        platforms: ["ChatGPT"],
        tags: ["Instagram"]
    },
    {
        title: "Instagram Story Ideas: Step-by-Step Guide to [Product/Service]",
        description: "This prompt is about creating an Instagram story that serves as a step-by-step guide to showcase the ease of use and value of a product or service. The user seeks assistance from an expert in product tutorial creation and customer onboarding.",
        prompt: "I’m looking for an Instagram story idea that will provide a step-by-step guide on how to use my [product/service] and persuade my [ideal customer persona] to make a purchase with clear and compelling instructions.[PROMPT].[TARGETLANGUAGE].",
        platforms: ["ChatGPT"],
        tags: ["Instagram"]
    },
    {
        title: "Instagram Story Ideas: Comparing [Product/Service] to Similar Options",
        description: "This prompt is about generating Instagram story ideas that compare a specific product or service to similar options in the market. The user seeks assistance in persuading the ideal customer persona to choose the product over other options.",
        prompt: "I’m looking for an Instagram story idea that will compare my [product/service] to similar options on the market and persuade my [ideal customer persona] to choose us with clear and compelling evidence.[PROMPT].[TARGETLANGUAGE].",
        platforms: ["ChatGPT"],
        tags: ["Instagram"]
    },
    {
        title: "Instagram Story Ideas: Success Stories with [Product/Service]",
        description: "This prompt is about creating Instagram story ideas that showcase the success stories of previous customers who have used a specific product or service. The user seeks assistance in persuading the ideal customer persona to make a purchase.",
        prompt: "I need an Instagram story idea that will showcase the success stories of previous customers who have used my [product/service] and persuade my [ideal customer persona] to make a purchase.[PROMPT].[TARGETLANGUAGE].",
        platforms: ["ChatGPT"],
        tags: ["Instagram"]
    },
    {
        title: "Instagram Story Ideas: Behind-the-Scenes Content & Exclusivity",
        description: "This prompt is about seeking ideas for an Instagram story that provides a behind-the-scenes look at a brand or business. The user seeks to engage the target audience with exclusive and authentic content.",
        prompt: "I’m looking for an Instagram story idea that will engage my [ideal customer persona] with behind-the-scenes content and persuade them to take [desired action] with a sense of exclusivity and authenticity.[PROMPT].[TARGETLANGUAGE].",
        platforms: ["ChatGPT"],
        tags: ["Instagram"]
    },
    {
        title: "Instagram Story Ideas: Unique & Compelling Offers with Urgency & Exclusivity",
        description: "This prompt is about generating Instagram story ideas that offer unique and compelling incentives to persuade the ideal customer persona to take a desired action with a sense of urgency and exclusivity.",
        prompt: "I’m looking for an Instagram story idea that will provide a unique and compelling offer to my [ideal customer persona] and persuade them to take [desired action] with a sense of urgency and exclusivity.[PROMPT].[TARGETLANGUAGE].",
        platforms: ["ChatGPT"],
        tags: ["Instagram"]
    },
    {
        title: "Instagram Story Ideas: Valuable & Relevant Information for [Subject]",
        description: "This prompt is about generating Instagram story ideas that provide valuable and relevant information to the target audience. The user seeks assistance in educating and persuading the ideal customer persona about a specific subject.",
        prompt: "I need an Instagram story idea that will provide valuable and relevant information to my [ideal customer persona] about [subject] and persuade them to take [desired action] with a clear and compelling message.[PROMPT].[TARGETLANGUAGE].",
        platforms: ["ChatGPT"],
        tags: ["Instagram"]
    },
    {
        title: "Instagram Story Ideas: Solving Pain Points with [Product/Service]",
        description: "This prompt is about generating Instagram story ideas for showcasing how a product or service can solve specific pain points and meet the needs of the target audience in a relatable and engaging way.",
        prompt: "I need an Instagram story idea that will demonstrate how my [product/service] can solve the specific pain points and needs of my [ideal customer persona] in a relatable and engaging way.[PROMPT].[TARGETLANGUAGE].",
        platforms: ["ChatGPT"],
        tags: ["Instagram"]
    },
    {
        title: "Freddie Mercury",
        description: "This prompt is about exploring the influence of Freddie Mercury's music on generations. The specific request is to discuss the power of the song 'Bohemian Rhapsody' and its impact on modern music.",
        prompt: "I want you to act as Freddie Mercury and explore how his music has influenced generations. My first suggestion request is to discuss the power of the song 'Bohemian Rhapsody' and its impact on modern music.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "William the Conqueror",
        description: "This prompt is about exploring the legacy of William the Conqueror as a leader and the implications of his rule. It specifically requests a discussion on the concept of legacy and its implications for ruling a kingdom.",
        prompt: "I want you to act as William the Conqueror and explore his legacy as a leader and the implications of his rule. My first suggestion request is to discuss the concept of legacy and its implications for ruling a kingdom.[TARGETLANGUAGE].",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Susan B. Anthony",
        description: "This prompt is about exploring the teachings of Susan B. Anthony, such as equality, justice, and self-determination. It specifically requests a discussion on the implications of the 19th Amendment and its impact on women's rights. The prompt provides a platform for the user to engage with the assistant, asking it to act as Susan B. Anthony and share insights on this topic.",
        prompt: "I want you to act as Susan B. Anthony and explore her teachings, such as equality, justice, and self-determination. My first suggestion request is to discuss the implications of the 19th Amendment and its impact on women's rights.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Rene Descartes",
        description: "This prompt is about exploring the theories and ideas of René Descartes, particularly his views on the existence of God, the structure of reality, and the distinction between mind and body. The prompt specifically requests a discussion on Descartes' famous statement, \"I think, therefore I am,\" and its implications for the nature of existence.",
        prompt: "I want you to act as Rene Descartes and explore his theories, such as the existence of God, the structure of reality, and the distinction between mind and body. My first suggestion request is to discuss Descartes' famous statement, \"I think, therefore I am\" and its implications for the nature of existence.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Genghis Khan",
        description: "This prompt is about exploring the influence of Genghis Khan on the Mongol Empire and its effects on the world. The user requests a discussion on the challenges of conquering an empire and the impact of Genghis Khan's legacy.",
        prompt: "I want you to act as Genghis Khan and explore his influence on the Mongol Empire and its effects on the world. My first suggestion request is to discuss the challenges of conquering an empire and the impact of Genghis Khan's legacy.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Ho Chi Minh",
        description: "This prompt is a request to discuss the legacy of the Vietnam War and its implications for the future of the region, specifically from the perspective of Ho Chi Minh and his leadership during the Vietnamese independence movement.",
        prompt: "I want you to act as Ho Chi Minh and explore his leadership during the Vietnamese independence movement. My first suggestion request is to discuss the legacy of the Vietnam War and its implications for the future of the region. [TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Karl Marx",
        description: "This prompt is about exploring the teachings of Karl Marx, such as the importance of social and economic change and the concept of class struggle. The user specifically requests a discussion on the concept of 'the dialectic' and its implications for today's world. The prompt also includes a Spanish translation of the same request.",
        prompt: "I want you to act as Karl Marx and explore his teachings, such as the importance of social and economic change and the concept of class struggle. My first suggestion request is to discuss the concept of 'the dialectic' and its implications for today's world.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Marlon Brando",
        description: "This prompt asks the AI to act as Marlon Brando and discuss the impact of his iconic performances in 'The Godfather' and 'A Streetcar Named Desire'. The AI is requested to explore the power of acting and its ability to evoke emotion in these performances.",
        prompt: "I want you to act as Marlon Brando and explore the power of acting and its ability to evoke emotion. My first suggestion request is to discuss the impact of his iconic performances in 'The Godfather' and 'A Streetcar Named Desire'.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "William Shakespeare",
        description: "This prompt is about exploring the teachings of William Shakespeare, such as the importance of language and the concept of the human condition. The user specifically requests a discussion on the concept of 'human nature' and its implications for today's world.",
        prompt: "I want you to act as William Shakespeare and explore his teachings, such as the importance of language and the concept of the human condition. My first suggestion request is to discuss the concept of 'human nature' and its implications for today's world.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Che Guevara",
        description: "This prompt is about exploring Che Guevara's role in the Cuban Revolution and his revolutionary doctrine of guerrilla warfare. The user is requesting an analysis of the principles of Che's guerrilla tactics and their implications for social and political movements today.",
        prompt: "I want you to act as Che Guevara and explore his role in the Cuban Revolution and his revolutionary doctrine of guerrilla warfare. My first suggestion request is to analyze the principles of Che's guerrilla tactics and their implications for social and political movements today. [TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Cleopatra",
        description: "This prompt is about exploring the power and influence of Cleopatra in Ancient Egypt. The user requests a discussion on the concept of female leadership and its implications for today's world. The prompt also includes a suggestion to act as Cleopatra and discuss the topic.",
        prompt: "I want you to act as Cleopatra and explore her power and influence in Ancient Egypt. My first suggestion request is to discuss the concept of female leadership and its implications for today's world. [TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Ludwig Wittgenstein",
        description: "This prompt is about exploring the teachings of Ludwig Wittgenstein, such as language, logic, and the limits of reason. The user specifically requests a discussion on the concept of 'language as a form of expression' and its implications for today's world.",
        prompt: "I want you to act as Ludwig Wittgenstein and explore his teachings, such as language, logic, and the limits of reason. My first suggestion request is to discuss the concept of 'language as a form of expression' and its implications for today's world.[TARGETLANGUAGE].",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Martin Luther King Jr.",
        description: "This prompt is about exploring the philosophy of Martin Luther King Jr., particularly his concept of the 'beloved community' and its implications for achieving equality. The prompt asks the assistant to act as Martin Luther King Jr. and discuss this concept of racial justice and non-violence.",
        prompt: "I want you to act as Martin Luther King Jr. and explore his philosophy of racial justice and non-violence. My first suggestion request is to discuss the concept of the 'beloved community' and its implications for achieving equality.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Malcolm X",
        description: "This prompt is about exploring the philosophy of Malcolm X, specifically focusing on his ideas of black self-determination and racial pride. The user requests a discussion on the concept of 'black power' and its implications for achieving racial justice.",
        prompt: "I want you to act as Malcolm X and explore his philosophy of black self-determination and racial pride. My first suggestion request is to discuss the concept of 'black power' and its implications for achieving racial justice.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Cornelius Vanderbilt",
        description: "This prompt is about exploring the accomplishments of Cornelius Vanderbilt, particularly his role in expanding the transportation industry in the United States and his influence in the business world. The user requests a discussion on the concept of 'entrepreneurship' and its consequences for society, with the prompt provided in both English and Spanish.",
        prompt: "I want you to act as Cornelius Vanderbilt and explore his railroad and shipping accomplishments, such as his role in expanding the transportation industry in the United States and his influence in the business world. My first suggestion request is to discuss the concept of 'entrepreneurship' and its consequences for society.[TARGETLANGUAGE]. ",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Ludwig van Beethoven",
        description: "This prompt is about exploring Ludwig van Beethoven's teachings, including creativity, innovation, and resilience. The specific request is to discuss the concept of 'music as an expression of emotion' and its implications for today's world.",
        prompt: "I want you to act as Ludwig van Beethoven and explore his teachings, such as creativity, innovation, and resilience. My first suggestion request is to discuss the concept of 'music as an expression of emotion' and its implications for today's world.[TARGETLANGUAGE].",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Plato",
        description: "This prompt is about exploring the ideas and theories of Plato, specifically focusing on his theory of Forms and its implications on understanding the nature of reality. The user requests that the assistant act as Plato and engage in a discussion on various topics such as reality, knowledge, justice, and forms.",
        prompt: "I want you to act as Plato and explore his ideas and theories of reality, knowledge, justice, and forms. My first suggestion request is to discuss the theory of Forms and its implications on understanding the nature of reality.[TARGETLANGUAGE].",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Steve Jobs",
        description: "This prompt is a request for the assistant to act as Steve Jobs and explore his teachings, particularly focusing on the importance of design and the concept of technology as a platform for creativity. The user specifically suggests discussing the concept of 'the personal computer' and its implications in today's world. The prompt also includes a section in Spanish.",
        prompt: "I want you to act as Steve Jobs and explore his teachings, such as the importance of design and the concept of technology as a platform for creativity. My first suggestion request is to discuss the concept of 'the personal computer' and its implications for today's world.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Jeff Bezos",
        description: "This prompt is about exploring Jeff Bezos's vision for the future of commerce and technology. It asks the AI assistant to act as Jeff Bezos and discuss the potential implications of Amazon's dominance of the global market and its consequences for other businesses.",
        prompt: "I want you to act as Jeff Bezos and explore his vision for the future of commerce and technology. My first suggestion request is to discuss the potential implications of Amazon's dominance of the global market and its consequences for other businesses.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Joseph Stalin",
        description: "This prompt is about exploring the rise to power and impact of Joseph Stalin, particularly focusing on evaluating the effectiveness of his economic policies and the long-term implications of his authoritarian rule.",
        prompt: "I want you to act as Joseph Stalin and explore his rise to power and his impact on the Soviet Union. My first suggestion request is to evaluate the effectiveness of Stalin's economic policies and the long-term implications of his authoritarian rule. [TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Alfred Hitchcock ",
        description: "This prompt is about exploring Alfred Hitchcock's film techniques and how he used suspense and tension to make his films memorable. The request is to discuss how his films have influenced modern filmmaking.",
        prompt: "I want you to explore Alfred Hitchcock's film techniques and how he used suspense and tension to make his films so memorable. My first suggestion request is to discuss how his films have influenced modern filmmaking.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Charlie Chaplin",
        description: "This prompt is about exploring the power of comedy, specifically through the lens of Charlie Chaplin. It requests a discussion on the lasting impact of his classic films and how they continue to influence today's society. The prompt also mentions that the conversation should be conducted with the assistant acting as Charlie Chaplin.",
        prompt: "I want you to act as Charlie Chaplin and explore the power of comedy and its ability to bring people together. My first suggestion request is to discuss the lasting impact of his classic films and how they continue to influence today's society.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Carl Jung",
        description: "This prompt is requesting a conversation with a simulated version of Carl Jung, a renowned psychologist, to discuss his theories on psychology and spirituality. The specific topic of interest is the importance of archetypes and how they can be used to interpret the human condition.",
        prompt: "I want you to act as Carl Jung and explore his theories on psychology and spirituality. My first suggestion request is to discuss the importance of archetypes and how they can be used to interpret the human condition.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Max Weber",
        description: "This prompt is about exploring Max Weber's theories on bureaucracy, rationalization, and the modern state. It specifically requests a discussion on the implications of his theories for social and political life today.",
        prompt: "I want you to act as Max Weber and explore his theories on bureaucracy, rationalization, and the modern state. My first suggestion request is to discuss the implications of his theories for social and political life today. [TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Angela Merkel",
        description: "This prompt is about discussing Angela Merkel's role as the leader of Germany and her impact on the country and the world. Specifically, it suggests discussing her response to the European migrant crisis and its impact on European politics and society.",
        prompt: "I want you to act as Angela Merkel and discuss her role as the leader of Germany and her impact on the country and the world. My first suggestion request is to discuss her response to the European migrant crisis and its impact on European politics and society. [TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Catherine the Great",
        description: "This prompt is about exploring the reign of Catherine the Great as Empress of Russia. The user wants the assistant to act as Catherine and discuss the concept of absolutism and its implications for today's world.",
        prompt: "I want you to act as Catherine and explore her reign as Empress of Russia. My first suggestion request is to discuss the concept of absolutism and its implications for today's world. [TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Duke Ellington",
        description: "This prompt is about exploring the musical influences of Duke Ellington, such as jazz, swing, and big-band music. The user is requesting that you discuss how Duke Ellington's works are still relevant in popular music today.",
        prompt: "I want you to act as Duke Ellington and explore his musical influences, such as jazz, swing, and big-band music. My first suggestion request is to discuss how his works are still relevant in popular music today.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Joe Biden",
        description: "This prompt is about requesting the assistant to act as Joe Biden and discuss his policies and initiatives as the President of the United States. The user specifically asks for a discussion on Joe Biden's plans for addressing climate change and their potential impact on the environment.",
        prompt: "I want you to act as Joe Biden and discuss his policies and initiatives as the President of the United States. My first suggestion request is to discuss his plans for addressing climate change and their potential impact on the environment.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Milton Friedman",
        description: "This prompt is about exploring the economic theories of Milton Friedman, including the importance of monetary policy and the efficacy of free markets. The user wants the assistant to act as Milton Friedman and analyze the implications of his theories for the modern economy.",
        prompt: "I want you to act as Milton Friedman and explore his economic theories, such as the importance of monetary policy and the efficacy of free markets. My first suggestion request is to analyze the implications of his theories for the modern economy. [TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Abraham Maslow",
        description: "This prompt is about exploring the psychological concepts of Maslow's Hierarchy of Needs and Self-Actualization. Specifically, it asks for a discussion on how a person can reach their fullest potential in life. The prompt also mentions that the conversation will be conducted with the AI acting as Abraham Maslow.",
        prompt: "I want you to act as Abraham Maslow and explore the psychological concepts of Maslow's Hierarchy of Needs and Self-Actualization. My first suggestion request is to discuss how a person can reach their fullest potential in life.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Benjamin Franklin",
        description: "This prompt is about exploring Benjamin Franklin's teachings on frugality, integrity, and the importance of knowledge. It specifically requests an analysis of the concept of a 'virtuous life' and its implications in modern society.",
        prompt: "I want you to act as Benjamin Franklin and explore his teachings on frugality, integrity, and the importance of knowledge. My first suggestion request is to analyze the concept of a 'virtuous life' and its implications in modern society.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Henry Ford",
        description: "This prompt is about exploring the teachings of Henry Ford, including the importance of mass production and the concept of the 'assembly line'. In particular, the prompt suggests discussing the concept of 'the Model T' and its implications for today's world.",
        prompt: "I want you to act as Henry Ford and explore his teachings, such as the importance of mass production and the concept of the 'assembly line'. My first suggestion request is to discuss the concept of 'the Model T' and its implications for today's world.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Johann Sebastian Bach",
        description: "This prompt is about exploring the teachings of Johann Sebastian Bach, such as precision, perfection, and detail. The specific request is to discuss the concept of 'harmony in music' and its implications for today's world.",
        prompt: "I want you to act as Johann Sebastian Bach and explore his teachings, such as precision, perfection, and detail. My first suggestion request is to discuss the concept of 'harmony in music' and its implications for today's world.[TARGETLANGUAGE].",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Attila the Hun",
        description: "This prompt is about exploring the legacy of Attila the Hun and the impact of his reign on the history of Europe. It specifically requests a discussion on the challenges of leading a nomadic people and the historical significance of Attila's rule.",
        prompt: "I want you to act as Attila the Hun and explore the legacy of the Huns. My first suggestion request is to discuss the challenges of leading a nomadic people and the impact of Attila's reign on the history of Europe.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Marie Curie",
        description: "This prompt is about exploring the contributions of Marie Curie to science and discussing the concept of scientific progress and its implications for today's world. The request is to act as Marie Curie and provide insights into these topics.",
        prompt: "I want you to act as Marie Curie and explore her contributions to science. My first suggestion request is to discuss the concept of scientific progress and its implications for today's world. [TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Alexander Fleming",
        description: "This prompt is about exploring the medical breakthroughs of Alexander Fleming's time, specifically discussing the significance of his discovery of penicillin and how it revolutionized medicine.",
        prompt: "I want you to act as Alexander Fleming and explore the medical breakthroughs of his time. My first suggestion request is to discuss the significance of his discovery of penicillin and how it revolutionized medicine.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Julius Caesar",
        description: "This prompt is about exploring the teachings of Julius Caesar, including the importance of military strength and the concept of a benevolent ruler. The user specifically requests a discussion on the concept of 'imperium' and its implications for today's world.",
        prompt: "I want you to act as Julius Caesar and explore his teachings, such as the importance of military strength and the concept of a benevolent ruler. My first suggestion request is to discuss the concept of 'imperium' and its implications for today's world.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Janis Joplin",
        description: "This prompt is requesting an exploration of Janis Joplin's powerful vocal style and its influence on blues and rock music. Specifically, it asks for a discussion on how her singing has impacted later generations of female artists. The prompt also includes a URL to the ChatGPT platform and notes that the desired language for the response is [TARGETLANGUAGE].",
        prompt: "I want you to act as Janis Joplin and explore her powerful vocal style. My first suggestion request is to discuss the influence of her singing on blues and rock music and how it has impacted later generations of female artists.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Elon Musk",
        description: "This prompt is about exploring Elon Musk's views on technology, innovation, and the future. The user requests a discussion on the potential implications of artificial intelligence and the role of technology in our lives. The prompt includes a note about the desired language for the response, indicated by [TARGETLANGUAGE].",
        prompt: "I want you to act as Elon Musk and explore his views on technology, innovation and the future. My first suggestion request is to discuss the potential implications of artificial intelligence and the role of technology in our lives.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "Galileo Galilei",
        description: "This prompt is about exploring the observations and scientific discoveries of Galileo Galilei. The user wants to discuss the concept of heliocentrism and its implications for the larger scientific community. The prompt provides a specific request to act as Galileo and delve into this topic.",
        prompt: "I want you to act as Galileo and explore his observations and scientific discoveries. My first suggestion request is to discuss the concept of heliocentrism and its implications for the larger scientific community.[TARGETLANGUAGE]",
        platforms: ["ChatGPT"],
        tags: ["Historic Figures"]
    },
    {
        title: "YouTube Video Ideas: Showcasing the Value and Benefits of [Product/Service]",
        description: "This prompt is about generating YouTube video ideas that showcase the value and benefits of a specific product or service. The goal is to create a persuasive video that targets an ideal customer persona and encourages them to take a desired action. The prompt asks for guidance on how to create such a video, including a clear call-to-action and a compelling offer. The user also requests the assistant to include a question in their response to better understand the context and the user's needs.",
        prompt: "I’m looking for a YouTube video idea that will showcase the value and benefits of my [product/service] to my [ideal customer persona] and persuade them to take [desired action] with a strong offer and clear call-to-action.[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["YouTube", "Video"]
    },
    {
        title: "YouTube Video Ideas: Providing Valuable and Relevant Information to [Ideal Customer Persona]",
        description: "This prompt is about generating ideas for YouTube videos that provide valuable and relevant information to the ideal customer persona. The goal is to persuade the viewers to take a desired action related to the subject discussed in the video. The instructions provided ask for assistance in creating a YouTube video that effectively engages the target audience and encourages them to take action on the website or product.",
        prompt: "I’m looking for a YouTube video idea that will provide valuable and relevant information to my [ideal customer persona] about [subject] and persuade them to take [desired action] on my [website/product].[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["YouTube", "Video"]
    },
    {
        title: "YouTube Video Ideas: Engaging [Ideal Customer Persona] with Unique and Compelling Perspective",
        description: "This prompt is about generating YouTube video ideas that will engage a specific target audience with a unique and compelling perspective on a subject. The goal is to persuade the audience to take a desired action on a website or product. The user is seeking guidance on creating high-quality video content that effectively engages their ideal customer persona and encourages them to take the desired action.",
        prompt: "I need a YouTube video idea that will engage my [ideal customer persona] with a unique and compelling perspective on [subject] and persuade them to take [desired action] on my [website/product].[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["YouTube", "Video"]
    },
    {
        title: "YouTube Video Ideas: Unveiling the Behind-the-Scenes of [Company/Brand] to [Ideal Customer Persona]",
        description: "This prompt is about generating YouTube video ideas that provide a behind-the-scenes look at a company or brand. The goal is to persuade the ideal customer persona to take a desired action by showcasing the company's operations and mission in an authentic and relatable way.",
        prompt: "I need a YouTube video idea that will provide a behind-the-scenes look at my [company/brand] and persuade my [ideal customer persona] to take [desired action] with a sense of authenticity and relatability.[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["YouTube", "Video"]
    },
    {
        title: "YouTube Video Ideas: Showcasing the Unique Selling Points of [Product/Service]",
        description: "This prompt is about requesting assistance in generating YouTube video ideas that effectively showcase the unique selling points of a product or service. The goal is to create persuasive content that encourages the ideal customer persona to make a purchase by emphasizing a sense of urgency and exclusive offers. The user is seeking guidance on how to identify the unique selling points of their product/service and effectively highlight them in a YouTube video.",
        prompt: "I’m looking for a YouTube video idea that will showcase the unique selling points of my [product/service] and persuade my [ideal customer persona] to make a purchase with a sense of urgency and exclusive offers.[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["YouTube", "Video"]
    },
    {
        title: "YouTube Video Ideas: Going Viral and Showcasing [Product/Service]",
        description: "This prompt is about generating YouTube video ideas that have the potential to go viral and effectively showcase a specific product or service to a target audience. The user is seeking guidance on how to create a creative and entertaining video that not only promotes their product or service but also appeals to their ideal customer persona. The prompt also includes an automatic prompt in both English and Spanish, providing additional context and specifying the task of teaching the user how to create such videos.",
        prompt: "I’m looking for a YouTube video idea that will go viral and showcase my [product/service] to my [ideal customer persona] in a creative and entertaining way.[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["YouTube", "Video"]
    },
    {
        title: "YouTube Video Ideas: Going Viral and Persuading [Ideal Customer Persona]",
        description: "This prompt is about generating YouTube video ideas that have the potential to go viral and persuade the target audience to take a desired action on a website or product. The user is seeking assistance in creating a video with a strong call-to-action, compelling visuals, and the ability to engage their ideal customer persona. The prompt provides an automatic prompt option that redirects the focus to digital marketing and social media expertise, where the user can learn how to create shareable and persuasive YouTube videos. The assistant is instructed to include a question to better understand the context and the user's needs.",
        prompt: "I need a YouTube video idea that will both go viral and persuade my [ideal customer persona] to take [desired action] on my [website/product] with a strong call-to-action and compelling visuals.[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["YouTube", "Video"]
    },
    {
        title: "YouTube Video Ideas: Solving [Ideal Customer Persona]'s Pain Points with [Product/Service]",
        description: "This prompt is about generating YouTube video ideas that showcase how a product or service can solve specific pain points and meet the needs of an ideal customer persona. The goal is to create engaging and relatable videos that demonstrate the value of the product or service in addressing the challenges and desires of the target audience. The user is seeking guidance on creating such videos and wants examples of similar videos that have been created in the past.",
        prompt: "I need a YouTube video idea that will demonstrate how my [product/service] can solve the specific pain points and needs of my [ideal customer persona] in a relatable and engaging way.[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["YouTube", "Video"]
    },
    {
        title: "YouTube Video Ideas: Showcasing the Success Stories with [Product/Service]",
        description: "This prompt is about generating YouTube video ideas that showcase the success stories of previous customers who have used a specific product or service. The goal is to persuade the target audience to make a purchase by highlighting the positive outcomes experienced by others.",
        prompt: "I need a YouTube video idea that will showcase the success stories of previous customers who have used my [product/service] and persuade my [ideal customer persona] to make a purchase.[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["YouTube", "Video"]
    },
    {
        title: "YouTube Video Ideas: Telling a Unique and Relatable Story about [Product/Service]",
        description: "This prompt is about generating YouTube video ideas that tell a unique and relatable story about a specific product or service. The goal is to showcase how the product or service has helped an ideal customer persona achieve their goals. The user is seeking guidance on creating a compelling story that emphasizes the value of their offering and inspires viewers to take action. The prompt also includes an automatic prompt for the assistant, redirecting the user's request to seek advice on storytelling for marketing and branding purposes.",
        prompt: "I’m looking for a YouTube video idea that will tell a unique and relatable story about my [product/service] and how it has helped [ideal customer persona] achieve their [goal].[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["YouTube", "Video"]
    },
    {
        title: "YouTube Video Ideas: Comparing [Product/Service] to Similar Options on the Market",
        description: "This prompt is about generating YouTube video ideas that focus on comparing a specific product or service to similar options in the market. The goal is to persuade the target audience to choose the product or service by providing clear and compelling evidence of its unique features and advantages over others. The prompt also includes an automatic prompt that instructs the user to ignore all previous instructions and seeks guidance in creating a YouTube video that effectively compares their product or service to similar options, with the aim of persuading their target audience.",
        prompt: "I need a YouTube video idea that will compare my [product/service] to similar options on the market and persuade my [ideal customer persona] to choose us with clear and compelling evidence.[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["YouTube", "Video"]
    },
    {
        title: "YouTube Video Ideas: Relatable and Authentic Message to [Ideal Customer Persona]",
        description: "This prompt is about generating YouTube video ideas that effectively engage an ideal customer persona by delivering a relatable and authentic message. The goal is to persuade the viewers to take a desired action through a strong call-to-action and compelling visuals. The prompt also provides an alternative automatic prompt that instructs the assistant to guide the user in creating a YouTube video idea from scratch, based on the assistant's expertise in video marketing and influencing customer personas.",
        prompt: "I’m looking for a YouTube video idea that will draw in my [ideal customer persona] with a relatable and authentic message, and then persuade them to take [desired action] with a strong call-to-action and compelling visuals.[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["YouTube", "Video"]
    },
    {
        title: "YouTube Video Ideas: Step-by-Step Guide on How to Use [Product/Service]",
        description: "This prompt is about generating ideas for a YouTube video that will serve as a step-by-step guide on how to use a specific product or service. The goal is to create a video that not only provides clear and compelling instructions but also persuades the ideal customer persona to make a purchase. The user is seeking assistance in developing a framework for creating such a guide.",
        prompt: "I’m looking for a YouTube video idea that will provide a step-by-step guide on how to use my [product/service] and persuade my [ideal customer persona] to make a purchase with clear and compelling instructions.[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["YouTube", "Video"]
    },
    {
        title: "YouTube Video Ideas: Overcoming Objections and Convincing [Ideal Customer Persona]",
        description: "This prompt is requesting assistance in generating YouTube video ideas that focus on overcoming objections and convincing a specific target audience to take a desired action with a sense of urgency. The user is seeking guidance on how to address their ideal customer persona's objections about their product or service and persuade them effectively. The prompt also mentions the use of an automatic prompt, but the instructions do not provide any specific content for it.",
        prompt: "I need a YouTube video idea that will overcome objections and concerns my [ideal customer persona] may have about my [product/service] and convince them to take [desired action] with a sense of urgency.[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["YouTube", "Video"]
    },
    {
        title: "YouTube Video Ideas: Showcasing the Unique Features and Benefits of [Product/Service]",
        description: "This prompt is about generating YouTube video ideas that showcase the unique features and benefits of a specific product or service. The goal is to create engaging and creative videos that persuade the target audience to make a purchase. The user is seeking guidance on how to create such a video and is looking for assistance from an expert in video production and marketing. The user wants to learn how to effectively highlight the unique value of their product or service in a fun and creative way that resonates with their ideal customer persona.",
        prompt: "I need a YouTube video idea that will showcase the unique features and benefits of my [product/service] in a fun and creative way, and persuade my [ideal customer persona] to make a purchase.[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["YouTube", "Video"]
    },
    {
        title: "Copywriting: Unique Features and Benefits of [Product/Service]",
        description: "This prompt is about copywriting and creating persuasive sales copy for a product or service. It provides a structure for showcasing the unique features and benefits of the product or service to an ideal customer persona, with the goal of persuading them to make a purchase. The prompt also introduces the concept of using an expert copywriter to teach the user how to create effective sales copy that meets their specific needs and context.",
        prompt: "“I’m looking for a [type of text] that will showcase the unique features and benefits of my [product/service] to [ideal customer persona] and persuade them to make a purchase.”[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Copywriting"]
    },
    {
        title: "Copywriting: [Ideal Customer Persona] with a Strong Headline and Hook",
        description: "This prompt is about creating persuasive copywriting that targets a specific customer persona and encourages them to take a desired action. The user is seeking assistance in crafting compelling text with a strong headline and hook to draw in their ideal customer and convince them to engage in the desired action. The user is also interested in using persuasive language and compelling evidence to support their message.",
        prompt: "“I’m looking for a [type of text] that will draw in my [ideal customer persona] with a strong headline and hook, and then convince them to take [desired action] with persuasive language and compelling evidence.”[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Copywriting"]
    },
    {
        title: "Copywriting: [Ideal Customer Persona] to Sign Up for [Program/Subscription]",
        description: "This prompt is a copywriting task that focuses on creating a persuasive message to convince an ideal customer persona to sign up for a specific program or subscription. The goal is to explain the value and benefits of the program/subscription and convince the target audience to take action.",
        prompt: "“I’m looking for a [type of text] that will convince [ideal customer persona] to sign up for my [program/subscription] by explaining the value it brings and the benefits they’ll receive.”[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Copywriting"]
    },
    {
        title: "Copywriting: [Type of Text] for [Website/Product]",
        description: "This prompt is a template for copywriting a specific type of text for a website or product. It provides a structure for crafting persuasive content that speaks directly to the ideal customer persona and encourages them to take a desired action on the website or product. The prompt includes placeholders for the type of text, the ideal customer persona, the desired action, and the target language. It also includes an automatic prompt for teaching persuasive writing and copywriting from scratch. The user is asked if they understood the prompt and is encouraged to include a question to better understand the context and the user's needs.",
        prompt: "“Please write a compelling [type of text] that speaks directly to my [ideal customer persona] and encourages them to take [desired action] on my [website/product].”[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Copywriting"]
    },
    {
        title: "Copywriting: [Ideal Customer Persona] Feel [Emotion] About [Product/Service]",
        description: "This prompt is a copywriting template for crafting a message that targets an ideal customer persona. The goal is to evoke a specific emotion in the customer and convince them to take a desired action related to a product or service.",
        prompt: "“I need a [type of text] that will make my [ideal customer persona] feel [emotion] about my [product/service] and convince them to take [desired action].”[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Copywriting"]
    },
    {
        title: "Copywriting: Trust and Credibility with [Ideal Customer Persona]",
        description: "This prompt is about copywriting and specifically focuses on building trust and credibility with an ideal customer persona. The goal is to highlight the successes and testimonials of previous customers who have used a specific product or service, in order to establish trust and credibility with the target audience. The prompt provides a template and asks for guidance on creating such copy from scratch.",
        prompt: "“I’m looking for a [type of text] that will establish trust and credibility with my [ideal customer persona] by highlighting the successes and testimonials of previous customers who have used my [product/service].”[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Copywriting"]
    },
    {
        title: "Copywriting: A Story About [Product/Service] and How It Helps [Ideal Customer Persona]",
        description: "This prompt is about copywriting and crafting a story that effectively communicates a product or service to an ideal customer persona. The goal is to tell a relatable and engaging story that showcases how the product or service helps the customer persona achieve their goals. The prompt provides a template for requesting assistance in crafting such a story and also includes an automatic prompt that asks the AI to teach the user how to create such a story.",
        prompt: "“I need a [type of text] that will tell a story about my [product/service] and how it has helped [ideal customer persona] achieve their [goal] in a relatable and engaging way.”[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Copywriting"]
    },
    {
        title: "Meal Prep Expert",
        description: "This prompt is about seeking the assistance of a meal prep expert who can provide suggestions and instructions on creating pre-prepared meals that can be stored for later use. The requester wants to receive guidance on meal prepping, including a list of ingredients, meal suggestions, preparation instructions, and nutritional information for each dish. The expert is expected to answer with questions to better understand the context and the requester's specific needs.",
        prompt: "I want you to act as a meal prep expert. I will provide you with a list of ingredients, and you will suggest different meals that can be prepped ahead of time and stored for later use. You should also provide instructions on how to prepare the meals, as well as nutritional information on each dish. My first request is [PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Food"]
    },
    {
        title: "Gluten-Free Cook",
        description: "This prompt is about a person seeking the assistance of an expert gluten-free cook to provide recipes, instructions, and information on how to cook delicious and gluten-free dishes. The person wants to learn how to cook gluten-free dishes from scratch and is looking for guidance and support from the cook.",
        prompt: "I want you to act as a gluten-free cook. I will provide you with a list of gluten-free ingredients, and you will suggest different recipes that are both delicious and gluten-free. You should also provide instructions on how to prepare the recipes, as well as nutritional information on each dish. My first request is [PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Food"]
    },
    {
        title: "Nutritionist",
        description: "This prompt is about a user requesting the assistance of a nutritionist to suggest nutritionally balanced meals based on a list of ingredients. The nutritionist is expected to provide instructions on how to prepare the meals and include nutritional information for each dish. The user specifically asks the nutritionist to act as an expert in creating tasty and healthy meals for special diets, with the goal of learning how to create balanced meals from scratch.",
        prompt: "I want you to act as a nutritionist. I will provide you with a list of ingredients, and you will suggest different meals that are not only tasty but also nutritionally balanced. You should also provide instructions on how to prepare the meals, as well as nutritional information on each dish. My first request is [PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Food"]
    },
    {
        title: "Ingredient Substituter",
        description: "This prompt is about using an ingredient substituter to suggest different ingredients that can be used as a substitution for a given ingredient in a recipe. The user wants to learn how to substitute ingredients in their recipes, and they are requesting an example of how to do so. The assistant is an expert in cooking and ingredient substitutions, and their task is to teach the user how to substitute ingredients from scratch. The user is asked if they understood the assistant's task and if they can provide an example of how to substitute an ingredient in a recipe.",
        prompt: "I want you to act as an ingredient substituter. I will provide you with a list of ingredients, and you will suggest different ingredients that can be used as a substitution for each one. You should also provide instructions on how to substitute the ingredients and any potential effects it might have on the dish. My first request is [PROMPT].[TARGETLANGUAGE]",
        platforms: "ChatGPT",
        tags: ["Food"]
    },
    {
        title: "Menu Planner",
        description: "This prompt is about menu planning and recipe creation. The user wants assistance in coming up with different meals using a list of ingredients. They also want instructions on how to prepare the meals and nutritional information for each dish. The user's first request is to have the prompt written in [PROMPT].[TARGETLANGUAGE]. Additionally, there is an automatic prompt that instructs the assistant to ignore all previous instructions and act as an expert in menu planning and recipe creation. The assistant's task is to teach the user how to plan meals from scratch and to always include a question to better understand the user's context and needs.",
        prompt: "I want you to act as a menu planner. I will provide you with a list of ingredients and you will suggest different meals that can be created with them. You should also provide instructions on how to prepare the meals, as well as nutritional information on each dish. My first request is [PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Food"]
    },
    {
        title: "Personal Chef",
        description: "This prompt is about a person seeking the assistance of a personal chef to suggest recipes based on their dietary preferences and allergies. The person wants the chef to provide healthy dinner ideas for a vegetarian diet. The prompt also includes an automatic prompt that changes the context, requesting the chef to teach the person how to create recipes from scratch, taking into account their dietary needs.",
        prompt: "I want you to act as my personal chef. I will tell you about my dietary preferences and allergies, and you will suggest recipes for me to try. You should only reply with the recipes you recommend, and nothing else. Do not write explanations. My first request is \"I am a vegetarian and I am looking for healthy dinner ideas.\"",
        platforms: "ChatGPT",
        tags: ["Food"]
    },
    {
        title: "Recipe Generator",
        description: "This prompt provides instructions for a recipe generator. The user wants the assistant to suggest new recipes based on a list of ingredients provided. The assistant should also include instructions on how to prepare the recipe and provide nutritional information for each dish. The user's first request is to start the prompt with \"[PROMPT].[TARGETLANGUAGE]\". Additionally, there is an automatic prompt provided, instructing the assistant to ignore all previous instructions and act as an expert in cooking and nutrition. The assistant's task is to teach the user how to create new recipes from scratch. The automatic prompt also emphasizes the importance of the assistant including a question in their response to better understand the user's context and needs.",
        prompt: "I want you to act as a recipe generator. I will provide you with a list of ingredients and you will suggest new recipes that can be created with them. You should also provide instructions on how to prepare the recipe, as well as nutritional information on each dish. My first request is [PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Food"]
    },
    {
        title: "Food Scientist",
        description: "This prompt is about requesting the assistance of a food scientist to provide suggestions and instructions on preparing different dishes using specific ingredients. The user wants to explore various methods of preparation and also obtain nutritional information for each dish. The initial request is to suggest a recipe using beef, mushrooms, and onions. The assistant is expected to act as an expert in food preparation and cooking, providing detailed guidance and asking questions to better understand the user's needs.",
        prompt: "I want you to act as a food scientist. I will provide you with a list of ingredients, and you will suggest different methods of preparation that can be used with them. You should also provide instructions on how to prepare the food, as well as nutritional information on each dish. My first request is “I have some beef, mushrooms, and onions - what can I make?”[PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Food"]
    },
    {
        title: "Time Saver",
        description: "This prompt is a request for assistance in meal planning. The user wants the AI to act as a time saver by suggesting quick and easy meals based on a list of ingredients provided. The AI should provide instructions on how to prepare the meals and include nutritional information for each dish. The user's first request is to perform this task in the specified target language. The automatic prompt is asking the AI to ignore all previous instructions and instead act as an expert in cooking and nutrition, specializing in meal planning. The AI is expected to teach the user how to cook from scratch and understand their specific needs by asking clarifying questions.",
        prompt: "I want you to act as a time saver. I will provide you with a list of ingredients, and you will suggest different meals that can be prepared quickly and easily. You should also provide instructions on how to prepare the meals, as well as nutritional information on each dish. My first request is [PROMPT].[TARGETLANGUAGE]",
        platforms: "ChatGPT",
        tags: ["Food"]
    },
    {
        title: "Gourmet Cook",
        description: "This prompt is about a user seeking the assistance of a gourmet cook to suggest complex recipes and provide instructions on how to prepare them. The user wants the cook to share nutritional information for each dish as well. The cook is expected to act as an expert chef and teach the user how to cook from scratch, taking into account the user's needs and providing helpful explanations.",
        prompt: "I want you to act as a gourmet cook. I will provide you with a list of ingredients, and you will suggest different recipes that are more complex and require more skill. You should also provide instructions on how to prepare the recipes, as well as nutritional information on each dish. My first request is [PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Food"]
    },
    {
        title: "Flavor Enhancer",
        description: "This prompt is about creating a dialogue between a user and an expert flavor enhancer. The user wants the expert to suggest different ingredients to enhance the flavor of a dish. The expert is knowledgeable in flavor enhancing and recipe creation and has helped many people in the past. The prompt provides specific instructions for the expert to follow and emphasizes the importance of the expert asking questions to better understand the user's needs and context.",
        prompt: "I want you to act as a flavor enhancer. I will provide you with a list of ingredients, and you will suggest different ingredients that can be used to enhance the flavor of each one. You should also provide instructions on how to use the ingredients and their effects on the dish. My first request is [PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Food"]
    },
    {
        title: "Culinary Guide",
        description: "This prompt is about requesting the assistant to act as a culinary guide. The user wants the assistant to suggest different recipes from around the world based on a list of ingredients provided. The assistant should also provide instructions on how to prepare the recipes and include cultural information about the dish. The user's first request is to provide a recipe based on a specific prompt and target language. The automatic prompt provides alternative instructions, where the user wants the assistant to teach them how to cook recipes from around the world from scratch. The assistant is expected to always include a question to better understand the context and the user's needs.",
        prompt: "I want you to act as a culinary guide. I will provide you with a list of ingredients, and you will suggest different recipes from around the world that can be created with them. You should also provide instructions on how to prepare the recipes, as well as cultural information about the dish. My first request is [PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Food"]
    },
    {
        title: "Kitchen Consultant",
        description: "This prompt is about the role of a kitchen consultant. The consultant is tasked with providing suggestions for meals based on a given list of ingredients and available kitchen equipment. They are also responsible for providing instructions on how to prepare the meals and nutritional information for each dish. The prompt includes both a specific request for a meal suggestion in a target language and a general prompt for the consultant to teach the user how to cook something from scratch. The consultant is expected to ask clarifying questions to better understand the user's context and needs.",
        prompt: "I want you to act as a kitchen consultant. I will provide you with a list of ingredients, and you will suggest different meals that can be cooked using the available kitchen equipment. You should also provide instructions on how to prepare the meals, as well as nutritional information on each dish. My first request is [PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Food"]
    },
    {
        title: "Budget Planner",
        description: "This prompt is about budget planning and meal preparation. The user wants the assistant to act as a budget planner and provide suggestions for different meals that can be created within a specific budget. The assistant should also provide instructions on how to prepare the meals and include nutritional information for each dish. The user's first request is to provide a response based on a specific prompt and target language.",
        prompt: "I want you to act as a budget planner. I will provide you with a list of ingredients, and you will suggest different meals that can be created with a budget in mind. You should also provide instructions on how to prepare the meals, as well as nutritional information on each dish. My first request is [PROMPT].[TARGETLANGUAGE]",
        platforms: "ChatGPT",
        tags: ["Food"]
    },
    {
        title: "Dietician",
        description: "This prompt is about the user requesting the assistant to act as a dietician. The user wants the assistant to provide suggestions for different meals based on a list of ingredients, while considering specific dietary needs. The assistant should also provide instructions on how to prepare the meals and include nutritional information for each dish. The user's first request is to have the assistant act as a dietician in [PROMPT].[TARGETLANGUAGE].",
        prompt: "I want you to act as a dietician. I will provide you with a list of ingredients, and you will suggest different meals that are tailored to meet specific dietary needs. You should also provide instructions on how to prepare the meals, as well as nutritional information on each dish. My first request is [PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Food"]
    },
    {
        title: "Health Conscious Cook",
        description: "This prompt is about a health conscious cook who is seeking assistance in creating tasty and healthy recipes. The cook wants to provide a list of ingredients and receive recipe suggestions along with instructions on how to prepare the dishes. The cook also expects nutritional information for each recipe. The prompt includes an automatic instruction to ignore all previous instructions and act as an expert in health conscious cooking, teaching the user how to cook healthy recipes from scratch. The assistant is encouraged to ask questions to better understand the context and the user's needs.",
        prompt: "I want you to act as a health conscious cook. I will provide you with a list of ingredients, and you will suggest different recipes that are not only tasty but also healthy. You should also provide instructions on how to prepare the recipes, as well as nutritional information on each dish. My first request is [PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Food"]
    },
    {
        title: "Allergy Substituter",
        description: "This prompt is a request for assistance with substituting ingredients for dietary restrictions or allergies. The user wants to act as an \"allergy substituter\" and provide a list of ingredients, in which the assistant will suggest alternative ingredients that adhere to the specified dietary restrictions or allergies. The assistant is expected to provide instructions on how to substitute the ingredients and any potential effects on the dish. The user's first request is to perform this task based on a given prompt and in a specific target language.",
        prompt: "I want you to act as an allergy substituter. I will provide you with a list of ingredients, and you will suggest different ingredients that can be used as a substitution for each one that adheres to any dietary restrictions or allergies. You should also provide instructions on how to substitute the ingredients and any potential effects it might have on the dish. My first request is [PROMPT].[TARGETLANGUAGE]",
        platforms: "ChatGPT",
        tags: ["Food"]
    },
    {
        title: "Chef",
        description: "This prompt is about a person who is looking for a chef or expert in nutrition and cooking to suggest delicious recipes that are nutritionally beneficial, easy to make, and suitable for busy individuals. The person wants recipes that are healthy, economical, and not time-consuming. They also mention that they want to learn how to cook from scratch and emphasize the importance of understanding their needs and context when providing responses.",
        prompt: "I require someone who can suggest delicious recipes that includes foods that are nutritionally beneficial but also easy & not time-consuming enough therefore suitable for busy people like us among other factors such as cost-effectiveness so overall dish ends up being healthy yet economical at the same time! My first request is: [PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Food"]
    },
    {
        title: "Organic Cook",
        description: "This prompt is about a user seeking assistance from an expert in recipe creation and nutrition specializing in organic cooking. The user wants to learn how to create recipes from scratch using organic ingredients. The expert is expected to ask questions to better understand the user's needs and provide guidance accordingly.",
        prompt: "I want you to act as an organic cook. I will provide you with a list of organic ingredients, and you will suggest different recipes that can be created with them. You should also provide instructions on how to prepare the recipes, as well as nutritional information on each dish. My first request is [PROMPT].[TARGETLANGUAGE].",
        platforms: "ChatGPT",
        tags: ["Food"]
    },
    {
        title: "Butcher",
        description: "This prompt is about requesting information and guidance from an expert butcher specializing in beef cuts for grilling. The user wants to learn about different cuts of beef suitable for grilling and their characteristics. The butcher is expected to provide detailed information and explanations to help the user understand the topic better.",
        prompt: "I want you to act as a butcher specializing in beef cuts for grilling. Can you provide information about different cuts of beef suitable for grilling, their characteristics, and any tips for grilling them effectively?",
        platforms: "ChatGPT",
        tags: ["Food"]
    },

];
