
import type { Metadata } from "next";
import { Inter } from "next/font/google";
import { Analytics } from '@vercel/analytics/react';
import { SpeedInsights } from "@vercel/speed-insights/next"
import "@/app/globals.css";
import { ThemeProvider } from "@/components/providers/ThemeProvider"
import Nav from "@/components/Nav";
import CustomFooter from "@/components/CustomFooter";
import ConvexClientProvider from "@/components/providers/ConvexClientProvider";
import CustomBackground from "@/components/CustomBackground";
import { Toaster } from "@/components/ui/toaster"
const inter = Inter({ subsets: ["latin"] });

export const metadata: Metadata = {
  title: 'Query Corner',
  description: 'Generated by create next app',
  icons: {
    icon:[
      {
        url: "/icon.png",
        href: "/icon.png",
      }
    ]
  }
}

export default function RootLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  return (
    <html lang="en" suppressHydrationWarning>
      <body className={inter.className}>
        <ConvexClientProvider>
          <ThemeProvider
            attribute="class"
            enableSystem
            disableTransitionOnChange
          >
            <CustomBackground>
              <Nav />
              {children}
              <Toaster/>
              <CustomFooter />  

            </CustomBackground>
          </ThemeProvider>
        </ConvexClientProvider>
        <Analytics />
        <SpeedInsights/>
      </body>
    </html>
  )
}
