# Things Cats Cannot Eat

Cats have specific dietary needs, and some human foods can be harmful or even toxic to them. Here are some common foods that should **never** be given to cats:

## 1. Onions, Garlic, and Chives

All forms of onion, garlic, and chives—whether raw, cooked, or powdered can damage a cat's red blood cells, leading to anemia. Even small amounts can cause severe illness over time.

::: danger
**Toxic Effect:** Hemolytic anemia  
**Source:** [PDSA - Onion and Garlic Poisoning in Cats](https://www.pdsa.org.uk/pet-help-and-advice/pet-health-hub/other-veterinary-advice/onion-and-garlic-poisoning-in-cats)
:::

## 2. Chocolate

Chocolate contains substances called theobromine and caffeine, which are highly toxic to cats. These can cause abnormal heart rhythms, muscle tremors, and even seizures.

::: danger
**Toxic Effect:** Heart arrhythmias, muscle tremors, seizures  
**Source:** [Brookhaven Vets - Is Chocolate Dangerous For Cats](https://www.brookhavenanimalhosp.com/site/blog/2022/06/15/is-chocolate-dangerous-for-cats)
:::

## 3. Alcohol

Even small amounts of alcohol can cause severe health issues in cats, such as vomiting, disorientation, respiratory distress, and in severe cases, coma or death.

::: danger
**Toxic Effect:** Respiratory distress, coma  
**Source:** [Vetster - Alcohol Poisoning in Cats](https://vetster.com/en/conditions/cat/alcohol-poisoning)
:::

## 4. Grapes and Raisins

Although the exact substance in grapes and raisins that harms cats is unknown, these fruits can cause kidney failure, leading to symptoms like vomiting, lethargy, and increased urination.

::: danger
**Toxic Effect:** Kidney failure  
**Source:** [Joii Pet Care - Grape and Raisin Poisoning in Cats](https://www.joiipetcare.com/health-conditions/cat/grape-and-raisin-poisoning/)
:::

## 5. Xylitol (Artificial Sweetener)

Xylitol is an artificial sweetener found in sugar-free gum, candies, and some peanut butters. While it is primarily dangerous to dogs, it can also cause a dangerous drop in blood sugar and liver damage in cats.

::: warning
**Toxic Effect:** Hypoglycemia, liver failure  
**Source:** [PureForm Pet Health - Xylitol Poisoning](https://pureformpethealth.com/blogs/pureform-pet-care/xylitol-poisoning-dogs-cats)
:::

## 6. Raw Eggs and Fish

Raw eggs can contain bacteria like Salmonella, and raw fish can destroy thiamine, an essential B-vitamin, leading to neurological issues in cats.

::: warning
**Toxic Effect:** Neurological issues due to thiamine deficiency  
**Source:** [PetMD - Can Cats Eat Eggs?](https://www.petmd.com/cat/nutrition/can-cats-eat-eggs)
:::

## 7. Dairy Products

Most adult cats are lactose intolerant, meaning they cannot properly digest dairy products like milk and cheese. Consuming these can lead to digestive upset, including diarrhea and cramps.

::: warning
**Toxic Effect:** Digestive upset (diarrhea, cramps)  
**Source:** [James Wellbeloved - Can cats have dairy?](https://wellbeloved.com/blogs/caring-for-cats/can-cats-have-dairy)
:::

## Conclusion

Many common human foods are dangerous for cats, and it’s important to be aware of what’s safe and what’s not. If your cat consumes any of these harmful foods, contact your veterinarian immediately.

## References

1. PDSA. (n.d.). *Onion and Garlic Poisoning in Cats*. Retrieved from [https://www.pdsa.org.uk/pet-help-and-advice/pet-health-hub/other-veterinary-advice/onion-and-garlic-poisoning-in-cats](https://www.pdsa.org.uk/pet-help-and-advice/pet-health-hub/other-veterinary-advice/onion-and-garlic-poisoning-in-cats)

2. Brookhaven Vets. (2022, June 15). *Is Chocolate Dangerous For Cats?* Retrieved from [https://www.brookhavenanimalhosp.com/site/blog/2022/06/15/is-chocolate-dangerous-for-cats](https://www.brookhavenanimalhosp.com/site/blog/2022/06/15/is-chocolate-dangerous-for-cats)

3. Vetster. (n.d.). *Alcohol Poisoning in Cats*. Retrieved from [https://vetster.com/en/conditions/cat/alcohol-poisoning](https://vetster.com/en/conditions/cat/alcohol-poisoning)

4. Joii Pet Care. (n.d.). *Grape and Raisin Poisoning in Cats*. Retrieved from [https://www.joiipetcare.com/health-conditions/cat/grape-and-raisin-poisoning/](https://www.joiipetcare.com/health-conditions/cat/grape-and-raisin-poisoning/)

5. PureForm Pet Health. (n.d.). *Xylitol Poisoning*. Retrieved from [https://pureformpethealth.com/blogs/pureform-pet-care/xylitol-poisoning-dogs-cats](https://pureformpethealth.com/blogs/pureform-pet-care/xylitol-poisoning-dogs-cats)

6. PetMD. (n.d.). *Can Cats Eat Eggs?* Retrieved from [https://www.petmd.com/cat/nutrition/can-cats-eat-eggs](https://www.petmd.com/cat/nutrition/can-cats-eat-eggs)

7. James Wellbeloved. (n.d.). *Can cats have dairy?* Retrieved from [https://wellbeloved.com/blogs/caring-for-cats/can-cats-have-dairy](https://wellbeloved.com/blogs/caring-for-cats/can-cats-have-dairy)

