# Welcome to Cat Docs - An Open-Source Project Documenting Cats!

The idea of this project is to combine all the information related to cats into one website - whether it be about tips for owning a cat as a pet, learning cat history, all cat products, you name it.

Feel free to contribute and create new issues for any feedback, or questions you have! This is a project about everything and anything related to cats, so feel free to explore!

### For Beginners

- Feel free to open new issues and comment on existing ones if you want to take on tasks. Help is always welcomed!

Thanks for visiting Cat Docs!


## 🌈 Contribution Guidelines:

### Getting Started

Set up the project locally by following these steps:

1. **Fork the Repository**:
   - Click the "Fork" button at the top-right corner of the repository page to create a copy of the repository under your own GitHub account.

2. **Clone Your Fork**:
   - Clone the forked repository to your local machine using the following command:
     ```bash
     git clone https://github.com/your-username/cat-docs.git
     ```
     Replace `your-username` with your GitHub username.

3. **Navigate to the Project Directory**:
   ```bash
   cd cat-docs
   ```

4. **Install Dependencies**:
   - Install the required dependencies using the package manager of your choice. For example, with npm:
     ```bash
     npm install
     ```

5. **Run the Project**:
   - Start the project using the VitePress command to ensure everything is working correctly:
     ```bash
     npm run docs:dev
     ```

### Contributing

1. **Browse the Issues**:
   - Look through the [issues](https://github.com/SanditZZ/cat-docs/issues) to find one that interests you. Comment on the issue to let the maintainers know you'd like to work on it. The issue will then be assigned to you.

2. **Create a Branch**:
   - Create a new branch for your work. Use a descriptive name that relates to the issue you're addressing. For example:
     ```bash
     git checkout -b issue-123-add-cat-facts
     ```

3. **Make Your Changes**:
   - Implement your changes and commit them to your branch. Follow the project's coding standards and commit message guidelines.

4. **Push Your Branch**:
   - Push your branch to your forked repository:
     ```bash
     git push origin issue-123-add-cat-facts
     ```

5. **Submit a Pull Request (PR)**:
   - Go to the original repository on GitHub and you should see a prompt to create a pull request. Click "Compare & pull request".

6. **PR Review and Approval**:
   - Your pull request will be reviewed by the maintainers. Please be patient and responsive to any feedback you receive. Only maintainers have the authority to merge and deploy your changes.

### Learn More

For more detailed information about working with forks and contributing to open-source projects, check out [GitHub's guide on working with forks](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/working-with-forks).

