# Learning Tracker

Tracking my technical skills, my coding projects, my course work, and helpful resources for learning web development and computer programming to plan, document, and share my progress.

Learning logs:
[April 2020](https://github.com/SabineEmden/learning-tracker/blob/master/learning-logs/2020April.md) | 
[March 2020](https://github.com/SabineEmden/learning-tracker/blob/master/learning-logs/2020March.md) | 
[February 2020](https://github.com/SabineEmden/learning-tracker/blob/master/learning-logs/2020February.md)


## Technical Skills

Skill | Level
--- | ---
HTML | :bulb: :bulb: :bulb: :bulb:
CSS | :bulb: :bulb:
JavaScript | :bulb:
Bootstrap | :bulb: :bulb:
Responsive Web Design | :bulb:
Web Accessibility | :bulb: :bulb:
Command Line | :bulb: :bulb: :bulb:
Git | :bulb: :bulb: :bulb:
GitHub | :bulb: :bulb: :bulb:
Python | :bulb:
PHP | :bulb:
WordPress Development | :bulb:
Agile Methodologies | :bulb:


## Coding Projects

### Portfolio Website

*Completed*

https://sabineemden.github.io

Design and implement a responsive website for a minimum of two platforms while adhering to validation and accessibility standards. 

Skills used: HTML5, CSS3, JavaScript, Bootstrap 4, responsive web design, web accessibility

Course project: Web Design for Everybody Capstone

[GitHub repository](https://github.com/SabineEmden/SabineEmden.github.io)


## Coursework

### Coursera

- [X] Internet History, Technology, and Security
(See [course description](https://www.coursera.org/learn/internet-history))

- [X] Web Design for Everybody (Basics of Web Development and Coding) Specialization
(See [course descriptions](https://www.coursera.org/specializations/web-design))
  - [X] Introduction to HTML5
  - [X] Introduction to CSS3
  - [X] Interactivity with JavaScript
  - [X] Advanced Styling with Responsive Design
  - [X] Web Desing for Everybody Capstone

- [ ] Python for Everybody Specialization
(See [course descriptions](https://www.coursera.org/specializations/python))
  - [X] Programming for Everybody (Getting Started with Python)
  - [ ] Python Data Structures
  - [ ] Using Python to Access Web Data
  - [ ] Using Databases with Python
  - [ ] Capstone: Retrieving, Processing, and Visualizing Data with Python

- [ ] Web Applications for Everybody Specialization
(See [course descriptions](https://www.coursera.org/specializations/web-applications))
  - [ ] Building Web Applications in PHP
  - [ ] Introduction to Structured Query Language (SQL)
  - [ ] Building Database Applications in PHP
  - [ ] JavaScript, jQuery, and JSON

- [ ] Agile Development Specialization (See [course descriptions](https://www.coursera.org/specializations/agile-development))
  - [X] Agile Meets Design Thinking
  - [X] Running Product Design Sprints
  - [ ] Managing an Agile Team
  - [ ] Hypothesis Driven Development
  - [ ] Agile Development in Practice (Project-centered Course)

### Udacity

- [X] Shell Workshop
(See [course description](https://www.udacity.com/course/shell-workshop--ud206))

- [X] Version Control with Git
(See [course description](https://www.udacity.com/course/version-control-with-git--ud123))

- [X] GitHub & Collaboration
(Course discontinued)

- [X] Writing READMEs
(See [course description](https://www.udacity.com/course/writing-readmes--ud777))

### Udemy

- [ ] Become a WordPress Developer by Brad Schiff (See [course description](https://www.udemy.com/course/become-a-wordpress-developer-php-javascript/))


## Resources

### Online Courses

- [Coursera](https://www.coursera.org)
- [edX](https://www.edx.org)
- [Udacity](https://www.udacity.com)
- [Udemy](https://www.udemy.com)

### Tutorials

- [Learn to Code HTML & CSS](https://learn.shayhowe.com) by Shay Howe
- [W3Schools Online Web Tutorials](https://www.w3schools.com)
- [MDN Web Docs](https://developer.mozilla.org/en-US/)

### Coding Challenges

- [Frontend Mentor](https://www.frontendmentor.io)

### Tools

- [The W3C Markup Validation Service](https://validator.w3.org)
- [WAVE Web Accessibility Evaluation Tool](https://wave.webaim.org)
- [Bootstrap](https://getbootstrap.com), CSS framework
- [Git](https://git-scm.com), version control system
- [Visual Studio Code](https://wptavern.com), text editor
- [Local](https://localwp.com), local WordPress development

### Documentation

- [WebAIM's WCAG 2 Checklist](https://webaim.org/standards/wcag/checklist)
- [GitHub](https://help.github.com/en/github)
- [WordPress Developer Resources](https://developer.wordpress.org)

### Blogs

- [freeCodeCamp](https://www.freecodecamp.org/news/)
- [WordPress Tavern](https://wptavern.com)

### Podcasts

- [Learn to Code With Me](https://learntocodewith.me/podcast/) with Laurence Bradford
- [CodeNewbie](https://www.codenewbie.org/podcast) with Saron Yitbarek


### Books

- [A Mind For Numbers: How to Excel at Math and Science](https://barbaraoakley.com/books/a-mind-for-numbers/) by Barbara Oakley

## Acknowledgements

This project is inspired by Syk Houdeib's [Learning Tracker](https://github.com/Syknapse/My-Learning-Tracker), by Alexander Kallaway's [#100DaysOfCode Challenge](https://github.com/kallaway/100-days-of-code), and by Shovan Chatterjee's [Full Stack Web Developer Path](https://github.com/shovanch/fullstack-web-developer-path).

I found Syk Houdeib's [Learning Tracker](https://github.com/Syknapse/My-Learning-Tracker) through his post for freeCodeCamp [How I switches career and got a developer job in 10 months: a true story](https://www.freecodecamp.org/news/how-i-switched-careers-and-got-a-developer-job-in-10-months-a-true-story-b8895e855a8b/).


## Note

- If you like this repo and find it useful, please consider starring it &#9733; (on the top right of the page).
- If you would like to use it as a template to track your own learning, you can fork the repo and customize the files to your own needs.