/*
 * Decompiled with CFR 0.152.
 */
package me.ljr.insdal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.ljr.insdal.ApkDecompiler;
import me.ljr.insdal.Constant;
import me.ljr.insdal.PathManager;
import me.ljr.insdal.SmaliHelper;
import org.apache.commons.cli.CommandLine;

public class Instrumenter {
    private PathManager mPM = null;
    private CommandLine mCmd = null;
    private Set<String> mKeys = null;
    private String mTag = null;
    private ApkDecompiler.ManifestParser mMP = null;
    private List<String> mMethodInfo = null;
    private List<String> mKeyInfo = null;
    private List<String> mBranchInfo = null;
    public boolean mForMethod = false;
    public boolean mForKey = false;
    public boolean mForBranch = false;

    public Instrumenter(PathManager pm, CommandLine cmd) {
        this.mPM = pm;
        this.mCmd = cmd;
        if (this.mCmd.hasOption("m")) {
            this.mForMethod = true;
        }
        if (this.mCmd.hasOption("k")) {
            this.mForKey = true;
            this.mKeys = new HashSet<String>();
            File keyFile = new File(new File(this.mCmd.getOptionValue("k")).getAbsolutePath());
            if (keyFile.isFile()) {
                String[] tempKeys;
                ArrayList<String> keyList = new ArrayList<String>();
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(keyFile));
                    String eachLine = null;
                    while ((eachLine = reader.readLine()) != null) {
                        if (eachLine.length() <= 0) continue;
                        keyList.add(eachLine);
                    }
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (String str : tempKeys = keyList.toArray(new String[keyList.size()])) {
                    if (str.equals("")) continue;
                    this.mKeys.add(str);
                }
            } else {
                String[] tempKeys;
                for (String str : tempKeys = this.mCmd.getOptionValue("k").split(":")) {
                    if (str.equals("")) continue;
                    this.mKeys.add(str);
                }
            }
        }
        if (this.mCmd.hasOption("b")) {
            this.mForBranch = true;
        }
        String string = this.mTag = this.mCmd.hasOption("t") ? this.mCmd.getOptionValue("t") : "InsDal";
        if (this.mCmd.hasOption("i")) {
            this.mMethodInfo = new ArrayList<String>();
            this.mKeyInfo = new ArrayList<String>();
            this.mBranchInfo = new ArrayList<String>();
        }
    }

    public void addManifestParser(ApkDecompiler.ManifestParser mp) {
        this.mMP = mp;
    }

    public void instrument(String[] smaliPath) {
        for (int i = 0; i < smaliPath.length; ++i) {
            if (this.mCmd.hasOption("P")) {
                String[] packageStr;
                for (String str : packageStr = this.mCmd.getOptionValue("P").split(":")) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(smaliPath[i]);
                    for (String s : str.split("\\.")) {
                        sb.append(File.separator);
                        sb.append(s);
                    }
                    this.instrumentOp(sb.toString(), smaliPath[i] + File.separator + this.mMP.mMainActivity + ".smali");
                }
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(smaliPath[i]);
                for (String s : this.mMP.mPackageName.split("\\.")) {
                    sb.append(File.separator);
                    sb.append(s);
                }
                this.instrumentOp(sb.toString(), smaliPath[i] + File.separator + this.mMP.mMainActivity + ".smali");
            }
            if (!this.mCmd.hasOption("i")) continue;
            this.outputInsInfo();
        }
    }

    private void instrumentSb(List<String> content) {
        content.add("\n");
        content.add(".field public static " + Constant._sb_name + ":Ljava/lang/StringBuilder;");
        if (content.contains(".method static constructor <clinit>()V")) {
            int regIndex = content.indexOf(".method static constructor <clinit>()V");
            while (!content.get(regIndex).contains(".locals")) {
                ++regIndex;
            }
            String[] split = content.get(regIndex).split(" ");
            int regNum = Integer.valueOf(split[split.length - 1]);
            if (0 == regNum) {
                content.set(regIndex, "    .locals 1");
            }
            int returnIndex = content.indexOf(".method static constructor <clinit>()V");
            while (!content.get(returnIndex).contains("return-void")) {
                ++returnIndex;
            }
            ArrayList<String> newContent = new ArrayList<String>();
            newContent.add("");
            newContent.add("    new-instance v0, Ljava/lang/StringBuilder;");
            newContent.add("");
            newContent.add("    invoke-direct {v0}, Ljava/lang/StringBuilder;-><init>()V");
            newContent.add("");
            newContent.add("    sput-object v0, L" + this.mMP.mMainActivity + ";->" + Constant._sb_name + ":Ljava/lang/StringBuilder;");
            newContent.add("");
            content.addAll(returnIndex, newContent);
        } else {
            content.add("");
            content.add(".method static constructor <clinit>()V");
            content.add("    .locals 1");
            content.add("");
            content.add("    .prologue");
            content.add("");
            content.add("    new-instance v0, Ljava/lang/StringBuilder;");
            content.add("");
            content.add("    invoke-direct {v0}, Ljava/lang/StringBuilder;-><init>()V");
            content.add("");
            content.add("    sput-object v0, L" + this.mMP.mMainActivity + ";->" + Constant._sb_name + ":Ljava/lang/StringBuilder;");
            content.add("");
            content.add("    return-void");
            content.add(".end method");
        }
    }

    private void instrumentOp(String path, String mainActPath) {
        if (path.contains("R.smali") || path.contains("R$") || path.contains("BuildConfig.smali")) {
            return;
        }
        File tarFile = new File(path);
        if (!tarFile.exists()) {
            return;
        }
        if (tarFile.isDirectory()) {
            for (File subFile : tarFile.listFiles()) {
                this.instrumentOp(subFile.toString(), mainActPath);
            }
        } else {
            ArrayList<String> content = new ArrayList<String>();
            try {
                BufferedReader reader = new BufferedReader(new FileReader(tarFile));
                String eachLine = null;
                while ((eachLine = reader.readLine()) != null) {
                    content.add(eachLine);
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (tarFile.getAbsolutePath().equals(mainActPath) && (this.mForMethod || this.mForKey || this.mForBranch)) {
                this.instrumentSb(content);
            }
            if (this.mForMethod) {
                this.insMethod(content);
            }
            if (this.mForKey) {
                this.insKey(content);
            }
            if (this.mForBranch) {
                this.insBranch(content);
            }
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(tarFile));
                for (String eachContent : content) {
                    writer.write(eachContent + "\n");
                }
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void outputInsInfo() {
        try {
            FileWriter fw = new FileWriter(this.mPM.mInsInfoPath);
            if (this.mForMethod) {
                fw.write("----------Instrumented Methods----------\n");
                for (String method : this.mMethodInfo) {
                    fw.write(method + "\n");
                }
                fw.write("----------------------------------------\n");
            }
            if (this.mForKey) {
                fw.write("------Instrumented Key Operations-------\n");
                for (String key : this.mKeyInfo) {
                    fw.write(key + "\n");
                }
                fw.write("----------------------------------------\n");
            }
            if (this.mForBranch) {
                fw.write("----------Instrumented Branches----------\n");
                for (String branch : this.mBranchInfo) {
                    fw.write(branch + "\n");
                }
                fw.write("----------------------------------------\n");
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void insMethod(List<String> content) {
        for (int i = 0; i < content.size(); ++i) {
            if (content.get(i).indexOf(".method") != 0 || content.get(i).contains("synthetic") || content.get(i).contains("abstract") || content.get(i).contains("native")) continue;
            int methodIndex = i;
            SmaliHelper.transferReg(content, i);
            int[] newReg = SmaliHelper.getNewReg(content, i);
            String methodName = SmaliHelper.getMethodName(content, i);
            i = SmaliHelper.findMethodLogPlace(content, i);
            SmaliHelper.insLogOp(content, i, newReg, "M_" + this.mTag, methodName);
            if (this.mCmd.hasOption("i")) {
                this.mMethodInfo.add(methodName);
            }
            if (!this.mCmd.hasOption("V")) continue;
            List<Integer> paramInfo = SmaliHelper.getParamInfo(content.get(methodIndex));
            int localRegNum = Integer.valueOf(content.get(methodIndex + 1).split("\\(")[1].split("\\)")[0]);
            int arg_index = 0;
            for (int k = 1; k < paramInfo.size(); ++k) {
                if (0 == paramInfo.get(k)) continue;
                String pType = SmaliHelper.PARAM_TYPE[paramInfo.get(k)];
                if (pType.equals("B") || pType.equals("S")) {
                    pType = "I";
                }
                i += SmaliHelper.insValueLogOp(content, i, newReg, "VM_" + this.mTag, k - 1 + localRegNum, pType, arg_index, this.mMP.mMainActivity);
                ++arg_index;
            }
        }
    }

    private void insKey(List<String> content) {
        boolean methodFlag = false;
        for (int i = 0; i < content.size(); ++i) {
            if (!(content.get(i).indexOf(".method") != 0 || content.get(i).contains("synthetic") || content.get(i).contains("abstract") || content.get(i).contains("native"))) {
                methodFlag = true;
            } else if (content.get(i).indexOf(".end method") == 0) {
                methodFlag = false;
            }
            if (!methodFlag) continue;
            for (String eachKey : this.mKeys) {
                int mIndex;
                if (!content.get(i).contains(eachKey) || !content.get(i).contains("invoke-") || (mIndex = SmaliHelper.getMethodIndex(content, i)) < 0 || mIndex == i) continue;
                i += SmaliHelper.transferReg(content, mIndex);
                int[] newReg = SmaliHelper.getNewReg(content, mIndex);
                i += SmaliHelper.insLogOp(content, i, newReg, "K_" + this.mTag, eachKey);
                if (this.mCmd.hasOption("i")) {
                    String methodName = SmaliHelper.getMethodName(content, mIndex);
                    this.mKeyInfo.add(methodName + ": " + eachKey);
                }
                if (!this.mCmd.hasOption("v")) continue;
                List<Integer> usedRegs = SmaliHelper.getUsedReg(content.get(i));
                List<Integer> usedRegTypes = SmaliHelper.getParamInfo(content.get(i));
                int type_index = 1;
                for (int k = 0; k < usedRegs.size(); ++k) {
                    String pType;
                    if (0 == usedRegTypes.get(type_index)) {
                        ++type_index;
                    }
                    if ((pType = SmaliHelper.PARAM_TYPE[usedRegTypes.get(type_index)]).equals("B") || pType.equals("S")) {
                        pType = "I";
                    }
                    i += SmaliHelper.insValueLogOp(content, i, newReg, "VK_" + this.mTag, usedRegs.get(k), pType, k, this.mMP.mMainActivity);
                }
            }
        }
    }

    private void insBranch(List<String> content) {
        boolean methodFlag = false;
        for (int i = 0; i < content.size(); ++i) {
            if (!(content.get(i).indexOf(".method") != 0 || content.get(i).contains("synthetic") || content.get(i).contains("abstract") || content.get(i).contains("native"))) {
                methodFlag = true;
            } else if (content.get(i).indexOf(".end method") == 0) {
                methodFlag = false;
            }
            if (!methodFlag) continue;
        }
    }
}

