/*
 * Decompiled with CFR 0.152.
 */
package me.ljr.insdal;

import java.util.Date;
import me.ljr.insdal.ApkDecompiler;
import me.ljr.insdal.Instrumenter;
import me.ljr.insdal.PathManager;
import me.ljr.insdal.util.SystemUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class InsDal {
    private String[] mCmdArgs = null;
    private ApkDecompiler mDecompiler = null;
    private Instrumenter mInstrumenter = null;
    private CommandLine mCmd = null;
    private PathManager mPM = null;
    private ApkDecompiler.ManifestParser mMP = null;
    private int mTargetOS = 0;

    public static void main(String[] args) {
        InsDal insDal = new InsDal(args);
        insDal.start();
    }

    private InsDal(String[] args) {
        this.mCmdArgs = args;
        this.mTargetOS = SystemUtil.getTargetOS();
        this.mCmd = this.getCmd();
    }

    private void start() {
        if (null == this.mCmd) {
            System.exit(-1);
        }
        if (-1 == this.mTargetOS) {
            System.out.println("Unknown operating system. (require Windows or Linux)");
            System.exit(-1);
        }
        if (this.mCmd.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java -jar InsDal.jar [options]", this.getOptions());
            System.exit(0);
        }
        if (!this.mCmd.hasOption("f")) {
            System.out.println("Miss the target apk file. (use the \"f\" option to specify the file)");
            System.exit(-1);
        }
        this.mPM = new PathManager(this.mCmd);
        this.mDecompiler = new ApkDecompiler(this.mPM, this.mTargetOS);
        this.mInstrumenter = new Instrumenter(this.mPM, this.mCmd);
        System.out.println("---------------------------------------------------------------");
        System.out.println("Instrumenting for methods:  " + (this.mInstrumenter.mForMethod ? "+" : "-"));
        System.out.println("Instrumenting for keys:     " + (this.mInstrumenter.mForKey ? "+" : "-"));
        System.out.println("Instrumenting for branches: " + (this.mInstrumenter.mForBranch ? "+" : "-"));
        System.out.println("----------------------> Decompiling APK <----------------------");
        this.mDecompiler.decompile();
        long startTime = new Date().getTime();
        this.mMP = this.mDecompiler.manifestParse();
        this.mInstrumenter.addManifestParser(this.mMP);
        System.out.println("-----------------------> Instrumenting <-----------------------");
        this.mInstrumenter.instrument(this.mPM.mSmaliFolderPath);
        System.out.println("-----------------------> Rebuilding APK <----------------------");
        long endTime = new Date().getTime();
        this.mDecompiler.rebuild();
        System.out.println("------------------------> Signing APK <------------------------");
        this.mDecompiler.signApk();
        System.out.println("-----------------------> Copying Files <-----------------------");
        this.mDecompiler.copyFile();
        if (!this.mCmd.hasOption("p")) {
            System.out.println("-----------------> Removing Decompiled Folder <----------------");
            this.mDecompiler.deleteDeFolder();
        }
        System.out.println("Instrumentation time: " + (endTime - startTime) + "ms");
        System.out.println("--------------------------> ! DONE ! <-------------------------");
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption("h", false, "Show the help information.");
        options.addOption("f", true, "Set the target APK file.");
        options.addOption("m", false, "Add logs for methods.");
        options.addOption("k", true, "Add logs for key operations. (Use \":\" to split multiple keys or give a file that stores keys, each of which is in a single line.)");
        options.addOption("P", true, "Instrument the target package.");
        options.addOption("p", false, "Preserve the decompiled files.");
        options.addOption("V", false, "Print the parameters's value of the instrumented methods. (This option works when you use option \"m\".)");
        options.addOption("v", false, "Print the arguments' value of the key operations. (This option works when you use option \"k\".)");
        options.addOption("t", true, "Set some specific words in tag string. (If not, we will use the default tag \"M/K/B/V_InsDal\".)");
        options.addOption("i", false, "Output all instrumentation information into \"ins_info\" file.");
        return options;
    }

    private CommandLine getCmd() {
        DefaultParser parser = new DefaultParser();
        try {
            return parser.parse(this.getOptions(), this.mCmdArgs);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

