/*
 * Decompiled with CFR 0.152.
 */
package me.ljr.insdal;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import me.ljr.insdal.Constant;
import me.ljr.insdal.PathManager;
import me.ljr.insdal.util.StringUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ApkDecompiler {
    private PathManager mPM = null;
    private int mTargetOS = 0;

    public ApkDecompiler(PathManager pm, int targetOS) {
        this.mPM = pm;
        this.mTargetOS = targetOS;
    }

    public void decompile() {
        String[] decompileStr = new String[6];
        if (1 == this.mTargetOS) {
            decompileStr[0] = Constant._apktool_windows_path;
        } else if (2 == this.mTargetOS || 3 == this.mTargetOS) {
            decompileStr[0] = Constant._apktool_linux_path;
        }
        decompileStr[1] = "d";
        decompileStr[2] = "-f";
        decompileStr[3] = this.mPM.mApkPath;
        decompileStr[4] = "-o";
        decompileStr[5] = this.mPM.mDeFolderPath;
        try {
            Process p = Runtime.getRuntime().exec(decompileStr, null, null);
            this.getInfo(p);
            p.waitFor();
            if (p.waitFor() != 0) {
                System.out.println(StringUtil.errorInfo("Decompile Failed"));
                System.exit(-1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(StringUtil.errorInfo("Decompile Failed"));
            System.exit(-1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void rebuild() {
        String[] rebuildStr = new String[3];
        if (1 == this.mTargetOS) {
            rebuildStr[0] = Constant._apktool_windows_path;
        } else if (2 == this.mTargetOS || 3 == this.mTargetOS) {
            rebuildStr[0] = Constant._apktool_linux_path;
        }
        rebuildStr[1] = "b";
        rebuildStr[2] = this.mPM.mDeFolderPath;
        try {
            Process p = Runtime.getRuntime().exec(rebuildStr, null, null);
            this.getInfo(p);
            p.waitFor();
            if (p.waitFor() != 0) {
                System.out.println(StringUtil.errorInfo("Rebuild Failed"));
                System.exit(-1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(StringUtil.errorInfo("Rebuild Failed"));
            System.exit(-1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void signApk() {
        String[] signStr = new String[]{"java", "-jar", Constant._signapk_path, Constant._pem_path, Constant._pk8_path, this.mPM.mDistApkPath, this.mPM.mSignedApkPath};
        try {
            Process p = Runtime.getRuntime().exec(signStr, null, null);
            this.getInfo(p);
            p.waitFor();
            if (p.waitFor() != 0) {
                System.out.println(StringUtil.errorInfo("Sign APK Failed"));
                System.exit(-1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(StringUtil.errorInfo("Sign APK Failed"));
            System.exit(-1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void copyFile() {
        String[] copyStr = null;
        if (1 == this.mTargetOS) {
            copyStr = new String[]{"cmd", "/c", "xcopy", this.mPM.mSignedApkPath, this.mPM.mApkParPath, "/e/q/y"};
        } else if (2 == this.mTargetOS || 3 == this.mTargetOS) {
            copyStr = new String[]{"cp", this.mPM.mSignedApkPath, this.mPM.mApkParPath};
        }
        try {
            Process p = Runtime.getRuntime().exec(copyStr, null, null);
            this.getInfo(p);
            p.waitFor();
            if (p.waitFor() != 0) {
                System.out.println(StringUtil.errorInfo("Copy Files Failed"));
                System.exit(-1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(StringUtil.errorInfo("Copy Files Failed"));
            System.exit(-1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void deleteDeFolder() {
        String[] deleteStr = null;
        if (1 == this.mTargetOS) {
            deleteStr = new String[]{"cmd", "/c", "rd", "/s/q", this.mPM.mDeFolderPath};
        } else if (2 == this.mTargetOS || 3 == this.mTargetOS) {
            deleteStr = new String[]{"rm", "-rf", this.mPM.mDeFolderPath};
        }
        try {
            Process p = Runtime.getRuntime().exec(deleteStr, null, null);
            this.getInfo(p);
            p.waitFor();
            if (p.waitFor() != 0) {
                System.out.println(StringUtil.errorInfo("Delete Folder Failed"));
                System.exit(-1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(StringUtil.errorInfo("Delete Folder Failed"));
            System.exit(-1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public ManifestParser manifestParse() {
        ManifestParser mp = new ManifestParser();
        SAXReader reader = new SAXReader();
        try {
            Document doc = reader.read(new File(this.mPM.mManifestPath));
            Element root = doc.getRootElement();
            mp.mPackageName = root.attributeValue("package");
            Iterator eleIte = root.elementIterator();
            Element applicationEle = null;
            while (eleIte.hasNext()) {
                Element subElement = (Element)eleIte.next();
                if (!subElement.getName().equals("application")) continue;
                applicationEle = subElement;
                break;
            }
            if (null == applicationEle) {
                System.out.println(StringUtil.errorInfo("Parse main Activity failed"));
                System.exit(-1);
            } else {
                Iterator appIte = applicationEle.elementIterator();
                Element mainActEle = null;
                while (appIte.hasNext()) {
                    Element appEle = (Element)appIte.next();
                    if (appEle.getName().equals("activity")) {
                        Iterator actIte = appEle.elementIterator();
                        while (actIte.hasNext()) {
                            Element actEle = (Element)actIte.next();
                            if (!actEle.getName().equals("intent-filter")) continue;
                            Iterator filterIte = actEle.elementIterator();
                            boolean isMain = false;
                            boolean isLauncher = false;
                            while (filterIte.hasNext()) {
                                Element filterEle = (Element)filterIte.next();
                                if (filterEle.getName().equals("action") && null != filterEle.attributeValue("name") && filterEle.attributeValue("name").equals("android.intent.action.MAIN")) {
                                    isMain = true;
                                }
                                if (!filterEle.getName().equals("category") || null == filterEle.attributeValue("name") || !filterEle.attributeValue("name").equals("android.intent.category.LAUNCHER")) continue;
                                isLauncher = true;
                            }
                            if (!isMain || !isLauncher) continue;
                            mainActEle = appEle;
                        }
                    }
                    if (null == mainActEle) continue;
                    break;
                }
                if (null == mainActEle) {
                    System.out.println(StringUtil.errorInfo("Parse main Activity failed"));
                    System.exit(-1);
                } else {
                    String mainActTempName = mainActEle.attributeValue("name");
                    if (StringUtil.isEmpty(mainActTempName)) {
                        System.out.println(StringUtil.errorInfo("Parse main Activity failed"));
                        System.exit(-1);
                    } else {
                        String nameWithDot = '.' == mainActTempName.charAt(0) ? mp.mPackageName + mainActTempName : (!mainActTempName.contains(".") ? mp.mPackageName + "." + mainActTempName : mainActTempName);
                        StringBuilder mainActSb = new StringBuilder();
                        String[] pathSplit = nameWithDot.split("\\.");
                        for (int i = 0; i < pathSplit.length; ++i) {
                            if (0 != i) {
                                mainActSb.append("/");
                            }
                            mainActSb.append(pathSplit[i]);
                        }
                        mp.mMainActivity = mainActSb.toString();
                    }
                }
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return mp;
    }

    private void getInfo(Process p) {
        try {
            BufferedInputStream in = new BufferedInputStream(p.getInputStream());
            BufferedReader inBr = new BufferedReader(new InputStreamReader(in));
            String inStr = null;
            while ((inStr = inBr.readLine()) != null) {
                System.out.println(inStr);
            }
            inBr.close();
            in.close();
            BufferedInputStream err = new BufferedInputStream(p.getErrorStream());
            BufferedReader errBr = new BufferedReader(new InputStreamReader(err));
            String errStr = null;
            while ((errStr = errBr.readLine()) != null) {
                System.err.println(errStr);
            }
            errBr.close();
            err.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class ManifestParser {
        public String mPackageName = null;
        public String mMainActivity = null;
    }
}

