<?php declare(strict_types = 1);
/**
 * This file is part of the SqlFtw library (https://github.com/sqlftw)
 *
 * Copyright (c) 2017 Vlasta Neubauer (@paranoiq)
 *
 * For the full copyright and license information read the file 'license.md', distributed with this source code
 */

// spell-check-ignore: AMBIGOUS BADRETURN BADSELECT BADSTATEMENT BLOCKHOLE BUFPOOL CHECKREAD COLUMNACCESS CTX CURSHNDLR DBACCESS DBS DISPLAYWIDTH DML DOCID DOESNT DONT DUP DUPID EMFILE ENDIANESS ERRMSG FCNTL FCT FIELDLENGTH FIELDNAME FILSORT FPARSER FTS GEOJSON GNO HASHCHK HNDLR INEXISTENT INPROGRESS INSERTABLE INVAL IPSOCK ISNT KEYFILE KEYNAME KMS LILABEL MGMT MULTIUPDATE NCOLLATIONS NISAMCHK NONEXISTING NONPARTITIONED NONTRANS NONUNIQ NONUPD NONUPDATEABLE NOPK NORETURN NORETURNEND NOTA NYI OUTOFMEMORY PARAMCOUNT PASSWD PERFSCHEMA PLUGGABLE PROCACCESS RBDEADLOCK RBROLLBACK RBTIMEOUT READLOCK REORG REPL REPREPARE RETSET RLI RMERR RMFAIL ROWSIZE SBR SORTMEMORY SPKEYS SPLITTABLE SPVAR SQLTHREAD SROUTINE STRUCT SUBPART SYSVAR TABLEACCESS TABLENAME TEXTFILE THD TMPTABLE TRG TRXS UNINIT UNIQ UNSUPORTED UPG VARCOND VER VTOKEN WD WSAS XAER
// spell-check-ignore: ADUIT AUTHID AUTOPOSITION CARTESIAN CFG CONN CRS DECRYPTED DEINITIALIZE GEOGCS GLOBSTAT GRP JT KERBEROS LIBCURL LOOPBACK MVI MYSQLBACKUP MYSQLD NONINTEGER NONPOSITIVE NONRECURSIVE OOM OUTOFBOUNDS PAREN PRIDICTION PROJ REENCRYPT REQ STERE THR THRS TP TXN UKNOWN

namespace SqlFtw\Platform\Features;

use SqlFtw\Sql\IntEnum;

/**
 * MySQL error codes
 *
 * @see: https://dev.mysql.com/doc/mysql-errors/8.0/en/server-error-reference.html
 * @see: https://mariadb.com/kb/en/mariadb-error-codes/
 */
class MysqlError extends IntEnum
{

    public const ER_HASHCHK = 1000;
    public const ER_NISAMCHK = 1001;
    public const ER_NO = 1002;
    public const ER_YES = 1003;
    public const ER_CANT_CREATE_FILE = 1004;
    public const ER_CANT_CREATE_TABLE = 1005;
    public const ER_CANT_CREATE_DB = 1006;
    public const ER_DB_CREATE_EXISTS = 1007;
    public const ER_DB_DROP_EXISTS = 1008;
    public const ER_DB_DROP_DELETE = 1009;
    public const ER_DB_DROP_RMDIR = 1010;
    public const ER_CANT_DELETE_FILE = 1011;
    public const ER_CANT_FIND_SYSTEM_REC = 1012;
    public const ER_CANT_GET_STAT = 1013;
    public const ER_CANT_GET_WD = 1014;
    public const ER_CANT_LOCK = 1015;
    public const ER_CANT_OPEN_FILE = 1016;
    public const ER_FILE_NOT_FOUND = 1017;
    public const ER_CANT_READ_DIR = 1018;
    public const ER_CANT_SET_WD = 1019;
    public const ER_CHECKREAD = 1020;
    public const ER_DISK_FULL = 1021;
    public const ER_DUP_KEY = 1022;
    public const ER_ERROR_ON_CLOSE = 1023;
    public const ER_ERROR_ON_READ = 1024;
    public const ER_ERROR_ON_RENAME = 1025;
    public const ER_ERROR_ON_WRITE = 1026;
    public const ER_FILE_USED = 1027;
    public const ER_FILSORT_ABORT = 1028;
    public const ER_FORM_NOT_FOUND = 1029;
    public const ER_GET_ERRNO = 1030;
    public const ER_ILLEGAL_HA = 1031;
    public const ER_KEY_NOT_FOUND = 1032;
    public const ER_NOT_FORM_FILE = 1033;
    public const ER_NOT_KEYFILE = 1034;
    public const ER_OLD_KEYFILE = 1035;
    public const ER_OPEN_AS_READONLY = 1036;
    public const ER_OUTOFMEMORY = 1037;
    public const ER_OUT_OF_SORTMEMORY = 1038;
    public const ER_UNEXPECTED_EOF = 1039;
    public const ER_CON_COUNT_ERROR = 1040;
    public const ER_OUT_OF_RESOURCES = 1041;
    public const ER_BAD_HOST_ERROR = 1042;
    public const ER_HANDSHAKE_ERROR = 1043;
    public const ER_DBACCESS_DENIED_ERROR = 1044;
    public const ER_ACCESS_DENIED_ERROR = 1045;
    public const ER_NO_DB_ERROR = 1046;
    public const ER_UNKNOWN_COM_ERROR = 1047;
    public const ER_BAD_NULL_ERROR = 1048;
    public const ER_BAD_DB_ERROR = 1049;
    public const ER_TABLE_EXISTS_ERROR = 1050;
    public const ER_BAD_TABLE_ERROR = 1051;
    public const ER_NON_UNIQ_ERROR = 1052;
    public const ER_SERVER_SHUTDOWN = 1053;
    public const ER_BAD_FIELD_ERROR = 1054;
    public const ER_WRONG_FIELD_WITH_GROUP = 1055;
    public const ER_WRONG_GROUP_FIELD = 1056;
    public const ER_WRONG_SUM_SELECT = 1057;
    public const ER_WRONG_VALUE_COUNT = 1058;
    public const ER_TOO_LONG_IDENT = 1059;
    public const ER_DUP_FIELDNAME = 1060;
    public const ER_DUP_KEYNAME = 1061;
    public const ER_DUP_ENTRY = 1062;
    public const ER_WRONG_FIELD_SPEC = 1063;
    public const ER_PARSE_ERROR = 1064;
    public const ER_EMPTY_QUERY = 1065;
    public const ER_NONUNIQ_TABLE = 1066;
    public const ER_INVALID_DEFAULT = 1067;
    public const ER_MULTIPLE_PRI_KEY = 1068;
    public const ER_TOO_MANY_KEYS = 1069;
    public const ER_TOO_MANY_KEY_PARTS = 1070;
    public const ER_TOO_LONG_KEY = 1071;
    public const ER_KEY_COLUMN_DOES_NOT_EXITS = 1072;
    public const ER_BLOB_USED_AS_KEY = 1073;
    public const ER_TOO_BIG_FIELDLENGTH = 1074;
    public const ER_WRONG_AUTO_KEY = 1075;
    public const ER_READY = 1076;
    public const ER_NORMAL_SHUTDOWN = 1077;
    public const ER_GOT_SIGNAL = 1078;
    public const ER_SHUTDOWN_COMPLETE = 1079;
    public const ER_FORCING_CLOSE = 1080;
    public const ER_IPSOCK_ERROR = 1081;
    public const ER_NO_SUCH_INDEX = 1082;
    public const ER_WRONG_FIELD_TERMINATORS = 1083;
    public const ER_BLOBS_AND_NO_TERMINATED = 1084;
    public const ER_TEXTFILE_NOT_READABLE = 1085;
    public const ER_FILE_EXISTS_ERROR = 1086;
    public const ER_LOAD_INFO = 1087;
    public const ER_ALTER_INFO = 1088;
    public const ER_WRONG_SUB_KEY = 1089;
    public const ER_CANT_REMOVE_ALL_FIELDS = 1090;
    public const ER_CANT_DROP_FIELD_OR_KEY = 1091;
    public const ER_INSERT_INFO = 1092;
    public const ER_UPDATE_TABLE_USED = 1093;
    public const ER_NO_SUCH_THREAD = 1094;
    public const ER_KILL_DENIED_ERROR = 1095;
    public const ER_NO_TABLES_USED = 1096;
    public const ER_TOO_BIG_SET = 1097;
    public const ER_NO_UNIQUE_LOGFILE = 1098;
    public const ER_TABLE_NOT_LOCKED_FOR_WRITE = 1099;
    public const ER_TABLE_NOT_LOCKED = 1100;
    public const ER_BLOB_CANT_HAVE_DEFAULT = 1101;
    public const ER_WRONG_DB_NAME = 1102;
    public const ER_WRONG_TABLE_NAME = 1103;
    public const ER_TOO_BIG_SELECT = 1104;
    public const ER_UNKNOWN_ERROR = 1105;
    public const ER_UNKNOWN_PROCEDURE = 1106;
    public const ER_WRONG_PARAMCOUNT_TO_PROCEDURE = 1107;
    public const ER_WRONG_PARAMETERS_TO_PROCEDURE = 1108;
    public const ER_UNKNOWN_TABLE = 1109;
    public const ER_FIELD_SPECIFIED_TWICE = 1110;
    public const ER_INVALID_GROUP_FUNC_USE = 1111;
    public const ER_UNSUPPORTED_EXTENSION = 1112;
    public const ER_TABLE_MUST_HAVE_COLUMNS = 1113;
    public const ER_RECORD_FILE_FULL = 1114;
    public const ER_UNKNOWN_CHARACTER_SET = 1115;
    public const ER_TOO_MANY_TABLES = 1116;
    public const ER_TOO_MANY_FIELDS = 1117;
    public const ER_TOO_BIG_ROWSIZE = 1118;
    public const ER_STACK_OVERRUN = 1119;
    public const ER_WRONG_OUTER_JOIN = 1120;
    public const ER_NULL_COLUMN_IN_INDEX = 1121;
    public const ER_CANT_FIND_UDF = 1122;
    public const ER_CANT_INITIALIZE_UDF = 1123;
    public const ER_UDF_NO_PATHS = 1124;
    public const ER_UDF_EXISTS = 1125;
    public const ER_CANT_OPEN_LIBRARY = 1126;
    public const ER_CANT_FIND_DL_ENTRY = 1127;
    public const ER_FUNCTION_NOT_DEFINED = 1128;
    public const ER_HOST_IS_BLOCKED = 1129;
    public const ER_HOST_NOT_PRIVILEGED = 1130;
    public const ER_PASSWORD_ANONYMOUS_USER = 1131;
    public const ER_PASSWORD_NOT_ALLOWED = 1132;
    public const ER_PASSWORD_NO_MATCH = 1133;
    public const ER_UPDATE_INFO = 1134;
    public const ER_CANT_CREATE_THREAD = 1135;
    public const ER_WRONG_VALUE_COUNT_ON_ROW = 1136;
    public const ER_CANT_REOPEN_TABLE = 1137;
    public const ER_INVALID_USE_OF_NULL = 1138;
    public const ER_REGEXP_ERROR = 1139;
    public const ER_MIX_OF_GROUP_FUNC_AND_FIELDS = 1140;
    public const ER_NONEXISTING_GRANT = 1141;
    public const ER_TABLEACCESS_DENIED_ERROR = 1142;
    public const ER_COLUMNACCESS_DENIED_ERROR = 1143;
    public const ER_ILLEGAL_GRANT_FOR_TABLE = 1144;
    public const ER_GRANT_WRONG_HOST_OR_USER = 1145;
    public const ER_NO_SUCH_TABLE = 1146;
    public const ER_NONEXISTING_TABLE_GRANT = 1147;
    public const ER_NOT_ALLOWED_COMMAND = 1148;
    public const ER_SYNTAX_ERROR = 1149;
    public const ER_DELAYED_CANT_CHANGE_LOCK = 1150;
    public const ER_TOO_MANY_DELAYED_THREADS = 1151;
    public const ER_ABORTING_CONNECTION = 1152;
    public const ER_NET_PACKET_TOO_LARGE = 1153;
    public const ER_NET_READ_ERROR_FROM_PIPE = 1154;
    public const ER_NET_FCNTL_ERROR = 1155;
    public const ER_NET_PACKETS_OUT_OF_ORDER = 1156;
    public const ER_NET_UNCOMPRESS_ERROR = 1157;
    public const ER_NET_READ_ERROR = 1158;
    public const ER_NET_READ_INTERRUPTED = 1159;
    public const ER_NET_ERROR_ON_WRITE = 1160;
    public const ER_NET_WRITE_INTERRUPTED = 1161;
    public const ER_TOO_LONG_STRING = 1162;
    public const ER_TABLE_CANT_HANDLE_BLOB = 1163;
    public const ER_TABLE_CANT_HANDLE_AUTO_INCREMENT = 1164;
    public const ER_DELAYED_INSERT_TABLE_LOCKED = 1165;
    public const ER_WRONG_COLUMN_NAME = 1166;
    public const ER_WRONG_KEY_COLUMN = 1167;
    public const ER_WRONG_MRG_TABLE = 1168;
    public const ER_DUP_UNIQUE = 1169;
    public const ER_BLOB_KEY_WITHOUT_LENGTH = 1170;
    public const ER_PRIMARY_CANT_HAVE_NULL = 1171;
    public const ER_TOO_MANY_ROWS = 1172;
    public const ER_REQUIRES_PRIMARY_KEY = 1173;
    public const ER_NO_RAID_COMPILED = 1174;
    public const ER_UPDATE_WITHOUT_KEY_IN_SAFE_MODE = 1175;
    public const ER_KEY_DOES_NOT_EXITS = 1176;
    public const ER_CHECK_NO_SUCH_TABLE = 1177;
    public const ER_CHECK_NOT_IMPLEMENTED = 1178;
    public const ER_CANT_DO_THIS_DURING_AN_TRANSACTION = 1179;
    public const ER_ERROR_DURING_COMMIT = 1180;
    public const ER_ERROR_DURING_ROLLBACK = 1181;
    public const ER_ERROR_DURING_FLUSH_LOGS = 1182;
    public const ER_ERROR_DURING_CHECKPOINT = 1183;
    public const ER_NEW_ABORTING_CONNECTION = 1184;
    public const ER_DUMP_NOT_IMPLEMENTED = 1185;
    public const ER_FLUSH_MASTER_BINLOG_CLOSED = 1186;
    public const ER_INDEX_REBUILD = 1187;
    public const ER_MASTER = 1188;
    public const ER_MASTER_NET_READ = 1189;
    public const ER_MASTER_NET_WRITE = 1190;
    public const ER_FT_MATCHING_KEY_NOT_FOUND = 1191;
    public const ER_LOCK_OR_ACTIVE_TRANSACTION = 1192;
    public const ER_UNKNOWN_SYSTEM_VARIABLE = 1193;
    public const ER_CRASHED_ON_USAGE = 1194;
    public const ER_CRASHED_ON_REPAIR = 1195;
    public const ER_WARNING_NOT_COMPLETE_ROLLBACK = 1196;
    public const ER_TRANS_CACHE_FULL = 1197;
    public const ER_SLAVE_MUST_STOP = 1198;
    public const ER_SLAVE_NOT_RUNNING = 1199;
    public const ER_BAD_SLAVE = 1200;
    public const ER_MASTER_INFO = 1201;
    public const ER_SLAVE_THREAD = 1202;
    public const ER_TOO_MANY_USER_CONNECTIONS = 1203;
    public const ER_SET_CONSTANTS_ONLY = 1204;
    public const ER_LOCK_WAIT_TIMEOUT = 1205;
    public const ER_LOCK_TABLE_FULL = 1206;
    public const ER_READ_ONLY_TRANSACTION = 1207;
    public const ER_DROP_DB_WITH_READ_LOCK = 1208;
    public const ER_CREATE_DB_WITH_READ_LOCK = 1209;
    public const ER_WRONG_ARGUMENTS = 1210;
    public const ER_NO_PERMISSION_TO_CREATE_USER = 1211;
    public const ER_UNION_TABLES_IN_DIFFERENT_DIR = 1212;
    public const ER_LOCK_DEADLOCK = 1213;
    public const ER_TABLE_CANT_HANDLE_FT = 1214;
    public const ER_CANNOT_ADD_FOREIGN = 1215;
    public const ER_NO_REFERENCED_ROW = 1216;
    public const ER_ROW_IS_REFERENCED = 1217;
    public const ER_CONNECT_TO_MASTER = 1218;
    public const ER_QUERY_ON_MASTER = 1219;
    public const ER_ERROR_WHEN_EXECUTING_COMMAND = 1220;
    public const ER_WRONG_USAGE = 1221;
    public const ER_WRONG_NUMBER_OF_COLUMNS_IN_SELECT = 1222;
    public const ER_CANT_UPDATE_WITH_READLOCK = 1223;
    public const ER_MIXING_NOT_ALLOWED = 1224;
    public const ER_DUP_ARGUMENT = 1225;
    public const ER_USER_LIMIT_REACHED = 1226;
    public const ER_SPECIFIC_ACCESS_DENIED_ERROR = 1227;
    public const ER_LOCAL_VARIABLE = 1228;
    public const ER_GLOBAL_VARIABLE = 1229;
    public const ER_NO_DEFAULT = 1230;
    public const ER_WRONG_VALUE_FOR_VAR = 1231;
    public const ER_WRONG_TYPE_FOR_VAR = 1232;
    public const ER_VAR_CANT_BE_READ = 1233;
    public const ER_CANT_USE_OPTION_HERE = 1234;
    public const ER_NOT_SUPPORTED_YET = 1235;
    public const ER_MASTER_FATAL_ERROR_READING_BINLOG = 1236;
    public const ER_SLAVE_IGNORED_TABLE = 1237;
    public const ER_INCORRECT_GLOBAL_LOCAL_VAR = 1238;
    public const ER_WRONG_FK_DEF = 1239;
    public const ER_KEY_REF_DO_NOT_MATCH_TABLE_REF = 1240;
    public const ER_OPERAND_COLUMNS = 1241;
    public const ER_SUBQUERY_NO_1_ROW = 1242;
    public const ER_UNKNOWN_STMT_HANDLER = 1243;
    public const ER_CORRUPT_HELP_DB = 1244;
    public const ER_CYCLIC_REFERENCE = 1245;
    public const ER_AUTO_CONVERT = 1246;
    public const ER_ILLEGAL_REFERENCE = 1247;
    public const ER_DERIVED_MUST_HAVE_ALIAS = 1248;
    public const ER_SELECT_REDUCED = 1249;
    public const ER_TABLENAME_NOT_ALLOWED_HERE = 1250;
    public const ER_NOT_SUPPORTED_AUTH_MODE = 1251;
    public const ER_SPATIAL_CANT_HAVE_NULL = 1252;
    public const ER_COLLATION_CHARSET_MISMATCH = 1253;
    public const ER_SLAVE_WAS_RUNNING = 1254;
    public const ER_SLAVE_WAS_NOT_RUNNING = 1255;
    public const ER_TOO_BIG_FOR_UNCOMPRESS = 1256;
    public const ER_ZLIB_Z_MEM_ERROR = 1257;
    public const ER_ZLIB_Z_BUF_ERROR = 1258;
    public const ER_ZLIB_Z_DATA_ERROR = 1259;
    public const ER_CUT_VALUE_GROUP_CONCAT = 1260;
    public const ER_WARN_TOO_FEW_RECORDS = 1261;
    public const ER_WARN_TOO_MANY_RECORDS = 1262;
    public const ER_WARN_NULL_TO_NOTNULL = 1263;
    public const ER_WARN_DATA_OUT_OF_RANGE = 1264;
    public const WARN_DATA_TRUNCATED = 1265;
    public const ER_WARN_USING_OTHER_HANDLER = 1266;
    public const ER_CANT_AGGREGATE_2COLLATIONS = 1267;
    public const ER_DROP_USER = 1268;
    public const ER_REVOKE_GRANTS = 1269;
    public const ER_CANT_AGGREGATE_3COLLATIONS = 1270;
    public const ER_CANT_AGGREGATE_NCOLLATIONS = 1271;
    public const ER_VARIABLE_IS_NOT_STRUCT = 1272;
    public const ER_UNKNOWN_COLLATION = 1273;
    public const ER_SLAVE_IGNORED_SSL_PARAMS = 1274;
    public const ER_SERVER_IS_IN_SECURE_AUTH_MODE = 1275;
    public const ER_WARN_FIELD_RESOLVED = 1276;
    public const ER_BAD_SLAVE_UNTIL_COND = 1277;
    public const ER_MISSING_SKIP_SLAVE = 1278;
    public const ER_UNTIL_COND_IGNORED = 1279;
    public const ER_WRONG_NAME_FOR_INDEX = 1280;
    public const ER_WRONG_NAME_FOR_CATALOG = 1281;
    public const ER_WARN_QC_RESIZE = 1282;
    public const ER_BAD_FT_COLUMN = 1283;
    public const ER_UNKNOWN_KEY_CACHE = 1284;
    public const ER_WARN_HOSTNAME_WONT_WORK = 1285;
    public const ER_UNKNOWN_STORAGE_ENGINE = 1286;
    public const ER_WARN_DEPRECATED_SYNTAX = 1287;
    public const ER_NON_UPDATABLE_TABLE = 1288;
    public const ER_FEATURE_DISABLED = 1289;
    public const ER_OPTION_PREVENTS_STATEMENT = 1290;
    public const ER_DUPLICATED_VALUE_IN_TYPE = 1291;
    public const ER_TRUNCATED_WRONG_VALUE = 1292;
    public const ER_TOO_MUCH_AUTO_TIMESTAMP_COLS = 1293;
    public const ER_INVALID_ON_UPDATE = 1294;
    public const ER_UNSUPPORTED_PS = 1295;
    public const ER_GET_ERRMSG = 1296;
    public const ER_GET_TEMPORARY_ERRMSG = 1297;
    public const ER_UNKNOWN_TIME_ZONE = 1298;
    public const ER_WARN_INVALID_TIMESTAMP = 1299;
    public const ER_INVALID_CHARACTER_STRING = 1300;
    public const ER_WARN_ALLOWED_PACKET_OVERFLOWED = 1301;
    public const ER_CONFLICTING_DECLARATIONS = 1302;
    public const ER_SP_NO_RECURSIVE_CREATE = 1303;
    public const ER_SP_ALREADY_EXISTS = 1304;
    public const ER_SP_DOES_NOT_EXIST = 1305;
    public const ER_SP_DROP_FAILED = 1306;
    public const ER_SP_STORE_FAILED = 1307;
    public const ER_SP_LILABEL_MISMATCH = 1308;
    public const ER_SP_LABEL_REDEFINE = 1309;
    public const ER_SP_LABEL_MISMATCH = 1310;
    public const ER_SP_UNINIT_VAR = 1311;
    public const ER_SP_BADSELECT = 1312;
    public const ER_SP_BADRETURN = 1313;
    public const ER_SP_BADSTATEMENT = 1314;
    public const ER_UPDATE_LOG_DEPRECATED_IGNORED = 1315;
    public const ER_UPDATE_LOG_DEPRECATED_TRANSLATED = 1316;
    public const ER_QUERY_INTERRUPTED = 1317;
    public const ER_SP_WRONG_NO_OF_ARGS = 1318;
    public const ER_SP_COND_MISMATCH = 1319;
    public const ER_SP_NORETURN = 1320;
    public const ER_SP_NORETURNEND = 1321;
    public const ER_SP_BAD_CURSOR_QUERY = 1322;
    public const ER_SP_BAD_CURSOR_SELECT = 1323;
    public const ER_SP_CURSOR_MISMATCH = 1324;
    public const ER_SP_CURSOR_ALREADY_OPEN = 1325;
    public const ER_SP_CURSOR_NOT_OPEN = 1326;
    public const ER_SP_UNDECLARED_VAR = 1327;
    public const ER_SP_WRONG_NO_OF_FETCH_ARGS = 1328;
    public const ER_SP_FETCH_NO_DATA = 1329;
    public const ER_SP_DUP_PARAM = 1330;
    public const ER_SP_DUP_VAR = 1331;
    public const ER_SP_DUP_COND = 1332;
    public const ER_SP_DUP_CURS = 1333;
    public const ER_SP_CANT_ALTER = 1334;
    public const ER_SP_SUBSELECT_NYI = 1335;
    public const ER_STMT_NOT_ALLOWED_IN_SF_OR_TRG = 1336;
    public const ER_SP_VARCOND_AFTER_CURSHNDLR = 1337;
    public const ER_SP_CURSOR_AFTER_HANDLER = 1338;
    public const ER_SP_CASE_NOT_FOUND = 1339;
    public const ER_FPARSER_TOO_BIG_FILE = 1340;
    public const ER_FPARSER_BAD_HEADER = 1341;
    public const ER_FPARSER_EOF_IN_COMMENT = 1342;
    public const ER_FPARSER_ERROR_IN_PARAMETER = 1343;
    public const ER_FPARSER_EOF_IN_UNKNOWN_PARAMETER = 1344;
    public const ER_VIEW_NO_EXPLAIN = 1345;
    public const ER_FRM_UNKNOWN_TYPE = 1346;
    public const ER_WRONG_OBJECT = 1347;
    public const ER_NONUPDATEABLE_COLUMN = 1348;
    public const ER_VIEW_SELECT_DERIVED = 1349;
    public const ER_VIEW_SELECT_CLAUSE = 1350;
    public const ER_VIEW_SELECT_VARIABLE = 1351;
    public const ER_VIEW_SELECT_TMPTABLE = 1352;
    public const ER_VIEW_WRONG_LIST = 1353;
    public const ER_WARN_VIEW_MERGE = 1354;
    public const ER_WARN_VIEW_WITHOUT_KEY = 1355;
    public const ER_VIEW_INVALID = 1356;
    public const ER_SP_NO_DROP_SP = 1357;
    public const ER_SP_GOTO_IN_HNDLR = 1358;
    public const ER_TRG_ALREADY_EXISTS = 1359;
    public const ER_TRG_DOES_NOT_EXIST = 1360;
    public const ER_TRG_ON_VIEW_OR_TEMP_TABLE = 1361;
    public const ER_TRG_CANT_CHANGE_ROW = 1362;
    public const ER_TRG_NO_SUCH_ROW_IN_TRG = 1363;
    public const ER_NO_DEFAULT_FOR_FIELD = 1364;
    public const ER_DIVISION_BY_ZERO = 1365;
    public const ER_TRUNCATED_WRONG_VALUE_FOR_FIELD = 1366;
    public const ER_ILLEGAL_VALUE_FOR_TYPE = 1367;
    public const ER_VIEW_NONUPD_CHECK = 1368;
    public const ER_VIEW_CHECK_FAILED = 1369;
    public const ER_PROCACCESS_DENIED_ERROR = 1370;
    public const ER_RELAY_LOG_FAIL = 1371;
    public const ER_PASSWD_LENGTH = 1372;
    public const ER_UNKNOWN_TARGET_BINLOG = 1373;
    public const ER_IO_ERR_LOG_INDEX_READ = 1374;
    public const ER_BINLOG_PURGE_PROHIBITED = 1375;
    public const ER_FSEEK_FAIL = 1376;
    public const ER_BINLOG_PURGE_FATAL_ERR = 1377;
    public const ER_LOG_IN_USE = 1378;
    public const ER_LOG_PURGE_UNKNOWN_ERR = 1379;
    public const ER_RELAY_LOG_INIT = 1380;
    public const ER_NO_BINARY_LOGGING = 1381;
    public const ER_RESERVED_SYNTAX = 1382;
    public const ER_WSAS_FAILED = 1383;
    public const ER_DIFF_GROUPS_PROC = 1384;
    public const ER_NO_GROUP_FOR_PROC = 1385;
    public const ER_ORDER_WITH_PROC = 1386;
    public const ER_LOGGING_PROHIBIT_CHANGING_OF = 1387;
    public const ER_NO_FILE_MAPPING = 1388;
    public const ER_WRONG_MAGIC = 1389;
    public const ER_PS_MANY_PARAM = 1390;
    public const ER_KEY_PART_0 = 1391;
    public const ER_VIEW_CHECKSUM = 1392;
    public const ER_VIEW_MULTIUPDATE = 1393;
    public const ER_VIEW_NO_INSERT_FIELD_LIST = 1394;
    public const ER_VIEW_DELETE_MERGE_VIEW = 1395;
    public const ER_CANNOT_USER = 1396;
    public const ER_XAER_NOTA = 1397;
    public const ER_XAER_INVAL = 1398;
    public const ER_XAER_RMFAIL = 1399;
    public const ER_XAER_OUTSIDE = 1400;
    public const ER_XAER_RMERR = 1401;
    public const ER_XA_RBROLLBACK = 1402;
    public const ER_NONEXISTING_PROC_GRANT = 1403;
    public const ER_PROC_AUTO_GRANT_FAIL = 1404;
    public const ER_PROC_AUTO_REVOKE_FAIL = 1405;
    public const ER_DATA_TOO_LONG = 1406;
    public const ER_SP_BAD_SQLSTATE = 1407;
    public const ER_STARTUP = 1408;
    public const ER_LOAD_FROM_FIXED_SIZE_ROWS_TO_VAR = 1409;
    public const ER_CANT_CREATE_USER_WITH_GRANT = 1410;
    public const ER_WRONG_VALUE_FOR_TYPE = 1411;
    public const ER_TABLE_DEF_CHANGED = 1412;
    public const ER_SP_DUP_HANDLER = 1413;
    public const ER_SP_NOT_VAR_ARG = 1414;
    public const ER_SP_NO_RETSET = 1415;
    public const ER_CANT_CREATE_GEOMETRY_OBJECT = 1416;
    public const ER_FAILED_ROUTINE_BREAK_BINLOG = 1417;
    public const ER_BINLOG_UNSAFE_ROUTINE = 1418;
    public const ER_BINLOG_CREATE_ROUTINE_NEED_SUPER = 1419;
    public const ER_EXEC_STMT_WITH_OPEN_CURSOR = 1420;
    public const ER_STMT_HAS_NO_OPEN_CURSOR = 1421;
    public const ER_COMMIT_NOT_ALLOWED_IN_SF_OR_TRG = 1422;
    public const ER_NO_DEFAULT_FOR_VIEW_FIELD = 1423;
    public const ER_SP_NO_RECURSION = 1424;
    public const ER_TOO_BIG_SCALE = 1425;
    public const ER_TOO_BIG_PRECISION = 1426;
    public const ER_M_BIGGER_THAN_D = 1427;
    public const ER_WRONG_LOCK_OF_SYSTEM_TABLE = 1428;
    public const ER_CONNECT_TO_FOREIGN_DATA_SOURCE = 1429;
    public const ER_QUERY_ON_FOREIGN_DATA_SOURCE = 1430;
    public const ER_FOREIGN_DATA_SOURCE_DOESNT_EXIST = 1431;
    public const ER_FOREIGN_DATA_STRING_INVALID_CANT_CREATE = 1432;
    public const ER_FOREIGN_DATA_STRING_INVALID = 1433;
    public const ER_CANT_CREATE_FEDERATED_TABLE = 1434;
    public const ER_TRG_IN_WRONG_SCHEMA = 1435;
    public const ER_STACK_OVERRUN_NEED_MORE = 1436;
    public const ER_TOO_LONG_BODY = 1437;
    public const ER_WARN_CANT_DROP_DEFAULT_KEYCACHE = 1438;
    public const ER_TOO_BIG_DISPLAYWIDTH = 1439;
    public const ER_XAER_DUPID = 1440;
    public const ER_DATETIME_FUNCTION_OVERFLOW = 1441;
    public const ER_CANT_UPDATE_USED_TABLE_IN_SF_OR_TRG = 1442;
    public const ER_VIEW_PREVENT_UPDATE = 1443;
    public const ER_PS_NO_RECURSION = 1444;
    public const ER_SP_CANT_SET_AUTOCOMMIT = 1445;
    public const ER_MALFORMED_DEFINER = 1446;
    public const ER_VIEW_FRM_NO_USER = 1447;
    public const ER_VIEW_OTHER_USER = 1448;
    public const ER_NO_SUCH_USER = 1449;
    public const ER_FORBID_SCHEMA_CHANGE = 1450;
    public const ER_ROW_IS_REFERENCED_2 = 1451;
    public const ER_NO_REFERENCED_ROW_2 = 1452;
    public const ER_SP_BAD_VAR_SHADOW = 1453;
    public const ER_TRG_NO_DEFINER = 1454;
    public const ER_OLD_FILE_FORMAT = 1455;
    public const ER_SP_RECURSION_LIMIT = 1456;
    public const ER_SP_PROC_TABLE_CORRUPT = 1457;
    public const ER_SP_WRONG_NAME = 1458;
    public const ER_TABLE_NEEDS_UPGRADE = 1459;
    public const ER_SP_NO_AGGREGATE = 1460;
    public const ER_MAX_PREPARED_STMT_COUNT_REACHED = 1461;
    public const ER_VIEW_RECURSIVE = 1462;
    public const ER_NON_GROUPING_FIELD_USED = 1463;
    public const ER_TABLE_CANT_HANDLE_SPKEYS = 1464;
    public const ER_NO_TRIGGERS_ON_SYSTEM_SCHEMA = 1465;
    public const ER_REMOVED_SPACES = 1466;
    public const ER_AUTOINC_READ_FAILED = 1467;
    public const ER_USERNAME = 1468;
    public const ER_HOSTNAME = 1469;
    public const ER_WRONG_STRING_LENGTH = 1470;
    public const ER_NON_INSERTABLE_TABLE = 1471;
    public const ER_ADMIN_WRONG_MRG_TABLE = 1472;
    public const ER_TOO_HIGH_LEVEL_OF_NESTING_FOR_SELECT = 1473;
    public const ER_NAME_BECOMES_EMPTY = 1474;
    public const ER_AMBIGUOUS_FIELD_TERM = 1475;
    public const ER_FOREIGN_SERVER_EXISTS = 1476;
    public const ER_FOREIGN_SERVER_DOESNT_EXIST = 1477;
    public const ER_ILLEGAL_HA_CREATE_OPTION = 1478;
    public const ER_PARTITION_REQUIRES_VALUES_ERROR = 1479;
    public const ER_PARTITION_WRONG_VALUES_ERROR = 1480;
    public const ER_PARTITION_MAXVALUE_ERROR = 1481;
    public const ER_PARTITION_SUBPARTITION_ERROR = 1482;
    public const ER_PARTITION_SUBPART_MIX_ERROR = 1483;
    public const ER_PARTITION_WRONG_NO_PART_ERROR = 1484;
    public const ER_PARTITION_WRONG_NO_SUBPART_ERROR = 1485;
    public const ER_WRONG_EXPR_IN_PARTITION_FUNC_ERROR = 1486;
    public const ER_NO_CONST_EXPR_IN_RANGE_OR_LIST_ERROR = 1487;
    public const ER_FIELD_NOT_FOUND_PART_ERROR = 1488;
    public const ER_LIST_OF_FIELDS_ONLY_IN_HASH_ERROR = 1489;
    public const ER_INCONSISTENT_PARTITION_INFO_ERROR = 1490;
    public const ER_PARTITION_FUNC_NOT_ALLOWED_ERROR = 1491;
    public const ER_PARTITIONS_MUST_BE_DEFINED_ERROR = 1492;
    public const ER_RANGE_NOT_INCREASING_ERROR = 1493;
    public const ER_INCONSISTENT_TYPE_OF_FUNCTIONS_ERROR = 1494;
    public const ER_MULTIPLE_DEF_CONST_IN_LIST_PART_ERROR = 1495;
    public const ER_PARTITION_ENTRY_ERROR = 1496;
    public const ER_MIX_HANDLER_ERROR = 1497;
    public const ER_PARTITION_NOT_DEFINED_ERROR = 1498;
    public const ER_TOO_MANY_PARTITIONS_ERROR = 1499;
    public const ER_SUBPARTITION_ERROR = 1500;
    public const ER_CANT_CREATE_HANDLER_FILE = 1501;
    public const ER_BLOB_FIELD_IN_PART_FUNC_ERROR = 1502;
    public const ER_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF = 1503;
    public const ER_NO_PARTS_ERROR = 1504;
    public const ER_PARTITION_MGMT_ON_NONPARTITIONED = 1505;
    public const ER_FOREIGN_KEY_ON_PARTITIONED = 1506;
    public const ER_DROP_PARTITION_NON_EXISTENT = 1507;
    public const ER_DROP_LAST_PARTITION = 1508;
    public const ER_COALESCE_ONLY_ON_HASH_PARTITION = 1509;
    public const ER_REORG_HASH_ONLY_ON_SAME_NO = 1510;
    public const ER_REORG_NO_PARAM_ERROR = 1511;
    public const ER_ONLY_ON_RANGE_LIST_PARTITION = 1512;
    public const ER_ADD_PARTITION_SUBPART_ERROR = 1513;
    public const ER_ADD_PARTITION_NO_NEW_PARTITION = 1514;
    public const ER_COALESCE_PARTITION_NO_PARTITION = 1515;
    public const ER_REORG_PARTITION_NOT_EXIST = 1516;
    public const ER_SAME_NAME_PARTITION = 1517;
    public const ER_NO_BINLOG_ERROR = 1518;
    public const ER_CONSECUTIVE_REORG_PARTITIONS = 1519;
    public const ER_REORG_OUTSIDE_RANGE = 1520;
    public const ER_PARTITION_FUNCTION_FAILURE = 1521;
    public const ER_PART_STATE_ERROR = 1522;
    public const ER_LIMITED_PART_RANGE = 1523;
    public const ER_PLUGIN_IS_NOT_LOADED = 1524;
    public const ER_WRONG_VALUE = 1525;
    public const ER_NO_PARTITION_FOR_GIVEN_VALUE = 1526;
    public const ER_FILEGROUP_OPTION_ONLY_ONCE = 1527;
    public const ER_CREATE_FILEGROUP_FAILED = 1528;
    public const ER_DROP_FILEGROUP_FAILED = 1529;
    public const ER_TABLESPACE_AUTO_EXTEND_ERROR = 1530;
    public const ER_WRONG_SIZE_NUMBER = 1531;
    public const ER_SIZE_OVERFLOW_ERROR = 1532;
    public const ER_ALTER_FILEGROUP_FAILED = 1533;
    public const ER_BINLOG_ROW_LOGGING_FAILED = 1534;
    public const ER_BINLOG_ROW_WRONG_TABLE_DEF = 1535;
    public const ER_BINLOG_ROW_RBR_TO_SBR = 1536;
    public const ER_EVENT_ALREADY_EXISTS = 1537;
    public const ER_EVENT_STORE_FAILED = 1538;
    public const ER_EVENT_DOES_NOT_EXIST = 1539;
    public const ER_EVENT_CANT_ALTER = 1540;
    public const ER_EVENT_DROP_FAILED = 1541;
    public const ER_EVENT_INTERVAL_NOT_POSITIVE_OR_TOO_BIG = 1542;
    public const ER_EVENT_ENDS_BEFORE_STARTS = 1543;
    public const ER_EVENT_EXEC_TIME_IN_THE_PAST = 1544;
    public const ER_EVENT_OPEN_TABLE_FAILED = 1545;
    public const ER_EVENT_NEITHER_M_EXPR_NOR_M_AT = 1546;
    public const ER_COL_COUNT_DOESNT_MATCH_CORRUPTED = 1547;
    public const ER_CANNOT_LOAD_FROM_TABLE = 1548;
    public const ER_EVENT_CANNOT_DELETE = 1549;
    public const ER_EVENT_COMPILE_ERROR = 1550;
    public const ER_EVENT_SAME_NAME = 1551;
    public const ER_EVENT_DATA_TOO_LONG = 1552;
    public const ER_DROP_INDEX_FK = 1553;
    public const ER_WARN_DEPRECATED_SYNTAX_WITH_VER = 1554;
    public const ER_CANT_WRITE_LOCK_LOG_TABLE = 1555;
    public const ER_CANT_LOCK_LOG_TABLE = 1556;
    public const ER_FOREIGN_DUPLICATE_KEY = 1557;
    public const ER_COL_COUNT_DOESNT_MATCH_PLEASE_UPDATE = 1558;
    public const ER_TEMP_TABLE_PREVENTS_SWITCH_OUT_OF_RBR = 1559;
    public const ER_STORED_FUNCTION_PREVENTS_SWITCH_BINLOG_FORMAT = 1560;
    public const ER_NDB_CANT_SWITCH_BINLOG_FORMAT = 1561;
    public const ER_PARTITION_NO_TEMPORARY = 1562;
    public const ER_PARTITION_CONST_DOMAIN_ERROR = 1563;
    public const ER_PARTITION_FUNCTION_IS_NOT_ALLOWED = 1564;
    public const ER_DDL_LOG_ERROR = 1565;
    public const ER_NULL_IN_VALUES_LESS_THAN = 1566;
    public const ER_WRONG_PARTITION_NAME = 1567;
    public const ER_CANT_CHANGE_TX_ISOLATION = 1568;
    public const ER_DUP_ENTRY_AUTOINCREMENT_CASE = 1569;
    public const ER_EVENT_MODIFY_QUEUE_ERROR = 1570;
    public const ER_EVENT_SET_VAR_ERROR = 1571;
    public const ER_PARTITION_MERGE_ERROR = 1572;
    public const ER_CANT_ACTIVATE_LOG = 1573;
    public const ER_RBR_NOT_AVAILABLE = 1574;
    public const ER_BASE64_DECODE_ERROR = 1575;
    public const ER_EVENT_RECURSION_FORBIDDEN = 1576;
    public const ER_EVENTS_DB_ERROR = 1577;
    public const ER_ONLY_INTEGERS_ALLOWED = 1578;
    public const ER_UNSUPORTED_LOG_ENGINE = 1579;
    public const ER_BAD_LOG_STATEMENT = 1580;
    public const ER_CANT_RENAME_LOG_TABLE = 1581;
    public const ER_WRONG_PARAMCOUNT_TO_NATIVE_FCT = 1582;
    public const ER_WRONG_PARAMETERS_TO_NATIVE_FCT = 1583;
    public const ER_WRONG_PARAMETERS_TO_STORED_FCT = 1584;
    public const ER_NATIVE_FCT_NAME_COLLISION = 1585;
    public const ER_DUP_ENTRY_WITH_KEY_NAME = 1586;
    public const ER_BINLOG_PURGE_EMFILE = 1587;
    public const ER_EVENT_CANNOT_CREATE_IN_THE_PAST = 1588;
    public const ER_EVENT_CANNOT_ALTER_IN_THE_PAST = 1589;
    public const ER_SLAVE_INCIDENT = 1590;
    public const ER_NO_PARTITION_FOR_GIVEN_VALUE_SILENT = 1591;
    public const ER_BINLOG_UNSAFE_STATEMENT = 1592;
    public const ER_SLAVE_FATAL_ERROR = 1593;
    public const ER_SLAVE_RELAY_LOG_READ_FAILURE = 1594;
    public const ER_SLAVE_RELAY_LOG_WRITE_FAILURE = 1595;
    public const ER_SLAVE_CREATE_EVENT_FAILURE = 1596;
    public const ER_SLAVE_MASTER_COM_FAILURE = 1597;
    public const ER_BINLOG_LOGGING_IMPOSSIBLE = 1598;
    public const ER_VIEW_NO_CREATION_CTX = 1599;
    public const ER_VIEW_INVALID_CREATION_CTX = 1600;
    public const ER_SR_INVALID_CREATION_CTX = 1601;
    public const ER_TRG_CORRUPTED_FILE = 1602;
    public const ER_TRG_NO_CREATION_CTX = 1603;
    public const ER_TRG_INVALID_CREATION_CTX = 1604;
    public const ER_EVENT_INVALID_CREATION_CTX = 1605;
    public const ER_TRG_CANT_OPEN_TABLE = 1606;
    public const ER_CANT_CREATE_SROUTINE = 1607;
    public const ER_SLAVE_AMBIGOUS_EXEC_MODE = 1608;
    public const ER_NO_FORMAT_DESCRIPTION_EVENT_BEFORE_BINLOG_STATEMENT = 1609;
    public const ER_SLAVE_CORRUPT_EVENT = 1610;
    public const ER_LOAD_DATA_INVALID_COLUMN = 1611;
    public const ER_LOG_PURGE_NO_FILE = 1612;
    public const ER_XA_RBTIMEOUT = 1613;
    public const ER_XA_RBDEADLOCK = 1614;
    public const ER_NEED_REPREPARE = 1615;
    public const ER_DELAYED_NOT_SUPPORTED = 1616;
    public const WARN_NO_MASTER_INFO = 1617;
    public const WARN_OPTION_IGNORED = 1618;
    public const WARN_PLUGIN_DELETE_BUILTIN = 1619;
    public const WARN_PLUGIN_BUSY = 1620;
    public const ER_VARIABLE_IS_READONLY = 1621;
    public const ER_WARN_ENGINE_TRANSACTION_ROLLBACK = 1622;
    public const ER_SLAVE_HEARTBEAT_FAILURE = 1623;
    public const ER_SLAVE_HEARTBEAT_VALUE_OUT_OF_RANGE = 1624;
    public const ER_NDB_REPLICATION_SCHEMA_ERROR = 1625;
    public const ER_CONFLICT_FN_PARSE_ERROR = 1626;
    public const ER_EXCEPTIONS_WRITE_ERROR = 1627;
    public const ER_TOO_LONG_TABLE_COMMENT = 1628;
    public const ER_TOO_LONG_FIELD_COMMENT = 1629;
    public const ER_FUNC_INEXISTENT_NAME_COLLISION = 1630;
    public const ER_DATABASE_NAME = 1631;
    public const ER_TABLE_NAME = 1632;
    public const ER_PARTITION_NAME = 1633;
    public const ER_SUBPARTITION_NAME = 1634;
    public const ER_TEMPORARY_NAME = 1635;
    public const ER_RENAMED_NAME = 1636;
    public const ER_TOO_MANY_CONCURRENT_TRXS = 1637;
    public const WARN_NON_ASCII_SEPARATOR_NOT_IMPLEMENTED = 1638;
    public const ER_DEBUG_SYNC_TIMEOUT = 1639;
    public const ER_DEBUG_SYNC_HIT_LIMIT = 1640;
    public const ER_DUP_SIGNAL_SET = 1641;
    public const ER_SIGNAL_WARN = 1642;
    public const ER_SIGNAL_NOT_FOUND = 1643;
    public const ER_SIGNAL_EXCEPTION = 1644;
    public const ER_RESIGNAL_WITHOUT_ACTIVE_HANDLER = 1645;
    public const ER_SIGNAL_BAD_CONDITION_TYPE = 1646;
    public const WARN_COND_ITEM_TRUNCATED = 1647;
    public const ER_COND_ITEM_TOO_LONG = 1648;
    public const ER_UNKNOWN_LOCALE = 1649;
    public const ER_SLAVE_IGNORE_SERVER_IDS = 1650;
    public const ER_QUERY_CACHE_DISABLED = 1651;
    public const ER_SAME_NAME_PARTITION_FIELD = 1652;
    public const ER_PARTITION_COLUMN_LIST_ERROR = 1653;
    public const ER_WRONG_TYPE_COLUMN_VALUE_ERROR = 1654;
    public const ER_TOO_MANY_PARTITION_FUNC_FIELDS_ERROR = 1655;
    public const ER_MAXVALUE_IN_VALUES_IN = 1656;
    public const ER_TOO_MANY_VALUES_ERROR = 1657;
    public const ER_ROW_SINGLE_PARTITION_FIELD_ERROR = 1658;
    public const ER_FIELD_TYPE_NOT_ALLOWED_AS_PARTITION_FIELD = 1659;
    public const ER_PARTITION_FIELDS_TOO_LONG = 1660;
    public const ER_BINLOG_ROW_ENGINE_AND_STMT_ENGINE = 1661;
    public const ER_BINLOG_ROW_MODE_AND_STMT_ENGINE = 1662;
    public const ER_BINLOG_UNSAFE_AND_STMT_ENGINE = 1663;
    public const ER_BINLOG_ROW_INJECTION_AND_STMT_ENGINE = 1664;
    public const ER_BINLOG_STMT_MODE_AND_ROW_ENGINE = 1665;
    public const ER_BINLOG_ROW_INJECTION_AND_STMT_MODE = 1666;
    public const ER_BINLOG_MULTIPLE_ENGINES_AND_SELF_LOGGING_ENGINE = 1667;
    public const ER_BINLOG_UNSAFE_LIMIT = 1668;
    public const ER_BINLOG_UNSAFE_INSERT_DELAYED = 1669;
    public const ER_BINLOG_UNSAFE_SYSTEM_TABLE = 1670;
    public const ER_BINLOG_UNSAFE_AUTOINC_COLUMNS = 1671;
    public const ER_BINLOG_UNSAFE_UDF = 1672;
    public const ER_BINLOG_UNSAFE_SYSTEM_VARIABLE = 1673;
    public const ER_BINLOG_UNSAFE_SYSTEM_FUNCTION = 1674;
    public const ER_BINLOG_UNSAFE_NONTRANS_AFTER_TRANS = 1675;
    public const ER_MESSAGE_AND_STATEMENT = 1676;
    public const ER_SLAVE_CONVERSION_FAILED = 1677;
    public const ER_SLAVE_CANT_CREATE_CONVERSION = 1678;
    public const ER_INSIDE_TRANSACTION_PREVENTS_SWITCH_BINLOG_FORMAT = 1679;
    public const ER_PATH_LENGTH = 1680;
    public const ER_WARN_DEPRECATED_SYNTAX_NO_REPLACEMENT = 1681;
    public const ER_WRONG_NATIVE_TABLE_STRUCTURE = 1682;
    public const ER_WRONG_PERFSCHEMA_USAGE = 1683;
    public const ER_WARN_I_S_SKIPPED_TABLE = 1684;
    public const ER_INSIDE_TRANSACTION_PREVENTS_SWITCH_BINLOG_DIRECT = 1685;
    public const ER_STORED_FUNCTION_PREVENTS_SWITCH_BINLOG_DIRECT = 1686;
    public const ER_SPATIAL_MUST_HAVE_GEOM_COL = 1687;
    public const ER_TOO_LONG_INDEX_COMMENT = 1688;
    public const ER_LOCK_ABORTED = 1689;
    public const ER_DATA_OUT_OF_RANGE = 1690;
    public const ER_WRONG_SPVAR_TYPE_IN_LIMIT = 1691;
    public const ER_BINLOG_UNSAFE_MULTIPLE_ENGINES_AND_SELF_LOGGING_ENGINE = 1692;
    public const ER_BINLOG_UNSAFE_MIXED_STATEMENT = 1693;
    public const ER_INSIDE_TRANSACTION_PREVENTS_SWITCH_SQL_LOG_BIN = 1694;
    public const ER_STORED_FUNCTION_PREVENTS_SWITCH_SQL_LOG_BIN = 1695;
    public const ER_FAILED_READ_FROM_PAR_FILE = 1696;
    public const ER_VALUES_IS_NOT_INT_TYPE_ERROR = 1697;
    public const ER_ACCESS_DENIED_NO_PASSWORD_ERROR = 1698;
    public const ER_SET_PASSWORD_AUTH_PLUGIN = 1699;
    public const ER_GRANT_PLUGIN_USER_EXISTS = 1700;
    public const ER_TRUNCATE_ILLEGAL_FK = 1701;
    public const ER_PLUGIN_IS_PERMANENT = 1702;
    public const ER_SLAVE_HEARTBEAT_VALUE_OUT_OF_RANGE_MIN = 1703;
    public const ER_SLAVE_HEARTBEAT_VALUE_OUT_OF_RANGE_MAX = 1704;
    public const ER_STMT_CACHE_FULL = 1705;
    public const ER_MULTI_UPDATE_KEY_CONFLICT = 1706;
    public const ER_TABLE_NEEDS_REBUILD = 1707;
    public const WARN_OPTION_BELOW_LIMIT = 1708;
    public const ER_INDEX_COLUMN_TOO_LONG = 1709;
    public const ER_ERROR_IN_TRIGGER_BODY = 1710;
    public const ER_ERROR_IN_UNKNOWN_TRIGGER_BODY = 1711;
    public const ER_INDEX_CORRUPT = 1712;
    public const ER_UNDO_RECORD_TOO_BIG = 1713;
    public const ER_BINLOG_UNSAFE_INSERT_IGNORE_SELECT = 1714;
    public const ER_BINLOG_UNSAFE_INSERT_SELECT_UPDATE = 1715;
    public const ER_BINLOG_UNSAFE_REPLACE_SELECT = 1716;
    public const ER_BINLOG_UNSAFE_CREATE_IGNORE_SELECT = 1717;
    public const ER_BINLOG_UNSAFE_CREATE_REPLACE_SELECT = 1718;
    public const ER_BINLOG_UNSAFE_UPDATE_IGNORE = 1719;
    public const ER_PLUGIN_NO_UNINSTALL = 1720;
    public const ER_PLUGIN_NO_INSTALL = 1721;
    public const ER_BINLOG_UNSAFE_WRITE_AUTOINC_SELECT = 1722;
    public const ER_BINLOG_UNSAFE_CREATE_SELECT_AUTOINC = 1723;
    public const ER_BINLOG_UNSAFE_INSERT_TWO_KEYS = 1724;
    public const ER_TABLE_IN_FK_CHECK = 1725;
    public const ER_UNSUPPORTED_ENGINE = 1726;
    public const ER_BINLOG_UNSAFE_AUTOINC_NOT_FIRST = 1727;
    public const ER_CANNOT_LOAD_FROM_TABLE_V2 = 1728;
    public const ER_MASTER_DELAY_VALUE_OUT_OF_RANGE = 1729;
    public const ER_ONLY_FD_AND_RBR_EVENTS_ALLOWED_IN_BINLOG_STATEMENT = 1730;
    public const ER_PARTITION_EXCHANGE_DIFFERENT_OPTION = 1731;
    public const ER_PARTITION_EXCHANGE_PART_TABLE = 1732;
    public const ER_PARTITION_EXCHANGE_TEMP_TABLE = 1733;
    public const ER_PARTITION_INSTEAD_OF_SUBPARTITION = 1734;
    public const ER_UNKNOWN_PARTITION = 1735;
    public const ER_TABLES_DIFFERENT_METADATA = 1736;
    public const ER_ROW_DOES_NOT_MATCH_PARTITION = 1737;
    public const ER_BINLOG_CACHE_SIZE_GREATER_THAN_MAX = 1738;
    public const ER_WARN_INDEX_NOT_APPLICABLE = 1739;
    public const ER_PARTITION_EXCHANGE_FOREIGN_KEY = 1740;
    public const ER_NO_SUCH_KEY_VALUE = 1741;
    public const ER_RPL_INFO_DATA_TOO_LONG = 1742;
    public const ER_NETWORK_READ_EVENT_CHECKSUM_FAILURE = 1743;
    public const ER_BINLOG_READ_EVENT_CHECKSUM_FAILURE = 1744;
    public const ER_BINLOG_STMT_CACHE_SIZE_GREATER_THAN_MAX = 1745;
    public const ER_CANT_UPDATE_TABLE_IN_CREATE_TABLE_SELECT = 1746;
    public const ER_PARTITION_CLAUSE_ON_NONPARTITIONED = 1747;
    public const ER_ROW_DOES_NOT_MATCH_GIVEN_PARTITION_SET = 1748;
    public const ER_NO_SUCH_PARTITION__UNUSED = 1749;
    public const ER_CHANGE_RPL_INFO_REPOSITORY_FAILURE = 1750;
    public const ER_WARNING_NOT_COMPLETE_ROLLBACK_WITH_CREATED_TEMP_TABLE = 1751;
    public const ER_WARNING_NOT_COMPLETE_ROLLBACK_WITH_DROPPED_TEMP_TABLE = 1752;
    public const ER_MTS_FEATURE_IS_NOT_SUPPORTED = 1753;
    public const ER_MTS_UPDATED_DBS_GREATER_MAX = 1754;
    public const ER_MTS_CANT_PARALLEL = 1755;
    public const ER_MTS_INCONSISTENT_DATA = 1756;
    public const ER_FULLTEXT_NOT_SUPPORTED_WITH_PARTITIONING = 1757;
    public const ER_DA_INVALID_CONDITION_NUMBER = 1758;
    public const ER_INSECURE_PLAIN_TEXT = 1759;
    public const ER_INSECURE_CHANGE_MASTER = 1760;
    public const ER_FOREIGN_DUPLICATE_KEY_WITH_CHILD_INFO = 1761;
    public const ER_FOREIGN_DUPLICATE_KEY_WITHOUT_CHILD_INFO = 1762;
    public const ER_SQLTHREAD_WITH_SECURE_SLAVE = 1763;
    public const ER_TABLE_HAS_NO_FT = 1764;
    public const ER_VARIABLE_NOT_SETTABLE_IN_SF_OR_TRIGGER = 1765;
    public const ER_VARIABLE_NOT_SETTABLE_IN_TRANSACTION = 1766;
    public const ER_GTID_NEXT_IS_NOT_IN_GTID_NEXT_LIST = 1767;
    public const ER_CANT_CHANGE_GTID_NEXT_IN_TRANSACTION_WHEN_GTID_NEXT_LIST_IS_NULL = 1768;
    public const ER_SET_STATEMENT_CANNOT_INVOKE_FUNCTION = 1769;
    public const ER_GTID_NEXT_CANT_BE_AUTOMATIC_IF_GTID_NEXT_LIST_IS_NON_NULL = 1770;
    public const ER_SKIPPING_LOGGED_TRANSACTION = 1771;
    public const ER_MALFORMED_GTID_SET_SPECIFICATION = 1772;
    public const ER_MALFORMED_GTID_SET_ENCODING = 1773;
    public const ER_MALFORMED_GTID_SPECIFICATION = 1774;
    public const ER_GNO_EXHAUSTED = 1775;
    public const ER_BAD_SLAVE_AUTO_POSITION = 1776;
    public const ER_AUTO_POSITION_REQUIRES_GTID_MODE_ON = 1777;
    public const ER_CANT_DO_IMPLICIT_COMMIT_IN_TRX_WHEN_GTID_NEXT_IS_SET = 1778;
    public const ER_GTID_MODE_2_OR_3_REQUIRES_DISABLE_GTID_UNSAFE_STATEMENTS_ON = 1779;
    public const ER_GTID_MODE_REQUIRES_BINLOG = 1780;
    public const ER_CANT_SET_GTID_NEXT_TO_GTID_WHEN_GTID_MODE_IS_OFF = 1781;
    public const ER_CANT_SET_GTID_NEXT_TO_ANONYMOUS_WHEN_GTID_MODE_IS_ON = 1782;
    public const ER_CANT_SET_GTID_NEXT_LIST_TO_NON_NULL_WHEN_GTID_MODE_IS_OFF = 1783;
    public const ER_FOUND_GTID_EVENT_WHEN_GTID_MODE_IS_OFF = 1784;
    public const ER_GTID_UNSAFE_NON_TRANSACTIONAL_TABLE = 1785;
    public const ER_GTID_UNSAFE_CREATE_SELECT = 1786;
    public const ER_GTID_UNSAFE_CREATE_DROP_TEMPORARY_TABLE_IN_TRANSACTION = 1787;
    public const ER_GTID_MODE_CAN_ONLY_CHANGE_ONE_STEP_AT_A_TIME = 1788;
    public const ER_MASTER_HAS_PURGED_REQUIRED_GTIDS = 1789;
    public const ER_CANT_SET_GTID_NEXT_WHEN_OWNING_GTID = 1790;
    public const ER_UNKNOWN_EXPLAIN_FORMAT = 1791;
    public const ER_CANT_EXECUTE_IN_READ_ONLY_TRANSACTION = 1792;
    public const ER_TOO_LONG_TABLE_PARTITION_COMMENT = 1793;
    public const ER_SLAVE_CONFIGURATION = 1794;
    public const ER_INNODB_FT_LIMIT = 1795;
    public const ER_INNODB_NO_FT_TEMP_TABLE = 1796;
    public const ER_INNODB_FT_WRONG_DOCID_COLUMN = 1797;
    public const ER_INNODB_FT_WRONG_DOCID_INDEX = 1798;
    public const ER_INNODB_ONLINE_LOG_TOO_BIG = 1799;
    public const ER_UNKNOWN_ALTER_ALGORITHM = 1800;
    public const ER_UNKNOWN_ALTER_LOCK = 1801;
    public const ER_MTS_CHANGE_MASTER_CANT_RUN_WITH_GAPS = 1802;
    public const ER_MTS_RECOVERY_FAILURE = 1803;
    public const ER_MTS_RESET_WORKERS = 1804;
    public const ER_COL_COUNT_DOESNT_MATCH_CORRUPTED_V2 = 1805;
    public const ER_SLAVE_SILENT_RETRY_TRANSACTION = 1806;
    public const ER_DISCARD_FK_CHECKS_RUNNING = 1807;
    public const ER_TABLE_SCHEMA_MISMATCH = 1808;
    public const ER_TABLE_IN_SYSTEM_TABLESPACE = 1809;
    public const ER_IO_READ_ERROR = 1810;
    public const ER_IO_WRITE_ERROR = 1811;
    public const ER_TABLESPACE_MISSING = 1812;
    public const ER_TABLESPACE_EXISTS = 1813;
    public const ER_TABLESPACE_DISCARDED = 1814;
    public const ER_INTERNAL_ERROR = 1815;
    public const ER_INNODB_IMPORT_ERROR = 1816;
    public const ER_INNODB_INDEX_CORRUPT = 1817;
    public const ER_INVALID_YEAR_COLUMN_LENGTH = 1818;
    public const ER_NOT_VALID_PASSWORD = 1819;
    public const ER_MUST_CHANGE_PASSWORD = 1820;
    public const ER_FK_NO_INDEX_CHILD = 1821;
    public const ER_FK_NO_INDEX_PARENT = 1822;
    public const ER_FK_FAIL_ADD_SYSTEM = 1823;
    public const ER_FK_CANNOT_OPEN_PARENT = 1824;
    public const ER_FK_INCORRECT_OPTION = 1825;
    public const ER_FK_DUP_NAME = 1826;
    public const ER_PASSWORD_FORMAT = 1827;
    public const ER_FK_COLUMN_CANNOT_DROP = 1828;
    public const ER_FK_COLUMN_CANNOT_DROP_CHILD = 1829;
    public const ER_FK_COLUMN_NOT_NULL = 1830;
    public const ER_DUP_INDEX = 1831;
    public const ER_FK_COLUMN_CANNOT_CHANGE = 1832;
    public const ER_FK_COLUMN_CANNOT_CHANGE_CHILD = 1833;
    public const ER_FK_CANNOT_DELETE_PARENT = 1834;
    public const ER_MALFORMED_PACKET = 1835;
    public const ER_READ_ONLY_MODE = 1836;
    public const ER_GTID_NEXT_TYPE_UNDEFINED_GROUP = 1837;
    public const ER_VARIABLE_NOT_SETTABLE_IN_SP = 1838;
    public const ER_CANT_SET_GTID_PURGED_WHEN_GTID_MODE_IS_OFF = 1839;
    public const ER_CANT_SET_GTID_PURGED_WHEN_GTID_EXECUTED_IS_NOT_EMPTY = 1840;
    public const ER_CANT_SET_GTID_PURGED_WHEN_OWNED_GTIDS_IS_NOT_EMPTY = 1841;
    public const ER_GTID_PURGED_WAS_CHANGED = 1842;
    public const ER_GTID_EXECUTED_WAS_CHANGED = 1843;
    public const ER_BINLOG_STMT_MODE_AND_NO_REPL_TABLES = 1844;
    public const ER_ALTER_OPERATION_NOT_SUPPORTED = 1845;
    public const ER_ALTER_OPERATION_NOT_SUPPORTED_REASON = 1846;
    public const ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_COPY = 1847;
    public const ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_PARTITION = 1848;
    public const ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_FK_RENAME = 1849;
    public const ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_COLUMN_TYPE = 1850;
    public const ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_FK_CHECK = 1851;
    public const ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_IGNORE = 1852;
    public const ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_NOPK = 1853;
    public const ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_AUTOINC = 1854;
    public const ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_HIDDEN_FTS = 1855;
    public const ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_CHANGE_FTS = 1856;
    public const ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_FTS = 1857;
    public const ER_SQL_SLAVE_SKIP_COUNTER_NOT_SETTABLE_IN_GTID_MODE = 1858;
    public const ER_DUP_UNKNOWN_IN_INDEX = 1859;
    public const ER_IDENT_CAUSES_TOO_LONG_PATH = 1860;
    public const ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_NOT_NULL = 1861;
    public const ER_MUST_CHANGE_PASSWORD_LOGIN = 1862;
    public const ER_ROW_IN_WRONG_PARTITION = 1863;
    public const ER_MTS_EVENT_BIGGER_PENDING_JOBS_SIZE_MAX = 1864;
    public const ER_INNODB_NO_FT_USES_PARSER = 1865;
    public const ER_BINLOG_LOGICAL_CORRUPTION = 1866;
    public const ER_WARN_PURGE_LOG_IN_USE = 1867;
    public const ER_WARN_PURGE_LOG_IS_ACTIVE = 1868;
    public const ER_AUTO_INCREMENT_CONFLICT = 1869;
    public const WARN_ON_BLOCKHOLE_IN_RBR = 1870;
    public const ER_SLAVE_MI_INIT_REPOSITORY = 1871;
    public const ER_SLAVE_RLI_INIT_REPOSITORY = 1872;
    public const ER_ACCESS_DENIED_CHANGE_USER_ERROR = 1873;
    public const ER_INNODB_READ_ONLY = 1874;
    public const ER_STOP_SLAVE_SQL_THREAD_TIMEOUT = 1875;
    public const ER_STOP_SLAVE_IO_THREAD_TIMEOUT = 1876;
    public const ER_TABLE_CORRUPT = 1877;
    public const ER_TEMP_FILE_WRITE_FAILURE = 1878;
    public const ER_INNODB_FT_AUX_NOT_HEX_ID = 1879;
    public const ER_OLD_TEMPORALS_UPGRADED = 1880;
    public const ER_INNODB_FORCED_RECOVERY = 1881;
    public const ER_AES_INVALID_IV = 1882;
    public const ER_PLUGIN_CANNOT_BE_UNINSTALLED = 1883;
    public const ER_GTID_UNSAFE_BINLOG_SPLITTABLE_STATEMENT_AND_GTID_GROUP = 1884;
    public const ER_SLAVE_HAS_MORE_GTIDS_THAN_MASTER = 1885;
    public const ER_MISSING_KEY = 1886;
    public const WARN_NAMED_PIPE_ACCESS_EVERYONE = 1887;
    public const ER_FOUND_MISSING_GTIDS = 1888;
    public const ER_FILE_CORRUPT = 3000;
    public const ER_ERROR_ON_MASTER = 3001;
    public const ER_INCONSISTENT_ERROR = 3002;
    public const ER_STORAGE_ENGINE_NOT_LOADED = 3003;
    public const ER_GET_STACKED_DA_WITHOUT_ACTIVE_HANDLER = 3004;
    public const ER_WARN_LEGACY_SYNTAX_CONVERTED = 3005;
    public const ER_BINLOG_UNSAFE_FULLTEXT_PLUGIN = 3006;
    public const ER_CANNOT_DISCARD_TEMPORARY_TABLE = 3007;
    public const ER_FK_DEPTH_EXCEEDED = 3008;
    public const ER_COL_COUNT_DOESNT_MATCH_PLEASE_UPDATE_V2 = 3009;
    public const ER_WARN_TRIGGER_DOESNT_HAVE_CREATED = 3010;
    public const ER_REFERENCED_TRG_DOES_NOT_EXIST = 3011;
    public const ER_EXPLAIN_NOT_SUPPORTED = 3012;
    public const ER_INVALID_FIELD_SIZE = 3013;
    public const ER_MISSING_HA_CREATE_OPTION = 3014;
    public const ER_ENGINE_OUT_OF_MEMORY = 3015;
    public const ER_PASSWORD_EXPIRE_ANONYMOUS_USER = 3016;
    public const ER_SLAVE_SQL_THREAD_MUST_STOP = 3017;
    public const ER_NO_FT_MATERIALIZED_SUBQUERY = 3018;
    public const ER_INNODB_UNDO_LOG_FULL = 3019;
    public const ER_INVALID_ARGUMENT_FOR_LOGARITHM = 3020;
    public const ER_SLAVE_CHANNEL_IO_THREAD_MUST_STOP = 3021;
    public const ER_WARN_OPEN_TEMP_TABLES_MUST_BE_ZERO = 3022;
    public const ER_WARN_ONLY_MASTER_LOG_FILE_NO_POS = 3023;
    public const ER_QUERY_TIMEOUT = 3024;
    public const ER_NON_RO_SELECT_DISABLE_TIMER = 3025;
    public const ER_DUP_LIST_ENTRY = 3026;
    public const ER_SQL_MODE_NO_EFFECT = 3027;
    public const ER_AGGREGATE_ORDER_FOR_UNION = 3028;
    public const ER_AGGREGATE_ORDER_NON_AGG_QUERY = 3029;
    public const ER_SLAVE_WORKER_STOPPED_PREVIOUS_THD_ERROR = 3030;
    public const ER_DONT_SUPPORT_SLAVE_PRESERVE_COMMIT_ORDER = 3031;
    public const ER_SERVER_OFFLINE_MODE = 3032;
    public const ER_GIS_DIFFERENT_SRIDS = 3033;
    public const ER_GIS_UNSUPPORTED_ARGUMENT = 3034;
    public const ER_GIS_UNKNOWN_ERROR = 3035;
    public const ER_GIS_UNKNOWN_EXCEPTION = 3036;
    public const ER_GIS_INVALID_DATA = 3037;
    public const ER_BOOST_GEOMETRY_EMPTY_INPUT_EXCEPTION = 3038;
    public const ER_BOOST_GEOMETRY_CENTROID_EXCEPTION = 3039;
    public const ER_BOOST_GEOMETRY_OVERLAY_INVALID_INPUT_EXCEPTION = 3040;
    public const ER_BOOST_GEOMETRY_TURN_INFO_EXCEPTION = 3041;
    public const ER_BOOST_GEOMETRY_SELF_INTERSECTION_POINT_EXCEPTION = 3042;
    public const ER_BOOST_GEOMETRY_UNKNOWN_EXCEPTION = 3043;
    public const ER_STD_BAD_ALLOC_ERROR = 3044;
    public const ER_STD_DOMAIN_ERROR = 3045;
    public const ER_STD_LENGTH_ERROR = 3046;
    public const ER_STD_INVALID_ARGUMENT = 3047;
    public const ER_STD_OUT_OF_RANGE_ERROR = 3048;
    public const ER_STD_OVERFLOW_ERROR = 3049;
    public const ER_STD_RANGE_ERROR = 3050;
    public const ER_STD_UNDERFLOW_ERROR = 3051;
    public const ER_STD_LOGIC_ERROR = 3052;
    public const ER_STD_RUNTIME_ERROR = 3053;
    public const ER_STD_UNKNOWN_EXCEPTION = 3054;
    public const ER_GIS_DATA_WRONG_ENDIANESS = 3055;
    public const ER_CHANGE_MASTER_PASSWORD_LENGTH = 3056;
    public const ER_USER_LOCK_WRONG_NAME = 3057;
    public const ER_USER_LOCK_DEADLOCK = 3058;
    public const ER_REPLACE_INACCESSIBLE_ROWS = 3059;
    public const ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_GIS = 3060;
    public const ER_ILLEGAL_USER_VAR = 3061;
    public const ER_GTID_MODE_OFF = 3062;
    public const ER_UNSUPPORTED_BY_REPLICATION_THREAD = 3063;
    public const ER_INCORRECT_TYPE = 3064;
    public const ER_FIELD_IN_ORDER_NOT_SELECT = 3065;
    public const ER_AGGREGATE_IN_ORDER_NOT_SELECT = 3066;
    public const ER_INVALID_RPL_WILD_TABLE_FILTER_PATTERN = 3067;
    public const ER_NET_OK_PACKET_TOO_LARGE = 3068;
    public const ER_INVALID_JSON_DATA = 3069;
    public const ER_INVALID_GEOJSON_MISSING_MEMBER = 3070;
    public const ER_INVALID_GEOJSON_WRONG_TYPE = 3071;
    public const ER_INVALID_GEOJSON_UNSPECIFIED = 3072;
    public const ER_DIMENSION_UNSUPPORTED = 3073;
    public const ER_SLAVE_CHANNEL_DOES_NOT_EXIST = 3074;
    public const ER_SLAVE_MULTIPLE_CHANNELS_HOST_PORT = 3075;
    public const ER_SLAVE_CHANNEL_NAME_INVALID_OR_TOO_LONG = 3076;
    public const ER_SLAVE_NEW_CHANNEL_WRONG_REPOSITORY = 3077;
    public const ER_SLAVE_CHANNEL_DELETE = 3078;
    public const ER_SLAVE_MULTIPLE_CHANNELS_CMD = 3079;
    public const ER_SLAVE_MAX_CHANNELS_EXCEEDED = 3080;
    public const ER_SLAVE_CHANNEL_MUST_STOP = 3081;
    public const ER_SLAVE_CHANNEL_NOT_RUNNING = 3082;
    public const ER_SLAVE_CHANNEL_WAS_RUNNING = 3083;
    public const ER_SLAVE_CHANNEL_WAS_NOT_RUNNING = 3084;
    public const ER_SLAVE_CHANNEL_SQL_THREAD_MUST_STOP = 3085;
    public const ER_SLAVE_CHANNEL_SQL_SKIP_COUNTER = 3086;
    public const ER_WRONG_FIELD_WITH_GROUP_V2 = 3087;
    public const ER_MIX_OF_GROUP_FUNC_AND_FIELDS_V2 = 3088;
    public const ER_WARN_DEPRECATED_SYSVAR_UPDATE = 3089;
    public const ER_WARN_DEPRECATED_SQLMODE = 3090;
    public const ER_CANNOT_LOG_PARTIAL_DROP_DATABASE_WITH_GTID = 3091;
    public const ER_GROUP_REPLICATION_CONFIGURATION = 3092;
    public const ER_GROUP_REPLICATION_RUNNING = 3093;
    public const ER_GROUP_REPLICATION_APPLIER_INIT_ERROR = 3094;
    public const ER_GROUP_REPLICATION_STOP_APPLIER_THREAD_TIMEOUT = 3095;
    public const ER_GROUP_REPLICATION_COMMUNICATION_LAYER_SESSION_ERROR = 3096;
    public const ER_GROUP_REPLICATION_COMMUNICATION_LAYER_JOIN_ERROR = 3097;
    public const ER_BEFORE_DML_VALIDATION_ERROR = 3098;
    public const ER_PREVENTS_VARIABLE_WITHOUT_RBR = 3099;
    public const ER_RUN_HOOK_ERROR = 3100;
    public const ER_TRANSACTION_ROLLBACK_DURING_COMMIT = 3101;
    public const ER_GENERATED_COLUMN_FUNCTION_IS_NOT_ALLOWED = 3102;
    public const ER_UNSUPPORTED_ALTER_INPLACE_ON_VIRTUAL_COLUMN = 3103;
    public const ER_WRONG_FK_OPTION_FOR_GENERATED_COLUMN = 3104;
    public const ER_NON_DEFAULT_VALUE_FOR_GENERATED_COLUMN = 3105;
    public const ER_UNSUPPORTED_ACTION_ON_GENERATED_COLUMN = 3106;
    public const ER_GENERATED_COLUMN_NON_PRIOR = 3107;
    public const ER_DEPENDENT_BY_GENERATED_COLUMN = 3108;
    public const ER_GENERATED_COLUMN_REF_AUTO_INC = 3109;
    public const ER_FEATURE_NOT_AVAILABLE = 3110;
    public const ER_CANT_SET_GTID_MODE = 3111;
    public const ER_CANT_USE_AUTO_POSITION_WITH_GTID_MODE_OFF = 3112;
    public const ER_CANT_REPLICATE_ANONYMOUS_WITH_AUTO_POSITION = 3113;
    public const ER_CANT_REPLICATE_ANONYMOUS_WITH_GTID_MODE_ON = 3114;
    public const ER_CANT_REPLICATE_GTID_WITH_GTID_MODE_OFF = 3115;
    public const ER_CANT_SET_ENFORCE_GTID_CONSISTENCY_ON_WITH_ONGOING_GTID_VIOLATING_TRANSACTIONS = 3116;
    public const ER_SET_ENFORCE_GTID_CONSISTENCY_WARN_WITH_ONGOING_GTID_VIOLATING_TRANSACTIONS = 3117;
    public const ER_ACCOUNT_HAS_BEEN_LOCKED = 3118;
    public const ER_WRONG_TABLESPACE_NAME = 3119;
    public const ER_TABLESPACE_IS_NOT_EMPTY = 3120;
    public const ER_WRONG_FILE_NAME = 3121;
    public const ER_BOOST_GEOMETRY_INCONSISTENT_TURNS_EXCEPTION = 3122;
    public const ER_WARN_OPTIMIZER_HINT_SYNTAX_ERROR = 3123;
    public const ER_WARN_BAD_MAX_EXECUTION_TIME = 3124;
    public const ER_WARN_UNSUPPORTED_MAX_EXECUTION_TIME = 3125;
    public const ER_WARN_CONFLICTING_HINT = 3126;
    public const ER_WARN_UNKNOWN_QB_NAME = 3127;
    public const ER_UNRESOLVED_HINT_NAME = 3128;
    public const ER_WARN_ON_MODIFYING_GTID_EXECUTED_TABLE = 3129;
    public const ER_PLUGGABLE_PROTOCOL_COMMAND_NOT_SUPPORTED = 3130;
    public const ER_LOCKING_SERVICE_WRONG_NAME = 3131;
    public const ER_LOCKING_SERVICE_DEADLOCK = 3132;
    public const ER_LOCKING_SERVICE_TIMEOUT = 3133;
    public const ER_GIS_MAX_POINTS_IN_GEOMETRY_OVERFLOWED = 3134;
    public const ER_SQL_MODE_MERGED = 3135;
    public const ER_VTOKEN_PLUGIN_TOKEN_MISMATCH = 3136;
    public const ER_VTOKEN_PLUGIN_TOKEN_NOT_FOUND = 3137;
    public const ER_CANT_SET_VARIABLE_WHEN_OWNING_GTID = 3138;
    public const ER_SLAVE_CHANNEL_OPERATION_NOT_ALLOWED = 3139;
    public const ER_INVALID_JSON_TEXT = 3140;
    public const ER_INVALID_JSON_TEXT_IN_PARAM = 3141;
    public const ER_INVALID_JSON_BINARY_DATA = 3142;
    public const ER_INVALID_JSON_PATH = 3143;
    public const ER_INVALID_JSON_CHARSET = 3144;
    public const ER_INVALID_JSON_CHARSET_IN_FUNCTION = 3145;
    public const ER_INVALID_TYPE_FOR_JSON = 3146;
    public const ER_INVALID_CAST_TO_JSON = 3147;
    public const ER_INVALID_JSON_PATH_CHARSET = 3148;
    public const ER_INVALID_JSON_PATH_WILDCARD = 3149;
    public const ER_JSON_VALUE_TOO_BIG = 3150;
    public const ER_JSON_KEY_TOO_BIG = 3151;
    public const ER_JSON_USED_AS_KEY = 3152;
    public const ER_JSON_VACUOUS_PATH = 3153;
    public const ER_JSON_BAD_ONE_OR_ALL_ARG = 3154;
    public const ER_NUMERIC_JSON_VALUE_OUT_OF_RANGE = 3155;
    public const ER_INVALID_JSON_VALUE_FOR_CAST = 3156;
    public const ER_JSON_DOCUMENT_TOO_DEEP = 3157;
    public const ER_JSON_DOCUMENT_NULL_KEY = 3158;
    public const ER_SECURE_TRANSPORT_REQUIRED = 3159;
    public const ER_NO_SECURE_TRANSPORTS_CONFIGURED = 3160;
    public const ER_DISABLED_STORAGE_ENGINE = 3161;
    public const ER_USER_DOES_NOT_EXIST = 3162;
    public const ER_USER_ALREADY_EXISTS = 3163;
    public const ER_AUDIT_API_ABORT = 3164;
    public const ER_INVALID_JSON_PATH_ARRAY_CELL = 3165;
    public const ER_BUFPOOL_RESIZE_INPROGRESS = 3166;
    public const ER_FEATURE_DISABLED_SEE_DOC = 3167;
    public const ER_SERVER_ISNT_AVAILABLE = 3168;
    public const ER_SESSION_WAS_KILLED = 3169;
    public const ER_CAPACITY_EXCEEDED = 3170;
    public const ER_CAPACITY_EXCEEDED_IN_RANGE_OPTIMIZER = 3171;
    public const ER_TABLE_NEEDS_UPG_PART = 3172;
    public const ER_CANT_WAIT_FOR_EXECUTED_GTID_SET_WHILE_OWNING_A_GTID = 3173;
    public const ER_CANNOT_ADD_FOREIGN_BASE_COL_VIRTUAL = 3174;
    public const ER_CANNOT_CREATE_VIRTUAL_INDEX_CONSTRAINT = 3175;
    public const ER_ERROR_ON_MODIFYING_GTID_EXECUTED_TABLE = 3176;
    public const ER_LOCK_REFUSED_BY_ENGINE = 3177;
    public const ER_UNSUPPORTED_ALTER_ONLINE_ON_VIRTUAL_COLUMN = 3178;
    public const ER_MASTER_KEY_ROTATION_NOT_SUPPORTED_BY_SE = 3179;
    public const ER_MASTER_KEY_ROTATION_ERROR_BY_SE = 3180;
    public const ER_MASTER_KEY_ROTATION_BINLOG_FAILED = 3181;
    public const ER_MASTER_KEY_ROTATION_SE_UNAVAILABLE = 3182;
    public const ER_TABLESPACE_CANNOT_ENCRYPT = 3183;
    public const ER_INVALID_ENCRYPTION_OPTION = 3184;
    public const ER_CANNOT_FIND_KEY_IN_KEYRING = 3185;
    public const ER_CAPACITY_EXCEEDED_IN_PARSER = 3186;
    public const ER_UNSUPPORTED_ALTER_ENCRYPTION_INPLACE = 3187;
    public const ER_KEYRING_UDF_KEYRING_SERVICE_ERROR = 3188;
    public const ER_USER_COLUMN_OLD_LENGTH = 3189;
    public const ER_CANT_RESET_MASTER = 3190;
    public const ER_GROUP_REPLICATION_MAX_GROUP_SIZE = 3191;
    public const ER_CANNOT_ADD_FOREIGN_BASE_COL_STORED = 3192;
    public const ER_TABLE_REFERENCED = 3193;
    public const ER_PARTITION_ENGINE_DEPRECATED_FOR_TABLE = 3194;
    public const ER_WARN_USING_GEOMFROMWKB_TO_SET_SRID_ZERO = 3195;
    public const ER_WARN_USING_GEOMFROMWKB_TO_SET_SRID = 3196;
    public const ER_XA_RETRY = 3197;
    public const ER_KEYRING_AWS_UDF_AWS_KMS_ERROR = 3198;
    public const ER_BINLOG_UNSAFE_XA = 3199;
    public const ER_UDF_ERROR = 3200;
    public const ER_KEYRING_MIGRATION_FAILURE = 3201;
    public const ER_KEYRING_ACCESS_DENIED_ERROR = 3202;
    public const ER_KEYRING_MIGRATION_STATUS = 3203;
    public const ER_PLUGIN_FAILED_TO_OPEN_TABLES = 3204;
    public const ER_PLUGIN_FAILED_TO_OPEN_TABLE = 3205;
    public const ER_AUDIT_LOG_NO_KEYRING_PLUGIN_INSTALLED = 3206;
    public const ER_AUDIT_LOG_ENCRYPTION_PASSWORD_HAS_NOT_BEEN_SET = 3207;
    public const ER_AUDIT_LOG_COULD_NOT_CREATE_AES_KEY = 3208;
    public const ER_AUDIT_LOG_ENCRYPTION_PASSWORD_CANNOT_BE_FETCHED = 3209;
    public const ER_AUDIT_LOG_JSON_FILTERING_NOT_ENABLED = 3210;
    public const ER_AUDIT_LOG_UDF_INSUFFICIENT_PRIVILEGE = 3211;
    public const ER_AUDIT_LOG_SUPER_PRIVILEGE_REQUIRED = 3212;
    public const ER_COULD_NOT_REINITIALIZE_AUDIT_LOG_FILTERS = 3213;
    public const ER_AUDIT_LOG_UDF_INVALID_ARGUMENT_TYPE = 3214;
    public const ER_AUDIT_LOG_UDF_INVALID_ARGUMENT_COUNT = 3215;
    public const ER_AUDIT_LOG_HAS_NOT_BEEN_INSTALLED = 3216;
    public const ER_AUDIT_LOG_UDF_READ_INVALID_MAX_ARRAY_LENGTH_ARG_TYPE = 3217;
    public const ER_AUDIT_LOG_UDF_READ_INVALID_MAX_ARRAY_LENGTH_ARG_VALUE = 3218;

    //public const ER_AUDIT_LOG_JSON_FILTER_PARSING_ERROR = 3219;
    //public const ER_AUDIT_LOG_JSON_FILTER_NAME_CANNOT_BE_EMPTY = 3220;
    //public const ER_AUDIT_LOG_JSON_USER_NAME_CANNOT_BE_EMPTY = 3221;
    //public const ER_AUDIT_LOG_JSON_FILTER_DOES_NOT_EXISTS = 3222;
    //public const ER_AUDIT_LOG_USER_FIRST_CHARACTER_MUST_BE_ALPHANUMERIC = 3223;
    //public const ER_AUDIT_LOG_USER_NAME_INVALID_CHARACTER = 3224;
    //public const ER_AUDIT_LOG_HOST_NAME_INVALID_CHARACTER = 3225;
    //public const WARN_DEPRECATED_MAXDB_SQL_MODE_FOR_TIMESTAMP = 3226;
    //public const ER_XA_REPLICATION_FILTERS = 3227;
    //public const ER_CANT_OPEN_ERROR_LOG = 3228;
    //public const ER_GROUPING_ON_TIMESTAMP_IN_DST = 3229;
    //public const ER_CANT_START_SERVER_NAMED_PIPE = 3230;
    //public const ER_WRITE_SET_EXCEEDS_LIMIT = 3231;

    public const ER_AES_INVALID_KDF_NAME = 3235;
    public const ER_AES_INVALID_KDF_ITERATIONS = 3236;
    public const WARN_AES_KEY_SIZE = 3237;
    public const ER_AES_INVALID_KDF_OPTION_SIZE = 3238;

    public const ER_ACL_OPERATION_FAILED = 3501;
    public const ER_UNSUPPORTED_INDEX_ALGORITHM = 3502;
    public const ER_NO_SUCH_DB = 3503;
    public const ER_TOO_BIG_ENUM = 3504;
    public const ER_TOO_LONG_SET_ENUM_VALUE = 3505;
    public const ER_INVALID_DD_OBJECT = 3506;
    public const ER_UPDATING_DD_TABLE = 3507;
    public const ER_INVALID_DD_OBJECT_ID = 3508;
    public const ER_INVALID_DD_OBJECT_NAME = 3509;
    public const ER_TABLESPACE_MISSING_WITH_NAME = 3510;
    public const ER_TOO_LONG_ROUTINE_COMMENT = 3511;
    public const ER_SP_LOAD_FAILED = 3512;
    public const ER_INVALID_BITWISE_OPERANDS_SIZE = 3513;
    public const ER_INVALID_BITWISE_AGGREGATE_OPERANDS_SIZE = 3514;
    public const ER_WARN_UNSUPPORTED_HINT = 3515;
    public const ER_UNEXPECTED_GEOMETRY_TYPE = 3516;
    public const ER_SRS_PARSE_ERROR = 3517;
    public const ER_SRS_PROJ_PARAMETER_MISSING = 3518;
    public const ER_WARN_SRS_NOT_FOUND = 3519;
    public const ER_SRS_NOT_CARTESIAN = 3520;
    public const ER_SRS_NOT_CARTESIAN_UNDEFINED = 3521;
    public const ER_PK_INDEX_CANT_BE_INVISIBLE = 3522;
    public const ER_UNKNOWN_AUTHID = 3523;
    public const ER_FAILED_ROLE_GRANT = 3524;
    public const ER_OPEN_ROLE_TABLES = 3525;
    public const ER_FAILED_DEFAULT_ROLES = 3526;
    public const ER_COMPONENTS_NO_SCHEME = 3527;
    public const ER_COMPONENTS_NO_SCHEME_SERVICE = 3528;
    public const ER_COMPONENTS_CANT_LOAD = 3529;
    public const ER_ROLE_NOT_GRANTED = 3530;
    public const ER_FAILED_REVOKE_ROLE = 3531;
    public const ER_RENAME_ROLE = 3532;
    public const ER_COMPONENTS_CANT_ACQUIRE_SERVICE_IMPLEMENTATION = 3533;
    public const ER_COMPONENTS_CANT_SATISFY_DEPENDENCY = 3534;
    public const ER_COMPONENTS_LOAD_CANT_REGISTER_SERVICE_IMPLEMENTATION = 3535;
    public const ER_COMPONENTS_LOAD_CANT_INITIALIZE = 3536;
    public const ER_COMPONENTS_UNLOAD_NOT_LOADED = 3537;
    public const ER_COMPONENTS_UNLOAD_CANT_DEINITIALIZE = 3538;
    public const ER_COMPONENTS_CANT_RELEASE_SERVICE = 3539;
    public const ER_COMPONENTS_UNLOAD_CANT_UNREGISTER_SERVICE = 3540;
    public const ER_COMPONENTS_CANT_UNLOAD = 3541;
    public const ER_WARN_UNLOAD_THE_NOT_PERSISTED = 3542;
    public const ER_COMPONENT_TABLE_INCORRECT = 3543;
    public const ER_COMPONENT_MANIPULATE_ROW_FAILED = 3544;
    public const ER_COMPONENTS_UNLOAD_DUPLICATE_IN_GROUP = 3545;
    public const ER_CANT_SET_GTID_PURGED_DUE_SETS_CONSTRAINTS = 3546;
    public const ER_CANNOT_LOCK_USER_MANAGEMENT_CACHES = 3547;
    public const ER_SRS_NOT_FOUND = 3548;
    public const ER_VARIABLE_NOT_PERSISTED = 3549;
    public const ER_IS_QUERY_INVALID_CLAUSE = 3550;
    public const ER_UNABLE_TO_STORE_STATISTICS = 3551;
    public const ER_NO_SYSTEM_SCHEMA_ACCESS = 3552;
    public const ER_NO_SYSTEM_TABLESPACE_ACCESS = 3553;
    public const ER_NO_SYSTEM_TABLE_ACCESS = 3554;
    public const ER_NO_SYSTEM_TABLE_ACCESS_FOR_DICTIONARY_TABLE = 3555;
    public const ER_NO_SYSTEM_TABLE_ACCESS_FOR_SYSTEM_TABLE = 3556;
    public const ER_NO_SYSTEM_TABLE_ACCESS_FOR_TABLE = 3557;
    public const ER_INVALID_OPTION_KEY = 3558;
    public const ER_INVALID_OPTION_VALUE = 3559;
    public const ER_INVALID_OPTION_KEY_VALUE_PAIR = 3560;
    public const ER_INVALID_OPTION_START_CHARACTER = 3561;
    public const ER_INVALID_OPTION_END_CHARACTER = 3562;
    public const ER_INVALID_OPTION_CHARACTERS = 3563;
    public const ER_DUPLICATE_OPTION_KEY = 3564;
    public const ER_WARN_SRS_NOT_FOUND_AXIS_ORDER = 3565;
    public const ER_NO_ACCESS_TO_NATIVE_FCT = 3566;
    public const ER_RESET_MASTER_TO_VALUE_OUT_OF_RANGE = 3567;
    public const ER_RESET_SOURCE_TO_VALUE_OUT_OF_RANGE = 3567;
    public const ER_UNRESOLVED_TABLE_LOCK = 3568;
    public const ER_DUPLICATE_TABLE_LOCK = 3569;
    public const ER_BINLOG_UNSAFE_SKIP_LOCKED = 3570;
    public const ER_BINLOG_UNSAFE_NOWAIT = 3571;
    public const ER_LOCK_NOWAIT = 3572;
    public const ER_CTE_RECURSIVE_REQUIRES_UNION = 3573;
    public const ER_CTE_RECURSIVE_REQUIRES_NONRECURSIVE_FIRST = 3574;
    public const ER_CTE_RECURSIVE_FORBIDS_AGGREGATION = 3575;
    public const ER_CTE_RECURSIVE_FORBIDDEN_JOIN_ORDER = 3576;
    public const ER_CTE_RECURSIVE_REQUIRES_SINGLE_REFERENCE = 3577;
    public const ER_SWITCH_TMP_ENGINE = 3578;
    public const ER_WINDOW_NO_SUCH_WINDOW = 3579;
    public const ER_WINDOW_CIRCULARITY_IN_WINDOW_GRAPH = 3580;
    public const ER_WINDOW_NO_CHILD_PARTITIONING = 3581;
    public const ER_WINDOW_NO_INHERIT_FRAME = 3582;
    public const ER_WINDOW_NO_REDEFINE_ORDER_BY = 3583;
    public const ER_WINDOW_FRAME_START_ILLEGAL = 3584;
    public const ER_WINDOW_FRAME_END_ILLEGAL = 3585;
    public const ER_WINDOW_FRAME_ILLEGAL = 3586;
    public const ER_WINDOW_RANGE_FRAME_ORDER_TYPE = 3587;
    public const ER_WINDOW_RANGE_FRAME_TEMPORAL_TYPE = 3588;
    public const ER_WINDOW_RANGE_FRAME_NUMERIC_TYPE = 3589;
    public const ER_WINDOW_RANGE_BOUND_NOT_CONSTANT = 3590;
    public const ER_WINDOW_DUPLICATE_NAME = 3591;
    public const ER_WINDOW_ILLEGAL_ORDER_BY = 3592;
    public const ER_WINDOW_INVALID_WINDOW_FUNC_USE = 3593;
    public const ER_WINDOW_INVALID_WINDOW_FUNC_ALIAS_USE = 3594;
    public const ER_WINDOW_NESTED_WINDOW_FUNC_USE_IN_WINDOW_SPEC = 3595;
    public const ER_WINDOW_ROWS_INTERVAL_USE = 3596;
    public const ER_WINDOW_NO_GROUP_ORDER_UNUSED = 3597;
    public const ER_WINDOW_NO_GROUP_ORDER = 3597;
    public const ER_WINDOW_EXPLAIN_JSON = 3598;
    public const ER_WINDOW_FUNCTION_IGNORES_FRAME = 3599;
    public const ER_WINDOW_SE_NOT_ACCEPTABLE = 3600;
    public const ER_WL9236_NOW_UNUSED = 3600;
    public const ER_INVALID_NO_OF_ARGS = 3601;
    public const ER_FIELD_IN_GROUPING_NOT_GROUP_BY = 3602;
    public const ER_TOO_LONG_TABLESPACE_COMMENT = 3603;
    public const ER_ENGINE_CANT_DROP_TABLE = 3604;
    public const ER_ENGINE_CANT_DROP_MISSING_TABLE = 3605;
    public const ER_TABLESPACE_DUP_FILENAME = 3606;
    public const ER_DB_DROP_RMDIR2 = 3607;
    public const ER_IMP_NO_FILES_MATCHED = 3608;
    public const ER_IMP_SCHEMA_DOES_NOT_EXIST = 3609;
    public const ER_IMP_TABLE_ALREADY_EXISTS = 3610;
    public const ER_IMP_INCOMPATIBLE_MYSQLD_VERSION = 3611;
    public const ER_IMP_INCOMPATIBLE_DD_VERSION = 3612;
    public const ER_IMP_INCOMPATIBLE_SDI_VERSION = 3613;
    public const ER_WARN_INVALID_HINT = 3614;
    public const ER_VAR_DOES_NOT_EXIST = 3615;
    public const ER_LONGITUDE_OUT_OF_RANGE = 3616;
    public const ER_LATITUDE_OUT_OF_RANGE = 3617;
    public const ER_NOT_IMPLEMENTED_FOR_GEOGRAPHIC_SRS = 3618;
    public const ER_ILLEGAL_PRIVILEGE_LEVEL = 3619;
    public const ER_NO_SYSTEM_VIEW_ACCESS = 3620;
    public const ER_COMPONENT_FILTER_FLABBERGASTED = 3621;
    public const ER_PART_EXPR_TOO_LONG = 3622;
    public const ER_UDF_DROP_DYNAMICALLY_REGISTERED = 3623;
    public const ER_UNABLE_TO_STORE_COLUMN_STATISTICS = 3624;
    public const ER_UNABLE_TO_UPDATE_COLUMN_STATISTICS = 3625;
    public const ER_UNABLE_TO_DROP_COLUMN_STATISTICS = 3626;
    public const ER_UNABLE_TO_BUILD_HISTOGRAM = 3627;
    public const ER_MANDATORY_ROLE = 3628;
    public const ER_MISSING_TABLESPACE_FILE = 3629;
    public const ER_PERSIST_ONLY_ACCESS_DENIED_ERROR = 3630;
    public const ER_CMD_NEED_SUPER = 3631;
    public const ER_PATH_IN_DATADIR = 3632;
    public const ER_CLONE_DDL_IN_PROGRESS = 3633;
    public const ER_DDL_IN_PROGRESS = 3633;
    public const ER_CLONE_TOO_MANY_CONCURRENT_CLONES = 3634;
    public const ER_TOO_MANY_CONCURRENT_CLONES = 3634;
    public const ER_APPLIER_LOG_EVENT_VALIDATION_ERROR = 3635;
    public const ER_CTE_MAX_RECURSION_DEPTH = 3636;
    public const ER_NOT_HINT_UPDATABLE_VARIABLE = 3637;
    public const ER_CREDENTIALS_CONTRADICT_TO_HISTORY = 3638;
    public const ER_WARNING_PASSWORD_HISTORY_CLAUSES_VOID = 3639;
    public const ER_CLIENT_DOES_NOT_SUPPORT = 3640;
    public const ER_I_S_SKIPPED_TABLESPACE = 3641;
    public const ER_TABLESPACE_ENGINE_MISMATCH = 3642;
    public const ER_WRONG_SRID_FOR_COLUMN = 3643;
    public const ER_CANNOT_ALTER_SRID_DUE_TO_INDEX = 3644;
    public const ER_WARN_BINLOG_PARTIAL_UPDATES_DISABLED = 3645;
    public const ER_WARN_BINLOG_V1_ROW_EVENTS_DISABLED = 3646;
    public const ER_WARN_BINLOG_PARTIAL_UPDATES_SUGGESTS_PARTIAL_IMAGES = 3647;
    public const ER_COULD_NOT_APPLY_JSON_DIFF = 3648;
    public const ER_CORRUPTED_JSON_DIFF = 3649;
    public const ER_RESOURCE_GROUP_EXISTS = 3650;
    public const ER_RESOURCE_GROUP_NOT_EXISTS = 3651;
    public const ER_INVALID_VCPU_ID = 3652;
    public const ER_INVALID_VCPU_RANGE = 3653;
    public const ER_INVALID_THREAD_PRIORITY = 3654;
    public const ER_DISALLOWED_OPERATION = 3655;
    public const ER_RESOURCE_GROUP_BUSY = 3656;
    public const ER_RESOURCE_GROUP_DISABLED = 3657;
    public const ER_FEATURE_UNSUPPORTED = 3658;
    public const ER_ATTRIBUTE_IGNORED = 3659;
    public const ER_INVALID_THREAD_ID = 3660;
    public const ER_RESOURCE_GROUP_BIND_FAILED = 3661;
    public const ER_INVALID_USE_OF_FORCE_OPTION = 3662;
    public const ER_GROUP_REPLICATION_COMMAND_FAILURE = 3663;
    public const ER_SDI_OPERATION_FAILED = 3664;
    public const ER_MISSING_JSON_TABLE_VALUE = 3665;
    public const ER_WRONG_JSON_TABLE_VALUE = 3666;
    public const ER_TF_MUST_HAVE_ALIAS = 3667;
    public const ER_TF_FORBIDDEN_JOIN_TYPE = 3668;
    public const ER_JT_VALUE_OUT_OF_RANGE = 3669;
    public const ER_JT_MAX_NESTED_PATH = 3670;
    public const ER_PASSWORD_EXPIRATION_NOT_SUPPORTED_BY_AUTH_METHOD = 3671;
    public const ER_INVALID_GEOJSON_CRS_NOT_TOP_LEVEL = 3672;
    public const ER_BAD_NULL_ERROR_NOT_IGNORED = 3673;
    public const WARN_USELESS_SPATIAL_INDEX = 3674;
    public const ER_DISK_FULL_NOWAIT = 3675;
    public const ER_PARSE_ERROR_IN_DIGEST_FN = 3676;
    public const ER_UNDISCLOSED_PARSE_ERROR_IN_DIGEST_FN = 3677;
    public const ER_SCHEMA_DIR_EXISTS = 3678;
    public const ER_SCHEMA_DIR_MISSING = 3679;
    public const ER_SCHEMA_DIR_CREATE_FAILED = 3680;
    public const ER_SCHEMA_DIR_UNKNOWN = 3681;
    public const ER_ONLY_IMPLEMENTED_FOR_SRID_0_AND_4326 = 3682;
    public const ER_BINLOG_EXPIRE_LOG_DAYS_AND_SECS_USED_TOGETHER = 3683;
    public const ER_REGEXP_BUFFER_OVERFLOW = 3684;
    public const ER_REGEXP_STRING_NOT_TERMINATED = 3684;
    public const ER_REGEXP_ILLEGAL_ARGUMENT = 3685;
    public const ER_REGEXP_INDEX_OUTOFBOUNDS_ERROR = 3686;
    public const ER_REGEXP_INTERNAL_ERROR = 3687;
    public const ER_REGEXP_RULE_SYNTAX = 3688;
    public const ER_REGEXP_BAD_ESCAPE_SEQUENCE = 3689;
    public const ER_REGEXP_UNIMPLEMENTED = 3690;
    public const ER_REGEXP_MISMATCHED_PAREN = 3691;
    public const ER_REGEXP_BAD_INTERVAL = 3692;
    public const ER_REGEXP_MAX_LT_MIN = 3693;
    public const ER_REGEXP_INVALID_BACK_REF = 3694;
    public const ER_REGEXP_LOOK_BEHIND_LIMIT = 3695;
    public const ER_REGEXP_MISSING_CLOSE_BRACKET = 3696;
    public const ER_REGEXP_INVALID_RANGE = 3697;
    public const ER_REGEXP_STACK_OVERFLOW = 3698;
    public const ER_REGEXP_TIME_OUT = 3699;
    public const ER_REGEXP_PATTERN_TOO_BIG = 3700;
    public const ER_CANT_SET_ERROR_LOG_SERVICE = 3701;
    public const ER_EMPTY_PIPELINE_FOR_ERROR_LOG_SERVICE = 3702;
    public const ER_COMPONENT_FILTER_DIAGNOSTICS = 3703;
    public const ER_INNODB_CANNOT_BE_IGNORED = 3704;
    public const ER_NOT_IMPLEMENTED_FOR_CARTESIAN_SRS = 3704;
    public const ER_NOT_IMPLEMENTED_FOR_PROJECTED_SRS = 3705;
    public const ER_NONPOSITIVE_RADIUS = 3706;
    public const ER_RESTART_SERVER_FAILED = 3707;
    public const ER_SRS_MISSING_MANDATORY_ATTRIBUTE = 3708;
    public const ER_SRS_MULTIPLE_ATTRIBUTE_DEFINITIONS = 3709;
    public const ER_SRS_NAME_CANT_BE_EMPTY_OR_WHITESPACE = 3710;
    public const ER_SRS_ORGANIZATION_CANT_BE_EMPTY_OR_WHITESPACE = 3711;
    public const ER_SRS_ID_ALREADY_EXISTS = 3712;
    public const ER_WARN_SRS_ID_ALREADY_EXISTS = 3713;
    public const ER_CANT_MODIFY_SRID_0 = 3714;
    public const ER_WARN_RESERVED_SRID_RANGE = 3715;
    public const ER_CANT_MODIFY_SRS_USED_BY_COLUMN = 3716;
    public const ER_SRS_INVALID_CHARACTER_IN_ATTRIBUTE = 3717;
    public const ER_SRS_ATTRIBUTE_STRING_TOO_LONG = 3718;
    public const ER_DEPRECATED_UTF8_ALIAS = 3719;
    public const ER_DEPRECATED_NATIONAL = 3720;
    public const ER_INVALID_DEFAULT_UTF8MB4_COLLATION = 3721;
    public const ER_UNABLE_TO_COLLECT_LOG_STATUS = 3722;
    public const ER_RESERVED_TABLESPACE_NAME = 3723;
    public const ER_UNABLE_TO_SET_OPTION = 3724;
    public const ER_REPLICA_POSSIBLY_DIVERGED_AFTER_DDL = 3725;
    public const ER_SLAVE_POSSIBLY_DIVERGED_AFTER_DDL = 3725;
    public const ER_SRS_NOT_GEOGRAPHIC = 3726;
    public const ER_POLYGON_TOO_LARGE = 3727;
    public const ER_SPATIAL_UNIQUE_INDEX = 3728;
    public const ER_INDEX_TYPE_NOT_SUPPORTED_FOR_SPATIAL_INDEX = 3729;
    public const ER_FK_CANNOT_DROP_PARENT = 3730;
    public const ER_GEOMETRY_PARAM_LONGITUDE_OUT_OF_RANGE = 3731;
    public const ER_GEOMETRY_PARAM_LATITUDE_OUT_OF_RANGE = 3732;
    public const ER_FK_CANNOT_USE_VIRTUAL_COLUMN = 3733;
    public const ER_FK_NO_COLUMN_PARENT = 3734;
    public const ER_CANT_SET_ERROR_SUPPRESSION_LIST = 3735;
    public const ER_SRS_GEOGCS_INVALID_AXES = 3736;
    public const ER_SRS_INVALID_SEMI_MAJOR_AXIS = 3737;
    public const ER_SRS_INVALID_INVERSE_FLATTENING = 3738;
    public const ER_SRS_INVALID_ANGULAR_UNIT = 3739;
    public const ER_SRS_INVALID_PRIME_MERIDIAN = 3740;
    public const ER_TRANSFORM_SOURCE_SRS_NOT_SUPPORTED = 3741;
    public const ER_TRANSFORM_TARGET_SRS_NOT_SUPPORTED = 3742;
    public const ER_TRANSFORM_SOURCE_SRS_MISSING_TOWGS84 = 3743;
    public const ER_TRANSFORM_TARGET_SRS_MISSING_TOWGS84 = 3744;
    public const ER_TEMP_TABLE_PREVENTS_SWITCH_SESSION_BINLOG_FORMAT = 3745;
    public const ER_TEMP_TABLE_PREVENTS_SWITCH_GLOBAL_BINLOG_FORMAT = 3746;
    public const ER_RUNNING_APPLIER_PREVENTS_SWITCH_GLOBAL_BINLOG_FORMAT = 3747;
    public const ER_CLIENT_GTID_UNSAFE_CREATE_DROP_TEMP_TABLE_IN_TRX_IN_SBR = 3748;
    public const ER_TABLE_WITHOUT_PK = 3750;
    public const ER_WARN_DATA_TRUNCATED_FUNCTIONAL_INDEX = 3751;
    public const WARN_DATA_TRUNCATED_FUNCTIONAL_INDEX = 3751;
    public const ER_WARN_DATA_OUT_OF_RANGE_FUNCTIONAL_INDEX = 3752;
    public const ER_FUNCTIONAL_INDEX_ON_JSON_OR_GEOMETRY_FUNCTION = 3753;
    public const ER_FUNCTIONAL_INDEX_REF_AUTO_INCREMENT = 3754;
    public const ER_CANNOT_DROP_COLUMN_FUNCTIONAL_INDEX = 3755;
    public const ER_FUNCTIONAL_INDEX_PRIMARY_KEY = 3756;
    public const ER_FUNCTIONAL_INDEX_ON_LOB = 3757;
    public const ER_FUNCTIONAL_INDEX_FUNCTION_IS_NOT_ALLOWED = 3758;
    public const ER_FULLTEXT_FUNCTIONAL_INDEX = 3759;
    public const ER_SPATIAL_FUNCTIONAL_INDEX = 3760;
    public const ER_WRONG_KEY_COLUMN_FUNCTIONAL_INDEX = 3761;
    public const ER_FUNCTIONAL_INDEX_ON_FIELD = 3762;
    public const ER_GENERATED_COLUMN_NAMED_FUNCTION_IS_NOT_ALLOWED = 3763;
    public const ER_GENERATED_COLUMN_ROW_VALUE = 3764;
    public const ER_GENERATED_COLUMN_VARIABLES = 3765;
    public const ER_DEPENDENT_BY_DEFAULT_GENERATED_VALUE = 3766;
    public const ER_DEFAULT_VAL_GENERATED_NON_PRIOR = 3767;
    public const ER_DEFAULT_VAL_GENERATED_REF_AUTO_INC = 3768;
    public const ER_DEFAULT_VAL_GENERATED_FUNCTION_IS_NOT_ALLOWED = 3769;
    public const ER_DEFAULT_VAL_GENERATED_NAMED_FUNCTION_IS_NOT_ALLOWED = 3770;
    public const ER_DEFAULT_VAL_GENERATED_ROW_VALUE = 3771;
    public const ER_DEFAULT_VAL_GENERATED_VARIABLES = 3772;
    public const ER_DEFAULT_AS_VAL_GENERATED = 3773;
    public const ER_UNSUPPORTED_ACTION_ON_DEFAULT_VAL_GENERATED = 3774;
    public const ER_GTID_UNSAFE_ALTER_ADD_COL_WITH_DEFAULT_EXPRESSION = 3775;
    public const ER_FK_CANNOT_CHANGE_ENGINE = 3776;
    public const ER_WARN_DEPRECATED_USER_SET_EXPR = 3777;
    public const ER_WARN_DEPRECATED_UTF8MB3_COLLATION = 3778;
    public const ER_WARN_DEPRECATED_NESTED_COMMENT_SYNTAX = 3779;
    public const ER_FK_INCOMPATIBLE_COLUMNS = 3780;
    public const ER_GR_HOLD_WAIT_TIMEOUT = 3781;
    public const ER_GR_HOLD_KILLED = 3782;
    public const ER_GR_HOLD_MEMBER_STATUS_ERROR = 3783;
    public const ER_RPL_ENCRYPTION_FAILED_TO_FETCH_KEY = 3784;
    public const ER_RPL_ENCRYPTION_KEY_NOT_FOUND = 3785;
    public const ER_RPL_ENCRYPTION_KEYRING_INVALID_KEY = 3786;
    public const ER_RPL_ENCRYPTION_HEADER_ERROR = 3787;
    public const ER_RPL_ENCRYPTION_FAILED_TO_ROTATE_LOGS = 3788;
    public const ER_RPL_ENCRYPTION_KEY_EXISTS_UNEXPECTED = 3789;
    public const ER_RPL_ENCRYPTION_FAILED_TO_GENERATE_KEY = 3790;
    public const ER_RPL_ENCRYPTION_FAILED_TO_STORE_KEY = 3791;
    public const ER_RPL_ENCRYPTION_FAILED_TO_REMOVE_KEY = 3792;
    public const ER_RPL_ENCRYPTION_UNABLE_TO_CHANGE_OPTION = 3793;
    public const ER_RPL_ENCRYPTION_MASTER_KEY_RECOVERY_FAILED = 3794;
    public const ER_SLOW_LOG_MODE_IGNORED_WHEN_NOT_LOGGING_TO_FILE = 3795;
    public const ER_GRP_TRX_CONSISTENCY_NOT_ALLOWED = 3796;
    public const ER_GRP_TRX_CONSISTENCY_BEFORE = 3797;
    public const ER_GRP_TRX_CONSISTENCY_AFTER_ON_TRX_BEGIN = 3798;
    public const ER_GRP_TRX_CONSISTENCY_BEGIN_NOT_ALLOWED = 3799;
    public const ER_FUNCTIONAL_INDEX_ROW_VALUE_IS_NOT_ALLOWED = 3800;
    public const ER_RPL_ENCRYPTION_FAILED_TO_ENCRYPT = 3801;
    public const ER_PAGE_TRACKING_NOT_STARTED = 3802;
    public const ER_PAGE_TRACKING_RANGE_NOT_TRACKED = 3803;
    public const ER_PAGE_TRACKING_CANNOT_PURGE = 3804;
    public const ER_RPL_ENCRYPTION_CANNOT_ROTATE_BINLOG_MASTER_KEY = 3805;
    public const ER_BINLOG_MASTER_KEY_RECOVERY_OUT_OF_COMBINATION = 3806;
    public const ER_BINLOG_MASTER_KEY_ROTATION_FAIL_TO_OPERATE_KEY = 3807;
    public const ER_BINLOG_MASTER_KEY_ROTATION_FAIL_TO_ROTATE_LOGS = 3808;
    public const ER_BINLOG_MASTER_KEY_ROTATION_FAIL_TO_REENCRYPT_LOG = 3809;
    public const ER_BINLOG_MASTER_KEY_ROTATION_FAIL_TO_CLEANUP_UNUSED_KEYS = 3810;
    public const ER_BINLOG_MASTER_KEY_ROTATION_FAIL_TO_CLEANUP_AUX_KEY = 3811;
    public const ER_NON_BOOLEAN_EXPR_FOR_CHECK_CONSTRAINT = 3812;
    public const ER_COLUMN_CHECK_CONSTRAINT_REFERENCES_OTHER_COLUMN = 3813;
    public const ER_CHECK_CONSTRAINT_NAMED_FUNCTION_IS_NOT_ALLOWED = 3814;
    public const ER_CHECK_CONSTRAINT_FUNCTION_IS_NOT_ALLOWED = 3815;
    public const ER_CHECK_CONSTRAINT_VARIABLES = 3816;
    public const ER_CHECK_CONSTRAINT_ROW_VALUE = 3817;
    public const ER_CHECK_CONSTRAINT_REFERS_AUTO_INCREMENT_COLUMN = 3818;
    public const ER_CHECK_CONSTRAINT_VIOLATED = 3819;
    public const ER_CHECK_CONSTRAINT_REFERS_UNKNOWN_COLUMN = 3820;
    public const ER_CHECK_CONSTRAINT_NOT_FOUND = 3821;
    public const ER_CHECK_CONSTRAINT_DUP_NAME = 3822;
    public const ER_CHECK_CONSTRAINT_CLAUSE_USING_FK_REFER_ACTION_COLUMN = 3823;
    public const WARN_UNENCRYPTED_TABLE_IN_ENCRYPTED_DB = 3824;
    public const ER_INVALID_ENCRYPTION_REQUEST = 3825;
    public const ER_CANNOT_SET_TABLE_ENCRYPTION = 3826;
    public const ER_CANNOT_SET_DATABASE_ENCRYPTION = 3827;
    public const ER_CANNOT_SET_TABLESPACE_ENCRYPTION = 3828;
    public const ER_TABLESPACE_CANNOT_BE_ENCRYPTED = 3829;
    public const ER_TABLESPACE_CANNOT_BE_DECRYPTED = 3830;
    public const ER_TABLESPACE_TYPE_UNKNOWN = 3831;
    public const ER_TARGET_TABLESPACE_UNENCRYPTED = 3832;
    public const ER_CANNOT_USE_ENCRYPTION_CLAUSE = 3833;
    public const ER_INVALID_MULTIPLE_CLAUSES = 3834;
    public const ER_UNSUPPORTED_USE_OF_GRANT_AS = 3835;
    public const ER_UKNOWN_AUTH_ID_OR_ACCESS_DENIED_FOR_GRANT_AS = 3836;
    public const ER_DEPENDENT_BY_FUNCTIONAL_INDEX = 3837;
    public const ER_PLUGIN_NOT_EARLY = 3838;
    public const ER_INNODB_REDO_LOG_ARCHIVE_START_SUBDIR_PATH = 3839;
    public const ER_INNODB_REDO_LOG_ARCHIVE_START_TIMEOUT = 3840;
    public const ER_INNODB_REDO_LOG_ARCHIVE_DIRS_INVALID = 3841;
    public const ER_INNODB_REDO_LOG_ARCHIVE_LABEL_NOT_FOUND = 3842;
    public const ER_INNODB_REDO_LOG_ARCHIVE_DIR_EMPTY = 3843;
    public const ER_INNODB_REDO_LOG_ARCHIVE_NO_SUCH_DIR = 3844;
    public const ER_INNODB_REDO_LOG_ARCHIVE_DIR_CLASH = 3845;
    public const ER_INNODB_REDO_LOG_ARCHIVE_DIR_PERMISSIONS = 3846;
    public const ER_INNODB_REDO_LOG_ARCHIVE_FILE_CREATE = 3847;
    public const ER_INNODB_REDO_LOG_ARCHIVE_ACTIVE = 3848;
    public const ER_INNODB_REDO_LOG_ARCHIVE_INACTIVE = 3849;
    public const ER_INNODB_REDO_LOG_ARCHIVE_FAILED = 3850;
    public const ER_INNODB_REDO_LOG_ARCHIVE_SESSION = 3851;
    public const ER_STD_REGEX_ERROR = 3852;
    public const ER_INVALID_JSON_TYPE = 3853;
    public const ER_CANNOT_CONVERT_STRING = 3854;
    public const ER_DEPENDENT_BY_PARTITION_FUNC = 3855;
    public const ER_WARN_DEPRECATED_FLOAT_AUTO_INCREMENT = 3856;
    public const ER_RPL_CANT_STOP_REPLICA_WHILE_LOCKED_BACKUP = 3857;
    public const ER_RPL_CANT_STOP_SLAVE_WHILE_LOCKED_BACKUP = 3857;
    public const ER_WARN_DEPRECATED_FLOAT_DIGITS = 3858;
    public const ER_WARN_DEPRECATED_FLOAT_UNSIGNED = 3859;
    public const ER_WARN_DEPRECATED_INTEGER_DISPLAY_WIDTH = 3860;
    public const ER_WARN_DEPRECATED_ZEROFILL = 3861;
    public const ER_CLONE_DONOR = 3862;
    public const ER_CLONE_PROTOCOL = 3863;
    public const ER_CLONE_DONOR_VERSION = 3864;
    public const ER_CLONE_OS = 3865;
    public const ER_CLONE_PLATFORM = 3866;
    public const ER_CLONE_CHARSET = 3867;
    public const ER_CLONE_CONFIG = 3868;
    public const ER_CLONE_SYS_CONFIG = 3869;
    public const ER_CLONE_PLUGIN_MATCH = 3870;
    public const ER_CLONE_LOOPBACK = 3871;
    public const ER_CLONE_ENCRYPTION = 3872;
    public const ER_CLONE_DISK_SPACE = 3873;
    public const ER_CLONE_IN_PROGRESS = 3874;
    public const ER_CLONE_DISALLOWED = 3875;
    public const ER_CANNOT_GRANT_ROLES_TO_ANONYMOUS_USER = 3876;
    public const ER_SECONDARY_ENGINE_PLUGIN = 3877;
    public const ER_SECOND_PASSWORD_CANNOT_BE_EMPTY = 3878;
    public const ER_DB_ACCESS_DENIED = 3879;
    public const ER_DA_AUTH_ID_WITH_SYSTEM_USER_PRIV_IN_MANDATORY_ROLES = 3880;
    public const ER_DA_RPL_GTID_TABLE_CANNOT_OPEN = 3881;
    public const ER_GEOMETRY_IN_UNKNOWN_LENGTH_UNIT = 3882;
    public const ER_DA_PLUGIN_INSTALL_ERROR = 3883;
    public const ER_NO_SESSION_TEMP = 3884;
    public const ER_DA_UNKNOWN_ERROR_NUMBER = 3885;
    public const ER_COLUMN_CHANGE_SIZE = 3886;
    public const ER_REGEXP_INVALID_CAPTURE_GROUP_NAME = 3887;
    public const ER_DA_SSL_LIBRARY_ERROR = 3888;
    public const ER_SECONDARY_ENGINE = 3889;
    public const ER_SECONDARY_ENGINE_DDL = 3890;
    public const ER_INCORRECT_CURRENT_PASSWORD = 3891;
    public const ER_MISSING_CURRENT_PASSWORD = 3892;
    public const ER_CURRENT_PASSWORD_NOT_REQUIRED = 3893;
    public const ER_PASSWORD_CANNOT_BE_RETAINED_ON_PLUGIN_CHANGE = 3894;
    public const ER_CURRENT_PASSWORD_CANNOT_BE_RETAINED = 3895;
    public const ER_PARTIAL_REVOKES_EXIST = 3896;
    public const ER_CANNOT_GRANT_SYSTEM_PRIV_TO_MANDATORY_ROLE = 3897;
    public const ER_XA_REPLICATION_FILTERS = 3898;
    public const ER_UNSUPPORTED_SQL_MODE = 3899;
    public const ER_REGEXP_INVALID_FLAG = 3900;
    public const ER_PARTIAL_REVOKE_AND_DB_GRANT_BOTH_EXISTS = 3901;
    public const ER_UNIT_NOT_FOUND = 3902;
    public const ER_INVALID_JSON_VALUE_FOR_FUNC_INDEX = 3903;
    public const ER_JSON_VALUE_OUT_OF_RANGE_FOR_FUNC_INDEX = 3904;
    public const ER_EXCEEDED_MV_KEYS_NUM = 3905;
    public const ER_EXCEEDED_MV_KEYS_SPACE = 3906;
    public const ER_FUNCTIONAL_INDEX_DATA_IS_TOO_LONG = 3907;
    public const ER_WRONG_MVI_VALUE = 3908;
    public const ER_WARN_FUNC_INDEX_NOT_APPLICABLE = 3909;
    public const ER_GRP_RPL_UDF_ERROR = 3910;
    public const ER_UPDATE_GTID_PURGED_WITH_GR = 3911;
    public const ER_GROUPING_ON_TIMESTAMP_IN_DST = 3912;
    public const ER_TABLE_NAME_CAUSES_TOO_LONG_PATH = 3913;
    public const ER_AUDIT_LOG_INSUFFICIENT_PRIVILEGE = 3914;
    public const ER_DA_GRP_RPL_STARTED_AUTO_REJOIN = 3916;
    public const ER_SYSVAR_CHANGE_DURING_QUERY = 3917;
    public const ER_GLOBSTAT_CHANGE_DURING_QUERY = 3918;
    public const ER_GRP_RPL_MESSAGE_SERVICE_INIT_FAILURE = 3919;
    public const ER_CHANGE_MASTER_WRONG_COMPRESSION_ALGORITHM_CLIENT = 3920;
    public const ER_CHANGE_SOURCE_WRONG_COMPRESSION_ALGORITHM_CLIENT = 3920;
    public const ER_CHANGE_MASTER_WRONG_COMPRESSION_LEVEL_CLIENT = 3921;
    public const ER_CHANGE_SOURCE_WRONG_COMPRESSION_LEVEL_CLIENT = 3921;
    public const ER_WRONG_COMPRESSION_ALGORITHM_CLIENT = 3922;
    public const ER_WRONG_COMPRESSION_LEVEL_CLIENT = 3923;
    public const ER_CHANGE_MASTER_WRONG_COMPRESSION_ALGORITHM_LIST_CLIENT = 3924;
    public const ER_CHANGE_SOURCE_WRONG_COMPRESSION_ALGORITHM_LIST_CLIENT = 3924;
    public const ER_CLIENT_PRIVILEGE_CHECKS_USER_CANNOT_BE_ANONYMOUS = 3925;
    public const ER_CLIENT_PRIVILEGE_CHECKS_USER_DOES_NOT_EXIST = 3926;
    public const ER_CLIENT_PRIVILEGE_CHECKS_USER_CORRUPT = 3927;
    public const ER_CLIENT_PRIVILEGE_CHECKS_USER_NEEDS_RPL_APPLIER_PRIV = 3928;
    public const ER_WARN_DA_PRIVILEGE_NOT_REGISTERED = 3929;
    public const ER_CLIENT_KEYRING_UDF_KEY_INVALID = 3930;
    public const ER_CLIENT_KEYRING_UDF_KEY_TYPE_INVALID = 3931;
    public const ER_CLIENT_KEYRING_UDF_KEY_TOO_LONG = 3932;
    public const ER_CLIENT_KEYRING_UDF_KEY_TYPE_TOO_LONG = 3933;
    public const ER_JSON_SCHEMA_VALIDATION_ERROR_WITH_DETAILED_REPORT = 3934;
    public const ER_DA_UDF_INVALID_CHARSET_SPECIFIED = 3935;
    public const ER_DA_UDF_INVALID_CHARSET = 3936;
    public const ER_DA_UDF_INVALID_COLLATION = 3937;
    public const ER_DA_UDF_INVALID_EXTENSION_ARGUMENT_TYPE = 3938;
    public const ER_MULTIPLE_CONSTRAINTS_WITH_SAME_NAME = 3939;
    public const ER_CONSTRAINT_NOT_FOUND = 3940;
    public const ER_ALTER_CONSTRAINT_ENFORCEMENT_NOT_SUPPORTED = 3941;
    public const ER_TABLE_VALUE_CONSTRUCTOR_MUST_HAVE_COLUMNS = 3942;
    public const ER_TABLE_VALUE_CONSTRUCTOR_CANNOT_HAVE_DEFAULT = 3943;
    public const ER_CLIENT_QUERY_FAILURE_INVALID_NON_ROW_FORMAT = 3944;
    public const ER_REQUIRE_ROW_FORMAT_INVALID_VALUE = 3945;
    public const ER_FAILED_TO_DETERMINE_IF_ROLE_IS_MANDATORY = 3946;
    public const ER_FAILED_TO_FETCH_MANDATORY_ROLE_LIST = 3947;
    public const ER_CLIENT_LOCAL_FILES_DISABLED = 3948;
    public const ER_IMP_INCOMPATIBLE_CFG_VERSION = 3949;
    public const ER_DA_OOM = 3950;
    public const ER_DA_UDF_INVALID_ARGUMENT_TO_SET_CHARSET = 3951;
    public const ER_DA_UDF_INVALID_RETURN_TYPE_TO_SET_CHARSET = 3952;
    public const ER_MULTIPLE_INTO_CLAUSES = 3953;
    public const ER_MISPLACED_INTO = 3954;
    public const ER_USER_ACCESS_DENIED_FOR_USER_ACCOUNT_BLOCKED_BY_PASSWORD_LOCK = 3955;
    public const ER_WARN_DEPRECATED_YEAR_UNSIGNED = 3956;
    public const ER_CLONE_NETWORK_PACKET = 3957;
    public const ER_SDI_OPERATION_FAILED_MISSING_RECORD = 3958;
    public const ER_DEPENDENT_BY_CHECK_CONSTRAINT = 3959;
    public const ER_GRP_OPERATION_NOT_ALLOWED_GR_MUST_STOP = 3960;
    public const ER_WARN_DEPRECATED_JSON_TABLE_ON_ERROR_ON_EMPTY = 3961;
    public const ER_WARN_DEPRECATED_INNER_INTO = 3962;
    public const ER_WARN_DEPRECATED_VALUES_FUNCTION_ALWAYS_NULL = 3963;
    public const ER_WARN_DEPRECATED_SQL_CALC_FOUND_ROWS = 3964;
    public const ER_WARN_DEPRECATED_FOUND_ROWS = 3965;
    public const ER_MISSING_JSON_VALUE = 3966;
    public const ER_MULTIPLE_JSON_VALUES = 3967;
    public const ER_HOSTNAME_TOO_LONG = 3968;
    public const ER_WARN_CLIENT_DEPRECATED_PARTITION_PREFIX_KEY = 3969;
    public const ER_GROUP_REPLICATION_USER_EMPTY_MSG = 3970;
    public const ER_GROUP_REPLICATION_USER_MANDATORY_MSG = 3971;
    public const ER_GROUP_REPLICATION_PASSWORD_LENGTH = 3972;
    public const ER_SUBQUERY_TRANSFORM_REJECTED = 3973;
    public const ER_DA_GRP_RPL_RECOVERY_ENDPOINT_FORMAT = 3974;
    public const ER_DA_GRP_RPL_RECOVERY_ENDPOINT_INVALID = 3975;
    public const ER_WRONG_VALUE_FOR_VAR_PLUS_ACTIONABLE_PART = 3976;
    public const ER_STATEMENT_NOT_ALLOWED_AFTER_START_TRANSACTION = 3977;
    public const ER_FOREIGN_KEY_WITH_ATOMIC_CREATE_SELECT = 3978;
    public const ER_NOT_ALLOWED_WITH_START_TRANSACTION = 3979;
    public const ER_INVALID_JSON_ATTRIBUTE = 3980;
    public const ER_ENGINE_ATTRIBUTE_NOT_SUPPORTED = 3981;
    public const ER_INVALID_USER_ATTRIBUTE_JSON = 3982;
    public const ER_INNODB_REDO_DISABLED = 3983;
    public const ER_INNODB_REDO_ARCHIVING_ENABLED = 3984;
    public const ER_MDL_OUT_OF_RESOURCES = 3985;
    public const ER_IMPLICIT_COMPARISON_FOR_JSON = 3986;
    public const ER_FUNCTION_DOES_NOT_SUPPORT_CHARACTER_SET = 3987;
    public const ER_IMPOSSIBLE_STRING_CONVERSION = 3988;
    public const ER_SCHEMA_READ_ONLY = 3989;
    public const ER_RPL_ASYNC_RECONNECT_GTID_MODE_OFF = 3990;
    public const ER_RPL_ASYNC_RECONNECT_AUTO_POSITION_OFF = 3991;
    public const ER_DISABLE_GTID_MODE_REQUIRES_ASYNC_RECONNECT_OFF = 3992;
    public const ER_DISABLE_AUTO_POSITION_REQUIRES_ASYNC_RECONNECT_OFF = 3993;
    public const ER_INVALID_PARAMETER_USE = 3994;
    public const ER_CHARACTER_SET_MISMATCH = 3995;
    public const ER_WARN_VAR_VALUE_CHANGE_NOT_SUPPORTED = 3996;
    public const ER_INVALID_TIME_ZONE_INTERVAL = 3997;
    public const ER_INVALID_CAST = 3998;
    public const ER_HYPERGRAPH_NOT_SUPPORTED_YET = 3999;
    public const ER_WARN_HYPERGRAPH_EXPERIMENTAL = 4000;
    public const ER_DA_NO_ERROR_LOG_PARSER_CONFIGURED = 4001;
    public const ER_DA_ERROR_LOG_TABLE_DISABLED = 4002;
    public const ER_DA_ERROR_LOG_MULTIPLE_FILTERS = 4003;
    public const ER_DA_CANT_OPEN_ERROR_LOG = 4004;
    public const ER_USER_REFERENCED_AS_DEFINER = 4005;
    public const ER_CANNOT_USER_REFERENCED_AS_DEFINER = 4006;
    public const ER_REGEX_NUMBER_TOO_BIG = 4007;
    public const ER_SPVAR_NONINTEGER_TYPE = 4008;
    public const WARN_UNSUPPORTED_ACL_TABLES_READ = 4009;
    public const ER_BINLOG_UNSAFE_ACL_TABLE_READ_IN_DML_DDL = 4010;
    public const ER_STOP_REPLICA_MONITOR_IO_THREAD_TIMEOUT = 4011;
    public const ER_STARTING_REPLICA_MONITOR_IO_THREAD = 4012;
    public const ER_CANT_USE_ANONYMOUS_TO_GTID_WITH_GTID_MODE_NOT_ON = 4013;
    public const ER_CANT_COMBINE_ANONYMOUS_TO_GTID_AND_AUTOPOSITION = 4014;
    public const ER_ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTIONS_REQUIRES_GTID_MODE_ON = 4015;
    public const ER_SQL_REPLICA_SKIP_COUNTER_USED_WITH_GTID_MODE_ON = 4016;
    public const ER_SQL_SLAVE_SKIP_COUNTER_USED_WITH_GTID_MODE_ON = 4016;
    public const ER_USING_ASSIGN_GTIDS_TO_ANONYMOUS_TRANSACTIONS_AS_LOCAL_OR_UUID = 4017;
    public const ER_CANT_SET_ANONYMOUS_TO_GTID_AND_WAIT_UNTIL_SQL_THD_AFTER_GTIDS = 4018;
    public const ER_CANT_SET_SQL_AFTER_OR_BEFORE_GTIDS_WITH_ANONYMOUS_TO_GTID = 4019;
    public const ER_ANONYMOUS_TO_GTID_UUID_SAME_AS_GROUP_NAME = 4020;
    public const ER_CANT_USE_SAME_UUID_AS_GROUP_NAME = 4021;
    public const ER_GRP_RPL_RECOVERY_CHANNEL_STILL_RUNNING = 4022;
    public const ER_INNODB_INVALID_AUTOEXTEND_SIZE_VALUE = 4023;
    public const ER_INNODB_INCOMPATIBLE_WITH_TABLESPACE = 4024;
    public const ER_INNODB_AUTOEXTEND_SIZE_OUT_OF_RANGE = 4025;
    public const ER_CANNOT_USE_AUTOEXTEND_SIZE_CLAUSE = 4026;
    public const ER_ROLE_GRANTED_TO_ITSELF = 4027;
    public const ER_TABLE_MUST_HAVE_A_VISIBLE_COLUMN = 4028;
    public const ER_INNODB_COMPRESSION_FAILURE = 4029;
    public const ER_WARN_ASYNC_CONN_FAILOVER_NETWORK_NAMESPACE = 4030;
    public const ER_CLIENT_INTERACTION_TIMEOUT = 4031;
    public const ER_INVALID_CAST_TO_GEOMETRY = 4032;
    public const ER_INVALID_CAST_POLYGON_RING_DIRECTION = 4033;
    public const ER_GIS_DIFFERENT_SRIDS_AGGREGATION = 4034;
    public const ER_RELOAD_KEYRING_FAILURE = 4035;
    public const ER_SDI_GET_KEYS_INVALID_TABLESPACE = 4036;
    public const ER_CHANGE_RPL_SRC_WRONG_COMPRESSION_ALGORITHM_SIZE = 4037;
    public const ER_WARN_DEPRECATED_TLS_VERSION_FOR_CHANNEL_CLI = 4038;
    public const ER_CANT_USE_SAME_UUID_AS_VIEW_CHANGE_UUID = 4039;
    public const ER_ANONYMOUS_TO_GTID_UUID_SAME_AS_VIEW_CHANGE_UUID = 4040;
    public const ER_GRP_RPL_VIEW_CHANGE_UUID_FAIL_GET_VARIABLE = 4041;
    public const ER_WARN_ADUIT_LOG_MAX_SIZE_AND_PRUNE_SECONDS = 4042;
    public const ER_WARN_ADUIT_LOG_MAX_SIZE_CLOSE_TO_ROTATE_ON_SIZE = 4043;
    public const ER_KERBEROS_CREATE_USER = 4044;
    public const ER_INSTALL_PLUGIN_CONFLICT_CLIENT = 4045;
    public const ER_DA_ERROR_LOG_COMPONENT_FLUSH_FAILED = 4046;
    public const ER_WARN_SQL_AFTER_MTS_GAPS_GAP_NOT_CALCULATED = 4047;
    public const ER_INVALID_ASSIGNMENT_TARGET = 4048;
    public const ER_OPERATION_NOT_ALLOWED_ON_GR_SECONDARY = 4049;
    public const ER_GRP_RPL_FAILOVER_CHANNEL_STATUS_PROPAGATION = 4050;
    public const ER_WARN_AUDIT_LOG_FORMAT_UNIX_TIMESTAMP_ONLY_WHEN_JSON = 4051;
    public const ER_INVALID_MFA_PLUGIN_SPECIFIED = 4052;
    public const ER_IDENTIFIED_BY_UNSUPPORTED = 4053;
    public const ER_INVALID_PLUGIN_FOR_REGISTRATION = 4054;
    public const ER_PLUGIN_REQUIRES_REGISTRATION = 4055;
    public const ER_MFA_METHOD_EXISTS = 4056;
    public const ER_MFA_METHOD_NOT_EXISTS = 4057;
    public const ER_AUTHENTICATION_POLICY_MISMATCH = 4058;
    public const ER_PLUGIN_REGISTRATION_DONE = 4059;
    public const ER_INVALID_USER_FOR_REGISTRATION = 4060;
    public const ER_USER_REGISTRATION_FAILED = 4061;
    public const ER_MFA_METHODS_INVALID_ORDER = 4062;
    public const ER_MFA_METHODS_IDENTICAL = 4063;
    public const ER_INVALID_MFA_OPERATIONS_FOR_PASSWORDLESS_USER = 4064;
    public const ER_CHANGE_REPLICATION_SOURCE_NO_OPTIONS_FOR_GTID_ONLY = 4065;
    public const ER_CHANGE_REP_SOURCE_CANT_DISABLE_REQ_ROW_FORMAT_WITH_GTID_ONLY = 4066;
    public const ER_CHANGE_REP_SOURCE_CANT_DISABLE_AUTO_POSITION_WITH_GTID_ONLY = 4067;
    public const ER_CHANGE_REP_SOURCE_CANT_DISABLE_GTID_ONLY_WITHOUT_POSITIONS = 4068;
    public const ER_CHANGE_REP_SOURCE_CANT_DISABLE_AUTO_POS_WITHOUT_POSITIONS = 4069;
    public const ER_CHANGE_REP_SOURCE_GR_CHANNEL_WITH_GTID_MODE_NOT_ON = 4070;
    public const ER_CANT_USE_GTID_ONLY_WITH_GTID_MODE_NOT_ON = 4071;
    public const ER_WARN_C_DISABLE_GTID_ONLY_WITH_SOURCE_AUTO_POS_INVALID_POS = 4072;
    public const ER_DA_SSL_FIPS_MODE_ERROR = 4073;
    public const ER_VALUE_OUT_OF_RANGE = 4074;
    public const ER_FULLTEXT_WITH_ROLLUP = 4075;
    public const ER_REGEXP_MISSING_RESOURCE = 4076;
    public const ER_WARN_REGEXP_USING_DEFAULT = 4077;
    public const ER_REGEXP_MISSING_FILE = 4078;
    public const ER_WARN_DEPRECATED_COLLATION = 4079;
    public const ER_CONCURRENT_PROCEDURE_USAGE = 4080;
    public const ER_DA_GLOBAL_CONN_LIMIT = 4081;
    public const ER_DA_CONN_LIMIT = 4082;
    public const ER_ALTER_OPERATION_NOT_SUPPORTED_REASON_COLUMN_TYPE_INSTANT = 4083;
    public const ER_WARN_SF_UDF_NAME_COLLISION = 4084;
    public const ER_CANNOT_PURGE_BINLOG_WITH_BACKUP_LOCK = 4085;
    public const ER_TOO_MANY_WINDOWS = 4086;
    public const ER_MYSQLBACKUP_CLIENT_MSG = 4087;
    public const ER_COMMENT_CONTAINS_INVALID_STRING = 4088;
    public const ER_DEFINITION_CONTAINS_INVALID_STRING = 4089;
    public const ER_CANT_EXECUTE_COMMAND_WITH_ASSIGNED_GTID_NEXT = 4090;
    public const ER_XA_TEMP_TABLE = 4091;
    public const ER_INNODB_MAX_ROW_VERSION = 4092;
    public const ER_INNODB_INSTANT_ADD_NOT_SUPPORTED_MAX_SIZE = 4093;
    public const ER_OPERATION_NOT_ALLOWED_WHILE_PRIMARY_CHANGE_IS_RUNNING = 4094;
    public const ER_WARN_DEPRECATED_DATETIME_DELIMITER = 4095;
    public const ER_WARN_DEPRECATED_SUPERFLUOUS_DELIMITER = 4096;
    public const ER_CANNOT_PERSIST_SENSITIVE_VARIABLES = 4097;
    public const ER_WARN_CANNOT_SECURELY_PERSIST_SENSITIVE_VARIABLES = 4098;
    public const ER_WARN_TRG_ALREADY_EXISTS = 4099;
    public const ER_IF_NOT_EXISTS_UNSUPPORTED_TRG_EXISTS_ON_DIFFERENT_TABLE = 4100;
    public const ER_IF_NOT_EXISTS_UNSUPPORTED_UDF_NATIVE_FCT_NAME_COLLISION = 4101;
    public const ER_SET_PASSWORD_AUTH_PLUGIN_ERROR = 4102;
    public const ER_SRS_INVALID_LATITUDE_OF_ORIGIN = 4105;
    public const ER_SRS_INVALID_LONGITUDE_OF_ORIGIN = 4106;
    public const ER_SRS_UNUSED_PROJ_PARAMETER_PRESENT = 4107;
    public const ER_GIPK_COLUMN_EXISTS = 4108;
    public const ER_GIPK_FAILED_AUTOINC_COLUMN_EXISTS = 4109;
    public const ER_GIPK_COLUMN_ALTER_NOT_ALLOWED = 4110;
    public const ER_DROP_PK_COLUMN_TO_DROP_GIPK = 4111;
    public const ER_CREATE_SELECT_WITH_GIPK_DISALLOWED_IN_SBR = 4112;
    public const ER_DA_EXPIRE_LOGS_DAYS_IGNORED = 4113;
    public const ER_CTE_RECURSIVE_NOT_UNION = 4114;
    public const ER_COMMAND_BACKEND_FAILED_TO_FETCH_SECURITY_CTX = 4115;
    public const ER_COMMAND_SERVICE_BACKEND_FAILED = 4116;
    public const ER_CLIENT_FILE_PRIVILEGE_FOR_REPLICATION_CHECKS = 4117;
    public const ER_GROUP_REPLICATION_FORCE_MEMBERS_COMMAND_FAILURE = 4118;
    public const ER_WARN_DEPRECATED_IDENT = 4119;
    public const ER_INTERSECT_ALL_MAX_DUPLICATES_EXCEEDED = 4120;
    public const ER_TP_QUERY_THRS_PER_GRP_EXCEEDS_TXN_THR_LIMIT = 4121;
    public const ER_BAD_TIMESTAMP_FORMAT = 4122;
    public const ER_SHAPE_PRIDICTION_UDF = 4123;
    public const ER_SRS_INVALID_HEIGHT = 4124;
    public const ER_SRS_INVALID_SCALING = 4125;
    public const ER_SRS_INVALID_ZONE_WIDTH = 4126;
    public const ER_SRS_INVALID_LATITUDE_POLAR_STERE_VAR_A = 4127;
    public const ER_WARN_DEPRECATED_CLIENT_NO_SCHEMA_OPTION = 4128;
    public const ER_TABLE_NOT_EMPTY = 4129;
    public const ER_TABLE_NO_PRIMARY_KEY = 4130;
    public const ER_TABLE_IN_SHARED_TABLESPACE = 4131;
    public const ER_INDEX_OTHER_THAN_PK = 4132;
    public const ER_LOAD_BULK_DATA_UNSORTED = 4133;
    public const ER_BULK_EXECUTOR_ERROR = 4134;
    public const ER_BULK_READER_LIBCURL_INIT_FAILED = 4135;
    public const ER_BULK_READER_LIBCURL_ERROR = 4136;
    public const ER_BULK_READER_SERVER_ERROR = 4137;
    public const ER_BULK_READER_COMMUNICATION_ERROR = 4138;
    public const ER_BULK_LOAD_DATA_FAILED = 4139;
    public const ER_BULK_LOADER_COLUMN_TOO_BIG_FOR_LEFTOVER_BUFFER = 4140;
    public const ER_BULK_LOADER_COMPONENT_ERROR = 4141;
    public const ER_BULK_LOADER_FILE_CONTAINS_LESS_LINES_THAN_IGNORE_CLAUSE = 4142;
    public const ER_BULK_PARSER_MISSING_ENCLOSED_BY = 4143;
    public const ER_BULK_PARSER_ROW_BUFFER_MAX_TOTAL_COLS_EXCEEDED = 4144;
    public const ER_BULK_PARSER_COPY_BUFFER_SIZE_EXCEEDED = 4145;
    public const ER_BULK_PARSER_UNEXPECTED_END_OF_INPUT = 4146;
    public const ER_BULK_PARSER_UNEXPECTED_ROW_TERMINATOR = 4147;
    public const ER_BULK_PARSER_UNEXPECTED_CHAR_AFTER_ENDING_ENCLOSED_BY = 4148;
    public const ER_BULK_PARSER_UNEXPECTED_CHAR_AFTER_NULL_ESCAPE = 4149;
    public const ER_BULK_PARSER_UNEXPECTED_CHAR_AFTER_COLUMN_TERMINATOR = 4150;
    public const ER_BULK_PARSER_INCOMPLETE_ESCAPE_SEQUENCE = 4151;
    public const ER_LOAD_BULK_DATA_FAILED = 4152;
    public const ER_LOAD_BULK_DATA_WRONG_VALUE_FOR_FIELD = 4153;
    public const ER_LOAD_BULK_DATA_WARN_NULL_TO_NOTNULL = 4154;
    public const ER_REQUIRE_TABLE_PRIMARY_KEY_CHECK_GENERATE_WITH_GR = 4155;
    public const ER_CANT_CHANGE_SYS_VAR_IN_READ_ONLY_MODE = 4156;
    public const ER_INNODB_INSTANT_ADD_DROP_NOT_SUPPORTED_MAX_SIZE = 4157;
    public const ER_INNODB_INSTANT_ADD_NOT_SUPPORTED_MAX_FIELDS = 4158;
    public const ER_CANT_SET_PERSISTED = 4159;
    public const ER_INSTALL_COMPONENT_SET_NULL_VALUE = 4160;
    public const ER_INSTALL_COMPONENT_SET_UNUSED_VALUE = 4161;
    public const ER_WARN_DEPRECATED_USER_DEFINED_COLLATIONS = 4162;
    public const ER_SP_UNSUPPORTED_LANGUAGE = 4163;
    public const ER_SP_NO_ALTER_LANGUAGE = 4164;
    public const ER_VALIDATE_PASSWORD_INSUFFICIENT_CHANGED_CHARACTERS = 4165;
    public const ER_WARN_DEPRECATED_WITH_NOTE = 4166;

}
