<p align="center">
<img src="https://user-images.githubusercontent.com/20617661/135019003-62f544c4-9278-47a0-bfdd-f0eae5895ab9.png" alt="Roslyn logo">
</p>

<hr/>

<p align="center">
 <img src="https://github.com/SPCodeOrg/SPCode/actions/workflows/betarelease.yml/badge.svg">
 <img src="https://github.com/SPCodeOrg/SPCode/actions/workflows/release.yml/badge.svg">
 <a href="https://discord.com/invite/Uf6hMqnkY4"><img src="https://discordapp.com/api/guilds/810629824884375582/widget.png" alt="Chat on Discord" style="max-width:100%;"></a> 
<p>

<h2>About</h2>

<img src="https://user-images.githubusercontent.com/20617661/135123265-98b3a7bf-606e-4cee-9839-810295f936cf.png">

SPCode is an open source SourcePawn editor, with multiple tools and features designed to help you <b>develop and deploy your SourceMod plugins fast and easy</b>.
It was born in 2015 under the name of SPEdit, and in early 2020, we took care of its development. <a href="https://github.com/SPCodeOrg/SPCode/releases/latest">Download it now!</a>

<h2>Features</h2>

* Compiling-config system (fully customizable)
* Syntax highlighting (fully customizable)
* Deprecated 1.6 syntax highlighting
* SourcePawn plugin templates (customizable)
* Copying after/before compiling (& pre/post commandlines)
* Dynamic autocomplete and IntelliSense-like functionalities from all opened include-files
* FTP upload
* Server start feature
* Code folding
* Editor docking
* API references
* Bracket highlighting
* Auto-indentation (active and passive)
* Errors/warnings list
* Syntax reformatter (syntax tidy)
* Auto-updating
* [Lysis Decompiler](https://github.com/peace-maker/lysis-java) (by [peace-maker](https://github.com/peace-maker))
* SMX dissassembler
* RCON querying
* Auto bracket-closing
* Object browser
* Translations in multiple languages

<h2>Building</h2>

Requirements:
- [.NET Framework 4.8](https://dotnet.microsoft.com/en-us/download/dotnet-framework/thank-you/net48-developer-pack-offline-installer)
- [NSIS](https://nsis.sourceforge.io/Download)
- [Git](https://git-scm.com/download/win)

1- Build the program: `msbuild Spcode.csproj /p:Configuration=Release` <br>
2- Create the installer with `makensis .\bin\Release\SPCode.nsi` <br>
3- Create the portable version running `.\Compress.ps1` with PowerShell <br>
4- Build the updater: `msbuild Deploy\SpcodeUpdater\SpcodeUpdater.csproj /p:Configuration=Release`

<h2>Credits</h2>

* [Julien Kluge](https://github.com/JulienKluge) (original author of [SPEdit](https://github.com/JulienKluge/SPEdit))
* [Maxi Jabase](https://github.com/maxijabase) (current maintainer)
* [Natanel Shitrit](https://github.com/natanel-shitrit) (maintainer)
* [Hexer10](https://github.com/Hexer10) (maintainer, SPCode creator)
