<?php
defined('CORE_PATH') OR defined('INDEX_PAGE') OR exit('No direct script access allowed');

/*
  |--------------------------------------------------------------------------
  | Base Site URL
  |--------------------------------------------------------------------------
  |
  | URL to your CodeIgniter root. Typically this will be your base URL,
  | WITH a trailing slash:
  |
  |	http://example.com/
  |
  | WARNING: You MUST set this value!
  |
  | If it is not set, then CodeIgniter will try guess the protocol and path
  | your installation, but due to security concerns the hostname will be set
  | to $_SERVER['SERVER_ADDR'] if available, or localhost otherwise.
  | The auto-detection mechanism exists only for convenience during
  | development and MUST NOT be used in production!
  |
  | If you need to allow multiple domains, remember that this file is still
  | a PHP script and you can easily do that on your own.
  |
 */
$config['base_url'] = '/';

/*
  |--------------------------------------------------------------------------
  | Index File
  |--------------------------------------------------------------------------
  |
  | Typically this will be your index.php file, unless you've renamed it to
  | something else. If you are using mod_rewrite to remove the page set this
  | variable so that it is blank.
  |
 */
$config['index_page'] = 'index.php';

/*
  |--------------------------------------------------------------------------
  | URI PROTOCOL
  |--------------------------------------------------------------------------
  |
  | This item determines which server global should be used to retrieve the
  | URI string.  The default setting of 'REQUEST_URI' works for most servers.
  | If your links do not seem to work, try one of the other delicious flavors:
  |
  | 'REQUEST_URI'    Uses $_SERVER['REQUEST_URI']
  | 'QUERY_STRING'   Uses $_SERVER['QUERY_STRING']
  | 'PATH_INFO'      Uses $_SERVER['PATH_INFO']
  |
  | WARNING: If you set this to 'PATH_INFO', URIs will always be URL-decoded!
 */
$config['uri_protocol'] = 'REQUEST_URI';

/*
  |--------------------------------------------------------------------------
  | URL suffix
  |--------------------------------------------------------------------------
  |
  | This option allows you to add a suffix to all URLs generated by CodeIgniter.
  | For more information please see the user guide:
  |
  | https://codeigniter.com/user_guide/general/urls.html
 */
$config['url_suffix'] = '';

/*
  |--------------------------------------------------------------------------
  | Default Language
  |--------------------------------------------------------------------------
  |
  | This determines which set of language files should be used. Make sure
  | there is an available translation if you intend to use something other
  | than english.
  |
 */
$config['language'] = 'english';

/*
  |--------------------------------------------------------------------------
  | Default Character Set
  |--------------------------------------------------------------------------
  |
  | This determines which character set is used by default in various methods
  | that require a character set to be provided.
  |
  | See http://php.net/htmlspecialchars for a list of supported charsets.
  |
 */
$config['charset'] = 'UTF-8';

/*
  |--------------------------------------------------------------------------
  | Enable/Disable System Hooks
  |--------------------------------------------------------------------------
  |
  | If you would like to use the 'hooks' feature you must enable it by
  | setting this variable to TRUE (boolean).  See the user guide for details.
  |
 */
$config['enable_hooks'] = FALSE;

/*
  |--------------------------------------------------------------------------
  | Class Extension Prefix
  |--------------------------------------------------------------------------
  |
  | This item allows you to set the filename/classname prefix when extending
  | native libraries.  For more information please see the user guide:
  |
  | https://codeigniter.com/user_guide/general/core_classes.html
  | https://codeigniter.com/user_guide/general/creating_libraries.html
  |
 */
$config['subclass_prefix'] = 'MY_';

/*
  |--------------------------------------------------------------------------
  | Composer auto-loading
  |--------------------------------------------------------------------------
  |
  | Enabling this setting will tell CodeIgniter to look for a Composer
  | package auto-loader script in application/vendor/autoload.php.
  |
  |	$config['composer_autoload'] = TRUE;
  |
  | Or if you have your vendor/ directory located somewhere else, you
  | can opt to set a specific path as well:
  |
  |	$config['composer_autoload'] = '/path/to/vendor/autoload.php';
  |
  | For more information about Composer, please visit http://getcomposer.org/
  |
  | Note: This will NOT disable or override the CodeIgniter-specific
  |	autoloading (application/config/autoload.php)
 */
$config['composer_autoload'] = FALSE;

/*
  |--------------------------------------------------------------------------
  | Allowed URL Characters
  |--------------------------------------------------------------------------
  |
  | This lets you specify which characters are permitted within your URLs.
  | When someone tries to submit a URL with disallowed characters they will
  | get a warning message.
  |
  | As a security measure you are STRONGLY encouraged to restrict URLs to
  | as few characters as possible.  By default only these are allowed: a-z 0-9~%.:_-
  |
  | Leave blank to allow all characters -- but only if you are insane.
  |
  | The configured value is actually a regular expression character group
  | and it will be executed as: ! preg_match('/^[<permitted_uri_chars>]+$/i
  |
  | DO NOT CHANGE THIS UNLESS YOU FULLY UNDERSTAND THE REPERCUSSIONS!!
  |
 */
$config['permitted_uri_chars'] = 'a-z 0-9~%.:_\-@\=';

/*
  |--------------------------------------------------------------------------
  | Enable Query Strings
  |--------------------------------------------------------------------------
  |
  | By default CodeIgniter uses search-engine friendly segment based URLs:
  | example.com/who/what/where/
  |
  | By default CodeIgniter enables access to the $_GET array.  If for some
  | reason you would like to disable it, set 'allow_get_array' to FALSE.
  |
  | You can optionally enable standard query string based URLs:
  | example.com?who=me&what=something&where=here
  |
  | Options are: TRUE or FALSE (boolean)
  |
  | The other items let you set the query string 'words' that will
  | invoke your controllers and its functions:
  | example.com/index.php?c=controller&m=function
  |
  | Please note that some of the helpers won't work as expected when
  | this feature is enabled, since CodeIgniter is designed primarily to
  | use segment based URLs.
  |
 */
$config['allow_get_array'] = TRUE;
$config['enable_query_strings'] = FALSE;
$config['controller_trigger'] = 'c';
$config['function_trigger'] = 'm';
$config['directory_trigger'] = 'd';

/*
  |--------------------------------------------------------------------------
  | Error Logging Threshold
  |--------------------------------------------------------------------------
  |
  | You can enable error logging by setting a threshold over zero. The
  | threshold determines what gets logged. Threshold options are:
  |
  |	0 = Disables logging, Error logging TURNED OFF
  |	1 = Error Messages (including PHP errors)
  |	2 = Debug Messages
  |	3 = Informational Messages
  |	4 = All Messages
  |
  | You can also pass an array with threshold levels to show individual error types
  |
  | 	array(2) = Debug Messages, without Error Messages
  |
  | For a live site you'll usually only enable Errors (1) to be logged otherwise
  | your log files will fill up very fast.
  |
 */
$config['log_threshold'] = 0;

/*
  |--------------------------------------------------------------------------
  | Error Logging Directory Path
  |--------------------------------------------------------------------------
  |
  | Leave this BLANK unless you would like to set something other than the default
  | application/logs/ directory. Use a full server path with trailing slash.
  |
 */
$config['log_path'] = '';

/*
  |--------------------------------------------------------------------------
  | Log File Extension
  |--------------------------------------------------------------------------
  |
  | The default filename extension for log files. The default 'php' allows for
  | protecting the log files via basic scripting, when they are to be stored
  | under a publicly accessible directory.
  |
  | Note: Leaving it blank will default to 'php'.
  |
 */
$config['log_file_extension'] = '';

/*
  |--------------------------------------------------------------------------
  | Log File Permissions
  |--------------------------------------------------------------------------
  |
  | The file system permissions to be applied on newly created log files.
  |
  | IMPORTANT: This MUST be an integer (no quotes) and you MUST use octal
  |            integer notation (i.e. 0700, 0644, etc.)
 */
$config['log_file_permissions'] = 0644;

/*
  |--------------------------------------------------------------------------
  | Date Format for Logs
  |--------------------------------------------------------------------------
  |
  | Each item that is logged has an associated date. You can use PHP date
  | codes to set your own date formatting
  |
 */
$config['project_name'] = 'Ceramic';
$config['project_version'] = '1.1.0';
$config['log_date_format'] = 'Y-m-d H:i:s';
$config['default_controller'] = 'Welcome';
$config['case_insensitive'] = true;
$config['globals'] = array(//dirname(dirname(ROOT)) . DIRECTORY_SEPARATOR . "config" . DIRECTORY_SEPARATOR . "config.php"
);
//$config['includes'] = array(dirname(dirname(ROOT)) . DIRECTORY_SEPARATOR . "config" . DIRECTORY_SEPARATOR);
//$config['includes'] = array(dirname(dirname(ROOT)) . DIRECTORY_SEPARATOR . "config" . DIRECTORY_SEPARATOR . "config.php");

$config['header'] = 'global/header';
$config['footer'] = 'global/footer';
$config['force_https'] = true;
/* $config['authentication'] = array(
	'controller' => 'login',
	'session' => 'cm-login-sessid',
	'referrer' => true,
	'type' => ''
); */

const ENVIRONMENT = ENVIRONMENT_DEVELOPMENT;
//const SHOW_DEBUG_BACKTRACE = true;
