SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Table structure for sd_ad
-- ----------------------------
DROP TABLE IF EXISTS `sd_ad`;
CREATE TABLE `sd_ad` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `datalist` text,
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  `akey` varchar(10) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_admin
-- ----------------------------
DROP TABLE IF EXISTS `sd_admin`;
CREATE TABLE `sd_admin` (
  `adminid` int(10) NOT NULL AUTO_INCREMENT,
  `adminname` varchar(50) DEFAULT '',
  `adminpass` varchar(50) DEFAULT '',
  `penname` varchar(20) DEFAULT '',
  `pid` int(10) DEFAULT '0',
  `logintimes` int(10) DEFAULT '0',
  `lastlogindate` int(10) DEFAULT '0',
  `lastloginip` varchar(50) DEFAULT '',
  `islock` int(10) DEFAULT '0',
  `readonly` smallint(1) DEFAULT '0',
  PRIMARY KEY (`adminid`),
  KEY `adminname` (`adminname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_admin_log
-- ----------------------------
DROP TABLE IF EXISTS `sd_admin_log`;
CREATE TABLE `sd_admin_log` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `url` varchar(255) DEFAULT '',
  `msg` varchar(255) DEFAULT '',
  `ip` varchar(50) DEFAULT '',
  `createdate` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_admin_login_log
-- ----------------------------
DROP TABLE IF EXISTS `sd_admin_login_log`;
CREATE TABLE `sd_admin_login_log` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `loginname` varchar(50) DEFAULT '',
  `loginip` varchar(50) DEFAULT '',
  `logindate` int(10) DEFAULT '0',
  `loginmsg` varchar(255) DEFAULT '',
  `loginstate` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_admin_menu
-- ----------------------------
DROP TABLE IF EXISTS `sd_admin_menu`;
CREATE TABLE `sd_admin_menu` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `cname` varchar(50) DEFAULT '',
  `aname` varchar(50) DEFAULT '',
  `dname` varchar(255) DEFAULT '',
  `followid` int(10) DEFAULT '0',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_admin_part
-- ----------------------------
DROP TABLE IF EXISTS `sd_admin_part`;
CREATE TABLE `sd_admin_part` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `page_list` text,
  `cate_list` text,
  `pagelever` varchar(50) DEFAULT '',
  `pagelock` smallint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_alias
-- ----------------------------
DROP TABLE IF EXISTS `sd_alias`;
CREATE TABLE `sd_alias` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `alias` varchar(50) DEFAULT '',
  `app` varchar(255) DEFAULT '',
  `sid` int(10) DEFAULT '0',
  `types` int(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `alias` (`alias`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_attachment
-- ----------------------------
DROP TABLE IF EXISTS `sd_attachment`;
CREATE TABLE `sd_attachment` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '1：图片，2：视频，3：其他文件',
  `file_url` varchar(255) DEFAULT '',
  `file_name` varchar(255) DEFAULT '' COMMENT '文件名',
  `file_ext` varchar(50) DEFAULT '' COMMENT '后缀',
  `file_size` int(10) DEFAULT '0',
  `file_type` int(10) DEFAULT '0' COMMENT '1：图片，2：视频，3：其他',
  `file_update` int(10) DEFAULT '0' COMMENT '上传的日期',
  `file_local` int(10) DEFAULT '0' COMMENT '存放位置（1：本地，2：阿里云，3：七牛云）',
  `file_adminid` int(10) DEFAULT '0',
  `file_userid` int(10) DEFAULT '0',
  `file_ip` varchar(50) DEFAULT '' COMMENT '传者上IP',
  `gid` int(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`file_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_attachment_group
-- ----------------------------
DROP TABLE IF EXISTS `sd_attachment_group`;
CREATE TABLE `sd_attachment_group` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `gname` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `islock` smallint(1) DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_auth
-- ----------------------------
DROP TABLE IF EXISTS `sd_auth`;
CREATE TABLE `sd_auth` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ckey` varchar(50) DEFAULT '',
  `cval` text,
  `cdate` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_auto_key
-- ----------------------------
DROP TABLE IF EXISTS `sd_auto_key`;
CREATE TABLE `sd_auto_key` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `reply_type` int(10) DEFAULT '0',
  `reply_text` text,
  `reply_id` int(10) DEFAULT '0',
  `matchtype` int(10) DEFAULT '0',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_auto_reply
-- ----------------------------
DROP TABLE IF EXISTS `sd_auto_reply`;
CREATE TABLE `sd_auto_reply` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `reply_key` varchar(50) DEFAULT '',
  `reply_type` int(10) DEFAULT '0',
  `reply_text` text,
  `reply_id` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_badword
-- ----------------------------
DROP TABLE IF EXISTS `sd_badword`;
CREATE TABLE `sd_badword` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `words` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_bbs
-- ----------------------------
DROP TABLE IF EXISTS `sd_bbs`;
CREATE TABLE `sd_bbs` (
  `bbs_id` int(10) NOT NULL AUTO_INCREMENT,
  `fid` int(10) DEFAULT '0',
  `title` varchar(255) DEFAULT '',
  `userid` int(10) DEFAULT '0',
  `islock` tinyint(4) DEFAULT '0',
  `ontop` tinyint(4) DEFAULT '0',
  `isnice` tinyint(4) DEFAULT '0',
  `hits` int(10) DEFAULT '0',
  `replynum` int(10) DEFAULT '0',
  `createdate` int(10) DEFAULT '0',
  PRIMARY KEY (`bbs_id`),
  KEY `title` (`title`),
  KEY `islock` (`islock`),
  KEY `fid` (`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_bbs_cate
-- ----------------------------
DROP TABLE IF EXISTS `sd_bbs_cate`;
CREATE TABLE `sd_bbs_cate` (
  `cateid` int(10) NOT NULL AUTO_INCREMENT,
  `catename` varchar(50) DEFAULT '',
  `seotitle` varchar(255) DEFAULT '',
  `seokey` varchar(255) DEFAULT '',
  `seodesc` varchar(255) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `isshow` tinyint(4) DEFAULT '0',
  `post_group` varchar(255) DEFAULT '',
  `view_group` varchar(255) DEFAULT '',
  `reply_group` varchar(255) DEFAULT '',
  `cate_icon` varchar(255) DEFAULT '',
  PRIMARY KEY (`cateid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_bbs_reply
-- ----------------------------
DROP TABLE IF EXISTS `sd_bbs_reply`;
CREATE TABLE `sd_bbs_reply` (
  `replyid` int(10) NOT NULL AUTO_INCREMENT,
  `bbsid` int(10) DEFAULT '0',
  `userid` int(10) DEFAULT '0',
  `istopic` tinyint(4) DEFAULT '0',
  `content` mediumtext,
  `reply` text,
  `createdate` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`replyid`),
  KEY `bbsid` (`bbsid`),
  KEY `istopic` (`istopic`),
  KEY `islock` (`islock`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_book
-- ----------------------------
DROP TABLE IF EXISTS `sd_book`;
CREATE TABLE `sd_book` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `truename` varchar(50) DEFAULT '',
  `tel` varchar(20) DEFAULT '',
  `mobile` varchar(11) DEFAULT '',
  `remark` text,
  `reply` text,
  `ontop` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  `createdate` int(10) DEFAULT '0',
  `postip` varchar(20) DEFAULT '',
  `replydate` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_category
-- ----------------------------
DROP TABLE IF EXISTS `sd_category`;
CREATE TABLE `sd_category` (
  `cateid` int(11) NOT NULL AUTO_INCREMENT,
  `catename` varchar(50) DEFAULT '',
  `followid` int(10) DEFAULT '0',
  `catenum` int(10) DEFAULT '0',
  `catetype` int(10) DEFAULT '0',
  `cateurl` varchar(255) DEFAULT '',
  `catepage` int(10) DEFAULT '0',
  `catelist` varchar(255) DEFAULT '',
  `cateshow` varchar(255) DEFAULT '',
  `catetitle` varchar(255) DEFAULT '',
  `catekey` varchar(255) DEFAULT '',
  `catedesc` varchar(255) DEFAULT '',
  `isshow` int(10) DEFAULT '0',
  `isblank` int(10) DEFAULT '0',
  `isfilter` int(10) DEFAULT '0',
  `catedomain` varchar(255) DEFAULT '',
  `cate_extend` int(10) DEFAULT '0',
  `mycateename` varchar(255) DEFAULT '',
  `mycatepic` varchar(255) DEFAULT '',
  `cate_groupid` varchar(50) DEFAULT '',
  `myename` varchar(255) DEFAULT '',
  PRIMARY KEY (`cateid`),
  KEY `followid` (`followid`),
  KEY `ordnum` (`catenum`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_category_field
-- ----------------------------
DROP TABLE IF EXISTS `sd_category_field`;
CREATE TABLE `sd_category_field` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `field_title` varchar(50) DEFAULT '',
  `field_key` varchar(50) DEFAULT '',
  `field_type` int(10) DEFAULT '0',
  `field_length` int(10) DEFAULT '0',
  `field_upload_type` int(10) DEFAULT '0',
  `field_default` varchar(255) DEFAULT '',
  `field_list` text,
  `field_sql` varchar(255) DEFAULT '',
  `field_tips` varchar(255) DEFAULT '',
  `field_rule` int(10) DEFAULT '0',
  `field_radio` int(10) DEFAULT '0',
  `field_editor` int(10) DEFAULT '0',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_city
-- ----------------------------
DROP TABLE IF EXISTS `sd_city`;
CREATE TABLE `sd_city` (
  `cateid` int(10) NOT NULL AUTO_INCREMENT COMMENT '区域主键',
  `name` varchar(20) DEFAULT '' COMMENT '区域名称',
  `followid` int(10) DEFAULT '0' COMMENT '上级',
  `ordnum` int(10) DEFAULT '0',
  `site_open` smallint(1) DEFAULT '0' COMMENT '是否开启分站功能',
  `site_root` varchar(50) DEFAULT '' COMMENT '路径',
  `site_domain` smallint(1) DEFAULT '0' COMMENT '是否绑定域名',
  `issys` smallint(1) DEFAULT '0',
  `site_self` smallint(1) DEFAULT '0',
  `site_key` varchar(255) DEFAULT '',
  `site_desc` varchar(255) DEFAULT '',
  `site_title` varchar(255) DEFAULT '',
  PRIMARY KEY (`cateid`),
  KEY `followid` (`followid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_code
-- ----------------------------
DROP TABLE IF EXISTS `sd_code`;
CREATE TABLE `sd_code` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT '',
  `code` varchar(50) DEFAULT '',
  `types` int(10) DEFAULT '0',
  `createdate` int(10) DEFAULT '0',
  `isover` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_config
-- ----------------------------
DROP TABLE IF EXISTS `sd_config`;
CREATE TABLE `sd_config` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `gid` int(10) DEFAULT '0',
  `ckey` varchar(50) DEFAULT '',
  `ctitle` varchar(50) DEFAULT '',
  `cvalue` text,
  `ordnum` int(10) DEFAULT '0',
  `ctype` int(10) DEFAULT '0',
  `dvalue` text,
  `dtext` varchar(255) DEFAULT NULL,
  `rtype` int(10) DEFAULT '0',
  `utype` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  `issys` int(10) DEFAULT '0',
  `ishide` smallint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ckey` (`ckey`),
  KEY `gid` (`gid`),
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_config_group
-- ----------------------------
DROP TABLE IF EXISTS `sd_config_group`;
CREATE TABLE `sd_config_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gname` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `gkey` varchar(50) DEFAULT '',
  `islock` int(10) DEFAULT '0',
  `types` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_content
-- ----------------------------
DROP TABLE IF EXISTS `sd_content`;
CREATE TABLE `sd_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT '',
  `pic` varchar(255) DEFAULT '',
  `ispic` int(10) DEFAULT '0',
  `classid` int(10) DEFAULT '0',
  `hits` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  `ontop` int(10) DEFAULT '0',
  `isnice` int(10) DEFAULT '0',
  `ordnum` int(10) DEFAULT '0',
  `upnum` int(10) DEFAULT '0',
  `downnum` int(10) DEFAULT '0',
  `isurl` int(10) DEFAULT '0',
  `url` varchar(255) DEFAULT '',
  `createdate` int(10) DEFAULT '0',
  `lastupdate` int(10) DEFAULT '0',
  `intro` text,
  `tags` varchar(255) DEFAULT '',
  `seotitle` varchar(255) DEFAULT '',
  `seokey` varchar(255) DEFAULT '',
  `seodesc` varchar(255) DEFAULT '',
  `alias` varchar(50) DEFAULT '',
  `showskin` varchar(255) DEFAULT '',
  `extend` text,
  `subid` varchar(255) DEFAULT '',
  `adminid` int(10) DEFAULT '0',
  `view_groupid` varchar(50) DEFAULT '',
  `isauto` int(10) DEFAULT '0',
  `tagslist` varchar(500) DEFAULT '',
  `ispush` int(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `where` (`islock`,`classid`,`id`,`subid`),
  KEY `order` (`id`,`ontop`,`ordnum`,`classid`,`islock`),
  KEY `ontop` (`id`,`ontop`),
  KEY `ordnum` (`id`,`ordnum`),
  KEY `isauto` (`islock`,`isauto`,`createdate`),
  KEY `subid` (`subid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_extend
-- ----------------------------
DROP TABLE IF EXISTS `sd_extend`;
CREATE TABLE `sd_extend` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_extend_field
-- ----------------------------
DROP TABLE IF EXISTS `sd_extend_field`;
CREATE TABLE `sd_extend_field` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `eid` int(10) DEFAULT '0',
  `field_title` varchar(50) DEFAULT '',
  `field_key` varchar(50) DEFAULT '',
  `field_type` int(10) DEFAULT '0',
  `field_list` text,
  `field_default` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_form
-- ----------------------------
DROP TABLE IF EXISTS `sd_form`;
CREATE TABLE `sd_form` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `tablename` varchar(255) DEFAULT '',
  `add_skins` varchar(255) DEFAULT '',
  `list_skins` varchar(255) DEFAULT '',
  `show_skins` varchar(255) DEFAULT '',
  `seotitle` varchar(255) DEFAULT '',
  `seokey` varchar(255) DEFAULT '',
  `seodesc` varchar(255) DEFAULT '',
  `iscode` int(10) DEFAULT '0',
  `backway` int(10) DEFAULT '0',
  `mid` int(10) DEFAULT '0',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  `isuser` smallint(1) DEFAULT '0',
  `publish_state` smallint(1) DEFAULT '0',
  `publish_limit` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_form_field
-- ----------------------------
DROP TABLE IF EXISTS `sd_form_field`;
CREATE TABLE `sd_form_field` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `form_id` int(10) DEFAULT '0',
  `field_title` varchar(50) DEFAULT '',
  `field_key` varchar(50) DEFAULT '',
  `field_type` int(10) DEFAULT '0',
  `field_length` int(10) DEFAULT '0',
  `field_upload_type` int(10) DEFAULT '0',
  `field_default` varchar(255) DEFAULT '',
  `field_list` text,
  `field_sql` varchar(255) DEFAULT '',
  `field_tips` varchar(255) DEFAULT '',
  `field_rule` int(10) DEFAULT '0',
  `field_radio` int(10) DEFAULT '0',
  `field_editor` int(10) DEFAULT '0',
  `field_filter` int(10) DEFAULT '0',
  `field_table` varchar(50) DEFAULT '',
  `field_join` varchar(255) DEFAULT '',
  `field_where` varchar(255) DEFAULT '',
  `field_order` varchar(255) DEFAULT '',
  `field_value` varchar(50) DEFAULT '',
  `field_label` varchar(50) DEFAULT '',
  `islist` int(10) DEFAULT '0',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_form_resume
-- ----------------------------
DROP TABLE IF EXISTS `sd_form_resume`;
CREATE TABLE `sd_form_resume` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `postip` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  `createdate` int(10) DEFAULT '0',
  `lastupdate` int(10) DEFAULT '0',
  `my_title` varchar(255) DEFAULT '',
  `my_truename` varchar(20) DEFAULT '',
  `my_sex` int(10) DEFAULT '0',
  `my_age` int(10) DEFAULT '0',
  `my_mobile` varchar(11) DEFAULT '',
  `my_education` int(10) DEFAULT '0',
  `my_work_exp` text,
  `my_intro` text,
  `mypiclist` text,
  `myeditor` text,
  `userid` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_inquiry
-- ----------------------------
DROP TABLE IF EXISTS `sd_inquiry`;
CREATE TABLE `sd_inquiry` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT '',
  `truename` varchar(50) DEFAULT '',
  `mobile` varchar(20) DEFAULT '',
  `remark` text,
  `createdate` int(10) DEFAULT '0',
  `isover` int(10) DEFAULT '0',
  `postip` varchar(50) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_link
-- ----------------------------
DROP TABLE IF EXISTS `sd_link`;
CREATE TABLE `sd_link` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `webname` varchar(50) DEFAULT '',
  `weblogo` varchar(255) DEFAULT '',
  `weburl` varchar(255) DEFAULT '',
  `islogo` int(10) DEFAULT '0',
  `classid` int(10) DEFAULT '0',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_mass
-- ----------------------------
DROP TABLE IF EXISTS `sd_mass`;
CREATE TABLE `sd_mass` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` int(10) DEFAULT '0',
  `mass_type` int(10) DEFAULT '0',
  `mass_text` text,
  `mass_id` int(10) DEFAULT '0',
  `isover` int(10) DEFAULT '0',
  `total_num` int(10) DEFAULT '0',
  `success_num` int(10) DEFAULT '0',
  `fail_num` int(10) DEFAULT '0',
  `msg_id` varchar(255) DEFAULT '',
  `post_type` smallint(2) DEFAULT '0',
  `wxname` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_mater
-- ----------------------------
DROP TABLE IF EXISTS `sd_mater`;
CREATE TABLE `sd_mater` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `media_id` varchar(255) DEFAULT '',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_mater_data
-- ----------------------------
DROP TABLE IF EXISTS `sd_mater_data`;
CREATE TABLE `sd_mater_data` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `cid` int(10) DEFAULT '0',
  `title` varchar(255) DEFAULT '',
  `pic` varchar(255) DEFAULT '',
  `intro` varchar(255) DEFAULT '',
  `content` text,
  `url` varchar(1000) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `piclist` text,
  `media_id` varchar(255) DEFAULT '',
  `media_date` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_model
-- ----------------------------
DROP TABLE IF EXISTS `sd_model`;
CREATE TABLE `sd_model` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `tablename` varchar(50) DEFAULT '',
  `model_desc` varchar(255) DEFAULT '',
  `list_skins` varchar(255) DEFAULT '',
  `show_skins` varchar(255) DEFAULT '',
  `form_group` varchar(255) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  `issys` int(10) DEFAULT '0',
  `leverstate` smallint(1) DEFAULT '0',
  `buystate` smallint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_model_field
-- ----------------------------
DROP TABLE IF EXISTS `sd_model_field`;
CREATE TABLE `sd_model_field` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `model_id` int(10) DEFAULT '0',
  `field_title` varchar(50) DEFAULT '',
  `field_key` varchar(50) DEFAULT '',
  `field_type` int(10) DEFAULT '0',
  `field_length` int(10) DEFAULT '0',
  `field_upload_type` int(10) DEFAULT '0',
  `field_default` varchar(255) DEFAULT '',
  `field_list` text,
  `field_sql` varchar(255) DEFAULT '',
  `field_tips` varchar(255) DEFAULT '',
  `field_rule` int(10) DEFAULT '0',
  `field_radio` int(10) DEFAULT '0',
  `field_editor` int(10) DEFAULT '0',
  `field_group` int(10) DEFAULT '0',
  `field_filter` int(10) DEFAULT '0',
  `field_table` varchar(50) DEFAULT '',
  `field_join` varchar(255) DEFAULT '',
  `field_where` varchar(255) DEFAULT '',
  `field_order` varchar(255) DEFAULT '',
  `field_value` varchar(50) DEFAULT '',
  `field_label` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  `issys` int(10) DEFAULT '0',
  `isbase` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_model_job
-- ----------------------------
DROP TABLE IF EXISTS `sd_model_job`;
CREATE TABLE `sd_model_job` (
  `jobid` int(10) NOT NULL AUTO_INCREMENT,
  `cid` int(10) DEFAULT '0',
  `content` text,
  `work_address` varchar(50) DEFAULT '',
  `work_nature` varchar(50) DEFAULT '',
  `work_education` varchar(50) DEFAULT '',
  `work_money` varchar(50) DEFAULT '',
  `work_age` varchar(50) DEFAULT '',
  `work_num` varchar(50) DEFAULT '',
  PRIMARY KEY (`jobid`),
  UNIQUE KEY `cid` (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_model_news
-- ----------------------------
DROP TABLE IF EXISTS `sd_model_news`;
CREATE TABLE `sd_model_news` (
  `newsid` int(10) NOT NULL AUTO_INCREMENT,
  `cid` int(10) DEFAULT '0',
  `price` decimal(10,2) DEFAULT '0.00',
  `content` text,
  PRIMARY KEY (`newsid`),
  UNIQUE KEY `cid` (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_model_page
-- ----------------------------
DROP TABLE IF EXISTS `sd_model_page`;
CREATE TABLE `sd_model_page` (
  `pageid` int(10) NOT NULL AUTO_INCREMENT,
  `cid` int(10) DEFAULT '0',
  `piclist` text,
  `content` text,
  PRIMARY KEY (`pageid`),
  UNIQUE KEY `cid` (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_model_pro
-- ----------------------------
DROP TABLE IF EXISTS `sd_model_pro`;
CREATE TABLE `sd_model_pro` (
  `proid` int(10) NOT NULL AUTO_INCREMENT,
  `cid` int(10) DEFAULT '0',
  `price` decimal(10,2) DEFAULT '0.00',
  `content` text,
  `piclist` text,
  PRIMARY KEY (`proid`),
  UNIQUE KEY `cid` (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_onlinepay
-- ----------------------------
DROP TABLE IF EXISTS `sd_onlinepay`;
CREATE TABLE `sd_onlinepay` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `orderid` varchar(50) DEFAULT '',
  `pay_no` varchar(50) DEFAULT '',
  `paytype` smallint(1) DEFAULT '0',
  `ispay` smallint(1) DEFAULT '0',
  `createdate` int(10) DEFAULT '0',
  `payway` varchar(100) DEFAULT '',
  `paymoney` decimal(10,2) DEFAULT '0.00',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_order
-- ----------------------------
DROP TABLE IF EXISTS `sd_order`;
CREATE TABLE `sd_order` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `orderid` varchar(50) DEFAULT '',
  `pro_name` varchar(255) DEFAULT '',
  `pro_num` int(10) DEFAULT '0',
  `pro_price` decimal(10,2) DEFAULT '0.00',
  `truename` varchar(50) DEFAULT '',
  `mobile` varchar(20) DEFAULT '',
  `address` varchar(255) DEFAULT '',
  `remark` text,
  `createdate` int(10) DEFAULT '0',
  `isover` int(10) DEFAULT '0',
  `ispay` int(10) DEFAULT '0',
  `payway` varchar(50) DEFAULT '',
  `trade_no` varchar(255) DEFAULT '',
  `postip` varchar(50) DEFAULT '',
  `userid` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_order_buy
-- ----------------------------
DROP TABLE IF EXISTS `sd_order_buy`;
CREATE TABLE `sd_order_buy` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `orderid` varchar(255) DEFAULT '',
  `userid` int(10) DEFAULT '0',
  `paymoney` decimal(10,2) DEFAULT '0.00',
  `cid` int(10) DEFAULT '0',
  `ispay` int(10) DEFAULT '0',
  `createdate` int(10) DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_sitelink
-- ----------------------------
DROP TABLE IF EXISTS `sd_sitelink`;
CREATE TABLE `sd_sitelink` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `url` varchar(255) DEFAULT '',
  `num` int(10) DEFAULT '0',
  `ordnum` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_tags
-- ----------------------------
DROP TABLE IF EXISTS `sd_tags`;
CREATE TABLE `sd_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `hits` int(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id` (`id`),
  KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_temp_mail
-- ----------------------------
DROP TABLE IF EXISTS `sd_temp_mail`;
CREATE TABLE `sd_temp_mail` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT '',
  `mail_title` varchar(255) DEFAULT '',
  `mail_content` text,
  `islock` int(10) DEFAULT '0',
  `mkey` varchar(50) DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `id` (`id`),
  KEY `mkey` (`mkey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_user
-- ----------------------------
DROP TABLE IF EXISTS `sd_user`;
CREATE TABLE `sd_user` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uname` varchar(50) DEFAULT '',
  `upass` varchar(50) DEFAULT '',
  `umoney` decimal(10,2) DEFAULT '0.00',
  `uemail` varchar(50) DEFAULT '',
  `uface` varchar(255) DEFAULT '',
  `uid` int(10) DEFAULT '0',
  `islock` int(10) DEFAULT '0',
  `regdate` int(10) DEFAULT '0',
  `regip` varchar(50) DEFAULT '',
  `lastlogindate` int(10) DEFAULT '0',
  `lastloginip` varchar(50) DEFAULT '',
  `logintimes` int(10) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uname` (`uname`),
  KEY `uemail` (`uemail`),
  KEY `uid` (`uid`),
  KEY `islock` (`islock`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_user_buy
-- ----------------------------
DROP TABLE IF EXISTS `sd_user_buy`;
CREATE TABLE `sd_user_buy` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `cid` int(10) DEFAULT '0',
  `userid` int(10) DEFAULT '0',
  `createdate` int(10) DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_user_group
-- ----------------------------
DROP TABLE IF EXISTS `sd_user_group`;
CREATE TABLE `sd_user_group` (
  `gid` int(10) NOT NULL AUTO_INCREMENT,
  `gname` varchar(50) DEFAULT '',
  `ordnum` int(10) DEFAULT '0',
  PRIMARY KEY (`gid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_user_login
-- ----------------------------
DROP TABLE IF EXISTS `sd_user_login`;
CREATE TABLE `sd_user_login` (
  `oid` int(10) NOT NULL AUTO_INCREMENT,
  `userid` int(10) DEFAULT '0',
  `type` varchar(10) DEFAULT '',
  `openid` varchar(255) DEFAULT '',
  `unionid` varchar(255) DEFAULT '',
  `session_key` varchar(255) DEFAULT '',
  `loginkey` varchar(255) DEFAULT '',
  PRIMARY KEY (`oid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_user_money
-- ----------------------------
DROP TABLE IF EXISTS `sd_user_money`;
CREATE TABLE `sd_user_money` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `types` smallint(1) DEFAULT '0',
  `title` varchar(255) DEFAULT '',
  `userid` int(10) DEFAULT '0',
  `amount` decimal(10,2) DEFAULT '0.00',
  `oldmoney` decimal(10,2) DEFAULT '0.00',
  `newmoney` decimal(10,2) DEFAULT '0.00',
  `createdate` int(10) DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_user_pay
-- ----------------------------
DROP TABLE IF EXISTS `sd_user_pay`;
CREATE TABLE `sd_user_pay` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `orderid` varchar(50) DEFAULT '',
  `userid` int(10) DEFAULT '0',
  `paymoney` decimal(10,2) DEFAULT '0.00',
  `createdate` int(10) DEFAULT '0',
  `ispay` smallint(1) DEFAULT '0',
  `payway` varchar(50) DEFAULT '',
  `paydate` int(10) DEFAULT '0',
  `trade_no` varchar(255) DEFAULT '',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for sd_wx_menu
-- ----------------------------
DROP TABLE IF EXISTS `sd_wx_menu`;
CREATE TABLE `sd_wx_menu` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(20) DEFAULT '',
  `followid` int(10) DEFAULT '0',
  `sonnum` int(10) DEFAULT '0',
  `reply_type` int(10) DEFAULT '0',
  `reply_text` text,
  `reply_id` int(10) DEFAULT '0',
  `reply_url` text,
  `ordnum` int(10) DEFAULT '0',
  `appid` varchar(255) DEFAULT '',
  `pagepath` varchar(255) DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records 
-- ----------------------------
INSERT INTO `sd_ad` VALUES ('1', 'Pc站Banner', '{\"1\":{\"image\":\"/upfile/2017/11/1510796972734.jpg\",\"desc\":\"\",\"url\":\"\"},\"2\":{\"image\":\"/upfile/2017/11/1510796972158.jpg\",\"desc\":\"\",\"url\":\"\"},\"3\":{\"image\":\"/upfile/2017/11/1510796972617.jpg\",\"desc\":\"\",\"url\":\"\"}}', '0', '1', 'pc');
INSERT INTO `sd_ad` VALUES ('2', '手机站Banner', '{\"2\":{\"image\":\"/upfile/2017/11/1511156457492.jpg\",\"desc\":\"\",\"url\":\"\"},\"3\":{\"image\":\"/upfile/2017/11/1511156457342.jpg\",\"desc\":\"\",\"url\":\"\"},\"1\":{\"image\":\"/upfile/2017/11/1511156457416.jpg\",\"desc\":\"\",\"url\":\"\"}}', '0', '1', 'mobile');
INSERT INTO `sd_ad` VALUES ('3', '小程序Banner', '{\"1\":{\"image\":\"/upfile/a1.jpg\",\"desc\":\"\",\"url\":\"\"},\"2\":{\"image\":\"/upfile/b1.jpg\",\"desc\":\"\",\"url\":\"\"},\"3\":{\"image\":\"/upfile/c1.jpg\",\"desc\":\"\",\"url\":\"\"}}', '3', '1', 'open');
INSERT INTO `sd_admin_menu` VALUES ('1', '网站管理', '', '', '', '0', '1', '1');
INSERT INTO `sd_admin_menu` VALUES ('2', '栏目管理', '', '', '', '0', '3', '1');
INSERT INTO `sd_admin_menu` VALUES ('3', '内容管理', '', '', '', '0', '5', '1');
INSERT INTO `sd_admin_menu` VALUES ('4', '扩展管理', '', '', '', '0', '15', '1');
INSERT INTO `sd_admin_menu` VALUES ('6', '模板插件', '', '', '', '0', '17', '1');
INSERT INTO `sd_admin_menu` VALUES ('7', '网站设置', 'config', 'index', '', '1', '1', '1');
INSERT INTO `sd_admin_menu` VALUES ('8', '设置分组', 'configgroup', 'index', '', '54', '5', '1');
INSERT INTO `sd_admin_menu` VALUES ('9', '模型管理', 'model', 'index', '', '2', '5', '1');
INSERT INTO `sd_admin_menu` VALUES ('10', '栏目管理', 'category', 'index', '', '2', '1', '1');
INSERT INTO `sd_admin_menu` VALUES ('11', '内容管理', 'content', 'index', '', '3', '1', '1');
INSERT INTO `sd_admin_menu` VALUES ('12', '回收站', 'content', 'recycle', '', '3', '3', '1');
INSERT INTO `sd_admin_menu` VALUES ('13', '友情链接', 'link', 'index', '', '4', '1', '1');
INSERT INTO `sd_admin_menu` VALUES ('14', '留言管理', 'book', 'index', '', '4', '3', '1');
INSERT INTO `sd_admin_menu` VALUES ('15', '表单管理', 'form', 'index', '', '2', '7', '1');
INSERT INTO `sd_admin_menu` VALUES ('16', '询价管理', 'inquiry', 'index', '', '4', '5', '1');
INSERT INTO `sd_admin_menu` VALUES ('17', '订单管理', 'order', 'index', '', '4', '7', '1');
INSERT INTO `sd_admin_menu` VALUES ('18', '广告管理', 'ad', 'index', '', '4', '9', '1');
INSERT INTO `sd_admin_menu` VALUES ('19', '部门管理', 'part', 'index', '', '1', '7', '1');
INSERT INTO `sd_admin_menu` VALUES ('20', '插件列表', 'plug', 'index', '', '6', '5', '1');
INSERT INTO `sd_admin_menu` VALUES ('21', '后台用户', 'admin', 'index', '', '1', '9', '1');
INSERT INTO `sd_admin_menu` VALUES ('22', '模板管理', 'theme', 'index', '', '6', '1', '1');
INSERT INTO `sd_admin_menu` VALUES ('23', '后台菜单', 'menu', 'index', '', '54', '13', '1');
INSERT INTO `sd_admin_menu` VALUES ('24', '栏目扩展', 'catefield', 'index', '', '2', '3', '1');
INSERT INTO `sd_admin_menu` VALUES ('25', '区块管理', 'block', 'index', '', '3', '5', '1');
INSERT INTO `sd_admin_menu` VALUES ('26', '微信公众号', '', '', '', '0', '9', '1');
INSERT INTO `sd_admin_menu` VALUES ('27', '素材管理', 'wxmater', 'index', '', '26', '1', '1');
INSERT INTO `sd_admin_menu` VALUES ('28', '关注回复', 'wxsubscribe', 'index', '', '26', '3', '1');
INSERT INTO `sd_admin_menu` VALUES ('29', '自动回复', 'wxauto', 'index', '', '26', '5', '1');
INSERT INTO `sd_admin_menu` VALUES ('30', '关键字回复', 'wxkey', 'index', '', '26', '7', '1');
INSERT INTO `sd_admin_menu` VALUES ('31', '菜单管理', 'wxmenu', 'index', '', '26', '9', '1');
INSERT INTO `sd_admin_menu` VALUES ('32', '内容扩展', 'extend', 'index', '', '2', '9', '1');
INSERT INTO `sd_admin_menu` VALUES ('33', '标签管理', 'tags', 'index', '', '4', '11', '1');
INSERT INTO `sd_admin_menu` VALUES ('34', '群发管理', 'wxmass', 'index', '', '26', '11', '1');
INSERT INTO `sd_admin_menu` VALUES ('35', '管理日志', 'log', 'index', '', '54', '15', '1');
INSERT INTO `sd_admin_menu` VALUES ('36', '错误日志', 'logerror', 'index', '', '54', '17', '1');
INSERT INTO `sd_admin_menu` VALUES ('37', '邮件模板', 'mail', 'index', '', '6', '3', '1');
INSERT INTO `sd_admin_menu` VALUES ('38', '缓存管理', 'cache', 'index', '', '54', '21', '1');
INSERT INTO `sd_admin_menu` VALUES ('39', '内链管理', 'sitelink', 'index', '', '4', '13', '1');
INSERT INTO `sd_admin_menu` VALUES ('40', '会员管理', '', '', '', '0', '7', '1');
INSERT INTO `sd_admin_menu` VALUES ('41', '会员管理', 'user', 'index', '', '40', '1', '1');
INSERT INTO `sd_admin_menu` VALUES ('42', '会员组管理', 'usergroup', 'index', '', '40', '3', '1');
INSERT INTO `sd_admin_menu` VALUES ('43', '会员设置', 'userconfig', 'index', '', '40', '5', '1');
INSERT INTO `sd_admin_menu` VALUES ('45', '社区管理', '', '', '', '0', '11', '1');
INSERT INTO `sd_admin_menu` VALUES ('46', '社区设置', 'bbsconfig', 'index', '', '45', '1', '1');
INSERT INTO `sd_admin_menu` VALUES ('47', '社区分类', 'bbscate', 'index', '', '45', '3', '1');
INSERT INTO `sd_admin_menu` VALUES ('48', '主题管理', 'bbs', 'index', '', '45', '5', '1');
INSERT INTO `sd_admin_menu` VALUES ('49', '帖子管理', 'bbstopic', 'index', '', '45', '7', '1');
INSERT INTO `sd_admin_menu` VALUES ('50', '城市分站', '', '', '', '0', '13', '1');
INSERT INTO `sd_admin_menu` VALUES ('51', '分站设置', 'cityconfig', 'index', '', '50', '1', '1');
INSERT INTO `sd_admin_menu` VALUES ('52', '城市管理', 'city', 'index', '', '50', '3', '1');
INSERT INTO `sd_admin_menu` VALUES ('53', '接口设置', 'api', 'index', '', '1', '3', '1');
INSERT INTO `sd_admin_menu` VALUES ('54', '系统管理', 'api', 'index', '', '0', '19', '1');
INSERT INTO `sd_admin_menu` VALUES ('55', '财务管理', 'usermoney', 'index', '', '40', '7', '1');
INSERT INTO `sd_admin_menu` VALUES ('56', '充值记录', 'userpay', 'index', '', '40', '9', '1');
INSERT INTO `sd_admin_menu` VALUES ('57', '购买记录', 'userbuy', 'index', '', '40', '11', '1');
INSERT INTO `sd_admin_menu` VALUES ('58', '支付记录', 'useronline', 'index', '', '40', '13', '1');
INSERT INTO `sd_alias` VALUES ('1', 'book', 'other/book', '0', '0');
INSERT INTO `sd_alias` VALUES ('2', 'sitemap', 'other/sitemap', '0', '0');
INSERT INTO `sd_alias` VALUES ('3', 'search', 'other/search', '0', '0');
INSERT INTO `sd_alias` VALUES ('4', 'tags', 'other/tags', '0', '0');
INSERT INTO `sd_alias` VALUES ('5', 'user', 'user/index', '0', '0');
INSERT INTO `sd_alias` VALUES ('6', 'login', 'user/login', '0', '0');
INSERT INTO `sd_alias` VALUES ('7', 'reg', 'user/reg', '0', '0');
INSERT INTO `sd_alias` VALUES ('8', 'getpass', 'user/getpass', '0', '0');
INSERT INTO `sd_alias` VALUES ('9', 'editpass', 'user/editpass', '0', '0');
INSERT INTO `sd_alias` VALUES ('10', 'editemail', 'user/editemail', '0', '0');
INSERT INTO `sd_alias` VALUES ('11', 'out', 'user/out', '0', '0');
INSERT INTO `sd_alias` VALUES ('12', 'bbs', 'bbs/index', '0', '0');
INSERT INTO `sd_alias` VALUES ('13', 'bbsadd', 'bbs/add', '0', '0');
INSERT INTO `sd_alias` VALUES ('14', 'bbsshow', 'bbs/show', '0', '0');
INSERT INTO `sd_alias` VALUES ('15', 'bbsedit', 'bbs/edit', '0', '0');
INSERT INTO `sd_alias` VALUES ('16', 'myorder', 'user/myorder', '0', '0');
INSERT INTO `sd_alias` VALUES ('17', 'city', 'index/city', '0', '0');
INSERT INTO `sd_alias` VALUES ('18', 'taglist', 'other/taglist', '0', '0');
INSERT INTO `sd_alias` VALUES ('19', 'pay', 'user/pay', '0', '0');
INSERT INTO `sd_alias` VALUES ('20', 'mymoney', 'user/mymoney', '0', '0');
INSERT INTO `sd_attachment` VALUES ('1', '/upfile/2017/11/1510640750195.jpg', '1510640750195.jpg', '.jpg', '95145', '1', '1510640752', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('2', '/upfile/2017/11/1510640750387.jpg', '1510640750387.jpg', '.jpg', '61096', '1', '1510640752', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('3', '/upfile/2017/11/1510640750423.jpg', '1510640750423.jpg', '.jpg', '52877', '1', '1510640752', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('4', '/upfile/2017/11/1510640750479.jpg', '1510640750479.jpg', '.jpg', '70092', '1', '1510640752', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('5', '/upfile/2017/11/1510640750803.jpg', '1510640750803.jpg', '.jpg', '55749', '1', '1510640752', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('6', '/upfile/2017/11/1510641452333.jpg', '1510641452333.jpg', '.jpg', '110976', '1', '1510641454', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('7', '/upfile/2017/11/1510641455868.jpg', '1510641455868.jpg', '.jpg', '91891', '1', '1510641456', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('8', '/upfile/2017/11/1510641456574.jpg', '1510641456574.jpg', '.jpg', '18221', '1', '1510641458', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('9', '/upfile/2017/11/1510641457995.jpg', '1510641457995.jpg', '.jpg', '75205', '1', '1510641458', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('10', '/upfile/2017/11/1510641459308.jpg', '1510641459308.jpg', '.jpg', '76882', '1', '1510641460', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('11', '/upfile/2017/11/1510641459659.jpg', '1510641459659.jpg', '.jpg', '20735', '1', '1510641460', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('12', '/upfile/2017/11/1510641461345.jpg', '1510641461345.jpg', '.jpg', '9625', '1', '1510641462', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('13', '/upfile/2017/11/1510641462273.jpg', '1510641462273.jpg', '.jpg', '94332', '1', '1510641464', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('14', '/upfile/2017/11/1510641463996.jpg', '1510641463996.jpg', '.jpg', '12543', '1', '1510641464', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('15', '/upfile/2017/11/1510641464608.jpg', '1510641464608.jpg', '.jpg', '49245', '1', '1510641466', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('16', '/upfile/2017/11/1510641832353.jpg', '1510641832353.jpg', '.jpg', '21529', '1', '1510641834', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('17', '/upfile/2017/11/1510641832876.jpg', '1510641832876.jpg', '.jpg', '35720', '1', '1510641834', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('18', '/upfile/2017/11/1510641833517.jpg', '1510641833517.jpg', '.jpg', '33148', '1', '1510641834', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('19', '/upfile/2017/11/1510641834688.jpg', '1510641834688.jpg', '.jpg', '41653', '1', '1510641836', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('20', '/upfile/2017/11/1510641835376.jpg', '1510641835376.jpg', '.jpg', '35158', '1', '1510641836', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('21', '/upfile/2017/11/1510641836227.jpg', '1510641836227.jpg', '.jpg', '35158', '1', '1510641838', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('22', '/upfile/2017/11/1510641837459.jpg', '1510641837459.jpg', '.jpg', '35720', '1', '1510641838', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('23', '/upfile/2017/11/1510641838427.jpg', '1510641838427.jpg', '.jpg', '33148', '1', '1510641840', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('24', '/upfile/2017/11/1510641839894.jpg', '1510641839894.jpg', '.jpg', '41653', '1', '1510641840', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('25', '/upfile/2017/11/1510641840110.jpg', '1510641840110.jpg', '.jpg', '21345', '1', '1510641842', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('26', '/upfile/2017/11/1510641841542.jpg', '1510641841542.jpg', '.jpg', '32703', '1', '1510641842', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('27', '/upfile/2017/11/1510641841796.jpg', '1510641841796.jpg', '.jpg', '34319', '1', '1510641842', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('28', '/upfile/2017/11/1510641842199.jpg', '1510641842199.jpg', '.jpg', '34825', '1', '1510641844', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('29', '/upfile/2017/11/1510641843699.jpg', '1510641843699.jpg', '.jpg', '31885', '1', '1510641844', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('30', '/upfile/2017/11/1510641844710.jpg', '1510641844710.jpg', '.jpg', '20417', '1', '1510641846', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('31', '/upfile/2017/11/1510641845494.jpg', '1510641845494.jpg', '.jpg', '33148', '1', '1510641846', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('32', '/upfile/2017/11/1510641846318.jpg', '1510641846318.jpg', '.jpg', '41653', '1', '1510641848', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('33', '/upfile/2017/11/1510641847389.jpg', '1510641847389.jpg', '.jpg', '34319', '1', '1510641848', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('34', '/upfile/2017/11/1510641847443.jpg', '1510641847443.jpg', '.jpg', '32703', '1', '1510641848', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('35', '/upfile/2017/11/1510641849916.jpg', '1510641849916.jpg', '.jpg', '32703', '1', '1510641850', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('36', '/upfile/2017/11/1510641850912.jpg', '1510641850912.jpg', '.jpg', '41653', '1', '1510641852', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('37', '/upfile/2017/11/1510641850984.jpg', '1510641850984.jpg', '.jpg', '35158', '1', '1510641852', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('38', '/upfile/2017/11/1510641851410.jpg', '1510641851410.jpg', '.jpg', '32703', '1', '1510641852', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('39', '/upfile/2017/11/1510641852134.jpg', '1510641852134.jpg', '.jpg', '34319', '1', '1510641854', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('40', '/upfile/2017/11/1510641853784.jpg', '1510641853784.jpg', '.jpg', '34319', '1', '1510641854', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('41', '/upfile/2017/11/1510641854958.jpg', '1510641854958.jpg', '.jpg', '35158', '1', '1510641856', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('42', '/upfile/2017/11/1510641855283.jpg', '1510641855283.jpg', '.jpg', '41653', '1', '1510641856', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('43', '/upfile/2017/11/1510641856152.jpg', '1510641856152.jpg', '.jpg', '32703', '1', '1510641858', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('44', '/upfile/2017/11/1510641856985.jpg', '1510641856985.jpg', '.jpg', '34319', '1', '1510641858', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('45', '/upfile/2017/11/1510641857341.jpg', '1510641857341.jpg', '.jpg', '31885', '1', '1510641858', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('46', '/upfile/2017/11/1510641859581.jpg', '1510641859581.jpg', '.jpg', '34825', '1', '1510641860', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('47', '/upfile/2017/11/1510641860150.jpg', '1510641860150.jpg', '.jpg', '41653', '1', '1510641862', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('48', '/upfile/2017/11/1510641860695.jpg', '1510641860695.jpg', '.jpg', '35158', '1', '1510641862', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('49', '/upfile/2017/11/1510641861170.jpg', '1510641861170.jpg', '.jpg', '32703', '1', '1510641862', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('50', '/upfile/2017/11/1510641862760.jpg', '1510641862760.jpg', '.jpg', '34825', '1', '1510641864', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('51', '/upfile/2017/11/1510641864640.jpg', '1510641864640.jpg', '.jpg', '31885', '1', '1510641866', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('52', '/upfile/2017/11/1510641865403.jpg', '1510641865403.jpg', '.jpg', '33148', '1', '1510641866', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('53', '/upfile/2017/11/1510641866180.jpg', '1510641866180.jpg', '.jpg', '41653', '1', '1510641868', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('54', '/upfile/2017/11/1510641866579.jpg', '1510641866579.jpg', '.jpg', '32703', '1', '1510641868', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('55', '/upfile/2017/11/1510641867914.jpg', '1510641867914.jpg', '.jpg', '34319', '1', '1510641868', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('56', '/upfile/2017/11/1510641868961.jpg', '1510641868961.jpg', '.jpg', '31885', '1', '1510641870', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('57', '/upfile/2017/11/1510641869456.jpg', '1510641869456.jpg', '.jpg', '32213', '1', '1510641870', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('58', '/upfile/2017/11/1510641870470.jpg', '1510641870470.jpg', '.jpg', '35720', '1', '1510641872', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('59', '/upfile/2017/11/1510641871530.jpg', '1510641871530.jpg', '.jpg', '33148', '1', '1510641872', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('60', '/upfile/2017/11/1510641872254.jpg', '1510641872254.jpg', '.jpg', '41653', '1', '1510641874', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('61', '/upfile/2017/11/1510641873391.jpg', '1510641873391.jpg', '.jpg', '34825', '1', '1510641874', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('62', '/upfile/2017/11/1510641873817.jpg', '1510641873817.jpg', '.jpg', '32703', '1', '1510641874', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('63', '/upfile/2017/11/1510641875829.jpg', '1510641875829.jpg', '.jpg', '33148', '1', '1510641876', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('64', '/upfile/2017/11/1510641875860.jpg', '1510641875860.jpg', '.jpg', '35720', '1', '1510641876', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('65', '/upfile/2017/11/1510641876423.jpg', '1510641876423.jpg', '.jpg', '41653', '1', '1510641878', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('66', '/upfile/2017/11/1510641877473.jpg', '1510641877473.jpg', '.jpg', '32703', '1', '1510641878', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('67', '/upfile/2017/11/1510641878561.jpg', '1510641878561.jpg', '.jpg', '34825', '1', '1510641880', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('68', '/upfile/2017/11/1510641879654.jpg', '1510641879654.jpg', '.jpg', '35291', '1', '1510641880', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('69', '/upfile/2017/11/1510641880814.jpg', '1510641880814.jpg', '.jpg', '41653', '1', '1510641882', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('70', '/upfile/2017/11/1510641881770.jpg', '1510641881770.jpg', '.jpg', '32703', '1', '1510641882', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('71', '/upfile/2017/11/1510641882517.jpg', '1510641882517.jpg', '.jpg', '34319', '1', '1510641884', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('72', '/upfile/2017/11/1510641882926.jpg', '1510641882926.jpg', '.jpg', '34825', '1', '1510641884', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('73', '/upfile/2017/11/1510641884838.jpg', '1510641884838.jpg', '.jpg', '21943', '1', '1510641886', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('74', '/upfile/2017/11/1510641885865.jpg', '1510641885865.jpg', '.jpg', '35720', '1', '1510641886', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('75', '/upfile/2017/11/1510641885914.jpg', '1510641885914.jpg', '.jpg', '49245', '1', '1510641886', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('76', '/upfile/2017/11/1510641886317.jpg', '1510641886317.jpg', '.jpg', '33148', '1', '1510641888', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('77', '/upfile/2017/11/1510641887262.jpg', '1510641887262.jpg', '.jpg', '41653', '1', '1510641888', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('78', '/upfile/2017/11/1510641888447.jpg', '1510641888447.jpg', '.jpg', '32213', '1', '1510641890', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('79', '/upfile/2017/11/1510641889313.jpg', '1510641889313.jpg', '.jpg', '35720', '1', '1510641890', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('80', '/upfile/2017/11/1510641890889.jpg', '1510641890889.jpg', '.jpg', '33148', '1', '1510641892', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('81', '/upfile/2017/11/1510641891151.jpg', '1510641891151.jpg', '.jpg', '41653', '1', '1510641892', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('82', '/upfile/2017/11/1510641891290.jpg', '1510641891290.jpg', '.jpg', '32703', '1', '1510641892', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('83', '/upfile/2017/11/1510641893535.jpg', '1510641893535.jpg', '.jpg', '30653', '1', '1510641894', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('84', '/upfile/2017/11/1510641894582.jpg', '1510641894582.jpg', '.jpg', '41653', '1', '1510641896', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('85', '/upfile/2017/11/1510641894960.jpg', '1510641894960.jpg', '.jpg', '33148', '1', '1510641896', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('86', '/upfile/2017/11/1510641895803.jpg', '1510641895803.jpg', '.jpg', '32703', '1', '1510641896', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('87', '/upfile/2017/11/1510641896151.jpg', '1510641896151.jpg', '.jpg', '34319', '1', '1510641898', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('88', '/upfile/2017/11/1510641897242.jpg', '1510641897242.jpg', '.jpg', '32115', '1', '1510641898', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('89', '/upfile/2017/11/1510641898678.jpg', '1510641898678.jpg', '.jpg', '32703', '1', '1510641900', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('90', '/upfile/2017/11/1510641899390.jpg', '1510641899390.jpg', '.jpg', '34319', '1', '1510641900', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('91', '/upfile/2017/11/1510641900852.jpg', '1510641900852.jpg', '.jpg', '34825', '1', '1510641902', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('92', '/upfile/2017/11/1510641900932.jpg', '1510641900932.jpg', '.jpg', '31885', '1', '1510641902', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('93', '/upfile/2017/11/1510641902402.jpg', '1510641902402.jpg', '.jpg', '34825', '1', '1510641904', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('94', '/upfile/2017/11/1510641903852.jpg', '1510641903852.jpg', '.jpg', '49245', '1', '1510641904', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('95', '/upfile/2017/11/1510641904195.jpg', '1510641904195.jpg', '.jpg', '34319', '1', '1510641906', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('96', '/upfile/2017/11/1510641904530.jpg', '1510641904530.jpg', '.jpg', '35720', '1', '1510641906', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('97', '/upfile/2017/11/1510641905855.jpg', '1510641905855.jpg', '.jpg', '34825', '1', '1510641906', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('98', '/upfile/2017/11/1510641906300.jpg', '1510641906300.jpg', '.jpg', '31885', '1', '1510641908', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('99', '/upfile/2017/11/1510796940948.gif', '1510796940948.gif', '.gif', '6403', '1', '1510796942', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('100', '/upfile/2017/11/1510796972158.jpg', '1510796972158.jpg', '.jpg', '188423', '1', '1510796974', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('101', '/upfile/2017/11/1510796972617.jpg', '1510796972617.jpg', '.jpg', '215264', '1', '1510796974', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('102', '/upfile/2017/11/1510796972734.jpg', '1510796972734.jpg', '.jpg', '218180', '1', '1510796974', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('103', '/upfile/2017/11/1511156457342.jpg', '1511156457342.jpg', '.jpg', '135244', '1', '1511156458', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('104', '/upfile/2017/11/1511156457416.jpg', '1511156457416.jpg', '.jpg', '193995', '1', '1511156458', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_attachment` VALUES ('105', '/upfile/2017/11/1511156457492.jpg', '1511156457492.jpg', '.jpg', '168325', '1', '1511156458', '1', '0', '0', '127.0.0.1', '0');
INSERT INTO `sd_auto_reply` VALUES ('1', 'subscribe', '0', '', '0');
INSERT INTO `sd_auto_reply` VALUES ('2', 'auto', '0', '', '0');
INSERT INTO `sd_badword` VALUES ('1', '');
INSERT INTO `sd_category` VALUES ('1', '关于我们', '0', '0', '-1', '', '20', '', '', '', '', '', '1', '0', '0', '', '0', 'About Us', '', '', '');
INSERT INTO `sd_category` VALUES ('2', '新闻中心', '0', '0', '1', '', '10', '', '', '', '', '', '1', '0', '0', '', '0', 'News', '', '', '');
INSERT INTO `sd_category` VALUES ('3', '产品展示', '0', '0', '2', '', '12', '', '', '', '', '', '1', '0', '1', '', '0', 'Product', '', '', '');
INSERT INTO `sd_category` VALUES ('4', '客户案例', '0', '0', '1', '', '20', 'content/news/list_pic.php', '', '', '', '', '1', '0', '0', '', '0', 'Case', '', '', '');
INSERT INTO `sd_category` VALUES ('5', '人才招聘', '0', '0', '3', '', '20', '', '', '', '', '', '1', '0', '0', '', '0', 'Job', '', '', '');
INSERT INTO `sd_category` VALUES ('6', '联系我们', '0', '0', '-1', '', '20', '', '', '', '', '', '1', '0', '0', '', '0', 'Contact Us', '', '', '');
INSERT INTO `sd_category` VALUES ('7', '公司简介', '1', '0', '-1', '', '20', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '');
INSERT INTO `sd_category` VALUES ('8', '企业文化', '1', '0', '-1', '', '20', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '');
INSERT INTO `sd_category` VALUES ('9', '荣誉资质', '1', '0', '-1', '', '20', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '');
INSERT INTO `sd_category` VALUES ('10', '公司动态', '2', '0', '1', '', '10', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '');
INSERT INTO `sd_category` VALUES ('11', '行业资讯', '2', '0', '1', '', '10', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '');
INSERT INTO `sd_category` VALUES ('12', '生活家电', '3', '0', '2', '', '12', '', '', '', '', '', '1', '0', '1', '', '0', '', '', '', '');
INSERT INTO `sd_category` VALUES ('13', '智能家电', '3', '0', '2', '', '12', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '');
INSERT INTO `sd_category` VALUES ('14', '配件产品', '3', '0', '2', '', '12', '', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '');
INSERT INTO `sd_category` VALUES ('15', '电水壶', '12', '0', '2', '', '12', '', '', '', '', '', '1', '0', '1', '', '0', '', '', '', '');
INSERT INTO `sd_category` VALUES ('16', '挂烫机', '12', '0', '2', '', '12', '', '', '', '', '', '1', '0', '1', '', '0', '', '', '', '');
INSERT INTO `sd_category` VALUES ('17', '吸尘器', '12', '0', '2', '', '12', '', '', '', '', '', '1', '0', '1', '', '0', '', '', '', '');
INSERT INTO `sd_category` VALUES ('18', '城市规划', '4', '0', '1', '', '20', 'content/news/list_pic.php', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '');
INSERT INTO `sd_category` VALUES ('19', '居住建筑', '4', '0', '1', '', '20', 'content/news/list_pic.php', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '');
INSERT INTO `sd_category` VALUES ('20', '公共建筑', '4', '0', '1', '', '20', 'content/news/list_pic.php', '', '', '', '', '1', '0', '0', '', '0', '', '', '', '');
INSERT INTO `sd_category_field` VALUES ('1', '英文名称', 'mycateename', '1', '0', '0', '', '', 'varchar(255) NOT NULL', '', '0', '1', '0', '0', '1');
INSERT INTO `sd_category_field` VALUES ('2', '栏目图片', 'mycatepic', '5', '0', '1', '', '', 'varchar(255) NOT NULL', '', '0', '1', '0', '0', '1');
INSERT INTO `sd_category_field` VALUES ('3', '英文名称', 'myename', '1', '0', '0', '', '', '', '建议一级栏目填写', '0', '0', '0', '0', '1');
INSERT INTO `sd_config` VALUES ('1', '1', 'web_line', '网站设置', '', '1', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('2', '1', 'web_open', '网站开关', '1', '3', '6', '网站开启|1,网站关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('3', '1', 'web_close', '关闭原因', '临时维护', '5', '5', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('4', '1', 'web_name', '网站名称', 'SDCMS三合一企业网站管理系统', '7', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('5', '1', 'web_logo', '网站Logo', '/upfile/2017/11/1510796940948.gif', '9', '4', '', '', '1', '1', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('6', '1', 'web_icp', 'ICP备案号', '', '13', '1', '', '', '1', '1', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('7', '1', 'seo_line', '优化设置', '', '23', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('8', '1', 'seo_title', '优化标题', '', '25', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('9', '1', 'seo_key', '网站关键字', '', '27', '5', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('10', '1', 'seo_desc', '网站描述', '', '29', '5', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('11', '2', 'url_mode', 'Url模式', '1', '0', '6', '普通模式（例: /?m=home&amp;c=index&amp;a=index）|1,PathInfo模式（例: /index.php/home/index/index.html）|2,伪静态模式（例: /home/index/index.html）|3', '', '2', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('12', '2', 'url_mid', 'Url间隔符', '/', '0', '8', '/|/,-|-,_|_', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('13', '2', 'url_ext', 'Url后缀', '.html', '0', '8', '无后缀|,.html|.html', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('14', '3', 'mail_type', '发送方式', '0', '0', '6', '关闭发邮件|0,通过PHP的Mail函数发送|1,通过SOCKET连接SMTP服务器发送(支持SMTP验证) |2,通过PHP函数SMTP发送(仅Windows主机下有效不支持SMTP验证)|3', '', '2', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('15', '3', 'mail_name', '发件人姓名', 'IT平民', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('16', '3', 'mail_sign', '邮件签名', '测试签名', '0', '5', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('17', '3', 'mail_spilt', '邮件头分隔符', '1', '0', '6', '使用CRLF作为分隔符(通常为Windows主机)|1,使用LF作为分隔符(通常为Unix/Linux主机)|2,使用CR作为分隔符(通常为Mac主机)|3', '', '2', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('18', '3', 'mail_smtp', 'SMTP服务器', '', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('19', '3', 'mail_user', '用户名', '', '0', '1', '', '填写邮箱全称，如：test@qq.com', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('20', '3', 'mail_pass', '密码/授权码', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('21', '3', 'mail_auth', '验证', '1', '0', '6', '是|1,否|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('22', '3', 'mail_port', '端口', '25', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('23', '4', 'upload_line', '上传设置', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('24', '4', 'upload_image_max', '图像最大上传', '5', '0', '1', '', '单位：M', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('25', '4', 'upload_video_max', '视频最大上传', '40', '0', '1', '', '单位：M', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('26', '4', 'upload_file_max', '附件最大上传', '2000', '0', '1', '', '单位：M', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('27', '4', 'upload_file_folder', '储存方式', '2', '0', '6', '按 年 目录，如：2016/14731414801.jpg|1,按 年/月 目录，如：2016/10/14731414801.jpg|2,按 年/月/日 目录，如：2016/10/21/14731414801.jpg|3', '', '2', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('28', '4', 'thumb_line', '压缩设置', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('29', '4', 'thumb_open', '等比压缩', '0', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('30', '4', 'thumb_min', '压缩宽度', '1000', '0', '1', '', '图片会被压缩成这个宽度', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('31', '4', 'water_line', '水印设置', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('32', '4', 'water_open', '水印开关', '0', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('33', '4', 'water_width', '最小宽度', '400', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('34', '4', 'water_height', '最小高度', '100', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('35', '4', 'water_opacity', '透明度', '60', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('36', '4', 'water_position', '水印位置', '5', '0', '8', '随机显示|0,顶部居左|1,顶部居中|2,顶部居右|3,中部居左|4,中部居中|5,中部居右|6,底部居左|7,底部居中|8,底部居右|9', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('37', '4', 'water_logo', '水印Logo', '', '0', '4', '', '', '1', '1', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('38', '5', 'mobile_open', '开关', '0', '1', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('39', '5', 'mobile_domain', '绑定域名', '', '5', '1', '', '例：m.baidu.com', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('40', '6', 'weixin_appid', 'AppID(应用ID)', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('41', '6', 'weixin_appsecret', 'AppSecret(应用密钥)', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('42', '6', 'weixin_token', 'Token(令牌)', '', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('43', '6', 'weixin_id', '公众号的微信号', '', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('44', '6', 'weixin_qrcode', '公众号二维码', '', '0', '4', '', '', '1', '1', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('45', '7', 'link_logo', 'LOGO链接', '1', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('46', '7', 'link_class', '分类开关', '0', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('47', '7', 'link_class_data', '链接分类', '首页链接|1\r\n合作伙伴|2', '0', '5', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('48', '8', 'ct_company', '公司名称', '成都某某网络科技有限公司', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('49', '8', 'ct_tel', '服务热线', '400-1234-5678', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('50', '8', 'ct_fax', '传真号码', '', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('51', '8', 'ct_mobile', '手机号码', '', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('52', '8', 'ct_email', '电子邮箱', '', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('53', '8', 'ct_address', '公司地址', '', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('54', '5', 'mobile_auto', '自动识别', '0', '7', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('55', '5', 'mobile_logo', '手机站LOGO', '/upfile/mobile.png', '9', '4', '', '', '1', '1', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('56', '3', 'mail_admin', '管理员邮箱', '', '0', '1', '', '不能和上面的用户名相同', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('57', '2', 'url_line', '路由映射', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('58', '2', 'url_list', '模型列表页', 'list', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('59', '2', 'url_show', '模型内容页', 'show', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('60', '9', 'admin_code', '后台登录验证码', '1', '2', '6', '图形验证码|1,谷歌验证码|3,关闭|2', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('61', '9', 'admin_logintimes', '登录尝试次数', '5', '4', '1', '', '超过次数后禁止登录', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('62', '9', 'admin_log', '自动清理日志时间', '60', '5', '1', '', '单位为天，超过多少天的自动清理', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('63', '1', 'count_line', '流量统计', '', '31', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('64', '1', 'count_code', '统计代码', '', '33', '5', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('65', '1', 'home_line', '其他设置', '', '35', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('66', '1', 'home_video', '首页视频', '', '11', '4', '', '请上传mp4格式视频，大小建议5M以内', '1', '3', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('67', '10', 'pay_open', '接口状态', '0', '1', '6', '开启|1,关闭|0', '关闭后以下设置无效，在线支付接口均需要企业（含个体工商户）身份才能申请到', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('68', '10', 'pay_alipay_line', '支付宝接口（含电脑网站支付和手机网站支付）', '', '3', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('69', '10', 'pay_alipay_open', '是否开启', '0', '5', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('70', '10', 'pay_alipay_appid', 'AppID', '', '7', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('73', '10', 'pay_alipay_biz', '接口授权码', '', '11', '5', '', '支付宝支付接口授权码通过官网购买，未授权时接只能支付0.01元', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('74', '10', 'pay_wxpay_line', '微信支付接口（含扫码支付、公众号支付和微信H5支付）', '', '13', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('75', '10', 'pay_wxpay_open', '是否开启', '0', '15', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('76', '10', 'pay_wxpay_appid', '商户号', '', '17', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('77', '10', 'pay_wxpay_key', '密钥', '', '19', '5', '', '长度为32位，必须包含：大小写字母和数字', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('78', '10', 'pay_wxpay_biz', '接口授权码', '', '21', '5', '', '微信支付接口授权码通过官网购买，未授权时接只能支付0.01元', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('79', '1', 'web_domain', '站点主域名', '', '19', '1', '', '例：www.baidu.com，使用栏目绑定域名时，必须配置主域名', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('80', '1', 'content_subid', '内容副栏目', '0', '37', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('81', '11', 'file_way', '存储方式', 'local', '0', '8', '本地存储|local,阿里云Oss|oss,七牛云|qiniu', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('82', '11', 'file_oss_line', '阿里云OSS', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('83', '11', 'file_oss_appid', 'Access Key ID', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('84', '11', 'file_oss_appkey', 'Access Key Secret', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('85', '11', 'file_oss_bucket', 'Bucket', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('86', '11', 'file_oss_domain', '用户域名', '', '0', '1', '', '例：http://file.baidu.com', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('87', '11', 'file_oss_url', 'OSS 域名', '', '0', '1', '', '例：http://test.oss-cn-hangzhou.aliyuncs.com', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('88', '11', 'file_qiniu_line', '七牛云存储', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('89', '11', 'file_qiniu_appid', 'AccessKey', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('90', '11', 'file_qiniu_appkey', 'Secret Key', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('91', '11', 'file_qiniu_bucket', 'Bucket', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('92', '11', 'file_qiniu_domain', '用户域名', '', '0', '1', '', '可以使用绑定的域名，也可以使用测试域名，例：http://file.baidu.com', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('93', '11', 'file_qiniu_url', '上传地址', '', '0', '1', '', '例：http://upload.qiniu.com', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('94', '12', 'user_open', '开放注册', '1', '0', '6', '开放注册|1,关闭注册|2', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('95', '12', 'user_reg_type', '注册审核', '1', '0', '6', '直接通过|1,邮箱验证|2,管理员审核|3', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('96', '12', 'user_badname', '禁止注册的用户名', 'sdcms|admin|ceo|cto|boss|fuck|cao', '0', '5', '', '多个请用“|”间隔', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('97', '12', 'user_reg_group', '加入用户组', '1', '0', '8', '默认用户组|0', '注册后默认加入哪个会员组', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('98', '12', 'user_reg_auth', '注册验证码', '1', '0', '6', '开启|1,关闭|2', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('99', '12', 'user_login_auth', '登录验证码', '1', '0', '6', '开启|1,关闭|2', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('100', '12', 'user_getpass_auth', '忘记密码验证码', '1', '0', '6', '开启|1,关闭|2', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('101', '13', 'api_qq_line', 'QQ登录接口', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('102', '13', 'api_qq_open', '接口状态', '0', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('103', '13', 'api_qq_appid', 'AppId', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('104', '13', 'api_qq_key', 'AppKey', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('105', '13', 'api_weibo_line', '微博登录接口', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('106', '13', 'api_weibo_open', '接口状态', '0', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('107', '13', 'api_weibo_appid', 'App Key', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('108', '13', 'api_weibo_key', 'App Secret', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('109', '14', 'bbs_open', '社区开关', '1', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('110', '14', 'bbs_close', '关闭原因', '社区维护中', '0', '5', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('111', '14', 'bbs_webname', '社区名称', '社区名称', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('112', '14', 'bbs_seotitle', '优化标题', '', '0', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('113', '14', 'bbs_seokey', '关键字', '', '0', '5', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('114', '14', 'bbs_seodesc', '描述', '', '0', '5', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('115', '14', 'bbs_newpost', '发帖时间间隔', '5', '0', '1', '单位：分钟', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('116', '14', 'bbs_replypost', '回帖时间间隔', '1', '0', '1', '单位：分钟', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('117', '14', 'bbs_post_lock', '发帖需要审核', '1', '0', '6', '不需要审核|1,需要审核|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('118', '6', 'web_share_pic', '微信分享图片', '', '0', '4', '', '微信分享默认图片，建议尺寸：100*100', '1', '1', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('119', '1', 'web_order_login', '下单设置', '1', '39', '6', '会员才能下单|1,任何人都可下单|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('120', '4', 'water_piclist', '组图水印', '0', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('121', '13', 'api_weixin_line', '微信扫码登录接口（Pc网站使用，需要申请开发者认证）', '0', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('122', '13', 'api_weixin_open', '接口状态', '0', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('123', '13', 'api_weixin_appid', 'AppID', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('124', '13', 'api_weixin_appkey', 'AppSecret', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('125', '13', 'api_wx_line', ' 微信公众号登录接口（在微信公众号内访问使用，需要公众号通过认证）', '0', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('126', '13', 'api_wx_open', '接口状态', '0', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('127', '15', 'city_domain', '分站根域名', '', '5', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('128', '15', 'city_class', '栏目加城市名', '0', '7', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('129', '15', 'city_content', '内容加城市名', '0', '9', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('130', '2', 'url_cate_ext', '栏目及别名后缀', '.html', '0', '8', '无后缀|,/|/,.html|.html', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('131', '4', 'thumb_auto', '自动缩略图', '1', '0', '6', '开启|1,关闭|0', '开启后前台自动生成图片缩略图', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('132', '6', 'weixin_cache', '微信数据缓存', '1', '0', '6', '开启|1,关闭|0', '多个网站同时使用同一个公众号时，请关闭。', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('133', '14', 'bbs_post_code', '发帖验证码', '1', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('134', '14', 'bbs_reply_code', '回帖验证码', '0', '0', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('135', '16', 'open_line', '公共设置', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('136', '16', 'open_appkey', '接口密钥', 'sdcms', '0', '1', '', '小程序接口通信密钥，不可为空', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('137', '16', 'open_debug', '调试开关', '0', '0', '6', '开启|1,关闭|0', '本地调试时，请开启', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('138', '16', 'open_bizcode', '小程序授权码', '', '0', '5', '', '在正式域名下使用小程序，需要经过授权', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('139', '16', 'open_weixin_line', '微信小程序', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('140', '16', 'open_weixin_appid', 'AppID', '', '0', '1', '', '小程序ID', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('141', '16', 'open_weixin_appsecret', 'AppSecret', '', '0', '1', '', '小程序密钥', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('142', '16', 'open_baidu_line', '百度小程序', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('143', '16', 'open_baidu_appid', 'App ID', '', '0', '1', '', '智能小程序ID', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('144', '16', 'open_baidu_appkey', 'App Key', '', '0', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('145', '16', 'open_baidu_appsecret', 'App Secret', '', '0', '1', '', '智能小程序密匙', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('146', '10', 'pay_baidu_line', '百度收银台（小程序使用）', '', '23', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('147', '10', 'pay_baidu_open', '是否开启', '0', '25', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('148', '10', 'pay_baidu_dealid', 'dealId', '', '27', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('149', '10', 'pay_baidu_appkey', 'APP KEY', '', '29', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('150', '10', 'pay_baidu_public_key', '平台公钥', '', '31', '5', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('151', '10', 'pay_baidu_private_key', '开发者私钥', '', '33', '5', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('152', '10', 'pay_baidu_biz', '接口授权码', '', '35', '5', '', '百度收银台接口授权码通过官网购买，未授权时接只能支付0.01元', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('153', '15', 'city_class_mid', '栏目连接符', '', '11', '1', '', '分站栏目在城市名称后的连接字符', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('154', '15', 'city_content_mid', '内容连接符', '', '13', '1', '', '分站内容在城市名称后的连接字符', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('155', '1', 'web_domain_line', '域名相关', '', '15', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('156', '1', 'web_http', 'Http类型', 'http://', '17', '6', 'Http://|http://,Https://|https://', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('157', '1', 'web_domains', '副域名', '', '21', '5', '', '一行一条，格式：www.baidu.com 或 baidu.com，副域名会自动跳转到主域名', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('158', '5', 'mobile_http', 'Http类型', 'http://', '3', '6', 'Http://|http://,Https://|https://', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('159', '13', 'api_wx_autologin', '免注册绑定', '0', '0', '6', '开启|1,关闭|0', '微信公众号内访问登录免注册', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('160', '1', 'category_http', '栏目Http类型', 'http://', '21', '6', 'Http://|http://,Https://|https://', '当栏目使用域名绑定功能时使用', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('161', '15', 'city_open', '分站开关', '1', '1', '6', '开启|1,关闭|0', '关闭后前台不显示', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('162', '15', 'city_http', '分站Http类型', 'http://', '3', '6', 'Http://|http://,Https://|https://', '当分站绑定域名时使用', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('163', '16', 'open_douyin_line', '抖音小程序', '', '0', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('164', '16', 'open_douyin_appid', 'AppID', '', '0', '1', '', '小程序AppID', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('165', '16', 'open_douyin_appsecret', 'AppSecret', '', '0', '1', '', '小程序AppSecret', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('166', '10', 'pay_douyin_line', '抖音支付接口（小程序使用，担保接口）', '', '37', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('167', '10', 'pay_douyin_open', '是否开启', '0', '39', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('169', '10', 'pay_douyin_token', 'Token(令牌)', '', '41', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('170', '10', 'pay_douyin_salt', 'SALT', '', '43', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('171', '6', 'weixin_share_open', '分享开关', '1', '0', '6', '开启|1,关闭|0', '微信内访问分享开关', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('172', '12', 'user_default_face', '默认头像', '/upfile/noface.gif', '0', '4', '', '会员默认头像', '1', '1', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('173', '9', 'admin_code_google', '谷歌密钥', '', '3', '1', '', '如果使用：谷歌验证码，请点击【生成】按钮生成密钥，然后通过【身份验证器】APP，扫描二维码', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('174', '9', 'admin_logo', '后台Logo', '/public/admin/images/logo.png', '1', '4', '', '建议尺寸：200*40', '1', '1', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('175', '10', 'pay_alipay_public', '支付宝公钥', '', '7', '5', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('177', '1', 'beian_line', '公安备案号', '', '13', '9', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('176', '10', 'pay_alipay_private', '商户私钥', '', '7', '5', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('178', '1', 'beian_num', '备案号', '', '13', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('179', '1', 'beian_url', '备案链接', '', '13', '1', '', '', '1', '0', '1', '1', '0');
INSERT INTO `sd_config` VALUES ('180', '10', 'pay_free_line', '免签支付接口（需提现，申请网址：https://www.nicemb.com）', '', '22', '9', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('181', '10', 'pay_free_open', '接口开关', '0', '22', '6', '开启|1,关闭|0', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('182', '10', 'pay_free_id', 'AppId', '', '22', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config` VALUES ('183', '10', 'pay_free_key', 'AppKey', '', '22', '1', '', '', '1', '0', '1', '1', '1');
INSERT INTO `sd_config_group` VALUES ('1', '基本设置', '0', '0', '1', '1');
INSERT INTO `sd_config_group` VALUES ('2', '运行模式', '0', '0', '1', '1');
INSERT INTO `sd_config_group` VALUES ('3', '邮件设置', '0', '0', '1', '1');
INSERT INTO `sd_config_group` VALUES ('4', '附件设置', '0', '0', '1', '1');
INSERT INTO `sd_config_group` VALUES ('5', '手机站', '0', '0', '1', '1');
INSERT INTO `sd_config_group` VALUES ('6', '微信设置', '0', '0', '1', '2');
INSERT INTO `sd_config_group` VALUES ('7', '友情链接', '0', 'link', '1', '0');
INSERT INTO `sd_config_group` VALUES ('8', '联系方式', '0', '0', '1', '1');
INSERT INTO `sd_config_group` VALUES ('9', '后台相关', '0', '0', '1', '1');
INSERT INTO `sd_config_group` VALUES ('10', '支付接口', '0', '0', '1', '2');
INSERT INTO `sd_config_group` VALUES ('11', '云存储', '0', '0', '1', '2');
INSERT INTO `sd_config_group` VALUES ('12', '会员设置', '0', 'user', '1', '0');
INSERT INTO `sd_config_group` VALUES ('13', '快捷登录', '0', '0', '1', '2');
INSERT INTO `sd_config_group` VALUES ('14', '社区设置', '0', 'bbs', '1', '0');
INSERT INTO `sd_config_group` VALUES ('15', '城市分站', '0', 'city', '1', '0');
INSERT INTO `sd_config_group` VALUES ('16', '小程序接口', '0', '0', '1', '2');
INSERT INTO `sd_content` VALUES ('1', '如何选购和使用覆面机', '/upfile/2017/11/1510641452333.jpg', '1', '10', '2', '1', '0', '0', '0', '0', '0', '0', '', '1510588800', '1597645674', '覆面机又被称为贴面机或裱纸机，用于对预印彩色印刷面纸与瓦楞纸板的裱贴粘合，它是预印纸箱生产的重要配套设备，对瓦楞纸板加工生产效率和质量具有一定的影响作用。随着社会经济的不断发展，预印纸箱的应用越来越广泛，覆面机的结构也越趋向多样化和自动化，制造技术、性能也越趋成熟和先进。由于覆面机的结构和性能不同，瓦楞纸板和面纸的裱贴粘合的效果也', '', '', '', '', '', '', 'a:0:{}', null, '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('2', '塑料包装印刷企业对凹印油墨的特殊要求', '/upfile/2017/11/1510641455868.jpg', '1', '10', '2', '1', '1', '0', '0', '1', '0', '0', '', '1510588800', '1597641835', '油墨的耐抗性即印品墨膜对严酷条件的耐受能力，包括耐光性、耐热性、耐油脂性、耐化学性等。如需要煮沸杀菌包装的印刷油墨和颜料坯需要具有耐煮沸性。\r\n\r\n	\r\n\r\n	经济性包装印刷厂在印刷生产中，追求的是低投入、高回报，即按照适度包装的原则，在满足以上条件的前提下，选择总体成本(采购成本加使用成本等)较低的油墨。包装印刷厂虽然选择了合适的油墨，但在油墨', '', '', '', '', '', '', 'a:0:{}', null, '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('3', '浅析印刷包装企业对CTP系统的需求', '/upfile/2017/11/1510641456574.jpg', '1', '10', '0', '1', '0', '0', '0', '1', '0', '0', '', '1510588800', '1597645646', '一个适合的CTP系统需从包装印刷的特点出发，解决困扰包装印刷企业的一系列头疼问题，才能满足包装印刷企业的需求，使其从CTP技术中受益。CTP技术进入包装印刷企业，需要解决好如下问题：\r\n\r\n	\r\n\r\n	1. 包装印刷在生产中关注专色再现，色彩一致性。\r\n\r\n	相比色彩的层次再现及中性灰控制，包装印刷企业更注重专色再现和色彩一致性问题。这需要CTP系统具备色彩管理的工艺控', '', '', '', '', '', '', 'a:0:{}', null, '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('4', '电子行业中包装机的地位', '/upfile/2017/11/1510641459659.jpg', '1', '11', '0', '1', '0', '0', '0', '0', '0', '0', '', '1510588800', '1597645501', '电子行业的发展需要包装机械的辅助。包装机械的发展则需要电子行业的支持!电子行业是一个先进的高科技产业，其重要性可以衡量一个国家的科学技术水平如何。而包装机械行业在电子行业却表示相当抢手。包装机械在电子行业的应用也非常广泛。东莞旭田包装机械是国内知名的老牌包装机械厂家，国内有着很高的知名度。多年来旭田包装机械一直坚持走自主创新的道路，', '', '', '', '', '', '', 'a:0:{}', null, '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('5', '国内包装机行业发展现状', '/upfile/2017/11/1510641461345.jpg', '1', '11', '0', '1', '0', '0', '0', '0', '0', '0', '', '1510588800', '1597645580', '甚至于大件的家居用品都需要包装，无论是食品还是生活用品。包装已成为潮流，而包装机械行业也随之蓬勃发展。特别对于食品行业，各式各样的包装设备屡见不鲜，从印刷包装到微机组合秤再到废品打包出卖，每一个环节的创新都为食品包装行业带来新的变化。随着国际社会对食品包装行业的要求不时提高，竞争也随之激烈，国内外包装机械市场繁荣的面前正演绎着一场', '', '', '', '', '', '', 'a:0:{}', null, '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('6', '环保包装持续发展的重点环保油墨', '/upfile/2017/11/1510641463996.jpg', '1', '11', '1', '1', '0', '0', '0', '0', '0', '0', '', '1510588800', '1597645455', '无论是水性油墨、可降解油墨还是UV固化油墨，环保油墨性能的改进给印刷和包装行业注入了新的活力。这些环境友好型产品都将为印刷包装行业的可继续发展作出贡献。环保油墨市场增长 随着包装行业不时努力降低自己的环境影响力，环保油墨和印刷技术的使用也在不时增加。各国政府纷纷通过法律法规的形式对油墨的成分做出了限制，例如欧盟出台了针对包装可堆肥性标', '', '', '', '', '', '', 'a:0:{}', null, '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('7', '二号产品展示', '/upfile/2017/11/1510641832353.jpg', '1', '14', '0', '1', '0', '0', '0', '0', '0', '0', '', '1510588800', '1510898815', 'EPE珍珠棉袋是非交联闭孔结构 , 是一种新型环保的包装材料。它由低密度聚乙烯脂经物理发泡产生无数的独立气泡构成。克服了普通发泡胶易碎、变形、回复性差的缺点。具有隔水防潮、防震、隔音、保温、可塑性能佳、韧性强、循环再造、环保、抗撞力强等诸多优点，亦具有很好的抗化学性能。是传统包装材料的理想替代品。\r\n\r\n	\r\n\r\n	EPE珍珠棉袋广泛应用于电子电器、仪器仪', '产品', '', '', '', '', '', 'a:0:{}', '', '0', '', '0', '[{\"name\":\"产品\",\"id\":\"1\"}]', '0');
INSERT INTO `sd_content` VALUES ('8', '一号产品展示', '/upfile/2017/11/1510641835376.jpg', '1', '14', '0', '1', '0', '0', '0', '0', '0', '0', '', '1510588800', '1510898809', 'EPE珍珠棉袋是非交联闭孔结构 , 是一种新型环保的包装材料。它由低密度聚乙烯脂经物理发泡产生无数的独立气泡构成。克服了普通发泡胶易碎、变形、回复性差的缺点。具有隔水防潮、防震、隔音、保温、可塑性能佳、韧性强、循环再造、环保、抗撞力强等诸多优点，亦具有很好的抗化学性能。是传统包装材料的理想替代品。\r\n\r\n	\r\n\r\n	EPE珍珠棉袋广泛应用于电子电器、仪器仪', '产品', '', '', '', '', '', 'a:0:{}', '', '0', '', '0', '[{\"name\":\"产品\",\"id\":\"1\"}]', '0');
INSERT INTO `sd_content` VALUES ('9', '四号产品展示 ', '/upfile/2017/11/1510641840110.jpg', '1', '15', '1', '1', '0', '0', '0', '0', '0', '0', '', '1510588800', '1510641843', '易洁包装提供的透明PE骨袋的材质为NY（PA）/CPE或PET/NY（PA）/CPE。此产品具有防静电功能、抽真空效果佳、透明度高、透(氧)气率低、防潮性能好、抗拉强度与耐穿刺强度高、易热封、密封性好、不易老化等特点。\r\n\r\n	\r\n\r\n	透明PE骨袋主要用于五金、电子元器件、有需要抽真空要求的包装等。尺寸、规格、耐高温性等都可按要求定做。PE骨袋还可根据客户要求，在不侵犯他人知识产', '', '', '', '', '', '', 'a:0:{}', null, '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('10', '三号产品展示', '/upfile/2017/11/1510641844710.jpg', '1', '14', '0', '1', '0', '0', '0', '0', '0', '0', '', '1510588800', '1510898801', '易洁包装提供的透明PE骨袋的材质为NY（PA）/CPE或PET/NY（PA）/CPE。此产品具有防静电功能、抽真空效果佳、透明度高、透(氧)气率低、防潮性能好、抗拉强度与耐穿刺强度高、易热封、密封性好、不易老化等特点。\r\n\r\n	\r\n\r\n	透明PE骨袋主要用于五金、电子元器件、有需要抽真空要求的包装等。尺寸、规格、耐高温性等都可按要求定做。PE骨袋还可根据客户要求，在不侵犯他人知识产', '产品', '', '', '', '', '', 'a:0:{}', '', '0', '', '0', '[{\"name\":\"产品\",\"id\":\"1\"}]', '0');
INSERT INTO `sd_content` VALUES ('11', '五号产品展示 ', '/upfile/2017/11/1510641849916.jpg', '1', '15', '0', '1', '0', '0', '0', '0', '0', '0', '', '1510588800', '1510641852', '易洁包装提供的透明PE骨袋的材质为NY（PA）/CPE或PET/NY（PA）/CPE。此产品具有防静电功能、抽真空效果佳、透明度高、透(氧)气率低、防潮性能好、抗拉强度与耐穿刺强度高、易热封、密封性好、不易老化等特点。\r\n\r\n	\r\n\r\n	透明PE骨袋主要用于五金、电子元器件、有需要抽真空要求的包装等。尺寸、规格、耐高温性等都可按要求定做。PE骨袋还可根据客户要求，在不侵犯他人知识产', '', '', '', '', '', '', 'a:0:{}', null, '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('12', '六号产品展示 ', '/upfile/2017/11/1510641853784.jpg', '1', '15', '0', '1', '0', '0', '0', '0', '0', '0', '', '1510588800', '1510641857', '易洁包装提供的透明PE骨袋的材质为NY（PA）/CPE或PET/NY（PA）/CPE。此产品具有防静电功能、抽真空效果佳、透明度高、透(氧)气率低、防潮性能好、抗拉强度与耐穿刺强度高、易热封、密封性好、不易老化等特点。\r\n\r\n	\r\n\r\n	透明PE骨袋主要用于五金、电子元器件、有需要抽真空要求的包装等。尺寸、规格、耐高温性等都可按要求定做。PE骨袋还可根据客户要求，在不侵犯他人知识产', '', '', '', '', '', '', 'a:0:{}', null, '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('13', '七号产品展示 ', '/upfile/2017/11/1510641859581.jpg', '1', '15', '0', '1', '0', '0', '0', '0', '0', '0', '', '1510588800', '1510641862', '易洁包装提供的透明PE骨袋的材质为NY（PA）/CPE或PET/NY（PA）/CPE。此产品具有防静电功能、抽真空效果佳、透明度高、透(氧)气率低、防潮性能好、抗拉强度与耐穿刺强度高、易热封、密封性好、不易老化等特点。\r\n\r\n	\r\n\r\n	透明PE骨袋主要用于五金、电子元器件、有需要抽真空要求的包装等。尺寸、规格、耐高温性等都可按要求定做。PE骨袋还可根据客户要求，在不侵犯他人知识产', '', '', '', '', '', '', 'a:0:{}', null, '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('14', '八号产品展示 ', '/upfile/2017/11/1510641864640.jpg', '1', '15', '1', '1', '0', '0', '0', '0', '0', '0', '', '1510588800', '1510641868', '易洁包装提供的透明PE骨袋的材质为NY（PA）/CPE或PET/NY（PA）/CPE。此产品具有防静电功能、抽真空效果佳、透明度高、透(氧)气率低、防潮性能好、抗拉强度与耐穿刺强度高、易热封、密封性好、不易老化等特点。\r\n\r\n	\r\n\r\n	透明PE骨袋主要用于五金、电子元器件、有需要抽真空要求的包装等。尺寸、规格、耐高温性等都可按要求定做。PE骨袋还可根据客户要求，在不侵犯他人知识产', '', '', '', '', '', '', 'a:0:{}', null, '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('15', '十号产品展示 ', '/upfile/2017/11/1510641869456.jpg', '1', '15', '0', '1', '0', '1', '0', '0', '0', '0', '', '1510588800', '1510641873', '纯铝立体袋材质结构PET/AL/CPE或PET/AL/NY(PA)/CPE（聚酯/铝膜/聚乙烯流延薄膜或聚酯/铝膜/尼龙膜/聚乙烯流延薄膜）两种三或四层结构，具有良好的防水，阻氧，避光的功能。整体颜色为铝箔颜色不透光。\r\n\r\n	\r\n\r\n	纯铝立体袋可做成多种款式：平口袋式、自封式（密实袋/拉链袋）、信封式、信封自粘式、连体式、立体式等，袋身图案可根据客户要求印刷；内外表面电阻值：108&mdash;101', '', '', '', '', '', '', 'a:0:{}', null, '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('16', '九号产品展示 ', '/upfile/2017/11/1510641875829.jpg', '1', '15', '2', '1', '0', '1', '0', '0', '0', '0', '', '1510588800', '1510641878', '纯铝立体袋材质结构PET/AL/CPE或PET/AL/NY(PA)/CPE（聚酯/铝膜/聚乙烯流延薄膜或聚酯/铝膜/尼龙膜/聚乙烯流延薄膜）两种三或四层结构，具有良好的防水，阻氧，避光的功能。整体颜色为铝箔颜色不透光。\r\n\r\n	\r\n\r\n	纯铝立体袋可做成多种款式：平口袋式、自封式（密实袋/拉链袋）、信封式、信封自粘式、连体式、立体式等，袋身图案可根据客户要求印刷；内外表面电阻值：108&mdash;101', '', '', '', '', '', '', 'a:0:{}', null, '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('17', '十一号产品展示 ', '/upfile/2017/11/1510641879654.jpg', '1', '13', '0', '1', '0', '1', '0', '0', '0', '0', '', '1510588800', '1510641882', '纯铝立体袋材质结构PET/AL/CPE或PET/AL/NY(PA)/CPE（聚酯/铝膜/聚乙烯流延薄膜或聚酯/铝膜/尼龙膜/聚乙烯流延薄膜）两种三或四层结构，具有良好的防水，阻氧，避光的功能。整体颜色为铝箔颜色不透光。\r\n\r\n	\r\n\r\n	纯铝立体袋可做成多种款式：平口袋式、自封式（密实袋/拉链袋）、信封式、信封自粘式、连体式、立体式等，袋身图案可根据客户要求印刷；内外表面电阻值：108&mdash;101', '', '', '', '', '', '', 'a:0:{}', null, '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('18', '十二号产品展示 ', '/upfile/2017/11/1510641884838.jpg', '1', '13', '0', '1', '0', '1', '0', '0', '0', '0', '', '1510588800', '1510641887', '纯铝立体袋材质结构PET/AL/CPE或PET/AL/NY(PA)/CPE（聚酯/铝膜/聚乙烯流延薄膜或聚酯/铝膜/尼龙膜/聚乙烯流延薄膜）两种三或四层结构，具有良好的防水，阻氧，避光的功能。整体颜色为铝箔颜色不透光。\r\n\r\n	\r\n\r\n	纯铝立体袋可做成多种款式：平口袋式、自封式（密实袋/拉链袋）、信封式、信封自粘式、连体式、立体式等，袋身图案可根据客户要求印刷；内外表面电阻值：108&mdash;101', '', '', '', '', '', '', 'a:0:{}', null, '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('19', '十三号产品展示 ', '/upfile/2017/11/1510641888447.jpg', '1', '13', '2', '1', '0', '1', '0', '0', '0', '0', '', '1510588800', '1510641891', '纯铝立体袋材质结构PET/AL/CPE或PET/AL/NY(PA)/CPE（聚酯/铝膜/聚乙烯流延薄膜或聚酯/铝膜/尼龙膜/聚乙烯流延薄膜）两种三或四层结构，具有良好的防水，阻氧，避光的功能。整体颜色为铝箔颜色不透光。\r\n\r\n	\r\n\r\n	纯铝立体袋可做成多种款式：平口袋式、自封式（密实袋/拉链袋）、信封式、信封自粘式、连体式、立体式等，袋身图案可根据客户要求印刷；内外表面电阻值：108&mdash;101', '', '', '', '', '', '', 'a:0:{}', null, '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('20', '十四号产品展示 ', '/upfile/2017/11/1510641893535.jpg', '1', '13', '0', '1', '0', '1', '0', '0', '0', '0', '', '1510588800', '1510641896', '纯铝立体袋材质结构PET/AL/CPE或PET/AL/NY(PA)/CPE（聚酯/铝膜/聚乙烯流延薄膜或聚酯/铝膜/尼龙膜/聚乙烯流延薄膜）两种三或四层结构，具有良好的防水，阻氧，避光的功能。整体颜色为铝箔颜色不透光。\r\n\r\n	\r\n\r\n	纯铝立体袋可做成多种款式：平口袋式、自封式（密实袋/拉链袋）、信封式、信封自粘式、连体式、立体式等，袋身图案可根据客户要求印刷；内外表面电阻值：108&mdash;101', '', '', '', '', '', '', 'a:0:{}', null, '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('21', '十五号产品展示 ', '/upfile/2017/11/1510641897242.jpg', '1', '13', '0', '1', '0', '1', '0', '0', '0', '0', '', '1510588800', '1510641900', '纯铝立体袋材质结构PET/AL/CPE或PET/AL/NY(PA)/CPE（聚酯/铝膜/聚乙烯流延薄膜或聚酯/铝膜/尼龙膜/聚乙烯流延薄膜）两种三或四层结构，具有良好的防水，阻氧，避光的功能。整体颜色为铝箔颜色不透光。\r\n\r\n	\r\n\r\n	纯铝立体袋可做成多种款式：平口袋式、自封式（密实袋/拉链袋）、信封式、信封自粘式、连体式、立体式等，袋身图案可根据客户要求印刷；内外表面电阻值：108&mdash;101', '', '', '', '', '', '', 'a:0:{}', null, '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('22', '十六号产品展示', '/upfile/2017/11/1510641902402.jpg', '1', '14', '10', '1', '0', '1', '0', '0', '0', '0', '', '1510588800', '1510898794', '纯铝立体袋材质结构PET/AL/CPE或PET/AL/NY(PA)/CPE（聚酯/铝膜/聚乙烯流延薄膜或聚酯/铝膜/尼龙膜/聚乙烯流延薄膜）两种三或四层结构，具有良好的防水，阻氧，避光的功能。整体颜色为铝箔颜色不透光。\r\n\r\n	\r\n\r\n	纯铝立体袋可做成多种款式：平口袋式、自封式（密实袋/拉链袋）、信封式、信封自粘式、连体式、立体式等，袋身图案可根据客户要求印刷；内外表面电阻值：108—101', '产品', '', '', '', '', '', 'a:0:{}', '', '0', '', '0', '[{\"name\":\"产品\",\"id\":\"1\"}]', '0');
INSERT INTO `sd_content` VALUES ('29', '采购成本管理专员', '', '0', '5', '0', '1', '0', '0', '0', '0', '0', '0', '', '1510588800', '1510899459', '<p>1、采购价格审核，价格分析，大宗材料行情跟进； <br/>2、采购成本降本效益计算及进度监控，分大类对比分析； <br/>3、采购成本基础管理（含定价率、供货比例、独家供货、价差清理、一次性采购、物料代用等）；<br/> 4、多组织间价格对比，调让价格制定，追补价差审核； <br/>5、涉及采购成本的其他工作；</p>', '', '', '', '', '', '', 'a:0:{}', '', '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('30', '产品测试工程师', '', '0', '5', '0', '1', '0', '0', '0', '0', '0', '0', '', '1510588800', '1510899422', '<p>1、负责海外市场使用及环境调研，并转化为产品标准； <br/>2、负责海外产品竞品比对及性能、可靠性验证； <br/>3、负责海外产品的品质把关，参与外销产品开发全过程。</p>', '', '', '', '', '', '', 'a:0:{}', '', '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('31', '自动化工程师', '', '0', '5', '0', '1', '0', '0', '0', '0', '0', '0', '', '1510588800', '1510899408', '<p>1、负责实施自动化项目设计、开发或引进；<br/>2、负责参与自动化相关体系、流程和标准文件的建立和编纂；<br/>3、负责设备自动化新技术、新工艺的研究，参与项目评审；<br/>4、协助解决车间自动化设备使用和管理工作；<br/>5、协助完成自动化项目年度目标规划和日常开展工作计划与总结。</p>', '', '', '', '', '', '', 'a:0:{}', '', '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('32', '产品企划工程师', '', '0', '5', '0', '1', '0', '0', '0', '0', '0', '0', '', '1510588800', '1510899387', '<p>1、负责单产品企划及上市推动：通过市场调研、消费者研究提出创新的产品解决方案，形成产品企划提案，推动产品成功上市。 <br/>2、负责产品上市阶段工作的推动：编写新产品详情文案框架、对接视频拍摄，与推广共同制定新产品的推广计划并实施落地。 <br/>3、负责微信公众号的日常运营：微信号日常运营，不断改善微信号的用户体验，提高粉丝活跃度，并与智能中心一起对接微</p>', '', '', '', '', '', '', 'a:0:{}', '', '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('33', '销售业务专员', '', '0', '5', '1', '1', '0', '0', '0', '0', '1', '0', '', '1510588800', '1510899371', '<p>1、负责客户开拓； <br/>2、负责客户辅导，对客户专业化指导并推动客户服务工作；<br/> 3、负责跟进客户的回款及相关单据的跟进工作； <br/>4、负责完成公司安排的其他专项工作。</p>', '', '', '', '', '', '', 'a:0:{}', '', '0', '', '0', '[]', '0');
INSERT INTO `sd_content` VALUES ('34', '海外销售代表', '', '0', '5', '3', '1', '0', '0', '0', '0', '0', '0', '', '1510588800', '1510899357', '<p>1、客户商机挖掘、商机落实、项目跟进、过程管理等； <br/>2、客户订单接单，下单，跟进生产、发货、收款等全流程管理； <br/>3、客户日常沟通、客户接待、会谈安排等； <br/>4、展会接待、新客户挖掘、产品推荐； <br/>5、拜访客户，了解客户新需求。</p>', '', '', '', '', '', '', 'a:0:{}', '', '0', '', '0', '[]', '0');
INSERT INTO `sd_form` VALUES ('1', '简历', 'resume', '', '', '', '', '', '', '1', '2', '4', '0', '1', '0', '0', '1');
INSERT INTO `sd_form_field` VALUES ('1', '1', '申请职位', 'my_title', '1', '0', '0', '{php:get.jobname}', '', 'varchar(255) NOT NULL', '', '1', '1', '0', '0', '', '', '', '', '', '', '1', '0', '1');
INSERT INTO `sd_form_field` VALUES ('2', '1', '姓名', 'my_truename', '1', '20', '0', '', '', 'varchar(20) NOT NULL', '', '1', '1', '0', '0', '', '', '', '', '', '', '1', '0', '1');
INSERT INTO `sd_form_field` VALUES ('3', '1', '性别', 'my_sex', '11', '0', '0', '', '男|1,女|2', 'int(10) NOT NULL', '', '1', '1', '0', '0', '', '', '', '', '', '', '0', '0', '1');
INSERT INTO `sd_form_field` VALUES ('4', '1', '年龄', 'my_age', '3', '2', '0', '', '', 'int(10) NOT NULL', '', '3', '1', '0', '0', '', '', '', '', '', '', '0', '0', '1');
INSERT INTO `sd_form_field` VALUES ('5', '1', '手机', 'my_mobile', '1', '11', '0', '', '', 'varchar(11) NOT NULL', '', '6', '1', '0', '0', '', '', '', '', '', '', '0', '0', '1');
INSERT INTO `sd_form_field` VALUES ('6', '1', '学历', 'my_education', '11', '0', '0', '', '大专|1,本科|2,硕士|3,博士|4', 'int(10) NOT NULL', '', '1', '1', '0', '0', '', '', '', '', '', '', '0', '0', '1');
INSERT INTO `sd_form_field` VALUES ('7', '1', '工作经验', 'my_work_exp', '8', '0', '0', '', '', 'text NOT NULL', '', '1', '1', '0', '0', '', '', '', '', '', '', '0', '0', '1');
INSERT INTO `sd_form_field` VALUES ('8', '1', '自我评价', 'my_intro', '8', '0', '0', '', '', 'text NOT NULL', '', '1', '1', '0', '0', '', '', '', '', '', '', '0', '0', '1');
INSERT INTO `sd_link` VALUES ('1', 'Sdcms官网', '', 'http://www.sdcms.cn', '0', '1', '0', '1');
INSERT INTO `sd_link` VALUES ('2', '极品模板', '', 'http://www.nicemb.com', '0', '0', '0', '1');
INSERT INTO `sd_link` VALUES ('3', '百度科技', '', 'http://www.baidu.com', '0', '0', '0', '1');
INSERT INTO `sd_link` VALUES ('4', '新浪微博', '', 'http://www.weibo.com', '0', '0', '0', '1');
INSERT INTO `sd_link` VALUES ('5', '支付宝', '', 'http://www.alipay.com', '0', '0', '0', '1');
INSERT INTO `sd_link` VALUES ('6', '微信', '', 'http://weixin.qq.com', '0', '0', '0', '1');
INSERT INTO `sd_link` VALUES ('7', '阿里云', '', 'http://www.aliyun.com', '0', '0', '0', '1');
INSERT INTO `sd_model` VALUES ('1', '文章模型', 'news', '', 'content/news/list.php', 'content/news/show.php', '基本设置|1,SEO设置|2,可选设置|3', '0', '1', '1', '1', '1');
INSERT INTO `sd_model` VALUES ('2', '产品模型', 'pro', '', 'content/pro/list.php', 'content/pro/show.php', '基本设置|1,SEO设置|2,可选设置|3', '0', '1', '1', '0', '0');
INSERT INTO `sd_model` VALUES ('3', '招聘模型', 'job', '', 'content/job/list.php', 'content/job/show.php', '基本设置|1,SEO设置|2,可选设置|3', '0', '1', '1', '0', '0');
INSERT INTO `sd_model_field` VALUES ('1', '1', '标题', 'title', '1', '255', '0', '', '', '', '', '1', '1', '0', '1', '0', '', '', '', '', '', '', '1', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('2', '1', '正文', 'content', '12', '0', '0', '', '', '', '', '0', '1', '2', '1', '0', '', '', '', '', '', '', '3', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('3', '1', '缩略图', 'pic', '5', '255', '1', '', '', '', '', '0', '1', '0', '1', '0', '', '', '', '', '', '', '5', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('4', '1', '标签', 'tags', '1', '255', '0', '', '', '', '多个标签请使用英文逗号隔开，不能超过10个', '0', '1', '0', '1', '0', '', '', '', '', '', '', '7', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('5', '1', '摘要', 'intro', '8', '0', '0', '', '', '', '', '0', '1', '0', '1', '0', '', '', '', '', '', '', '9', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('6', '1', '状态', 'islock', '9', '0', '0', '1', '立即发布|1,存为草稿|0', '', '', '0', '1', '0', '1', '0', '', '', '', '', '', '', '11', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('7', '1', '优化标题', 'seotitle', '1', '255', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '13', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('8', '1', '关键字', 'seokey', '8', '0', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '15', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('9', '1', '描述', 'seodesc', '8', '0', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '17', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('10', '1', '别名', 'alias', '1', '50', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '19', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('11', '1', '外链', 'url', '1', '255', '0', '', '', '', '添加外链时，将不显示正文内容', '0', '1', '0', '3', '0', '', '', '', '', '', '', '21', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('12', '1', '人气', 'hits', '3', '10', '0', '0', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '23', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('13', '1', '赞数量', 'upnum', '3', '10', '0', '0', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '25', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('14', '1', '踩数量', 'downnum', '3', '10', '0', '0', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '27', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('15', '1', '排序', 'ordnum', '3', '10', '0', '0', '', '', '数字越大越靠前', '0', '1', '0', '3', '0', '', '', '', '', '', '', '29', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('16', '1', '置顶', 'ontop', '9', '0', '0', '0', '否|0,是|1', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '31', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('17', '1', '推荐', 'isnice', '9', '0', '0', '0', '否|0,是|1', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '33', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('18', '1', '发布日期', 'createdate', '2', '0', '0', '{php:now}', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '35', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('19', '1', '内容页模板', 'showskin', '1', '255', '0', '', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '37', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('20', '2', '标题', 'title', '1', '255', '0', '', '', '', '', '1', '1', '0', '1', '0', '', '', '', '', '', '', '1', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('21', '2', '组图', 'piclist', '13', '0', '0', '', '', '', '', '0', '1', '0', '1', '0', '', '', '', '', '', '', '3', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('22', '2', '正文', 'content', '12', '0', '0', '', '', '', '', '0', '1', '2', '1', '0', '', '', '', '', '', '', '5', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('23', '2', '简介', 'intro', '8', '0', '0', '', '', '', '', '0', '1', '0', '1', '0', '', '', '', '', '', '', '7', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('24', '2', '缩略图', 'pic', '5', '255', '1', '', '', '', '', '0', '1', '0', '1', '0', '', '', '', '', '', '', '9', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('25', '2', '价格', 'price', '4', '10', '1', '', '', '', '单位：元', '1', '1', '0', '1', '0', '', '', '', '', '', '', '11', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('26', '2', '标签', 'tags', '1', '255', '0', '', '', '', '多个标签请使用英文逗号隔开，不能超过10个', '0', '1', '0', '1', '0', '', '', '', '', '', '', '13', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('27', '2', '状态', 'islock', '9', '0', '0', '1', '立即发布|1,存为草稿|0', '', '', '0', '1', '0', '1', '0', '', '', '', '', '', '', '15', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('28', '2', '优化标题', 'seotitle', '1', '255', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '17', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('29', '2', '关键字', 'seokey', '8', '0', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '19', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('30', '2', '描述', 'seodesc', '8', '0', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '21', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('31', '2', '别名', 'alias', '1', '50', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '23', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('32', '2', '外链', 'url', '1', '255', '0', '', '', '', '添加外链时，将不显示正文内容', '0', '1', '0', '3', '0', '', '', '', '', '', '', '25', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('33', '2', '人气', 'hits', '3', '10', '0', '0', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '27', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('34', '2', '赞数量', 'upnum', '3', '10', '0', '0', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '29', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('35', '2', '踩数量', 'downnum', '3', '10', '0', '0', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '31', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('36', '2', '排序', 'ordnum', '3', '10', '0', '0', '', '', '数字越大越靠前', '0', '1', '0', '3', '0', '', '', '', '', '', '', '33', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('37', '2', '置顶', 'ontop', '9', '0', '0', '0', '否|0,是|1', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '35', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('38', '2', '推荐', 'isnice', '9', '0', '0', '0', '否|0,是|1', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '37', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('39', '2', '发布日期', 'createdate', '2', '0', '0', '{php:now}', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '39', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('40', '2', '内容页模板', 'showskin', '1', '255', '0', '', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '41', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('43', '3', '职位名称', 'title', '1', '255', '0', '', '', '', '', '1', '1', '0', '1', '0', '', '', '', '', '', '', '1', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('44', '3', '工作内容', 'content', '12', '0', '0', '', '', '', '', '0', '1', '1', '1', '0', '', '', '', '', '', '', '15', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('45', '3', '缩略图', 'pic', '5', '0', '1', '', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '49', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('46', '3', '标签', 'tags', '1', '255', '0', '', '', '', '多个标签请使用英文逗号隔开，不能超过10个', '0', '1', '0', '1', '0', '', '', '', '', '', '', '19', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('47', '3', '任职要求', 'intro', '12', '0', '0', '', '', '', '', '0', '1', '1', '1', '0', '', '', '', '', '', '', '17', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('48', '3', '状态', 'islock', '9', '0', '0', '1', '立即发布|1,存为草稿|0', '', '', '0', '1', '0', '1', '0', '', '', '', '', '', '', '21', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('49', '3', '优化标题', 'seotitle', '1', '0', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '23', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('50', '3', '关键字', 'seokey', '8', '0', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '25', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('51', '3', '描述', 'seodesc', '8', '0', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '27', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('52', '3', '别名', 'alias', '1', '50', '0', '', '', '', '', '0', '1', '0', '2', '0', '', '', '', '', '', '', '29', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('53', '3', '外链', 'url', '1', '255', '0', '', '', '', '添加外链时，将不显示正文内容', '0', '1', '0', '3', '0', '', '', '', '', '', '', '31', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('54', '3', '人气', 'hits', '3', '10', '0', '0', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '33', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('55', '3', '赞数量', 'upnum', '3', '0', '0', '0', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '35', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('56', '3', '踩数量', 'downnum', '3', '0', '0', '0', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '37', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('57', '3', '排序', 'ordnum', '3', '0', '0', '0', '', '', '数字越大越靠前', '0', '1', '0', '3', '0', '', '', '', '', '', '', '39', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('58', '3', '置顶', 'ontop', '9', '0', '0', '0', '否|0,是|1', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '41', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('59', '3', '推荐', 'isnice', '9', '0', '0', '0', '否|0,是|1', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '43', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('60', '3', '发布日期', 'createdate', '2', '0', '0', '{php:now}', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '45', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('61', '3', '内容页模板', 'showskin', '1', '0', '0', '', '', '', '', '0', '1', '0', '3', '0', '', '', '', '', '', '', '47', '1', '1', '1');
INSERT INTO `sd_model_field` VALUES ('62', '3', '工作地点', 'work_address', '1', '50', '0', '', '', '', '', '1', '1', '0', '1', '0', '', '', '', '', '', '', '3', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('64', '3', '学历要求', 'work_education', '11', '0', '0', '不限', '不限|不限,高中及以上|高中及以上,大专及以上|大专及以上,本科及以上|本科及以上,大专及以上|大专及以上', '', '', '1', '1', '0', '1', '0', '', '', '', '', '', '', '7', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('63', '3', '工作性质', 'work_nature', '11', '0', '0', '全职', '全职|全职,兼职|兼职', '', '', '1', '1', '0', '1', '0', '', '', '', '', '', '', '5', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('65', '3', '薪资待遇', 'work_money', '11', '0', '0', '面议', '面议|面议,2000-3000元/月|2000-3000元/月,3000-5000元/月|3000-5000元/月,5000-8000元/月|5000-8000元/月,8000-10000元/月|8000-10000元/月,10000-20000元/月|10000-20000元/月,20000-50000元/月|20000-50000元/月', '', '', '1', '1', '0', '1', '0', '', '', '', '', '', '', '9', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('66', '3', '工作年限', 'work_age', '11', '0', '0', '不限', '不限|不限,1年及以上|1年及以上,2年及以上|2年及以上,3年及以上|3年及以上,4年及以上|4年及以上,5年及以上|5年及以上', '', '', '1', '1', '0', '1', '0', '', '', '', '', '', '', '11', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('67', '3', '招聘人数', 'work_num', '11', '0', '0', '若干', '若干|若干,1|1,2|2,3|3,4|4,5|5,6|6,7|7,8|8,9|9,10|10', '', '', '1', '1', '0', '1', '0', '', '', '', '', '', '', '13', '1', '1', '0');
INSERT INTO `sd_model_field` VALUES ('68', '1', '购买价格', 'price', '4', '10', '1', '0', '', '', '单位：元', '4', '1', '0', '1', '0', '', '', '', '', '', '', '10', '1', '1', '0');
INSERT INTO `sd_model_job` VALUES ('7', '29', '<p>负责集团大宗原材料采购及供应链领域的成本管理工作，具体职责如下： <br/>1、采购价格审核，价格分析，大宗材料行情跟进； <br/>2、采购成本降本效益计算及进度监控，分大类对比分析； <br/>3、采购成本基础管理（含定价率、供货比例、独家供货、价差清理、一次性采购、物料代用等）； <br/>4、多组织间价格对比，调让价格制定，追补价差审核； <br/>5、涉及采购成本的其他工作； <br/>6、降低采购成本、管控采购风险,,负责组织大宗原材料采购成本体系搭建及流程制度梳理维护。</p><div class=\"clear\"></div>', '苏州', '全职', '大专及以上', '3000-5000元/月', '1年及以上', '1');
INSERT INTO `sd_model_job` VALUES ('8', '30', '<p>1、负责海外市场使用及环境调研，并转化为产品标准； <br/>2、负责海外产品竞品比对及性能、可靠性验证； <br/>3、负责海外产品的品质把关，参与外销产品开发全过程。</p><div class=\"clear\"></div>', '苏州', '全职', '本科及以上', '10000-20000元/月', '5年及以上', '1');
INSERT INTO `sd_model_job` VALUES ('9', '31', '<p>1、负责实施自动化项目设计、开发或引进；<br/>2、负责参与自动化相关体系、流程和标准文件的建立和编纂；<br/>3、负责设备自动化新技术、新工艺的研究，参与项目评审；<br/>4、协助解决车间自动化设备使用和管理工作；<br/>5、协助完成自动化项目年度目标规划和日常开展工作计划与总结。</p><div class=\"clear\"></div>', '苏州', '全职', '不限', '面议', '不限', '1');
INSERT INTO `sd_model_job` VALUES ('10', '32', '<p>1、负责单产品企划及上市推动：通过市场调研、消费者研究提出创新的产品解决方案，形成产品企划提案，推动产品成功上市。 <br/>2、负责产品上市阶段工作的推动：编写新产品详情文案框架、对接视频拍摄，与推广共同制定新产品的推广计划并实施落地。 <br/>3、负责微信公众号的日常运营：微信号日常运营，不断改善微信号的用户体验，提高粉丝活跃度，并与智能中心一起对接微信号进行迭代开发。</p><div class=\"clear\"></div>', '苏州', '全职', '本科及以上', '面议', '1年及以上', '2');
INSERT INTO `sd_model_job` VALUES ('11', '33', '<p>1、负责客户开拓； <br/>2、负责客户辅导，对客户专业化指导并推动客户服务工作； <br/>3、负责跟进客户的回款及相关单据的跟进工作； <br/>4、负责完成公司安排的其他专项工作。</p><div class=\"clear\"></div>', '苏州', '全职', '本科及以上', '20000-50000元/月', '5年及以上', '1');
INSERT INTO `sd_model_job` VALUES ('12', '34', '<p>1、客户商机挖掘、商机落实、项目跟进、过程管理等； <br/>2、客户订单接单，下单，跟进生产、发货、收款等全流程管理； <br/>3、客户日常沟通、客户接待、会谈安排等； <br/>4、展会接待、新客户挖掘、产品推荐； <br/>5、拜访客户，了解客户新需求。</p><div class=\"clear\"></div>', '苏州', '全职', '本科及以上', '20000-50000元/月', '不限', '若干');
INSERT INTO `sd_model_news` VALUES ('1', '1', '0.00', '<p>&nbsp;</p><p>覆面机又被称为贴面机或裱纸机，用于对预印彩色印刷面纸与瓦楞纸板的裱贴粘合，它是预印纸箱生产的重要配套设备，对瓦楞纸板加工生产效率和质量具有一定的影响作用。随着社会经济的不断发展，预印纸箱的应用越来越广泛，覆面机的结构也越趋向多样化和自动化，制造技术、性能也越趋成熟和先进。由于覆面机的结构和性能不同，瓦楞纸板和面纸的裱贴粘合的效果也截然不同，所以，正确选购和使用覆面机是提高纸箱生产效率和质量的重要一环。</p><p>&nbsp;&nbsp;&nbsp;</p><p>1 覆面机的结构与性能</p><p>现在市场上覆面机的结构多种多样，有完全靠手工操作、结构简单、机器占地面积小、胶水干燥速度慢、生产效率低、价格便宜、小型机械厂就能生产的普通贴面机，这种机器至少需要3个人操作，先由一个人将瓦楞纸板放进胶水轮与滚动轮之间，再由对面的2个人共同将面纸抬起对准经过过胶的瓦楞纸板进行裱贴，该工艺一般适合于生产小批量且质量档次不高的预印纸箱。</p><p>&nbsp;&nbsp;&nbsp;</p><p>半自动覆面机是由2个人同时分别将瓦楞纸板和面纸输送到定位系统，经过滚压进入输送带，在压输带的压力下实现均匀的裱贴，具有粘合牢固、不易起泡和脱胶的优点。该机的速度是可调整的，但是速度受到手工放纸操作速度的限制，难以实现高速的裱贴生产。</p><p>&nbsp;&nbsp;&nbsp;</p><p>全自动高速覆面机的面纸和瓦楞纸板都是采用真空吸附自动进纸、自动输送的，其后部的输送带和加压带与半自动机器差不多，由于机器速度快，粘合剂应该采用快干型的。该机具有生产效率高，裱贴质量比较好的优点，较适合于面纸材料硬、高档的预印纸箱的生产。</p><p>&nbsp;&nbsp;&nbsp;&nbsp;</p><p>2 覆面机的款式介绍</p><p>1)FM系列C型半自动两用覆面机</p><p>&nbsp;&nbsp;&nbsp;</p><p>这类覆面机适合于面纸与底纸或瓦楞纸板(如卡纸，A、B、C、D、E型瓦楞纸或四层瓦楞纸板)的裱贴粘合，面纸和底纸采用同步光电技术控制，可避免底纸或面纸送纸不到位的问题。机器采用LED数字显示器计数裱贴的数量，可自动、快捷、准确显示出生产的数量。涂胶装置可使过胶均匀、耗胶量少。机器的规矩具有调整方便、精确度高的特点，适合于预印纸箱、纸盒的裱贴，是包装生产常用的配套设备之一。</p><p>&nbsp;&nbsp;&nbsp;</p><p>2)KFMJ-D型气动液压式多功能卡纸覆面机</p><p>该机采用光电计数器、纸张空张保护控制功能和全液压装置，并采用进口气动、液压自动锁定光电元器件。当面纸或底纸不输入的情况下，可较好地避免因单向进纸涂胶后由于没有裱贴纸的作用而粘在辊筒上，降低裱贴的废品率。该机还应用先进的液压技术，能够自动锁定完成纸张的涂胶、裱贴、压实的全过程，使涂胶更均匀、用胶量少、粘合强度高。该机可裱贴定量100～1500g/m2的材料，机器速度可根据裱贴材料特性进行调整，机器的裱贴精确度较高，是各种包装盒和商品卡片生产的配套设备。</p><p>&nbsp;&nbsp;&nbsp;</p><p>3)全自动FMZ-1450、FMZ-1260覆面机</p><p>这两款机器的最高速度分别可达到5000张/小时和6000张/小时；裱贴最大尺寸分别为1450mm&amp;times;1250mm和1260mm&amp;times;1250mm，最小尺寸为400mm&amp;times;400mm，覆贴误差约为&amp;plusmn;1.5mm。该机的主要优点是:特殊的前规定位，具有定位稳定、精确、底纸不超前的特点。由于该机器采用面纸侧拉规及面纸侧吹风，可有效保证送纸精度和提高生产效率。机器面纸输送采用重叠式走纸方式，可使送纸更平稳。该机器应用PLC跟踪技术，可根据纸张大小自动调节相关参数，使机器运行始终保持在最佳状态。TWIDO PLC通过Modbus控制变频调速系统，可实现不停机无级调速。该机适合于厚度&amp;le;7mm、定量在250g/m2～450g/m2之间材料的裱贴，是提高瓦楞纸箱、纸盒生产效率和质量，大批量生产预印纸箱的理想设备。</p><p>&nbsp;&nbsp;&nbsp;</p><p>3 选购覆面机应该注意的因素</p><p>由于覆面机的结构、性能不同，其适应性和价格也是有很大差异的。所以，选购时要根据工厂的产品特点、厂房条件、技术和资金实力等，进行全面的综合考虑。笔者认为，采购时应着重从选品牌、选价格、选规格、选机型和选实用性等方面进行考虑。</p><p>&nbsp;&nbsp;&nbsp;</p><p>1)选品牌</p><p>选品牌实际上就是选制造商。一般情况来说，生产规模大、技术实力雄厚的大工厂所生产的覆面机性能、质量相对比较稳定、可靠，售后服务也比较有保障。青岛美光机械有限公司是现在国内生产覆面机比较大的工厂，在全国各地有不少的用户，该公司生产的覆面机的性能、质量、售后服务等方面已经被广大用户所认同。</p><p>&nbsp;&nbsp;&nbsp;</p><p>2)选价格</p><p>价格是决定生产成本的重要因素之一，是工厂设备采购控制的重要一环。机器的价格与它的结构、性能、品牌等有一定的关系，结构简单、低效的贴合机一台只要几千元就可买到。半自动覆面机与自动覆面相比，少了自动输纸结构，机器的速度也受到手工放纸速度的限制，它的价格在10万元/台左右。而全自动的覆面机结构复杂，机械精度和技术含量都比较高，生产效率和质量也高，它的价格在35万元/台左右。选择什么档次的机型，要根据工厂的产品特点而定。值得一提的是，不同的厂家生产的同样结构的覆面机，由于各工厂的生产能力、生产规模、材料来源、管理模式和生产成本等的不同，其价格会有一定的差异。所以，选价格就是要在&amp;ldquo;货比三家&amp;rdquo;的情况下，通过&amp;ldquo;走市场、访用户&amp;rdquo;的途径，对市场上设备的结构、性能和价格进行多方的考察，使自己对设备行情有一个比较准确、清晰的了解，以确保采购到价格合适、性能可靠的覆面机。</p><p>&nbsp;&nbsp;&nbsp;</p><p>3)选规格</p><p>覆面机的规格是相对辊筒的长度而言的，辊筒长的覆面机可裱贴的纸板宽度相对就大，购买覆面机的规格主要应根据工厂产品的特点确定。有的工厂以窄幅产品为主，为了使机器也可以裱贴大规格的产品，就全部购买大规格的机器进行生产，认为购买大规格的机器&amp;ldquo;可大可小&amp;rdquo;适应性强。实际上，用大规格的机器去裱贴小规格、小批量的产品，一方面容易造成粘合剂的浪费，另一方面能源消耗、生产成本也高。所以，产品结构比较多样化的工厂，在选购覆面机规格时，应酌情按比例适当选购不同规格的覆面机，以适应高效、合理生产的要求。</p><p>&nbsp;&nbsp;&nbsp;</p><p>4)选机型</p><p>覆面机有完全靠手工操作、结构简单的贴面机，有半自动和全自动的覆面机，不同机型的覆面机其结构、性能、价格也截然不同，选择什么机型的覆面机进行生产，主要取决于工厂产品的结构和特点。如中、小型的工厂所生产的产品品种杂、规格多，既有固定的大宗业务量的产品，又有小批量的定单，可酌情采购手工操作的贴面机、半自动和全自动的覆面机各若干台，这样，生产时可根据产品的特点合理安排合适的机器进行生产，对提高生产效率和质量都是比较有利的。</p><p>&nbsp;&nbsp;&nbsp;</p><p>5)选实用性</p><p>所采购的覆面机应该符合经济、合理、优质、高效的生产要求，才能有利于提高生产效率和质量，降低生产成本。工厂要根据自己产品结构的特点，确定机器的采购意向，小批量、小规格的产品宜采购手工贴面机进行裱贴，数量大、材质硬的面纸和质量要求高的产品则应选购半自动、全自动的覆面机进行裱贴，切忌选购全自动的覆面机长期去裱贴生产小批量的、小规格的纸箱产品。</p><p>&nbsp;&nbsp;&nbsp;</p><p>4 覆面机的正确使用和保养</p><p>1)生产操作的控制</p><p>当裱贴彩印的面纸较薄并且有卷曲的情况下，机器的速度不可开得过快。装面纸和瓦楞纸板时，它们左右相对的位置要对准，以免因为出纸定位出现偏向误差，产生横向裱贴不准。为了确保面纸和瓦楞纸板裱贴位置准确无误，机器的生产速度要根据面纸的特点合理掌握；装纸时要将面纸和瓦楞纸板的相对位置对准；上、下链条的行程必须准确；上、下纸对准后要将堆纸台的挡纸限位装置固定好。</p><p>&nbsp;&nbsp;&nbsp;</p><p>2)送纸和定位机构</p><p>机器若调整或保养不当，也容易造成面纸和瓦楞纸板裱贴出现误差弊病。其主要原因有:送纸链条机构存在松动现象，使上、下链条工作配合不一致或不稳定；上、下链条上的前规出现松动，使送纸时对纸边产生撞击现象；压纸钢板条对面纸的接触位置不适或间隙太大，没有起到减缓纸板高速运动时惯性冲力的作用；上、下滚压辊因没有经常清洗而聚积着一定量的胶液，阻滞了面纸和瓦楞纸板的同步滚压输送。所以，机器的链条应适时进行清理、清洗，并保持良好的润滑；对于出现松动的前规，应该及时采取相应的措施进行处理；调整压纸钢板条的位置，使之与纸板保持一定的摩擦力，防止输纸过猛而超前；应经常清除干净上、下滚压辊上的胶液或赃污。</p><p>&nbsp;&nbsp;&nbsp;</p><p>3)机器的正确使用和保养</p><p>自动覆面机的精度高，这是提高生产效率和质量的可靠保证，故平时要注意做好机器的正确使用和保养工作，这是防止机器非正常磨损和损坏的重要环节。新机器采购后，若由于工厂自身技术条件的限制，不能自行培训生产操作人员的话，应请设备供应厂家派技术人员上门培训设备操作者，确保机器在采购后能够得到正确的使用和正常的发挥。在设备起初使用的磨合期，机器的生产速度不要开得过快，一般要控制在3000张/小时左右。在设备试生产过程中，要注意通过&amp;ldquo;观、闻、摸&amp;rdquo;等方法检查机器是否保持正常状态。观，就是要注意看看机器有关部件的工作状态、动作有没有异常；闻，就是要注意听听机器有没有不正常的声响；摸，就是在机器刚运行的一段时间内，要适时停机去摸摸机器的一些转动轴、齿轮等转动件，是否出现明显温升而产生异常滚烫的感觉。如发现不正常现象，应立即停机进行检查，发现问题及时处理。机器在使用过程中，一定要严格按设备说明书的要求进行操作，并做好机器的润滑和定期保养工作，这是确保设备保持良好的精度，提高生产效率和质量的有效保证。</p><p>&nbsp;&nbsp;&nbsp;</p><p>覆面机作为预印纸箱生产的重要配套设备，是纸箱生产加工质量不可忽略的生产要素之一，只有深入实际全面了解覆面机的市场动态，根据工厂的实际情况和产品的特点合理选购适合本工厂厂情的机器，并正确地进行使用和保养，才能使所采购到的设备在提高生产效率和产品质量方面发挥最佳的作用。</p>');
INSERT INTO `sd_model_news` VALUES ('2', '2', '0.00', '<p>油墨的耐抗性即印品墨膜对严酷条件的耐受能力，包括耐光性、耐热性、耐油脂性、耐化学性等。如需要煮沸杀菌包装的印刷油墨和颜料坯需要具有耐煮沸性。</p><p>经济性包装印刷厂在印刷生产中，追求的是低投入、高回报，即按照适度包装的原则，在满足以上条件的前提下，选择总体成本(采购成本加使用成本等)较低的油墨。包装印刷厂虽然选择了合适的油墨，但在油墨的使用过程中，也出现了不少由于油墨本身而产生的问题。那么，包装印刷厂对油墨有什么更高的要求呢？</p><p><strong>包装印刷厂对油墨的要求</strong></p><p>包装印刷厂为了使自己的营运费用最佳化，改善生产的稳定性，满足客户的要求，在生产高质量产品的同时，提高生产效率、改善生产环境和满足客户对产品的环保要求是包装印刷厂对油墨的基本要求。降低使用成本降低成本，获得最大利润是企业生存和发展的前提，包装印刷厂也不例外。虽然油墨只占印刷成本的15％(纸张占45％)，但据我们了解，印刷厂始终没有放弃降低油墨成本的努力，包装印刷厂更希望油墨供应商以最佳的性价比，提供满足要求的油墨产品。</p><p><strong>提高油墨着色性</strong></p><p>印刷厂都希望油墨生产厂提高油墨的着色性，希望用定量的油墨印出更多的活件或定量的活件用最少量的油墨，以减少印刷成本。然而，油墨的用量与油墨的着色性密切相关。在墨量一定的情况下，油墨着色性越高，所印活件越多，利润越大。</p><p><strong>减少助剂的使用或使用配套助剂</strong></p><p>一方面，印刷厂都希望所用油墨在印刷时可以直接使用，不需要添加或很少添加助国内塑料凹印油墨市场浅析当前国内塑料软包装行业中，上规模的大型企业只占10％左右，中小型企业却占90％以上。</p><p>大型塑包企业的印刷机先进，印刷速度快(高速印刷机)；产品档次高、批量大、品种专一、用油墨品质较高而且用量大，一般最多固定用二至三个油墨厂家生产的油墨。然而众多的中、小型塑包企业的印刷机，虽然在近年来有已有更新；但是中、低速印刷机还占大多数。其设备和条件较差，生产的品种多、批量小、数量少。因而用油墨较杂，使用油墨也没有固定的油墨厂家，一般以低价位的油墨为首选。</p><p>油墨品种在塑料软包装中，食品包装、食盐包装、化妆日用品包装、医药品包装、纸制品包装、服装包装中：食品包装是以复合里印油墨为主，部份糖果纸用表印油墨；蒸煮包装使用高温蒸煮油墨，一般真空包装则采用聚酯油墨；奶制品包装宜用耐水、耐酸、耐温的油墨。药品包装和化妆品包装以聚酯油墨为主。</p><p>食盐包装有的生产厂家使用表印油墨，有的生产厂家用复合里印油墨，但更多的生产厂家使用聚酯油墨。日用品包装、纸制品包装和服装包装使用表印油墨的多，但是表印白油墨应是特制的、爽滑耐划伤、防粘连的油墨。随着包装市场档次的提高，使用复合里印油墨的越来越多了。</p><p>塑料凹印油墨的价位当前塑料油墨的价位分高、中、低三挡，上海DlC油墨公司、江门东洋油墨公司、深圳深日油墨公司等的油墨市场售价较高。山西雄鹰油墨公司、浙江新东方油墨公司的油墨价格居中。</p><p>浙江永在化工公司的油墨价位较低，可是国内生产偏低价位油墨的小油墨厂家太多了。</p><p>一般塑料凹印油墨市场售价：蒸煮如何使用醇溶凹印油墨醇溶性凹版印刷油墨，由醇溶性合成树脂、溶剂及有机颜料经充分研磨分散后，具有良好流动性的胶状液体，属挥发干燥型油墨，具有良好的印刷适性、干燥快、光泽亮、色彩鲜艳等特点。适用于印刷包装食品用玻璃纸和糖果包装纸。印刷速度在25-70m／mm。</p><p>醇溶凹印油墨使用方法：应于较低温度下贮存，使用前将油墨进行充分搅拌，使之具有良好的流动性能。曰醇溶油墨在粘度、稀稠、干燥性等方面，要符合上机要求。如果油墨太稠，可用乙醇(能加速干燥)或丁醇(能减慢干燥)稀释，或加稀释剂稀释。如因印机的速度较高或冬季气候较而干燥慢时，可加入快干剂以加速其干燥性。曰油墨可以互相混合，以调节各种色泽。但不可与其它型号油墨混用，以免产生树脂析出等无法使用现象。<br/></p>');
INSERT INTO `sd_model_news` VALUES ('3', '3', '0.00', '<p style=\"text-align: center;\"><img alt=\"浅析印刷包装企业对CTP系统的需求\" src=\"/upfile/2017/11/1510641457995.jpg\"/></p><p>一个适合的CTP系统需从包装印刷的特点出发，解决困扰包装印刷企业的一系列头疼问题，才能满足包装印刷企业的需求，使其从CTP技术中受益。CTP技术进入包装印刷企业，需要解决好如下问题：</p><p>&nbsp;</p><p>1. 包装印刷在生产中关注专色再现，色彩一致性。</p><p>相比色彩的层次再现及中性灰控制，包装印刷企业更注重专色再现和色彩一致性问题。这需要CTP系统具备色彩管理的工艺控制模块，不单是配备硬件设备那么简单，更需提供色彩的调试和质量控制培训服务，解决好实际生产中的色彩一致性问题。</p><p>数码打样与上机工艺打样结合。大批量生产，需要建立生产控制标准和规范，而包装厂目前的打样有相当一部分是上印刷机打样，客户签字认可。色彩管理作为CTP系统的一部分，需要通过建立一系列生产工艺的规范和标准，保证生产的稳定性，保证数码打样与印刷色彩的一致性。</p><p>&nbsp;</p><p>2. 与CTF出片晒版传统工艺兼容性问题。</p><p>很多印包企业仍有一定比例活件用CTF出胶片晒版，不可避免两种工艺同时存在的状况，这需要CTP系统能解决好CTP与CTF两种工艺兼容的问题，不致出现CTF晒版印刷与CTP制版印刷在色彩等方面的差异。</p><p>包装厂重印情况较多，注重网点还原稳定性。</p><p>这是包装印厂上CTP的一个障碍，经常留片，用时拿出来客户签字认可的胶片反复晒版，担心CTP反复出版，每次网点还原有差异。CTP系统须结合设备的稳定性、高精度、专业的色彩工艺服务保证反复出版的网点还原稳定性、多次重印的色彩一致性。</p><p>&nbsp;</p><p>3. 包装印前客户文件的检查，以及拼大版和陷印问题。</p><p>对于外来的客户文件，因复杂多样的制作软件版本及多种处理效果，会给印前输出带来出错机会，需要流程系统具备多种出错检查机制，将出错的可能性以及给企业带来的损失降到最低。同时包装企业在传统的生产工艺流程，手工检查陷印、手工拼大版，费时费力，同时效率低下。CTP系统须协助印前人员解决包装印前处理中常见的陷印、拼大版以及油墨转换、预飞等问题。</p><p>&nbsp;</p><p>4. 安全防伪生产的需求。</p><p>对于烟包、酒包、化妆品等包装印刷企业，可不得不提到假货赝品，运用一些防伪技术是必不可少的，同时也可为提高产品更多的附加值，从而为上游客户提供更多增值服务。</p><p>&nbsp;</p><p>5. 对专业、及时、本地化的服务需求。</p><p>由于大部分包装企业上CTP前没有印前，经验比较欠缺，CTP技术引进后，需要供应商具有强大的综合服务能力，需具备专业、及时和本地化的特点。</p>');
INSERT INTO `sd_model_news` VALUES ('4', '4', '0.00', '<p style=\"text-align: center;\"><img alt=\"电子行业中包装机的地位\" src=\"/upfile/2017/11/1510641459308.jpg\"/></p><p>电子行业的发展需要包装机械的辅助。包装机械的发展则需要电子行业的支持!电子行业是一个先进的高科技产业，其重要性可以衡量一个国家的科学技术水平如何。而包装机械行业在电子行业却表示相当抢手。包装机械在电子行业的应用也非常广泛。东莞旭田包装机械是国内知名的老牌包装机械厂家，国内有着很高的知名度。多年来旭田包装机械一直坚持走自主创新的道路，解脱国内包装机械技术对国外的依赖性，并加大力度研发拥有自主知识产权的包装机械，旭田包装机械已经取得了硕果累累的果实。近年来旭田包装机械推出的包装机械设备已经最大限度的满足了市场商品的需求，为包装机械行业的发展排除了发展中遇到阻碍石，让旭田包装机械在包装机械行业有着更好的发展，同时也给包装机械行业提供了新的发展空间。</p><p>包装机械行业不时地变化中，旭田包装机械给各行各业的发展添加了新的启示。包装机械根据自身的优势，不时的完善与发展，应用范围广，使得电子产品包装生产对包装机械设备具有了强烈的依赖性。包装机械设备对电子产品的包装能够有效地阻挡商品与空气的接触，起到防潮、防氧化的作用，旭田包装机械已经成了目前很多电子厂商的首选包装机械设备。包装机械行业的发展中，旭田包装机械找出了适合自己产品的发展道路，旭田包装机械对包装机产品进行潜心研究，医药和电子行业中的使用也是不俗的由于医药行业因其对药物有着非常高的卫生要求，为了防止不用要的意外发生或者因包装不当而导致疾病的传达，因而包装机械在包装上则做到这一点，尽可能地避免了因包装不当而发生的意外医疗事故。针对国内包装机械行业的发展现状，东莞旭田包装机械有限公司认为未来国内包装机械将会迎来更广阔的市场和商机，国内包装机械厂家要想突破目前行业发展的有利因素就要敢于创新、敢于发展，时刻掌握市场发展的动向，力求与时代发展同步。司经十多年的奋斗和努力，已经为今天的辉煌成绩打下了良好的基础堡垒，包装机械行业的竞争中卓尔不群。</p>');
INSERT INTO `sd_model_news` VALUES ('5', '5', '0.00', '<p style=\"text-align: center;\"><img alt=\"国内包装机行业发展现状\" src=\"/upfile/2017/11/1510641462273.jpg\"/></p><p>甚至于大件的家居用品都需要包装，无论是食品还是生活用品。包装已成为潮流，而包装机械行业也随之蓬勃发展。特别对于食品行业，各式各样的包装设备屡见不鲜，从印刷包装到微机组合秤再到废品打包出卖，每一个环节的创新都为食品包装行业带来新的变化。随着国际社会对食品包装行业的要求不时提高，竞争也随之激烈，国内外包装机械市场繁荣的面前正演绎着一场场市场争夺战。众所周知，中国的食品机械企业数量多，规模小，科技含量低。只有大约5%国内食品包装机械企业拥有全套包装系统的生产能力，能与如日本、德国、意大利等的国际企业相竞争，大多数规模小的食品企业只能依靠进口包装机械设备。据有关数据显示，2010年中国食品和包装机械主要从欧洲进口，包装机械的进口金额为20.98亿美元，占包装机械总额的70.71%同比增长40.94%可见中国国内对包装机械的需求量之大，但由于国内的包装机械技术未能满足食品企业的需求，至使国内包装机械设备进口量有增无减。</p><p>食品包装机械行业的出路：科技与节能 科学技术是企业的生命，也是企业的动力。包装机械自动控制系统不时完善，使之发展也趋向智能化。如检测技术的提高，不但能显示当前机器故障的位置还能预测可能发生的故障，让操作员能及时检查和更换相关配件，有效地避免故障的发生。远程监控也是食品包装机械的一个创新应用，集团客户能统一统筹全部机器的运转及实现远程监控，对企业来说是一大便当。国际模协秘书长罗百辉表示，科技与节能将会成为未来包装机械行业发展的重要方向。包装机械行业的科技革新除机器自身外还要考虑包装资料，环保节能是包装行业的一个重要议题，不少国家及社会团体都加入到包装节能环保的技术开发中。也有一些新式的环保包装产品呈现，如英国研发出一款用胡萝卜做的包装纸，既可食用也可用来包装食物;日本一家研究所，以豆渣为原料，制成一款遇热能溶可食包装纸。包装机械在节约人工本钱和资料本钱上也同样出色，能使一支大约需要2025人的生产队伍缩短为45人，并能同时高于人工生产效率。欧美更借助其强大的经济、科技优势对我国食品包装机械企业造成巨大的压力。如位于美国艾奥瓦州勒马斯的WellDairi一家自动化程度很高的乳制品加工企业。与KukaRobot公司合作研发一款能在极端寒冷的环境下仍旧坚持可靠运行状态的码垛机器人。这款机器人能极大地保证产品的质量及包装速度。包装机械行业，算得上是绝无仅有的新技术，也是该企业实现全球化战略的一把利器</p><p>。食品包装机械行业的前景：机遇与挑战 食品机械行业是向阳产业，蕴藏着巨大的发展潜力。国被誉为未来食品加工的大型&amp;ldquo;工厂&amp;rdquo;据有关数据显示，中国现在每年水果罐头产量为120万吨，约60万吨出口到国外，约占全球市场的1/6除了硬性的社会需求外，国政府采取相应的鼓励措施，将大力推动食品机械企业的转型，向工业化、信息化、市场化的方向迈进，协助企业突破资金与技术的困难。国际著名调查机构&amp;mdash;Visiongain也通过对全球各大食品包装饮料企业近几年的发展趋势和轨迹的调查，大胆地预测2011年全球食品饮料包装市场价值将达117亿美元。并预言未来十年包装机械将会发生革命性的变化，这将会为食品饮料包装行业带来新的机遇。包装机械发展的道路也并不是一帆风顺，将会面临更大的挑战。国，食品行业较分散，并且小作坊较多。据统计，中国有食品生产企业达45万家，其中80%10人以下的小作坊生产。因为企业规模小，资金短缺，机械化生产很难被应用上，这对我国的食品机械发展有一定的阻碍作用。包装机械行业在国内还将有一段较长时间的发展，不少包装企业将目标瞄准国外，但国外的市场竞争更为激烈。德国、意大利、日本形成了包装机械行业的铁三角&amp;rdquo;技术水平对中国包装机械企业来说有压倒性的优势。中国企业能站在国际舞台上的只有极少数的几家。中国包装机械企业的发展道路还很长，这条漫长的道路长必然会遇到各种挑战，借助政府的支持，积极学习国外先进经验的同时，加强自主研发，才干取得进步<br/></p>');
INSERT INTO `sd_model_news` VALUES ('6', '6', '0.00', '<p style=\"text-align: center;\"><img alt=\"环保包装持续发展的重点环保油墨\" src=\"/upfile/2017/11/1510641464608.jpg\"/></p><p>无论是水性油墨、可降解油墨还是UV固化油墨，环保油墨性能的改进给印刷和包装行业注入了新的活力。这些环境友好型产品都将为印刷包装行业的可继续发展作出贡献。环保油墨市场增长 随着包装行业不时努力降低自己的环境影响力，环保油墨和印刷技术的使用也在不时增加。各国政府纷纷通过法律法规的形式对油墨的成分做出了限制，例如欧盟出台了针对包装可堆肥性标准。尽管这些规范目前还不会对中国等重要制造业大国发生制约，但它已经给这些国家的包装企业带来了一定压力，并促进了环保油墨技术在亚太地区的发展。日本东洋油墨制造株式会社通讯总监优&amp;middot;安达充在2010年就曾经预言：随着相关规定的日益严格和公众环保意识的增强，环保产品的市场需求将不断增长。因此，环保油墨市场在最近几年经历了继续的增长，并有望继续坚持增长。</p><p>史密斯派诺公司在2010年发布的一份调查演讲中预测，环保油墨市场的产值将从2009年的58亿欧元增长到2014年的72亿欧元，年均复合增长率高达4.5%油墨化学和印刷技术的进步为高性能和环保印刷技术的诞生作出了巨大的贡献。虽然它不会直接催生最环保的印刷方式，但这些技术能在协助企业实现环保目标的同时确保印刷质量不受影响。水性印刷工艺的进步 水性印刷工艺已使用了几十年时间，能通过消除或减少对以石油为基础的溶剂的使用来降低印刷过程中挥发性有机化合物的排放和能源的消耗量。此外，去掉油墨配方中的溶剂还能降低印刷行业对石油的依赖以及对高本钱污染治理方案的需求。直到最近，水性油墨还被认为是不适合在食品包装领域使用，因为它干燥速度较慢，很难与食品领域中常用的非吸收性包装资料相兼容。但是水性柔印技术在近年来所取得的进步协助人们解脱了一定的限制。以跨国企业富林特集团为例，该公司在2010年推出了水性柔印油墨，采用了富林特专有的自交联技术，能使墨膜在塑料等包装资料相接触时表示出更好的粘着性。这类技术创新为无溶剂印刷进入充溢挑战的软包装市场奠定了基础。很多胜利的油墨技术都是与整体的包装理念相辅相承的以前的塑料薄膜无法使用打印机进行直接打印，因为塑料薄膜不能吸收水性墨水。施赖纳公司找到一种解决方法，塑料薄膜外表使用了一种能够吸水的涂层。使用水性墨水在这种资料上进行直接打印，干燥时间还不到1秒钟。同时，这种资料可以设计成在条码薄膜再加一层保护膜的双层结构，从而维护标签免受机械磨损、湿润和腐蚀的损害。这表明，任何阻碍环保油墨向前发展的问题最终都会得到解决。UV及电子束固化技术异军突起 UV柔印能通过紫外线使油墨固化，进而为用户带来无与伦比的环保效果。UV柔印技术在印刷包装市场上的应用不时扩大，即便是敏感的包装领域，也得到用户的认可。意大利基杜公司就发明性地将UV柔印与无溶剂覆膜结合在一起，为追求环保的包装用户提供了理想的印刷解决方案。</p><p>该公司总经理德安纽兹尔曾在2012年年初表示：解决方案能通过覆膜维护UV印刷表示，从而防止UV油墨与食物的接触，最大限度地降低UV油墨污染食品的可能性。除了UV固化以外，电子束技术也常被用来对无溶剂油墨进行干燥。这项技术的支持者们认为，电子束的固化效果要好于UV但它较高的本钱和复杂的技术也是妨碍其在包装市场上不时扩大市场份额的主要原因。但随着成本的不时下降和技术的日益普及，电子束固化系统的市场份额有望进一步增加，尤其是能源消耗量低于UV和保守热固化系统的情况下。UV和电子束固化技术之间进行选择是一件很困难的事情，但随着现代化柔印机的不时增加，人们也许不再需要做出这样的选择。4月初，一家美国包装印刷企业订购了全球首台高斯新款卷筒纸胶印系统，该系统不但配备了UV和电子束固化系统，而且还装有联机的柔印和涂布单元。可降解油墨潜力无限 虽然很多技术都能使印刷变得更加环保，但仍有人愿意通过油墨改善产品的用后环保性。而在所有环保油墨中，可生物降解油墨是最受包装领域欢迎的因为它本钱效益较高，而且更便于人们对纸张进行回收。随着技术的不时进步，可生物降解油墨将成为可降解包装理念中的一个重要组成局部。环保型油墨技术的发展总是要经历一个漫长而曲折的过程，现在所使用的技术主要是用来改善印刷流程的可持续性，而且它对印刷质量也有了很大提升。随着技术的不时革新，环保方面的潜力也将不时被释放出来。这个所有企业都不愿意为环保而影响印刷质量的市场上，环保油墨无论是对整个行业还是环境都变得比以往更加重要。<br/></p>');
INSERT INTO `sd_model_page` VALUES ('1', '7', '\"\"', '<p>　　时代网站信息管理系统（简称：SDCMS，计算机软件著作权登记号：2013SR024100），SDCMS是苏州烟火网络科技有限公司旗下产品，自2008年发布第一个产品以来，历经八年的成长与发展，时至今日我们已研发出门户版、商城版、企业版以及最新的PHP三网合一企业网站管理系统等产品系列。我们的产品为几十万中小企事业单位提供了源动力。</p><p>　　八年来我们一直致力于产品的良好用户体验、网络营销效果而努力，我们力求每一个产品版本的发布，都要向前迈进，与时俱进。</p><p>　　强大灵活的模板引擎，方便扩展的自定义模型、模型自定义字段、自定义表单等灵活的功能扩展，满足各种不同的需求。强大的手机版功能，智能识别手机和电脑访问，更好的满足移动互联网的需要。</p><p>　　展望未来，我们将一如既往注重产品的用户体验和实用价值，为日新月异的互联网发展而不懈努力！</p>');
INSERT INTO `sd_model_page` VALUES ('2', '8', '\"\"', '<p>企业文化</p>');
INSERT INTO `sd_model_page` VALUES ('3', '9', '{\"1\":{\"image\":\"/upfile/2017/11/1510640750423.jpg\",\"desc\":\"\"},\"2\":{\"image\":\"/upfile/2017/11/1510640750195.jpg\",\"desc\":\"\"},\"4\":{\"image\":\"/upfile/2017/11/1510640750387.jpg\",\"desc\":\"\"},\"3\":{\"image\":\"/upfile/2017/11/1510640750803.jpg\",\"desc\":\"\"},\"5\":{\"image\":\"/upfile/2017/11/1510640750479.jpg\",\"desc\":\"\"}}', '<p>　</p>');
INSERT INTO `sd_model_page` VALUES ('4', '6', '\"\"', '<p><strong><span style=\"font-size: 16px;\">苏州烟火网络科技有限公司</span></strong></p><p>联系人：IT平民<br/>电　话：0512-12345678<br/>邮　箱：<a href=\"mailto:sdcms@qq.com\">sdcms@qq.com</a></p>');
INSERT INTO `sd_model_pro` VALUES ('1', '7', '0.00', '<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); line-height: 24px; font-family: &quot;Microsoft YaHei&quot;;\"><span style=\"line-height: 2; font-size: 14px;\"><strong>EPE珍珠棉袋</strong>是非交联闭孔结构 , 是一种新型环保的包装材料。它由低密度聚乙烯脂经物理发泡产生无数的独立气泡构成。克服了普通发泡胶易碎、变形、回复性差的缺点。具有隔水防潮、防震、隔音、保温、可塑性能佳、韧性强、循环再造、环保、抗撞力强等诸多优点，亦具有很好的抗化学性能。是传统包装材料的理想替代品。</span></p><p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); line-height: 24px; font-family: &quot;Microsoft YaHei&quot;;\">\r\n	&nbsp;</p><p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); line-height: 24px; font-family: &quot;Microsoft YaHei&quot;;\"><span style=\"line-height: 2; font-size: 14px;\"><strong>EPE珍珠棉袋</strong>广泛应用于电子电器、仪器仪表、电脑、音响、医疗器械、工控机箱、灯饰、工艺品、玻璃、陶瓷、家电、喷涂、家俱、酒类及礼品包装、五金制品、玩具、瓜果、皮鞋的内包装、日用品等多种产品的包装。加入防静电剂和阻燃剂后，更显其卓越的性能。</span></p>', '[{\"image\":\"/upfile/2017/11/1510641832876.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641833517.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641834688.jpg\",\"desc\":\"\"}]');
INSERT INTO `sd_model_pro` VALUES ('2', '8', '0.00', '<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); line-height: 24px; font-family: &quot;Microsoft YaHei&quot;;\"><span style=\"line-height: 2; font-size: 14px;\"><strong>EPE珍珠棉袋</strong>是非交联闭孔结构 , 是一种新型环保的包装材料。它由低密度聚乙烯脂经物理发泡产生无数的独立气泡构成。克服了普通发泡胶易碎、变形、回复性差的缺点。具有隔水防潮、防震、隔音、保温、可塑性能佳、韧性强、循环再造、环保、抗撞力强等诸多优点，亦具有很好的抗化学性能。是传统包装材料的理想替代品。</span></p><p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); line-height: 24px; font-family: &quot;Microsoft YaHei&quot;;\">\r\n	&nbsp;</p><p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); line-height: 24px; font-family: &quot;Microsoft YaHei&quot;;\"><span style=\"line-height: 2; font-size: 14px;\"><strong>EPE珍珠棉袋</strong>广泛应用于电子电器、仪器仪表、电脑、音响、医疗器械、工控机箱、灯饰、工艺品、玻璃、陶瓷、家电、喷涂、家俱、酒类及礼品包装、五金制品、玩具、瓜果、皮鞋的内包装、日用品等多种产品的包装。加入防静电剂和阻燃剂后，更显其卓越的性能。</span></p>', '[{\"image\":\"/upfile/2017/11/1510641836227.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641837459.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641838427.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641839894.jpg\",\"desc\":\"\"}]');
INSERT INTO `sd_model_pro` VALUES ('3', '9', '0.00', '<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\">易洁包装提供的<strong>透明PE骨袋的材质</strong>为NY（PA）/CPE或PET/NY（PA）/CPE。此产品具有防静电功能、抽真空效果佳、透明度高、透(氧)气率低、防潮性能好、抗拉强度与耐穿刺强度高、易热封、密封性好、不易老化等特点。</span></p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	&nbsp;</p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\"><strong>透明PE骨袋</strong>主要用于五金、电子元器件、有需要抽真空要求的包装等。尺寸、规格、耐高温性等都可按要求定做。PE骨袋还可根据客户要求，在不侵犯他人知识产权的情况下，印刷文字、图案、商标等，助您提升企业形象。</span></p>\r\n\r\n        ', '[{\"image\":\"/upfile/2017/11/1510641841542.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641841796.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641842199.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641843699.jpg\",\"desc\":\"\"}]');
INSERT INTO `sd_model_pro` VALUES ('4', '10', '0.00', '<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); line-height: 24px; font-family: &quot;Microsoft YaHei&quot;;\"><span style=\"line-height: 2; font-size: 14px;\">易洁包装提供的<strong>透明PE骨袋的材质</strong>为NY（PA）/CPE或PET/NY（PA）/CPE。此产品具有防静电功能、抽真空效果佳、透明度高、透(氧)气率低、防潮性能好、抗拉强度与耐穿刺强度高、易热封、密封性好、不易老化等特点。</span></p><p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); line-height: 24px; font-family: &quot;Microsoft YaHei&quot;;\">\r\n	&nbsp;</p><p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); line-height: 24px; font-family: &quot;Microsoft YaHei&quot;;\"><span style=\"line-height: 2; font-size: 14px;\"><strong>透明PE骨袋</strong>主要用于五金、电子元器件、有需要抽真空要求的包装等。尺寸、规格、耐高温性等都可按要求定做。PE骨袋还可根据客户要求，在不侵犯他人知识产权的情况下，印刷文字、图案、商标等，助您提升企业形象。</span></p>', '[{\"image\":\"/upfile/2017/11/1510641845494.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641846318.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641847443.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641847389.jpg\",\"desc\":\"\"}]');
INSERT INTO `sd_model_pro` VALUES ('5', '11', '0.00', '<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\">易洁包装提供的<strong>透明PE骨袋的材质</strong>为NY（PA）/CPE或PET/NY（PA）/CPE。此产品具有防静电功能、抽真空效果佳、透明度高、透(氧)气率低、防潮性能好、抗拉强度与耐穿刺强度高、易热封、密封性好、不易老化等特点。</span></p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	&nbsp;</p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\"><strong>透明PE骨袋</strong>主要用于五金、电子元器件、有需要抽真空要求的包装等。尺寸、规格、耐高温性等都可按要求定做。PE骨袋还可根据客户要求，在不侵犯他人知识产权的情况下，印刷文字、图案、商标等，助您提升企业形象。</span></p>\r\n\r\n        ', '[{\"image\":\"/upfile/2017/11/1510641850984.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641850912.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641851410.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641852134.jpg\",\"desc\":\"\"}]');
INSERT INTO `sd_model_pro` VALUES ('6', '12', '0.00', '<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\">易洁包装提供的<strong>透明PE骨袋的材质</strong>为NY（PA）/CPE或PET/NY（PA）/CPE。此产品具有防静电功能、抽真空效果佳、透明度高、透(氧)气率低、防潮性能好、抗拉强度与耐穿刺强度高、易热封、密封性好、不易老化等特点。</span></p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	&nbsp;</p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\"><strong>透明PE骨袋</strong>主要用于五金、电子元器件、有需要抽真空要求的包装等。尺寸、规格、耐高温性等都可按要求定做。PE骨袋还可根据客户要求，在不侵犯他人知识产权的情况下，印刷文字、图案、商标等，助您提升企业形象。</span></p>\r\n\r\n        ', '[{\"image\":\"/upfile/2017/11/1510641854958.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641855283.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641856152.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641856985.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641857341.jpg\",\"desc\":\"\"}]');
INSERT INTO `sd_model_pro` VALUES ('7', '13', '0.00', '<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\">易洁包装提供的<strong>透明PE骨袋的材质</strong>为NY（PA）/CPE或PET/NY（PA）/CPE。此产品具有防静电功能、抽真空效果佳、透明度高、透(氧)气率低、防潮性能好、抗拉强度与耐穿刺强度高、易热封、密封性好、不易老化等特点。</span></p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	&nbsp;</p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\"><strong>透明PE骨袋</strong>主要用于五金、电子元器件、有需要抽真空要求的包装等。尺寸、规格、耐高温性等都可按要求定做。PE骨袋还可根据客户要求，在不侵犯他人知识产权的情况下，印刷文字、图案、商标等，助您提升企业形象。</span></p>\r\n\r\n        ', '[{\"image\":\"/upfile/2017/11/1510641860695.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641860150.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641861170.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641862760.jpg\",\"desc\":\"\"}]');
INSERT INTO `sd_model_pro` VALUES ('8', '14', '0.00', '<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\">易洁包装提供的<strong>透明PE骨袋的材质</strong>为NY（PA）/CPE或PET/NY（PA）/CPE。此产品具有防静电功能、抽真空效果佳、透明度高、透(氧)气率低、防潮性能好、抗拉强度与耐穿刺强度高、易热封、密封性好、不易老化等特点。</span></p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	&nbsp;</p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\"><strong>透明PE骨袋</strong>主要用于五金、电子元器件、有需要抽真空要求的包装等。尺寸、规格、耐高温性等都可按要求定做。PE骨袋还可根据客户要求，在不侵犯他人知识产权的情况下，印刷文字、图案、商标等，助您提升企业形象。</span></p>\r\n\r\n        ', '[{\"image\":\"/upfile/2017/11/1510641865403.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641866180.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641866579.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641867914.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641868961.jpg\",\"desc\":\"\"}]');
INSERT INTO `sd_model_pro` VALUES ('9', '15', '0.00', '<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\"><strong>纯铝立体袋材质结构</strong>PET/AL/CPE或PET/AL/NY(PA)/CPE（聚酯/铝膜/聚乙烯流延薄膜或聚酯/铝膜/尼龙膜/聚乙烯流延薄膜）两种三或四层结构，具有良好的防水，阻氧，避光的功能。整体颜色为铝箔颜色不透光。</span></p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	&nbsp;</p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\"><strong>纯铝立体袋可做成多种款式：</strong>平口袋式、自封式（密实袋/拉链袋）、信封式、信封自粘式、连体式、立体式等，袋身图案可根据客户要求印刷；内外表面电阻值：108&mdash;1011&Omega;。</span></p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	&nbsp;</p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\">纯铝立体袋适用于有防潮要求的电子产品包装：各类PC板、IC集成电路、光驱、硬盘、电子元器件等。</span></p>\r\n\r\n        ', '[{\"image\":\"/upfile/2017/11/1510641870470.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641871530.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641872254.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641873817.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641873391.jpg\",\"desc\":\"\"}]');
INSERT INTO `sd_model_pro` VALUES ('10', '16', '0.00', '<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\"><strong>纯铝立体袋材质结构</strong>PET/AL/CPE或PET/AL/NY(PA)/CPE（聚酯/铝膜/聚乙烯流延薄膜或聚酯/铝膜/尼龙膜/聚乙烯流延薄膜）两种三或四层结构，具有良好的防水，阻氧，避光的功能。整体颜色为铝箔颜色不透光。</span></p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	&nbsp;</p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\"><strong>纯铝立体袋可做成多种款式：</strong>平口袋式、自封式（密实袋/拉链袋）、信封式、信封自粘式、连体式、立体式等，袋身图案可根据客户要求印刷；内外表面电阻值：108&mdash;1011&Omega;。</span></p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	&nbsp;</p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\">纯铝立体袋适用于有防潮要求的电子产品包装：各类PC板、IC集成电路、光驱、硬盘、电子元器件等。</span></p>\r\n\r\n        ', '[{\"image\":\"/upfile/2017/11/1510641875860.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641876423.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641877473.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641878561.jpg\",\"desc\":\"\"}]');
INSERT INTO `sd_model_pro` VALUES ('11', '17', '0.00', '<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\"><strong>纯铝立体袋材质结构</strong>PET/AL/CPE或PET/AL/NY(PA)/CPE（聚酯/铝膜/聚乙烯流延薄膜或聚酯/铝膜/尼龙膜/聚乙烯流延薄膜）两种三或四层结构，具有良好的防水，阻氧，避光的功能。整体颜色为铝箔颜色不透光。</span></p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	&nbsp;</p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\"><strong>纯铝立体袋可做成多种款式：</strong>平口袋式、自封式（密实袋/拉链袋）、信封式、信封自粘式、连体式、立体式等，袋身图案可根据客户要求印刷；内外表面电阻值：108&mdash;1011&Omega;。</span></p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	&nbsp;</p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\">纯铝立体袋适用于有防潮要求的电子产品包装：各类PC板、IC集成电路、光驱、硬盘、电子元器件等。</span></p>\r\n\r\n        ', '[{\"image\":\"/upfile/2017/11/1510641880814.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641881770.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641882517.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641882926.jpg\",\"desc\":\"\"}]');
INSERT INTO `sd_model_pro` VALUES ('12', '18', '0.00', '<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\"><strong>纯铝立体袋材质结构</strong>PET/AL/CPE或PET/AL/NY(PA)/CPE（聚酯/铝膜/聚乙烯流延薄膜或聚酯/铝膜/尼龙膜/聚乙烯流延薄膜）两种三或四层结构，具有良好的防水，阻氧，避光的功能。整体颜色为铝箔颜色不透光。</span></p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	&nbsp;</p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\"><strong>纯铝立体袋可做成多种款式：</strong>平口袋式、自封式（密实袋/拉链袋）、信封式、信封自粘式、连体式、立体式等，袋身图案可根据客户要求印刷；内外表面电阻值：108&mdash;1011&Omega;。</span></p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	&nbsp;</p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\">纯铝立体袋适用于有防潮要求的电子产品包装：各类PC板、IC集成电路、光驱、硬盘、电子元器件等。</span></p>\r\n\r\n        ', '[{\"image\":\"/upfile/2017/11/1510641885914.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641885865.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641886317.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641887262.jpg\",\"desc\":\"\"}]');
INSERT INTO `sd_model_pro` VALUES ('13', '19', '0.00', '<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\"><strong>纯铝立体袋材质结构</strong>PET/AL/CPE或PET/AL/NY(PA)/CPE（聚酯/铝膜/聚乙烯流延薄膜或聚酯/铝膜/尼龙膜/聚乙烯流延薄膜）两种三或四层结构，具有良好的防水，阻氧，避光的功能。整体颜色为铝箔颜色不透光。</span></p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	&nbsp;</p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\"><strong>纯铝立体袋可做成多种款式：</strong>平口袋式、自封式（密实袋/拉链袋）、信封式、信封自粘式、连体式、立体式等，袋身图案可根据客户要求印刷；内外表面电阻值：108&mdash;1011&Omega;。</span></p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	&nbsp;</p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\">纯铝立体袋适用于有防潮要求的电子产品包装：各类PC板、IC集成电路、光驱、硬盘、电子元器件等。</span></p>\r\n\r\n        ', '[{\"image\":\"/upfile/2017/11/1510641889313.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641890889.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641891151.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641891290.jpg\",\"desc\":\"\"}]');
INSERT INTO `sd_model_pro` VALUES ('14', '20', '0.00', '<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\"><strong>纯铝立体袋材质结构</strong>PET/AL/CPE或PET/AL/NY(PA)/CPE（聚酯/铝膜/聚乙烯流延薄膜或聚酯/铝膜/尼龙膜/聚乙烯流延薄膜）两种三或四层结构，具有良好的防水，阻氧，避光的功能。整体颜色为铝箔颜色不透光。</span></p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	&nbsp;</p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\"><strong>纯铝立体袋可做成多种款式：</strong>平口袋式、自封式（密实袋/拉链袋）、信封式、信封自粘式、连体式、立体式等，袋身图案可根据客户要求印刷；内外表面电阻值：108&mdash;1011&Omega;。</span></p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	&nbsp;</p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\">纯铝立体袋适用于有防潮要求的电子产品包装：各类PC板、IC集成电路、光驱、硬盘、电子元器件等。</span></p>\r\n\r\n        ', '[{\"image\":\"/upfile/2017/11/1510641894960.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641894582.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641895803.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641896151.jpg\",\"desc\":\"\"}]');
INSERT INTO `sd_model_pro` VALUES ('15', '21', '0.00', '<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\"><strong>纯铝立体袋材质结构</strong>PET/AL/CPE或PET/AL/NY(PA)/CPE（聚酯/铝膜/聚乙烯流延薄膜或聚酯/铝膜/尼龙膜/聚乙烯流延薄膜）两种三或四层结构，具有良好的防水，阻氧，避光的功能。整体颜色为铝箔颜色不透光。</span></p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	&nbsp;</p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\"><strong>纯铝立体袋可做成多种款式：</strong>平口袋式、自封式（密实袋/拉链袋）、信封式、信封自粘式、连体式、立体式等，袋身图案可根据客户要求印刷；内外表面电阻值：108&mdash;1011&Omega;。</span></p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	&nbsp;</p>\r\n<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); font-family: \'Microsoft YaHei\'; line-height: 24px;\">\r\n	<span style=\"font-size: 14px; line-height: 2;\">纯铝立体袋适用于有防潮要求的电子产品包装：各类PC板、IC集成电路、光驱、硬盘、电子元器件等。</span></p>\r\n\r\n        ', '[{\"image\":\"/upfile/2017/11/1510641898678.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641899390.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641900852.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641900932.jpg\",\"desc\":\"\"}]');
INSERT INTO `sd_model_pro` VALUES ('16', '22', '168.00', '<p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); line-height: 24px; font-family: &quot;Microsoft YaHei&quot;;\"><span style=\"line-height: 2; font-size: 14px;\"><strong>纯铝立体袋材质结构</strong>PET/AL/CPE或PET/AL/NY(PA)/CPE（聚酯/铝膜/聚乙烯流延薄膜或聚酯/铝膜/尼龙膜/聚乙烯流延薄膜）两种三或四层结构，具有良好的防水，阻氧，避光的功能。整体颜色为铝箔颜色不透光。</span></p><p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); line-height: 24px; font-family: &quot;Microsoft YaHei&quot;;\">\r\n	&nbsp;</p><p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); line-height: 24px; font-family: &quot;Microsoft YaHei&quot;;\"><span style=\"line-height: 2; font-size: 14px;\"><strong>纯铝立体袋可做成多种款式：</strong>平口袋式、自封式（密实袋/拉链袋）、信封式、信封自粘式、连体式、立体式等，袋身图案可根据客户要求印刷；内外表面电阻值：108&amp;mdash;1011&amp;Omega;。</span></p><p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); line-height: 24px; font-family: &quot;Microsoft YaHei&quot;;\">\r\n	&nbsp;</p><p style=\"margin: 0px; padding: 0px; color: rgb(102, 102, 102); line-height: 24px; font-family: &quot;Microsoft YaHei&quot;;\"><span style=\"line-height: 2; font-size: 14px;\">纯铝立体袋适用于有防潮要求的电子产品包装：各类PC板、IC集成电路、光驱、硬盘、电子元器件等。</span></p>', '[{\"image\":\"/upfile/2017/11/1510641903852.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641904530.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641904195.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641905855.jpg\",\"desc\":\"\"},{\"image\":\"/upfile/2017/11/1510641906300.jpg\",\"desc\":\"\"}]');
INSERT INTO `sd_tags` VALUES ('1', '产品', '4');
INSERT INTO `sd_temp_mail` VALUES ('1', '留言提醒', '有一条新的留言需要处理', '<p>姓　名：$name<br/>手　机：$mobile<br/>电　话：$tel<br/>内　容：$remark</p>', '1', 'book');
INSERT INTO `sd_temp_mail` VALUES ('2', '询价提醒', '有一条新的询价需要处理', '<p>产　品：$proname<br/>姓　名：$name<br/>手　机：$mobile<br/>备　注：$remark</p>', '1', 'inquiry');
INSERT INTO `sd_temp_mail` VALUES ('3', '订单提醒', '有一条新的订单需要处理', '<p>订单号：$orderid<br/>产　品：$proname<br/>数　量：$num<br/>金　额：$money<br/>姓　名：$name<br/>手　机：$mobile<br/>地　址：$address<br/>备　注：$remark</p>', '1', 'order');
INSERT INTO `sd_temp_mail` VALUES ('4', '用户注册', '账号注册邮箱验证', '<p>您正在进行【注册账户】邮箱验证：<br/>您的验证码是：$code<br/>如本邮件非您操作响应，请忽略。</p>', '1', 'reg');
INSERT INTO `sd_temp_mail` VALUES ('5', '找回密码', '账户找回密码邮箱验证', '<p>您正在进行【找回密码】邮箱验证：<br/>您的验证码是：$code<br/>如本邮件非您操作响应，请忽略。</p>', '1', 'getpass');
INSERT INTO `sd_user_group` VALUES ('1', '普通会员', '0');
INSERT INTO `sd_user_group` VALUES ('2', 'Vip会员', '0');
