# Learning Resources Repository

[English](README.md) | [中文](docs/README.zh.md)

Welcome to the **Learning Resources Repository**! This repository is designed to offer a comprehensive collection of curated resources across various fields to support your personal and professional development. Whether you're a student, professional, or just curious, you'll find valuable materials to help you enhance your skills and knowledge.

## 📚 Contents

1. [Frontend Development](#-frontend-development)
2. [Backend Development](#-backend-development)
3. [Mobile Development](#mobile-development)


4. [Product Design](#product-design)
5. [Programming Basics](#programming-basics)
6. [Personal Development](#-personal-development)
7. [Spatial Computing](#spatial-computing)
8. [Machine Learning](#-machine-learning)


---

## 🌐 Frontend Development

Explore resources for mastering frontend development, from beginner to advanced levels. Find tutorials, courses, and books that cover HTML, CSS, JavaScript, and more.

- [**Beginner Level**](./FrontendDevelopment/Frontend.md/#-beginner-level)
- [**Intermediate Level**](./FrontendDevelopment/Frontend.md/#-intermediate-level)
- [**Advanced Level**](./FrontendDevelopment/Frontend.md/#-advanced-level)

## 💻 Backend Development

Discover resources for backend development, including server-side languages, databases, and APIs. This section includes guides for different skill levels.

- [**Beginner Level**](./BackendDevelopment/Backend.md/#-beginner-level)
- [**Intermediate Level**](./BackendDevelopment//Backend.md/#-intermediate-level)
- [**Advanced Level**](./BackendDevelopment//Backend.md/#-advanced-level)

## 📱Mobile Development

Access resources for mobile development, including iOS and Android platforms. Find tutorials, courses, blogs and communities to help you build mobile apps.
Access resources for mobile development, including iOS and Android platforms. Find tutorials, courses, blogs and communities to help you build mobile apps.

- [**Beginners Level**](./MobileDevelopment//MobileDevelopment.md/#-beginners-level)
- [**Intermediate Level**](./MobileDevelopment//MobileDevelopment.md/#-intermediate-level)
- [**Advanced Level**](./MobileDevelopment//MobileDevelopment.md/#-advanced-level)

## 🎨Product Design


Access resources for product design. Find tutorials, courses, blogs and communities to help you design and curate excellent user experience.


- [**Beginners level**](./ProductDesign//ProductDesign.md/#getting-started)
- [**Intermediate level**](./ProductDesign//ProductDesign.md/#prototyping--design-tools)
- [**Advanced level**](./ProductDesign//ProductDesign.md.md/#design-systems--ui-kits)

## 👨‍💻Programming Basics


Access resources to help you kickstart your programming journey. Find tutorials to the 10 most popular programming languages.


- [**Beginners level**](./ProgrammingBasics//ProgrammingBasics.md)

## 🧠 Personal Development

Access a range of materials for personal growth, including goal setting, productivity, and emotional intelligence. Resources are available for various stages of personal development.

- [**Beginner Level**](./personalDevelopment/personaldevelopment/#-beginner-level)
- [**Intermediate Level**](./personalDevelopment/personaldevelopment/#-intermediate-level)
- [**Advanced Level**](./personalDevelopment/personaldevelopment/#-advanced-level)
- [**Books**](./personalDevelopment/personaldevelopment/#-books)


## Spatial Computing

Spatial computing is any of various human–computer interaction techniques that are perceived by users as taking place in the real world, in and around their natural bodies and physical environments, instead of constrained to and perceptually behind computer screens. 

Kickstart a career in Spatial Computing with the aid of these learning resources:

- [**Articles**](./SpatialComputing/resources.md/#-articles)
- [**Courses**](./SpatialComputing/resources.md/#-courses)
- [**Communities**](./SpatialComputing/resources.md/#-communities)
- 
- 
## 🤖 Machine Learning

Access a range of materials of machine learning ranging from videos, courses, books to make you better.

- [**Beginner Level**](./MachineLearning/MachineLearning.md/#-beginner-level)
- [**Intermediate Level**](./MachineLearning/MachineLearning.md/#-intermediate-level)
- [**Advanced Level**](./MachineLearning/MachineLearning.md/#-advanced-level)
- [**Books**](./MachineLearning/MachineLearning.md/#-books)

## 🖊️ Technical Writing

Get access to different ranges of learning resources from videos, courses, tools to books in order to increase your productivity as a technical writer.

- [**Beginners Level**](./TechnicalWriting/TechnicalWriting.md/#-beginners-level)
- [**Intermediate Level**](./TechnicalWriting/TechnicalWriting.md/#-intermediate-level)
- [**Advanced Level**](./TechnicalWriting/TechnicalWriting.md/#-advanced-level)


## 🖊️ Technical Writing

Get access to different ranges of learning resources from videos, courses, tools to books in order to increase your productivity as a technical writer.

- [**Beginners Level**](./TechnicalWriting/TechnicalWriting.md/#-beginners-level)
- [**Intermediate Level**](./TechnicalWriting/TechnicalWriting.md/#-intermediate-level)
- [**Advanced Level**](./TechnicalWriting/TechnicalWriting.md/#-advanced-level)


---

## 🤝 Contributions


We welcome contributions to make this repository even more valuable! If you have resources to add or improvements to suggest, please refer to our [CONTRIBUTING.md](./CONTRIBUTING.md) file for guidelines.

### Contributors


<a href="https://github.com/SCA-OAU/LearnLink/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=SCA-OAU/LearnLink" />
</a>

Made with [contrib.rocks](https://contrib.rocks).

## 📧 Support


Don't forget to star ⭐ this repo if you find this helpful

---

## 📑 License


This project is licensed under the MIT License - see the [license](./LICENSE.md) file for details.

---

Thank you for visiting and happy learning! 🚀
