# 🎨Product Design Resources

Welcome to the **Product Design Resources** Hub! Whether you're just starting out in product design or looking to enhance your skills, this hub provides valuable resources to help you on your journey. Below, you'll find resources categorized by topics such as **UI/UX Design**, **Prototyping Tools**, **Design Systems**, and more.

## 📝Table of Content
1. [Getting Started](#getting-started)
2. [Prototyping & Design Tools](#prototyping--design-tools)
3. [Visual Design & Branding](#visual-design--branding)
4. [Design Systems & UI Kits](#design-systems--ui-kits)
5. [User Research & Usability Testing](#user-research--usability-testing)
6. [Design Communities & Inspiration](#design-communities--inspiration)
7. [Books to Read](#books-to-read)
8. [Additional Resources](#additional-resources)
9. [Contributing](#contributing)

## Getting Started
**Courses & Tutorials**
- **[Getting started in UI/UX Design](https://drive.google.com/drive/u/0/folders/19WIKvM2iqyq9OKustKNJaNMk3XDBRZHL)**
- **[Udacity Product Design](https://tinyurl.com/yx2pxcp9)**
- **[Linkedin Learning](https://tinyurl.com/2p9ujdct)**
- **[Perxel course](http://perxels.com)**
- **[Interaction Design Foundation](https://www.interaction-design.org/)**
- **[Coursera - UI/UX Design Specialization](https://www.coursera.org/specializations/ui-ux-design)**
- **[Google UX Design Professional Certificate](https://grow.google/certificates/ux-design/)**- A highly recommended course that focuses on real-world UX projects.

**Design Blogs & Magazines**
- **[Smashing Magazine](https://www.smashingmagazine.com/)**- Stay updated with the latest articles on design, UX, coding, and digital trends.
- **[UX Collective](https://uxdesign.cc/)**- A community-driven publication featuring top UX/UI design articles and case studies.
- **[NN Group (Nielsen Norman Group)](https://www.nngroup.com/articles/)**- Research-backed articles on user experience, usability, and accessibility.

**UX Case Studies**
- **[Case Study Club](https://www.casestudy.club/)**- Collection of in-depth case studies on product design and UX projects.
- **[UX Planet](https://uxplanet.org/tagged/case-study)**- Learn from detailed UX case studies and insights on product design projects.

## Prototyping & Design Tools

 1. **Prototyping Tools**
- **[Figma](https://www.figma.com/)**
  - Cloud-based design and prototyping tool. Great for real-time collaboration and wireframing.
- **[Adobe XD](https://www.adobe.com/products/xd.html)**
  - A powerful tool for wireframing, prototyping, and design collaboration.
- **[Sketch](https://www.sketch.com/)**
  - One of the most popular tools for designing user interfaces, especially on macOS.
- **[InVision](https://www.invisionapp.com/)**
  - Focused on prototyping and user flows, InVision provides features for design collaboration.

2. **Wireframing Tools**
- **[Balsamiq](https://balsamiq.com/)**
  - Simple, drag-and-drop wireframing tool that mimics low-fidelity sketching.
- **[Wireframe.cc](https://wireframe.cc/)**
  - Minimal and focused web app for quick wireframes.

3. **Collaboration & Handoff Tools**
- **[Zeplin](https://zeplin.io/)**
  - Helps designers hand off designs to developers by generating specs and assets.
- **[Avocode](https://avocode.com/)**
  - Organizes design files, provides version control, and makes it easier to hand off designs to developers.

## Visual Design & Branding

1. **Color Tools**
- **[Coolors](https://coolors.co/)**
  - Generate beautiful color palettes for your designs.
- **[Adobe Color](https://color.adobe.com/)**
  - Create, browse, and save color schemes, or explore trending palettes.
- **[Color Hunt](https://colorhunt.co/)**
  - A curated collection of beautiful color palettes for designers.

2. **Typography**
- **[Google Fonts](https://fonts.google.com/)**
  - A collection of free, open-source fonts available for use in web and print design.
- **[Fontpair](https://fontpair.co/)**
  - Pairing recommendations for Google fonts, perfect for typography choices in your design projects.
- **[Fonts in Use](https://fontsinuse.com/)**
  - Examples of how fonts are used in real-world applications.

3. **Illustrations & Icons**
- **[unDraw](https://undraw.co/)**
  - Open-source illustrations that can be customized and used in design projects.
- **[Icon8](https://icons8.com/icons)**  
  - A comprehensive library of free icons, illustrations, and stock photos.
- **[Feather Icons](https://feathericons.com/)**
  - A collection of simply designed open-source icons.

## Design Systems & UI Kits

1. **Design Systems**
- **[Carbon Design System](https://www.carbondesignsystem.com/)**
  - IBM's open-source design system for products and digital experiences.
- **[Material Design](https://material.io/design)**
  - Google’s design system that guides the creation of intuitive, accessible products.
- **[Apple Human Interface Guidelines](https://developer.apple.com/design/human-interface-guidelines/)**
  - Best practices for creating intuitive apps that adhere to Apple’s design guidelines.

2. **UI Kits**
- **[Figma Freebies](https://www.figma.com/community)**
  - Free community-made design templates and UI kits available within Figma.
- **[Sketch App Resources](https://www.sketchappsources.com/)**
  - A wide variety of UI kits, icons, and templates for Sketch users.
- **[Adobe XD Resources](https://www.adobe.com/products/xd/resources.html)**
  - UI kits, wireframes, and icons for Adobe XD.

## User Research & Usability Testing

1. **User Research Tools**
- **[Lookback](https://lookback.io/)**
  - A tool for conducting live, remote user research and interviews.
- **[UserTesting](https://www.usertesting.com/)**
  - Real-time feedback on prototypes and products from users.
- **[Maze](https://maze.design/)**
  - A user testing platform for validating prototypes and gathering actionable insights.

2. **Surveys & Feedback**
- **[Google Forms](https://www.google.com/forms/about/)**
  - Simple, free tool for creating surveys and collecting user feedback.
- **[Typeform](https://www.typeform.com/)**
  - Beautifully designed forms and surveys that can help collect qualitative feedback.
- **[SurveyMonkey](https://www.surveymonkey.com/)**
  - A powerful tool for creating in-depth surveys to gather insights from users.

## Design Communities & Inspiration

1. **Design Communities**
- **[Dribbble](https://dribbble.com/)**
  - A community for showcasing your design work and finding inspiration.
- **[Behance](https://www.behance.net/)**
  - An Adobe-owned platform where designers share their portfolios and discover creative work.
- **[Designer Hangout](https://www.designerhangout.co/)**
  - A Slack-based community where UX designers connect, share resources, and collaborate.

2. **Inspiration Sites**
- **[Awwwards](https://www.awwwards.com/)**
  - A collection of the best web designs from around the world, featuring creative UX/UI.
- **[Land-book](https://land-book.com/)**
  - Discover and explore landing page designs for inspiration.
- **[Lapa Ninja](https://www.lapa.ninja/)**
  - A great resource for browsing beautiful landing page designs and product inspiration.

## Books to Read

- **[Don't Make Me Think by Steve Krug](https://www.amazon.com/Dont-Make-Me-Think-Usability/dp/0321965515)**
  - A classic on web usability and user-centered design principles.
- **[The Design of Everyday Things by Don Norman](https://www.amazon.com/Design-Everyday-Things-Revised-Expanded/dp/0465050654)**
  - This book explains the principles of design from a user-centric perspective.
- **[Sprint by Jake Knapp](https://www.thesprintbook.com/)**
  - Learn how to solve big problems and test new ideas in just five days.

## Additional Resources

- **[UX Design Master Checklist](https://www.uxchecklist.github.io/)**
  - A comprehensive checklist to ensure every design element is covered in your UX project.
- **[Canva Design School](https://designschool.canva.com/)**
  - Free tutorials and articles on the basics of design, branding, and visual communication.
- **[Laws of UX](https://lawsofux.com/)**
  - A collection of principles and guidelines for building better, more intuitive user experiences.

## Contributing
Feel free to contribute to this resource hub by submitting additional tools, courses, or resources that can help fellow designers. Please check out the [CONTRIBUTING.md](../CONTRIBUTING.md) file for guidelines on how to add more resources to this repository.

This hub is curated with love for the design community. Happy designing! 🎨💻✨










