# DevOps Learning Resources

Welcome to the **DevOps Learning Resources** repository! This repository provides a curated list of resources for DevOps, from fundamental concepts to advanced topics. Whether you're just starting out or aiming to refine your skills, you'll find valuable materials here.

## 📑 Table of Contents
1. [Beginner Level](#-beginner-level)
2. [Intermediate Level](#-intermediate-level)
3. [Advanced Level](#-advanced-level)
4. [Tools & Resources](#-tools--resources)
5. [Contribute](#-contribute)

---

## 🟢 Beginner Level

Start with the fundamentals of DevOps, Linux, Git and Bash Scripting.

### Courses & Tutorials:
- [**Introduction to DevOps**](https://www.datacamp.com/courses/devops-concepts) - **datacamp**: DevOps Concepts.
- [**Linux**](https://www.freecodecamp.org/news/introduction-to-linux/) - **freecodecamp**: Introduction to Linux.
- [**Git and Version Control**](https://www.datacamp.com/courses/introduction-to-git) - **datacamp**: Learn Git.
- [**Bash Scripting**](https://www.datacamp.com/courses/introduction-to-bash-scripting) - **datacamp**: Introduction to Bash Scripting.
- [**Cloud Platforms**](https://youtu.be/Vnk0p-63mHQ?si=4_L_je98VwR5WEzr) - **YouTube**: Overview of Various Cloud Platforms.


---

## 🟠 Intermediate Level

Explore more advanced DevOps practices such as Ansible, Terraform, Docker and Docker Compose.

### Courses & Tutorials:
- [**Ansible**](https://www.youtube.com/watch?v=3RiVKs8GHYQ&list=PLT98CRl2KxKEUHie1m24-wkyHpEsa4Y70) - **YouTube**: Getting Started with Ansible.
- [**Docker**](https://youtu.be/pg19Z8LL06w?si=vhUEKlorObUs-WpR) - **YouTube**: Docker Crash Course for Absolute Beginners.
- [**Docker Compose**](https://youtu.be/SXwC9fSwct8?si=tsm2_FnN8VkjUSXy) - **YouTube**:  Ultimate Docker Compose.
- [**Terraform**](https://youtu.be/7xngnjfIlK4?si=swuG5djNoX_R-r4h) - **YouTube**:  Complete Terraform Course.

---

## 🔴 Advanced Level

Focus on Orchestration, Monitoring and Observability, CI/CD Pipelines, and DevSecOps.

### Courses & Tutorials:
 [**Kubernetes**](https://youtu.be/X48VuDVv0do?si=ya4BnTZU-_hVoDuk) - **YouTube**: Kubernetes Tutorial for Beginners.

- [**Continuous Integration and Continuous Deployment**](https://www.redhat.com/en/topics/devops/what-is-ci-cd) - **RedHat**: What is CI/CD.

- [**Monitoring and Logging**](https://youtu.be/9TJx7QTrTyo?si=n3KZ_1ZdqRUOiUtM) - **YouTube**:  Server Monitoring // Prometheus and Grafana Tutorial .

- [**DevSecOps**](https://learn.kodekloud.com/courses/devsecops-kubernetes-devops-security) - **KodeKloud**: DevOps & Security.



---

## 🤝 Contribute

Want to add a resource? Contributions are welcome! Please check out the [CONTRIBUTING.md](../CONTRIBUTING.md) file for guidelines on how to contribute.

---

Feel free to explore and share with your community! 🚀