# GoLang

### 1. Basic Operators
  * \+
  * \-
  * \*
  * /
  * %
  * ++
  * --
  * =
  * +=
  * -=
  * *=
  * /=
  * %=
  * <<=
  * \>>=
  * &=
  * ^=
  * |=

### 2. Conditions
  * ==
  * !=
  * \>
  * \<
  * \>=
  * <=

### 3. Data Types
  * String
  * Boolean
  * Int
  * Int8
  * Int16
  * Int32
  * Int64
  * uInt
  * UInt8
  * Uint16
  * UInt32
  * UInt64
  * UIntptr
  * Byte
  * Rune
  * Float32
  * Float64
  * Complex64
  * Complex128

### 4. Strings
  * \\'
  * \\"
  * \\\
  * \n
  * \r
  * \t
  * \b
  * \ooo
  * \xhhh
  * Subscripting (Indexing)
  * Slicing
  * Sprintf
  * Sscanf
  * Fscanf
  * Scanf

### 5. List
  * `New()`
  * `Init()`
  * `Back()`
  * `Front()`
  * `InsertAfter()`
  * `Len()`
  * `MoveAfter()`
  * `MoveBefore()`
  * `MoveToBack()`
  * `PushBack()`
  * `PushBackList()`
  * `PushFront()`
  * `PushFrontList()`
  * `Remove()`

### 6. Array
  * `Len()`

### 7. Slice
  * `Len()`
  * `cap()`
  * `copy()`
  * `make()`
  * `append()`

### 8. Structs
  * Attributes
  * Methods
  * Composition

### 9. Statements
  * import
  * package
  * if
  * else if
  * else
  * for
  * return
  * defer
  * break
  * goto
  * continue
  * func
  * const

### 10. Basic Functions
  * `print()`
  * `println()`
  * `type()`
  * `error()`
  * `new()`
  * `panic()`
  * `close()`
  * `recover()`

### 11. Effective Go Style Guide
  * Format code according to Effective Go page on goland.org

### 11. Tasks
  * Create variables
  * Cast variables
  * Utilize Nested loops
  * Import packages
  * Read and write to a file
  * Create Functions
  * Function recursion
  * Create a struct with attributes and methods
