# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/)
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [v3.3.5](https://github.com/RobBrazier/svelte-awesome/compare/v3.3.4...v3.3.5)

### Commits

- update dev dependencies to latest compatible versions for svelte 5 [`110eb3d`](https://github.com/RobBrazier/svelte-awesome/commit/110eb3d607f2c6b82d942311b796000b9f66c74b)
- fix: update peerDependencies to support svelte 5 now it's released [`36037df`](https://github.com/RobBrazier/svelte-awesome/commit/36037dff562a0db491d9cd0cbbb0c9c721db9f67)

## [v3.3.4](https://github.com/RobBrazier/svelte-awesome/compare/v3.3.3...v3.3.4) - 2024-09-09

### Commits

- fix: revert peerDependencies change until further testing is done [`bb4f931`](https://github.com/RobBrazier/svelte-awesome/commit/bb4f931460eda1b69266d50ccbce3b12f23738be)

## [v3.3.3](https://github.com/RobBrazier/svelte-awesome/compare/v3.3.2...v3.3.3) - 2024-09-09

### Merged

- fix: update peerDependencies so that it can be installed on svelte 5 [`#1172`](https://github.com/RobBrazier/svelte-awesome/pull/1172)

## [v3.3.2](https://github.com/RobBrazier/svelte-awesome/compare/v3.3.1...v3.3.2) - 2024-09-09

### Merged

- chore(deps-dev): bump the svelte group across 1 directory with 3 updates [`#1170`](https://github.com/RobBrazier/svelte-awesome/pull/1170)
- chore: upgrade dependencies in preparation for svelte 5 [`#1165`](https://github.com/RobBrazier/svelte-awesome/pull/1165)
- chore(deps-dev): bump change-case from 5.4.0 to 5.4.2 [`#1067`](https://github.com/RobBrazier/svelte-awesome/pull/1067)
- chore(deps-dev): bump the linting across 1 directories with 1 update [`#1066`](https://github.com/RobBrazier/svelte-awesome/pull/1066)
- chore(deps-dev): bump the svelte across 1 directories with 2 updates [`#1065`](https://github.com/RobBrazier/svelte-awesome/pull/1065)
- chore(deps-dev): bump @sveltejs/kit from 1.30.3 to 2.2.0 [`#1064`](https://github.com/RobBrazier/svelte-awesome/pull/1064)
- chore: create dependabot.yml [`#1063`](https://github.com/RobBrazier/svelte-awesome/pull/1063)

### Commits

- Update dependabot.yml [`160354d`](https://github.com/RobBrazier/svelte-awesome/commit/160354d3b42dd61f033ca6baf654f761fc553c9e)

## [v3.3.1](https://github.com/RobBrazier/svelte-awesome/compare/v3.3.0...v3.3.1) - 2024-01-05

### Merged

- Add svelte options tag to fix rendering in Svelte 5 [`#1060`](https://github.com/RobBrazier/svelte-awesome/pull/1060)
- chore: shrink generated code [`#1058`](https://github.com/RobBrazier/svelte-awesome/pull/1058)

### Commits

- Run prettier [`cd36ab1`](https://github.com/RobBrazier/svelte-awesome/commit/cd36ab1d4ec568c9e305ee284e58a7f7b0962ed7)

## [v3.3.0](https://github.com/RobBrazier/svelte-awesome/compare/v3.2.1...v3.3.0) - 2023-12-01

### Merged

- chore(deps): update svelte (major) [`#1034`](https://github.com/RobBrazier/svelte-awesome/pull/1034)
- chore: readme updates [`#1038`](https://github.com/RobBrazier/svelte-awesome/pull/1038)
- chore(deps): update dependency release-it to v16 [`#1033`](https://github.com/RobBrazier/svelte-awesome/pull/1033)
- chore(deps): update linting to v3 (major) [`#1027`](https://github.com/RobBrazier/svelte-awesome/pull/1027)
- chore(deps): update svelte [`#1028`](https://github.com/RobBrazier/svelte-awesome/pull/1028)
- added search functionality [`#1007`](https://github.com/RobBrazier/svelte-awesome/pull/1007)

### Commits

- fix: update package.json to be compatible with latest svelte and svelte-package versions [`58cbb5e`](https://github.com/RobBrazier/svelte-awesome/commit/58cbb5e0e2032f10573f3b236f8c1e5987c14a50)
- prettier format [`a7ca68a`](https://github.com/RobBrazier/svelte-awesome/commit/a7ca68a0004c885c1143df0c2c4b6d23fc8cb2d8)
- Add renovate.json [`1a4692a`](https://github.com/RobBrazier/svelte-awesome/commit/1a4692a2e1ce3ac9187a7a2db28268fa8fabf130)
- fix: npm publishing uses new package.json [`edc718a`](https://github.com/RobBrazier/svelte-awesome/commit/edc718af7c46130e623bf20cf7359325b44cc6df)

## [v3.2.1](https://github.com/RobBrazier/svelte-awesome/compare/v3.2.0...v3.2.1) - 2023-06-22

### Merged

- add Svelte 4 to peerDependencies [`#985`](https://github.com/RobBrazier/svelte-awesome/pull/985)
- chore(deps-dev): bump svelte-preprocess from 5.0.1 to 5.0.3 [`#972`](https://github.com/RobBrazier/svelte-awesome/pull/972)

## [v3.2.0](https://github.com/RobBrazier/svelte-awesome/compare/v3.1.0...v3.2.0) - 2023-03-17

### Merged

- handle additional properties e.g. aria-hidden and pass to svg element [`#966`](https://github.com/RobBrazier/svelte-awesome/pull/966)

### Fixed

- handle additional properties e.g. aria-hidden and pass to svg element - fixes #965 [`#965`](https://github.com/RobBrazier/svelte-awesome/issues/965)

## [v3.1.0](https://github.com/RobBrazier/svelte-awesome/compare/v3.0.1...v3.1.0) - 2023-03-05

### Merged

- chore(deps-dev): bump svelte-highlight from 6.2.1 to 7.2.0 [`#964`](https://github.com/RobBrazier/svelte-awesome/pull/964)
- Sveltekit upgrade and optimisations [`#958`](https://github.com/RobBrazier/svelte-awesome/pull/958)
- chore(deps-dev): bump gh-release from 6.0.4 to 7.0.2 [`#947`](https://github.com/RobBrazier/svelte-awesome/pull/947)
- chore(deps): bump minimatch from 3.0.4 to 3.1.2 [`#939`](https://github.com/RobBrazier/svelte-awesome/pull/939)

### Commits

- format files to be compliant with prettier and add examples for v6 as well as v5 [`1256232`](https://github.com/RobBrazier/svelte-awesome/commit/1256232cc97341bcd540567698f441b7b80990af)
- Upgrade sveltekit out of alpha version and optimise code a bit to be less hacky [`2524d98`](https://github.com/RobBrazier/svelte-awesome/commit/2524d98c16c3f7d49af482651f0df3d1b0c0a1ff)
- clean up devDependencies to remove a bunch of stuff dependabot added [`0a10314`](https://github.com/RobBrazier/svelte-awesome/commit/0a10314c31e4f5bcf4832e260dcad3fbf9f5009a)
- migration to @sveltejs/package v2 [`3f1b832`](https://github.com/RobBrazier/svelte-awesome/commit/3f1b832d8b9313c3f652f71016881f373a0fdb30)
- add typing to flip option [`f4c2dae`](https://github.com/RobBrazier/svelte-awesome/commit/f4c2dae9c3a9a4c4f363729407b046c11fc9c16e)
- fix devcontainer to work with docker [`6d2e124`](https://github.com/RobBrazier/svelte-awesome/commit/6d2e12409558197dfe0cb49cce6a614c3859cbcb)
- svelte-migrate: renamed files [`20795a5`](https://github.com/RobBrazier/svelte-awesome/commit/20795a5c42a5fbc112272166b7ffe718a0b99e7c)

## [v3.0.1](https://github.com/RobBrazier/svelte-awesome/compare/v3.0.0...v3.0.1) - 2022-12-01

### Merged

- fix: #187 remove non-unique ids from `path` and `polygon` [`#930`](https://github.com/RobBrazier/svelte-awesome/pull/930)
- chore(deps-dev): bump svelte from 3.50.1 to 3.53.1 [`#938`](https://github.com/RobBrazier/svelte-awesome/pull/938)
- chore(deps-dev): bump tslib from 2.4.0 to 2.4.1 [`#923`](https://github.com/RobBrazier/svelte-awesome/pull/923)
- chore(deps-dev): bump eslint-plugin-svelte3 from 3.4.1 to 4.0.0 [`#885`](https://github.com/RobBrazier/svelte-awesome/pull/885)
- chore(deps-dev): bump @sveltejs/kit from 1.0.0-next.324 to 1.0.0-next.347 [`#882`](https://github.com/RobBrazier/svelte-awesome/pull/882)

## [v3.0.0](https://github.com/RobBrazier/svelte-awesome/compare/v2.4.6...v3.0.0) - 2022-05-03

### Merged

- BREAKING: restructure icon names and files to be more consistent and add icons index page [`#877`](https://github.com/RobBrazier/svelte-awesome/pull/877)
- chore(deps-dev): bump svelte-highlight from 5.2.2 to 6.0.1 [`#853`](https://github.com/RobBrazier/svelte-awesome/pull/853)
- chore(deps-dev): bump @sveltejs/kit from 1.0.0-next.295 to 1.0.0-next.324 [`#864`](https://github.com/RobBrazier/svelte-awesome/pull/864)
- chore(deps-dev): bump svelte-check from 2.4.5 to 2.4.6 [`#857`](https://github.com/RobBrazier/svelte-awesome/pull/857)
- chore(deps-dev): bump gh-release from 6.0.1 to 6.0.3 [`#855`](https://github.com/RobBrazier/svelte-awesome/pull/855)
- chore(deps): bump minimist from 1.2.5 to 1.2.6 [`#856`](https://github.com/RobBrazier/svelte-awesome/pull/856)
- chore(deps-dev): bump svelte from 3.46.4 to 3.46.6 [`#852`](https://github.com/RobBrazier/svelte-awesome/pull/852)
- chore(deps-dev): bump @typescript-eslint/parser from 5.13.0 to 5.17.0 [`#851`](https://github.com/RobBrazier/svelte-awesome/pull/851)

### Commits

- fix example after highlight.js upgrade [`3ad7b8f`](https://github.com/RobBrazier/svelte-awesome/commit/3ad7b8fe7faceb41c4235ffd1d7cbb91c07e61fc)

## [v2.4.6](https://github.com/RobBrazier/svelte-awesome/compare/v2.4.5...v2.4.6) - 2022-03-11

### Commits

- fix package path [`4bf1577`](https://github.com/RobBrazier/svelte-awesome/commit/4bf1577560bf9e88649569d8b2d4ee0e535f2bf9)

## [v2.4.5](https://github.com/RobBrazier/svelte-awesome/compare/v2.4.4...v2.4.5) - 2022-03-11

### Merged

- Upgrade svelte kit [`#848`](https://github.com/RobBrazier/svelte-awesome/pull/848)
- chore(deps-dev): bump @sveltejs/kit from 1.0.0-next.240 to 1.0.0-next.252 [`#825`](https://github.com/RobBrazier/svelte-awesome/pull/825)

### Commits

- non-functional change to validate github actions pipeline [`9c97fc8`](https://github.com/RobBrazier/svelte-awesome/commit/9c97fc80735d672ff04365ba2b05cde3159bee50)
- apply svelte-kit configuration recommendations [`0cd6054`](https://github.com/RobBrazier/svelte-awesome/commit/0cd605474225b5010f7ef7a8fe99276e4b240388)
- remove config.kit.target from svelte.config.js as no longer required [`897d67d`](https://github.com/RobBrazier/svelte-awesome/commit/897d67d24ac52eb5faedbe8ebbb55e144d611c6b)

## [v2.4.4](https://github.com/RobBrazier/svelte-awesome/compare/v2.4.3...v2.4.4) - 2022-01-25

### Commits

- fix invalid peerDependencies [`b38d38a`](https://github.com/RobBrazier/svelte-awesome/commit/b38d38a0157da4c7e5b6bf22829af8c61502f8cd)

## [v2.4.3](https://github.com/RobBrazier/svelte-awesome/compare/v2.4.2...v2.4.3) - 2022-01-23

### Merged

- Explictly calls out use of camelCase for imports [`#820`](https://github.com/RobBrazier/svelte-awesome/pull/820)
- chore(deps-dev): bump svelte-highlight from 4.0.0 to 5.1.2 [`#798`](https://github.com/RobBrazier/svelte-awesome/pull/798)
- chore(deps-dev): bump @sveltejs/kit from 1.0.0-next.179 to 1.0.0-next.192 [`#793`](https://github.com/RobBrazier/svelte-awesome/pull/793)

### Commits

- fix @sveltejs/adapter-static rimraf build issue [`e2785fa`](https://github.com/RobBrazier/svelte-awesome/commit/e2785fa6600ff095e6c84af9c93c1ebc932a4070)
- use latest version of svelte-kit for example [`9993237`](https://github.com/RobBrazier/svelte-awesome/commit/99932371e8d60abcad57d89d10f117c553d7f317)
- reduce pinning on svelte in peerDependencies [`2d9e552`](https://github.com/RobBrazier/svelte-awesome/commit/2d9e5522f66eedfad386b16dce095626a86ff029)

## [v2.4.2](https://github.com/RobBrazier/svelte-awesome/compare/v2.4.1...v2.4.2) - 2021-10-03

### Commits

- add svelte to peerDependencies [`38a42ba`](https://github.com/RobBrazier/svelte-awesome/commit/38a42ba01e6647a0f6546dd6e7935b6a7701ae85)

## [v2.4.1](https://github.com/RobBrazier/svelte-awesome/compare/v2.4.0...v2.4.1) - 2021-10-03

### Commits

- fix scale warning 'number is not assignable to type string' [`d47d4c0`](https://github.com/RobBrazier/svelte-awesome/commit/d47d4c0e3c4621ada70ebbe7ed970e0ce60bd427)
- add dynamic base path to get demo working [`ecfdf23`](https://github.com/RobBrazier/svelte-awesome/commit/ecfdf234425126324f38e148449a8e6d0eb367b4)

## [v2.4.0](https://github.com/RobBrazier/svelte-awesome/compare/v2.3.2...v2.4.0) - 2021-10-03

### Merged

- Add svelte-kit compatibility [`#784`](https://github.com/RobBrazier/svelte-awesome/pull/784)
- chore(deps-dev): bump eslint-plugin-import from 2.23.4 to 2.24.2 [`#772`](https://github.com/RobBrazier/svelte-awesome/pull/772)
- chore(deps-dev): bump serve from 11.3.2 to 12.0.0 [`#761`](https://github.com/RobBrazier/svelte-awesome/pull/761)
- chore(deps-dev): bump svelte-highlight from 2.1.0 to 3.0.0 [`#756`](https://github.com/RobBrazier/svelte-awesome/pull/756)

### Commits

- re-add svelte to package.json [`11f28e5`](https://github.com/RobBrazier/svelte-awesome/commit/11f28e576cba7c3c1d2f89131102c1133b439964)

## [v2.3.2](https://github.com/RobBrazier/svelte-awesome/compare/v2.3.1...v2.3.2) - 2021-05-28

### Commits

- update example with svelte-highlight instead of prettify.js [`78534de`](https://github.com/RobBrazier/svelte-awesome/commit/78534de7e9b1b21e6fae4556a9c247e5dfe7daee)
- only set style if required [`7737de0`](https://github.com/RobBrazier/svelte-awesome/commit/7737de0fb8eb7136676e8509dbf2279a9c8d85dc)

## [v2.3.1](https://github.com/RobBrazier/svelte-awesome/compare/v2.3.0...v2.3.1) - 2021-03-29

### Merged

- chore(deps): bump node-fetch from 2.6.0 to 2.6.1 [`#681`](https://github.com/RobBrazier/svelte-awesome/pull/681)
- chore(deps): bump serialize-javascript from 3.0.0 to 3.1.0 [`#671`](https://github.com/RobBrazier/svelte-awesome/pull/671)
- chore(deps-dev): bump rollup from 2.18.1 to 2.23.0 [`#666`](https://github.com/RobBrazier/svelte-awesome/pull/666)
- chore(deps-dev): bump eslint from 7.3.1 to 7.6.0 [`#669`](https://github.com/RobBrazier/svelte-awesome/pull/669)
- chore(deps-dev): bump @fortawesome/free-regular-svg-icons from 5.13.1 to 5.14.0 [`#667`](https://github.com/RobBrazier/svelte-awesome/pull/667)
- chore(deps): bump svelte from 3.23.2 to 3.24.0 [`#668`](https://github.com/RobBrazier/svelte-awesome/pull/668)
- chore(deps-dev): bump lodash from 4.17.15 to 4.17.19 [`#665`](https://github.com/RobBrazier/svelte-awesome/pull/665)
- chore(deps-dev): bump eslint from 7.2.0 to 7.3.1 [`#661`](https://github.com/RobBrazier/svelte-awesome/pull/661)
- chore(deps-dev): bump rollup from 2.16.1 to 2.18.1 [`#664`](https://github.com/RobBrazier/svelte-awesome/pull/664)
- chore(deps-dev): bump @fortawesome/free-regular-svg-icons from 5.13.0 to 5.13.1 [`#663`](https://github.com/RobBrazier/svelte-awesome/pull/663)
- chore(deps-dev): bump eslint-plugin-import from 2.21.2 to 2.22.0 [`#662`](https://github.com/RobBrazier/svelte-awesome/pull/662)
- chore(deps-dev): bump rollup-plugin-svelte from 5.2.2 to 5.2.3 [`#660`](https://github.com/RobBrazier/svelte-awesome/pull/660)
- Create Dependabot config file [`#659`](https://github.com/RobBrazier/svelte-awesome/pull/659)
- build(deps): bump svelte from 3.20.1 to 3.21.0 [`#609`](https://github.com/RobBrazier/svelte-awesome/pull/609)

### Commits

- fix rollup compatibility [`dc85158`](https://github.com/RobBrazier/svelte-awesome/commit/dc851583016b2fe4b1ae5e0ee01fa81ad393e225)
- Merge pull request #658 from RobBrazier/dependabot/npm_and_yarn/eslint-7.2.0 [`67818e6`](https://github.com/RobBrazier/svelte-awesome/commit/67818e66b80f63395d0205162c62de5adce7b6ab)
- Merge pull request #656 from RobBrazier/dependabot/npm_and_yarn/rollup-2.16.1 [`bb554ab`](https://github.com/RobBrazier/svelte-awesome/commit/bb554ababdad57d9eb60e8bc23377d5ede4149aa)
- Merge pull request #655 from RobBrazier/dependabot/npm_and_yarn/eslint-config-airbnb-base-14.2.0 [`84def6e`](https://github.com/RobBrazier/svelte-awesome/commit/84def6e867a1dd48689e2d1c0caa5e8e3509d236)
- Merge pull request #654 from RobBrazier/dependabot/npm_and_yarn/acorn-7.3.1 [`066abdc`](https://github.com/RobBrazier/svelte-awesome/commit/066abdc28eb456b51c99f7e2dfc19d09b594e1c6)
- Merge pull request #653 from RobBrazier/dependabot/npm_and_yarn/svelte-3.23.2 [`d03e3d5`](https://github.com/RobBrazier/svelte-awesome/commit/d03e3d5f69a253159a8d6fe98f9166921408df15)
- Merge pull request #652 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-import-2.21.2 [`79395e9`](https://github.com/RobBrazier/svelte-awesome/commit/79395e93b9be93517857dda60ba2b1f5c0f37c29)
- Merge pull request #651 from RobBrazier/dependabot/npm_and_yarn/svelte-3.23.1 [`60e4616`](https://github.com/RobBrazier/svelte-awesome/commit/60e4616c7ea306287c656fafc58d4882bb626cc6)
- Merge pull request #650 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-import-2.21.1 [`5463b30`](https://github.com/RobBrazier/svelte-awesome/commit/5463b3048d71301ddb2d738ae4d9dd4f0dbc32ee)
- Merge pull request #649 from RobBrazier/dependabot/npm_and_yarn/rollup-2.15.0 [`12c02b0`](https://github.com/RobBrazier/svelte-awesome/commit/12c02b03746e7b0bf2fda2c8e266432209a324fc)
- Merge pull request #648 from RobBrazier/dependabot/npm_and_yarn/serve-11.3.2 [`84bc47a`](https://github.com/RobBrazier/svelte-awesome/commit/84bc47a9d72277c81f65776ccd5b960dd6fd5368)
- Merge pull request #647 from RobBrazier/dependabot/npm_and_yarn/rollup-2.13.1 [`7cdb981`](https://github.com/RobBrazier/svelte-awesome/commit/7cdb981998ed38a61fcf6801369df829b2f31de5)
- Merge pull request #646 from RobBrazier/dependabot/npm_and_yarn/rollup-2.13.0 [`bdc24d0`](https://github.com/RobBrazier/svelte-awesome/commit/bdc24d051a76c89e0e45e1ebc9da165446e93466)
- Merge pull request #645 from RobBrazier/dependabot/npm_and_yarn/rollup-2.12.1 [`8569625`](https://github.com/RobBrazier/svelte-awesome/commit/856962510bbe477f1d714c09957cd7d81f04715d)
- Merge pull request #642 from RobBrazier/dependabot/npm_and_yarn/rollup-2.11.2 [`88fe39d`](https://github.com/RobBrazier/svelte-awesome/commit/88fe39daff345dea18a1b60d8a33ea3e0b268cb9)
- Merge pull request #641 from RobBrazier/dependabot/npm_and_yarn/rollup-2.11.0 [`074241e`](https://github.com/RobBrazier/svelte-awesome/commit/074241e2babd717f5908d6d579775f19f55adc6f)
- Merge pull request #640 from RobBrazier/dependabot/npm_and_yarn/svelte-3.23.0 [`45e9cc0`](https://github.com/RobBrazier/svelte-awesome/commit/45e9cc0b4057571d933b143cf9ac17a9232cd227)
- Merge pull request #639 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-terser-6.1.0 [`37ace68`](https://github.com/RobBrazier/svelte-awesome/commit/37ace6889ab4d2df6ca98f4db97e69fc1ba4b332)
- Merge pull request #638 from RobBrazier/dependabot/npm_and_yarn/rollup-2.10.9 [`f9f24eb`](https://github.com/RobBrazier/svelte-awesome/commit/f9f24ebd8470c13749fff397bfe76fa298a10a54)
- Merge pull request #637 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-terser-6.0.1 [`0b0c9ae`](https://github.com/RobBrazier/svelte-awesome/commit/0b0c9ae261c5e79e5f35f0923581353195e7776f)
- Merge pull request #635 from RobBrazier/dependabot/npm_and_yarn/rollup-2.10.8 [`f3a93e3`](https://github.com/RobBrazier/svelte-awesome/commit/f3a93e3b08989a770fbe2742242fd0fc7c02f19a)
- Merge pull request #634 from RobBrazier/dependabot/npm_and_yarn/serve-11.3.1 [`1333b4a`](https://github.com/RobBrazier/svelte-awesome/commit/1333b4a7805d0c009ab32a84c731c249aaa2b970)
- Merge pull request #633 from RobBrazier/dependabot/npm_and_yarn/rollup-2.10.7 [`fc3479f`](https://github.com/RobBrazier/svelte-awesome/commit/fc3479ff0c5dd9188939553b4bff0c47795d3882)
- Merge pull request #632 from RobBrazier/dependabot/npm_and_yarn/rollup-2.10.5 [`0b9ebf2`](https://github.com/RobBrazier/svelte-awesome/commit/0b9ebf2d03b2b74d3f16ad813b3020716d3665d3)
- Merge pull request #631 from RobBrazier/dependabot/npm_and_yarn/rollup-2.10.4 [`f980442`](https://github.com/RobBrazier/svelte-awesome/commit/f980442c5a5c82023a391ab101858a97a00b36d6)
- Merge pull request #630 from RobBrazier/dependabot/npm_and_yarn/rollup-2.10.3 [`575c161`](https://github.com/RobBrazier/svelte-awesome/commit/575c161fc5c11e169e865f6662717a5900419e29)
- Merge pull request #629 from RobBrazier/dependabot/npm_and_yarn/svelte-3.22.3 [`948a0f7`](https://github.com/RobBrazier/svelte-awesome/commit/948a0f7e7d09df17bae689e1b0a6dcc5a305a05f)
- Merge pull request #628 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-svelte-5.2.2 [`26f3cb0`](https://github.com/RobBrazier/svelte-awesome/commit/26f3cb0ffe80a86dba1da39b2c236f325696f22b)
- Merge pull request #627 from RobBrazier/dependabot/npm_and_yarn/rollup-2.10.2 [`a8a04a8`](https://github.com/RobBrazier/svelte-awesome/commit/a8a04a8a3ab8a819c66624763837a7753259a717)
- Merge pull request #626 from RobBrazier/dependabot/npm_and_yarn/rollup-2.10.0 [`aaa72e4`](https://github.com/RobBrazier/svelte-awesome/commit/aaa72e4034c8015ff97019fc0c6a19b87f226f09)
- Merge pull request #625 from RobBrazier/dependabot/npm_and_yarn/rollup-2.9.1 [`37a11ce`](https://github.com/RobBrazier/svelte-awesome/commit/37a11ce6a4bc5a6c176bde39a973a4fae83119e1)
- Merge pull request #624 from RobBrazier/dependabot/npm_and_yarn/rollup-2.9.0 [`f37738d`](https://github.com/RobBrazier/svelte-awesome/commit/f37738d707e194229180a6e0e25f2d0bf5456a56)
- Merge pull request #623 from RobBrazier/dependabot/npm_and_yarn/acorn-7.2.0 [`116f898`](https://github.com/RobBrazier/svelte-awesome/commit/116f898375e7baf150140da9ec1049632f274d08)
- Merge pull request #622 from RobBrazier/dependabot/npm_and_yarn/rollup-2.8.2 [`44d1b2e`](https://github.com/RobBrazier/svelte-awesome/commit/44d1b2e4e9271f9e2a5b9ea08e2ad95a91c12f38)
- Merge pull request #621 from RobBrazier/dependabot/npm_and_yarn/rollup-2.8.1 [`9e5dd46`](https://github.com/RobBrazier/svelte-awesome/commit/9e5dd4602c56e13ecaa1dafcb550a47b2ec2b903)
- Merge pull request #620 from RobBrazier/dependabot/npm_and_yarn/rollup-2.8.0 [`d5f1e82`](https://github.com/RobBrazier/svelte-awesome/commit/d5f1e8253e354da8e9b1fe13bcae9cc4e8be51e9)
- Merge pull request #619 from RobBrazier/dependabot/npm_and_yarn/svelte-3.22.2 [`520dffa`](https://github.com/RobBrazier/svelte-awesome/commit/520dffaf2e0f23d517fe8137c76b1b030472fb78)
- Merge pull request #618 from RobBrazier/dependabot/npm_and_yarn/svelte-3.22.1 [`3da3602`](https://github.com/RobBrazier/svelte-awesome/commit/3da3602b89811c1f86ce08be43c1dac46c0b6236)
- Merge pull request #617 from RobBrazier/dependabot/npm_and_yarn/svelte-3.22.0 [`9d8f0d2`](https://github.com/RobBrazier/svelte-awesome/commit/9d8f0d27b96d81de5c611185cf1b6a2e81f10c33)
- Merge pull request #615 from RobBrazier/dependabot/npm_and_yarn/rollup-2.7.6 [`2dbf5b8`](https://github.com/RobBrazier/svelte-awesome/commit/2dbf5b83b7af9f28f06c0f41e4b7f1c6af1987ea)
- Merge pull request #614 from RobBrazier/dependabot/npm_and_yarn/rollup-2.7.5 [`945d157`](https://github.com/RobBrazier/svelte-awesome/commit/945d1573f414817235834c579064265158b879ce)
- Merge pull request #613 from RobBrazier/dependabot/npm_and_yarn/rollup-2.7.4 [`e2b75dc`](https://github.com/RobBrazier/svelte-awesome/commit/e2b75dca6890210bb3a1a55c643c5815c2bc408f)
- Merge pull request #612 from RobBrazier/dependabot/npm_and_yarn/graceful-fs-4.2.4 [`8812808`](https://github.com/RobBrazier/svelte-awesome/commit/8812808a20cf68d9bb0a6ad8a365ab48184d2822)
- Merge pull request #611 from RobBrazier/dependabot/npm_and_yarn/rollup-2.7.3 [`a8c5bbf`](https://github.com/RobBrazier/svelte-awesome/commit/a8c5bbf16ba0c045fa5b48f45e0c82888565a119)
- Merge pull request #608 from RobBrazier/dependabot/npm_and_yarn/rollup-2.7.2 [`acb19dc`](https://github.com/RobBrazier/svelte-awesome/commit/acb19dca501aec753ac377c57971321a2cb6a3bf)
- Merge pull request #607 from RobBrazier/dependabot/npm_and_yarn/rollup-2.7.1 [`96293af`](https://github.com/RobBrazier/svelte-awesome/commit/96293af535964f8bb368a497289b774ef47176ab)
- Merge pull request #606 from RobBrazier/dependabot/npm_and_yarn/rollup-2.7.0 [`95ba041`](https://github.com/RobBrazier/svelte-awesome/commit/95ba0412533ad348596ca8a53701c2222f132020)
- Merge pull request #604 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-html-6.0.2 [`075982c`](https://github.com/RobBrazier/svelte-awesome/commit/075982c64e210156f1b80d52d41ef71ba4569bac)

## [v2.3.0](https://github.com/RobBrazier/svelte-awesome/compare/v2.2.1...v2.3.0) - 2020-04-14

### Merged

- Reactive code updates when `scale` or `style` change [`#602`](https://github.com/RobBrazier/svelte-awesome/pull/602)
- build(deps): bump svelte from 3.19.2 to 3.20.0 [`#581`](https://github.com/RobBrazier/svelte-awesome/pull/581)
- build(deps-dev): bump rollup from 1.32.1 to 2.0.2 [`#574`](https://github.com/RobBrazier/svelte-awesome/pull/574)
- build(deps): bump svelte from 3.18.2 to 3.19.0 [`#567`](https://github.com/RobBrazier/svelte-awesome/pull/567)
- build(deps): bump svelte from 3.17.3 to 3.18.1 [`#561`](https://github.com/RobBrazier/svelte-awesome/pull/561)
- build(deps): bump svelte from 3.16.7 to 3.17.0 [`#553`](https://github.com/RobBrazier/svelte-awesome/pull/553)

### Commits

- add documentation for #602 [`c802eac`](https://github.com/RobBrazier/svelte-awesome/commit/c802eaca5882d26d8768e4ca661fa03f3e9d8fe8)
- Merge pull request #603 from RobBrazier/dependabot/npm_and_yarn/rollup-2.6.1 [`96f4315`](https://github.com/RobBrazier/svelte-awesome/commit/96f43155a727690955b53b86e8a5d400f525b0c3)
- Merge pull request #601 from RobBrazier/dependabot/npm_and_yarn/rollup-2.6.0 [`f6d59e8`](https://github.com/RobBrazier/svelte-awesome/commit/f6d59e89306ccbf8ecf59e13ee2de69ef14aa93e)
- Merge pull request #600 from RobBrazier/dependabot/npm_and_yarn/rollup-2.5.0 [`b4684c6`](https://github.com/RobBrazier/svelte-awesome/commit/b4684c6d4bfd23800a5e018c5693e2abf1813e2e)
- Merge pull request #598 from RobBrazier/dependabot/npm_and_yarn/rollup-2.4.0 [`cf85c8a`](https://github.com/RobBrazier/svelte-awesome/commit/cf85c8a3ab84de9292db6d22f14d370251251e29)
- Merge pull request #597 from RobBrazier/dependabot/npm_and_yarn/rollup-2.3.5 [`f201e62`](https://github.com/RobBrazier/svelte-awesome/commit/f201e62964b80781ef8ebb77e3c26b64e91a4411)
- Merge pull request #596 from RobBrazier/dependabot/npm_and_yarn/rollup-2.3.4 [`a2b4698`](https://github.com/RobBrazier/svelte-awesome/commit/a2b469895ac030e06bf79c90ce9af427fe73a233)
- Merge pull request #595 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-html-6.0.1 [`b596f75`](https://github.com/RobBrazier/svelte-awesome/commit/b596f75c3ae86c0955b973da86d353aca573fe3e)
- Merge pull request #594 from RobBrazier/dependabot/npm_and_yarn/rollup-2.3.3 [`8e5df08`](https://github.com/RobBrazier/svelte-awesome/commit/8e5df0802c9c94c274b8e6363b3baeaab7e98668)
- Merge pull request #591 from RobBrazier/dependabot/npm_and_yarn/rollup-2.3.2 [`ae08bda`](https://github.com/RobBrazier/svelte-awesome/commit/ae08bdac2292b4c6222ee1fce64c7b031a041e5d)
- Merge pull request #593 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-svelte-5.2.1 [`8687620`](https://github.com/RobBrazier/svelte-awesome/commit/8687620009e4a3496bed4b9791698815d6fc4fdd)
- Merge pull request #590 from RobBrazier/dependabot/npm_and_yarn/rollup-2.3.1 [`9bb1481`](https://github.com/RobBrazier/svelte-awesome/commit/9bb1481c51d1b454c842f28a5888eaea8a94e958)
- Merge pull request #589 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-svelte-5.2.0 [`0e8c860`](https://github.com/RobBrazier/svelte-awesome/commit/0e8c860378f7b7c37940044fbe05b1ea75e908f4)
- Merge pull request #588 from RobBrazier/dependabot/npm_and_yarn/rollup-2.3.0 [`fa1bb0e`](https://github.com/RobBrazier/svelte-awesome/commit/fa1bb0e5de65b218f6f9409287446009718a10b2)
- Merge pull request #587 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-import-2.20.2 [`b91aa32`](https://github.com/RobBrazier/svelte-awesome/commit/b91aa32190dc58a1712424cdeb12f0152c3c21a5)
- Merge pull request #585 from RobBrazier/dependabot/npm_and_yarn/rollup-2.2.0 [`2507a18`](https://github.com/RobBrazier/svelte-awesome/commit/2507a186d8bc979fa612130510876492aa104d92)
- Merge pull request #584 from RobBrazier/dependabot/npm_and_yarn/fortawesome/free-regular-svg-icons-5.13.0 [`7144e36`](https://github.com/RobBrazier/svelte-awesome/commit/7144e36f7c764832a52aeef20f1b47443bb7e175)
- Merge pull request #583 from RobBrazier/dependabot/npm_and_yarn/rollup-2.1.0 [`8bcecf5`](https://github.com/RobBrazier/svelte-awesome/commit/8bcecf5e252ef0dcb25a212587afaaa77b414169)
- Merge pull request #582 from RobBrazier/dependabot/npm_and_yarn/svelte-3.20.1 [`c86fcd5`](https://github.com/RobBrazier/svelte-awesome/commit/c86fcd5303e25a188c8ee69f3fb449a0e4cf2407)
- Merge pull request #580 from RobBrazier/dependabot/npm_and_yarn/eslint-config-airbnb-base-14.1.0 [`b0f8bef`](https://github.com/RobBrazier/svelte-awesome/commit/b0f8bef05ef9ffc9c65c4a1e63902720c40e27a8)
- Merge pull request #579 from RobBrazier/dependabot/npm_and_yarn/rollup-2.0.6 [`602bedb`](https://github.com/RobBrazier/svelte-awesome/commit/602bedb63ccaeab88aff38dde0a5286ae0b8bd9c)
- Merge pull request #578 from RobBrazier/dependabot/npm_and_yarn/rollup-2.0.5 [`c07893e`](https://github.com/RobBrazier/svelte-awesome/commit/c07893e0c253443ea399086458bf5691860d3af8)
- Merge pull request #577 from RobBrazier/dependabot/npm_and_yarn/rollup-2.0.4 [`fc145ca`](https://github.com/RobBrazier/svelte-awesome/commit/fc145cafe05c28d35700eded26e13cfcf4b46d67)
- Merge pull request #575 from RobBrazier/dependabot/npm_and_yarn/rollup-2.0.3 [`a15eb53`](https://github.com/RobBrazier/svelte-awesome/commit/a15eb53b50247d029523dccf80dc5e2a9038320a)
- Merge pull request #573 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-terser-5.3.0 [`4f03f9c`](https://github.com/RobBrazier/svelte-awesome/commit/4f03f9c09beda5cca32097797168049f037c9b8f)
- Merge pull request #572 from RobBrazier/dependabot/npm_and_yarn/rollup-1.32.1 [`cc3a9e0`](https://github.com/RobBrazier/svelte-awesome/commit/cc3a9e0b5902e9777aef0856a1fb46d9d28bf891)
- Merge pull request #571 from RobBrazier/dependabot/npm_and_yarn/svelte-3.19.2 [`4e9ad5a`](https://github.com/RobBrazier/svelte-awesome/commit/4e9ad5a4667060610167691e2b0353009e44322a)
- Merge pull request #570 from RobBrazier/dependabot/npm_and_yarn/acorn-7.1.1 [`e591e40`](https://github.com/RobBrazier/svelte-awesome/commit/e591e40aa2671bb61b29a986c223f4023c22d9bd)
- Merge pull request #569 from RobBrazier/dependabot/npm_and_yarn/rollup-1.32.0 [`dedfa1e`](https://github.com/RobBrazier/svelte-awesome/commit/dedfa1e6d9d52c56fa82a79b8f554b0740fb7b8c)
- Merge pull request #568 from RobBrazier/dependabot/npm_and_yarn/svelte-3.19.1 [`74b4c63`](https://github.com/RobBrazier/svelte-awesome/commit/74b4c636261b38d7055a8282eec97dbc6bc4acc9)
- Merge pull request #566 from RobBrazier/dependabot/npm_and_yarn/rollup-1.31.1 [`b4f23fa`](https://github.com/RobBrazier/svelte-awesome/commit/b4f23fa81dc4aaeb9e1c76a05701875df1274a48)
- Merge pull request #565 from RobBrazier/dependabot/npm_and_yarn/svelte-3.18.2 [`46037f6`](https://github.com/RobBrazier/svelte-awesome/commit/46037f63b49eaa7d6012622ce53bea6d048df79e)
- Merge pull request #564 from RobBrazier/dependabot/npm_and_yarn/fortawesome/free-regular-svg-icons-5.12.1 [`eb286f0`](https://github.com/RobBrazier/svelte-awesome/commit/eb286f0074bc64898d025c5b3b46bba084dab4d7)
- Merge pull request #563 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-import-2.20.1 [`67afa25`](https://github.com/RobBrazier/svelte-awesome/commit/67afa25a52413e55e0de3c47086df1696f1e0894)
- Merge pull request #562 from RobBrazier/dependabot/npm_and_yarn/rollup-1.31.0 [`6673724`](https://github.com/RobBrazier/svelte-awesome/commit/6673724e7dab75caa5e7b173ae26197228ef2249)
- Merge pull request #560 from RobBrazier/dependabot/npm_and_yarn/rollup-1.30.1 [`e1aeed5`](https://github.com/RobBrazier/svelte-awesome/commit/e1aeed5ea5dd21a0138e0f333115d2869c44ce44)
- Merge pull request #559 from RobBrazier/dependabot/npm_and_yarn/rollup-1.30.0 [`25d93d1`](https://github.com/RobBrazier/svelte-awesome/commit/25d93d11e14f35acd4814cc50644fbd6b7fa01f2)
- Merge pull request #557 from RobBrazier/dependabot/npm_and_yarn/svelte-3.17.3 [`a59dd83`](https://github.com/RobBrazier/svelte-awesome/commit/a59dd83fa9bbaafde334438101ff0434510adb7a)
- Merge pull request #556 from RobBrazier/dependabot/npm_and_yarn/rollup-1.29.1 [`646b85a`](https://github.com/RobBrazier/svelte-awesome/commit/646b85a3205842c34b188152c47de21b1aa16084)
- Merge pull request #555 from RobBrazier/dependabot/npm_and_yarn/svelte-3.17.2 [`8fc4378`](https://github.com/RobBrazier/svelte-awesome/commit/8fc43781bb0c32de123debb04a669629d09965fc)
- Merge pull request #554 from RobBrazier/dependabot/npm_and_yarn/svelte-3.17.1 [`97cafce`](https://github.com/RobBrazier/svelte-awesome/commit/97cafcedf153bcb14706bc0e0a782aaf93258a25)
- Merge pull request #552 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-terser-5.2.0 [`c9876c4`](https://github.com/RobBrazier/svelte-awesome/commit/c9876c42b58b382132e1911b5fff75ee930ace76)
- Merge pull request #551 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-import-2.20.0 [`bc444f4`](https://github.com/RobBrazier/svelte-awesome/commit/bc444f4c34c2d0e4dd5167f8b1ab0ac2d5e142f2)
- Merge pull request #550 from RobBrazier/dependabot/npm_and_yarn/rollup-1.29.0 [`e047fde`](https://github.com/RobBrazier/svelte-awesome/commit/e047fdecc0c78a892abde7cd8ecc8a94bdc5437b)
- Merge pull request #549 from RobBrazier/dependabot/npm_and_yarn/rollup-1.28.0 [`7ed66af`](https://github.com/RobBrazier/svelte-awesome/commit/7ed66af2ecb001ed61367bcb396c058405d93c4d)
- Merge pull request #548 from RobBrazier/dependabot/npm_and_yarn/svelte-3.16.7 [`aad56b6`](https://github.com/RobBrazier/svelte-awesome/commit/aad56b68e54dfbdecbaf13a494d6457616e93f2d)
- Merge pull request #547 from RobBrazier/dependabot/npm_and_yarn/svelte-3.16.6 [`b35adb3`](https://github.com/RobBrazier/svelte-awesome/commit/b35adb30a4bd3687da216506cb26e48eefd35459)
- Merge pull request #546 from RobBrazier/dependabot/npm_and_yarn/rollup-1.27.14 [`1d556fd`](https://github.com/RobBrazier/svelte-awesome/commit/1d556fd43def8749db4bc651c24211f0f71516dc)
- Merge pull request #545 from RobBrazier/dependabot/npm_and_yarn/eslint-6.8.0 [`2a46394`](https://github.com/RobBrazier/svelte-awesome/commit/2a46394cf51255e4a67437ea25cf3e1fd5870a88)
- Merge pull request #544 from RobBrazier/dependabot/npm_and_yarn/change-case-4.1.1 [`2b484a0`](https://github.com/RobBrazier/svelte-awesome/commit/2b484a006812f989c01338a1628e09e88c2c3faa)
- Merge pull request #543 from RobBrazier/dependabot/npm_and_yarn/svelte-3.16.5 [`7f0d10d`](https://github.com/RobBrazier/svelte-awesome/commit/7f0d10da74d5eeb73d4082228cfea867ea22d6d7)
- Merge pull request #542 from RobBrazier/dependabot/npm_and_yarn/rollup-1.27.13 [`d43974b`](https://github.com/RobBrazier/svelte-awesome/commit/d43974b27b0cd499a8b76422825d16fc938adfe7)
- Merge pull request #541 from RobBrazier/dependabot/npm_and_yarn/rollup-1.27.12 [`f0d4161`](https://github.com/RobBrazier/svelte-awesome/commit/f0d4161fb15ff88aebdbcdc1fd213ff81fbafa21)
- Merge pull request #540 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-terser-5.1.3 [`3c46303`](https://github.com/RobBrazier/svelte-awesome/commit/3c463039d648e4d9e16d268234e25287d3999ed3)
- Merge pull request #539 from RobBrazier/dependabot/npm_and_yarn/fortawesome/free-regular-svg-icons-5.12.0 [`4415d12`](https://github.com/RobBrazier/svelte-awesome/commit/4415d1291da7db7224c5bd7bce28f71034c2b680)
- Merge pull request #538 from RobBrazier/dependabot/npm_and_yarn/svelte-3.16.4 [`0c9bcc7`](https://github.com/RobBrazier/svelte-awesome/commit/0c9bcc7830984ecabe8ac4f36884584068545c2e)
- Add bundlephobia badge [`60e013d`](https://github.com/RobBrazier/svelte-awesome/commit/60e013d1af7c1dcf3ddc79887902c4ebf9a823bb)
- Merge pull request #537 from RobBrazier/dependabot/npm_and_yarn/rollup-1.27.9 [`47caac3`](https://github.com/RobBrazier/svelte-awesome/commit/47caac3254e91c67641d75ccf2d8ecec7ea323d1)
- Merge pull request #536 from RobBrazier/dependabot/npm_and_yarn/change-case-4.1.0 [`4a948e9`](https://github.com/RobBrazier/svelte-awesome/commit/4a948e94d8e643ddba74ccf183f3029b337ab9f5)
- Merge pull request #535 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-import-2.19.1 [`9863cb3`](https://github.com/RobBrazier/svelte-awesome/commit/9863cb3f0669f7678dcf1d189b0e2e5046b43253)
- Merge pull request #534 from RobBrazier/dependabot/npm_and_yarn/change-case-4.0.0 [`fd261ec`](https://github.com/RobBrazier/svelte-awesome/commit/fd261ec2dff16577be73087523e537026dfcf12f)
- Merge pull request #532 from RobBrazier/dependabot/npm_and_yarn/svelte-3.16.0 [`4cdd608`](https://github.com/RobBrazier/svelte-awesome/commit/4cdd6089538377280920125a0a755ed251619515)
- Merge pull request #533 from RobBrazier/dependabot/npm_and_yarn/rollup-1.27.8 [`bf01c77`](https://github.com/RobBrazier/svelte-awesome/commit/bf01c777ab6569ed4009e901384d69f899555b0b)
- Merge pull request #531 from RobBrazier/dependabot/npm_and_yarn/eslint-6.7.2 [`9b4e879`](https://github.com/RobBrazier/svelte-awesome/commit/9b4e8793b2d380eabe7aa0a7357bfa193905633c)
- Merge pull request #530 from RobBrazier/dependabot/npm_and_yarn/eslint-6.7.1 [`455b471`](https://github.com/RobBrazier/svelte-awesome/commit/455b471d72354f4457aad5bdf523d1064d92648f)
- Merge pull request #529 from RobBrazier/dependabot/npm_and_yarn/rollup-1.27.5 [`80c784a`](https://github.com/RobBrazier/svelte-awesome/commit/80c784a1d694b25db3b2f0a7f3d3eba286f6b060)

## [v2.2.1](https://github.com/RobBrazier/svelte-awesome/compare/v2.2.0...v2.2.1) - 2019-11-22

### Merged

- Improve rendering with SSR [`#527`](https://github.com/RobBrazier/svelte-awesome/pull/527)
- build(deps-dev): bump eslint from 5.16.0 to 6.3.0 [`#500`](https://github.com/RobBrazier/svelte-awesome/pull/500)
- build(deps): bump svelte from 3.9.1 to 3.12.0 [`#498`](https://github.com/RobBrazier/svelte-awesome/pull/498)
- build(deps): bump svelte from 3.8.1 to 3.9.1 [`#496`](https://github.com/RobBrazier/svelte-awesome/pull/496)
- build(deps-dev): bump eslint-config-airbnb-base from 13.2.0 to 14.0.0 [`#495`](https://github.com/RobBrazier/svelte-awesome/pull/495)

### Commits

- make icon data reactive in Icon.svelte to ensure component updates are passed to subcomponents [`be7c2bf`](https://github.com/RobBrazier/svelte-awesome/commit/be7c2bfc75dd22873a163a0277da6898bb1c2703)
- Merge pull request #526 from RobBrazier/dependabot/npm_and_yarn/rollup-1.27.0 [`bd9e326`](https://github.com/RobBrazier/svelte-awesome/commit/bd9e32690405eb69c6e59d6ab64043a56eca33fc)
- Merge pull request #522 from RobBrazier/dependabot/npm_and_yarn/rollup-1.26.5 [`6ef6b47`](https://github.com/RobBrazier/svelte-awesome/commit/6ef6b47111b74eb702dc7b92f40baab09528c8c7)
- Merge pull request #520 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-svelte-5.1.1 [`873d4a7`](https://github.com/RobBrazier/svelte-awesome/commit/873d4a75d9bf2a68fb7281edc950b1901ec7e93f)
- Merge pull request #519 from RobBrazier/dependabot/npm_and_yarn/eslint-6.6.0 [`6282bcc`](https://github.com/RobBrazier/svelte-awesome/commit/6282bcc85c22f61468ff3363eb7b196a541b0bf0)
- Merge pull request #518 from RobBrazier/dependabot/npm_and_yarn/rollup-1.26.0 [`2679973`](https://github.com/RobBrazier/svelte-awesome/commit/267997359baf83b64f7331ebffdb049ec734c1c3)
- Merge pull request #517 from RobBrazier/dependabot/npm_and_yarn/graceful-fs-4.2.3 [`91d96c9`](https://github.com/RobBrazier/svelte-awesome/commit/91d96c9c6943841fd7788cc5b06ed35c4c38ed20)
- Merge pull request #516 from RobBrazier/dependabot/npm_and_yarn/rollup-1.25.1 [`779995f`](https://github.com/RobBrazier/svelte-awesome/commit/779995f40840debd90e2a2df341380a30d6f3689)
- Merge pull request #514 from RobBrazier/dependabot/npm_and_yarn/eslint-6.5.1 [`22224b1`](https://github.com/RobBrazier/svelte-awesome/commit/22224b1675b49dd84e98af15ed9063ff551ee5f8)
- Merge pull request #513 from RobBrazier/dependabot/npm_and_yarn/rollup-1.23.1 [`3e37cab`](https://github.com/RobBrazier/svelte-awesome/commit/3e37cab321c1c6267b8a8cb8dff3d89a71f68e8c)
- Merge pull request #512 from RobBrazier/dependabot/npm_and_yarn/rollup-1.22.0 [`cc443ed`](https://github.com/RobBrazier/svelte-awesome/commit/cc443ed44a2d81c172ea302e7fc5a2c2cd84e822)
- Merge pull request #511 from RobBrazier/dependabot/npm_and_yarn/eslint-6.5.0 [`9864941`](https://github.com/RobBrazier/svelte-awesome/commit/98649417576070b8c068bcd762ea6e35515429e6)
- Merge pull request #510 from RobBrazier/dependabot/npm_and_yarn/fortawesome/free-regular-svg-icons-5.11.2 [`068032f`](https://github.com/RobBrazier/svelte-awesome/commit/068032fe78a601926cb4643ec2aaf56fe74141dd)
- Merge pull request #509 from RobBrazier/dependabot/npm_and_yarn/acorn-7.1.0 [`dd0dcb1`](https://github.com/RobBrazier/svelte-awesome/commit/dd0dcb115bfdeb07ad661ca5f1f3918815a69058)
- Merge pull request #508 from RobBrazier/dependabot/npm_and_yarn/fortawesome/free-regular-svg-icons-5.11.1 [`894b54a`](https://github.com/RobBrazier/svelte-awesome/commit/894b54a7ff13f7916f931cfc8562f815cb7c2789)
- Merge pull request #507 from RobBrazier/dependabot/npm_and_yarn/rollup-1.21.4 [`48c37ff`](https://github.com/RobBrazier/svelte-awesome/commit/48c37ff39c7af70915d4fce36731f362fd9eafcb)
- Merge pull request #505 from RobBrazier/dependabot/npm_and_yarn/svelte-3.12.1 [`54d4c07`](https://github.com/RobBrazier/svelte-awesome/commit/54d4c07dda61f7a4c9b5db290cc514d54d129156)
- Merge pull request #504 from RobBrazier/dependabot/npm_and_yarn/rollup-1.21.3 [`4dbe477`](https://github.com/RobBrazier/svelte-awesome/commit/4dbe47786b4525b87d43044e96274269b185e1cf)
- Merge pull request #502 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-terser-5.1.2 [`3d28ce7`](https://github.com/RobBrazier/svelte-awesome/commit/3d28ce79855e6f8aa8cd353ab1e5729750a49f95)
- Merge pull request #503 from RobBrazier/dependabot/npm_and_yarn/eslint-6.4.0 [`aa7939e`](https://github.com/RobBrazier/svelte-awesome/commit/aa7939e9c5be821f06b99f643404802d6cda0d56)
- Merge pull request #501 from RobBrazier/dependabot/npm_and_yarn/rollup-1.21.2 [`461a274`](https://github.com/RobBrazier/svelte-awesome/commit/461a27440a0b3e9ba6a808c7557462f2ce153e36)
- Merge pull request #490 from RobBrazier/dependabot/npm_and_yarn/rollup-1.20.3 [`16dfaa8`](https://github.com/RobBrazier/svelte-awesome/commit/16dfaa8d4c5deb1517dfa8e95966aed8663fe56f)
- Merge pull request #494 from RobBrazier/dependabot/npm_and_yarn/graceful-fs-4.2.2 [`c431402`](https://github.com/RobBrazier/svelte-awesome/commit/c431402fee9799a5821934aedbe6d688e61a0457)
- Merge pull request #493 from RobBrazier/dependabot/npm_and_yarn/fortawesome/free-regular-svg-icons-5.10.2 [`de0c2c9`](https://github.com/RobBrazier/svelte-awesome/commit/de0c2c95ea831aabae2142fdf619346eec205764)
- Merge pull request #491 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-commonjs-10.1.0 [`143fc00`](https://github.com/RobBrazier/svelte-awesome/commit/143fc00bda96c80204c4cb047afd3dcfad9261c4)
- Merge pull request #489 from RobBrazier/dependabot/npm_and_yarn/eslint-utils-1.4.2 [`c7707b6`](https://github.com/RobBrazier/svelte-awesome/commit/c7707b6f616fddf2471fb7f882c0978cf5d85a14)
- update example to include custom styles [`fc7bbc3`](https://github.com/RobBrazier/svelte-awesome/commit/fc7bbc383222d43a560a3aab20775bd51c2b4cd3)

## [v2.2.0](https://github.com/RobBrazier/svelte-awesome/compare/v2.1.0...v2.2.0) - 2019-08-22

### Commits

- Add support for custom classes and styles [`29e38b0`](https://github.com/RobBrazier/svelte-awesome/commit/29e38b0661ae5379c47ff9d9def02aef9b1a380c)
- Fix fontawesome v5 example [`20e52ec`](https://github.com/RobBrazier/svelte-awesome/commit/20e52ec96ce268c065b2e6eb49a4bd7de7152143)
- Fix label example [`a649953`](https://github.com/RobBrazier/svelte-awesome/commit/a649953519eaaa0d77321109027dd62842cf2e03)

## [v2.1.0](https://github.com/RobBrazier/svelte-awesome/compare/v2.0.1...v2.1.0) - 2019-08-20

### Merged

- Add FontAwesome v5 Support [`#487`](https://github.com/RobBrazier/svelte-awesome/pull/487)
- Add Semaphore v2 Pipeline [`#486`](https://github.com/RobBrazier/svelte-awesome/pull/486)

### Commits

- fix package-lock.json [`e9e9e30`](https://github.com/RobBrazier/svelte-awesome/commit/e9e9e309698282a66e285948cff0b0660e176718)
- add publish promotion [`f515ed9`](https://github.com/RobBrazier/svelte-awesome/commit/f515ed9855def9b68af5b1b896ed57aeba66569b)
- rename semaphore.yaml to semaphore.yml [`32cf4ef`](https://github.com/RobBrazier/svelte-awesome/commit/32cf4ef1afdba06078c661572de936049fbf9b05)
- rename semaphore.yaml to semaphore.yml [`cb0cfd5`](https://github.com/RobBrazier/svelte-awesome/commit/cb0cfd58e0c493c8c11da1f4bcab33274f19a106)
- add initial semaphore v3 pipeline [`e3b914b`](https://github.com/RobBrazier/svelte-awesome/commit/e3b914b8fc51a220546957e30ba8b4d351857ec3)
- split pipeline into separate blocks [`b339568`](https://github.com/RobBrazier/svelte-awesome/commit/b33956826d158048407b2c4286be0d392f3d15b3)
- add npm publish on promote [`a3f8240`](https://github.com/RobBrazier/svelte-awesome/commit/a3f8240a2c05ee91d468d0ccec68b797382a5250)
- specify node version [`d3431b8`](https://github.com/RobBrazier/svelte-awesome/commit/d3431b8451c7d173953198308f629c107d7792ec)
- add gh-pages to publish step [`804d8b5`](https://github.com/RobBrazier/svelte-awesome/commit/804d8b5d8aec2543956bd9b1840845967df97909)
- add node version to each block [`cc56aa9`](https://github.com/RobBrazier/svelte-awesome/commit/cc56aa9a0ce1b15bb3614c8184d960383df61e73)
- add version and agent to pipeline [`6faf24a`](https://github.com/RobBrazier/svelte-awesome/commit/6faf24a5f4a8cd3b5dcabfc1e0e2defce9d39684)
- specify node version [`0781644`](https://github.com/RobBrazier/svelte-awesome/commit/0781644177a58f8e91dbeb16ea49d66d071644c9)
- add sshkey for gh-pages publish [`5a0483a`](https://github.com/RobBrazier/svelte-awesome/commit/5a0483ad0f142bcff737c6a312d19f11440fd04e)
- change promotion to be on push to master [`662d899`](https://github.com/RobBrazier/svelte-awesome/commit/662d8998d368d9e98f87f18399255f3d0d1649ee)

## [v2.0.1](https://github.com/RobBrazier/svelte-awesome/compare/v2.0.0...v2.0.1) - 2019-08-19

### Commits

- remove unused eslint-plugin-jsx-a11y [`1e40c5b`](https://github.com/RobBrazier/svelte-awesome/commit/1e40c5b638463e3dd87545542445ad3003aa4dac)
- fix publish script - release -&gt; gh-release [`eb55b8b`](https://github.com/RobBrazier/svelte-awesome/commit/eb55b8b26aab8a8a8a76ad385352ddcf957d7f3f)

## [v2.0.0](https://github.com/RobBrazier/svelte-awesome/compare/v1.4.1...v2.0.0) - 2019-08-19

### Merged

- add svelte 3 support [`#434`](https://github.com/RobBrazier/svelte-awesome/pull/434)
- build(deps-dev): bump rollup from 0.66.2 to 0.66.4 [`#306`](https://github.com/RobBrazier/svelte-awesome/pull/306)

### Commits

- fix deployment scripts and use recommended rollup.config.js [`3bee01a`](https://github.com/RobBrazier/svelte-awesome/commit/3bee01a321c9f11731510fa1833d4836b1e30462)
- update svelte, terser and eslint [`844567d`](https://github.com/RobBrazier/svelte-awesome/commit/844567db3fa73adb40a0f801b80754e90f84ce31)
- update acorn dependency required for eslint [`48b1389`](https://github.com/RobBrazier/svelte-awesome/commit/48b138922629acae9f4f5f05e1f201e09c5027df)
- Merge pull request #479 from RobBrazier/dependabot/npm_and_yarn/lodash-4.17.15 [`64be443`](https://github.com/RobBrazier/svelte-awesome/commit/64be4436a0f7116bdfa9ef857604956e954e53ef)
- Merge pull request #482 from RobBrazier/dependabot/npm_and_yarn/release-it-12.3.4 [`a9fbe1c`](https://github.com/RobBrazier/svelte-awesome/commit/a9fbe1c64d0417ab8c0abf8216cdc69d0e45ca08)
- Merge pull request #478 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-import-2.18.2 [`db4e8a0`](https://github.com/RobBrazier/svelte-awesome/commit/db4e8a0c5b7e5b99a75e07d2c0c2de4ad35af44c)
- Merge pull request #476 from RobBrazier/dependabot/npm_and_yarn/lodash-4.17.13 [`efaf2ba`](https://github.com/RobBrazier/svelte-awesome/commit/efaf2ba59a37fb3e06008979ff47c27005b34163)
- Merge pull request #471 from RobBrazier/dependabot/npm_and_yarn/eslint-config-airbnb-base-13.2.0 [`62f1987`](https://github.com/RobBrazier/svelte-awesome/commit/62f19875f446eb92197ac849cf66161e65da178c)
- Merge pull request #469 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-jsx-a11y-6.2.3 [`46bc39f`](https://github.com/RobBrazier/svelte-awesome/commit/46bc39f6828c503d4cf2eb64df54359024f304f4)
- Merge pull request #465 from RobBrazier/dependabot/npm_and_yarn/graceful-fs-4.2.0 [`dae0261`](https://github.com/RobBrazier/svelte-awesome/commit/dae026135acedf3746e84bd4eb757b30521f81cd)
- Merge pull request #463 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-import-2.18.0 [`80f874c`](https://github.com/RobBrazier/svelte-awesome/commit/80f874c47ad8234daf81ff26ff0bb74a55830299)
- Merge pull request #455 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-svelte-5.1.0 [`730fd13`](https://github.com/RobBrazier/svelte-awesome/commit/730fd1345a0b138f8a00b4b82997ec4e2c147330)
- Merge pull request #450 from RobBrazier/dependabot/npm_and_yarn/release-it-12.3.0 [`2aa0ad6`](https://github.com/RobBrazier/svelte-awesome/commit/2aa0ad696b2f46e6301079e4a385cd25c22d883e)
- Merge pull request #447 from RobBrazier/dependabot/npm_and_yarn/release-it-12.2.2 [`31aba0c`](https://github.com/RobBrazier/svelte-awesome/commit/31aba0cff9a2d10bc4f96e22859595afe71a736d)
- Merge pull request #444 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-import-2.17.3 [`d591666`](https://github.com/RobBrazier/svelte-awesome/commit/d591666eca68bb7109c99df7c00c295f45c0f718)
- Merge pull request #443 from RobBrazier/dependabot/npm_and_yarn/release-it-12.2.1 [`d2cdd3f`](https://github.com/RobBrazier/svelte-awesome/commit/d2cdd3fb301752996492854a31933026bea12aa9)
- fix example and update rollup dependencies [`f70875e`](https://github.com/RobBrazier/svelte-awesome/commit/f70875eeaa5a1dbc1f6935bef740dfa8c97ecec7)
- Merge pull request #418 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-import-2.17.2 [`2cd6436`](https://github.com/RobBrazier/svelte-awesome/commit/2cd64360e917be9296e1f1948b42c2268fb1deb7)
- Merge pull request #417 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-import-2.17.1 [`c3433ad`](https://github.com/RobBrazier/svelte-awesome/commit/c3433ad5630496c88bdda375cbd8b4e00d070ba4)
- Merge pull request #414 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-replace-2.2.0 [`b48fa2d`](https://github.com/RobBrazier/svelte-awesome/commit/b48fa2de11c40b4e40ebd45ec8545648fe353637)
- Merge pull request #412 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-commonjs-9.3.4 [`bd60540`](https://github.com/RobBrazier/svelte-awesome/commit/bd6054016bbbcb07df4128441aa98eba5bef6efd)
- Merge pull request #411 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-commonjs-9.3.1 [`c15e3b1`](https://github.com/RobBrazier/svelte-awesome/commit/c15e3b111d07bf6b5c76e8330d8e114a40163b92)
- Merge pull request #410 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-commonjs-9.3.0 [`4e0205e`](https://github.com/RobBrazier/svelte-awesome/commit/4e0205ee7d4e383a02b449bf8d349fc549e3e565)
- Merge pull request #409 from RobBrazier/dependabot/npm_and_yarn/eslint-5.16.0 [`bdc848f`](https://github.com/RobBrazier/svelte-awesome/commit/bdc848fd422fef92fa911154946b8d321385a359)
- Merge pull request #408 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-commonjs-9.2.2 [`fe4e6ad`](https://github.com/RobBrazier/svelte-awesome/commit/fe4e6add6d2122024a54daba814ef17ad71a0b1c)
- Merge pull request #407 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-replace-2.1.1 [`f17b6af`](https://github.com/RobBrazier/svelte-awesome/commit/f17b6af989abf95a097da7eef8f8cf6549e058d6)
- Merge pull request #406 from RobBrazier/dependabot/npm_and_yarn/eslint-5.15.3 [`09b1e20`](https://github.com/RobBrazier/svelte-awesome/commit/09b1e206b9569377c0b2fcdf16bf3581b1ff5045)
- Merge pull request #405 from RobBrazier/dependabot/npm_and_yarn/eslint-5.15.2 [`85de086`](https://github.com/RobBrazier/svelte-awesome/commit/85de0864e43a7794fcb1835ca6162196daf228bd)
- Merge pull request #404 from RobBrazier/dependabot/npm_and_yarn/eslint-5.15.1 [`8a48ec7`](https://github.com/RobBrazier/svelte-awesome/commit/8a48ec70384bcd0cbebd1a917fd6cc00910d71b7)
- Merge pull request #403 from RobBrazier/dependabot/npm_and_yarn/eslint-5.15.0 [`7ab3493`](https://github.com/RobBrazier/svelte-awesome/commit/7ab3493abf89c651badde3373b0f5910945d7389)
- Merge pull request #401 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-commonjs-9.2.1 [`0d22c9e`](https://github.com/RobBrazier/svelte-awesome/commit/0d22c9eeb38fb53fc0fccd517bd0f4040430c665)
- Merge pull request #399 from RobBrazier/dependabot/npm_and_yarn/eslint-5.14.1 [`c0bae9c`](https://github.com/RobBrazier/svelte-awesome/commit/c0bae9c1c51677cf68f1fc60599c7fb3e9bf908a)
- Merge pull request #398 from RobBrazier/dependabot/npm_and_yarn/eslint-5.14.0 [`664d850`](https://github.com/RobBrazier/svelte-awesome/commit/664d85040fcc659b6e8819e3ad3061a7057533fe)
- Merge pull request #396 from RobBrazier/dependabot/npm_and_yarn/@commitlint/cli-7.5.2 [`242b7d1`](https://github.com/RobBrazier/svelte-awesome/commit/242b7d1306377975be6a68b79229c70cf50c5d3a)
- Merge pull request #395 from RobBrazier/dependabot/npm_and_yarn/@commitlint/cli-7.5.1 [`b933272`](https://github.com/RobBrazier/svelte-awesome/commit/b933272b3473679f54dbf50e46119afe9c57c2bd)
- Merge pull request #394 from RobBrazier/dependabot/npm_and_yarn/svelte-2.16.1 [`8f74f63`](https://github.com/RobBrazier/svelte-awesome/commit/8f74f63b93fd2441760fe08c6b8a2acf8f50f52e)
- Merge pull request #392 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-jsx-a11y-6.2.1 [`644b8a1`](https://github.com/RobBrazier/svelte-awesome/commit/644b8a10306f77bac09823dadbc7dcfe2cc63cfb)
- Merge pull request #390 from RobBrazier/dependabot/npm_and_yarn/eslint-5.13.0 [`2f6d456`](https://github.com/RobBrazier/svelte-awesome/commit/2f6d456bdf0a63d970a5916757b778e233351e0c)
- Merge pull request #389 from RobBrazier/dependabot/npm_and_yarn/@commitlint/cli-7.5.0 [`6f2a234`](https://github.com/RobBrazier/svelte-awesome/commit/6f2a23497de99ea46f406d2749ed67beff18e614)
- Merge pull request #388 from RobBrazier/dependabot/npm_and_yarn/@commitlint/prompt-cli-7.5.0 [`e41e4f2`](https://github.com/RobBrazier/svelte-awesome/commit/e41e4f25ea0706c1a4565a9fdea3bcc0e6ea956c)
- Merge pull request #387 from RobBrazier/dependabot/npm_and_yarn/@commitlint/config-conventional-7.5.0 [`310208b`](https://github.com/RobBrazier/svelte-awesome/commit/310208b7b93565956e00d8b60a7682cc1418b159)
- Merge pull request #386 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-import-2.16.0 [`2e7ce4b`](https://github.com/RobBrazier/svelte-awesome/commit/2e7ce4bbb25c7108f31da258f0fa234bb3e8ebbc)
- Merge pull request #385 from RobBrazier/dependabot/npm_and_yarn/@commitlint/cli-7.4.0 [`dccc7cd`](https://github.com/RobBrazier/svelte-awesome/commit/dccc7cd1af55266c0daee50e954ab825c3290021)
- Merge pull request #383 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-jsx-a11y-6.2.0 [`b5cdb2b`](https://github.com/RobBrazier/svelte-awesome/commit/b5cdb2beb198b6d36640c5d4af94add2895d46ed)
- Merge pull request #382 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-import-2.15.0 [`a80c60e`](https://github.com/RobBrazier/svelte-awesome/commit/a80c60e34cf55f0eea0d95a341c6703ca92741f0)
- Merge pull request #381 from RobBrazier/dependabot/npm_and_yarn/eslint-5.12.1 [`5437898`](https://github.com/RobBrazier/svelte-awesome/commit/5437898e381777be009d5a1e5fc82826631b3fd0)
- Merge pull request #380 from RobBrazier/dependabot/npm_and_yarn/@commitlint/cli-7.3.2 [`1a30315`](https://github.com/RobBrazier/svelte-awesome/commit/1a30315b1870f2acfe034bc0bada25f0e0c6898c)
- Merge pull request #379 from RobBrazier/dependabot/npm_and_yarn/@commitlint/prompt-cli-7.3.1 [`1dd60e7`](https://github.com/RobBrazier/svelte-awesome/commit/1dd60e724fd83c0a43c3e32bd42a9f1e9a5a7b6f)
- Merge pull request #378 from RobBrazier/dependabot/npm_and_yarn/@commitlint/cli-7.3.1 [`abd2f25`](https://github.com/RobBrazier/svelte-awesome/commit/abd2f2548d5d7bd85bcde33482d01206f389632c)
- Merge pull request #377 from RobBrazier/dependabot/npm_and_yarn/@commitlint/config-conventional-7.3.1 [`7d41be6`](https://github.com/RobBrazier/svelte-awesome/commit/7d41be6f65f8d0343e2f6eef4de38ce0c7c4e13b)
- Merge pull request #374 from RobBrazier/dependabot/npm_and_yarn/eslint-5.12.0 [`3f723d6`](https://github.com/RobBrazier/svelte-awesome/commit/3f723d6b8436d3753b31d1db4e4496180565202f)
- Merge pull request #370 from RobBrazier/dependabot/npm_and_yarn/husky-1.3.1 [`ad2dfac`](https://github.com/RobBrazier/svelte-awesome/commit/ad2dfac2b37dd6ef217f9ec9a6cc77fed2961297)
- Merge pull request #368 from RobBrazier/dependabot/npm_and_yarn/eslint-5.11.1 [`12ac812`](https://github.com/RobBrazier/svelte-awesome/commit/12ac812fcc43e69bcd30811c41c8eee36574a52e)
- Merge pull request #367 from RobBrazier/dependabot/npm_and_yarn/eslint-5.11.0 [`7cd1d1e`](https://github.com/RobBrazier/svelte-awesome/commit/7cd1d1eee740d3b80f011476b442218499e3f7d6)
- Merge pull request #364 from RobBrazier/dependabot/npm_and_yarn/husky-1.3.0 [`119dca4`](https://github.com/RobBrazier/svelte-awesome/commit/119dca44a3f5f48983780aad8f16f4a291db9fc5)
- Merge pull request #361 from RobBrazier/dependabot/npm_and_yarn/svelte-2.16.0 [`20c7970`](https://github.com/RobBrazier/svelte-awesome/commit/20c797084ae9d6f95d6f56fff7103d9369e5c6e6)
- Merge pull request #359 from RobBrazier/dependabot/npm_and_yarn/husky-1.2.1 [`1160425`](https://github.com/RobBrazier/svelte-awesome/commit/1160425ae045f0704c533dbefb6a312a21f7a88e)
- Merge pull request #356 from RobBrazier/dependabot/npm_and_yarn/eslint-5.10.0 [`72ebc3d`](https://github.com/RobBrazier/svelte-awesome/commit/72ebc3d9513b0e94570cf98b40224aff1cff87ff)
- Merge pull request #351 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-svelte-4.4.0 [`8acc290`](https://github.com/RobBrazier/svelte-awesome/commit/8acc2901841eb1924266659314bae7959db34eaa)
- Merge pull request #349 from RobBrazier/dependabot/npm_and_yarn/npm-run-all-4.1.5 [`fb1420e`](https://github.com/RobBrazier/svelte-awesome/commit/fb1420e600e872c65576eba54b6dc52b87c468ed)
- Merge pull request #347 from RobBrazier/dependabot/npm_and_yarn/husky-1.2.0 [`56ab254`](https://github.com/RobBrazier/svelte-awesome/commit/56ab254102ce73f2bc3f7a4f72421ed1435a97de)
- Merge pull request #344 from RobBrazier/dependabot/npm_and_yarn/husky-1.1.4 [`e291750`](https://github.com/RobBrazier/svelte-awesome/commit/e291750454bf00a0e1663516c631377ffc913cab)
- Merge pull request #341 from RobBrazier/dependabot/npm_and_yarn/eslint-5.9.0 [`b1e91cd`](https://github.com/RobBrazier/svelte-awesome/commit/b1e91cdd3e5abd90b66ca80faac677aa59626577)
- Merge pull request #338 from RobBrazier/dependabot/npm_and_yarn/svelte-2.15.3 [`7c7ff0c`](https://github.com/RobBrazier/svelte-awesome/commit/7c7ff0cd4a6f44f5c912787efeef3e4f3cb1bf34)
- Merge pull request #335 from RobBrazier/dependabot/npm_and_yarn/graceful-fs-4.1.15 [`850dc58`](https://github.com/RobBrazier/svelte-awesome/commit/850dc588d8c15774e5a73ddf726a78fc5a9a1d21)
- Merge pull request #334 from RobBrazier/dependabot/npm_and_yarn/svelte-2.15.2 [`5cf3017`](https://github.com/RobBrazier/svelte-awesome/commit/5cf30170c4a3bdfcb1b688046a69b8c68a90d46e)
- Merge pull request #333 from RobBrazier/dependabot/npm_and_yarn/husky-1.1.3 [`4e40800`](https://github.com/RobBrazier/svelte-awesome/commit/4e40800c6ac46fcb653d9bcbfee25bf194a62d0c)
- Merge pull request #332 from RobBrazier/dependabot/npm_and_yarn/svelte-2.15.1 [`7505a96`](https://github.com/RobBrazier/svelte-awesome/commit/7505a96d9535ed1f26240649bf7196a9a09ebba1)
- Merge pull request #331 from RobBrazier/dependabot/npm_and_yarn/svelte-2.15.0 [`7b421bb`](https://github.com/RobBrazier/svelte-awesome/commit/7b421bb058bc6a49a46d3b48ed8a49c155974d7a)
- Merge pull request #329 from RobBrazier/dependabot/npm_and_yarn/eslint-5.8.0 [`08ad82f`](https://github.com/RobBrazier/svelte-awesome/commit/08ad82fda7df0c16d903aa17abde489e886f8017)
- Merge pull request #328 from RobBrazier/dependabot/npm_and_yarn/svelte-2.14.3 [`a0ead24`](https://github.com/RobBrazier/svelte-awesome/commit/a0ead245efdde02ddb76b88923dd6b376e817fed)
- Merge pull request #327 from RobBrazier/dependabot/npm_and_yarn/svelte-2.14.2 [`e592e23`](https://github.com/RobBrazier/svelte-awesome/commit/e592e23739a06827740d765e014a172e5a7b44fa)
- Merge pull request #326 from RobBrazier/dependabot/npm_and_yarn/svelte-2.14.1 [`0307abd`](https://github.com/RobBrazier/svelte-awesome/commit/0307abd15a4ae57a80b65729b07cd7cb1afe848a)
- Merge pull request #322 from RobBrazier/dependabot/npm_and_yarn/svelte-2.14.0 [`0d94dbe`](https://github.com/RobBrazier/svelte-awesome/commit/0d94dbe88580bc54b8de80071c5234c77d193172)
- Merge pull request #320 from RobBrazier/dependabot/npm_and_yarn/eslint-5.7.0 [`6ed24ed`](https://github.com/RobBrazier/svelte-awesome/commit/6ed24ed78a38b95a7297ed0e5d0913cacbb62111)
- Merge pull request #319 from RobBrazier/dependabot/npm_and_yarn/@commitlint/prompt-cli-7.2.1 [`470a1bb`](https://github.com/RobBrazier/svelte-awesome/commit/470a1bb173b36ebb067c1dd205aecb1496691338)
- Merge pull request #318 from RobBrazier/dependabot/npm_and_yarn/@commitlint/cli-7.2.1 [`a3fbaa5`](https://github.com/RobBrazier/svelte-awesome/commit/a3fbaa53fcee46727cdf05d66e4cb7349c3f7b4d)
- Merge pull request #317 from RobBrazier/dependabot/npm_and_yarn/husky-1.1.2 [`a738c15`](https://github.com/RobBrazier/svelte-awesome/commit/a738c15202069b528ffab55598b25b8a39f7fb5f)
- Merge pull request #315 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-commonjs-9.2.0 [`a597337`](https://github.com/RobBrazier/svelte-awesome/commit/a5973378c6c3e7d8a9b27bcf8374e4ef0707971b)
- Merge pull request #312 from RobBrazier/dependabot/npm_and_yarn/husky-1.1.1 [`e26fef6`](https://github.com/RobBrazier/svelte-awesome/commit/e26fef63326b3f64dee86ff8547e28803b596704)
- Merge pull request #311 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-replace-2.1.0 [`a0d0f78`](https://github.com/RobBrazier/svelte-awesome/commit/a0d0f78a36a4081f4832d23db7f4665f2f6a4ba9)
- Merge pull request #310 from RobBrazier/dependabot/npm_and_yarn/@commitlint/prompt-cli-7.2.0 [`ada2ce8`](https://github.com/RobBrazier/svelte-awesome/commit/ada2ce8af64eb3f8008f8bdf193158f7e7605bf7)
- Merge pull request #308 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-jsx-a11y-6.1.2 [`0550354`](https://github.com/RobBrazier/svelte-awesome/commit/055035477c073d2cf175826e5f94dc336a3950f6)
- Merge pull request #309 from RobBrazier/dependabot/npm_and_yarn/@commitlint/cli-7.2.0 [`5cda4c6`](https://github.com/RobBrazier/svelte-awesome/commit/5cda4c67f1be89e737c14d7b1be457982f19585c)
- Merge pull request #304 from RobBrazier/dependabot/npm_and_yarn/husky-1.1.0 [`d03e691`](https://github.com/RobBrazier/svelte-awesome/commit/d03e691638569155023984ba18174bde520383f4)
- Merge pull request #303 from RobBrazier/dependabot/npm_and_yarn/eslint-5.6.1 [`10c0a5c`](https://github.com/RobBrazier/svelte-awesome/commit/10c0a5c5300b8d9920e14ff1eb55d58722e9a494)

## [v1.4.1](https://github.com/RobBrazier/svelte-awesome/compare/v1.4.0...v1.4.1) - 2018-09-28

### Merged

- build(example): fix example build [`#302`](https://github.com/RobBrazier/svelte-awesome/pull/302)
- fix: guard when accessing refs onupdate() to prevent TypeError [`#301`](https://github.com/RobBrazier/svelte-awesome/pull/301)
- build(deps-dev): bump rollup from 0.64.1 to 0.66.2 [`#295`](https://github.com/RobBrazier/svelte-awesome/pull/295)
- build(deps-dev): bump husky from 0.14.3 to 1.0.1 [`#300`](https://github.com/RobBrazier/svelte-awesome/pull/300)
- build(deps-dev): bump rollup-plugin-uglify from 4.0.0 to 5.0.2 [`#274`](https://github.com/RobBrazier/svelte-awesome/pull/274)

### Commits

- build: switch eslint-plugin-airbnb to eslint-plugin-airbnb-base [`041e8bf`](https://github.com/RobBrazier/svelte-awesome/commit/041e8bf0afa70ff77675d91159a5c704d9de2a7a)
- build: update husky commit checking config [`c188bd2`](https://github.com/RobBrazier/svelte-awesome/commit/c188bd2f503d393ad03c6d23b2af361b769dcb42)
- docs: remove waffle badge from README [`eacb0f4`](https://github.com/RobBrazier/svelte-awesome/commit/eacb0f4a84597cd1932abe5b6f885714b25787dd)
- Merge pull request #299 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-svelte-4.3.2 [`9efd624`](https://github.com/RobBrazier/svelte-awesome/commit/9efd624141955953fe8c3a575170cd4b3a2bf464)
- Merge pull request #297 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-html-4.0.6 [`5162666`](https://github.com/RobBrazier/svelte-awesome/commit/5162666611ef3bd1173bf07b2ca621594f1bbe8e)
- Merge pull request #296 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-svelte-4.3.1 [`a8c496f`](https://github.com/RobBrazier/svelte-awesome/commit/a8c496fea9fa0998243e4714bee213763737b49e)
- Merge pull request #294 from RobBrazier/dependabot/npm_and_yarn/semantic-release-15.9.16 [`9e22ecf`](https://github.com/RobBrazier/svelte-awesome/commit/9e22ecf8dcc1bb1cfe80a8eddd2e5df03c630ea5)
- Merge pull request #293 from RobBrazier/dependabot/npm_and_yarn/svelte-2.13.5 [`4e316f0`](https://github.com/RobBrazier/svelte-awesome/commit/4e316f022b2dc0b04004c4dede646743cad63994)
- Merge pull request #291 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-commonjs-9.1.8 [`a4a4d05`](https://github.com/RobBrazier/svelte-awesome/commit/a4a4d05d242524c9d3d213eab9cb04ebf92d1a21)
- Merge pull request #290 from RobBrazier/dependabot/npm_and_yarn/eslint-5.6.0 [`461a63c`](https://github.com/RobBrazier/svelte-awesome/commit/461a63ca0a7a383c04728d27e82d7a94d5c66f51)
- Merge pull request #287 from RobBrazier/dependabot/npm_and_yarn/lodash-4.17.11 [`4ad6d92`](https://github.com/RobBrazier/svelte-awesome/commit/4ad6d92989451a7d538de50220382d4f5cc3ebfe)
- Merge pull request #286 from RobBrazier/dependabot/npm_and_yarn/semantic-release-15.9.15 [`dabbff7`](https://github.com/RobBrazier/svelte-awesome/commit/dabbff79db1707e8e1c5651cb8a8e7f9d3c3aef4)
- Merge pull request #285 from RobBrazier/dependabot/npm_and_yarn/semantic-release-15.9.14 [`2213cd5`](https://github.com/RobBrazier/svelte-awesome/commit/2213cd5b03c196ddd263190644e650c93496b32b)
- Merge pull request #284 from RobBrazier/dependabot/npm_and_yarn/svelte-2.13.4 [`0607687`](https://github.com/RobBrazier/svelte-awesome/commit/0607687a68f08f063824c52d2a49e4a6fe6b4a97)
- Merge pull request #283 from RobBrazier/dependabot/npm_and_yarn/svelte-2.13.3 [`aa815a0`](https://github.com/RobBrazier/svelte-awesome/commit/aa815a0de8998485ba51a7f87dc967654ccb10c7)
- Merge pull request #281 from RobBrazier/dependabot/npm_and_yarn/@commitlint/prompt-cli-7.1.2 [`fcc7802`](https://github.com/RobBrazier/svelte-awesome/commit/fcc78024029f7354e5cbc692fbafc907e8734077)
- Merge pull request #280 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-node-resolve-3.4.0 [`7bf1d2b`](https://github.com/RobBrazier/svelte-awesome/commit/7bf1d2b87ab17585e34387279b8c2ef77a80abd6)
- Merge pull request #279 from RobBrazier/dependabot/npm_and_yarn/@commitlint/config-conventional-7.1.2 [`0cec9e2`](https://github.com/RobBrazier/svelte-awesome/commit/0cec9e2e62d9ddfd17f4683b2a5242069ecf363d)
- Merge pull request #278 from RobBrazier/dependabot/npm_and_yarn/@commitlint/cli-7.1.2 [`f93a1a8`](https://github.com/RobBrazier/svelte-awesome/commit/f93a1a8c81150e1615656c2a0a6734083461f1fa)
- Merge pull request #276 from RobBrazier/dependabot/npm_and_yarn/eslint-5.5.0 [`b3033bb`](https://github.com/RobBrazier/svelte-awesome/commit/b3033bb69ef62e5d59f0a0556a2b4e8c0f76b800)
- Merge pull request #275 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-svelte-4.3.0 [`c692e1b`](https://github.com/RobBrazier/svelte-awesome/commit/c692e1ba1c0b178d954bb64bb44cb7d94463a051)
- Merge pull request #273 from RobBrazier/dependabot/npm_and_yarn/@commitlint/cli-7.1.1 [`bb3431c`](https://github.com/RobBrazier/svelte-awesome/commit/bb3431c6c754932ed45f6a0fd5edda9515468e3f)
- Merge pull request #271 from RobBrazier/dependabot/npm_and_yarn/@commitlint/prompt-cli-7.1.1 [`023ec78`](https://github.com/RobBrazier/svelte-awesome/commit/023ec7845d79e70500c8b8775bfb9108d4826993)
- Merge pull request #272 from RobBrazier/dependabot/npm_and_yarn/@commitlint/config-conventional-7.1.1 [`c4be4d8`](https://github.com/RobBrazier/svelte-awesome/commit/c4be4d8f4e665ac973c5b35ce14a71eb095133e9)
- Merge pull request #270 from RobBrazier/dependabot/npm_and_yarn/svelte-2.13.2 [`3a6c5de`](https://github.com/RobBrazier/svelte-awesome/commit/3a6c5de45b464a76a34ca0c14fa6b1a9634df647)
- Merge pull request #269 from RobBrazier/dependabot/npm_and_yarn/semantic-release-15.9.12 [`8cb48c1`](https://github.com/RobBrazier/svelte-awesome/commit/8cb48c16df4a547bd464ff39c1cd5a94aa6c24d3)
- Merge pull request #268 from RobBrazier/dependabot/npm_and_yarn/svelte-2.13.1 [`0f74b3d`](https://github.com/RobBrazier/svelte-awesome/commit/0f74b3d9fb1167b22c63d1e42b297172031b2146)
- Merge pull request #267 from RobBrazier/dependabot/npm_and_yarn/semantic-release-15.9.11 [`5ebbf4b`](https://github.com/RobBrazier/svelte-awesome/commit/5ebbf4b4cbfbdafd36838dca268ab9b130e2a56c)
- Merge pull request #265 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-commonjs-9.1.6 [`c9eb3fa`](https://github.com/RobBrazier/svelte-awesome/commit/c9eb3fa66c4a60c6f14d982eb3ca090bc749235a)
- Merge pull request #264 from RobBrazier/dependabot/npm_and_yarn/svelte-2.12.0 [`d0b6779`](https://github.com/RobBrazier/svelte-awesome/commit/d0b677993aa75ab5dce8fd9a822694c10d55336e)
- Merge pull request #262 from RobBrazier/dependabot/npm_and_yarn/semantic-release-15.9.9 [`a4822dc`](https://github.com/RobBrazier/svelte-awesome/commit/a4822dc16552c8f0a3569442779f01169be769b4)
- Merge pull request #263 from RobBrazier/dependabot/npm_and_yarn/eslint-5.4.0 [`dad8043`](https://github.com/RobBrazier/svelte-awesome/commit/dad8043d3e20b2e091f002029b6202add3bb6e14)
- Merge pull request #261 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-react-7.11.1 [`d634357`](https://github.com/RobBrazier/svelte-awesome/commit/d6343577e2360938ecf70abb4811405c5ee53a0a)
- Merge pull request #260 from RobBrazier/dependabot/npm_and_yarn/svelte-2.11.0 [`aecdc60`](https://github.com/RobBrazier/svelte-awesome/commit/aecdc60a10f11879d0715c8d04741828e430bbce)
- Merge pull request #259 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-react-7.11.0 [`85f5b77`](https://github.com/RobBrazier/svelte-awesome/commit/85f5b7741047b99bd3d240a3cb7c6747a2f4c514)
- Merge pull request #257 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-import-2.14.0 [`69bf5ca`](https://github.com/RobBrazier/svelte-awesome/commit/69bf5caab335fbbde58b12fe16735eb39c867626)
- Merge pull request #256 from RobBrazier/dependabot/npm_and_yarn/semantic-release-15.9.8 [`7d94dc3`](https://github.com/RobBrazier/svelte-awesome/commit/7d94dc300ffe44e924e596ca0f9e25936671acf9)
- Merge pull request #255 from RobBrazier/dependabot/npm_and_yarn/svelte-2.10.1 [`29ec66e`](https://github.com/RobBrazier/svelte-awesome/commit/29ec66e02a72735d2c40352fccd0918fe410d815)
- Merge pull request #254 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-commonjs-9.1.5 [`a3c89e4`](https://github.com/RobBrazier/svelte-awesome/commit/a3c89e4c8a82b4ca9ed3860986f36ef253835b02)
- Merge pull request #253 from RobBrazier/dependabot/npm_and_yarn/semantic-release-15.9.6 [`24b670c`](https://github.com/RobBrazier/svelte-awesome/commit/24b670c044a08e18d639d553ff943fd8fb5b7bfa)
- Merge pull request #252 from RobBrazier/dependabot/npm_and_yarn/svelte-2.9.11 [`8943d4a`](https://github.com/RobBrazier/svelte-awesome/commit/8943d4a82e47325f3a7b7b3b48c0a514574919c5)

## [v1.4.0](https://github.com/RobBrazier/svelte-awesome/compare/v1.3.0...v1.4.0) - 2018-08-08

### Merged

- build(deps-dev): bump rollup from 0.62.0 to 0.63.4 [`#234`](https://github.com/RobBrazier/svelte-awesome/pull/234)
- build(deps-dev): bump svelte from 2.8.1 to 2.9.1 [`#217`](https://github.com/RobBrazier/svelte-awesome/pull/217)
- build(deps-dev): bump eslint-plugin-jsx-a11y from 6.0.3 to 6.1.0 [`#220`](https://github.com/RobBrazier/svelte-awesome/pull/220)
- build(deps-dev): bump semantic-release from 15.6.0 to 15.6.3 [`#218`](https://github.com/RobBrazier/svelte-awesome/pull/218)
- build(deps-dev): bump rollup-plugin-svelte from 4.1.0 to 4.2.1 [`#219`](https://github.com/RobBrazier/svelte-awesome/pull/219)
- build(devDeps): bump eslint from 4.19.1 to 5.0.1 [`#213`](https://github.com/RobBrazier/svelte-awesome/pull/213)
- build(devDeps): bump eslint-config-airbnb from 16.1.0 to 17.0.0 [`#212`](https://github.com/RobBrazier/svelte-awesome/pull/212)
- build(devDeps): bump eslint-plugin-import from 2.12.0 to 2.13.0 [`#210`](https://github.com/RobBrazier/svelte-awesome/pull/210)
- build(devDeps): bump @commitlint/prompt-cli from 6.1.3 to 7.0.0 [`#208`](https://github.com/RobBrazier/svelte-awesome/pull/208)
- build(devDeps): bump @commitlint/config-conventional from 6.1.3 to 7.0.1 [`#207`](https://github.com/RobBrazier/svelte-awesome/pull/207)
- build(devDeps): bump eslint-plugin-react from 7.9.1 to 7.10.0 [`#214`](https://github.com/RobBrazier/svelte-awesome/pull/214)
- build(devDeps): bump rollup from 0.61.2 to 0.62.0 [`#215`](https://github.com/RobBrazier/svelte-awesome/pull/215)

### Fixed

- feat: add svelte property to package.json [`#244`](https://github.com/RobBrazier/svelte-awesome/issues/244)

### Commits

- docs(example): fix example build [`2795c51`](https://github.com/RobBrazier/svelte-awesome/commit/2795c519ed2b267e9c0b5ae67168c3b1ec8bc0a9)
- Merge pull request #247 from RobBrazier/dependabot/npm_and_yarn/svelte-2.9.10 [`5b77ab9`](https://github.com/RobBrazier/svelte-awesome/commit/5b77ab9c678da932fe27eba6f81bcae3e81a4b8c)
- Merge pull request #246 from RobBrazier/dependabot/npm_and_yarn/eslint-5.3.0 [`503b506`](https://github.com/RobBrazier/svelte-awesome/commit/503b5069a46c2d72c9e83403cfa2fe1a25364637)
- Merge pull request #245 from RobBrazier/dependabot/npm_and_yarn/semantic-release-15.9.5 [`cf23942`](https://github.com/RobBrazier/svelte-awesome/commit/cf23942876d5d45781853324c496e390a6fcd984)
- Merge pull request #242 from RobBrazier/dependabot/npm_and_yarn/svelte-2.9.9 [`d400aa8`](https://github.com/RobBrazier/svelte-awesome/commit/d400aa8a7630e47f8128a2097fd4b4a527c354a9)
- Merge pull request #241 from RobBrazier/dependabot/npm_and_yarn/semantic-release-15.9.3 [`c69d106`](https://github.com/RobBrazier/svelte-awesome/commit/c69d106bae4532e93a3a68eba21e0f4e13b35f97)
- Merge pull request #240 from RobBrazier/dependabot/npm_and_yarn/semantic-release-15.9.2 [`e44a690`](https://github.com/RobBrazier/svelte-awesome/commit/e44a69084bec1e03ffc1385c3a8360dba956398f)
- Merge pull request #239 from RobBrazier/dependabot/npm_and_yarn/semantic-release-15.9.1 [`46648a1`](https://github.com/RobBrazier/svelte-awesome/commit/46648a1efc20eb10aea994a4f9a69744610e79ed)
- Merge pull request #238 from RobBrazier/dependabot/npm_and_yarn/rollup-plugin-commonjs-9.1.4 [`ba9a78e`](https://github.com/RobBrazier/svelte-awesome/commit/ba9a78e0b643b80521fbfe7c42a8834438478c3f)
- Merge pull request #237 from RobBrazier/dependabot/npm_and_yarn/svelte-2.9.7 [`c9186fa`](https://github.com/RobBrazier/svelte-awesome/commit/c9186fa9cf1df2dc0dfd1890c9bc02a5a4ec3c09)
- Merge pull request #236 from RobBrazier/dependabot/npm_and_yarn/svelte-2.9.6 [`da0344f`](https://github.com/RobBrazier/svelte-awesome/commit/da0344f37a0d574d7d0aad8cc5f30533d0673676)
- Merge pull request #235 from RobBrazier/dependabot/npm_and_yarn/eslint-5.2.0 [`3df9f2a`](https://github.com/RobBrazier/svelte-awesome/commit/3df9f2afbb586346e96936ce412f27cf39ec59b8)
- Merge pull request #231 from RobBrazier/dependabot/npm_and_yarn/svelte-2.9.5 [`9658498`](https://github.com/RobBrazier/svelte-awesome/commit/9658498ef4616a1a01edf78001fb48c56ee4537b)
- Merge pull request #233 from RobBrazier/dependabot/npm_and_yarn/semantic-release-15.8.1 [`4fb1d73`](https://github.com/RobBrazier/svelte-awesome/commit/4fb1d73473290a03b56403a46d669574ec7eed95)
- Merge pull request #226 from RobBrazier/dependabot/npm_and_yarn/eslint-plugin-jsx-a11y-6.1.1 [`f5b4d0b`](https://github.com/RobBrazier/svelte-awesome/commit/f5b4d0bc9e074276c6a35685a1f356f01a640fd2)
- Merge pull request #222 from RobBrazier/dependabot/npm_and_yarn/eslint-5.1.0 [`f432600`](https://github.com/RobBrazier/svelte-awesome/commit/f43260075dae98f46b14858f8c32b248bf3ea51d)

## [v1.3.0](https://github.com/RobBrazier/svelte-awesome/compare/v1.2.2...v1.3.0) - 2018-06-24

### Merged

- feat: add support for svelte 2 [`#205`](https://github.com/RobBrazier/svelte-awesome/pull/205)
- build(devDeps): bump rollup from 0.57.1 to 0.61.2 [`#202`](https://github.com/RobBrazier/svelte-awesome/pull/202)
- build: bump rollup-plugin-commonjs from 9.1.0 to 9.1.3 [`#183`](https://github.com/RobBrazier/svelte-awesome/pull/183)
- build: bump eslint-plugin-react from 7.7.0 to 7.8.2 [`#193`](https://github.com/RobBrazier/svelte-awesome/pull/193)
- build: bump semantic-release from 15.1.5 to 15.4.1 [`#195`](https://github.com/RobBrazier/svelte-awesome/pull/195)
- build: bump eslint-plugin-import from 2.10.0 to 2.11.0 [`#161`](https://github.com/RobBrazier/svelte-awesome/pull/161)
- build: bump lodash from 4.17.5 to 4.17.10 [`#176`](https://github.com/RobBrazier/svelte-awesome/pull/176)
- build: bump babel-core from 6.26.0 to 6.26.3 [`#181`](https://github.com/RobBrazier/svelte-awesome/pull/181)
- build: bump rollup-plugin-svelte from 4.0.0 to 4.1.0 [`#154`](https://github.com/RobBrazier/svelte-awesome/pull/154)
- build: bump eslint-plugin-html from 4.0.2 to 4.0.3 [`#159`](https://github.com/RobBrazier/svelte-awesome/pull/159)
- build: bump rollup-plugin-node-resolve from 3.0.3 to 3.3.0 [`#144`](https://github.com/RobBrazier/svelte-awesome/pull/144)
- build: bump semantic-release from 12.4.1 to 15.1.5 [`#156`](https://github.com/RobBrazier/svelte-awesome/pull/156)
- build: bump eslint-plugin-import from 2.9.0 to 2.10.0 [`#153`](https://github.com/RobBrazier/svelte-awesome/pull/153)
- build: bump eslint from 4.18.1 to 4.19.1 [`#147`](https://github.com/RobBrazier/svelte-awesome/pull/147)
- build: bump rollup from 0.56.3 to 0.57.1 [`#143`](https://github.com/RobBrazier/svelte-awesome/pull/143)
- build: bump rollup-plugin-commonjs from 8.3.0 to 9.1.0 [`#134`](https://github.com/RobBrazier/svelte-awesome/pull/134)
- build: bump @commitlint/prompt-cli from 6.1.2 to 6.1.3 [`#123`](https://github.com/RobBrazier/svelte-awesome/pull/123)
- build: bump @commitlint/cli from 6.1.2 to 6.1.3 [`#122`](https://github.com/RobBrazier/svelte-awesome/pull/122)
- build: bump @commitlint/config-conventional from 6.1.2 to 6.1.3 [`#120`](https://github.com/RobBrazier/svelte-awesome/pull/120)
- build: bump svelte from 1.55.0 to 1.56.0 [`#119`](https://github.com/RobBrazier/svelte-awesome/pull/119)
- build: bump rollup from 0.56.2 to 0.56.3 [`#118`](https://github.com/RobBrazier/svelte-awesome/pull/118)
- build: bump @commitlint/cli from 6.1.0 to 6.1.2 [`#117`](https://github.com/RobBrazier/svelte-awesome/pull/117)
- build: bump @commitlint/config-conventional from 6.1.0 to 6.1.2 [`#116`](https://github.com/RobBrazier/svelte-awesome/pull/116)
- build: bump @commitlint/prompt-cli from 6.1.0 to 6.1.2 [`#115`](https://github.com/RobBrazier/svelte-awesome/pull/115)
- build: bump eslint-plugin-import from 2.8.0 to 2.9.0 [`#114`](https://github.com/RobBrazier/svelte-awesome/pull/114)
- build: bump eslint-plugin-react from 7.6.1 to 7.7.0 [`#112`](https://github.com/RobBrazier/svelte-awesome/pull/112)
- build: bump eslint from 4.18.0 to 4.18.1 [`#113`](https://github.com/RobBrazier/svelte-awesome/pull/113)
- build: bump rollup from 0.56.1 to 0.56.2 [`#111`](https://github.com/RobBrazier/svelte-awesome/pull/111)
- build: bump eslint from 4.17.0 to 4.18.0 [`#110`](https://github.com/RobBrazier/svelte-awesome/pull/110)
- build: bump rollup from 0.56.0 to 0.56.1 [`#109`](https://github.com/RobBrazier/svelte-awesome/pull/109)
- build: bump rollup-plugin-buble from 0.18.0 to 0.19.2 [`#105`](https://github.com/RobBrazier/svelte-awesome/pull/105)
- build: Bump semantic-release from 11.0.2 to 12.4.1 [`#87`](https://github.com/RobBrazier/svelte-awesome/pull/87)
- build: Bump @commitlint/cli from 5.2.8 to 6.1.0 [`#98`](https://github.com/RobBrazier/svelte-awesome/pull/98)
- build: Bump @commitlint/prompt-cli from 5.2.8 to 6.1.0 [`#101`](https://github.com/RobBrazier/svelte-awesome/pull/101)
- build: bump rollup from 0.53.3 to 0.56.0 [`#107`](https://github.com/RobBrazier/svelte-awesome/pull/107)

## [v1.2.2](https://github.com/RobBrazier/svelte-awesome/compare/v1.2.1...v1.2.2) - 2018-02-15

### Merged

- fix(component): fix Icon not defined when compiling with svelte 1.55 [`#108`](https://github.com/RobBrazier/svelte-awesome/pull/108)
- build: Bump svelte from 1.50.1 to 1.55.0 [`#104`](https://github.com/RobBrazier/svelte-awesome/pull/104)
- build: Bump @commitlint/config-conventional from 5.2.3 to 6.1.0 [`#97`](https://github.com/RobBrazier/svelte-awesome/pull/97)
- build: Bump lodash from 4.17.4 to 4.17.5 [`#96`](https://github.com/RobBrazier/svelte-awesome/pull/96)
- build: Bump eslint from 4.14.0 to 4.17.0 [`#99`](https://github.com/RobBrazier/svelte-awesome/pull/99)
- build: Bump eslint-plugin-html from 4.0.1 to 4.0.2 [`#83`](https://github.com/RobBrazier/svelte-awesome/pull/83)
- chore(dependencies): Bump rollup-plugin-uglify from 2.0.1 to 3.0.0 [`#81`](https://github.com/RobBrazier/svelte-awesome/pull/81)
- chore(dependencies): Bump rollup-plugin-node-resolve from 3.0.0 to 3.0.2 [`#69`](https://github.com/RobBrazier/svelte-awesome/pull/69)
- chore(dependencies): Bump @commitlint/prompt-cli from 5.2.6 to 5.2.8 [`#54`](https://github.com/RobBrazier/svelte-awesome/pull/54)
- chore(dependencies): Bump rollup from 0.53.0 to 0.53.3 [`#60`](https://github.com/RobBrazier/svelte-awesome/pull/60)
- chore(dependencies): Bump svelte from 1.49.1 to 1.50.1 [`#59`](https://github.com/RobBrazier/svelte-awesome/pull/59)
- chore(dependencies): Bump poi from 9.6.4 to 9.6.9 [`#57`](https://github.com/RobBrazier/svelte-awesome/pull/57)
- chore(dependencies): Bump @commitlint/cli from 5.2.6 to 5.2.8 [`#53`](https://github.com/RobBrazier/svelte-awesome/pull/53)

## [v1.2.1](https://github.com/RobBrazier/svelte-awesome/compare/v1.2.0...v1.2.1) - 2017-12-25

### Merged

- build: fix semantic-release condition verification [`#51`](https://github.com/RobBrazier/svelte-awesome/pull/51)
- build: fix semantic-release condition verification [`#50`](https://github.com/RobBrazier/svelte-awesome/pull/50)
- fix(icon): fix computed property scope error from latest svelte version [`#49`](https://github.com/RobBrazier/svelte-awesome/pull/49)
- Bump semantic-release from 8.2.0 to 11.0.2 [`#40`](https://github.com/RobBrazier/svelte-awesome/pull/40)
- chore(dependencies): Bump eslint from 4.13.1 to 4.14.0 [`#48`](https://github.com/RobBrazier/svelte-awesome/pull/48)
- chore(dependencies): Bump @commitlint/cli from 5.2.5 to 5.2.6 [`#44`](https://github.com/RobBrazier/svelte-awesome/pull/44)
- chore(dependencies): Bump poi from 9.6.2 to 9.6.4 [`#47`](https://github.com/RobBrazier/svelte-awesome/pull/47)
- chore(dependencies): Bump rollup from 0.52.3 to 0.53.0 [`#45`](https://github.com/RobBrazier/svelte-awesome/pull/45)
- chore(dependencies): Bump @commitlint/prompt-cli from 5.2.5 to 5.2.6 [`#42`](https://github.com/RobBrazier/svelte-awesome/pull/42)
- Bump poi from 9.6.1 to 9.6.2 [`#41`](https://github.com/RobBrazier/svelte-awesome/pull/41)
- Bump rollup from 0.52.1 to 0.52.3 [`#38`](https://github.com/RobBrazier/svelte-awesome/pull/38)
- Bump rollup-plugin-svelte from 3.3.0 to 4.0.0 [`#34`](https://github.com/RobBrazier/svelte-awesome/pull/34)
- Add svelte to dev dependencies [`#39`](https://github.com/RobBrazier/svelte-awesome/pull/39)
- refactor(eslint): configure and fix code for eslint airbnb prefix [`#37`](https://github.com/RobBrazier/svelte-awesome/pull/37)
- Bump poi from 9.6.0 to 9.6.1 [`#33`](https://github.com/RobBrazier/svelte-awesome/pull/33)
- Bump poi from 9.5.11 to 9.6.0 [`#32`](https://github.com/RobBrazier/svelte-awesome/pull/32)
- Bump poi from 9.5.9 to 9.5.11 [`#31`](https://github.com/RobBrazier/svelte-awesome/pull/31)
- Bump @commitlint/cli from 5.2.3 to 5.2.5 [`#28`](https://github.com/RobBrazier/svelte-awesome/pull/28)
- Bump @commitlint/prompt-cli from 5.2.0 to 5.2.5 [`#30`](https://github.com/RobBrazier/svelte-awesome/pull/30)
- Bump rollup-plugin-svelte from 3.2.0 to 3.3.0 [`#29`](https://github.com/RobBrazier/svelte-awesome/pull/29)
- Bump poi from 9.5.7 to 9.5.9 [`#27`](https://github.com/RobBrazier/svelte-awesome/pull/27)
- Bump @commitlint/cli from 5.2.0 to 5.2.3 [`#22`](https://github.com/RobBrazier/svelte-awesome/pull/22)
- Bump poi from 9.5.6 to 9.5.7 [`#26`](https://github.com/RobBrazier/svelte-awesome/pull/26)
- Bump @commitlint/config-conventional from 5.1.3 to 5.2.3 [`#23`](https://github.com/RobBrazier/svelte-awesome/pull/23)
- Bump poi from 9.5.5 to 9.5.6 [`#24`](https://github.com/RobBrazier/svelte-awesome/pull/24)
- Bump rollup from 0.52.0 to 0.52.1 [`#25`](https://github.com/RobBrazier/svelte-awesome/pull/25)

### Commits

- build(rollup): remove unused rollup-plugin-babel dependency [`02a3307`](https://github.com/RobBrazier/svelte-awesome/commit/02a33073f2df270fc7338a63b53e98f757603e9e)
- build(svelte): add svelte to dev dependencies [`9ca013b`](https://github.com/RobBrazier/svelte-awesome/commit/9ca013b0ee1b2985ef52deb8a7e2fc85d5e50029)

## [v1.2.0](https://github.com/RobBrazier/svelte-awesome/compare/v1.1.1...v1.2.0) - 2017-12-04

### Merged

- feat(css): add css and animations [`#21`](https://github.com/RobBrazier/svelte-awesome/pull/21)

### Commits

- refactor(icon): remove unneeded klass from Icon component [`cd579ec`](https://github.com/RobBrazier/svelte-awesome/commit/cd579ec67ae2486f7f4dd3c396be8d179818b2f6)

## [v1.1.1](https://github.com/RobBrazier/svelte-awesome/compare/v1.1.0...v1.1.1) - 2017-12-04

### Merged

- fix(raw): fix raw icon type [`#19`](https://github.com/RobBrazier/svelte-awesome/pull/19)
- Bump rollup-plugin-svelte from 3.1.0 to 3.2.0 [`#18`](https://github.com/RobBrazier/svelte-awesome/pull/18)
- Bump @commitlint/prompt-cli from 5.1.2 to 5.2.0 [`#16`](https://github.com/RobBrazier/svelte-awesome/pull/16)
- Bump @commitlint/cli from 5.1.1 to 5.2.0 [`#17`](https://github.com/RobBrazier/svelte-awesome/pull/17)
- Bump rollup from 0.51.8 to 0.52.0 [`#15`](https://github.com/RobBrazier/svelte-awesome/pull/15)
- Bump poi from 9.5.4 to 9.5.5 [`#14`](https://github.com/RobBrazier/svelte-awesome/pull/14)

## [v1.1.0](https://github.com/RobBrazier/svelte-awesome/compare/v1.0.3...v1.1.0) - 2017-11-29

### Commits

- feat(icon): dynamically updated icons [`ccda8d6`](https://github.com/RobBrazier/svelte-awesome/commit/ccda8d69c0bcb88a1249cc7eae400a9714f41388)

## [v1.0.3](https://github.com/RobBrazier/svelte-awesome/compare/v1.0.2...v1.0.3) - 2017-11-29

### Commits

- fix(release): redo release [`1430a86`](https://github.com/RobBrazier/svelte-awesome/commit/1430a8609ffc4226ccda589fe9cb4c2239c84aa7)
- fix(release): redo release [`d3f892b`](https://github.com/RobBrazier/svelte-awesome/commit/d3f892b9f4d37c858ccc5072e9e639e9621267ed)

## [v1.0.2](https://github.com/RobBrazier/svelte-awesome/compare/v1.0.1...v1.0.2) - 2017-11-29

### Merged

- fix released artifact [`#13`](https://github.com/RobBrazier/svelte-awesome/pull/13)

### Commits

- fix(release): add dist to released versions [`e71bd39`](https://github.com/RobBrazier/svelte-awesome/commit/e71bd39902d93c114ec6a5620a4c9967a5e6ae94)
- fix(peer): remove svelte as a peer dependency [`687c18b`](https://github.com/RobBrazier/svelte-awesome/commit/687c18bd629dfe843de7268364bc865ad9658493)

## [v1.0.1](https://github.com/RobBrazier/svelte-awesome/compare/v1.0.0...v1.0.1) - 2017-11-29

### Merged

- fix(polygon): fix svg polygon rendering [`#11`](https://github.com/RobBrazier/svelte-awesome/pull/11)
- build(linting): switch to xo for linting [`#10`](https://github.com/RobBrazier/svelte-awesome/pull/10)
- refactor(icons): optimise icon generation [`#9`](https://github.com/RobBrazier/svelte-awesome/pull/9)

## v1.0.0 - 2017-11-29

### Commits

- feat(init): initial semantic commit [`56f999c`](https://github.com/RobBrazier/svelte-awesome/commit/56f999ca2073a3b520f804ed5d6013dc95065f43)
- fix(release): fix verifyConditions [`772d8f7`](https://github.com/RobBrazier/svelte-awesome/commit/772d8f70013d1b0d7e5ea9f9718c768285c22f92)
