<h1 align="center">Welcome to Mubarak! 👋 </h1>

<p align="center">Mubarak is an application that is used to make it easier for Muslims to carry out their daily worship. Built using Framework7. 💖 </p>

<p align="center">
<img src="https://img.shields.io/github/contributors/RizkiKarianata/mubarak?style=flat-square">
<img src="https://img.shields.io/github/issues/RizkiKarianata/mubarak?style=flat-square">
<img src="https://img.shields.io/github/stars/RizkiKarianata/mubarak?style=flat-square"> 
<img src="https://img.shields.io/github/forks/RizkiKarianata/mubarak?style=flat-square">
<img src="https://img.shields.io/github/last-commit/RizkiKarianata/mubarak.svg?style=flat-square">
<img src="https://img.shields.io/github/languages/code-size/RizkiKarianata/mubarak?style=flat-square">
<img src="https://img.shields.io/github/license/RizkiKarianata/mubarak?style=flat-square">
</p>

<p align="center">
<a href="https://karianata.com/mubarak/demo">Demo Page</a>&nbsp;&nbsp;&nbsp;
<a href="https://karianata.com/mubarak/docs">Documentation Page</a>&nbsp;&nbsp;&nbsp;
</p>

## 💾 Requirements

* `Node.js` - used for the entire application development process. Whether it's making an API or something
* `Web Browser` - can be used as an emulator to build applications. Example [Chrome, Firefox, Safari & Opera]
* `Internet` - because many use CDN and to make it easier to find solutions to all problems
* `Composer` - make it easier for developers to manage PHP project dependencies
* `Android SDK` - to simplify the process of building applications
* `Gradle` - function to perform application building automatically
* `Java Development Kit` - used for support in developing or building an application

## 🎯 How To Use

#### Using the built-in ready to use from the release (Recommended)

Download the latest project release from the [Release Page](https://github.com/RizkiKarianata/mubarak "Release Page"). Open the Mubarak project folder using a terminal and type `npm run dev`. To explore the source code you can use a text editor such as Visual Studio Code.

#### Build manually

* Before starting, make sure you have Node.js installed first
* If you have installed Node.js. Run the command git clone which is `https://github.com/RizkiKarianata/mubarak`
* Install the dependencies using the node package manager of your choice. For example run `npm install` in terminal
* To run the application you can run the command `npm run dev`. And the application will automatically open using port 8080 on your default browser

#### Build to APK

* You can run commands like in the `NPM Scripts` below by adding `npm run`. Example `npm run build-dev-cordova-android` on terminal

## 🛠 NPM Scripts

* 🔥 `start` - run development server
* 🔧 `dev` - run development server
* 🔧 `build-dev` - build web app using development mode (faster build without minification and optimization)
* 🔧 `build-prod` - build web app for production
* 📱 `build-dev-cordova` - build cordova app using development mode (faster build without minification and optimization)
* 📱 `build-prod-cordova` - build cordova app
* 📱 `build-dev-cordova-ios` - build cordova iOS app using development mode (faster build without minification and optimization)
* 📱 `build-prod-cordova-ios` - build cordova iOS app
* 📱 `build-dev-cordova-android` - build cordova Android app using development mode (faster build without minification and optimization)
* 📱 `build-prod-cordova-android` - build cordova Android app

## 📋 Documentation & Resources

* [Framework7](https://framework7.io/)
* [Apache Cordova](https://cordova.apache.org/)
* [Node.js](https://nodejs.org/en/)
* Did you build a framework or other features? Open up Pull Requests and put yours here! 😃

## 📆 Release Date

* v1.0.0 : 05 June 2022

## 🧑 Author

* Facebook : <a href="https://www.facebook.com/rizky.slankers.3386"> Rizki Karianata</a>
* Instagram : <a href="https://www.instagram.com/rizkikarianata"> @rizkikarianata</a>
* Youtube : <a href="https://www.youtube.com/channel/UCwhkJwsq6swJrerdP0tixJA"> @rizkikarianata</a>
* LinkedIn :  <a href="https://www.linkedin.com/in/rizkikarianata"> @rizkikarianata</a>

## 🤝 Contributing

<p>I really appreciate contributions, issues and feature requests because this application is far from perfect. Feel free to Pull Request and make changes to this project.</p>
<p>Since this is an open source project I finished it myself. There may be many features or things that could be improved or added. So I really appreciate your help.</p>

#### Steps To Contribute

* Fork it ( https://github.com/RizkiKarianata/mubarak )
* Create your feature branch (`git checkout -b my-new-feature`)
* Commit your changes (`git commit -am 'Add some feature'`)
* Push to the branch (`git push origin my-new-feature`)
* Create a new Pull Request

#### Notes To Contribute

Make sure to not commit generated files from your dist folder. All changes need to be made in the source files located in the `src` folder.

* Change the `scss` files to adapt styles
* Change the nunjucks based `html` files or the content defining `json` files to adapt layout and content
* Change the `js` files to adapt the application code

Always run a build and test the results before committing.

## 📝 License

* Copyright © 2020 Rizki Karianata
* **Mubarak is an open source project licensed under the MIT license**

## ☕️ Suppport & Donation

Love Mubarak? Support this project by donating or sharing with others in need.

<a href="https://www.buymeacoffee.com/rizkikarianata"><img src="https://img.shields.io/badge/Buy_Me_A_Coffee-FFDD00?style=for-the-badge&logo=buy-me-a-coffee&logoColor=black"/> </a>

**Made with ❤️ Rizki Karianata**