# Prompt Resources

Welcome to **Prompt Resources**, a comprehensive repository designed to help you master the art of prompt engineering. Whether you're just getting started or looking to refine advanced concepts, this resource is aimed at enhancing your skills in crafting effective, detailed, and versatile prompts for various use cases.

### Purpose

This repository is a collection of key concepts and principles related to prompt engineering, along with practical examples that you can directly apply. It includes techniques for tailoring prompts to specific audiences, improving clarity, managing complex tasks, and creating bias-free outputs.

### How to Use

- To explore advanced concepts, visit the [Basic Learn.md](https://github.com/Riddhish97/PromptResources/blob/main/Prompt%20Eng%20advanced%20examples/Basic%20guide.md) file. This file contains foundational principles and progressively builds towards more advanced techniques.
- The examples provided below showcase 20 essential prompt principles, each with a corresponding sample prompt to help you practice and refine your skills.

# Overview of Key Prompt Principles

| #   | Prompt Principle                                                 | Example Prompt                                                                                                                                                              |
| --- | ---------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| 1   | Tailor prompts to a specific audience.                           | Create a simple guide on using social media for teenagers.                                                                                                                  |
| 2   | Use positive directives for clarity.                             | Describe how engineers ensure the safety of bridges.                                                                                                                        |
| 3   | Break down tasks into simple steps.                              | P1: List the planets in our solar system. P2: Describe the characteristics of Earth.                                                                                        |
| 4   | Ensure unbiased and stereotype-free responses.                   | Discuss the role of gender in leadership. Ensure that your answer is unbiased and avoids relying on stereotypes.                                                            |
| 5   | Ask for explanations tailored to different understanding levels. | Explain climate change as if I’m a high school student.                                                                                                                     |
| 6   | Use imperative phrases for clearer instructions.                 | Your task is to summarize the importance of biodiversity. You MUST highlight key species.                                                                                   |
| 7   | Use examples to guide responses.                                 | Example 1: Convert 0°C to Fahrenheit (Response: 32°F). Example 2: Convert 100°C (Response: 212°F).                                                                          |
| 8   | Encourage detailed questions for clarification.                  | From now on, ask me questions to fully understand my goals for a business plan.                                                                                             |
| 9   | Teach and assess understanding.                                  | Teach me about the Pythagorean theorem and include a test at the end, but don’t give me the answers yet.                                                                    |
| 10  | Incorporate step-by-step thinking.                               | Write a function to calculate the factorial of a number. Let’s think step by step.                                                                                          |
| 11  | Use output primers to guide expectations.                        | Explain the concept of gravity. Explanation:                                                                                                                                |
| 12  | Request detailed content comprehensively.                        | Write a detailed article about renewable energy technologies, including all necessary information.                                                                          |
| 13  | Initiate creative tasks with prompts.                            | I’m providing the beginning of a detective story: "The clock struck midnight when the lights went out." Finish it based on the provided words.                              |
| 14  | State specific requirements for outputs.                         | Create a grocery list for a picnic, including keywords "sandwiches," "drinks," and "fruit."                                                                                 |
| 15  | Assign specific roles to enhance context.                        | As a historian, how would you describe the impact of the Industrial Revolution?                                                                                             |
| 16  | Handle complex code prompts across files.                        | Generate a web application with multiple files. Create a JavaScript file that can be run to generate the necessary HTML and CSS.                                            |
| 17  | Revise for clarity while maintaining style.                      | Please revise this paragraph for clarity: "Solar power is important because it helps."                                                                                      |
| 18  | Combine reasoning with examples.                                 | Example 1: "Multiply 5 by 3. First, take 5 and multiply it by 3. The result is 15." Main Question: "Multiply 7 by 4. First, take 7 and multiply it by 4. The result is...?" |
| 19  | Use delimiters for clarity in prompts.                           | Write an analysis discussing 'sustainable agriculture' in detail.                                                                                                           |
| 20  | Skip pleasantries for concise responses.                         | Explain the process of photosynthesis.                                                                                                                                      |
