<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>500 - Server Error</title>
    <style>
        * {
            box-sizing: border-box;
        }

        body {
            font-family: 'Roboto', sans-serif;
            background-color: #222;
            color: #fff;
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }

        .container {
            max-width: 400px;
            width: 90%;
            text-align: center;
            padding: 40px;
            background-color: #333;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
            border-radius: 4px;
            opacity: 0;
            animation: fade-in 1s forwards;
        }

        @keyframes fade-in {
            0% {
                opacity: 0;
                transform: translateY(-20px);
            }

            100% {
                opacity: 1;
                transform: translateY(0);
            }
        }

        h1 {
            font-size: 72px;
            font-weight: 700;
            color: transparent;
            background-image: linear-gradient(to right, #e91e63, #8c14fc);
            -webkit-background-clip: text;
            background-clip: text;
            -webkit-text-fill-color: transparent;
            margin: 0;
        }

        h2 {
            font-size: 24px;
            font-weight: 400;
            color: #fff;
            margin-top: 10px;
        }

        p {
            font-size: 16px;
            color: #ccc;
            margin-top: 20px;
        }

        a {
            display: inline-block;
            font-size: 16px;
            color: #e91e63;
            text-decoration: none;
            margin-top: 20px;
            border-bottom: 1px solid #e91e63;
            padding-bottom: 2px;
            transition: border-bottom 0.2s;
        }

        a:hover {
            border-bottom-color: #c2185b;
        }

        @media (max-width: 480px) {
            h1 {
                font-size: 48px;
            }

            h2 {
                font-size: 20px;
            }

            p {
                font-size: 14px;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <h1>500</h1>
        <h2>Internal Server Error</h2>
        <p>Sorry, something went wrong on our end.</p>
        <a href="<?php echo $_SERVER['REQUEST_URI']; ?>">try again</a>
    </div>
</body>

</html>