<p align="center">
  <img src="https://raw.githubusercontent.com/ReactMVC/API-Monster/main/public/logo.jpg" alt="Logo" width="388" height="500">
</p>
<div align="center">
 
# API Monster
API-Monster is a high-performance PHP framework designed specifically for building APIs. It provides a fast, secure, and easy-to-use environment for developing robust API applications. With API-Monster, you can take advantage of its powerful routing system inspired by Laravel, along with essential components such as a MySQL class, an HTTP class, and a Cipher class for encoding and decoding data.

</div>

## Features

- **Fast**: API-Monster is built with performance in mind, allowing you to develop high-speed APIs.
- **Secure**: Security is a top priority, and API-Monster includes features to ensure the safety of your API applications.
- **Easy**: API-Monster follows an intuitive and straightforward syntax, making it easy for developers to get started quickly.
- **Routing**: Take advantage of the robust routing system similar to Laravel, allowing you to define API endpoints and handle HTTP requests efficiently.
- **MySQL Class**: API-Monster provides a MySQL class that simplifies database interactions, making it easier to work with MySQL databases.
- **HTTP Class**: The HTTP class in API-Monster offers convenient methods for sending HTTP requests and handling responses.
- **Cipher Class**: The Cipher class allows you to encode and decode data, adding an extra layer of security to your API.
- **Controllers**: API-Monster supports the use of controllers, enabling you to organize your API logic into separate classes for better code structure and maintainability.
- **Object-Oriented Programming (OOP) Syntax**: API-Monster follows modern PHP conventions and utilizes OOP syntax, promoting clean and reusable code.

## Getting Started

To get started with API-Monster, you can use Composer to create a new project. Simply run the following command:

```
composer create-project darkphp/apimonster myapp
```

# API Monster Documentation

Welcome to the API-Monster documentation! Here you will find detailed information on how to use and extend the API-Monster PHP framework for building powerful APIs. 

You can access the full documentation at [https://github.com/ReactMVC/API-Monster/wiki](https://github.com/ReactMVC/API-Monster/wiki).

## Developer

API-Monster is developed by Hossein Pira. For any inquiries or support, you can reach out to the developer via the following channels:

- Email: h3dev.pira@gmail.com, hosseinpiradev@gmail.com
- Telegram: [@h3dev](https://t.me/h3dev)
