--------------------------------------------------------
--  File created - Sunday-February-17-2019   
--------------------------------------------------------
--------------------------------------------------------
--  DDL for Table CUSTOMER
--------------------------------------------------------

  CREATE TABLE "SYSTEM"."CUSTOMER" 
   (	"CUSTOMER_ID" NUMBER(10,0), 
	"FIRST_NAME" VARCHAR2(45 BYTE) DEFAULT NULL, 
	"LAST_NAME" VARCHAR2(45 BYTE) DEFAULT NULL, 
	"USER_NAME" VARCHAR2(45 BYTE), 
	"PASS" VARCHAR2(45 BYTE), 
	"EMAIL_ADDRESS" VARCHAR2(45 BYTE), 
	"PHONE_NUMBER" VARCHAR2(45 BYTE) DEFAULT NULL, 
	"ACTIVE" NUMBER(1,0) DEFAULT 0
   ) PCTFREE 10 PCTUSED 40 INITRANS 1 MAXTRANS 255 NOCOMPRESS LOGGING
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
REM INSERTING into SYSTEM.CUSTOMER
SET DEFINE OFF;
Insert into SYSTEM.CUSTOMER (CUSTOMER_ID,FIRST_NAME,LAST_NAME,USER_NAME,PASS,EMAIL_ADDRESS,PHONE_NUMBER,ACTIVE) values (1,'ravi','teja','raviteja','raviteja','raviteja@gmail.com','9705562280',0);
Insert into SYSTEM.CUSTOMER (CUSTOMER_ID,FIRST_NAME,LAST_NAME,USER_NAME,PASS,EMAIL_ADDRESS,PHONE_NUMBER,ACTIVE) values (4,'Jagadeesh','B','jagadeesh','jagadeesh','belagallujagadeesh@gmail.com','8074554870',0);
Insert into SYSTEM.CUSTOMER (CUSTOMER_ID,FIRST_NAME,LAST_NAME,USER_NAME,PASS,EMAIL_ADDRESS,PHONE_NUMBER,ACTIVE) values (601,'ravi','B','rtbollimuntha','teja','rtbollimuntha@gmail.com','9515647511',0);
Insert into SYSTEM.CUSTOMER (CUSTOMER_ID,FIRST_NAME,LAST_NAME,USER_NAME,PASS,EMAIL_ADDRESS,PHONE_NUMBER,ACTIVE) values (602,'sai','D','sai','sai','sai@gmail.com','9515647511',0);
Insert into SYSTEM.CUSTOMER (CUSTOMER_ID,FIRST_NAME,LAST_NAME,USER_NAME,PASS,EMAIL_ADDRESS,PHONE_NUMBER,ACTIVE) values (604,'ram','teja','ram','ram','ram@gmail.com','9515647511',0);
--------------------------------------------------------
--  DDL for Index SYS_C007022
--------------------------------------------------------

  CREATE UNIQUE INDEX "SYSTEM"."SYS_C007022" ON "SYSTEM"."CUSTOMER" ("CUSTOMER_ID") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  DDL for Index CUST_UNIQUE
--------------------------------------------------------

  CREATE UNIQUE INDEX "SYSTEM"."CUST_UNIQUE" ON "SYSTEM"."CUSTOMER" ("EMAIL_ADDRESS", "PHONE_NUMBER", "USER_NAME") 
  PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM" ;
--------------------------------------------------------
--  Constraints for Table CUSTOMER
--------------------------------------------------------

  ALTER TABLE "SYSTEM"."CUSTOMER" ADD CONSTRAINT "CUST_UNIQUE" UNIQUE ("EMAIL_ADDRESS", "PHONE_NUMBER", "USER_NAME")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM"  ENABLE;
  ALTER TABLE "SYSTEM"."CUSTOMER" MODIFY ("CUSTOMER_ID" NOT NULL ENABLE);
  ALTER TABLE "SYSTEM"."CUSTOMER" MODIFY ("USER_NAME" NOT NULL ENABLE);
  ALTER TABLE "SYSTEM"."CUSTOMER" MODIFY ("PASS" NOT NULL ENABLE);
  ALTER TABLE "SYSTEM"."CUSTOMER" MODIFY ("EMAIL_ADDRESS" NOT NULL ENABLE);
  ALTER TABLE "SYSTEM"."CUSTOMER" MODIFY ("ACTIVE" NOT NULL ENABLE);
  ALTER TABLE "SYSTEM"."CUSTOMER" ADD PRIMARY KEY ("CUSTOMER_ID")
  USING INDEX PCTFREE 10 INITRANS 2 MAXTRANS 255 COMPUTE STATISTICS 
  STORAGE(INITIAL 65536 NEXT 1048576 MINEXTENTS 1 MAXEXTENTS 2147483645
  PCTINCREASE 0 FREELISTS 1 FREELIST GROUPS 1 BUFFER_POOL DEFAULT FLASH_CACHE DEFAULT CELL_FLASH_CACHE DEFAULT)
  TABLESPACE "SYSTEM"  ENABLE;
