# Pull Request

## Description
**Provide a summary of the changes made in this pull request:**
- What does this PR do?
- Why are these changes necessary?

## Related Issues
**If this pull request is linked to an existing issue, please reference it here (e.g., `#123`):**

## Changes Made
**List all significant changes in this pull request:**
1. Describe what was added, modified, or removed.
2. Highlight the files affected.
   - Example:
     - Added `error_handling.c` to improve server stability.
     - Updated `README.md` to include new compilation steps.

## Testing
**Explain how you tested your changes:**
- Steps:
  - [ ] Compiled successfully using `gcc` or `MinGW`.
  - [ ] Tested file transfer functionality between server and client.
  - [ ] Verified compatibility across different OS (e.g., Windows, Linux).
- Include logs, screenshots, or other evidence to support your tests.

## Checklist
Before submitting this pull request, ensure the following are true:
- [ ] My code adheres to the coding standards for this project.
- [ ] I have tested my changes thoroughly and included necessary tests.
- [ ] I have updated documentation (if required).
- [ ] This pull request is ready for review.

**Thank you for contributing to the File Transfer Application in C (TCP) project!**
