# Security Policy

## Supported Versions
We encourage users to upgrade to the latest stable version to benefit from the latest security patches.

## Reporting a Vulnerability

If you discover a security vulnerability, we ask that you responsibly disclose it by following these steps:

1. **Do not disclose the vulnerability publicly**.
   - Publicly disclosing security issues can make the issue more widely known, potentially putting users at risk.
   - Please do not open an issue, pull request, or discussion in this repository to report security vulnerabilities.

2. **Report the vulnerability privately** by emailing us at:
   - **rares.racsan@gmail.com**
   
   If you do not have a direct contact email for the maintainers, feel free to use the [GitHub security advisories feature](https://docs.github.com/en/github/managing-security-vulnerabilities/adding-a-security-advisory) to create a security advisory.

3. **Provide detailed information**:
   - A clear description of the vulnerability
   - Steps to reproduce the vulnerability
   - Any proof-of-concept code or payloads (if applicable)
   - Affected version(s)
   - Any potential impact or severity assessment
   - Suggested mitigations or fixes, if available

## What Happens After Reporting?

Once the security issue is reported, we will follow these steps:

1. **Acknowledgment**: We will acknowledge your report within [72 hours].
2. **Investigation**: Our security team will investigate the issue to assess its severity and impact.
3. **Fix Development**: If the issue is confirmed, we will develop a patch or mitigation for it.
4. **Disclose the Issue**: Once the fix is developed and tested, we will publish a security advisory to disclose the vulnerability, along with instructions for users to upgrade or mitigate the issue.
5. **Credit**: If you wish, we will credit you as the reporter of the issue in our release notes or security advisory.

## Security Updates

We regularly release security patches for supported versions. If you are using an unsupported version, we strongly recommend upgrading to a supported version to ensure you receive the latest security updates.

## Scope

This policy applies to:
- **TextEditor** application and its components
- **TextEditor** repository and associated tools
- Issues related to data security, privacy, and system integrity

## Thank You!

We appreciate your help in keeping **PlainTextEditor** safe and secure. Responsible disclosure of vulnerabilities helps ensure that we can protect our users and prevent potential damage from malicious exploitation.
