# Future Features for PlainTextEditor

This document outlines the potential features planned for future versions of PlainTextEditor. These features aim to enhance the editor's functionality and provide users with a more robust and efficient text editing experience.

## Feature Ideas - 5/7

### 1. ~~Line Numbers~~ :heavy_check_mark:
- Display line numbers alongside the text editor for easier navigation and reference.
- **Benefits**: 
  - Improves readability for developers.
  - Makes debugging and editing large files simpler.

---

### 2. ~~Search and Replace~~ :heavy_check_mark:
- Add functionality to search for specific text within the editor, with an option to replace it.
- **Benefits**: 
  - Speeds up the process of modifying repetitive text.
  - Enables efficient text manipulation.

---

### 3. ~~Bookmarks~~ :heavy_check_mark:
- Allow users to bookmark specific lines for quick navigation within a document.
- **Features**: 
  - Toggle bookmarks on/off for selected lines.
  - Provide a sidebar or dropdown list of active bookmarks.
- **Benefits**: 
  - Makes managing large files more user-friendly.
  - Saves time when revisiting important sections of text.

---

### 4. ~~Bracket Matching~~ :heavy_check_mark:
- Highlight matching pairs of brackets (`{}`, `[]`, `()`), especially useful in C++ editor mode.
- **Benefits**: 
  - Reduces syntax errors.
  - Helps users understand code structure better.

---

### 5. ~~Customizable Colors~~ :heavy_check_mark:
- Extend the existing light/dark theme functionality to allow users to fully customize colors.

---

### 6. Integrated Compiler for C++ Editor
- Add an integrated compiler and debugger for C++ code written in the editor.
- **Features**: 
  - Compile and run code directly from the editor.
  - Display output/error messages in a separate panel.
- **Benefits**: 
  - Transforms PlainTextEditor into a lightweight IDE for C++ programming.
  - Streamlines the workflow for developers.

---

### 7. Text-to-Speech
- Enable text-to-speech functionality to read out the text in the editor.
- **Features**: 
  - Option to read selected text or the entire document.
  - Control over speech rate, volume, and voice.
- **Benefits**: 
  - Improves accessibility for visually impaired users.
  - Enhances usability for proofreading and reviewing text.

---

## Contributing
Have an idea for a new feature? Feel free to submit suggestions or contribute to the implementation by opening an issue or pull request!
