# Contributing to PlainTextEditor

First off, thank you for considering contributing to **PlainTextEditor**! 🎉

We welcome contributions from the community. Whether you're fixing a bug, adding a new feature, or improving the documentation, your help is greatly appreciated.

Please take a moment to review the following guidelines to ensure a smooth contribution process.

## How to Contribute

### 1. **Fork the Repository**
   - Fork the repository by clicking on the "Fork" button at the top right of the repository page.
   - This will create a personal copy of the repository under your GitHub account.

### 2. **Clone Your Fork**
   - Clone the forked repository to your local machine:
     ```bash
     git clone https://github.com/RaresRacsan/PlainTextEditor.git
     cd PlainTextEditor
     ```

### 3. **Create a Branch**
   - Create a new branch for your feature or bug fix:
     ```bash
     git checkout -b feature/your-feature-name
     ```
   - Try to name your branches descriptively based on what you're working on (e.g., `feature/add-dark-theme`, `bugfix/fix-save-button`).

### 4. **Make Changes**
   - Implement the changes you'd like to make.
   - Be sure to write clear, concise commit messages that describe the change you've made.
   - If you're adding a new feature, ensure that it is well-documented and tested.

### 5. **Test Your Changes**
   - Make sure the application works properly after your changes.
   - Run the app locally in Visual Studio, checking that the feature or fix works as expected.

### 6. **Commit Your Changes**
   - Once you're satisfied with your changes, commit them:
     ```bash
     git add .
     git commit -m "Your detailed commit message"
     ```
   - Try to follow this format for your commit messages:
     - For new features: `feature: Add [feature name]`
     - For bug fixes: `bugfix: Fix [issue description]`
     - For documentation: `docs: Update README.md for [specific change]`

### 7. **Push to Your Fork**
   - Push your changes to your forked repository:
     ```bash
     git push origin feature/your-feature-name
     ```

### 8. **Submit a Pull Request**
   - Go to the original repository on GitHub and click on "Pull Requests."
   - Click "New Pull Request" and select your branch to merge.
   - Provide a clear description of the changes you made and why you think they should be merged.
   - Our team will review your pull request, and we may ask for changes before merging it.

## Code of Conduct

We follow the [Contributor Covenant Code of Conduct](https://www.contributor-covenant.org/). By contributing, you agree to be respectful and constructive. Harassment, discrimination, or any other harmful behavior will not be tolerated.

## Reporting Bugs

If you've found a bug in the project, please open an issue by following these steps:

1. Go to the [Issues](https://github.com/RaresRacsan/PlainTextEditor/issues) page of the repository.
2. Click "New Issue" and describe the bug in detail. Include steps to reproduce the issue, expected behavior, and actual behavior.
3. If possible, provide any relevant screenshots or error messages that could help in fixing the bug.

## Suggestions and Features

If you have an idea for a new feature or improvement, feel free to open an issue or submit a pull request! We love suggestions that enhance the app or make it more user-friendly.

## Documentation

We strive to maintain good documentation for the project, but feel free to update or improve it when necessary. This includes improving the `README.md` file or adding comments to the code.

## License

By contributing, you agree that your contributions will be licensed under the [MIT License](LICENSE).

---

Thank you for contributing to **PlainTextEditor**! Your contributions help make the project better for everyone. 🚀
