﻿
function uploadFiles(event) {

    var input = document.getElementById('files');
    var files = input.files;
    var formData = new FormData();

    for (var i = 0; i < files.length; i++) {
        formData.append("file", files[i]);
    }

    enviarDados(formData);
}

function initializeDragAndDropArea() {

    if (typeof (window["FileReader"]) == "undefined") {
        return;
    }

    var dragAndDropArea = $("#dragAndDropArea");

    if (dragAndDropArea.length == 0) {
        return;
    }

    dragAndDropArea[0].ondragover = function () {
        dragAndDropArea.addClass("drag-and-drop-area-dragging");
        return false;
    };

    dragAndDropArea[0].ondragleave = function () {
        dragAndDropArea.removeClass("drag-and-drop-area-dragging");
        return false;
    };

    dragAndDropArea[0].ondrop = function (event) {
        dragAndDropArea.removeClass("drag-and-drop-area-dragging");

        var formData = new FormData();

        for (var i = 0; i != event.dataTransfer.files.length; i++) {
            formData.append("file", event.dataTransfer.files[i]);
        }

        enviarDados(formData);

        return false;
    }
}

function enviarDados(formData) {

    $.ajax({
        type: "POST",
        url: "/",
        contentType: false, // Not to set any content header
        processData: false, // Not to process data
        data: formData,
        success: function (result) {

            setTimeout(habilitarProgressBar, 200);
        },
        error: function (error) {

            alert(error.fail);
        }
    });
}

function habilitarProgressBar() {

    var element = document.getElementById("myprogressBar");
    element.style.display = "block";

    var width = 1;
    var identity = setInterval(scene, 20);

    function scene() {
        if (width >= 100) {
            clearInterval(identity);
            element.style.display = "none";
            location.reload();
        }

        else {
            width++;
            element.style.width = width + '%';
            element.innerHTML = width * 1 + '%';
        }
    }
}

$(document).ready(
    function () {
        initializeDragAndDropArea();
    }
);