﻿using System.Collections.Generic;
using System.IO;

namespace ProjetoUploadDownload.Models
{
    public class UploadFileResult
    {
        public int Id { get; set; }
        public string Nome { get; set; }
        public long Tamanho { get; set; }
        public string Tipo { get; set; }
        public string Caminho { get; set; }

        public List<UploadFileResult> ListarArquivos(string path)
        {
            List<UploadFileResult> listaArquivos = new List<UploadFileResult>();
            DirectoryInfo dirInfo = new DirectoryInfo(path);

            int i = 0;
            foreach (var item in dirInfo.GetFiles())
            {
                listaArquivos.Add(new UploadFileResult()
                {
                    Id = i + 1,
                    Nome = item.Name,
                    Caminho = dirInfo.FullName + @"\" + item.Name
                });
                i++;
            }

            return listaArquivos;
        }
    }
}
