﻿using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using MimeTypes;
using ProjetoUploadDownload.Models;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading.Tasks;

namespace ProjetoUploadDownload.Controllers
{
    public class HomeController : Controller
    {
        UploadFileResult uploadFileResult = new UploadFileResult();
        private IHostingEnvironment Environment;

        public HomeController(IHostingEnvironment _environment)
        {
            Environment = _environment;
        }

        public IActionResult Index()
        {
            string path = Path.Combine(this.Environment.WebRootPath, "UploadedFiles/");
            var files = uploadFileResult.ListarArquivos(path);

            return View(files);
        }

        public async Task<bool> UploadFile(IFormFile file)
        {
            try
            {
                bool isCopied = false;

                if (file.Length > 0)
                {
                    string fileName = file.FileName;
                    string extension = Path.GetExtension(fileName);

                    if (extension != "")
                    {
                        // Setar o caminho onde o arquivo será copiado
                        string filePath = Path.Combine(this.Environment.WebRootPath, "UploadedFiles/");

                        // Copia o arquivo para o caminho
                        using (var fileStream = new FileStream(
                            Path.Combine(filePath, fileName),
                                           FileMode.Create))
                        {
                            await file.CopyToAsync(fileStream);
                            isCopied = true;
                        }
                    }
                    else
                    {
                        throw new Exception("A extensão do arquivo é inválida.");
                    }
                }

                return isCopied;
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        [HttpPost]
        public async Task<IActionResult> IndexAsync(IFormFile file)
        {
            string msg = "";
            try
            {
                var lista = new List<UploadFileResult>();
                bool uploadSucesso = await UploadFile(file);

                if (uploadSucesso)
                {
                    lista.Add(new UploadFileResult()
                    {
                        Nome = file.FileName,
                        Tamanho = file.Length,
                        Tipo = file.ContentType
                    });
                }
                msg = "Arquivo: " + file.FileName + ", enviado com sucesso.";
                ViewBag.Mensagem = msg;
            }
            catch (Exception ex)
            {
                ViewBag.Mensagem = "Erro: " + ex.Message;
            }

            //Pega os arquivos da lista e atualiza na tela novamente quando o Upload for feito.
            string path = Path.Combine(this.Environment.WebRootPath, "UploadedFiles/");
            var arquivos = uploadFileResult.ListarArquivos(path);

            return View(arquivos);
        }

        public FileResult Download(string id)
        {
            string contentType = "";
            int arquivoID = Convert.ToInt32(id);
            string path = Path.Combine(this.Environment.WebRootPath, "UploadedFiles/");
            var arquivos = uploadFileResult.ListarArquivos(path);

            string fileName = (from arq in arquivos
                               where arq.Id == arquivoID
                               select arq.Nome).First();

            string extensao = Path.GetExtension(fileName);

            contentType = MimeTypeMap.GetMimeType(extensao);

            /*a variável "contentType" possui o tipo MIME do arquivo, por exemplo,
             se o arquivo for .pdf o seu contentType será -> "application/pdf" e assim por diante.
            
             Essa classe MimeTypeMap vem de um pacote NuGet chamado MimeTypeMapOfficial
             em que possui uma lista de todos os possíveis tipos MIME's de arquivos.
             */

            string pathFile = Path.Combine(this.Environment.WebRootPath, "UploadedFiles/") + fileName;

            /*Aqui, como exemplo, estou manipulando o arquivo txt */
            if (extensao == ".txt")
            {
                StreamWriter sw;
                sw = System.IO.File.CreateText(pathFile);
                sw.WriteLine("*** Voltei do back-end *** ");
                sw.WriteLine("Goodbye World.");
                sw.Close();
            }

            byte[] bytes = System.IO.File.ReadAllBytes(pathFile);

            return File(bytes, contentType, fileName);
        }
    }
}
