
function VarArrayToStr(const vArray: variant): string;

    function _VarToStr(const V: variant): string;
    var
    Vt: integer;
    begin
    Vt := VarType(V);
        case Vt of
          varSmallint,
          varInteger: Result := IntToStr(integer(V));
          varSingle,
          varDouble,
          varCurrency: Result := FloatToStr(Double(V));
          varDate: Result := VarToStr(V);
          varOleStr: Result := WideString(V);
          varBoolean: Result := VarToStr(V);
          varVariant: Result := VarToStr(Variant(V));
          varByte: Result := char(byte(V));
          varString: Result := String(V);
          varArray: Result := VarArrayToStr(Variant(V));
        end;
    end;

var
i: integer;
begin
    Result := '[';
     if (VarType(vArray) and VarArray)=0 then
       Result := _VarToStr(vArray)
    else
    for i := VarArrayLowBound(vArray, 1) to VarArrayHighBound(vArray, 1) do
     if i=VarArrayLowBound(vArray, 1)  then
      Result := Result+_VarToStr(vArray[i])
     else
      Result := Result+'|'+_VarToStr(vArray[i]);

    Result:=Result+']';
end;

function VarStrNull(const V:OleVariant):string; //avoid problems with null variants
begin
  Result:='';
  if not VarIsNull(V) then
  begin
    if VarIsArray(V) then
       Result:=VarArrayToStr(V)
    else
    Result:=VarToStr(V);
  end;
end;

